# Prompt tuning

[Prompt tuning](https://hf.co/papers/2104.08691) adds task-specific prompts to the input, and these prompt parameters are updated independently of the pretrained model parameters which are frozen.

The abstract from the paper is:

*In this work, we explore "prompt tuning", a simple yet effective mechanism for learning "soft prompts" to condition frozen language models to perform specific downstream tasks. Unlike the discrete text prompts used by GPT-3, soft prompts are learned through backpropagation and can be tuned to incorporate signal from any number of labeled examples. Our end-to-end learned approach outperforms GPT-3's "few-shot" learning by a large margin. More remarkably, through ablations on model size using T5, we show that prompt tuning becomes more competitive with scale: as models exceed billions of parameters, our method "closes the gap" and matches the strong performance of model tuning (where all model weights are tuned). This finding is especially relevant in that large models are costly to share and serve, and the ability to reuse one frozen model for multiple downstream tasks can ease this burden. Our method can be seen as a simplification of the recently proposed "prefix tuning" of Li and Liang (2021), and we provide a comparison to this and other similar approaches. Finally, we show that conditioning a frozen model with soft prompts confers benefits in robustness to domain transfer, as compared to full model tuning*.

## PromptTuningConfig[[peft.PromptTuningConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PromptTuningConfig</name><anchor>peft.PromptTuningConfig</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/prompt_tuning/config.py#L30</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "num_virtual_tokens", "val": ": int = None"}, {"name": "token_dim", "val": ": int = None"}, {"name": "num_transformer_submodules", "val": ": Optional[int] = None"}, {"name": "num_attention_heads", "val": ": Optional[int] = None"}, {"name": "num_layers", "val": ": Optional[int] = None"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}, {"name": "prompt_tuning_init", "val": ": typing.Union[peft.tuners.prompt_tuning.config.PromptTuningInit, str] = <PromptTuningInit.RANDOM: 'RANDOM'>"}, {"name": "prompt_tuning_init_text", "val": ": typing.Optional[str] = None"}, {"name": "tokenizer_name_or_path", "val": ": typing.Optional[str] = None"}, {"name": "tokenizer_kwargs", "val": ": typing.Optional[dict] = None"}]</parameters><paramsdesc>- **prompt_tuning_init** (Union[`PromptTuningInit`, `str`]) --
  The initialization of the prompt embedding. `TEXT` will initialize with your text. `SAMPLE_VOCAB` will
  initialize with randomly sampled tokens from the model's vocabulary. `RANDOM` will initialize with randomly
  sampled continuous, soft tokens (warning: sampled soft tokens may fall outside of embedding manifold)
- **prompt_tuning_init_text** (`str`, *optional*) --
  The text to initialize the prompt embedding. Only used if `prompt_tuning_init` is `TEXT`.
- **tokenizer_name_or_path** (`str`, *optional*) --
  The name or path of the tokenizer. Only used if `prompt_tuning_init` is `TEXT`.
- **tokenizer_kwargs** (`dict`, *optional*) --
  The keyword arguments to pass to `AutoTokenizer.from_pretrained`. Only used if `prompt_tuning_init` is
  `TEXT`.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the configuration class to store the configuration of a [PromptEmbedding](/docs/peft/main/en/package_reference/prompt_tuning#peft.PromptEmbedding).




</div>

## PromptEmbedding[[peft.PromptEmbedding]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.PromptEmbedding</name><anchor>peft.PromptEmbedding</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/prompt_tuning/model.py#L24</source><parameters>[{"name": "config", "val": ""}, {"name": "word_embeddings", "val": ""}]</parameters><paramsdesc>- **config** ([PromptTuningConfig](/docs/peft/main/en/package_reference/prompt_tuning#peft.PromptTuningConfig)) -- The configuration of the prompt embedding.
- **word_embeddings** (`torch.nn.Module`) -- The word embeddings of the base transformer model.</paramsdesc><paramgroups>0</paramgroups></docstring>

The model to encode virtual tokens into prompt embeddings.



**Attributes**:
- **embedding** (`torch.nn.Embedding`) -- The embedding layer of the prompt embedding.

<ExampleCodeBlock anchor="peft.PromptEmbedding.example">

Example:

```py
>>> from peft import PromptEmbedding, PromptTuningConfig

>>> config = PromptTuningConfig(
...     peft_type="PROMPT_TUNING",
...     task_type="SEQ_2_SEQ_LM",
...     num_virtual_tokens=20,
...     token_dim=768,
...     num_transformer_submodules=1,
...     num_attention_heads=12,
...     num_layers=12,
...     prompt_tuning_init="TEXT",
...     prompt_tuning_init_text="Predict if sentiment of this review is positive, negative or neutral",
...     tokenizer_name_or_path="t5-base",
... )

>>> # t5_model.shared is the word embeddings of the base model
>>> prompt_embedding = PromptEmbedding(config, t5_model.shared)
```

</ExampleCodeBlock>

Input Shape: (`batch_size`, `total_virtual_tokens`)

Output Shape: (`batch_size`, `total_virtual_tokens`, `token_dim`)


</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/prompt_tuning.md" />