# Helper methods

A collection of helper functions for PEFT.

## Checking if a model is a PEFT model[[peft.helpers.check_if_peft_model]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>peft.helpers.check_if_peft_model</name><anchor>peft.helpers.check_if_peft_model</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/helpers.py#L135</source><parameters>[{"name": "model_name_or_path", "val": ": str"}]</parameters><paramsdesc>- **model_name_or_path** (`str`) --
  Model id to check, can be local or on the Hugging Face Hub.</paramsdesc><paramgroups>0</paramgroups><rettype>`bool`</rettype><retdesc>True if the model is a PEFT model, False otherwise.</retdesc></docstring>

Check if the model is a PEFT model.








</div>

## Temporarily Rescaling Adapter Scale in LoraLayer Modules[[peft.helpers.rescale_adapter_scale]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>peft.helpers.rescale_adapter_scale</name><anchor>peft.helpers.rescale_adapter_scale</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/helpers.py#L156</source><parameters>[{"name": "model", "val": ""}, {"name": "multiplier", "val": ""}]</parameters><paramsdesc>- **model** -- The model containing `LoraLayer` modules whose scaling is to be adjusted.
- **multiplier** (float or int) --
  The multiplier that rescales the `scaling` attribute. Must be of type float or int.</paramsdesc><paramgroups>0</paramgroups><raises>- ``ValueError`` -- If the model does not contain any `LoraLayer`
  instances, indicating that the model does not support scaling.</raises><raisederrors>``ValueError``</raisederrors></docstring>

Context manager to temporarily rescale the scaling of the LoRA adapter in a model.

The original scaling values are restored when the context manager exits. This context manager works with the
transformers and diffusers models that have directly loaded LoRA adapters.

For LoRA, applying this context manager with multiplier in [0, 1] is strictly equivalent to applying
[wise-ft](https://huggingface.co/papers/2109.01903) (see [#1940](https://github.com/huggingface/peft/issues/1940)
for details). It can improve the performances of the model if there is a distribution shiftbetween the training
data used for fine-tuning, and the test data used during inference.

Warning: It has been reported that when using Apple's MPS backend for PyTorch, it is necessary to add a short sleep
time after exiting the context before the scales are fully restored.







<ExampleCodeBlock anchor="peft.helpers.rescale_adapter_scale.example">

Example:

```python
>>> model = ModelWithLoraLayer()
>>> multiplier = 0.5
>>> with rescale_adapter_scale(model, multiplier):
...     outputs = model(**inputs)  # Perform operations with the scaled model
>>> outputs = model(**inputs)  # The original scaling values are restored here
```

</ExampleCodeBlock>


</div>

## Context manager to disable input dtype casting in the `forward` method of LoRA layers[[peft.helpers.disable_input_dtype_casting]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>peft.helpers.disable_input_dtype_casting</name><anchor>peft.helpers.disable_input_dtype_casting</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/helpers.py#L217</source><parameters>[{"name": "model", "val": ": Module"}, {"name": "active", "val": ": bool = True"}]</parameters><paramsdesc>- **model** (nn.Module) --
  The model containing PEFT modules whose input dtype casting is to be adjusted.
- **active** (bool) --
  Whether the context manager is active (default) or inactive.</paramsdesc><paramgroups>0</paramgroups></docstring>

Context manager disables input dtype casting to the dtype of the weight.




</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/helpers.md" />