# AutoPeftModels

The `AutoPeftModel` classes loads the appropriate PEFT model for the task type by automatically inferring it from the configuration file. They are designed to quickly and easily load a PEFT model in a single line of code without having to worry about which exact model class you need or manually loading a [PeftConfig](/docs/peft/main/en/package_reference/config#peft.PeftConfig).

## AutoPeftModel[[peft.AutoPeftModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModel</name><anchor>peft.AutoPeftModel</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L152</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>from_pretrained</name><anchor>peft.AutoPeftModel.from_pretrained</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L67</source><parameters>[{"name": "pretrained_model_name_or_path", "val": ""}, {"name": "adapter_name", "val": ": str = 'default'"}, {"name": "is_trainable", "val": ": bool = False"}, {"name": "config", "val": ": Optional[PeftConfig] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "**kwargs", "val": ""}]</parameters></docstring>

A wrapper around all the preprocessing steps a user needs to perform in order to load a PEFT model. The kwargs
are passed along to `PeftConfig` that automatically takes care of filtering the kwargs of the Hub methods and
the config object init.


</div></div>

## AutoPeftModelForCausalLM[[peft.AutoPeftModelForCausalLM]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForCausalLM</name><anchor>peft.AutoPeftModelForCausalLM</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L157</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## AutoPeftModelForSeq2SeqLM[[peft.AutoPeftModelForSeq2SeqLM]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForSeq2SeqLM</name><anchor>peft.AutoPeftModelForSeq2SeqLM</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L162</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## AutoPeftModelForSequenceClassification[[peft.AutoPeftModelForSequenceClassification]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForSequenceClassification</name><anchor>peft.AutoPeftModelForSequenceClassification</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L167</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## AutoPeftModelForTokenClassification[[peft.AutoPeftModelForTokenClassification]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForTokenClassification</name><anchor>peft.AutoPeftModelForTokenClassification</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L172</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## AutoPeftModelForQuestionAnswering[[peft.AutoPeftModelForQuestionAnswering]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForQuestionAnswering</name><anchor>peft.AutoPeftModelForQuestionAnswering</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L177</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

## AutoPeftModelForFeatureExtraction[[peft.AutoPeftModelForFeatureExtraction]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AutoPeftModelForFeatureExtraction</name><anchor>peft.AutoPeftModelForFeatureExtraction</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/auto.py#L182</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>


</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/auto_class.md" />