# LyCORIS

[LyCORIS](https://hf.co/papers/2309.14859) (Lora beYond Conventional methods, Other Rank adaptation Implementations for Stable diffusion) are LoRA-like matrix decomposition adapters that modify the cross-attention layer of the UNet. The [LoHa](loha) and [LoKr](lokr) methods inherit from the `Lycoris` classes here.

## LycorisConfig[[peft.tuners.lycoris_utils.LycorisConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.tuners.lycoris_utils.LycorisConfig</name><anchor>peft.tuners.lycoris_utils.LycorisConfig</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/lycoris_utils.py#L35</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "rank_pattern", "val": ": Optional[dict] = <factory>"}, {"name": "alpha_pattern", "val": ": Optional[dict] = <factory>"}]</parameters></docstring>

A base config for LyCORIS like adapters


</div>

## LycorisLayer[[peft.tuners.lycoris_utils.LycorisLayer]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.tuners.lycoris_utils.LycorisLayer</name><anchor>peft.tuners.lycoris_utils.LycorisLayer</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/lycoris_utils.py#L60</source><parameters>[{"name": "base_layer", "val": ": nn.Module"}]</parameters></docstring>

A base layer for LyCORIS like adapters



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>merge</name><anchor>peft.tuners.lycoris_utils.LycorisLayer.merge</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/lycoris_utils.py#L114</source><parameters>[{"name": "safe_merge", "val": ": bool = False"}, {"name": "adapter_names", "val": ": Optional[list[str]] = None"}]</parameters><paramsdesc>- **safe_merge** (`bool`, *optional*) --
  If `True`, the merge operation will be performed in a copy of the original weights and check for NaNs
  before merging the weights. This is useful if you want to check if the merge operation will produce
  NaNs. Defaults to `False`.
- **adapter_names** (`List[str]`, *optional*) --
  The list of adapter names that should be merged. If `None`, all active adapters will be merged.
  Defaults to `None`.</paramsdesc><paramgroups>0</paramgroups></docstring>

Merge the active adapter weights into the base weights




</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>unmerge</name><anchor>peft.tuners.lycoris_utils.LycorisLayer.unmerge</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/lycoris_utils.py#L168</source><parameters>[]</parameters></docstring>

This method unmerges all merged adapter layers from the base weights.


</div></div>

## LycorisTuner[[peft.tuners.lycoris_utils.LycorisTuner]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.tuners.lycoris_utils.LycorisTuner</name><anchor>peft.tuners.lycoris_utils.LycorisTuner</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/lycoris_utils.py#L194</source><parameters>[{"name": "model", "val": ""}, {"name": "peft_config", "val": ": Union[PeftConfig, dict[str, PeftConfig]]"}, {"name": "adapter_name", "val": ": str"}, {"name": "low_cpu_mem_usage", "val": ": bool = False"}, {"name": "state_dict", "val": ": Optional[dict[str, torch.Tensor]] = None"}]</parameters><paramsdesc>- **model** (`torch.nn.Module`) -- The model to be adapted.
- **config** ([LoraConfig](/docs/peft/main/en/package_reference/lora#peft.LoraConfig)) -- The configuration of the Lora model.
- **adapter_name** (`str`) -- The name of the adapter, defaults to `"default"`.
- **low_cpu_mem_usage** (`bool`, `optional`, defaults to `False`) --
  Create empty adapter weights on meta device. Useful to speed up the loading process.</paramsdesc><paramgroups>0</paramgroups></docstring>

A base tuner for LyCORIS like adapters




</div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/adapter_utils.md" />