# AdaLoRA

[AdaLoRA](https://hf.co/papers/2303.10512) is a method for optimizing the number of trainable parameters to assign to weight matrices and layers, unlike LoRA, which distributes parameters evenly across all modules. More parameters are budgeted for important weight matrices and layers while less important ones receive fewer parameters.

The abstract from the paper is:

*Fine-tuning large pre-trained language models on downstream tasks has become an important paradigm in NLP. However, common practice fine-tunes all of the parameters in a pre-trained model, which becomes prohibitive when a large number of downstream tasks are present. Therefore, many fine-tuning methods are proposed to learn incremental updates of pre-trained weights in a parameter efficient way, e.g., low-rank increments. These methods often evenly distribute the budget of incremental updates across all pre-trained weight matrices, and overlook the varying importance of different weight parameters. As a consequence, the fine-tuning performance is suboptimal. To bridge this gap, we propose AdaLoRA, which adaptively allocates the parameter budget among weight matrices according to their importance score. In particular, AdaLoRA parameterizes the incremental updates in the form of singular value decomposition. Such a novel approach allows us to effectively prune the singular values of unimportant updates, which is essentially to reduce their parameter budget but circumvent intensive exact SVD computations. We conduct extensive experiments with several pre-trained models on natural language processing, question answering, and natural language generation to validate the effectiveness of AdaLoRA. Results demonstrate that AdaLoRA manifests notable improvement over baselines, especially in the low budget settings. Our code is publicly available at https://github.com/QingruZhang/AdaLoRA*.

## AdaLoraConfig[[peft.AdaLoraConfig]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AdaLoraConfig</name><anchor>peft.AdaLoraConfig</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/adalora/config.py#L24</source><parameters>[{"name": "task_type", "val": ": Optional[Union[str, TaskType]] = None"}, {"name": "peft_type", "val": ": Optional[Union[str, PeftType]] = None"}, {"name": "auto_mapping", "val": ": Optional[dict] = None"}, {"name": "peft_version", "val": ": Optional[str] = None"}, {"name": "base_model_name_or_path", "val": ": Optional[str] = None"}, {"name": "revision", "val": ": Optional[str] = None"}, {"name": "inference_mode", "val": ": bool = False"}, {"name": "r", "val": ": int = 8"}, {"name": "target_modules", "val": ": Optional[Union[list[str], str]] = None"}, {"name": "exclude_modules", "val": ": Optional[Union[list[str], str]] = None"}, {"name": "lora_alpha", "val": ": int = 8"}, {"name": "lora_dropout", "val": ": float = 0.0"}, {"name": "fan_in_fan_out", "val": ": bool = False"}, {"name": "bias", "val": ": Literal['none', 'all', 'lora_only'] = 'none'"}, {"name": "use_rslora", "val": ": bool = False"}, {"name": "modules_to_save", "val": ": Optional[list[str]] = None"}, {"name": "init_lora_weights", "val": ": bool | Literal['gaussian', 'eva', 'olora', 'pissa', 'pissa_niter_[number of iters]', 'corda', 'loftq', 'orthogonal'] = True"}, {"name": "layers_to_transform", "val": ": Optional[Union[list[int], int]] = None"}, {"name": "layers_pattern", "val": ": Optional[Union[list[str], str]] = None"}, {"name": "rank_pattern", "val": ": typing.Optional[dict] = None"}, {"name": "alpha_pattern", "val": ": Optional[dict] = <factory>"}, {"name": "megatron_config", "val": ": Optional[dict] = None"}, {"name": "megatron_core", "val": ": Optional[str] = 'megatron.core'"}, {"name": "trainable_token_indices", "val": ": Optional[Union[list[int], dict[str, list[int]]]] = None"}, {"name": "loftq_config", "val": ": Union[LoftQConfig, dict] = <factory>"}, {"name": "eva_config", "val": ": Optional[EvaConfig] = None"}, {"name": "corda_config", "val": ": Optional[CordaConfig] = None"}, {"name": "use_dora", "val": ": bool = False"}, {"name": "alora_invocation_tokens", "val": ": Optional[list[int]] = None"}, {"name": "use_qalora", "val": ": bool = False"}, {"name": "qalora_group_size", "val": ": int = 16"}, {"name": "layer_replication", "val": ": Optional[list[tuple[int, int]]] = None"}, {"name": "runtime_config", "val": ": LoraRuntimeConfig = <factory>"}, {"name": "lora_bias", "val": ": bool = False"}, {"name": "target_parameters", "val": ": Optional[list[str]] = None"}, {"name": "arrow_config", "val": ": Optional[ArrowConfig] = None"}, {"name": "target_r", "val": ": int = 8"}, {"name": "init_r", "val": ": int = 12"}, {"name": "tinit", "val": ": int = 0"}, {"name": "tfinal", "val": ": int = 0"}, {"name": "deltaT", "val": ": int = 1"}, {"name": "beta1", "val": ": float = 0.85"}, {"name": "beta2", "val": ": float = 0.85"}, {"name": "orth_reg_weight", "val": ": float = 0.5"}, {"name": "total_step", "val": ": typing.Optional[int] = None"}]</parameters><paramsdesc>- **target_r** (`int`) -- The target average rank of incremental matrix.
- **init_r** (`int`) -- The initial rank for each incremental matrix.
- **tinit** (`int`) -- The steps of initial fine-tuning warmup.
- **tfinal** (`int`) -- The number of steps of final fine-tuning.
- **deltaT** (`int`) -- The time internval between two budget allocations.
- **beta1** (`float`) -- The hyperparameter of EMA for sensitivity smoothing.
- **beta2** (`float`) -- The hyperparameter of EMA for undertainty quantification.
- **orth_reg_weight** (`float`) -- The coefficient of orthogonal regularization.
- **total_step** (`int`) -- The total training steps that should be specified before training.
- **rank_pattern** (`list`) -- The allocated rank for each weight matrix by RankAllocator.</paramsdesc><paramgroups>0</paramgroups></docstring>

This is the configuration class to store the configuration of a `~peft.AdaLora`.

AdaLoRA has three phases defined by `tinit`, `tfinal` and `total_step`.

The initial phase can be understood as a step for pre-training the adapters so that when reducing their rank, there
is already some information encoded that can be reduced instead of random matrices. This phase is defined by
supplying `tinit`.

After the initial phase is over (`tinit` steps have passed) and the final phase has not begun, AdaLoRA reduces the
budget of how much rank each layer is allowed to have with each step. This is where the reduction of rank is
happening. This goes on until `total_step - tfinal` steps are reached.

The last phase, beginning once `total_step - tfinal` steps are reached, does not change the layer ranks anymore but
fine-tunes the reduced-rank layers that resulted from the previous phase.

A practical example: `tinit` is 10, `tfinal` is 20, `total_step` is 100. We spend 10 steps doing pre-training
without rank reduction because our budget is constant (init phase), then we spend 80 (100-20) steps in the
reduction phase where our budget decreases step-wise and, finally, 20 steps in the final fine-tuning stage without
reduction.




</div>

## AdaLoraModel[[peft.AdaLoraModel]]

<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>class peft.AdaLoraModel</name><anchor>peft.AdaLoraModel</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/adalora/model.py#L37</source><parameters>[{"name": "model", "val": ""}, {"name": "config", "val": ""}, {"name": "adapter_name", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters><paramsdesc>- **model** ([*transformers.PreTrainedModel*]) -- The model to be adapted.
- **config** ([*AdaLoraConfig*]) -- The configuration of the AdaLora model.
- **adapter_name** (*str*) -- The name of the adapter, defaults to *"default"*.
- **low_cpu_mem_usage** (*bool*, *optional*, defaults to *False*) --
  Create empty adapter weights on meta device. Useful to speed up the loading process.</paramsdesc><paramgroups>0</paramgroups><rettype>*torch.nn.Module*</rettype><retdesc>The AdaLora model.</retdesc></docstring>

Creates AdaLoRA (Adaptive LoRA) model from a pretrained transformers model. Paper:
https://openreview.net/forum?id=lq62uWRJjiY







<ExampleCodeBlock anchor="peft.AdaLoraModel.example">

Example:

```python
>>> from transformers import AutoModelForSeq2SeqLM >>> from peft import LoraConfig, AdaLoraModel, AdaLoraConfig
>>> config = AdaLoraConfig(
peft_type="ADALORA", task_type="SEQ_2_SEQ_LM", init_r=12, lora_alpha=32, target_modules=["q", "v"],
lora_dropout=0.01,
)
>>> model = AutoModelForSeq2SeqLM.from_pretrained("t5-base") >>> model = AdaLoraModel(model, config, "default")
```

</ExampleCodeBlock>

    **Attributes**:
- **model** ([*transformers.PreTrainedModel*]) -- The model to be adapted.
- **peft_config** ([*AdaLoraConfig*]): The configuration of the AdaLora model.



<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>add_weighted_adapter</name><anchor>peft.AdaLoraModel.add_weighted_adapter</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/adalora/model.py#L344</source><parameters>[{"name": "*args", "val": ""}, {"name": "**kwargs", "val": ""}]</parameters></docstring>
This method is not supported for AdaLoRA, use LoRA instead.

</div>
<div class="docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8">


<docstring><name>update_and_allocate</name><anchor>peft.AdaLoraModel.update_and_allocate</anchor><source>https://github.com/huggingface/peft/blob/main/src/peft/tuners/adalora/model.py#L302</source><parameters>[{"name": "global_step", "val": ""}]</parameters><paramsdesc>- **global_step** (`int`) -- The current training step, it is used to calculate adalora budget.</paramsdesc><paramgroups>0</paramgroups></docstring>

This method updates Adalora budget and mask.

This should be called in every training step after `loss.backward()` and before `zero_grad()`.

`tinit`, `tfinal` and `deltaT` are handled with in the method.



<ExampleCodeBlock anchor="peft.AdaLoraModel.update_and_allocate.example">

Example:

```python
>>> loss = model(**input).loss
>>> loss.backward()
>>> optimizer.step()
>>> model.base_model.update_and_allocate(i_step)
>>> optimizer.zero_grad()
```

</ExampleCodeBlock>


</div></div>

<EditOnGithub source="https://github.com/huggingface/peft/blob/main/docs/source/package_reference/adalora.md" />