import{s as cs,n as rs,o as us}from"../chunks/scheduler.78382b47.js";import{S as hs,i as ds,e as o,s as l,c,h as ms,a as i,d as s,b as n,f as ps,g as r,j as p,k as fe,l as ys,m as a,n as u,t as h,o as d,p as m}from"../chunks/index.6dd35eb6.js";import{C as Ms,H as J,E as Ts}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca101b6.js";import{C as Te}from"../chunks/CodeBlock.c942b99c.js";function fs(_t){let y,we,je,Ue,w,be,U,_e,b,It="This document describes how PEFT’s checkpoint files are structured and how to convert between the PEFT format and other formats.",Ie,_,Ce,I,Ct="PEFT (parameter-efficient fine-tuning) methods only update a small subset of a model’s parameters rather than all of them. This is nice because checkpoint files can generally be much smaller than the original model files and are easier to store and share. However, this also means that to load a PEFT model, you need to have the original model available as well.",ge,C,gt='When you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a> on a PEFT model, the PEFT model saves three files, described below:',ve,g,vt="<li><code>adapter_model.safetensors</code> or <code>adapter_model.bin</code></li>",qe,v,qt='By default, the model is saved in the <code>safetensors</code> format, a secure alternative to the <code>bin</code> format, which is known to be susceptible to <a href="https://huggingface.co/docs/hub/security-pickle" rel="nofollow">security vulnerabilities</a> because it uses the pickle utility under the hood. Both formats store the same <code>state_dict</code> though, and are interchangeable.',Be,q,Bt="The <code>state_dict</code> only contains the parameters of the adapter module, not the base model. To illustrate the difference in size, a normal BERT model requires ~420MB of disk space, whereas an IA³ adapter on top of this BERT model only requires ~260KB.",Ee,M,Et="<li><code>adapter_config.json</code></li>",ke,B,kt="The <code>adapter_config.json</code> file contains the configuration of the adapter module, which is necessary to load the model. Below is an example of an <code>adapter_config.json</code> for an IA³ adapter with standard settings applied to a BERT model:",$e,E,Ae,k,$t="The configuration file contains:",Ze,$,At="<li>the adapter module type stored, <code>&quot;peft_type&quot;: &quot;IA3&quot;</code></li> <li>information about the base model like <code>&quot;base_model_name_or_path&quot;: &quot;bert-base-uncased&quot;</code></li> <li>the revision of the model (if any), <code>&quot;revision&quot;: null</code></li>",xe,A,Zt="If the base model is not a pretrained Transformers model, the latter two entries will be <code>null</code>. Other than that, the settings are all related to the specific IA³ adapter that was used to fine-tune the model.",Ve,T,xt="<li><code>README.md</code></li>",Fe,Z,Vt="The generated <code>README.md</code> is the model card of a PEFT model and contains a few pre-filled entries. The intent of this is to make it easier to share the model with others and to provide some basic information about the model. This file is not needed to load the model.",Le,x,Qe,V,Ft="When converting from another format to the PEFT format, we require both the <code>adapter_model.safetensors</code> (or <code>adapter_model.bin</code>) file and the <code>adapter_config.json</code> file.",He,F,Re,L,Lt="For the model weights, it is important to use the correct mapping from parameter name to value for PEFT to load the file. Getting this mapping right is an exercise in checking the implementation details, as there is no generally agreed upon format for PEFT adapters.",Xe,Q,Qt='Fortunately, figuring out this mapping is not overly complicated for common base cases. Let’s look at a concrete example, the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/layer.py" rel="nofollow"><code>LoraLayer</code></a>:',We,H,Ge,R,Ht="In the <code>__init__</code> code used by all <code>LoraLayer</code> classes in PEFT, there are a bunch of parameters used to initialize the model, but only a few are relevant for the checkpoint file: <code>lora_A</code>, <code>lora_B</code>, <code>lora_embedding_A</code>, and <code>lora_embedding_B</code>. These parameters are listed in the class attribute <code>adapter_layer_names</code> and contain the learnable parameters, so they must be included in the checkpoint file. All the other parameters, like the rank <code>r</code>, are derived from the <code>adapter_config.json</code> and must be included there (unless the default value is used).",Pe,X,Rt="Let’s check the <code>state_dict</code> of a PEFT LoRA model applied to BERT. When printing the first five keys using the default LoRA settings (the remaining keys are the same, just with different layer numbers), we get:",Ye,W,Xt="<li><code>base_model.model.encoder.layer.0.attention.self.query.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.query.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_A.weight</code></li> <li><code>base_model.model.encoder.layer.0.attention.self.value.lora_B.weight</code></li> <li><code>base_model.model.encoder.layer.1.attention.self.query.lora_A.weight</code></li> <li>etc.</li>",Ne,G,Wt="Let’s break this down:",Se,P,Gt="<li>By default, for BERT models, LoRA is applied to the <code>query</code> and <code>value</code> layers of the attention module. This is why you see <code>attention.self.query</code> and <code>attention.self.value</code> in the key names for each layer.</li> <li>LoRA decomposes the weights into two low-rank matrices, <code>lora_A</code> and <code>lora_B</code>. This is where <code>lora_A</code> and <code>lora_B</code> come from in the key names.</li> <li>These LoRA matrices are implemented as <code>nn.Linear</code> layers, so the parameters are stored in the <code>.weight</code> attribute (<code>lora_A.weight</code>, <code>lora_B.weight</code>).</li> <li>By default, LoRA isn’t applied to BERT’s embedding layer, so there are <em>no entries</em> for <code>lora_A_embedding</code> and <code>lora_B_embedding</code>.</li> <li>The keys of the <code>state_dict</code> always start with <code>&quot;base_model.model.&quot;</code>. The reason is that, in PEFT, we wrap the base model inside a tuner-specific model (<code>LoraModel</code> in this case), which itself is wrapped in a general PEFT model (<code>PeftModel</code>). For this reason, these two prefixes are added to the keys. When converting to the PEFT format, it is required to add these prefixes.</li>",ze,f,Pt="<p>This last point is not true for prefix tuning techniques like prompt tuning. There, the extra embeddings are directly stored in the <code>state_dict</code> without any prefixes added to the keys.</p>",De,Y,Yt="When inspecting the parameter names in the loaded model, you might be surprised to find that they look a bit different, e.g. <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.default.weight</code>. The difference is the <em><code>.default</code></em> part in the second to last segment. This part exists because PEFT generally allows the addition of multiple adapters at once (using an <code>nn.ModuleDict</code> or <code>nn.ParameterDict</code> to store them). For example, if you add another adapter called “other”, the key for that adapter would be <code>base_model.model.encoder.layer.0.attention.self.query.lora_A.other.weight</code>.",Oe,N,Nt='When you call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.save_pretrained">save_pretrained()</a>, the adapter name is stripped from the keys. The reason is that the adapter name is not an important part of the model architecture; it is just an arbitrary name. When loading the adapter, you could choose a totally different name, and the model would still work the same way. This is why the adapter name is not stored in the checkpoint file.',Ke,j,St="<p>If you call <code>save_pretrained(&quot;some/path&quot;)</code> and the adapter name is not <code>&quot;default&quot;</code>, the adapter is stored in a sub-directory with the same name as the adapter. So if the name is “other”, it would be stored inside of <code>some/path/other</code>.</p>",et,S,zt="In some circumstances, deciding which values to add to the checkpoint file can become a bit more complicated. For example, in PEFT, DoRA is implemented as a special case of LoRA. If you want to convert a DoRA model to PEFT, you should create a LoRA checkpoint with extra entries for DoRA. You can see this in the <code>__init__</code> of the previous <code>LoraLayer</code> code:",tt,z,st,D,Dt="This indicates that there is an optional extra parameter per layer for DoRA.",at,O,lt,K,Ot="All the other information needed to load a PEFT model is contained in the <code>adapter_config.json</code> file. Let’s check this file for a LoRA model applied to BERT:",nt,ee,ot,te,Kt="This contains a lot of entries, and at first glance, it could feel overwhelming to figure out all the right values to put in there. However, most of the entries are not necessary to load the model. This is either because they use the default values and don’t need to be added or because they only affect the initialization of the LoRA weights, which is irrelevant when it comes to loading the model. If you find that you don’t know what a specific parameter does, e.g., <code>&quot;use_rslora&quot;,</code> don’t add it, and you should be fine. Also note that as more options are added, this file will get more entries in the future, but it should be backward compatible.",it,se,es="At the minimum, you should include the following entries:",pt,ae,ct,le,ts='However, adding as many entries as possible, like the rank <code>r</code> or the <code>base_model_name_or_path</code> (if it’s a Transformers model) is recommended. This information can help others understand the model better and share it more easily. To check which keys and values are expected, check out the <a href="https://github.com/huggingface/peft/blob/main/src/peft/tuners/lora/config.py" rel="nofollow">config.py</a> file (as an example, this is the config file for LoRA) in the PEFT source code.',rt,ne,ut,oe,ss="In some circumstances, you might want to store the whole PEFT model, including the base weights. This can be necessary if, for instance, the base model is not available to the users trying to load the PEFT model. You can merge the weights first or convert it into a Transformer model.",ht,ie,dt,pe,as="The most straightforward way to store the whole PEFT model is to merge the adapter weights into the base weights:",mt,ce,yt,re,ls="There are some disadvantages to this approach, though:",Mt,ue,ns='<li>Once <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> is called, you get a basic model without any PEFT-specific functionality. This means you can’t use any of the PEFT-specific methods anymore.</li> <li>You cannot unmerge the weights, load multiple adapters at once, disable the adapter, etc.</li> <li>Not all PEFT methods support merging weights.</li> <li>Some PEFT methods may generally allow merging, but not with specific settings (e.g. when using certain quantization techniques).</li> <li>The whole model will be much larger than the PEFT model, as it will contain all the base weights as well.</li>',Tt,he,os="But inference with a merged model should be a bit faster.",ft,de,jt,me,is="Another way to save the whole model, assuming the base model is a Transformers model, is to use this hacky approach to directly insert the PEFT weights into the base model and save it, which only works if you “trick” Transformers into believing the PEFT model is not a PEFT model. This only works with LoRA because other adapters are not implemented in Transformers.",Jt,ye,wt,Me,Ut,Je,bt;return w=new Ms({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new J({props:{title:"PEFT checkpoint format",local:"peft-checkpoint-format",headingTag:"h1"}}),_=new J({props:{title:"PEFT files",local:"peft-files",headingTag:"h2"}}),E=new Te({props:{code:"JTdCJTBBJTIwJTIwJTIyYXV0b19tYXBwaW5nJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyYmFzZV9tb2RlbF9jbGFzcyUyMiUzQSUyMCUyMkJlcnRNb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmVudF9saWJyYXJ5JTIyJTNBJTIwJTIydHJhbnNmb3JtZXJzLm1vZGVscy5iZXJ0Lm1vZGVsaW5nX2JlcnQlMjIlMEElMjAlMjAlN0QlMkMlMEElMjAlMjAlMjJiYXNlX21vZGVsX25hbWVfb3JfcGF0aCUyMiUzQSUyMCUyMmJlcnQtYmFzZS11bmNhc2VkJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmZlZWRmb3J3YXJkX21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJvdXRwdXQuZGVuc2UlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJpbmZlcmVuY2VfbW9kZSUyMiUzQSUyMHRydWUlMkMlMEElMjAlMjAlMjJpbml0X2lhM193ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMm1vZHVsZXNfdG9fc2F2ZSUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJwZWZ0X3R5cGUlMjIlM0ElMjAlMjJJQTMlMjIlMkMlMEElMjAlMjAlMjJyZXZpc2lvbiUyMiUzQSUyMG51bGwlMkMlMEElMjAlMjAlMjJ0YXJnZXRfbW9kdWxlcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmtleSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0LmRlbnNlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feedforward_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_ia3_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;IA3&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;key&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;output.dense&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),x=new J({props:{title:"Convert to PEFT format",local:"convert-to-peft-format",headingTag:"h2"}}),F=new J({props:{title:"adapter_model",local:"adaptermodel",headingTag:"h3"}}),H=new Te({props:{code:"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",highlighted:`<span class="hljs-comment"># showing only part of the code</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoraLayer</span>(<span class="hljs-title class_ inherited__">BaseTunerLayer</span>):
    <span class="hljs-comment"># All names of layers that may contain (trainable) adapter weights</span>
    adapter_layer_names = (<span class="hljs-string">&quot;lora_A&quot;</span>, <span class="hljs-string">&quot;lora_B&quot;</span>, <span class="hljs-string">&quot;lora_embedding_A&quot;</span>, <span class="hljs-string">&quot;lora_embedding_B&quot;</span>)
    <span class="hljs-comment"># All names of other parameters that may contain adapter-related parameters</span>
    other_param_names = (<span class="hljs-string">&quot;r&quot;</span>, <span class="hljs-string">&quot;lora_alpha&quot;</span>, <span class="hljs-string">&quot;scaling&quot;</span>, <span class="hljs-string">&quot;lora_dropout&quot;</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, base_layer: nn.Module, **kwargs</span>) -&gt; <span class="hljs-literal">None</span>:
        self.base_layer = base_layer
        self.r = {}
        self.lora_alpha = {}
        self.scaling = {}
        self.lora_dropout = nn.ModuleDict({})
        self.lora_A = nn.ModuleDict({})
        self.lora_B = nn.ModuleDict({})
        <span class="hljs-comment"># For Embedding layer</span>
        self.lora_embedding_A = nn.ParameterDict({})
        self.lora_embedding_B = nn.ParameterDict({})
        <span class="hljs-comment"># Mark the weight as unmerged</span>
        self._disable_adapters = <span class="hljs-literal">False</span>
        self.merged_adapters = []
        self.use_dora: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">bool</span>] = {}
        self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>
        self._caches: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {}
        self.kwargs = kwargs`,wrap:!1}}),z=new Te({props:{code:"c2VsZi5sb3JhX21hZ25pdHVkZV92ZWN0b3IlM0ElMjBPcHRpb25hbCU1QnRvcmNoLm5uLlBhcmFtZXRlckRpY3QlNUQlMjAlM0QlMjBOb25lJTIwJTIwJTIzJTIwZm9yJTIwRG9SQQ==",highlighted:'self.lora_magnitude_vector: <span class="hljs-type">Optional</span>[torch.nn.ParameterDict] = <span class="hljs-literal">None</span>  <span class="hljs-comment"># for DoRA</span>',wrap:!1}}),O=new J({props:{title:"adapter_config",local:"adapterconfig",headingTag:"h3"}}),ee=new Te({props:{code:"JTdCJTBBJTIwJTIwJTIyYWxwaGFfcGF0dGVybiUyMiUzQSUyMCU3QiU3RCUyQyUwQSUyMCUyMCUyMmF1dG9fbWFwcGluZyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmJhc2VfbW9kZWxfY2xhc3MlMjIlM0ElMjAlMjJCZXJ0TW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJwYXJlbnRfbGlicmFyeSUyMiUzQSUyMCUyMnRyYW5zZm9ybWVycy5tb2RlbHMuYmVydC5tb2RlbGluZ19iZXJ0JTIyJTBBJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIyYmFzZV9tb2RlbF9uYW1lX29yX3BhdGglMjIlM0ElMjAlMjJiZXJ0LWJhc2UtdW5jYXNlZCUyMiUyQyUwQSUyMCUyMCUyMmJpYXMlMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIyZmFuX2luX2Zhbl9vdXQlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMmluZmVyZW5jZV9tb2RlJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmluaXRfbG9yYV93ZWlnaHRzJTIyJTNBJTIwdHJ1ZSUyQyUwQSUyMCUyMCUyMmxheWVyX3JlcGxpY2F0aW9uJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc19wYXR0ZXJuJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMmxheWVyc190b190cmFuc2Zvcm0lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybG9mdHFfY29uZmlnJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIybG9yYV9hbHBoYSUyMiUzQSUyMDglMkMlMEElMjAlMjAlMjJsb3JhX2Ryb3BvdXQlMjIlM0ElMjAwLjAlMkMlMEElMjAlMjAlMjJtZWdhdHJvbl9jb25maWclMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIybWVnYXRyb25fY29yZSUyMiUzQSUyMCUyMm1lZ2F0cm9uLmNvcmUlMjIlMkMlMEElMjAlMjAlMjJtb2R1bGVzX3RvX3NhdmUlMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUyQyUwQSUyMCUyMCUyMnIlMjIlM0ElMjA4JTJDJTBBJTIwJTIwJTIycmFua19wYXR0ZXJuJTIyJTNBJTIwJTdCJTdEJTJDJTBBJTIwJTIwJTIycmV2aXNpb24lMjIlM0ElMjBudWxsJTJDJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMnZhbHVlJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGFza190eXBlJTIyJTNBJTIwbnVsbCUyQyUwQSUyMCUyMCUyMnVzZV9kb3JhJTIyJTNBJTIwZmFsc2UlMkMlMEElMjAlMjAlMjJ1c2VfcnNsb3JhJTIyJTNBJTIwZmFsc2UlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;alpha_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;auto_mapping&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;base_model_class&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;BertModel&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parent_library&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;transformers.models.bert.modeling_bert&quot;</span>
  <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;base_model_name_or_path&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;bert-base-uncased&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;bias&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;none&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;fan_in_fan_out&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;inference_mode&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;init_lora_weights&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">true</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layer_replication&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;layers_to_transform&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;loftq_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_alpha&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;lora_dropout&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">0.0</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_config&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;megatron_core&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;megatron.core&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;modules_to_save&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;r&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">8</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;rank_pattern&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;revision&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;value&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;task_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">null</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_dora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;use_rslora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-literal"><span class="hljs-keyword">false</span></span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ae=new Te({props:{code:"JTdCJTBBJTIwJTIwJTIydGFyZ2V0X21vZHVsZXMlMjIlM0ElMjAlNUIlMjJxdWVyeSUyMiUyQyUyMCUyMnZhbHVlJTIyJTVEJTJDJTBBJTIwJTIwJTIycGVmdF90eXBlJTIyJTNBJTIwJTIyTE9SQSUyMiUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;target_modules&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;query&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;value&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;peft_type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;LORA&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ne=new J({props:{title:"Model storage",local:"model-storage",headingTag:"h2"}}),ie=new J({props:{title:"Merge the weights",local:"merge-the-weights",headingTag:"h3"}}),ce=new Te({props:{code:"bWVyZ2VkX21vZGVsJTIwJTNEJTIwbW9kZWwubWVyZ2VfYW5kX3VubG9hZCgpJTBBbWVyZ2VkX21vZGVsLnNhdmVfcHJldHJhaW5lZCguLi4p",highlighted:`merged_model = model.merge_and_unload()
merged_model.save_pretrained(...)`,wrap:!1}}),de=new J({props:{title:"Convert to a Transformers model",local:"convert-to-a-transformers-model",headingTag:"h3"}}),ye=new Te({props:{code:"",highlighted:`model = ...  <span class="hljs-comment"># the PEFT model</span>
...
<span class="hljs-comment"># after you finish training the model, save it in a temporary location</span>
model.save_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now load this model directly into a transformers model, without the PEFT wrapper</span>
<span class="hljs-comment"># the PEFT weights are directly injected into the base model</span>
model_loaded = AutoModel.from_pretrained(&lt;temp_location&gt;)
<span class="hljs-comment"># now make the loaded model believe that it is _not_ a PEFT model</span>
model_loaded._hf_peft_config_loaded = <span class="hljs-literal">False</span>
<span class="hljs-comment"># now when we save it, it will save the whole model</span>
model_loaded.save_pretrained(&lt;final_location&gt;)
<span class="hljs-comment"># or upload to Hugging Face Hub</span>
model_loaded.push_to_hub(&lt;final_location&gt;)`,wrap:!1}}),Me=new Ts({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/checkpoint.md"}}),{c(){y=o("meta"),we=l(),je=o("p"),Ue=l(),c(w.$$.fragment),be=l(),c(U.$$.fragment),_e=l(),b=o("p"),b.textContent=It,Ie=l(),c(_.$$.fragment),Ce=l(),I=o("p"),I.textContent=Ct,ge=l(),C=o("p"),C.innerHTML=gt,ve=l(),g=o("ol"),g.innerHTML=vt,qe=l(),v=o("p"),v.innerHTML=qt,Be=l(),q=o("p"),q.innerHTML=Bt,Ee=l(),M=o("ol"),M.innerHTML=Et,ke=l(),B=o("p"),B.innerHTML=kt,$e=l(),c(E.$$.fragment),Ae=l(),k=o("p"),k.textContent=$t,Ze=l(),$=o("ul"),$.innerHTML=At,xe=l(),A=o("p"),A.innerHTML=Zt,Ve=l(),T=o("ol"),T.innerHTML=xt,Fe=l(),Z=o("p"),Z.innerHTML=Vt,Le=l(),c(x.$$.fragment),Qe=l(),V=o("p"),V.innerHTML=Ft,He=l(),c(F.$$.fragment),Re=l(),L=o("p"),L.textContent=Lt,Xe=l(),Q=o("p"),Q.innerHTML=Qt,We=l(),c(H.$$.fragment),Ge=l(),R=o("p"),R.innerHTML=Ht,Pe=l(),X=o("p"),X.innerHTML=Rt,Ye=l(),W=o("ul"),W.innerHTML=Xt,Ne=l(),G=o("p"),G.textContent=Wt,Se=l(),P=o("ul"),P.innerHTML=Gt,ze=l(),f=o("blockquote"),f.innerHTML=Pt,De=l(),Y=o("p"),Y.innerHTML=Yt,Oe=l(),N=o("p"),N.innerHTML=Nt,Ke=l(),j=o("blockquote"),j.innerHTML=St,et=l(),S=o("p"),S.innerHTML=zt,tt=l(),c(z.$$.fragment),st=l(),D=o("p"),D.textContent=Dt,at=l(),c(O.$$.fragment),lt=l(),K=o("p"),K.innerHTML=Ot,nt=l(),c(ee.$$.fragment),ot=l(),te=o("p"),te.innerHTML=Kt,it=l(),se=o("p"),se.textContent=es,pt=l(),c(ae.$$.fragment),ct=l(),le=o("p"),le.innerHTML=ts,rt=l(),c(ne.$$.fragment),ut=l(),oe=o("p"),oe.textContent=ss,ht=l(),c(ie.$$.fragment),dt=l(),pe=o("p"),pe.textContent=as,mt=l(),c(ce.$$.fragment),yt=l(),re=o("p"),re.textContent=ls,Mt=l(),ue=o("ul"),ue.innerHTML=ns,Tt=l(),he=o("p"),he.textContent=os,ft=l(),c(de.$$.fragment),jt=l(),me=o("p"),me.textContent=is,Jt=l(),c(ye.$$.fragment),wt=l(),c(Me.$$.fragment),Ut=l(),Je=o("p"),this.h()},l(e){const t=ms("svelte-u9bgzb",document.head);y=i(t,"META",{name:!0,content:!0}),t.forEach(s),we=n(e),je=i(e,"P",{}),ps(je).forEach(s),Ue=n(e),r(w.$$.fragment,e),be=n(e),r(U.$$.fragment,e),_e=n(e),b=i(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-i846eh"&&(b.textContent=It),Ie=n(e),r(_.$$.fragment,e),Ce=n(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1jlobya"&&(I.textContent=Ct),ge=n(e),C=i(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-npkoss"&&(C.innerHTML=gt),ve=n(e),g=i(e,"OL",{"data-svelte-h":!0}),p(g)!=="svelte-1buhd3i"&&(g.innerHTML=vt),qe=n(e),v=i(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-12xl22z"&&(v.innerHTML=qt),Be=n(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1uhgqli"&&(q.innerHTML=Bt),Ee=n(e),M=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(M)!=="svelte-u9vwkh"&&(M.innerHTML=Et),ke=n(e),B=i(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-ubabis"&&(B.innerHTML=kt),$e=n(e),r(E.$$.fragment,e),Ae=n(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-18i1sdg"&&(k.textContent=$t),Ze=n(e),$=i(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-1fi0uuu"&&($.innerHTML=At),xe=n(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1nfr73w"&&(A.innerHTML=Zt),Ve=n(e),T=i(e,"OL",{start:!0,"data-svelte-h":!0}),p(T)!=="svelte-11vms8t"&&(T.innerHTML=xt),Fe=n(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-bfnv50"&&(Z.innerHTML=Vt),Le=n(e),r(x.$$.fragment,e),Qe=n(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1k4p1z7"&&(V.innerHTML=Ft),He=n(e),r(F.$$.fragment,e),Re=n(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-kd80je"&&(L.textContent=Lt),Xe=n(e),Q=i(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-vjr9ez"&&(Q.innerHTML=Qt),We=n(e),r(H.$$.fragment,e),Ge=n(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1bnpl7i"&&(R.innerHTML=Ht),Pe=n(e),X=i(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-my5lpq"&&(X.innerHTML=Rt),Ye=n(e),W=i(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-18g5t5x"&&(W.innerHTML=Xt),Ne=n(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1cey2tw"&&(G.textContent=Wt),Se=n(e),P=i(e,"UL",{"data-svelte-h":!0}),p(P)!=="svelte-12zgb0p"&&(P.innerHTML=Gt),ze=n(e),f=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-xj9vfo"&&(f.innerHTML=Pt),De=n(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-1g2h6ud"&&(Y.innerHTML=Yt),Oe=n(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-bu31s0"&&(N.innerHTML=Nt),Ke=n(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-a8hmi4"&&(j.innerHTML=St),et=n(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1bo4lop"&&(S.innerHTML=zt),tt=n(e),r(z.$$.fragment,e),st=n(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-34pnf6"&&(D.textContent=Dt),at=n(e),r(O.$$.fragment,e),lt=n(e),K=i(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-6fxao8"&&(K.innerHTML=Ot),nt=n(e),r(ee.$$.fragment,e),ot=n(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-6hfyn3"&&(te.innerHTML=Kt),it=n(e),se=i(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-190wzyy"&&(se.textContent=es),pt=n(e),r(ae.$$.fragment,e),ct=n(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-19ijgni"&&(le.innerHTML=ts),rt=n(e),r(ne.$$.fragment,e),ut=n(e),oe=i(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1bwnzmb"&&(oe.textContent=ss),ht=n(e),r(ie.$$.fragment,e),dt=n(e),pe=i(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1k0zco1"&&(pe.textContent=as),mt=n(e),r(ce.$$.fragment,e),yt=n(e),re=i(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-scpch6"&&(re.textContent=ls),Mt=n(e),ue=i(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-1d2h65c"&&(ue.innerHTML=ns),Tt=n(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-ohejod"&&(he.textContent=os),ft=n(e),r(de.$$.fragment,e),jt=n(e),me=i(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-lzrdax"&&(me.textContent=is),Jt=n(e),r(ye.$$.fragment,e),wt=n(e),r(Me.$$.fragment,e),Ut=n(e),Je=i(e,"P",{}),ps(Je).forEach(s),this.h()},h(){fe(y,"name","hf:doc:metadata"),fe(y,"content",js),fe(M,"start","2"),fe(T,"start","3"),fe(f,"class","tip"),fe(j,"class","tip")},m(e,t){ys(document.head,y),a(e,we,t),a(e,je,t),a(e,Ue,t),u(w,e,t),a(e,be,t),u(U,e,t),a(e,_e,t),a(e,b,t),a(e,Ie,t),u(_,e,t),a(e,Ce,t),a(e,I,t),a(e,ge,t),a(e,C,t),a(e,ve,t),a(e,g,t),a(e,qe,t),a(e,v,t),a(e,Be,t),a(e,q,t),a(e,Ee,t),a(e,M,t),a(e,ke,t),a(e,B,t),a(e,$e,t),u(E,e,t),a(e,Ae,t),a(e,k,t),a(e,Ze,t),a(e,$,t),a(e,xe,t),a(e,A,t),a(e,Ve,t),a(e,T,t),a(e,Fe,t),a(e,Z,t),a(e,Le,t),u(x,e,t),a(e,Qe,t),a(e,V,t),a(e,He,t),u(F,e,t),a(e,Re,t),a(e,L,t),a(e,Xe,t),a(e,Q,t),a(e,We,t),u(H,e,t),a(e,Ge,t),a(e,R,t),a(e,Pe,t),a(e,X,t),a(e,Ye,t),a(e,W,t),a(e,Ne,t),a(e,G,t),a(e,Se,t),a(e,P,t),a(e,ze,t),a(e,f,t),a(e,De,t),a(e,Y,t),a(e,Oe,t),a(e,N,t),a(e,Ke,t),a(e,j,t),a(e,et,t),a(e,S,t),a(e,tt,t),u(z,e,t),a(e,st,t),a(e,D,t),a(e,at,t),u(O,e,t),a(e,lt,t),a(e,K,t),a(e,nt,t),u(ee,e,t),a(e,ot,t),a(e,te,t),a(e,it,t),a(e,se,t),a(e,pt,t),u(ae,e,t),a(e,ct,t),a(e,le,t),a(e,rt,t),u(ne,e,t),a(e,ut,t),a(e,oe,t),a(e,ht,t),u(ie,e,t),a(e,dt,t),a(e,pe,t),a(e,mt,t),u(ce,e,t),a(e,yt,t),a(e,re,t),a(e,Mt,t),a(e,ue,t),a(e,Tt,t),a(e,he,t),a(e,ft,t),u(de,e,t),a(e,jt,t),a(e,me,t),a(e,Jt,t),u(ye,e,t),a(e,wt,t),u(Me,e,t),a(e,Ut,t),a(e,Je,t),bt=!0},p:rs,i(e){bt||(h(w.$$.fragment,e),h(U.$$.fragment,e),h(_.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(z.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(ae.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(ye.$$.fragment,e),h(Me.$$.fragment,e),bt=!0)},o(e){d(w.$$.fragment,e),d(U.$$.fragment,e),d(_.$$.fragment,e),d(E.$$.fragment,e),d(x.$$.fragment,e),d(F.$$.fragment,e),d(H.$$.fragment,e),d(z.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ye.$$.fragment,e),d(Me.$$.fragment,e),bt=!1},d(e){e&&(s(we),s(je),s(Ue),s(be),s(_e),s(b),s(Ie),s(Ce),s(I),s(ge),s(C),s(ve),s(g),s(qe),s(v),s(Be),s(q),s(Ee),s(M),s(ke),s(B),s($e),s(Ae),s(k),s(Ze),s($),s(xe),s(A),s(Ve),s(T),s(Fe),s(Z),s(Le),s(Qe),s(V),s(He),s(Re),s(L),s(Xe),s(Q),s(We),s(Ge),s(R),s(Pe),s(X),s(Ye),s(W),s(Ne),s(G),s(Se),s(P),s(ze),s(f),s(De),s(Y),s(Oe),s(N),s(Ke),s(j),s(et),s(S),s(tt),s(st),s(D),s(at),s(lt),s(K),s(nt),s(ot),s(te),s(it),s(se),s(pt),s(ct),s(le),s(rt),s(ut),s(oe),s(ht),s(dt),s(pe),s(mt),s(yt),s(re),s(Mt),s(ue),s(Tt),s(he),s(ft),s(jt),s(me),s(Jt),s(wt),s(Ut),s(Je)),s(y),m(w,e),m(U,e),m(_,e),m(E,e),m(x,e),m(F,e),m(H,e),m(z,e),m(O,e),m(ee,e),m(ae,e),m(ne,e),m(ie,e),m(ce,e),m(de,e),m(ye,e),m(Me,e)}}}const js='{"title":"PEFT checkpoint format","local":"peft-checkpoint-format","sections":[{"title":"PEFT files","local":"peft-files","sections":[],"depth":2},{"title":"Convert to PEFT format","local":"convert-to-peft-format","sections":[{"title":"adapter_model","local":"adaptermodel","sections":[],"depth":3},{"title":"adapter_config","local":"adapterconfig","sections":[],"depth":3}],"depth":2},{"title":"Model storage","local":"model-storage","sections":[{"title":"Merge the weights","local":"merge-the-weights","sections":[],"depth":3},{"title":"Convert to a Transformers model","local":"convert-to-a-transformers-model","sections":[],"depth":3}],"depth":2}],"depth":1}';function Js(_t){return us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends hs{constructor(y){super(),ds(this,y,Js,fs,cs,{})}}export{Is as component};
