import{s as ut,n as ct,o as ht}from"../chunks/scheduler.78382b47.js";import{S as Mt,i as yt,e as r,s,c as p,h as bt,a as o,d as a,b as n,f as mt,g as f,j as i,k as Ye,l as gt,m as l,n as d,t as m,o as u,p as c}from"../chunks/index.6dd35eb6.js";import{C as wt,H as Ee,E as Tt}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca101b6.js";import{C as h}from"../chunks/CodeBlock.c942b99c.js";function Jt(qe){let M,ae,ee,le,g,se,w,ne,T,Qe='PEFT’s practical benefits extends to other Hugging Face libraries like <a href="https://hf.co/docs/diffusers" rel="nofollow">Diffusers</a> and <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a>. One of the main benefits of PEFT is that an adapter file generated by a PEFT method is a lot smaller than the original model, which makes it super easy to manage and use multiple adapters. You can use one pretrained base model for multiple tasks by simply loading a new adapter finetuned for the task you’re solving. Or you can combine multiple adapters with a text-to-image diffusion model to create new effects.',re,J,Se="This tutorial will show you how PEFT can help you manage adapters in Diffusers and Transformers.",oe,$,ie,Z,Ne="Diffusers is a generative AI library for creating images and videos from text or images with diffusion models. LoRA is an especially popular training method for diffusion models because you can very quickly train and share diffusion models to generate images in new styles. To make it easier to use and try multiple LoRA models, Diffusers uses the PEFT library to help manage different adapters for inference.",pe,_,Pe='For example, load a base model and then load the <a href="https://huggingface.co/artificialguybr/3DRedmond-V1" rel="nofollow">artificialguybr/3DRedmond-V1</a> adapter for inference with the <a href="https://huggingface.co/docs/diffusers/v0.24.0/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights" rel="nofollow"><code>load_lora_weights</code></a> method. The <code>adapter_name</code> argument in the loading method is enabled by PEFT and allows you to set a name for the adapter so it is easier to reference.',fe,j,de,y,ze='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers.png"/>',me,U,Ae='Now let’s try another cool LoRA model, <a href="https://huggingface.co/ostris/super-cereal-sdxl-lora" rel="nofollow">ostris/super-cereal-sdxl-lora</a>. All you need to do is load and name this new adapter with <code>adapter_name</code>, and use the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.set_adapters" rel="nofollow"><code>set_adapters</code></a> method to set it as the currently active adapter.',ue,v,ce,b,De='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/test-lora-diffusers-2.png"/>',he,W,Ke='Finally, you can call the <a href="https://huggingface.co/docs/diffusers/api/loaders/unet#diffusers.loaders.UNet2DConditionLoadersMixin.disable_lora" rel="nofollow"><code>disable_lora</code></a> method to restore the base model.',Me,k,ye,C,Oe='Learn more about how PEFT supports Diffusers in the <a href="https://huggingface.co/docs/diffusers/tutorials/using_peft_for_inference" rel="nofollow">Inference with PEFT</a> tutorial.',be,B,ge,G,et='🤗 <a href="https://hf.co/docs/transformers" rel="nofollow">Transformers</a> is a collection of pretrained models for all types of tasks in all modalities. You can load these models for training or inference. Many of the models are large language models (LLMs), so it makes sense to integrate PEFT with Transformers to manage and train adapters.',we,x,tt="Load a base pretrained model to train.",Te,L,Je,F,at='Next, add an adapter configuration to specify how to adapt the model parameters. Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the configuration to the base model.',$e,H,Ze,I,lt='Now you can train the model with Transformer’s <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class or whichever training framework you prefer.',_e,R,st='To use the newly trained model for inference, the <a href="https://huggingface.co/docs/transformers/main/en/model_doc/auto#transformers.AutoModel" rel="nofollow">AutoModel</a> class uses PEFT on the backend to load the adapter weights and configuration file into a base pretrained model.',je,X,Ue,V,nt='Alternatively, you can use transformers <a href="https://huggingface.co/docs/transformers/en/main_classes/pipelines" rel="nofollow">Pipelines</a> to load the model for conveniently running inference:',ve,Y,We,E,rt='If you’re interested in comparing or using more than one adapter, you can call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> method to add the adapter configuration to the base model. The only requirement is the adapter type must be the same (you can’t mix a LoRA and LoHa adapter).',ke,q,Ce,Q,ot='Call <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.add_adapter">add_adapter()</a> again to attach a new adapter to the base model.',Be,S,Ge,N,it='Then you can use <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.set_adapter">set_adapter()</a> to set the currently active adapter.',xe,P,Le,z,pt='To disable the adapter, call the <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L313" rel="nofollow">disable_adapters</a> method.',Fe,A,He,D,ft='The <a href="https://github.com/huggingface/transformers/blob/4e3490f79b40248c53ee54365a9662611e880892/src/transformers/integrations/peft.py#L336" rel="nofollow">enable_adapters</a> can be used to enable the adapters again.',Ie,K,dt='If you’re curious, check out the <a href="https://huggingface.co/docs/transformers/main/peft" rel="nofollow">Load and train adapters with PEFT</a> tutorial to learn more.',Re,O,Xe,te,Ve;return g=new wt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),w=new Ee({props:{title:"PEFT integrations",local:"peft-integrations",headingTag:"h1"}}),$=new Ee({props:{title:"Diffusers",local:"diffusers",headingTag:"h2"}}),j=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGYXJ0aWZpY2lhbGd1eWJyX18zRFJlZG1vbmQtVjElMjIlMkMlMjAlMEElMjAlMjAlMjAlMjB3ZWlnaHRfbmFtZSUzRCUyMjNEUmVkbW9uZC0zRFJlbmRlclN0eWxlLTNEUmVuZGVyQUYuc2FmZXRlbnNvcnMlMjIlMkMlMjAlMEElMjAlMjAlMjAlMjBhZGFwdGVyX25hbWUlM0QlMjIzZCUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnN1c2hpJTIwcm9sbHMlMjBzaGFwZWQlMjBsaWtlJTIwa2F3YWlpJTIwY2F0JTIwZmFjZXMlMjIpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.load_lora_weights(
    <span class="hljs-string">&quot;peft-internal-testing/artificialguybr__3DRedmond-V1&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;3DRedmond-3DRenderStyle-3DRenderAF.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;3d&quot;</span>
)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),v=new h({props:{code:"cGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyb3N0cmlzJTJGc3VwZXItY2VyZWFsLXNkeGwtbG9yYSUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHdlaWdodF9uYW1lJTNEJTIyY2VyZWFsX2JveF9zZHhsX3YxLnNhZmV0ZW5zb3JzJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEJTIyY2VyZWFsJTIyJTBBKSUwQXBpcGVsaW5lLnNldF9hZGFwdGVycyglMjJjZXJlYWwlMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMjJzdXNoaSUyMHJvbGxzJTIwc2hhcGVkJTIwbGlrZSUyMGthd2FpaSUyMGNhdCUyMGZhY2VzJTIyKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`pipeline.load_lora_weights(
    <span class="hljs-string">&quot;ostris/super-cereal-sdxl-lora&quot;</span>, 
    weight_name=<span class="hljs-string">&quot;cereal_box_sdxl_v1.safetensors&quot;</span>, 
    adapter_name=<span class="hljs-string">&quot;cereal&quot;</span>
)
pipeline.set_adapters(<span class="hljs-string">&quot;cereal&quot;</span>)
image = pipeline(<span class="hljs-string">&quot;sushi rolls shaped like kawaii cat faces&quot;</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),k=new h({props:{code:"cGlwZWxpbmUuZGlzYWJsZV9sb3JhKCk=",highlighted:"pipeline.disable_lora()",wrap:!1}}),B=new Ee({props:{title:"Transformers",local:"transformers",headingTag:"h2"}}),L=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)`,wrap:!1}}),H=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvcmFfYWxwaGElM0QxNiUyQyUwQSUyMCUyMCUyMCUyMGxvcmFfZHJvcG91dCUzRDAuMSUyQyUwQSUyMCUyMCUyMCUyMHIlM0Q2NCUyQyUwQSUyMCUyMCUyMCUyMGJpYXMlM0QlMjJub25lJTIyJTJDJTBBJTIwJTIwJTIwJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTBBKSUwQW1vZGVsLmFkZF9hZGFwdGVyKHBlZnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

peft_config = LoraConfig(
    lora_alpha=<span class="hljs-number">16</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
    r=<span class="hljs-number">64</span>,
    bias=<span class="hljs-string">&quot;none&quot;</span>,
    task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>
)
model.add_adapter(peft_config)`,wrap:!1}}),X=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIycGVmdC1pbnRlcm5hbC10ZXN0aW5nJTJGb3B0LTM1MG0tbG9yYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)`,wrap:!1}}),Y=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBbW9kZWwlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjAlMjJwZWZ0LWludGVybmFsLXRlc3RpbmclMkZvcHQtMzUwbS1sb3JhJTIyKSUwQXByaW50KG1vZGVsKCUyMkhlbGxvJTIwV29ybGQlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

model = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;peft-internal-testing/opt-350m-lora&quot;</span>)
<span class="hljs-built_in">print</span>(model(<span class="hljs-string">&quot;Hello World&quot;</span>))`,wrap:!1}}),q=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMzUwbSUyMiklMEFtb2RlbC5hZGRfYWRhcHRlcihsb3JhX2NvbmZpZ18xJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl8xJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)
model.add_adapter(lora_config_1, adapter_name=<span class="hljs-string">&quot;adapter_1&quot;</span>)`,wrap:!1}}),S=new h({props:{code:"bW9kZWwuYWRkX2FkYXB0ZXIobG9yYV9jb25maWdfMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmFkYXB0ZXJfMiUyMik=",highlighted:'model.add_adapter(lora_config_2, adapter_name=<span class="hljs-string">&quot;adapter_2&quot;</span>)',wrap:!1}}),P=new h({props:{code:"bW9kZWwuc2V0X2FkYXB0ZXIoJTIyYWRhcHRlcl8xJTIyKSUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0X2Rpc2FibGVkJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`model.set_adapter(<span class="hljs-string">&quot;adapter_1&quot;</span>)
output = model.generate(**inputs)
<span class="hljs-built_in">print</span>(tokenizer.decode(output_disabled[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),A=new h({props:{code:"bW9kZWwuZGlzYWJsZV9hZGFwdGVycygp",highlighted:"model.disable_adapters()",wrap:!1}}),O=new Tt({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/tutorial/peft_integrations.md"}}),{c(){M=r("meta"),ae=s(),ee=r("p"),le=s(),p(g.$$.fragment),se=s(),p(w.$$.fragment),ne=s(),T=r("p"),T.innerHTML=Qe,re=s(),J=r("p"),J.textContent=Se,oe=s(),p($.$$.fragment),ie=s(),Z=r("p"),Z.textContent=Ne,pe=s(),_=r("p"),_.innerHTML=Pe,fe=s(),p(j.$$.fragment),de=s(),y=r("div"),y.innerHTML=ze,me=s(),U=r("p"),U.innerHTML=Ae,ue=s(),p(v.$$.fragment),ce=s(),b=r("div"),b.innerHTML=De,he=s(),W=r("p"),W.innerHTML=Ke,Me=s(),p(k.$$.fragment),ye=s(),C=r("p"),C.innerHTML=Oe,be=s(),p(B.$$.fragment),ge=s(),G=r("p"),G.innerHTML=et,we=s(),x=r("p"),x.textContent=tt,Te=s(),p(L.$$.fragment),Je=s(),F=r("p"),F.innerHTML=at,$e=s(),p(H.$$.fragment),Ze=s(),I=r("p"),I.innerHTML=lt,_e=s(),R=r("p"),R.innerHTML=st,je=s(),p(X.$$.fragment),Ue=s(),V=r("p"),V.innerHTML=nt,ve=s(),p(Y.$$.fragment),We=s(),E=r("p"),E.innerHTML=rt,ke=s(),p(q.$$.fragment),Ce=s(),Q=r("p"),Q.innerHTML=ot,Be=s(),p(S.$$.fragment),Ge=s(),N=r("p"),N.innerHTML=it,xe=s(),p(P.$$.fragment),Le=s(),z=r("p"),z.innerHTML=pt,Fe=s(),p(A.$$.fragment),He=s(),D=r("p"),D.innerHTML=ft,Ie=s(),K=r("p"),K.innerHTML=dt,Re=s(),p(O.$$.fragment),Xe=s(),te=r("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(a),ae=n(e),ee=o(e,"P",{}),mt(ee).forEach(a),le=n(e),f(g.$$.fragment,e),se=n(e),f(w.$$.fragment,e),ne=n(e),T=o(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-a6a8i"&&(T.innerHTML=Qe),re=n(e),J=o(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-4mutq9"&&(J.textContent=Se),oe=n(e),f($.$$.fragment,e),ie=n(e),Z=o(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-d4l0h1"&&(Z.textContent=Ne),pe=n(e),_=o(e,"P",{"data-svelte-h":!0}),i(_)!=="svelte-rcmzt6"&&(_.innerHTML=Pe),fe=n(e),f(j.$$.fragment,e),de=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(y)!=="svelte-1cw2tql"&&(y.innerHTML=ze),me=n(e),U=o(e,"P",{"data-svelte-h":!0}),i(U)!=="svelte-4vggr3"&&(U.innerHTML=Ae),ue=n(e),f(v.$$.fragment,e),ce=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),i(b)!=="svelte-pvy16"&&(b.innerHTML=De),he=n(e),W=o(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-dtlzi"&&(W.innerHTML=Ke),Me=n(e),f(k.$$.fragment,e),ye=n(e),C=o(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-1nfye23"&&(C.innerHTML=Oe),be=n(e),f(B.$$.fragment,e),ge=n(e),G=o(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-1b1b0a9"&&(G.innerHTML=et),we=n(e),x=o(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-luca6i"&&(x.textContent=tt),Te=n(e),f(L.$$.fragment,e),Je=n(e),F=o(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-ycm3gd"&&(F.innerHTML=at),$e=n(e),f(H.$$.fragment,e),Ze=n(e),I=o(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-rsm0q6"&&(I.innerHTML=lt),_e=n(e),R=o(e,"P",{"data-svelte-h":!0}),i(R)!=="svelte-11qdvon"&&(R.innerHTML=st),je=n(e),f(X.$$.fragment,e),Ue=n(e),V=o(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1xfm1"&&(V.innerHTML=nt),ve=n(e),f(Y.$$.fragment,e),We=n(e),E=o(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-1vwya0n"&&(E.innerHTML=rt),ke=n(e),f(q.$$.fragment,e),Ce=n(e),Q=o(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1pcj5p1"&&(Q.innerHTML=ot),Be=n(e),f(S.$$.fragment,e),Ge=n(e),N=o(e,"P",{"data-svelte-h":!0}),i(N)!=="svelte-ug4ykr"&&(N.innerHTML=it),xe=n(e),f(P.$$.fragment,e),Le=n(e),z=o(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-lfmda3"&&(z.innerHTML=pt),Fe=n(e),f(A.$$.fragment,e),He=n(e),D=o(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1orofvq"&&(D.innerHTML=ft),Ie=n(e),K=o(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1o6emrm"&&(K.innerHTML=dt),Re=n(e),f(O.$$.fragment,e),Xe=n(e),te=o(e,"P",{}),mt(te).forEach(a),this.h()},h(){Ye(M,"name","hf:doc:metadata"),Ye(M,"content",$t),Ye(y,"class","flex justify-center"),Ye(b,"class","flex justify-center")},m(e,t){gt(document.head,M),l(e,ae,t),l(e,ee,t),l(e,le,t),d(g,e,t),l(e,se,t),d(w,e,t),l(e,ne,t),l(e,T,t),l(e,re,t),l(e,J,t),l(e,oe,t),d($,e,t),l(e,ie,t),l(e,Z,t),l(e,pe,t),l(e,_,t),l(e,fe,t),d(j,e,t),l(e,de,t),l(e,y,t),l(e,me,t),l(e,U,t),l(e,ue,t),d(v,e,t),l(e,ce,t),l(e,b,t),l(e,he,t),l(e,W,t),l(e,Me,t),d(k,e,t),l(e,ye,t),l(e,C,t),l(e,be,t),d(B,e,t),l(e,ge,t),l(e,G,t),l(e,we,t),l(e,x,t),l(e,Te,t),d(L,e,t),l(e,Je,t),l(e,F,t),l(e,$e,t),d(H,e,t),l(e,Ze,t),l(e,I,t),l(e,_e,t),l(e,R,t),l(e,je,t),d(X,e,t),l(e,Ue,t),l(e,V,t),l(e,ve,t),d(Y,e,t),l(e,We,t),l(e,E,t),l(e,ke,t),d(q,e,t),l(e,Ce,t),l(e,Q,t),l(e,Be,t),d(S,e,t),l(e,Ge,t),l(e,N,t),l(e,xe,t),d(P,e,t),l(e,Le,t),l(e,z,t),l(e,Fe,t),d(A,e,t),l(e,He,t),l(e,D,t),l(e,Ie,t),l(e,K,t),l(e,Re,t),d(O,e,t),l(e,Xe,t),l(e,te,t),Ve=!0},p:ct,i(e){Ve||(m(g.$$.fragment,e),m(w.$$.fragment,e),m($.$$.fragment,e),m(j.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(B.$$.fragment,e),m(L.$$.fragment,e),m(H.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(q.$$.fragment,e),m(S.$$.fragment,e),m(P.$$.fragment,e),m(A.$$.fragment,e),m(O.$$.fragment,e),Ve=!0)},o(e){u(g.$$.fragment,e),u(w.$$.fragment,e),u($.$$.fragment,e),u(j.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(B.$$.fragment,e),u(L.$$.fragment,e),u(H.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(q.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(A.$$.fragment,e),u(O.$$.fragment,e),Ve=!1},d(e){e&&(a(ae),a(ee),a(le),a(se),a(ne),a(T),a(re),a(J),a(oe),a(ie),a(Z),a(pe),a(_),a(fe),a(de),a(y),a(me),a(U),a(ue),a(ce),a(b),a(he),a(W),a(Me),a(ye),a(C),a(be),a(ge),a(G),a(we),a(x),a(Te),a(Je),a(F),a($e),a(Ze),a(I),a(_e),a(R),a(je),a(Ue),a(V),a(ve),a(We),a(E),a(ke),a(Ce),a(Q),a(Be),a(Ge),a(N),a(xe),a(Le),a(z),a(Fe),a(He),a(D),a(Ie),a(K),a(Re),a(Xe),a(te)),a(M),c(g,e),c(w,e),c($,e),c(j,e),c(v,e),c(k,e),c(B,e),c(L,e),c(H,e),c(X,e),c(Y,e),c(q,e),c(S,e),c(P,e),c(A,e),c(O,e)}}}const $t='{"title":"PEFT integrations","local":"peft-integrations","sections":[{"title":"Diffusers","local":"diffusers","sections":[],"depth":2},{"title":"Transformers","local":"transformers","sections":[],"depth":2}],"depth":1}';function Zt(qe){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends Mt{constructor(M){super(),yt(this,M,Zt,Jt,ut,{})}}export{Wt as component};
