import{s as dl,n as ml,o as yl}from"../chunks/scheduler.78382b47.js";import{S as hl,i as ul,e as p,s as a,c as i,h as Jl,a as o,d as s,b as n,f as cl,g as M,j as y,k as He,l as wl,m as t,n as r,t as c,o as d,p as m}from"../chunks/index.6dd35eb6.js";import{C as Tl,H as le,E as Ul}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca101b6.js";import{C as h}from"../chunks/CodeBlock.c942b99c.js";function fl(Fe){let u,ae,se,ne,T,pe,U,oe,f,Se='<a href="../conceptual_guides/ia3">IA3</a> multiplies the model’s activations (the keys and values in the self-attention and encoder-decoder attention blocks, and the intermediate activation of the position-wise feedforward network) by three learned vectors. This PEFT method introduces an even smaller number of trainable parameters than LoRA which introduces weight matrices instead of vectors. The original model’s parameters are kept frozen and only these vectors are updated. As a result, it is faster, cheaper and more efficient to finetune for a new downstream task.',ie,b,qe="This guide will show you how to train a sequence-to-sequence model with IA3 to <em>generate a sentiment</em> given some financial news.",Me,J,Le='<p>Some familiarity with the general process of training a sequence-to-sequence would be really helpful and allow you to focus on how to apply IA3. If you’re new, we recommend taking a look at the <a href="https://huggingface.co/docs/transformers/tasks/translation" rel="nofollow">Translation</a> and <a href="https://huggingface.co/docs/transformers/tasks/summarization" rel="nofollow">Summarization</a> guides first from the Transformers documentation. When you’re ready, come back and see how easy it is to drop PEFT in to your training!</p>',re,j,ce,C,Ke='You’ll use the sentences_allagree subset of the <a href="https://huggingface.co/datasets/financial_phrasebank" rel="nofollow">financial_phrasebank</a> dataset. This subset contains financial news with 100% annotator agreement on the sentiment label. Take a look at the <a href="https://huggingface.co/datasets/financial_phrasebank/viewer/sentences_allagree" rel="nofollow">dataset viewer</a> for a better idea of the data and sentences you’ll be working with.',de,I,Pe='Load the dataset with the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/loading_methods#datasets.load_dataset" rel="nofollow">load_dataset</a> function. This subset of the dataset only contains a train split, so use the <code>train_test_split</code> function to create a train and validation split. Create a new <code>text_label</code> column so it is easier to understand what the <code>label</code> values <code>0</code>, <code>1</code>, and <code>2</code> mean.',me,g,ye,_,De="Load a tokenizer and create a preprocessing function that:",he,Z,Oe="<li>tokenizes the inputs, pads and truncates the sequence to the <code>max_length</code></li> <li>apply the same tokenizer to the labels but with a shorter <code>max_length</code> that corresponds to the label</li> <li>mask the padding tokens</li>",ue,k,Je,G,el='Use the <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> function to apply the preprocessing function to the entire dataset.',we,W,Te,B,ll='Create a training and evaluation <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow"><code>DataLoader</code></a>, and set <code>pin_memory=True</code> to speed up data transfer to the accelerator during training if your dataset samples are on a CPU.',Ue,v,fe,X,be,R,sl='Now you can load a pretrained model to use as the base model for IA3. This guide uses the <a href="https://huggingface.co/bigscience/mt0-large" rel="nofollow">bigscience/mt0-large</a> model, but you can use any sequence-to-sequence model you like.',je,V,Ce,N,Ie,Y,tl='All PEFT methods need a configuration that contains and specifies all the parameters for how the PEFT method should be applied. Create an <a href="/docs/peft/main/en/package_reference/ia3#peft.IA3Config">IA3Config</a> with the task type and set the inference mode to <code>False</code>. You can find additional parameters for this configuration in the <a href="../package_reference/ia3#ia3config">API reference</a>.',ge,w,al='<p>Call the <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.print_trainable_parameters">print_trainable_parameters()</a> method to compare the number of trainable parameters of <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> versus the number of parameters in the base model!</p>',_e,Q,nl='Once the configuration is setup, pass it to the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function along with the base model to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Ze,$,ke,z,Ge,x,pl="Set up an optimizer and learning rate scheduler.",We,E,Be,A,ol="Move the model to the accelerator and create a training loop that reports the loss and perplexity for each epoch.",ve,H,Xe,F,Re,S,il='After training is complete, you can upload your model to the Hub with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> method. You’ll need to login to your Hugging Face account first and enter your token when prompted.',Ve,q,Ne,L,Ye,K,Ml='To load the model for inference, use the <a href="/docs/peft/main/en/package_reference/auto_class#peft.AutoPeftModel.from_pretrained">from_pretrained()</a> method. Let’s also load a sentence of financial news from the dataset to generate a sentiment for.',Qe,P,$e,D,rl='Call the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate" rel="nofollow">generate</a> method to generate the predicted sentiment label.',ze,O,xe,ee,Ee,te,Ae;return T=new Tl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new le({props:{title:"IA3",local:"ia3",headingTag:"h1"}}),j=new le({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),g=new h({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyZmluYW5jaWFsX3BocmFzZWJhbmslMjIlMkMlMjAlMjJzZW50ZW5jZXNfYWxsYWdyZWUlMjIpJTBBZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQWRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUyMCUzRCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQWRlbCUyMGRzJTVCJTIydGVzdCUyMiU1RCUwQSUwQWNsYXNzZXMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELmZlYXR1cmVzJTVCJTIybGFiZWwlMjIlNUQubmFtZXMlMEFkcyUyMCUzRCUyMGRzLm1hcCglMEElMjAlMjAlMjAlMjBsYW1iZGElMjB4JTNBJTIwJTdCJTIydGV4dF9sYWJlbCUyMiUzQSUyMCU1QmNsYXNzZXMlNUJsYWJlbCU1RCUyMGZvciUyMGxhYmVsJTIwaW4lMjB4JTVCJTIybGFiZWwlMjIlNUQlNUQlN0QlMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSklMEElMEFkcyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RCUwQSU3QidzZW50ZW5jZSclM0ElMjAnSXQlMjB3aWxsJTIwYmUlMjBvcGVyYXRlZCUyMGJ5JTIwTm9raWElMjAlMkMlMjBhbmQlMjBzdXBwb3J0ZWQlMjBieSUyMGl0cyUyME5va2lhJTIwTmV0QWN0JTIwbmV0d29yayUyMGFuZCUyMHNlcnZpY2UlMjBtYW5hZ2VtZW50JTIwc3lzdGVtJTIwLiclMkMlMEElMjAnbGFiZWwnJTNBJTIwMSUyQyUwQSUyMCd0ZXh0X2xhYmVsJyUzQSUyMCduZXV0cmFsJyU3RA==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;financial_phrasebank&quot;</span>, <span class="hljs-string">&quot;sentences_allagree&quot;</span>)
ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
ds[<span class="hljs-string">&quot;validation&quot;</span>] = ds[<span class="hljs-string">&quot;test&quot;</span>]
<span class="hljs-keyword">del</span> ds[<span class="hljs-string">&quot;test&quot;</span>]

classes = ds[<span class="hljs-string">&quot;train&quot;</span>].features[<span class="hljs-string">&quot;label&quot;</span>].names
ds = ds.<span class="hljs-built_in">map</span>(
    <span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;text_label&quot;</span>: [classes[label] <span class="hljs-keyword">for</span> label <span class="hljs-keyword">in</span> x[<span class="hljs-string">&quot;label&quot;</span>]]},
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
)

ds[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;sentence&#x27;</span>: <span class="hljs-string">&#x27;It will be operated by Nokia , and supported by its Nokia NetAct network and service management system .&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text_label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}`,wrap:!1}}),k=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0ZXh0X2NvbHVtbiUyMCUzRCUyMCUyMnNlbnRlbmNlJTIyJTBBbGFiZWxfY29sdW1uJTIwJTNEJTIwJTIydGV4dF9sYWJlbCUyMiUwQW1heF9sZW5ndGglMjAlM0QlMjAxMjglMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwZXhhbXBsZXMlNUJ0ZXh0X2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjBleGFtcGxlcyU1QmxhYmVsX2NvbHVtbiU1RCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihpbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEbWF4X2xlbmd0aCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0YXJnZXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHRydW5jYXRpb24lM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMjAlMjAlMjAlMjBsYWJlbHMlMjAlM0QlMjBsYWJlbHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMEElMjAlMjAlMjAlMjBsYWJlbHMlNUJsYWJlbHMlMjAlM0QlM0QlMjB0b2tlbml6ZXIucGFkX3Rva2VuX2lkJTVEJTIwJTNEJTIwLTEwMCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lucHV0cyU1QiUyMmxhYmVscyUyMiU1RCUyMCUzRCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1vZGVsX2lucHV0cw==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

text_column = <span class="hljs-string">&quot;sentence&quot;</span>
label_column = <span class="hljs-string">&quot;text_label&quot;</span>
max_length = <span class="hljs-number">128</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
    inputs = examples[text_column]
    targets = examples[label_column]
    model_inputs = tokenizer(inputs, max_length=max_length, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = tokenizer(targets, max_length=<span class="hljs-number">3</span>, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    labels = labels[<span class="hljs-string">&quot;input_ids&quot;</span>]
    labels[labels == tokenizer.pad_token_id] = -<span class="hljs-number">100</span>
    model_inputs[<span class="hljs-string">&quot;labels&quot;</span>] = labels
    <span class="hljs-keyword">return</span> model_inputs`,wrap:!1}}),W=new h({props:{code:"cHJvY2Vzc2VkX2RzJTIwJTNEJTIwZHMubWFwKCUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3NfZnVuY3Rpb24lMkMlMEElMjAlMjAlMjAlMjBiYXRjaGVkJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9wcm9jJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV9jb2x1bW5zJTNEZHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXMlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Zyb21fY2FjaGVfZmlsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZGVzYyUzRCUyMlJ1bm5pbmclMjB0b2tlbml6ZXIlMjBvbiUyMGRhdGFzZXQlMjIlMkMlMEEp",highlighted:`processed_ds = ds.<span class="hljs-built_in">map</span>(
    preprocess_function,
    batched=<span class="hljs-literal">True</span>,
    num_proc=<span class="hljs-number">1</span>,
    remove_columns=ds[<span class="hljs-string">&quot;train&quot;</span>].column_names,
    load_from_cache_file=<span class="hljs-literal">False</span>,
    desc=<span class="hljs-string">&quot;Running tokenizer on dataset&quot;</span>,
)`,wrap:!1}}),v=new h({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGRlZmF1bHRfZGF0YV9jb2xsYXRvciUwQSUwQXRyYWluX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydHJhaW4lMjIlNUQlMEFldmFsX2RzJTIwJTNEJTIwcHJvY2Vzc2VkX2RzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCUwQSUwQWJhdGNoX3NpemUlMjAlM0QlMjA4JTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5fZHMlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlJTBBKSUwQWV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoZXZhbF9kcyUyQyUyMGNvbGxhdGVfZm4lM0RkZWZhdWx0X2RhdGFfY29sbGF0b3IlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMHBpbl9tZW1vcnklM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> default_data_collator

train_ds = processed_ds[<span class="hljs-string">&quot;train&quot;</span>]
eval_ds = processed_ds[<span class="hljs-string">&quot;validation&quot;</span>]

batch_size = <span class="hljs-number">8</span>

train_dataloader = DataLoader(
    train_ds, shuffle=<span class="hljs-literal">True</span>, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>
)
eval_dataloader = DataLoader(eval_ds, collate_fn=default_data_collator, batch_size=batch_size, pin_memory=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new le({props:{title:"Model",local:"model",headingTag:"h2"}}),V=new h({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM

model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)`,wrap:!1}}),N=new le({props:{title:"PEFT configuration and model",local:"peft-configuration-and-model",headingTag:"h3"}}),$=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBJQTNDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQXBlZnRfY29uZmlnJTIwJTNEJTIwSUEzQ29uZmlnKHRhc2tfdHlwZSUzRCUyMlNFUV8yX1NFUV9MTSUyMiklMEFtb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWcpJTBBbW9kZWwucHJpbnRfdHJhaW5hYmxlX3BhcmFtZXRlcnMoKSUwQSUyMnRyYWluYWJsZSUyMHBhcmFtcyUzQSUyMDI4MiUyQzYyNCUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDElMkMyMjklMkM4NjMlMkM5MzYlMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjAyMjk4MDEwMzA2MDc2NjU1MyUyMg==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> IA3Config, get_peft_model

peft_config = IA3Config(task_type=<span class="hljs-string">&quot;SEQ_2_SEQ_LM&quot;</span>)
model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;trainable params: 282,624 || all params: 1,229,863,936 || trainable%: 0.022980103060766553&quot;</span>`,wrap:!1}}),z=new le({props:{title:"Training",local:"training",headingTag:"h3"}}),E=new h({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwZ2V0X2xpbmVhcl9zY2hlZHVsZV93aXRoX3dhcm11cCUwQSUwQWxyJTIwJTNEJTIwOGUtMyUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0RsciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfbGluZWFyX3NjaGVkdWxlX3dpdGhfd2FybXVwKCUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEKGxlbih0cmFpbl9kYXRhbG9hZGVyKSUyMColMjBudW1fZXBvY2hzKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_linear_schedule_with_warmup

lr = <span class="hljs-number">8e-3</span>
num_epochs = <span class="hljs-number">3</span>

optimizer = torch.optim.AdamW(model.parameters(), lr=lr)
lr_scheduler = get_linear_schedule_with_warmup(
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=(<span class="hljs-built_in">len</span>(train_dataloader) * num_epochs),
)`,wrap:!1}}),H=new h({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>
model = model.to(device)

<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    model.train()
    total_loss = <span class="hljs-number">0</span>
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(train_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        total_loss += loss.detach().<span class="hljs-built_in">float</span>()
        loss.backward()
        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()

    model.<span class="hljs-built_in">eval</span>()
    eval_loss = <span class="hljs-number">0</span>
    eval_preds = []
    <span class="hljs-keyword">for</span> step, batch <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(tqdm(eval_dataloader)):
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        <span class="hljs-keyword">with</span> torch.no_grad():
            outputs = model(**batch)
        loss = outputs.loss
        eval_loss += loss.detach().<span class="hljs-built_in">float</span>()
        eval_preds.extend(
            tokenizer.batch_decode(torch.argmax(outputs.logits, -<span class="hljs-number">1</span>).detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)
        )

    eval_epoch_loss = eval_loss / <span class="hljs-built_in">len</span>(eval_dataloader)
    eval_ppl = torch.exp(eval_epoch_loss)
    train_epoch_loss = total_loss / <span class="hljs-built_in">len</span>(train_dataloader)
    train_ppl = torch.exp(train_epoch_loss)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{epoch=}</span>: <span class="hljs-subst">{train_ppl=}</span> <span class="hljs-subst">{train_epoch_loss=}</span> <span class="hljs-subst">{eval_ppl=}</span> <span class="hljs-subst">{eval_epoch_loss=}</span>&quot;</span>)`,wrap:!1}}),F=new le({props:{title:"Share your model",local:"share-your-model",headingTag:"h2"}}),q=new h({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBYWNjb3VudCUyMCUzRCUyMCUzQ3lvdXItaGYtYWNjb3VudC1uYW1lJTNFJTBBcGVmdF9tb2RlbF9pZCUyMCUzRCUyMGYlMjIlN0JhY2NvdW50JTdEJTJGbXQwLWxhcmdlLWlhMyUyMiUwQW1vZGVsLnB1c2hfdG9faHViKHBlZnRfbW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

account = &lt;your-hf-account-name&gt;
peft_model_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{account}</span>/mt0-large-ia3&quot;</span>
model.push_to_hub(peft_model_id)`,wrap:!1}}),L=new le({props:{title:"Inference",local:"inference",headingTag:"h2"}}),P=new h({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b1BlZnRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTNDeW91ci1oZi1hY2NvdW50LW5hbWUlM0UlMkZtdDAtbGFyZ2UtaWEzJTIyKS50byhkZXZpY2UpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRm10MC1sYXJnZSUyMiklMEElMEFpJTIwJTNEJTIwMTUlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTVCdGV4dF9jb2x1bW4lNUQlNUJpJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludChkcyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlNUJ0ZXh0X2NvbHVtbiU1RCU1QmklNUQpJTBBJTIyVGhlJTIwcm9idXN0JTIwZ3Jvd3RoJTIwd2FzJTIwdGhlJTIwcmVzdWx0JTIwb2YlMjB0aGUlMjBpbmNsdXNpb24lMjBvZiUyMGNsb3RoaW5nJTIwY2hhaW4lMjBMaW5kZXglMjBpbiUyMHRoZSUyMEdyb3VwJTIwaW4lMjBEZWNlbWJlciUyMDIwMDclMjAuJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForSeq2SeqLM

device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

model = AutoPeftModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;&lt;your-hf-account-name&gt;/mt0-large-ia3&quot;</span>).to(device)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)

i = <span class="hljs-number">15</span>
inputs = tokenizer(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(ds[<span class="hljs-string">&quot;validation&quot;</span>][text_column][i])
<span class="hljs-string">&quot;The robust growth was the result of the inclusion of clothing chain Lindex in the Group in December 2007 .&quot;</span>`,wrap:!1}}),O=new h({props:{code:"d2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElNUIncG9zaXRpdmUnJTVE",highlighted:`<span class="hljs-keyword">with</span> torch.no_grad():
    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
    outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">10</span>)
    <span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;positive&#x27;</span>]`,wrap:!1}}),ee=new Ul({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/task_guides/ia3.md"}}),{c(){u=p("meta"),ae=a(),se=p("p"),ne=a(),i(T.$$.fragment),pe=a(),i(U.$$.fragment),oe=a(),f=p("p"),f.innerHTML=Se,ie=a(),b=p("p"),b.innerHTML=qe,Me=a(),J=p("blockquote"),J.innerHTML=Le,re=a(),i(j.$$.fragment),ce=a(),C=p("p"),C.innerHTML=Ke,de=a(),I=p("p"),I.innerHTML=Pe,me=a(),i(g.$$.fragment),ye=a(),_=p("p"),_.textContent=De,he=a(),Z=p("ol"),Z.innerHTML=Oe,ue=a(),i(k.$$.fragment),Je=a(),G=p("p"),G.innerHTML=el,we=a(),i(W.$$.fragment),Te=a(),B=p("p"),B.innerHTML=ll,Ue=a(),i(v.$$.fragment),fe=a(),i(X.$$.fragment),be=a(),R=p("p"),R.innerHTML=sl,je=a(),i(V.$$.fragment),Ce=a(),i(N.$$.fragment),Ie=a(),Y=p("p"),Y.innerHTML=tl,ge=a(),w=p("blockquote"),w.innerHTML=al,_e=a(),Q=p("p"),Q.innerHTML=nl,Ze=a(),i($.$$.fragment),ke=a(),i(z.$$.fragment),Ge=a(),x=p("p"),x.textContent=pl,We=a(),i(E.$$.fragment),Be=a(),A=p("p"),A.textContent=ol,ve=a(),i(H.$$.fragment),Xe=a(),i(F.$$.fragment),Re=a(),S=p("p"),S.innerHTML=il,Ve=a(),i(q.$$.fragment),Ne=a(),i(L.$$.fragment),Ye=a(),K=p("p"),K.innerHTML=Ml,Qe=a(),i(P.$$.fragment),$e=a(),D=p("p"),D.innerHTML=rl,ze=a(),i(O.$$.fragment),xe=a(),i(ee.$$.fragment),Ee=a(),te=p("p"),this.h()},l(e){const l=Jl("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(s),ae=n(e),se=o(e,"P",{}),cl(se).forEach(s),ne=n(e),M(T.$$.fragment,e),pe=n(e),M(U.$$.fragment,e),oe=n(e),f=o(e,"P",{"data-svelte-h":!0}),y(f)!=="svelte-s2qd7"&&(f.innerHTML=Se),ie=n(e),b=o(e,"P",{"data-svelte-h":!0}),y(b)!=="svelte-xoc01f"&&(b.innerHTML=qe),Me=n(e),J=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(J)!=="svelte-teq66z"&&(J.innerHTML=Le),re=n(e),M(j.$$.fragment,e),ce=n(e),C=o(e,"P",{"data-svelte-h":!0}),y(C)!=="svelte-20qrnk"&&(C.innerHTML=Ke),de=n(e),I=o(e,"P",{"data-svelte-h":!0}),y(I)!=="svelte-xnp209"&&(I.innerHTML=Pe),me=n(e),M(g.$$.fragment,e),ye=n(e),_=o(e,"P",{"data-svelte-h":!0}),y(_)!=="svelte-aqyjx7"&&(_.textContent=De),he=n(e),Z=o(e,"OL",{"data-svelte-h":!0}),y(Z)!=="svelte-1xhy766"&&(Z.innerHTML=Oe),ue=n(e),M(k.$$.fragment,e),Je=n(e),G=o(e,"P",{"data-svelte-h":!0}),y(G)!=="svelte-ww7yef"&&(G.innerHTML=el),we=n(e),M(W.$$.fragment,e),Te=n(e),B=o(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-kwwkxd"&&(B.innerHTML=ll),Ue=n(e),M(v.$$.fragment,e),fe=n(e),M(X.$$.fragment,e),be=n(e),R=o(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1d06z94"&&(R.innerHTML=sl),je=n(e),M(V.$$.fragment,e),Ce=n(e),M(N.$$.fragment,e),Ie=n(e),Y=o(e,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-gbvacv"&&(Y.innerHTML=tl),ge=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),y(w)!=="svelte-1eb563c"&&(w.innerHTML=al),_e=n(e),Q=o(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-mz5vce"&&(Q.innerHTML=nl),Ze=n(e),M($.$$.fragment,e),ke=n(e),M(z.$$.fragment,e),Ge=n(e),x=o(e,"P",{"data-svelte-h":!0}),y(x)!=="svelte-tlkvop"&&(x.textContent=pl),We=n(e),M(E.$$.fragment,e),Be=n(e),A=o(e,"P",{"data-svelte-h":!0}),y(A)!=="svelte-166cxn8"&&(A.textContent=ol),ve=n(e),M(H.$$.fragment,e),Xe=n(e),M(F.$$.fragment,e),Re=n(e),S=o(e,"P",{"data-svelte-h":!0}),y(S)!=="svelte-q5liq1"&&(S.innerHTML=il),Ve=n(e),M(q.$$.fragment,e),Ne=n(e),M(L.$$.fragment,e),Ye=n(e),K=o(e,"P",{"data-svelte-h":!0}),y(K)!=="svelte-19b2iba"&&(K.innerHTML=Ml),Qe=n(e),M(P.$$.fragment,e),$e=n(e),D=o(e,"P",{"data-svelte-h":!0}),y(D)!=="svelte-1dkx89x"&&(D.innerHTML=rl),ze=n(e),M(O.$$.fragment,e),xe=n(e),M(ee.$$.fragment,e),Ee=n(e),te=o(e,"P",{}),cl(te).forEach(s),this.h()},h(){He(u,"name","hf:doc:metadata"),He(u,"content",bl),He(J,"class","tip"),He(w,"class","tip")},m(e,l){wl(document.head,u),t(e,ae,l),t(e,se,l),t(e,ne,l),r(T,e,l),t(e,pe,l),r(U,e,l),t(e,oe,l),t(e,f,l),t(e,ie,l),t(e,b,l),t(e,Me,l),t(e,J,l),t(e,re,l),r(j,e,l),t(e,ce,l),t(e,C,l),t(e,de,l),t(e,I,l),t(e,me,l),r(g,e,l),t(e,ye,l),t(e,_,l),t(e,he,l),t(e,Z,l),t(e,ue,l),r(k,e,l),t(e,Je,l),t(e,G,l),t(e,we,l),r(W,e,l),t(e,Te,l),t(e,B,l),t(e,Ue,l),r(v,e,l),t(e,fe,l),r(X,e,l),t(e,be,l),t(e,R,l),t(e,je,l),r(V,e,l),t(e,Ce,l),r(N,e,l),t(e,Ie,l),t(e,Y,l),t(e,ge,l),t(e,w,l),t(e,_e,l),t(e,Q,l),t(e,Ze,l),r($,e,l),t(e,ke,l),r(z,e,l),t(e,Ge,l),t(e,x,l),t(e,We,l),r(E,e,l),t(e,Be,l),t(e,A,l),t(e,ve,l),r(H,e,l),t(e,Xe,l),r(F,e,l),t(e,Re,l),t(e,S,l),t(e,Ve,l),r(q,e,l),t(e,Ne,l),r(L,e,l),t(e,Ye,l),t(e,K,l),t(e,Qe,l),r(P,e,l),t(e,$e,l),t(e,D,l),t(e,ze,l),r(O,e,l),t(e,xe,l),r(ee,e,l),t(e,Ee,l),t(e,te,l),Ae=!0},p:ml,i(e){Ae||(c(T.$$.fragment,e),c(U.$$.fragment,e),c(j.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(W.$$.fragment,e),c(v.$$.fragment,e),c(X.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c($.$$.fragment,e),c(z.$$.fragment,e),c(E.$$.fragment,e),c(H.$$.fragment,e),c(F.$$.fragment,e),c(q.$$.fragment,e),c(L.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),Ae=!0)},o(e){d(T.$$.fragment,e),d(U.$$.fragment,e),d(j.$$.fragment,e),d(g.$$.fragment,e),d(k.$$.fragment,e),d(W.$$.fragment,e),d(v.$$.fragment,e),d(X.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d($.$$.fragment,e),d(z.$$.fragment,e),d(E.$$.fragment,e),d(H.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(L.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),Ae=!1},d(e){e&&(s(ae),s(se),s(ne),s(pe),s(oe),s(f),s(ie),s(b),s(Me),s(J),s(re),s(ce),s(C),s(de),s(I),s(me),s(ye),s(_),s(he),s(Z),s(ue),s(Je),s(G),s(we),s(Te),s(B),s(Ue),s(fe),s(be),s(R),s(je),s(Ce),s(Ie),s(Y),s(ge),s(w),s(_e),s(Q),s(Ze),s(ke),s(Ge),s(x),s(We),s(Be),s(A),s(ve),s(Xe),s(Re),s(S),s(Ve),s(Ne),s(Ye),s(K),s(Qe),s($e),s(D),s(ze),s(xe),s(Ee),s(te)),s(u),m(T,e),m(U,e),m(j,e),m(g,e),m(k,e),m(W,e),m(v,e),m(X,e),m(V,e),m(N,e),m($,e),m(z,e),m(E,e),m(H,e),m(F,e),m(q,e),m(L,e),m(P,e),m(O,e),m(ee,e)}}}const bl='{"title":"IA3","local":"ia3","sections":[{"title":"Dataset","local":"dataset","sections":[],"depth":2},{"title":"Model","local":"model","sections":[{"title":"PEFT configuration and model","local":"peft-configuration-and-model","sections":[],"depth":3},{"title":"Training","local":"training","sections":[],"depth":3}],"depth":2},{"title":"Share your model","local":"share-your-model","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function jl(Fe){return yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zl extends hl{constructor(u){super(),ul(this,u,jl,fl,dl,{})}}export{Zl as component};
