import{s as hr,n as fr,o as ur}from"../chunks/scheduler.78382b47.js";import{S as Mr,i as wr,e as o,s as n,c as p,h as yr,a as i,d as a,b as s,f as Ha,g as d,j as r,k as Z,l as w,m as l,n as m,t as c,o as h,p as f}from"../chunks/index.6dd35eb6.js";import{C as br,H as M,E as Tr}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.9ca101b6.js";import{C as u}from"../chunks/CodeBlock.c942b99c.js";function gr(fo){let T,Qa,Fa,Ea,U,za,B,qa,I,uo='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',Na,$,Mo="This guide explores in more detail other options and features for using LoRA.",Sa,C,Pa,R,wo='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',Da,W,yo='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',Ka,L,Oa,G,bo="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",el,A,tl,V,al,X,To='<a href="https://huggingface.co/papers/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',ll,x,go="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",nl,F,sl,Y,Jo="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",ol,H,il,Q,jo='For detailed instruction on using PiSSA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',rl,E,pl,z,_o=`<a href="https://huggingface.co/papers/2406.05223" rel="nofollow">CorDA</a> builds task-aware LoRA adapters from weight decomposition oriented by the context of downstream task to learn (instruction-previewed mode, IPM) or world knowledge to maintain (knowledge-preserved mode, KPM).
The KPM not only achieves better performance than LoRA on fine-tuning tasks, but also mitigates the catastrophic forgetting of pre-trained world knowledge.
When preserving pre-trained knowledge is not a concern,
the IPM is favored because it can further accelerate convergence and enhance the fine-tuning performance.`,dl,q,vo="You need to configure the initialization method to “corda”, and specify the mode of IPM or KPM and the dataset to collect covariance matrices.",ml,N,cl,S,ko='For detailed instruction on using CorDA, please follow <a href="https://github.com/huggingface/peft/tree/main/examples/corda_finetuning" rel="nofollow">these instructions</a>.',hl,P,fl,D,Zo='<a href="https://huggingface.co/papers/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',ul,K,Uo="You just need to pass a single additional option to use OLoRA:",Ml,O,wl,ee,Bo='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',yl,te,bl,ae,Io='<a href="https://huggingface.co/papers/2410.07170" rel="nofollow">EVA</a> performs SVD on the input activations of each layer and uses the right-singular vectors to initialize LoRA weights. It is therefore a data-driven initialization scheme. Furthermore EVA adaptively allocates ranks across layers based on their “explained variance ratio” - a metric derived from the SVD analysis.',Tl,le,$o='You can use EVA by setting <code>init_lora_weights=&quot;eva&quot;</code> and defining <a href="/docs/peft/main/en/package_reference/lora#peft.EvaConfig">EvaConfig</a> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>:',gl,ne,Jl,se,Co="The parameter <code>rho</code> (≥ 1.0) determines how much redistribution is allowed. When <code>rho=1.0</code> and <code>r=16</code>, LoRA adapters are limited to exactly 16 ranks, preventing any redistribution from occurring. A recommended value for EVA with redistribution is 2.0, meaning the maximum rank allowed for a layer is 2r.",jl,oe,Ro='It is recommended to perform EVA initialization on an accelerator(e.g. CUDA GPU, Intel XPU) as it is much faster. To optimize the amount of available memory for EVA, you can use the <code>low_cpu_mem_usage</code> flag in <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a>:',_l,ie,vl,re,Wo='Then, call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> to initialize the EVA weights (in most cases the dataloader used for eva initialization can be the same as the one used for finetuning):',kl,pe,Zl,de,Lo='EVA works out of the box with bitsandbytes. Simply initialize the model with <code>quantization_config</code> and call <a href="/docs/peft/main/en/package_reference/lora#peft.initialize_lora_eva_weights">initialize_lora_eva_weights()</a> as usual.',Ul,J,Go='<p>For further instructions on using EVA, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/eva_finetuning" rel="nofollow">documentation</a>.</p>',Bl,me,Il,ce,$l,he,Ao='When quantizing the base model for QLoRA training, consider using the <a href="https://huggingface.co/papers/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Cl,fe,Vo="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Rl,ue,Wl,Me,Xo="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",Ll,we,Gl,ye,xo='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Al,be,Fo="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratively updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Vl,Te,Yo="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",Xl,ge,Ho="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",xl,j,Qo='<p>Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.</p>',Fl,Je,Yl,je,Eo='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',Hl,_e,Ql,ve,El,ke,zo='Activated LoRA (aLoRA) is a low rank adapter architecture for Causal LMs that allows for reusing existing base model KV cache for more efficient inference. This approach is best suited for inference pipelines which rely on the base model for most tasks/generations, but use aLoRA adapter(s) to perform specialized task(s) within the chain. For example, checking or correcting generated outputs of the base model. In these settings, inference times can be sped up by an order of magnitude or more. For more information on aLoRA and many example use cases, see <a href="https://huggingface.co/papers/2504.12397" rel="nofollow">https://huggingface.co/papers/2504.12397</a>.',zl,Ze,qo="This technique scans for the last occurence of an invocation sequence (<code>alora_invocation_tokens</code>) in each input (this can be as short as 1 token), and activates the adapter weights on tokens starting with the beginning of the invocation sequence (any inputs after the invocation sequence are also adapted, and all generated tokens will use the adapted weights). Weights on prior tokens are left un-adapted — making the cache for those tokens interchangeable with base model cache due to the causal attention mask in Causal LMs. Usage is very similar to standard LoRA, with the key difference that this invocation sequence must be specified when the adapter is created:",ql,Ue,Nl,Be,No="where <code>alora_invocation_tokens</code> is a list of integer token ids. Given a desired invocation string, this can be obtained as",Sl,Ie,Pl,$e,So="where the tokenizer is the tokenizer for the base model. Note that we have <code>add_special_tokens=False</code> to avoid adding SOS/EOS tokens in our search string (which will most likely cause failure to find).",Dl,Ce,Po="<strong>Notes</strong>",Kl,Re,Do='<li>aLoRA is only supported for <code>task_type=CAUSAL_LM</code> tasks due to its focus on cache reuse.</li> <li>Since the weights are adapted on fewer tokens, often (not always) aLoRA requires higher rank (<code>r</code>) than LoRA. <code>r=32</code> can be a good starting point.</li> <li>aLoRA weights cannot be merged into the base model by definition, since the adapter weights are selectively applied to a subset of tokens. Attempts to merge will throw errors.</li> <li>Beam search is not yet supported.</li> <li>It is generally not recommended to add new tokens to the tokenizer that are not present in the base model, as this can complicate the target use case of both the base model and adapter model operating on overlapping context. That said, there is a possible workaround by first efficiently adding <a href="https://huggingface.co/docs/peft/en/package_reference/trainable_tokens" rel="nofollow">trainable tokens</a> to the base model prior to training the adapter.</li>',Ol,We,en,Le,Ko=`Each input must have the <code>alora_invocation_tokens</code> sequence present, it is not added automatically. To maximize model performance without compromising cache reuse, it is recommended to have the adapter weights activated early, i.e. at the start of any adapter-specific prompting, but after any long inputs such as prior generations or documents. As with any model,
formatting should be consistent between train and test.`,tn,Ge,Oo=`Consider the following example, where the base model has a chat template,
and the goal is to train the adapter to generate a desired output.`,an,Ae,ei="<li>Option 1: If there is no task-specific prompt, i.e. the input is a chat history with the <code>assistant</code> prompt, then the chat template’s <code>assistant</code> prompt (e.g. <code>&lt;|start_of_role|&gt;assistant&lt;|end_of_role|&gt;</code>) is a natural choice for the invocation string. See the model’s chat template to find the prompt for the model.</li> <li>Option 2: If there is a task-specific prompt for the adapter that describes the task the adapter is learning, and that prompt is put as a <code>user</code> turn immediately prior to the generation, then the chat template’s <code>user</code> prompt (e.g. <code>&lt;|start_of_role|&gt;user&lt;|end_of_role|&gt;</code>) is a natural choice for the invocation string.</li>",ln,Ve,ti="Once deciding on an invocation string, get the model tokenizer and obtain <code>alora_invocation_tokens</code> as",nn,Xe,sn,xe,ai='An example inference setup is at <a href="https://github.com/huggingface/peft/blob/main/examples/alora_finetuning/alora_finetuning.py" rel="nofollow">alora finetuning</a>.',on,Fe,li="<strong>Note</strong> If using custom strings for the invocation string, make sure that the start and end of the string are special tokens to avoid issues with tokenization at the boundaries.",rn,Ye,ni="To see why, imagine that ‘a’, ‘b’, ‘c’, and ‘ab’ are tokens in your tokenizer (numbers 1, 2, 3, 4 respectively). Suppose that your alora_invocation_tokens = [2, 3]. Now imagine your input string is “abc”. Because “ab” is a token, this will get tokenized as [4,3]. So the alora_invocation_tokens will fail to be found, despite the string “bc” being in it. If the start and end of the invocation string are special tokens, however, this failure case will never happen since special tokens are never tokenized into the same token with other characters.",pn,He,dn,Qe,si="The main purpose of Activated LoRA is to make KV cache interchangeable between the base model and aLoRA adapter models <strong>prior to the invocation sequence</strong> since base and adapted KV values are not compatible. Specifically, keys and values stored during one model generation can be used in subsequent generations to avoid expensive prefill operations for context tokens. When sharing cache between the base model and aLoRA adapters, there are 2 main patterns:",mn,Ee,oi="<li>The base model has generated something, and an aLoRA adapter is then called to do a followup generation. Example: the base model answers a question, and an aLoRA trained to detect hallucinations checks the base model response.</li> <li>An aLoRA adapter has generated something, and the base model or a different aLoRA adapter is called to do a followup generation where there is partial context overlap with the original aLoRA. Example: The user provides a query, and an aLoRA rewrites the query to be more self-contained and improve retrieval in a RAG system. Then, documents are retrieved and loaded into context, an aLoRA checks if these documents are indeed relevant to the question, and then the base model generates an answer.</li>",cn,ze,ii='To demonstrate the above behaviors when using caching, we’re using <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">DynamicCache</a> from <code>transformers</code>. Care must be taken to ensure that adapted cache values are not mixed with base cache values. In particular, an extra step is required for sharing the cache when there is partial context overlap (pattern 2).',hn,qe,ri="<strong>Pattern 1: Base model followed by aLoRA</strong> Here, the entire input and generation from the base model is input into the aLoRA adapter, along with the invocation sequence:",fn,Ne,un,Se,pi="<strong>Pattern 2: aLoRA generation followed by base model (or another aLoRA) with partial context overlap</strong> Here, we prefill the shared context using the base model, and then generate.",Mn,Pe,wn,De,yn,Ke,di='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://huggingface.co/papers/2402.09353" rel="nofollow">https://huggingface.co/papers/2402.09353</a>.',bn,Oe,Tn,et,mi="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",gn,tt,Jn,at,ci="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",jn,lt,_n,nt,hi=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 ZE_AFFINITY_MASK=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,vn,st,fi='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',kn,ot,Zn,it,ui='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',Un,rt,Bn,pt,Mi='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',In,dt,$n,mt,Cn,ct,wi='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://huggingface.co/papers/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',Rn,ht,Wn,ft,yi='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',Ln,ut,bi=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,Gn,Mt,An,wt,Ti='By default, all layers targeted with LoRA will have the same rank <code>r</code> and the same <code>lora_alpha</code> (which determines the LoRA scaling), depending on what was specified in the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. In some cases, however, you may want to indicate different values for different layers. This is possible by passing the <code>rank_pattern</code> and <code>alpha_pattern</code> arguments to <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. These arguments should be dictionaries with the key being the layer name and the value being the rank/alpha value. The keys can be <a href="https://docs.python.org/3/library/re.html" rel="nofollow">regular expressions</a> (regex). All LoRA layers that are not explicitly mentioned in <code>rank_pattern</code> and <code>alpha_pattern</code> will take the default <code>r</code> and <code>lora_alpha</code> values.',Vn,yt,gi="To give an example, let’s assume that we have a model with the following structure:",Xn,bt,xn,Tt,Ji="<li><code>rank_pattern={&quot;foo&quot;: 42}</code> will match all 3 <code>foo</code> layers. Neither <code>foobar</code> nor <code>barfoo</code> are matched.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42}</code> will only match the <code>foo</code> layer of the model, but neither <code>module.foo</code> nor <code>module.module.foo</code>. This is because the <code>^</code> means “start of string” when using regular expressions, and only <code>foo</code> starts with <code>&quot;foo&quot;</code>, the other layer names have prefixes.</li> <li><code>rank_pattern={&quot;^module.foo&quot;: 42}</code> matches only <code>module.foo</code>, but not <code>module.module.foo</code>, for the same reason.</li> <li><code>rank_pattern={&quot;module.foo&quot;: 42}</code> matches both <code>module.foo</code> and <code>module.module.foo</code>, but not <code>foo</code>.</li> <li><code>rank_pattern={&quot;^foo&quot;: 42, &quot;^module.module.foo&quot;: 55}</code> matches <code>foo</code> and <code>module.module.foo</code>, respectively, but not <code>module.foo</code>.</li> <li>There is no need to indicate <code>$</code> to mark the end of the match, as this is added automatically by PEFT.</li>",Fn,gt,ji="The same logic applies to <code>alpha_pattern</code>. If you’re in doubt, don’t try to get fancy with regular expressions — just pass the full name for each module with a different rank/alpha, preceded by the <code>^</code> prefix, and you should be good.",Yn,Jt,Hn,_,_i="<p>This feature is experimental and subject to change.</p>",Qn,jt,vi='Generally, you should use <code>target_modules</code> to target the module (e.g. <code>nn.Linear</code>). However, in some circumstances, this is not possible. E.g., in many mixture of expert (MoE) layers in HF Transformers, instead of using <code>nn.Linear</code>, an <code>nn.Parameter</code> is used. PEFT normally overwrites the <code>forward</code> method for LoRA, but for <code>nn.Parameter</code>, there is none. Therefore, to apply LoRA to that parameter, it needs to be targeted with <code>target_parameters</code>. As an example, for <a href="https://huggingface.co/collections/meta-llama/llama-4-67f0c30d9fe03840bc9d0164" rel="nofollow">Llama4</a>, you can pass: <code>target_parameters=[&#39;feed_forward.experts.gate_up_proj&#39;, &#39;feed_forward.experts.down_proj]</code>.',En,_t,zn,vt,ki="<li>At the moment, this argument allows to target 2-dim or 3-dim <code>nn.Parameter</code>s. It is assumed that in the case of a 3-dim parameter, the 0th dimension is the expert dimension.</li> <li>It is currently not possible to add multiple LoRA adapters (via <code>model.add_adapter</code> or <code>model.load_adapter</code>) that use <code>target_parameters</code> at the same time.</li>",qn,kt,Nn,Zt,Zi="LoRA training can optionally include special purpose optimizers. Currently PEFT supports LoRA-FA and LoRA+.",Sn,Ut,Pn,Bt,Ui='LoRA training can be more effective and efficient using LoRA-FA, as described in <a href="https://huggingface.co/papers/2308.03303" rel="nofollow">LoRA-FA</a>. LoRA-FA reduces activation memory consumption by fixing the matrix A and only tuning the matrix B. During training, the gradient of B is optimized to approximate the full parameter fine-tuning gradient. Moreover, the memory consumption of LoRA-FA is not sensitive to the rank (since it erases the activation of $A$), therefore it can improve performance by enlarging lora rank without increasing memory consumption.',Dn,It,Kn,$t,On,Ct,Bi='LoRA training can be optimized using <a href="https://huggingface.co/papers/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',es,Rt,ts,Wt,as,Lt,Ii='Sometimes it is necessary to not only change some layer’s weights but to add new tokens as well. With larger models this can be a memory-costly endeavour. PEFT LoRA adapters support the <code>trainable_token_indices</code> parameter which allows tuning of other tokens alongside fine-tuning of specific layers with LoRA. This method only trains the tokens you specify and leaves all other tokens untouched. This saves memory and doesn’t throw away learned context of existing token embeddings in contrast to when training the whole embedding matrix. Under the hood this method uses the layer of <a href="/docs/peft/main/en/package_reference/trainable_tokens#peft.TrainableTokensModel">TrainableTokensModel</a>.',ls,Gt,ns,At,$i="In the snippet below we show how to add new tokens to the model and how to train it alongside the other layers in the model.",ss,Vt,os,Xt,Ci=`The token weights are part of your adapter state dict and saved alongside the LoRA weights.
If we would have used full fine-tuning with <code>modules_to_save=[&#39;embed_tokens&#39;]</code> we would have stored the full embedding matrix in the checkpoint, leading to a much bigger file.`,is,xt,Ri="To give a bit of an indication how much VRAM can be saved, a rudimentary comparison of the above example was made between training the embedding matrix fully (<code>modules_to_save=[&quot;embed_tokens&quot;]</code>), using a LoRA for the embedding matrix (<code>target_modules=[..., &quot;embed_tokens&quot;]</code>, rank 32) and trainable tokens (<code>trainable_token_indices=[...]</code>, 6 tokens). Trainable tokens used about as much VRAM (15,562MB vs. 15,581MB) as LoRA while being specific to the tokens and saved ~1GB of VRAM over fully training the embedding matrix.",rs,Ft,ps,Yt,Wi='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',ds,Ht,Li="Below is a diagram that explains the intuition of LoRA adapter merging:",ms,v,Gi='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',cs,Qt,Ai="We show in the snippets below how to run that using PEFT.",hs,Et,fs,zt,Vi='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',us,qt,Ms,Nt,Xi='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',ws,St,xi="First load the base model:",ys,Pt,bs,Dt,Fi="Then we load the first adapter:",Ts,Kt,gs,Ot,Yi="Then load a different adapter and merge it with the first one:",Js,ea,js,k,Hi='<p>There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.</p>',_s,ta,Qi="Now, perform inference:",vs,aa,ks,la,Zs,na,Ei='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.set_adapter">set_adapter()</a> function.',Us,sa,Bs,oa,zi='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Is,ia,$s,ra,Cs,pa,qi="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",Rs,da,Ni="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Ws,ma,Ls,ca,Si="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",Gs,ha,As,fa,Pi="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Vs,ua,Di="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",Xs,Ma,xs,wa,Ki="Using this feature has some drawbacks, namely:",Fs,ya,Oi=`<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights were merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:
<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handful of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>`,Ys,ba,Hs,Ta,Qs,ga,er='<a href="https://huggingface.co/papers/2405.11157" rel="nofollow">Arrow</a> is a modular routing algorithm designed to combine multiple pre-trained task-specific LoRA adapters to solve a given task. Rather than merging all adapters naively, Arrow introduces a <strong>gradient-free, token-wise mixture-of-experts (MoE) routing mechanism</strong>. At inference time, it first computes a <em>prototype</em> for each LoRA by extracting the top right singular vector from its SVD decomposition. Each token representation is then compared to these prototypes via cosine similarity to obtain routing coefficients. Tokens are assigned to the top-k most relevant LoRA adapters, with the coefficients normalized through softmax, and their outputs linearly combined. This allows effective reuse of existing LoRA modules for new tasks and leads to stronger zero-shot generalization.',Es,Ja,tr="In PEFT, Arrow is enabled through <code>ArrowConfig</code> and <code>create_arrow_model</code>. You can also configure parameters such as <code>top_k</code> (the number of LoRA adapters combined per token), <code>router_temperature</code> (the softmax temperature applied to the routing coefficients), and <code>rng_seed</code> (for reproducibility).",zs,ja,qs,_a,ar="Furthermore, you can add or remove adapters after calling <code>create_arrow_model</code>—for example, to fine-tune a new adapter or discard an unnecessary one. Once the adapters are in place, you can activate the <code>&quot;arrow_router&quot;</code> for inference to use Arrow. Note that if you add a new LoRA adapter after <code>create_arrow_model</code> and want to fine-tune it, you must explicitly set the new adapter as active, since <code>&quot;arrow_router&quot;</code> is activated by default in <code>create_arrow_model</code>.",Ns,va,Ss,ka,Ps,Za,lr='<a href="https://aclanthology.org/2025.acl-short.54/" rel="nofollow">GenKnowSub</a> augments Arrow by purifying task-specific LoRA adapters before routing. The key idea is to subtract general knowledge encoded in LoRA space—based on the <a href="https://huggingface.co/papers/2212.04089" rel="nofollow">forgetting-via-negation principle</a>—so that task adapters become more isolated and focused on task-relevant signals. Concretely, GenKnowSub estimates a low-dimensional “general” subspace from a set of general (non task-specific) LoRA adapters and removes this component from each task adapter’s LoRA update prior to Arrow’s token-wise routing. This typically improves compositionality and reduces interference when combining many task adapters.',Ds,Ua,nr="In PEFT, enable GenKnowSub by setting <code>use_gks=True</code> in ArrowConfig, and providing <code>general_adapter_paths</code> in <code>create_arrow_model</code>:",Ks,Ba,Os,Ia,sr="To encode general knowledge, GenKnowSub subtracts the average of the provided general adapters from each task-specific adapter once, before routing begins. Furthermore, the ability to add or remove adapters after calling <code>create_arrow_model</code> (as described in the Arrow section) is still supported in this case.",eo,g,Wa,or="<strong>Things to keep in mind when using Arrow + GenKnowSub:</strong>",oo,y,La,ir="<p>All LoRA adapters (task-specific and general) must share the same <code>rank</code> and <code>target_modules</code>.</p>",io,Ga,rr="<p>Any inconsistency in these settings will raise an error in <code>create_arrow_model</code>.</p>",ro,Aa,pr="<p>Having different scaling factors (<code>lora_alpha</code>) across task adapters is supported — Arrow handles them automatically.</p>",po,Va,dr="<p>Merging the <code>&quot;arrow_router&quot;</code> is not supported, due to its dynamic routing behavior.</p>",mo,Xa,mr="<p>In create_arrow_model, task adapters are loaded as <code>task_i</code> and general adapters as <code>gks_j</code> (where <code>i</code> and <code>j</code> are indices). The function ensures consistency of <code>target_modules</code>, <code>rank</code>, and whether adapters are applied to <code>Linear</code> or <code>Linear4bit</code> layers. It then adds the <code>&quot;arrow_router&quot;</code> module and activates it. Any customization of this process requires overriding <code>create_arrow_model</code>.</p>",co,$a,xa,cr="This implementation is compatible with 4-bit quantization (via bitsandbytes):",ho,Ca,to,Ra,ao,Ya,lo;return U=new br({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),B=new M({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),C=new M({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),L=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),A=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),V=new M({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),F=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),H=new u({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLik=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...)',wrap:!1}}),E=new M({props:{title:"CorDA",local:"corda",headingTag:"h3"}}),N=new u({props:{code:"JTQwdG9yY2gubm9fZ3JhZCgpJTBBZGVmJTIwcnVuX21vZGVsKCklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBc3N1bWUlMjAlNjBtb2RlbCU2MCUyMGFuZCUyMCU2MGRhdGFzZXQlNjAlMjBpcyUyMGluJTIwY29udGV4dC4uLiUwQSUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBkYXRhc2V0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwoKipiYXRjaCklMEElMEElMEFjb3JkYV9jb25maWclMjAlM0QlMjBDb3JkYUNvbmZpZyglMEElMjAlMjAlMjAlMjBjb3JkYV9tZXRob2QlM0QlMjJrcG0lMjIlMkMlMEEpJTBBbG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTNEJTIyY29yZGElMjIlMkMlMEElMjAlMjAlMjAlMjBjb3JkYV9jb25maWclM0Rjb3JkYV9jb25maWclMkMlMEEpJTBBcHJlcHJvY2Vzc19jb3JkYShtb2RlbCUyQyUyMGxvcmFfY29uZmlnJTJDJTIwcnVuX21vZGVsJTNEcnVuX21vZGVsKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGxvcmFfY29uZmlnKQ==",highlighted:`<span class="hljs-meta">@torch.no_grad()</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_model</span>():
    <span class="hljs-comment"># Assume \`model\` and \`dataset\` is in context...</span>
    model.<span class="hljs-built_in">eval</span>()
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> dataset:
        model(**batch)


corda_config = CordaConfig(
    corda_method=<span class="hljs-string">&quot;kpm&quot;</span>,
)
lora_config = LoraConfig(
    init_lora_weights=<span class="hljs-string">&quot;corda&quot;</span>,
    corda_config=corda_config,
)
preprocess_corda(model, lora_config, run_model=run_model)
peft_model = get_peft_model(model, lora_config)`,wrap:!1}}),P=new M({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),O=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),te=new M({props:{title:"EVA",local:"eva",headingTag:"h3"}}),ne=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwRXZhQ29uZmlnJTBBcGVmdF9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGluaXRfbG9yYV93ZWlnaHRzJTIwJTNEJTIwJTIyZXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwZXZhX2NvbmZpZyUyMCUzRCUyMEV2YUNvbmZpZyhyaG8lMjAlM0QlMjAyLjApJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, EvaConfig
peft_config = LoraConfig(
    init_lora_weights = <span class="hljs-string">&quot;eva&quot;</span>,
    eva_config = EvaConfig(rho = <span class="hljs-number">2.0</span>),
    ...
)`,wrap:!1}}),ie=new u({props:{code:"cGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKG1vZGVsJTJDJTIwcGVmdF9jb25maWclMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUp",highlighted:'peft_model = get_peft_model(model, peft_config, low_cpu_mem_usage=<span class="hljs-literal">True</span>)',wrap:!1}}),pe=new u({props:{code:"aW5pdGlhbGl6ZV9sb3JhX2V2YV93ZWlnaHRzKHBlZnRfbW9kZWwlMkMlMjBkYXRhbG9hZGVyKQ==",highlighted:"initialize_lora_eva_weights(peft_model, dataloader)",wrap:!1}}),me=new M({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),ce=new M({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),ue=new M({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),we=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),Je=new M({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),_e=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ve=new M({props:{title:"Activated LoRA (aLoRA)",local:"activated-lora-alora",headingTag:"h3"}}),Ue=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhhbG9yYV9pbnZvY2F0aW9uX3Rva2VucyUzRGFsb3JhX2ludm9jYXRpb25fdG9rZW5zJTJDJTIwdGFza190eXBlJTNEJTIyQ0FVU0FMX0xNJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(alora_invocation_tokens=alora_invocation_tokens, task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>, ...)`,wrap:!1}}),Ie=new u({props:{code:"aW52b2NhdGlvbl9zdHJpbmclMjAlM0QlMjAlMjJwbGFjZWhvbGRlciUyMiUwQWFsb3JhX2ludm9jYXRpb25fdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyLmVuY29kZShpbnZvY2F0aW9uX3N0cmluZyUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS4=",highlighted:`<span class="hljs-attr">invocation_string</span> = <span class="hljs-string">&quot;placeholder&quot;</span>
<span class="hljs-attr">alora_invocation_tokens</span> = tokenizer.encode(invocation_string, add_special_tokens=<span class="hljs-literal">False</span>).`,wrap:!1}}),We=new M({props:{title:"Choice of invocation sequence and SFT design",local:"choice-of-invocation-sequence-and-sft-design",headingTag:"h4"}}),Xe=new u({props:{code:"YWxvcmFfaW52b2NhdGlvbl90b2tlbnMlMjAlM0QlMjB0b2tlbml6ZXIuZW5jb2RlKGludm9jYXRpb25fc3RyaW5nJTJDJTIwYWRkX3NwZWNpYWxfdG9rZW5zJTNERmFsc2UpLg==",highlighted:'<span class="hljs-attr">alora_invocation_tokens</span> = tokenizer.encode(invocation_string, add_special_tokens=<span class="hljs-literal">False</span>).',wrap:!1}}),He=new M({props:{title:"Using (and reusing) cache for generation",local:"using-and-reusing-cache-for-generation",headingTag:"h4"}}),Ne=new u({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> transformers import DynamicCache
<span class="hljs-built_in">..</span>.
cache = DynamicCache()
inputs_base = tokenizer(prompt_base, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-comment"># Generate from base model and save cache</span>
with model_alora.disable_adapter(): 
    output = model_alora.generate(inputs_base[<span class="hljs-string">&quot;input_ids&quot;</span>].<span class="hljs-keyword">to</span>(device),<span class="hljs-attribute">attention_mask</span>=inputs_base[<span class="hljs-string">&quot;attention_mask&quot;</span>].<span class="hljs-keyword">to</span>(device),past_key_values = cache,<span class="hljs-attribute">return_dict_in_generate</span>=<span class="hljs-literal">True</span>)
output_text_base = tokenizer.decode(output.sequences[0])
cache = output.past_key_values

<span class="hljs-comment"># Generate with aLoRA adapter from cache</span>
prompt_alora = output_text + INVOCATION_STRING
inputs_alora = tokenizer(prompt_alora, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
output = model_alora.generate(**inputs_alora, <span class="hljs-attribute">past_key_values</span>=cache)
output_text_alora = tokenizer.decode(output[0])

<span class="hljs-comment"># <span class="hljs-doctag">Note:</span> cache is now tainted with adapter values and cannot be used in base model from here on!</span>`,wrap:!1}}),Pe=new u({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> transformers import DynamicCache
import copy
<span class="hljs-built_in">..</span>.
cache = DynamicCache()
inputs_shared = tokenizer(prompt_shared, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Prefill from base model and save cache</span>
with model_alora.disable_adapter():
    with torch.no_grad():
        model_alora(**inputs_shared, <span class="hljs-attribute">past_key_values</span>=cache)
cache_copy = copy.deepcopy(cache)

<span class="hljs-comment"># Generate from aLoRA using prefilled cache</span>
prompt_alora = prompt_shared + INVOCATION_STRING
inputs_alora = tokenizer(prompt_alora, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
output = model_alora.generate(**inputs_alora, <span class="hljs-attribute">past_key_values</span>=cache)
output_text_alora = tokenizer.decode(output[0])

<span class="hljs-comment"># Generate from base model using saved cache not tainted by aLoRA KV values</span>
prompt_base = prompt_shared
inputs_base = tokenizer(prompt_base, <span class="hljs-attribute">return_tensors</span>=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
with model_alora.disable_adapter(): 
    output = model_alora.generate(**inputs_base, <span class="hljs-attribute">past_key_values</span>=cache_copy)
output_text_base = tokenizer.decode(output[0])`,wrap:!1}}),De=new M({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),Oe=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),tt=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),lt=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),ot=new M({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),rt=new M({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),dt=new u({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),mt=new M({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),ht=new u({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),Mt=new M({props:{title:"Fine grained control over ranks and alpha (scaling)",local:"fine-grained-control-over-ranks-and-alpha-scaling",headingTag:"h3"}}),bt=new u({props:{code:"cHJpbnQobW9kZWwp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model)
Outer(
  (foo): Linear(...)
  (module): Middle(
    (foo): Linear(...)
    (foobar): Linear(...)
    (module): Inner(
      (foo): Linear(...)
      (barfoo): Linear(...)
    )
  )
)`,wrap:!1}}),Jt=new M({props:{title:"Targeting nn.Parameter directly",local:"targeting-nnparameter-directly",headingTag:"h3"}}),_t=new M({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),kt=new M({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),Ut=new M({props:{title:"LoRA-FA Optimizer",local:"lora-fa-optimizer",headingTag:"h3"}}),It=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwZ2V0X3BlZnRfbW9kZWwlMEFmcm9tJTIwcGVmdC5vcHRpbWl6ZXJzJTIwaW1wb3J0JTIwY3JlYXRlX2xvcmFmYV9vcHRpbWl6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUyQyUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIpJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4pJTBBbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwY29uZmlnKSUwQSUwQW9wdGltaXplciUyMCUzRCUyMGNyZWF0ZV9sb3JhZmFfb3B0aW1pemVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjByJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0Q3ZS01JTJDJTBBKSUwQSUwQXNjaGVkdWxlciUyMCUzRCUyMGdldF9jb3NpbmVfc2NoZWR1bGVfd2l0aF93YXJtdXAoJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRDEwMDAlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVycyUzRChvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIpJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_lorafa_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, get_cosine_schedule_with_warmup

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>)

config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_lorafa_optimizer(
    model=model,
    r=<span class="hljs-number">128</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lr=<span class="hljs-number">7e-5</span>,
)

scheduler = get_cosine_schedule_with_warmup(
    optimizer,
    num_warmup_steps=<span class="hljs-number">100</span>,
    num_training_steps=<span class="hljs-number">1000</span>,
)

trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),$t=new M({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),Rt=new u({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Wt=new M({props:{title:"Efficiently train tokens alongside LoRA",local:"efficiently-train-tokens-alongside-lora",headingTag:"h2"}}),Gt=new u({props:{code:"JTIzJTIwZm9yJTIwbGF5ZXIlMjAnZW1iZWRfdG9rZW5zJyUwQWNvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodHJhaW5hYmxlX3Rva2VuX2luZGljZXMlM0QlNUJpZHhfMSUyQyUyMGlkeF8yJTJDJTIwLi4uJTVEJTJDJTIwLi4uKSUwQSUwQSUyMyUyMHNwZWNpZmljJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYl90b2tlbnMnJTNBJTIwJTVCaWR4XzElMkMlMjBpZHhfMiUyQyUyMC4uLiU1RCU3RCUyQyUyMC4uLik=",highlighted:`<span class="hljs-comment"># for layer &#x27;embed_tokens&#x27;</span>
config = LoraConfig(trainable_token_indices=[idx_1, idx_2, ...], ...)

<span class="hljs-comment"># specific embedding layer</span>
config = LoraConfig(trainable_token_indices={<span class="hljs-string">&#x27;emb_tokens&#x27;</span>: [idx_1, idx_2, ...]}, ...)`,wrap:!1}}),Vt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwZ2V0X3BlZnRfbW9kZWwlMkMlMjBMb3JhQ29uZmlnJTBBJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLXYwLjElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQSUyMyUyMHdlJTIwZGVmaW5lJTIwb3VyJTIwbmV3JTIwdG9rZW5zJTIwYW5kJTIwYWRkJTIwdGhlbSUyMHRvJTIwdGhlJTIwdG9rZW5pemVyJTIwYXMlMjBzcGVjaWFsJTIwdG9rZW5zJTBBc3BlY2lhbF90b2tlbnMlMjAlM0QlMjAlNUInJTNDJTdDc3RhcnRfdGhpbmslN0MlM0UnJTJDJTIwJyUzQyU3Q3N0b3BfdGhpbmslN0MlM0UnJTVEJTBBdG9rZW5pemVyLmFkZF9zcGVjaWFsX3Rva2VucyglN0InYWRkaXRpb25hbF9zcGVjaWFsX3Rva2VucyclM0ElMjBzcGVjaWFsX3Rva2VucyU3RCklMEElMEElMjMlMjBtYWtlJTIwcm9vbSUyMGZvciUyMG5ldyUyMHRva2VucyUyMGluJTIwdGhlJTIwZW1iZWRkaW5nJTIwbWF0cml4JTIwaWYlMjBpdCUyMGlzbid0JTIwYmlnJTIwZW5vdWdoJTIwYWxyZWFkeSUwQWJhc2VfbW9kZWwucmVzaXplX3Rva2VuX2VtYmVkZGluZ3MobWF4KGxlbih0b2tlbml6ZXIpJTJDJTIwYmFzZV9tb2RlbC5tb2RlbC5lbWJlZF90b2tlbnMubnVtX2VtYmVkZGluZ3MpKSUwQSUwQSUyMyUyMHR5cGljYWwlMjBMb1JBJTIwY29uZmlnJTIwd2l0aCUyMCU2MHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTYwJTIwdGFyZ2V0aW5nJTIwZW1iZWRkaW5nJTIwbGF5ZXIlMjAlNjBlbWJlZF90b2tlbnMlNjAlMEElMjMlMjBhbmQlMjBzcGVjaWZpY2FsbHklMjBvdXIlMjBuZXclMjB0b2tlbnMlMjB3ZSUyMGp1c3QlMjBhZGRlZCUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyglMEElMjAlMjAlMjAlMjB0YXJnZXRfbW9kdWxlcyUzRCdhbGwtbGluZWFyJyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluYWJsZV90b2tlbl9pbmRpY2VzJTNEJTdCJ2VtYmVkX3Rva2VucyclM0ElMjB0b2tlbml6ZXIuY29udmVydF90b2tlbnNfdG9faWRzKHNwZWNpYWxfdG9rZW5zKSU3RCUyQyUwQSklMEFwZWZ0X21vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwoYmFzZV9tb2RlbCUyQyUyMGxvcmFfY29uZmlnKSUwQSUwQSUyMyUyMHByb2NlZWQlMjB0byUyMHRyYWluJTIwdGhlJTIwbW9kZWwlMjBsaWtlJTIwbm9ybWFsJTBBJTVCLi4uJTVE",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model, LoraConfig

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

<span class="hljs-comment"># we define our new tokens and add them to the tokenizer as special tokens</span>
special_tokens = [<span class="hljs-string">&#x27;&lt;|start_think|&gt;&#x27;</span>, <span class="hljs-string">&#x27;&lt;|stop_think|&gt;&#x27;</span>]
tokenizer.add_special_tokens({<span class="hljs-string">&#x27;additional_special_tokens&#x27;</span>: special_tokens})

<span class="hljs-comment"># make room for new tokens in the embedding matrix if it isn&#x27;t big enough already</span>
base_model.resize_token_embeddings(<span class="hljs-built_in">max</span>(<span class="hljs-built_in">len</span>(tokenizer), base_model.model.embed_tokens.num_embeddings))

<span class="hljs-comment"># typical LoRA config with \`trainable_token_indices\` targeting embedding layer \`embed_tokens\`</span>
<span class="hljs-comment"># and specifically our new tokens we just added</span>
lora_config = LoraConfig(
    target_modules=<span class="hljs-string">&#x27;all-linear&#x27;</span>,
    trainable_token_indices={<span class="hljs-string">&#x27;embed_tokens&#x27;</span>: tokenizer.convert_tokens_to_ids(special_tokens)},
)
peft_model = get_peft_model(base_model, lora_config)

<span class="hljs-comment"># proceed to train the model like normal</span>
[...]`,wrap:!1}}),Ft=new M({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Et=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),qt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Pt=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),Kt=new u({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),ea=new u({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),aa=new u({props:{code:"ZGV2aWNlJTIwJTNEJTIwdG9yY2guYWNjZWxlcmF0b3IuY3VycmVudF9hY2NlbGVyYXRvcigpLnR5cGUlMjBpZiUyMGhhc2F0dHIodG9yY2glMkMlMjAlMjJhY2NlbGVyYXRvciUyMiklMjBlbHNlJTIwJTIyY3VkYSUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJIZXklMkMlMjBhcmUlMjB5b3UlMjBjb25zY2lvdXMlM0YlMjBDYW4lMjB5b3UlMjB0YWxrJTIwdG8lMjBtZSUzRiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`device = torch.accelerator.current_accelerator().<span class="hljs-built_in">type</span> <span class="hljs-keyword">if</span> <span class="hljs-built_in">hasattr</span>(torch, <span class="hljs-string">&quot;accelerator&quot;</span>) <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),la=new M({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),sa=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ia=new u({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),ra=new M({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),ma=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),ha=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),Ma=new M({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),ba=new M({props:{title:"Composing and Reusing LoRA Adapters",local:"composing-and-reusing-lora-adapters",headingTag:"h2"}}),Ta=new M({props:{title:"Arrow",local:"arrow",headingTag:"h3"}}),ja=new u({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBjcmVhdGVfYXJyb3dfbW9kZWwlMkMlMjBBcnJvd0NvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMExvYWRpbmclMjB0aGUlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiklMEElMEElMjMlMjBDcmVhdGluZyUyMHRoZSUyMEFycm93JTIwY29uZmlnJTBBYXJyb3dfY29uZmlnJTIwJTNEJTIwQXJyb3dDb25maWcoJTBBJTIwJTIwJTIwJTIwdG9wX2slM0QzJTJDJTBBJTIwJTIwJTIwJTIwcm91dGVyX3RlbXBlcmF0dXJlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwcm5nX3NlZWQlM0Q0MiUyQyUwQSklMEElMEElMjMlMjBUaGUlMjBMb1JBJTIwYWRhcHRlcnMlMjBiZWxvdyUyMHdlcmUlMjB0cmFpbmVkJTIwb24lMjBhJTIwY2x1c3RlcmVkJTIwRkxBTiUyMGRhdGFzZXQuJTBBJTIzJTIwVGFzayUyMGNsdXN0ZXJpbmclMjB3YXMlMjBwZXJmb3JtZWQlMjB1c2luZyUyMHRoZSUyME1vZGVsLUJhc2VkJTIwQ2x1c3RlcmluZyUyMChNQkMpJTIwbWV0aG9kJTJDJTBBJTIzJTIwYXMlMjBkZXNjcmliZWQlMjBpbiUyMHRoZSUyMEFycm93JTIwcGFwZXIuJTBBJTIzJTIwV2hpbGUlMjBvbmUlMjBjb3VsZCUyMHRyYWluJTIwYSUyMHNlcGFyYXRlJTIwTG9SQSUyMGZvciUyMGVhY2glMjB0YXNrJTIwYW5kJTIwbGV0JTIwQXJyb3clMjByb3V0ZSUyMHRva2VucyUyMGFtb25nJTIwdGhlbSUyQyUwQSUyMyUyMHRyYWluaW5nJTIwTG9SQXMlMjBvbiUyMGNsdXN0ZXJzJTIwb2YlMjB0YXNrcyUyMGluc3RlYWQlMjBwcm92aWRlcyUyMGFuJTIwaW5kaXJlY3QlMjBvcHRpbWl6YXRpb24lMjBmb3IlMEElMjMlMjB0cmFuc2ZlciUyMGFjcm9zcyUyMHRoZSUyMG11bHRpLXRhc2slMjBkYXRhc2V0LiUwQXRhc2tfc3BlY2lmaWNfYWRhcHRlcl9wYXRocyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGYlMjJUYWhhQmElMkZwaGkzLW1pbmktY2x1c3RlcmVkLWZsYW4lMkZ0c19leHBlcnRfJTdCaSU3RCUyMiUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDEwKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMyUyMENyZWF0aW5nJTIwdGhlJTIwQXJyb3clMjBtb2RlbCUwQW1vZGVsJTIwJTNEJTIwY3JlYXRlX2Fycm93X21vZGVsKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhc2VfbW9kZWwlM0RiYXNlX21vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFza19zcGVjaWZpY19hZGFwdGVyX3BhdGhzJTNEdGFza19zcGVjaWZpY19hZGFwdGVyX3BhdGhzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJyb3dfY29uZmlnJTNEYXJyb3dfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyME5vdyUyMHRoZSUyMGZvcndhcmQlMjBwYXRoJTIwY291bGQlMjBiZSUyMGNhbGxlZCUyMG9uJTIwdGhpcyUyMG1vZGVsJTJDJTIwbGlrZSUyMGElMjBub3JtYWwlMjBQZWZ0TW9kZWwu",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> create_arrow_model, ArrowConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-comment"># Creating the Arrow config</span>
arrow_config = ArrowConfig(
    top_k=<span class="hljs-number">3</span>,
    router_temperature=<span class="hljs-number">1.0</span>,
    rng_seed=<span class="hljs-number">42</span>,
)

<span class="hljs-comment"># The LoRA adapters below were trained on a clustered FLAN dataset.</span>
<span class="hljs-comment"># Task clustering was performed using the Model-Based Clustering (MBC) method,</span>
<span class="hljs-comment"># as described in the Arrow paper.</span>
<span class="hljs-comment"># While one could train a separate LoRA for each task and let Arrow route tokens among them,</span>
<span class="hljs-comment"># training LoRAs on clusters of tasks instead provides an indirect optimization for</span>
<span class="hljs-comment"># transfer across the multi-task dataset.</span>
task_specific_adapter_paths = [
        <span class="hljs-string">f&quot;TahaBa/phi3-mini-clustered-flan/ts_expert_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)
    ]

<span class="hljs-comment"># Creating the Arrow model</span>
model = create_arrow_model(
        base_model=base_model,
        task_specific_adapter_paths=task_specific_adapter_paths,
        arrow_config=arrow_config,
    )

<span class="hljs-comment"># Now the forward path could be called on this model, like a normal PeftModel.</span>`,wrap:!1}}),va=new u({props:{code:"ZnJvbSUyMHRybCUyMGltcG9ydCUyMFNGVFRyYWluZXIlMkMlMjBTRlRDb25maWclMEElMEElMjMlMjBBZGRpbmclMjBhJTIwbmV3JTIwYWRhcHRlciUyMGFuZCUyMGFjdGl2YXRpbmclMjBpdCUwQW1vZGVsLmFkZF9hZGFwdGVyKGFkYXB0ZXJfbmFtZSUzRCduZXdfYWRhcHRlcicpJTBBbW9kZWwuc2V0X2FkYXB0ZXIoJ25ld19hZGFwdGVyJyklMEElMEElMjMlMjBOb3clMjB0aGUlMjBtb2RlbCUyMGNvdWxkJTIwYmUlMjB0cmFpbmVkJTIwYWxvbmclMjB0aGUlMjAlNjBuZXdfYWRhcHRlciU2MC4lMEF0cmFpbmVyJTIwJTNEJTIwU0ZUVHJhaW5lciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXJncyUzRFNGVENvbmZpZyguLi4pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyME9uY2UlMjB0aGUlMjB0cmFpbmluZyUyMGlzJTIwZG9uZSUyQyUyMHlvdSUyMGNhbiUyMGFjdGl2YXRlJTIwJTYwYXJyb3dfcm91dGVyJTYwJTIwYW5kJTIwdXNlJTIwaXQlMjBpbiUyMGluZmVyZW5jZSUwQW1vZGVsLnNldF9hZGFwdGVyKCdhcnJvd19yb3V0ZXInKSUyMCUyMCUyMCUyMCUyMyUyME1vZGVsJTIwaXMlMjByZWFkeSUyMHRvJTIwYmUlMjB1c2VkJTIwYXQlMjBpbmZlcmVuY2UlMjB0aW1lJTIwbm93",highlighted:`<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> SFTTrainer, SFTConfig

<span class="hljs-comment"># Adding a new adapter and activating it</span>
model.add_adapter(adapter_name=<span class="hljs-string">&#x27;new_adapter&#x27;</span>)
model.set_adapter(<span class="hljs-string">&#x27;new_adapter&#x27;</span>)

<span class="hljs-comment"># Now the model could be trained along the \`new_adapter\`.</span>
trainer = SFTTrainer(
        model=model,
        args=SFTConfig(...),
        ...
    )

<span class="hljs-comment"># Once the training is done, you can activate \`arrow_router\` and use it in inference</span>
model.set_adapter(<span class="hljs-string">&#x27;arrow_router&#x27;</span>)    <span class="hljs-comment"># Model is ready to be used at inference time now</span>`,wrap:!1}}),ka=new M({props:{title:"GenKnowSub",local:"genknowsub",headingTag:"h3"}}),Ba=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> create_arrow_model, ArrowConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>)

<span class="hljs-comment"># Creating the Arrow config</span>
arrow_config = ArrowConfig(
    top_k=<span class="hljs-number">3</span>,
    router_temperature=<span class="hljs-number">1.0</span>,
    use_gks=<span class="hljs-literal">True</span>,
    rng_seed=<span class="hljs-number">42</span>,
)

<span class="hljs-comment"># Path to task-specific, trained on flan clustered dataset (as we explained before.)</span>
task_specific_adapter_paths = [
        <span class="hljs-string">f&quot;TahaBa/phi3-mini-clustered-flan/ts_expert_<span class="hljs-subst">{i}</span>&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)
    ]
<span class="hljs-comment"># These general adapters are trained on English, German, and French Wikipedia dataset,</span>
<span class="hljs-comment"># with causal language modelling objective, each pair like: (507 token tsentence, 5 token completion), and the loss computed on the completion</span>
general_adapter_paths = [
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langen/checkpoint-17&quot;</span>,
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langfr/checkpoint-35&quot;</span>,
        <span class="hljs-string">&quot;TahaBa/phi3-mini-general-adapters/cluster0_batch16_prop1.0_langger/checkpoint-17&quot;</span>
    ]

<span class="hljs-comment"># Creating the Arrow model</span>
model = create_arrow_model(
        base_model=base_model,
        task_specific_adapter_paths=task_specific_adapter_paths,
        general_adapter_paths=general_adapter_paths,
        arrow_config=arrow_config,
    )

<span class="hljs-comment"># Now the forward path could be called on this model, like a normal PeftModel.</span>`,wrap:!1}}),Ca=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBRdWFudGlzYXRpb24lMjBjb25maWclMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYm5iXzRiaXRfdXNlX2RvdWJsZV9xdWFudCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMyUyMExvYWRpbmclMjB0aGUlMjBtb2RlbCUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWljcm9zb2Z0JTJGUGhpLTMtbWluaS00ay1pbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RibmJfY29uZmlnJTJDJTBBKSUwQSUwQSUyMyUyME5vdyUyMGNhbGwlMjBjcmVhdGVfYXJyb3dfbW9kZWwoKSUyMGFzJTIwd2UlMjBleHBsYWluZWQlMjBiZWZvcmUu",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, BitsAndBytesConfig
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># Quantisation config</span>
bnb_config = BitsAndBytesConfig(
        load_in_4bit=<span class="hljs-literal">True</span>,
        bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
        bnb_4bit_compute_dtype=torch.bfloat16,
        bnb_4bit_use_double_quant=<span class="hljs-literal">False</span>,
    )

<span class="hljs-comment"># Loading the model</span>
base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;microsoft/Phi-3-mini-4k-instruct&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=bnb_config,
)

<span class="hljs-comment"># Now call create_arrow_model() as we explained before.</span>`,wrap:!1}}),Ra=new Tr({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){T=o("meta"),Qa=n(),Fa=o("p"),Ea=n(),p(U.$$.fragment),za=n(),p(B.$$.fragment),qa=n(),I=o("p"),I.innerHTML=uo,Na=n(),$=o("p"),$.textContent=Mo,Sa=n(),p(C.$$.fragment),Pa=n(),R=o("p"),R.innerHTML=wo,Da=n(),W=o("p"),W.innerHTML=yo,Ka=n(),p(L.$$.fragment),Oa=n(),G=o("p"),G.innerHTML=bo,el=n(),p(A.$$.fragment),tl=n(),p(V.$$.fragment),al=n(),X=o("p"),X.innerHTML=To,ll=n(),x=o("p"),x.textContent=go,nl=n(),p(F.$$.fragment),sl=n(),Y=o("p"),Y.textContent=Jo,ol=n(),p(H.$$.fragment),il=n(),Q=o("p"),Q.innerHTML=jo,rl=n(),p(E.$$.fragment),pl=n(),z=o("p"),z.innerHTML=_o,dl=n(),q=o("p"),q.textContent=vo,ml=n(),p(N.$$.fragment),cl=n(),S=o("p"),S.innerHTML=ko,hl=n(),p(P.$$.fragment),fl=n(),D=o("p"),D.innerHTML=Zo,ul=n(),K=o("p"),K.textContent=Uo,Ml=n(),p(O.$$.fragment),wl=n(),ee=o("p"),ee.innerHTML=Bo,yl=n(),p(te.$$.fragment),bl=n(),ae=o("p"),ae.innerHTML=Io,Tl=n(),le=o("p"),le.innerHTML=$o,gl=n(),p(ne.$$.fragment),Jl=n(),se=o("p"),se.innerHTML=Co,jl=n(),oe=o("p"),oe.innerHTML=Ro,_l=n(),p(ie.$$.fragment),vl=n(),re=o("p"),re.innerHTML=Wo,kl=n(),p(pe.$$.fragment),Zl=n(),de=o("p"),de.innerHTML=Lo,Ul=n(),J=o("blockquote"),J.innerHTML=Go,Bl=n(),p(me.$$.fragment),Il=n(),p(ce.$$.fragment),$l=n(),he=o("p"),he.innerHTML=Ao,Cl=n(),fe=o("p"),fe.innerHTML=Vo,Rl=n(),p(ue.$$.fragment),Wl=n(),Me=o("p"),Me.innerHTML=Xo,Ll=n(),p(we.$$.fragment),Gl=n(),ye=o("p"),ye.innerHTML=xo,Al=n(),be=o("p"),be.innerHTML=Fo,Vl=n(),Te=o("p"),Te.innerHTML=Yo,Xl=n(),ge=o("ul"),ge.innerHTML=Ho,xl=n(),j=o("blockquote"),j.innerHTML=Qo,Fl=n(),p(Je.$$.fragment),Yl=n(),je=o("p"),je.innerHTML=Eo,Hl=n(),p(_e.$$.fragment),Ql=n(),p(ve.$$.fragment),El=n(),ke=o("p"),ke.innerHTML=zo,zl=n(),Ze=o("p"),Ze.innerHTML=qo,ql=n(),p(Ue.$$.fragment),Nl=n(),Be=o("p"),Be.innerHTML=No,Sl=n(),p(Ie.$$.fragment),Pl=n(),$e=o("p"),$e.innerHTML=So,Dl=n(),Ce=o("p"),Ce.innerHTML=Po,Kl=n(),Re=o("ul"),Re.innerHTML=Do,Ol=n(),p(We.$$.fragment),en=n(),Le=o("p"),Le.innerHTML=Ko,tn=n(),Ge=o("p"),Ge.textContent=Oo,an=n(),Ae=o("ul"),Ae.innerHTML=ei,ln=n(),Ve=o("p"),Ve.innerHTML=ti,nn=n(),p(Xe.$$.fragment),sn=n(),xe=o("p"),xe.innerHTML=ai,on=n(),Fe=o("p"),Fe.innerHTML=li,rn=n(),Ye=o("p"),Ye.textContent=ni,pn=n(),p(He.$$.fragment),dn=n(),Qe=o("p"),Qe.innerHTML=si,mn=n(),Ee=o("ol"),Ee.innerHTML=oi,cn=n(),ze=o("p"),ze.innerHTML=ii,hn=n(),qe=o("p"),qe.innerHTML=ri,fn=n(),p(Ne.$$.fragment),un=n(),Se=o("p"),Se.innerHTML=pi,Mn=n(),p(Pe.$$.fragment),wn=n(),p(De.$$.fragment),yn=n(),Ke=o("p"),Ke.innerHTML=di,bn=n(),p(Oe.$$.fragment),Tn=n(),et=o("p"),et.innerHTML=mi,gn=n(),p(tt.$$.fragment),Jn=n(),at=o("p"),at.innerHTML=ci,jn=n(),p(lt.$$.fragment),_n=n(),nt=o("p"),nt.innerHTML=hi,vn=n(),st=o("table"),st.innerHTML=fi,kn=n(),p(ot.$$.fragment),Zn=n(),it=o("ul"),it.innerHTML=ui,Un=n(),p(rt.$$.fragment),Bn=n(),pt=o("p"),pt.innerHTML=Mi,In=n(),p(dt.$$.fragment),$n=n(),p(mt.$$.fragment),Cn=n(),ct=o("p"),ct.innerHTML=wi,Rn=n(),p(ht.$$.fragment),Wn=n(),ft=o("p"),ft.innerHTML=yi,Ln=n(),ut=o("p"),ut.innerHTML=bi,Gn=n(),p(Mt.$$.fragment),An=n(),wt=o("p"),wt.innerHTML=Ti,Vn=n(),yt=o("p"),yt.textContent=gi,Xn=n(),p(bt.$$.fragment),xn=n(),Tt=o("ul"),Tt.innerHTML=Ji,Fn=n(),gt=o("p"),gt.innerHTML=ji,Yn=n(),p(Jt.$$.fragment),Hn=n(),_=o("blockquote"),_.innerHTML=_i,Qn=n(),jt=o("p"),jt.innerHTML=vi,En=n(),p(_t.$$.fragment),zn=n(),vt=o("ul"),vt.innerHTML=ki,qn=n(),p(kt.$$.fragment),Nn=n(),Zt=o("p"),Zt.textContent=Zi,Sn=n(),p(Ut.$$.fragment),Pn=n(),Bt=o("p"),Bt.innerHTML=Ui,Dn=n(),p(It.$$.fragment),Kn=n(),p($t.$$.fragment),On=n(),Ct=o("p"),Ct.innerHTML=Bi,es=n(),p(Rt.$$.fragment),ts=n(),p(Wt.$$.fragment),as=n(),Lt=o("p"),Lt.innerHTML=Ii,ls=n(),p(Gt.$$.fragment),ns=n(),At=o("p"),At.textContent=$i,ss=n(),p(Vt.$$.fragment),os=n(),Xt=o("p"),Xt.innerHTML=Ci,is=n(),xt=o("p"),xt.innerHTML=Ri,rs=n(),p(Ft.$$.fragment),ps=n(),Yt=o("p"),Yt.innerHTML=Wi,ds=n(),Ht=o("p"),Ht.textContent=Li,ms=n(),v=o("div"),v.innerHTML=Gi,cs=n(),Qt=o("p"),Qt.textContent=Ai,hs=n(),p(Et.$$.fragment),fs=n(),zt=o("p"),zt.innerHTML=Vi,us=n(),p(qt.$$.fragment),Ms=n(),Nt=o("p"),Nt.innerHTML=Xi,ws=n(),St=o("p"),St.textContent=xi,ys=n(),p(Pt.$$.fragment),bs=n(),Dt=o("p"),Dt.textContent=Fi,Ts=n(),p(Kt.$$.fragment),gs=n(),Ot=o("p"),Ot.textContent=Yi,Js=n(),p(ea.$$.fragment),js=n(),k=o("blockquote"),k.innerHTML=Hi,_s=n(),ta=o("p"),ta.textContent=Qi,vs=n(),p(aa.$$.fragment),ks=n(),p(la.$$.fragment),Zs=n(),na=o("p"),na.innerHTML=Ei,Us=n(),p(sa.$$.fragment),Bs=n(),oa=o("p"),oa.innerHTML=zi,Is=n(),p(ia.$$.fragment),$s=n(),p(ra.$$.fragment),Cs=n(),pa=o("p"),pa.textContent=qi,Rs=n(),da=o("p"),da.innerHTML=Ni,Ws=n(),p(ma.$$.fragment),Ls=n(),ca=o("p"),ca.innerHTML=Si,Gs=n(),p(ha.$$.fragment),As=n(),fa=o("p"),fa.innerHTML=Pi,Vs=n(),ua=o("p"),ua.innerHTML=Di,Xs=n(),p(Ma.$$.fragment),xs=n(),wa=o("p"),wa.textContent=Ki,Fs=n(),ya=o("ul"),ya.innerHTML=Oi,Ys=n(),p(ba.$$.fragment),Hs=n(),p(Ta.$$.fragment),Qs=n(),ga=o("p"),ga.innerHTML=er,Es=n(),Ja=o("p"),Ja.innerHTML=tr,zs=n(),p(ja.$$.fragment),qs=n(),_a=o("p"),_a.innerHTML=ar,Ns=n(),p(va.$$.fragment),Ss=n(),p(ka.$$.fragment),Ps=n(),Za=o("p"),Za.innerHTML=lr,Ds=n(),Ua=o("p"),Ua.innerHTML=nr,Ks=n(),p(Ba.$$.fragment),Os=n(),Ia=o("p"),Ia.innerHTML=sr,eo=n(),g=o("blockquote"),Wa=o("p"),Wa.innerHTML=or,oo=n(),y=o("ul"),La=o("li"),La.innerHTML=ir,io=n(),Ga=o("li"),Ga.innerHTML=rr,ro=n(),Aa=o("li"),Aa.innerHTML=pr,po=n(),Va=o("li"),Va.innerHTML=dr,mo=n(),Xa=o("li"),Xa.innerHTML=mr,co=n(),$a=o("li"),xa=o("p"),xa.textContent=cr,ho=n(),p(Ca.$$.fragment),to=n(),p(Ra.$$.fragment),ao=n(),Ya=o("p"),this.h()},l(e){const t=yr("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(a),Qa=s(e),Fa=i(e,"P",{}),Ha(Fa).forEach(a),Ea=s(e),d(U.$$.fragment,e),za=s(e),d(B.$$.fragment,e),qa=s(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-38uxl6"&&(I.innerHTML=uo),Na=s(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-ovsn32"&&($.textContent=Mo),Sa=s(e),d(C.$$.fragment,e),Pa=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-j883mf"&&(R.innerHTML=wo),Da=s(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1fujb7a"&&(W.innerHTML=yo),Ka=s(e),d(L.$$.fragment,e),Oa=s(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-mwvui1"&&(G.innerHTML=bo),el=s(e),d(A.$$.fragment,e),tl=s(e),d(V.$$.fragment,e),al=s(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1dv6v3"&&(X.innerHTML=To),ll=s(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1hy0lgx"&&(x.textContent=go),nl=s(e),d(F.$$.fragment,e),sl=s(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-auzrbb"&&(Y.textContent=Jo),ol=s(e),d(H.$$.fragment,e),il=s(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-16k39wq"&&(Q.innerHTML=jo),rl=s(e),d(E.$$.fragment,e),pl=s(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-53sj5j"&&(z.innerHTML=_o),dl=s(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1s3c5rd"&&(q.textContent=vo),ml=s(e),d(N.$$.fragment,e),cl=s(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-19qemwc"&&(S.innerHTML=ko),hl=s(e),d(P.$$.fragment,e),fl=s(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1iny7jf"&&(D.innerHTML=Zo),ul=s(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1j9g8qn"&&(K.textContent=Uo),Ml=s(e),d(O.$$.fragment,e),wl=s(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-sulxp4"&&(ee.innerHTML=Bo),yl=s(e),d(te.$$.fragment,e),bl=s(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-zsbb0y"&&(ae.innerHTML=Io),Tl=s(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1gqkzq0"&&(le.innerHTML=$o),gl=s(e),d(ne.$$.fragment,e),Jl=s(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-168zxvb"&&(se.innerHTML=Co),jl=s(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-18j5yjn"&&(oe.innerHTML=Ro),_l=s(e),d(ie.$$.fragment,e),vl=s(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8ll8w8"&&(re.innerHTML=Wo),kl=s(e),d(pe.$$.fragment,e),Zl=s(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-ryiojp"&&(de.innerHTML=Lo),Ul=s(e),J=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-2xjfr6"&&(J.innerHTML=Go),Bl=s(e),d(me.$$.fragment,e),Il=s(e),d(ce.$$.fragment,e),$l=s(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-icixot"&&(he.innerHTML=Ao),Cl=s(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-7f0aai"&&(fe.innerHTML=Vo),Rl=s(e),d(ue.$$.fragment,e),Wl=s(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-14vtcq9"&&(Me.innerHTML=Xo),Ll=s(e),d(we.$$.fragment,e),Gl=s(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1nywyxh"&&(ye.innerHTML=xo),Al=s(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1m1yphh"&&(be.innerHTML=Fo),Vl=s(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-yl8kok"&&(Te.innerHTML=Yo),Xl=s(e),ge=i(e,"UL",{"data-svelte-h":!0}),r(ge)!=="svelte-12tl4fy"&&(ge.innerHTML=Ho),xl=s(e),j=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-4geq86"&&(j.innerHTML=Qo),Fl=s(e),d(Je.$$.fragment,e),Yl=s(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-omuw13"&&(je.innerHTML=Eo),Hl=s(e),d(_e.$$.fragment,e),Ql=s(e),d(ve.$$.fragment,e),El=s(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-4un44o"&&(ke.innerHTML=zo),zl=s(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-5dffjs"&&(Ze.innerHTML=qo),ql=s(e),d(Ue.$$.fragment,e),Nl=s(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1a9b12s"&&(Be.innerHTML=No),Sl=s(e),d(Ie.$$.fragment,e),Pl=s(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-11qncp"&&($e.innerHTML=So),Dl=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1dbt04g"&&(Ce.innerHTML=Po),Kl=s(e),Re=i(e,"UL",{"data-svelte-h":!0}),r(Re)!=="svelte-8grvus"&&(Re.innerHTML=Do),Ol=s(e),d(We.$$.fragment,e),en=s(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-6nmqpq"&&(Le.innerHTML=Ko),tn=s(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mvzru2"&&(Ge.textContent=Oo),an=s(e),Ae=i(e,"UL",{"data-svelte-h":!0}),r(Ae)!=="svelte-1rhx7b3"&&(Ae.innerHTML=ei),ln=s(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-xa532g"&&(Ve.innerHTML=ti),nn=s(e),d(Xe.$$.fragment,e),sn=s(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-n95elu"&&(xe.innerHTML=ai),on=s(e),Fe=i(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1obb8uu"&&(Fe.innerHTML=li),rn=s(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-qgp1p0"&&(Ye.textContent=ni),pn=s(e),d(He.$$.fragment,e),dn=s(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-1f6e96e"&&(Qe.innerHTML=si),mn=s(e),Ee=i(e,"OL",{"data-svelte-h":!0}),r(Ee)!=="svelte-4kkan"&&(Ee.innerHTML=oi),cn=s(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-177u8nb"&&(ze.innerHTML=ii),hn=s(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1qt6a9e"&&(qe.innerHTML=ri),fn=s(e),d(Ne.$$.fragment,e),un=s(e),Se=i(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-e9wr3d"&&(Se.innerHTML=pi),Mn=s(e),d(Pe.$$.fragment,e),wn=s(e),d(De.$$.fragment,e),yn=s(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-x8nt61"&&(Ke.innerHTML=di),bn=s(e),d(Oe.$$.fragment,e),Tn=s(e),et=i(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-8wzhde"&&(et.innerHTML=mi),gn=s(e),d(tt.$$.fragment,e),Jn=s(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-16lyt50"&&(at.innerHTML=ci),jn=s(e),d(lt.$$.fragment,e),_n=s(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-a1fvzo"&&(nt.innerHTML=hi),vn=s(e),st=i(e,"TABLE",{"data-svelte-h":!0}),r(st)!=="svelte-1iyfgt7"&&(st.innerHTML=fi),kn=s(e),d(ot.$$.fragment,e),Zn=s(e),it=i(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-16sw3ja"&&(it.innerHTML=ui),Un=s(e),d(rt.$$.fragment,e),Bn=s(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-15vxux2"&&(pt.innerHTML=Mi),In=s(e),d(dt.$$.fragment,e),$n=s(e),d(mt.$$.fragment,e),Cn=s(e),ct=i(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-ku1fuj"&&(ct.innerHTML=wi),Rn=s(e),d(ht.$$.fragment,e),Wn=s(e),ft=i(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1ttqqw0"&&(ft.innerHTML=yi),Ln=s(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-foj0wd"&&(ut.innerHTML=bi),Gn=s(e),d(Mt.$$.fragment,e),An=s(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-ed0v39"&&(wt.innerHTML=Ti),Vn=s(e),yt=i(e,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-dtt8e"&&(yt.textContent=gi),Xn=s(e),d(bt.$$.fragment,e),xn=s(e),Tt=i(e,"UL",{"data-svelte-h":!0}),r(Tt)!=="svelte-1qf6hnm"&&(Tt.innerHTML=Ji),Fn=s(e),gt=i(e,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-qh5siy"&&(gt.innerHTML=ji),Yn=s(e),d(Jt.$$.fragment,e),Hn=s(e),_=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(_)!=="svelte-19cd168"&&(_.innerHTML=_i),Qn=s(e),jt=i(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-jvkb1r"&&(jt.innerHTML=vi),En=s(e),d(_t.$$.fragment,e),zn=s(e),vt=i(e,"UL",{"data-svelte-h":!0}),r(vt)!=="svelte-1h2fpez"&&(vt.innerHTML=ki),qn=s(e),d(kt.$$.fragment,e),Nn=s(e),Zt=i(e,"P",{"data-svelte-h":!0}),r(Zt)!=="svelte-ws58tf"&&(Zt.textContent=Zi),Sn=s(e),d(Ut.$$.fragment,e),Pn=s(e),Bt=i(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-18tpzlm"&&(Bt.innerHTML=Ui),Dn=s(e),d(It.$$.fragment,e),Kn=s(e),d($t.$$.fragment,e),On=s(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-1i0u5p9"&&(Ct.innerHTML=Bi),es=s(e),d(Rt.$$.fragment,e),ts=s(e),d(Wt.$$.fragment,e),as=s(e),Lt=i(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-iri31w"&&(Lt.innerHTML=Ii),ls=s(e),d(Gt.$$.fragment,e),ns=s(e),At=i(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-66nz7l"&&(At.textContent=$i),ss=s(e),d(Vt.$$.fragment,e),os=s(e),Xt=i(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-32mf1g"&&(Xt.innerHTML=Ci),is=s(e),xt=i(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-sspyjf"&&(xt.innerHTML=Ri),rs=s(e),d(Ft.$$.fragment,e),ps=s(e),Yt=i(e,"P",{"data-svelte-h":!0}),r(Yt)!=="svelte-23q4ca"&&(Yt.innerHTML=Wi),ds=s(e),Ht=i(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-1wwmf5r"&&(Ht.textContent=Li),ms=s(e),v=i(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1f6iuw5"&&(v.innerHTML=Gi),cs=s(e),Qt=i(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-hlzwis"&&(Qt.textContent=Ai),hs=s(e),d(Et.$$.fragment,e),fs=s(e),zt=i(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-m3cr6r"&&(zt.innerHTML=Vi),us=s(e),d(qt.$$.fragment,e),Ms=s(e),Nt=i(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-kbqhpl"&&(Nt.innerHTML=Xi),ws=s(e),St=i(e,"P",{"data-svelte-h":!0}),r(St)!=="svelte-1mwdwt1"&&(St.textContent=xi),ys=s(e),d(Pt.$$.fragment,e),bs=s(e),Dt=i(e,"P",{"data-svelte-h":!0}),r(Dt)!=="svelte-1lnmg1d"&&(Dt.textContent=Fi),Ts=s(e),d(Kt.$$.fragment,e),gs=s(e),Ot=i(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-1n53hd9"&&(Ot.textContent=Yi),Js=s(e),d(ea.$$.fragment,e),js=s(e),k=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(k)!=="svelte-18gsis4"&&(k.innerHTML=Hi),_s=s(e),ta=i(e,"P",{"data-svelte-h":!0}),r(ta)!=="svelte-qwbdkg"&&(ta.textContent=Qi),vs=s(e),d(aa.$$.fragment,e),ks=s(e),d(la.$$.fragment,e),Zs=s(e),na=i(e,"P",{"data-svelte-h":!0}),r(na)!=="svelte-xr6qp7"&&(na.innerHTML=Ei),Us=s(e),d(sa.$$.fragment,e),Bs=s(e),oa=i(e,"P",{"data-svelte-h":!0}),r(oa)!=="svelte-b1sqs0"&&(oa.innerHTML=zi),Is=s(e),d(ia.$$.fragment,e),$s=s(e),d(ra.$$.fragment,e),Cs=s(e),pa=i(e,"P",{"data-svelte-h":!0}),r(pa)!=="svelte-1fq5tpu"&&(pa.textContent=qi),Rs=s(e),da=i(e,"P",{"data-svelte-h":!0}),r(da)!=="svelte-lcywla"&&(da.innerHTML=Ni),Ws=s(e),d(ma.$$.fragment,e),Ls=s(e),ca=i(e,"P",{"data-svelte-h":!0}),r(ca)!=="svelte-6wkyom"&&(ca.innerHTML=Si),Gs=s(e),d(ha.$$.fragment,e),As=s(e),fa=i(e,"P",{"data-svelte-h":!0}),r(fa)!=="svelte-1o40ch6"&&(fa.innerHTML=Pi),Vs=s(e),ua=i(e,"P",{"data-svelte-h":!0}),r(ua)!=="svelte-mqf2jo"&&(ua.innerHTML=Di),Xs=s(e),d(Ma.$$.fragment,e),xs=s(e),wa=i(e,"P",{"data-svelte-h":!0}),r(wa)!=="svelte-e0xhf6"&&(wa.textContent=Ki),Fs=s(e),ya=i(e,"UL",{"data-svelte-h":!0}),r(ya)!=="svelte-9zbcsh"&&(ya.innerHTML=Oi),Ys=s(e),d(ba.$$.fragment,e),Hs=s(e),d(Ta.$$.fragment,e),Qs=s(e),ga=i(e,"P",{"data-svelte-h":!0}),r(ga)!=="svelte-1qlwkok"&&(ga.innerHTML=er),Es=s(e),Ja=i(e,"P",{"data-svelte-h":!0}),r(Ja)!=="svelte-1dov8xe"&&(Ja.innerHTML=tr),zs=s(e),d(ja.$$.fragment,e),qs=s(e),_a=i(e,"P",{"data-svelte-h":!0}),r(_a)!=="svelte-13ney51"&&(_a.innerHTML=ar),Ns=s(e),d(va.$$.fragment,e),Ss=s(e),d(ka.$$.fragment,e),Ps=s(e),Za=i(e,"P",{"data-svelte-h":!0}),r(Za)!=="svelte-1damsga"&&(Za.innerHTML=lr),Ds=s(e),Ua=i(e,"P",{"data-svelte-h":!0}),r(Ua)!=="svelte-bisu0r"&&(Ua.innerHTML=nr),Ks=s(e),d(Ba.$$.fragment,e),Os=s(e),Ia=i(e,"P",{"data-svelte-h":!0}),r(Ia)!=="svelte-19fqfkj"&&(Ia.innerHTML=sr),eo=s(e),g=i(e,"BLOCKQUOTE",{class:!0});var no=Ha(g);Wa=i(no,"P",{"data-svelte-h":!0}),r(Wa)!=="svelte-14xydvq"&&(Wa.innerHTML=or),oo=s(no),y=i(no,"UL",{});var b=Ha(y);La=i(b,"LI",{"data-svelte-h":!0}),r(La)!=="svelte-1g552yx"&&(La.innerHTML=ir),io=s(b),Ga=i(b,"LI",{"data-svelte-h":!0}),r(Ga)!=="svelte-1kqmy9e"&&(Ga.innerHTML=rr),ro=s(b),Aa=i(b,"LI",{"data-svelte-h":!0}),r(Aa)!=="svelte-o6l66k"&&(Aa.innerHTML=pr),po=s(b),Va=i(b,"LI",{"data-svelte-h":!0}),r(Va)!=="svelte-3a8u10"&&(Va.innerHTML=dr),mo=s(b),Xa=i(b,"LI",{"data-svelte-h":!0}),r(Xa)!=="svelte-1f7byj"&&(Xa.innerHTML=mr),co=s(b),$a=i(b,"LI",{});var so=Ha($a);xa=i(so,"P",{"data-svelte-h":!0}),r(xa)!=="svelte-1j9rbu8"&&(xa.textContent=cr),ho=s(so),d(Ca.$$.fragment,so),so.forEach(a),b.forEach(a),no.forEach(a),to=s(e),d(Ra.$$.fragment,e),ao=s(e),Ya=i(e,"P",{}),Ha(Ya).forEach(a),this.h()},h(){Z(T,"name","hf:doc:metadata"),Z(T,"content",Jr),Z(J,"class","tip"),Z(j,"class","tip"),Z(_,"class","warning"),Z(v,"class","flex justify-center"),Z(k,"class","tip"),Z(g,"class","tip")},m(e,t){w(document.head,T),l(e,Qa,t),l(e,Fa,t),l(e,Ea,t),m(U,e,t),l(e,za,t),m(B,e,t),l(e,qa,t),l(e,I,t),l(e,Na,t),l(e,$,t),l(e,Sa,t),m(C,e,t),l(e,Pa,t),l(e,R,t),l(e,Da,t),l(e,W,t),l(e,Ka,t),m(L,e,t),l(e,Oa,t),l(e,G,t),l(e,el,t),m(A,e,t),l(e,tl,t),m(V,e,t),l(e,al,t),l(e,X,t),l(e,ll,t),l(e,x,t),l(e,nl,t),m(F,e,t),l(e,sl,t),l(e,Y,t),l(e,ol,t),m(H,e,t),l(e,il,t),l(e,Q,t),l(e,rl,t),m(E,e,t),l(e,pl,t),l(e,z,t),l(e,dl,t),l(e,q,t),l(e,ml,t),m(N,e,t),l(e,cl,t),l(e,S,t),l(e,hl,t),m(P,e,t),l(e,fl,t),l(e,D,t),l(e,ul,t),l(e,K,t),l(e,Ml,t),m(O,e,t),l(e,wl,t),l(e,ee,t),l(e,yl,t),m(te,e,t),l(e,bl,t),l(e,ae,t),l(e,Tl,t),l(e,le,t),l(e,gl,t),m(ne,e,t),l(e,Jl,t),l(e,se,t),l(e,jl,t),l(e,oe,t),l(e,_l,t),m(ie,e,t),l(e,vl,t),l(e,re,t),l(e,kl,t),m(pe,e,t),l(e,Zl,t),l(e,de,t),l(e,Ul,t),l(e,J,t),l(e,Bl,t),m(me,e,t),l(e,Il,t),m(ce,e,t),l(e,$l,t),l(e,he,t),l(e,Cl,t),l(e,fe,t),l(e,Rl,t),m(ue,e,t),l(e,Wl,t),l(e,Me,t),l(e,Ll,t),m(we,e,t),l(e,Gl,t),l(e,ye,t),l(e,Al,t),l(e,be,t),l(e,Vl,t),l(e,Te,t),l(e,Xl,t),l(e,ge,t),l(e,xl,t),l(e,j,t),l(e,Fl,t),m(Je,e,t),l(e,Yl,t),l(e,je,t),l(e,Hl,t),m(_e,e,t),l(e,Ql,t),m(ve,e,t),l(e,El,t),l(e,ke,t),l(e,zl,t),l(e,Ze,t),l(e,ql,t),m(Ue,e,t),l(e,Nl,t),l(e,Be,t),l(e,Sl,t),m(Ie,e,t),l(e,Pl,t),l(e,$e,t),l(e,Dl,t),l(e,Ce,t),l(e,Kl,t),l(e,Re,t),l(e,Ol,t),m(We,e,t),l(e,en,t),l(e,Le,t),l(e,tn,t),l(e,Ge,t),l(e,an,t),l(e,Ae,t),l(e,ln,t),l(e,Ve,t),l(e,nn,t),m(Xe,e,t),l(e,sn,t),l(e,xe,t),l(e,on,t),l(e,Fe,t),l(e,rn,t),l(e,Ye,t),l(e,pn,t),m(He,e,t),l(e,dn,t),l(e,Qe,t),l(e,mn,t),l(e,Ee,t),l(e,cn,t),l(e,ze,t),l(e,hn,t),l(e,qe,t),l(e,fn,t),m(Ne,e,t),l(e,un,t),l(e,Se,t),l(e,Mn,t),m(Pe,e,t),l(e,wn,t),m(De,e,t),l(e,yn,t),l(e,Ke,t),l(e,bn,t),m(Oe,e,t),l(e,Tn,t),l(e,et,t),l(e,gn,t),m(tt,e,t),l(e,Jn,t),l(e,at,t),l(e,jn,t),m(lt,e,t),l(e,_n,t),l(e,nt,t),l(e,vn,t),l(e,st,t),l(e,kn,t),m(ot,e,t),l(e,Zn,t),l(e,it,t),l(e,Un,t),m(rt,e,t),l(e,Bn,t),l(e,pt,t),l(e,In,t),m(dt,e,t),l(e,$n,t),m(mt,e,t),l(e,Cn,t),l(e,ct,t),l(e,Rn,t),m(ht,e,t),l(e,Wn,t),l(e,ft,t),l(e,Ln,t),l(e,ut,t),l(e,Gn,t),m(Mt,e,t),l(e,An,t),l(e,wt,t),l(e,Vn,t),l(e,yt,t),l(e,Xn,t),m(bt,e,t),l(e,xn,t),l(e,Tt,t),l(e,Fn,t),l(e,gt,t),l(e,Yn,t),m(Jt,e,t),l(e,Hn,t),l(e,_,t),l(e,Qn,t),l(e,jt,t),l(e,En,t),m(_t,e,t),l(e,zn,t),l(e,vt,t),l(e,qn,t),m(kt,e,t),l(e,Nn,t),l(e,Zt,t),l(e,Sn,t),m(Ut,e,t),l(e,Pn,t),l(e,Bt,t),l(e,Dn,t),m(It,e,t),l(e,Kn,t),m($t,e,t),l(e,On,t),l(e,Ct,t),l(e,es,t),m(Rt,e,t),l(e,ts,t),m(Wt,e,t),l(e,as,t),l(e,Lt,t),l(e,ls,t),m(Gt,e,t),l(e,ns,t),l(e,At,t),l(e,ss,t),m(Vt,e,t),l(e,os,t),l(e,Xt,t),l(e,is,t),l(e,xt,t),l(e,rs,t),m(Ft,e,t),l(e,ps,t),l(e,Yt,t),l(e,ds,t),l(e,Ht,t),l(e,ms,t),l(e,v,t),l(e,cs,t),l(e,Qt,t),l(e,hs,t),m(Et,e,t),l(e,fs,t),l(e,zt,t),l(e,us,t),m(qt,e,t),l(e,Ms,t),l(e,Nt,t),l(e,ws,t),l(e,St,t),l(e,ys,t),m(Pt,e,t),l(e,bs,t),l(e,Dt,t),l(e,Ts,t),m(Kt,e,t),l(e,gs,t),l(e,Ot,t),l(e,Js,t),m(ea,e,t),l(e,js,t),l(e,k,t),l(e,_s,t),l(e,ta,t),l(e,vs,t),m(aa,e,t),l(e,ks,t),m(la,e,t),l(e,Zs,t),l(e,na,t),l(e,Us,t),m(sa,e,t),l(e,Bs,t),l(e,oa,t),l(e,Is,t),m(ia,e,t),l(e,$s,t),m(ra,e,t),l(e,Cs,t),l(e,pa,t),l(e,Rs,t),l(e,da,t),l(e,Ws,t),m(ma,e,t),l(e,Ls,t),l(e,ca,t),l(e,Gs,t),m(ha,e,t),l(e,As,t),l(e,fa,t),l(e,Vs,t),l(e,ua,t),l(e,Xs,t),m(Ma,e,t),l(e,xs,t),l(e,wa,t),l(e,Fs,t),l(e,ya,t),l(e,Ys,t),m(ba,e,t),l(e,Hs,t),m(Ta,e,t),l(e,Qs,t),l(e,ga,t),l(e,Es,t),l(e,Ja,t),l(e,zs,t),m(ja,e,t),l(e,qs,t),l(e,_a,t),l(e,Ns,t),m(va,e,t),l(e,Ss,t),m(ka,e,t),l(e,Ps,t),l(e,Za,t),l(e,Ds,t),l(e,Ua,t),l(e,Ks,t),m(Ba,e,t),l(e,Os,t),l(e,Ia,t),l(e,eo,t),l(e,g,t),w(g,Wa),w(g,oo),w(g,y),w(y,La),w(y,io),w(y,Ga),w(y,ro),w(y,Aa),w(y,po),w(y,Va),w(y,mo),w(y,Xa),w(y,co),w(y,$a),w($a,xa),w($a,ho),m(Ca,$a,null),l(e,to,t),m(Ra,e,t),l(e,ao,t),l(e,Ya,t),lo=!0},p:fr,i(e){lo||(c(U.$$.fragment,e),c(B.$$.fragment,e),c(C.$$.fragment,e),c(L.$$.fragment,e),c(A.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(H.$$.fragment,e),c(E.$$.fragment,e),c(N.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ie.$$.fragment,e),c(pe.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(Je.$$.fragment,e),c(_e.$$.fragment,e),c(ve.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(We.$$.fragment,e),c(Xe.$$.fragment,e),c(He.$$.fragment,e),c(Ne.$$.fragment,e),c(Pe.$$.fragment,e),c(De.$$.fragment,e),c(Oe.$$.fragment,e),c(tt.$$.fragment,e),c(lt.$$.fragment,e),c(ot.$$.fragment,e),c(rt.$$.fragment,e),c(dt.$$.fragment,e),c(mt.$$.fragment,e),c(ht.$$.fragment,e),c(Mt.$$.fragment,e),c(bt.$$.fragment,e),c(Jt.$$.fragment,e),c(_t.$$.fragment,e),c(kt.$$.fragment,e),c(Ut.$$.fragment,e),c(It.$$.fragment,e),c($t.$$.fragment,e),c(Rt.$$.fragment,e),c(Wt.$$.fragment,e),c(Gt.$$.fragment,e),c(Vt.$$.fragment,e),c(Ft.$$.fragment,e),c(Et.$$.fragment,e),c(qt.$$.fragment,e),c(Pt.$$.fragment,e),c(Kt.$$.fragment,e),c(ea.$$.fragment,e),c(aa.$$.fragment,e),c(la.$$.fragment,e),c(sa.$$.fragment,e),c(ia.$$.fragment,e),c(ra.$$.fragment,e),c(ma.$$.fragment,e),c(ha.$$.fragment,e),c(Ma.$$.fragment,e),c(ba.$$.fragment,e),c(Ta.$$.fragment,e),c(ja.$$.fragment,e),c(va.$$.fragment,e),c(ka.$$.fragment,e),c(Ba.$$.fragment,e),c(Ca.$$.fragment,e),c(Ra.$$.fragment,e),lo=!0)},o(e){h(U.$$.fragment,e),h(B.$$.fragment,e),h(C.$$.fragment,e),h(L.$$.fragment,e),h(A.$$.fragment,e),h(V.$$.fragment,e),h(F.$$.fragment,e),h(H.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(P.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(Ue.$$.fragment,e),h(Ie.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(He.$$.fragment,e),h(Ne.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(lt.$$.fragment,e),h(ot.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(Mt.$$.fragment,e),h(bt.$$.fragment,e),h(Jt.$$.fragment,e),h(_t.$$.fragment,e),h(kt.$$.fragment,e),h(Ut.$$.fragment,e),h(It.$$.fragment,e),h($t.$$.fragment,e),h(Rt.$$.fragment,e),h(Wt.$$.fragment,e),h(Gt.$$.fragment,e),h(Vt.$$.fragment,e),h(Ft.$$.fragment,e),h(Et.$$.fragment,e),h(qt.$$.fragment,e),h(Pt.$$.fragment,e),h(Kt.$$.fragment,e),h(ea.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(sa.$$.fragment,e),h(ia.$$.fragment,e),h(ra.$$.fragment,e),h(ma.$$.fragment,e),h(ha.$$.fragment,e),h(Ma.$$.fragment,e),h(ba.$$.fragment,e),h(Ta.$$.fragment,e),h(ja.$$.fragment,e),h(va.$$.fragment,e),h(ka.$$.fragment,e),h(Ba.$$.fragment,e),h(Ca.$$.fragment,e),h(Ra.$$.fragment,e),lo=!1},d(e){e&&(a(Qa),a(Fa),a(Ea),a(za),a(qa),a(I),a(Na),a($),a(Sa),a(Pa),a(R),a(Da),a(W),a(Ka),a(Oa),a(G),a(el),a(tl),a(al),a(X),a(ll),a(x),a(nl),a(sl),a(Y),a(ol),a(il),a(Q),a(rl),a(pl),a(z),a(dl),a(q),a(ml),a(cl),a(S),a(hl),a(fl),a(D),a(ul),a(K),a(Ml),a(wl),a(ee),a(yl),a(bl),a(ae),a(Tl),a(le),a(gl),a(Jl),a(se),a(jl),a(oe),a(_l),a(vl),a(re),a(kl),a(Zl),a(de),a(Ul),a(J),a(Bl),a(Il),a($l),a(he),a(Cl),a(fe),a(Rl),a(Wl),a(Me),a(Ll),a(Gl),a(ye),a(Al),a(be),a(Vl),a(Te),a(Xl),a(ge),a(xl),a(j),a(Fl),a(Yl),a(je),a(Hl),a(Ql),a(El),a(ke),a(zl),a(Ze),a(ql),a(Nl),a(Be),a(Sl),a(Pl),a($e),a(Dl),a(Ce),a(Kl),a(Re),a(Ol),a(en),a(Le),a(tn),a(Ge),a(an),a(Ae),a(ln),a(Ve),a(nn),a(sn),a(xe),a(on),a(Fe),a(rn),a(Ye),a(pn),a(dn),a(Qe),a(mn),a(Ee),a(cn),a(ze),a(hn),a(qe),a(fn),a(un),a(Se),a(Mn),a(wn),a(yn),a(Ke),a(bn),a(Tn),a(et),a(gn),a(Jn),a(at),a(jn),a(_n),a(nt),a(vn),a(st),a(kn),a(Zn),a(it),a(Un),a(Bn),a(pt),a(In),a($n),a(Cn),a(ct),a(Rn),a(Wn),a(ft),a(Ln),a(ut),a(Gn),a(An),a(wt),a(Vn),a(yt),a(Xn),a(xn),a(Tt),a(Fn),a(gt),a(Yn),a(Hn),a(_),a(Qn),a(jt),a(En),a(zn),a(vt),a(qn),a(Nn),a(Zt),a(Sn),a(Pn),a(Bt),a(Dn),a(Kn),a(On),a(Ct),a(es),a(ts),a(as),a(Lt),a(ls),a(ns),a(At),a(ss),a(os),a(Xt),a(is),a(xt),a(rs),a(ps),a(Yt),a(ds),a(Ht),a(ms),a(v),a(cs),a(Qt),a(hs),a(fs),a(zt),a(us),a(Ms),a(Nt),a(ws),a(St),a(ys),a(bs),a(Dt),a(Ts),a(gs),a(Ot),a(Js),a(js),a(k),a(_s),a(ta),a(vs),a(ks),a(Zs),a(na),a(Us),a(Bs),a(oa),a(Is),a($s),a(Cs),a(pa),a(Rs),a(da),a(Ws),a(Ls),a(ca),a(Gs),a(As),a(fa),a(Vs),a(ua),a(Xs),a(xs),a(wa),a(Fs),a(ya),a(Ys),a(Hs),a(Qs),a(ga),a(Es),a(Ja),a(zs),a(qs),a(_a),a(Ns),a(Ss),a(Ps),a(Za),a(Ds),a(Ua),a(Ks),a(Os),a(Ia),a(eo),a(g),a(to),a(ao),a(Ya)),a(T),f(U,e),f(B,e),f(C,e),f(L,e),f(A,e),f(V,e),f(F,e),f(H,e),f(E,e),f(N,e),f(P,e),f(O,e),f(te,e),f(ne,e),f(ie,e),f(pe,e),f(me,e),f(ce,e),f(ue,e),f(we,e),f(Je,e),f(_e,e),f(ve,e),f(Ue,e),f(Ie,e),f(We,e),f(Xe,e),f(He,e),f(Ne,e),f(Pe,e),f(De,e),f(Oe,e),f(tt,e),f(lt,e),f(ot,e),f(rt,e),f(dt,e),f(mt,e),f(ht,e),f(Mt,e),f(bt,e),f(Jt,e),f(_t,e),f(kt,e),f(Ut,e),f(It,e),f($t,e),f(Rt,e),f(Wt,e),f(Gt,e),f(Vt,e),f(Ft,e),f(Et,e),f(qt,e),f(Pt,e),f(Kt,e),f(ea,e),f(aa,e),f(la,e),f(sa,e),f(ia,e),f(ra,e),f(ma,e),f(ha,e),f(Ma,e),f(ba,e),f(Ta,e),f(ja,e),f(va,e),f(ka,e),f(Ba,e),f(Ca),f(Ra,e)}}}const Jr='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"CorDA","local":"corda","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"EVA","local":"eva","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Activated LoRA (aLoRA)","local":"activated-lora-alora","sections":[{"title":"Choice of invocation sequence and SFT design","local":"choice-of-invocation-sequence-and-sft-design","sections":[],"depth":4},{"title":"Using (and reusing) cache for generation","local":"using-and-reusing-cache-for-generation","sections":[],"depth":4}],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3},{"title":"Fine grained control over ranks and alpha (scaling)","local":"fine-grained-control-over-ranks-and-alpha-scaling","sections":[],"depth":3},{"title":"Targeting nn.Parameter directly","local":"targeting-nnparameter-directly","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA-FA Optimizer","local":"lora-fa-optimizer","sections":[],"depth":3},{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Efficiently train tokens alongside LoRA","local":"efficiently-train-tokens-alongside-lora","sections":[],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2},{"title":"Composing and Reusing LoRA Adapters","local":"composing-and-reusing-lora-adapters","sections":[{"title":"Arrow","local":"arrow","sections":[],"depth":3},{"title":"GenKnowSub","local":"genknowsub","sections":[],"depth":3}],"depth":2}],"depth":1}';function jr(fo){return ur(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ur extends Mr{constructor(T){super(),wr(this,T,jr,gr,hr,{})}}export{Ur as component};
