import{s as Bc,o as Pc,n as x}from"../chunks/scheduler.85c25b89.js";import{S as Gc,i as Ec,g as i,s as o,r as m,A as Dc,h as d,f as a,c as r,j as w,u,x as b,k as T,y as n,a as p,v as g,d as f,t as h,w as _}from"../chunks/index.c9bcf812.js";import{T as qc}from"../chunks/Tip.d8f753fa.js";import{D as $}from"../chunks/Docstring.af42ec0f.js";import{C as F}from"../chunks/CodeBlock.c004bd26.js";import{E as U}from"../chunks/ExampleCodeBlock.9054a1f5.js";import{H as k}from"../chunks/index.9790a2b6.js";function Hc(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckZlYXR1cmVFeHRyYWN0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjItbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkRlYXIlMjBFdmFuJTIwSGFuc2VuJTIwaXMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMHNpeCUyMFRvbnklMjBBd2FyZHMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Dear Evan Hansen is the winner of six Tony Awards.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function Qc(j){let l,N="Text Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJnZS1iYXNlLWVuLXYxLjUtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZ2UtYmFzZS1lbi12MS41LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkluJTIwdGhlJTIwc21vdWxkZXJpbmclMjBwcm9taXNlJTIwb2YlMjB0aGUlMjBmYWxsJTIwb2YlMjBUcm95JTJDJTIwYSUyMG15dGhpY2FsJTIwd29ybGQlMjBvZiUyMGdvZHMlMjBhbmQlMjBtb3J0YWxzJTIwcmlzZXMlMjBmcm9tJTIwdGhlJTIwYXNoZXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5n",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;In the smouldering promise of the fall of Troy, a mythical world of gods and mortals rises from the ashes.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_embeddings = outputs.token_embeddings
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence_embedding = = outputs.sentence_embedding`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1vtqn41"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function Yc(j){let l,N="Image Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwdXRpbCUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBdXRpbC5odHRwX2dldCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZVS1BMYWIlMkZzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMkZyYXclMkZtYXN0ZXIlMkZleGFtcGxlcyUyRnNlbnRlbmNlX3RyYW5zZm9ybWVyJTJGYXBwbGljYXRpb25zJTJGaW1hZ2Utc2VhcmNoJTJGdHdvX2RvZ3NfaW5fc25vdy5qcGclMjIlMkMlMjAlMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMlR3byUyMGRvZ3MlMjBpbiUyMHRoZSUyMHNub3clMjIlMkMlMjAnQSUyMGNhdCUyMG9uJTIwYSUyMHRhYmxlJyUyQyUyMCdBJTIwcGljdHVyZSUyMG9mJTIwTG9uZG9uJTIwYXQlMjBuaWdodCclNUQlMkMlMjBpbWFnZXMlM0RJbWFnZS5vcGVuKCUyMnR3b19kb2dzX2luX3Nub3cuanBnJTIyKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMGNvc2luZSUyMHNpbWlsYXJpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>util.http_get(<span class="hljs-string">&quot;https://github.com/UKPLab/sentence-transformers/raw/master/examples/sentence_transformer/applications/image-search/two_dogs_in_snow.jpg&quot;</span>, <span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">&gt;&gt;&gt; </span>    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)  <span class="hljs-comment"># Compute cosine similarities</span>`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-l4l8dd"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function Ac(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmxlZ2FsLWJlcnQtYmFzZS11bmNhc2VkLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGbGVnYWwtYmVydC1iYXNlLXVuY2FzZWQtbmV1cm9ueCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMCU1Qk1BU0slNUQlMjBBZ3JlZW1lbnQlMjBpcyUyMGJldHdlZW4lMjBHZW5lcmFsJTIwTW90b3JzJTIwYW5kJTIwSm9obiUyME11cnJheS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This [MASK] Agreement is between General Motors and John Murray.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">30522</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function Oc(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhhbWlsdG9uJTIwaXMlMjBjb25zaWRlcmVkJTIwdG8lMjBiZSUyMHRoZSUyMGJlc3QlMjBtdXNpY2FsJTIwb2YlMjBodW1hbiUyMGhpc3RvcnkuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of human history.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function Kc(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGcm9iZXJ0YS1iYXNlLXNxdWFkMi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDItbmV1cm9ueCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJBcmUlMjB0aGVyZSUyMHdoZWVsY2hhaXIlMjBzcGFjZXMlMjBpbiUyMHRoZSUyMHRoZWF0cmVzJTNGJTIyJTJDJTIwJTIyWWVzJTJDJTIwd2UlMjBoYXZlJTIwcmVzZXJ2ZWQlMjB3aGVlbGNoYWlyJTIwc3BhY2VzJTIwd2l0aCUyMGElMjBnb29kJTIwdmlldy4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjEyJTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHN0YXJ0X3Bvc2l0aW9ucyUyQyUyMGVuZF9wb3NpdGlvbnMlM0RlbmRfcG9zaXRpb25zKSUwQXN0YXJ0X3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzJTBBZW5kX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Are there wheelchair spaces in the theatres?&quot;</span>, <span class="hljs-string">&quot;Yes, we have reserved wheelchair spaces with a good view.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">12</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function ep(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJMaW4tTWFudWVsJTIwTWlyYW5kYSUyMGlzJTIwYW4lMjBBbWVyaWNhbiUyMHNvbmd3cml0ZXIlMkMlMjBhY3RvciUyQyUyMHNpbmdlciUyQyUyMGZpbG1tYWtlciUyQyUyMGFuZCUyMHBsYXl3cmlnaHQuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Lin-Manuel Miranda is an American songwriter, actor, singer, filmmaker, and playwright.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">20</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function tp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkX1NXQUctbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHLW5ldXJvbnglMjIpJTBBJTBBbnVtX2Nob2ljZXMlMjAlM0QlMjA0JTBBZmlyc3Rfc2VudGVuY2UlMjAlM0QlMjAlNUIlMjJNZW1iZXJzJTIwb2YlMjB0aGUlMjBwcm9jZXNzaW9uJTIwd2FsayUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBob2xkaW5nJTIwc21hbGwlMjBob3JuJTIwYnJhc3MlMjBpbnN0cnVtZW50cy4lMjIlNUQlMjAqJTIwbnVtX2Nob2ljZXMlMEFzZWNvbmRfc2VudGVuY2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBwYXNzZXMlMjBieSUyMHdhbGtpbmclMjBkb3duJTIwdGhlJTIwc3RyZWV0JTIwcGxheWluZyUyMHRoZWlyJTIwaW5zdHJ1bWVudHMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwaGFzJTIwaGVhcmQlMjBhcHByb2FjaGluZyUyMHRoZW0uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwYXJyaXZlcyUyMGFuZCUyMHRoZXkncmUlMjBvdXRzaWRlJTIwZGFuY2luZyUyMGFuZCUyMGFzbGVlcC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjB0dXJucyUyMHRoZSUyMGxlYWQlMjBzaW5nZXIlMjB3YXRjaGVzJTIwdGhlJTIwcGVyZm9ybWFuY2UuJTIyJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGZpcnN0X3NlbnRlbmNlJTJDJTIwc2Vjb25kX3NlbnRlbmNlJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlNUJrJTVEJTIwJTNEJTIwJTVCdiU1QmklM0ElMjBpJTIwJTJCJTIwbnVtX2Nob2ljZXMlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwbnVtX2Nob2ljZXMpJTVEJTBBaW5wdXRzJTIwJTNEJTIwZGljdChpbnB1dHMuY29udmVydF90b190ZW5zb3JzKHRlbnNvcl90eXBlJTNEJTIycHQlMjIpKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function np(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwZmF2b3JpdGUlMjBtb21lbnQlMjBvZiUyMHRoZSUyMGRheSUyMGlzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMjBtaW5fbGVuZ3RoJTNEMjAlMkMlMjBtYXhfbGVuZ3RoJTNEMjApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My favorite moment of the day is&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>, max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function op(j){let l,N=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=N},l(y){l=d(y,"P",{"data-svelte-h":!0}),b(l)!=="svelte-fincs2"&&(l.innerHTML=N)},m(y,c){p(y,l,c)},p:x,d(y){y&&a(l)}}}function rp(j){let l,N="Example of text-to-text generation:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChnb29nbGUtdDUlMkZ0NS1zbWFsbCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMGJhdGNoX3NpemUlM0QxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTNENjQlMkMlMjBudW1fYmVhbXMlM0Q0KSUwQW5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEFkZWwlMjBuZXVyb25fbW9kZWwlMEElMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NV9zbWFsbF9uZXVyb254JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(google-t5/t5-small, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">4</span>)
neuron_model.save_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
<span class="hljs-keyword">del</span> neuron_model

<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-hhyk5s"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function ap(j){let l,N="Example of text-to-text generation with tensor parallelism:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQWlmJTIwX19uYW1lX18lMjAlM0QlM0QlMjAlMjJfX21haW5fXyUyMiUzQSUyMCUyMCUyMyUyMGNvbXB1bHNvcnklMjBmb3IlMjBwYXJhbGxlbCUyMHRyYWNpbmclMjBzaW5jZSUyMHRoZSUyMEFQSSUyMHdpbGwlMjBzcGF3biUyMG11bHRpcGxlJTIwcHJvY2Vzc2VzLiUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnb29nbGUlMkZmbGFuLXQ1LXhsJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEOCUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzREZhbHNlJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBzZXF1ZW5jZV9sZW5ndGglM0QxMjglMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEElMjAlMjAlMjAlMjBkZWwlMjBuZXVyb25fbW9kZWwlMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmbGFuX3Q1X3hsX25ldXJvbnhfdHA4JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:  <span class="hljs-comment"># compulsory for parallel tracing since the API will spawn multiple processes.</span>
    neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(
        google/flan-t5-xl, export=<span class="hljs-literal">True</span>, tensor_parallel_size=<span class="hljs-number">8</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">128</span>, num_beams=<span class="hljs-number">4</span>,
    )
    neuron_model.save_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
    <span class="hljs-keyword">del</span> neuron_model
<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-onp91"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function sp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function lp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkZWVwbGFidjMtbW9iaWxldml0LXNtYWxsLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGVlcGxhYnYzLW1vYmlsZXZpdC1zbWFsbC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function ip(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdGFyZ2V0X3NpemVzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjklMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function dp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpLml0ZW0oKSUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function cp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME5ldXJvbk1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  NeuronModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function pp(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function mp(j){let l,N="Example using <code>optimum.neuron.pipeline</code>:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUyQyUyMHBpcGVsaW5lJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwLXNlbGYtbmV1cm9ueC1jdGMlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZmVhdHVyZV9leHRyYWN0b3IlM0Rwcm9jZXNzb3IuZmVhdHVyZV9leHRyYWN0b3IlMkMlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC, pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, feature_extractor=processor.feature_extractor, tokenizer=processor.tokenizer)`,wrap:!1}}),{c(){l=i("p"),l.innerHTML=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-ch7hyj"&&(l.innerHTML=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function up(j){let l,N="Example:",y,c,M;return c=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTVCZCU1QiUyMmFycmF5JTIyJTVEJTIwZm9yJTIwZCUyMGluJTIwZGF0YXNldCU1QiUzQTIlNUQlNUIlMjJhdWRpbyUyMiU1RCU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlJTBBKSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForXVector.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=N,y=o(),m(c.$$.fragment)},l(t){l=d(t,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=N),y=r(t),u(c.$$.fragment,t)},m(t,v){p(t,l,v),p(t,y,v),g(c,t,v),M=!0},p:x,i(t){M||(f(c.$$.fragment,t),M=!0)},o(t){h(c.$$.fragment,t),M=!1},d(t){t&&(a(l),a(y)),_(c,t)}}}function gp(j){let l,N,y,c,M,t,v,aa,Mt,sa,vt,ed=`The <code>NeuronTracedModel</code> class is available for instantiating a base Neuron model without a specific head.
It is used as the base class for all tasks but text generation.`,la,C,Nt,xs,go,td="Base class running compiled and optimized models on Neuron devices.",Us,fo,nd=`It implements generic methods for interacting with the Hugging Face Hub as well as compiling vanilla
transformers models to neuron-optimized TorchScript module and export it using <code>optimum.exporters.neuron</code> toolchain.`,Fs,ho,od="Class attributes:",Is,_o,rd=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;neuron_model&quot;</code>) — The name of the model type to use when
registering the NeuronTracedModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The <code>AutoModel</code> class to be represented by the
current NeuronTracedModel class.</li>`,Zs,bo,ad="Common attributes:",Xs,yo,sd=`<li>model (<code>torch.jit._script.ScriptModule</code>) — The loaded <code>ScriptModule</code> compiled for neuron devices.</li> <li>config (<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a>) — The configuration of the model.</li> <li>model_save_dir (<code>Path</code>) — The directory where a neuron compiled model is saved.
By default, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory will be used.</li>`,Ss,De,wt,Vs,Mo,ld="Returns whether this model can generate sequences with <code>.generate()</code>.",Ws,qe,Tt,Rs,vo,id="Gets a dictionary of inputs with their valid static shapes.",zs,He,$t,Ls,No,dd=`Loads a TorchScript module compiled by neuron(x)-cc compiler. It will be first loaded onto CPU and then moved to
one or multiple <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/arch/neuron-hardware/neuroncores-arch.html" rel="nofollow">NeuronCore</a>.`,Bs,Qe,jt,Ps,wo,cd="Removes padding from output tensors.",ia,kt,da,Ct,pd="The <code>NeuronDecoderModel</code> class is the base class for text generation models.",ca,Z,Jt,Gs,To,md="Base class to convert and run pre-trained transformers decoder models on Neuron devices.",Es,$o,ud="It implements the methods to convert a pre-trained transformers decoder model into a Neuron transformer model by:",Ds,jo,gd="<li>transferring the checkpoint weights of the original into an optimized neuron graph,</li> <li>compiling the resulting graph using the Neuron compiler.</li>",qs,ko,fd="Common attributes:",Hs,Co,hd='<li>model (<code>torch.nn.Module</code>) — The decoder model with a graph optimized for neuron devices.</li> <li>config (<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a>) — The configuration of the original model.</li> <li>generation_config (<a href="https://huggingface.co/docs/transformers/v4.51.3/en/main_classes/text_generation#transformers.GenerationConfig" rel="nofollow">GenerationConfig</a>) — The generation configuration used by default when calling <code>generate()</code>.</li>',pa,xt,ma,Ut,_d="The following Neuron model classes are available for natural language processing tasks.",ua,Ft,ga,X,It,Qs,Jo,bd="Neuron Model with a BaseModelOutput for feature-extraction tasks.",Ys,xo,yd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,As,Uo,Md="Feature Extraction model on Neuron devices.",Os,de,Zt,Ks,Fo,vd="The <code>NeuronModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",el,Ye,fa,Xt,ha,S,St,tl,Io,Nd="Neuron Model for Sentence Transformers.",nl,Zo,wd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ol,Xo,Td="Sentence Transformers model on Neuron devices.",rl,se,Vt,al,So,$d="The <code>NeuronModelForSentenceTransformers</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",sl,Ae,ll,Oe,_a,Wt,ba,V,Rt,il,Vo,jd="Neuron Model with a MaskedLMOutput for masked language modeling tasks.",dl,Wo,kd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,cl,Ro,Cd="Masked language model for on Neuron devices.",pl,ce,zt,ml,zo,Jd="The <code>NeuronModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ul,Ke,ya,Lt,Ma,W,Bt,gl,Lo,xd=`Neuron Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,fl,Bo,Ud=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,hl,Po,Fd="Sequence Classification model on Neuron devices.",_l,pe,Pt,bl,Go,Id="The <code>NeuronModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",yl,et,va,Gt,Na,R,Et,Ml,Eo,Zd="Neuron Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD.",vl,Do,Xd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Nl,qo,Sd="Question Answering model on Neuron devices.",wl,me,Dt,Tl,Ho,Vd="The <code>NeuronModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",$l,tt,wa,qt,Ta,z,Ht,jl,Qo,Wd=`Neuron Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks.`,kl,Yo,Rd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Cl,Ao,zd="Token Classification model on Neuron devices.",Jl,ue,Qt,xl,Oo,Ld="The <code>NeuronModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Ul,nt,$a,Yt,ja,L,At,Fl,Ko,Bd=`Neuron Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,Il,er,Pd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Zl,tr,Gd="Multiple choice model on Neuron devices.",Xl,ge,Ot,Sl,nr,Ed="The <code>NeuronModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Vl,ot,ka,Kt,Ca,A,en,Wl,or,Dd="Neuron model with a causal language modeling head for inference on Neuron devices.",Rl,rr,qd=`This model inherits from <code>~neuron.modeling.NeuronDecoderModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,zl,fe,tn,Ll,ar,Hd="The <code>NeuronModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Bl,rt,Ja,nn,xa,O,on,Pl,sr,Qd="Neuron Sequence-to-sequence model with a language modeling head for text2text-generation tasks.",Gl,lr,Yd=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,El,I,rn,Dl,ir,Ad='The <a href="/docs/optimum.neuron/v0.2.0.dev2/en/package_reference/modeling#optimum.neuron.NeuronModelForSeq2SeqLM">NeuronModelForSeq2SeqLM</a> forward method, overrides the <code>__call__</code> special method.',ql,at,Hl,dr,Od="<em>(Following models are compiled with neuronx compiler and can only be run on INF2.)</em>",Ql,st,Yl,cr,Kd="<em>(For large models, in order to fit into Neuron cores, we need to apply tensor parallelism. Here below is an example ran on <code>inf2.24xlarge</code>.)</em>",Al,lt,Ua,an,Fa,sn,ec="The following Neuron model classes are available for computer vision tasks.",Ia,ln,Za,B,dn,Ol,pr,tc="Neuron Model with an image classification head on top (a linear layer on top of the final hidden state of the [CLS] token) e.g. for ImageNet.",Kl,mr,nc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ei,ur,oc="Neuron Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, deit, levit, mobilenet_v2, mobilevit, vit, etc.",ti,he,cn,ni,gr,rc="The <code>NeuronModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",oi,it,Xa,pn,Sa,P,mn,ri,fr,ac="Neuron Model with a semantic segmentation head on top, e.g. for Pascal VOC.",ai,hr,sc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,si,_r,lc="Neuron Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports mobilevit, mobilenet-v2, etc.",li,_e,un,ii,br,ic="The <code>NeuronModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",di,dt,Va,gn,Wa,G,fn,ci,yr,dc="Neuron Model with object detection heads on top, for tasks such as COCO detection.",pi,Mr,cc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,mi,vr,pc="Neuron Model for object-detection, with object detection heads on top, for tasks such as COCO detection.",ui,be,hn,gi,Nr,mc="The <code>NeuronModelForObjectDetection</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",fi,ct,Ra,_n,za,bn,uc="The following auto classes are available for the following audio tasks.",La,yn,Ba,E,Mn,hi,wr,gc="Neuron Model with an audio classification head.",_i,Tr,fc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,bi,$r,hc=`Neuron Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,yi,ye,vn,Mi,jr,_c="The <code>NeuronModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",vi,pt,Pa,Nn,Ga,D,wn,Ni,kr,bc="Neuron Model with an audio frame classification head.",wi,Cr,yc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Ti,Jr,Mc="Neuron Model with a frame classification head on top for tasks like Speaker Diarization.",$i,Me,Tn,ji,xr,vc="The <code>NeuronModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ki,mt,Ea,$n,Da,q,jn,Ci,Ur,Nc="Neuron Model with a connectionist temporal classification head.",Ji,Fr,wc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,xi,Ir,Tc="Neuron Model with a language modeling head on top for Connectionist Temporal Classification (CTC).",Ui,le,kn,Fi,Zr,$c="The <code>NeuronModelForCTC</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Ii,ut,Zi,gt,qa,Cn,Ha,H,Jn,Xi,Xr,jc="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",Si,Sr,kc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Vi,Vr,Cc="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",Wi,ve,xn,Ri,Wr,Jc="The <code>NeuronModelForXVector</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",zi,ft,Qa,Un,Ya,Fn,xc="The following Neuron model classes are available for stable diffusion tasks.",Aa,In,Oa,xe,Zn,Li,Rr,Xn,Ka,Sn,es,Ue,Vn,Bi,zr,Wn,ts,Rn,ns,Fe,zn,Pi,Lr,Ln,os,Bn,rs,Ie,Pn,Gi,Br,Gn,as,En,ss,Ze,Dn,Ei,ht,qn,Di,Pr,Uc="The call function to the pipeline for generation.",ls,Hn,is,Xe,Qn,qi,Gr,Yn,ds,An,cs,Se,On,Hi,Er,Kn,ps,eo,ms,Ve,to,Qi,Dr,no,us,oo,gs,We,ro,Yi,qr,ao,fs,so,hs,Re,lo,Ai,Ne,io,Oi,Hr,Fc="The call function to the pipeline for generation.",Ki,Qr,Ic="Examples:",_s,ra,bs;return M=new k({props:{title:"Models",local:"models",headingTag:"h1"}}),v=new k({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),Mt=new k({props:{title:"NeuronTracedModel",local:"optimum.neuron.NeuronTracedModel",headingTag:"h3"}}),Nt=new $({props:{name:"class optimum.neuron.NeuronTracedModel",anchor:"optimum.neuron.NeuronTracedModel",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_traced.py#L67"}}),wt=new $({props:{name:"can_generate",anchor:"optimum.neuron.NeuronTracedModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_traced.py#L632"}}),Tt=new $({props:{name:"get_input_static_shapes",anchor:"optimum.neuron.NeuronTracedModel.get_input_static_shapes",parameters:[{name:"neuron_config",val:": NeuronDefaultConfig"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_traced.py#L487"}}),$t=new $({props:{name:"load_model",anchor:"optimum.neuron.NeuronTracedModel.load_model",parameters:[{name:"path",val:": typing.Union[str, pathlib.Path]"},{name:"to_neuron",val:": bool = False"},{name:"device_id",val:": int = 0"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.load_model.path",description:`<strong>path</strong> (<code>Union[str, Path]</code>) &#x2014;
Path of the compiled model.`,name:"path"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.to_neuron",description:`<strong>to_neuron</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to move manually the traced model to NeuronCore. It&#x2019;s only needed when <code>inline_weights_to_neff=False</code>, otherwise it is loaded automatically to a Neuron device.`,name:"to_neuron"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.device_id",description:`<strong>device_id</strong> (<code>int</code>, defaults to 0) &#x2014;
Index of NeuronCore to load the traced model to.`,name:"device_id"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_traced.py#L111"}}),jt=new $({props:{name:"remove_padding",anchor:"optimum.neuron.NeuronTracedModel.remove_padding",parameters:[{name:"outputs",val:": typing.List[torch.Tensor]"},{name:"dims",val:": typing.List[int]"},{name:"indices",val:": typing.List[int]"},{name:"padding_side",val:": typing.Literal['right', 'left'] = 'right'"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.outputs",description:`<strong>outputs</strong> (<code>List[torch.Tensor]</code>) &#x2014;
List of torch tensors which are inference output.`,name:"outputs"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.dims",description:`<strong>dims</strong> (<code>List[int]</code>) &#x2014;
List of dimensions in which we slice a tensor.`,name:"dims"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.indices",description:`<strong>indices</strong> (<code>List[int]</code>) &#x2014;
List of indices in which we slice a tensor along an axis.`,name:"indices"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.padding_side",description:`<strong>padding_side</strong> (<code>Literal[&quot;right&quot;, &quot;left&quot;]</code>, defaults to &#x201C;right&#x201D;) &#x2014;
The side on which the padding has been applied.`,name:"padding_side"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_traced.py#L584"}}),kt=new k({props:{title:"NeuronDecoderModel",local:"optimum.neuron.NeuronDecoderModel",headingTag:"h3"}}),Jt=new $({props:{name:"class optimum.neuron.NeuronDecoderModel",anchor:"optimum.neuron.NeuronDecoderModel",parameters:[{name:"config",val:": PretrainedConfig"},{name:"checkpoint_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory]"},{name:"compiled_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_decoder.py#L112"}}),xt=new k({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Ft=new k({props:{title:"NeuronModelForFeatureExtraction",local:"optimum.neuron.NeuronModelForFeatureExtraction",headingTag:"h3"}}),It=new $({props:{name:"class optimum.neuron.NeuronModelForFeatureExtraction",anchor:"optimum.neuron.NeuronModelForFeatureExtraction",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L98"}}),Zt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L111"}}),Ye=new U({props:{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.example",$$slots:{default:[Hc]},$$scope:{ctx:j}}}),Xt=new k({props:{title:"NeuronModelForSentenceTransformers",local:"optimum.neuron.NeuronModelForSentenceTransformers",headingTag:"h3"}}),St=new $({props:{name:"class optimum.neuron.NeuronModelForSentenceTransformers",anchor:"optimum.neuron.NeuronModelForSentenceTransformers",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L150"}}),Vt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L164"}}),Ae=new U({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example",$$slots:{default:[Qc]},$$scope:{ctx:j}}}),Oe=new U({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example-2",$$slots:{default:[Yc]},$$scope:{ctx:j}}}),Wt=new k({props:{title:"NeuronModelForMaskedLM",local:"optimum.neuron.NeuronModelForMaskedLM",headingTag:"h3"}}),Rt=new $({props:{name:"class optimum.neuron.NeuronModelForMaskedLM",anchor:"optimum.neuron.NeuronModelForMaskedLM",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L216"}}),zt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L229"}}),Ke=new U({props:{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.example",$$slots:{default:[Ac]},$$scope:{ctx:j}}}),Lt=new k({props:{title:"NeuronModelForSequenceClassification",local:"optimum.neuron.NeuronModelForSequenceClassification",headingTag:"h3"}}),Bt=new $({props:{name:"class optimum.neuron.NeuronModelForSequenceClassification",anchor:"optimum.neuron.NeuronModelForSequenceClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L309"}}),Pt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L323"}}),et=new U({props:{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.example",$$slots:{default:[Oc]},$$scope:{ctx:j}}}),Gt=new k({props:{title:"NeuronModelForQuestionAnswering",local:"optimum.neuron.NeuronModelForQuestionAnswering",headingTag:"h3"}}),Et=new $({props:{name:"class optimum.neuron.NeuronModelForQuestionAnswering",anchor:"optimum.neuron.NeuronModelForQuestionAnswering",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L262"}}),Dt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L275"}}),tt=new U({props:{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.example",$$slots:{default:[Kc]},$$scope:{ctx:j}}}),qt=new k({props:{title:"NeuronModelForTokenClassification",local:"optimum.neuron.NeuronModelForTokenClassification",headingTag:"h3"}}),Ht=new $({props:{name:"class optimum.neuron.NeuronModelForTokenClassification",anchor:"optimum.neuron.NeuronModelForTokenClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L356"}}),Qt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L370"}}),nt=new U({props:{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.example",$$slots:{default:[ep]},$$scope:{ctx:j}}}),Yt=new k({props:{title:"NeuronModelForMultipleChoice",local:"optimum.neuron.NeuronModelForMultipleChoice",headingTag:"h3"}}),At=new $({props:{name:"class optimum.neuron.NeuronModelForMultipleChoice",anchor:"optimum.neuron.NeuronModelForMultipleChoice",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L404"}}),Ot=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L418"}}),ot=new U({props:{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.example",$$slots:{default:[tp]},$$scope:{ctx:j}}}),Kt=new k({props:{title:"NeuronModelForCausalLM",local:"optimum.neuron.NeuronModelForCausalLM",headingTag:"h3"}}),en=new $({props:{name:"class optimum.neuron.NeuronModelForCausalLM",anchor:"optimum.neuron.NeuronModelForCausalLM",parameters:[{name:"config",val:": PretrainedConfig"},{name:"checkpoint_dir",val:": typing.Union[str, ForwardRef('Path'), ForwardRef('TemporaryDirectory')]"},{name:"compiled_dir",val:": typing.Union[str, ForwardRef('Path'), ForwardRef('TemporaryDirectory'), NoneType] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCausalLM.model",description:'<strong>model</strong> (<code>(</code>torch.jit._script.ScriptModule<code>)</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">(<code>torch.jit._script.ScriptModule</code>)</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) of the decoder compiled by neuron(x) compiler.',name:"model"},{anchor:"optimum.neuron.NeuronModelForCausalLM.config",description:'<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.',name:"config"},{anchor:"optimum.neuron.NeuronModelForCausalLM.model_path",description:`<strong>model_path</strong> (<code>Path</code>) &#x2014; The directory where the compiled artifacts for the model are stored.
It can be a temporary directory if the model has never been saved locally before.`,name:"model_path"},{anchor:"optimum.neuron.NeuronModelForCausalLM.generation_config",description:'<strong>generation_config</strong> (<code>transformers.GenerationConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/text_generation#transformers.GenerationConfig" rel="nofollow">GenerationConfig</a> holds the configuration for the model generation task.',name:"generation_config"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L758"}}),tn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCausalLM.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"cache_ids",val:": Tensor"},{name:"start_ids",val:": Tensor = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForCausalLM.forward.cache_ids",description:"<strong>cache_ids</strong> (<code>torch.LongTensor</code>) &#x2014; The indices at which the cached key and value for the current inputs need to be stored.",name:"cache_ids"},{anchor:"optimum.neuron.NeuronModelForCausalLM.forward.start_ids",description:"<strong>start_ids</strong> (<code>torch.LongTensor</code>) &#x2014; The indices of the first tokens to be processed, deduced form the attention masks.",name:"start_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L785"}}),rt=new U({props:{anchor:"optimum.neuron.NeuronModelForCausalLM.forward.example",$$slots:{default:[np]},$$scope:{ctx:j}}}),nn=new k({props:{title:"NeuronModelForSeq2SeqLM",local:"optimum.neuron.NeuronModelForSeq2SeqLM",headingTag:"h3"}}),on=new $({props:{name:"class optimum.neuron.NeuronModelForSeq2SeqLM",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM",parameters:[{name:"encoder",val:": ScriptModule"},{name:"decoder",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"encoder_file_name",val:": typing.Optional[str] = 'model.neuron'"},{name:"decoder_file_name",val:": typing.Optional[str] = 'model.neuron'"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_configs",val:": typing.Optional[typing.Dict[str, ForwardRef('NeuronDefaultConfig')]] = None"},{name:"configs",val:": typing.Optional[typing.Dict[str, ForwardRef('PretrainedConfig')]] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.encoder",description:'<strong>encoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the encoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"encoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.decoder",description:'<strong>decoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the decoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"decoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_seq2seq.py#L435"}}),rn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward",parameters:[{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"beam_scores",val:": typing.Optional[torch.FloatTensor] = None"},{name:"return_dict",val:": bool = False"},{name:"output_attentions",val:": bool = False"},{name:"output_hidden_states",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_seq2seq.py#L445"}}),at=new qc({props:{$$slots:{default:[op]},$$scope:{ctx:j}}}),st=new U({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example",$$slots:{default:[rp]},$$scope:{ctx:j}}}),lt=new U({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example-2",$$slots:{default:[ap]},$$scope:{ctx:j}}}),an=new k({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),ln=new k({props:{title:"NeuronModelForImageClassification",local:"optimum.neuron.NeuronModelForImageClassification",headingTag:"h3"}}),dn=new $({props:{name:"class optimum.neuron.NeuronModelForImageClassification",anchor:"optimum.neuron.NeuronModelForImageClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForImageClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L452"}}),cn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L472"}}),it=new U({props:{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.example",$$slots:{default:[sp]},$$scope:{ctx:j}}}),pn=new k({props:{title:"NeuronModelForSemanticSegmentation",local:"optimum.neuron.NeuronModelForSemanticSegmentation",headingTag:"h3"}}),mn=new $({props:{name:"class optimum.neuron.NeuronModelForSemanticSegmentation",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L499"}}),un=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L519"}}),dt=new U({props:{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.example",$$slots:{default:[lp]},$$scope:{ctx:j}}}),gn=new k({props:{title:"NeuronModelForObjectDetection",local:"optimum.neuron.NeuronModelForObjectDetection",headingTag:"h3"}}),fn=new $({props:{name:"class optimum.neuron.NeuronModelForObjectDetection",anchor:"optimum.neuron.NeuronModelForObjectDetection",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForObjectDetection.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L546"}}),hn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForObjectDetection.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L566"}}),ct=new U({props:{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.example",$$slots:{default:[ip]},$$scope:{ctx:j}}}),_n=new k({props:{title:"Audio",local:"audio",headingTag:"h2"}}),yn=new k({props:{title:"NeuronModelForAudioClassification",local:"optimum.neuron.NeuronModelForAudioClassification",headingTag:"h3"}}),Mn=new $({props:{name:"class optimum.neuron.NeuronModelForAudioClassification",anchor:"optimum.neuron.NeuronModelForAudioClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L595"}}),vn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L609"}}),pt=new U({props:{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.example",$$slots:{default:[dp]},$$scope:{ctx:j}}}),Nn=new k({props:{title:"NeuronModelForAudioFrameClassification",local:"optimum.neuron.NeuronModelForAudioFrameClassification",headingTag:"h3"}}),wn=new $({props:{name:"class optimum.neuron.NeuronModelForAudioFrameClassification",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L636"}}),Tn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L649"}}),mt=new U({props:{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.example",$$slots:{default:[cp]},$$scope:{ctx:j}}}),$n=new k({props:{title:"NeuronModelForCTC",local:"optimum.neuron.NeuronModelForCTC",headingTag:"h3"}}),jn=new $({props:{name:"class optimum.neuron.NeuronModelForCTC",anchor:"optimum.neuron.NeuronModelForCTC",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForCTC.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L676"}}),kn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCTC.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L690"}}),ut=new U({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example",$$slots:{default:[pp]},$$scope:{ctx:j}}}),gt=new U({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example-2",$$slots:{default:[mp]},$$scope:{ctx:j}}}),Cn=new k({props:{title:"NeuronModelForXVector",local:"optimum.neuron.NeuronModelForXVector",headingTag:"h3"}}),Jn=new $({props:{name:"class optimum.neuron.NeuronModelForXVector",anchor:"optimum.neuron.NeuronModelForXVector",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_file_name",val:": typing.Optional[str] = None"},{name:"preprocessors",val:": typing.Optional[typing.List] = None"},{name:"neuron_config",val:": typing.Optional[ForwardRef('NeuronDefaultConfig')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForXVector.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L717"}}),xn=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForXVector.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling.py#L730"}}),ft=new U({props:{anchor:"optimum.neuron.NeuronModelForXVector.forward.example",$$slots:{default:[up]},$$scope:{ctx:j}}}),Un=new k({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),In=new k({props:{title:"NeuronStableDiffusionPipeline",local:"optimum.neuron.NeuronStableDiffusionPipeline",headingTag:"h3"}}),Zn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionPipeline",anchor:"optimum.neuron.NeuronStableDiffusionPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1558"}}),Xn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),Sn=new k({props:{title:"NeuronStableDiffusionImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",headingTag:"h3"}}),Vn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1571"}}),Wn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),Rn=new k({props:{title:"NeuronStableDiffusionInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",headingTag:"h3"}}),zn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1576"}}),Ln=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),Bn=new k({props:{title:"NeuronLatentConsistencyModelPipeline",local:"optimum.neuron.NeuronLatentConsistencyModelPipeline",headingTag:"h3"}}),Pn=new $({props:{name:"class optimum.neuron.NeuronLatentConsistencyModelPipeline",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1589"}}),Gn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),En=new k({props:{title:"NeuronStableDiffusionControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",headingTag:"h3"}}),Dn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1594"}}),qn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.Optional[typing.List[int]] = None"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>Optional[&quot;PipelineImageInput&quot;]</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet. When <code>prompt</code> is a list, and if a list of images is passed for a single
ControlNet, each will be paired with each prompt in the <code>prompt</code> list. This also applies to multiple
ControlNets, where a list of image lists can be passed to batch for each prompt and each ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt. If it is different from the batch size used for the compiltaion,
it will be overriden by the static batch size of neuron (except for dynamic batching).`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[Union[torch.Generator, List[torch.Generator]]]</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>Optional[PipelineImageInput]</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>Optional[List[torch.Tensor]]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>Union[float, List[float]]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>Union[float, List[float]]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Optional[Union[Callable[[int, int, Dict], None], PipelineCallback, MultiPipelineCallbacks]]</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/pipelines/diffusers/pipeline_controlnet.py#L33",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Hn=new k({props:{title:"NeuronPixArtAlphaPipeline",local:"optimum.neuron.NeuronPixArtAlphaPipeline",headingTag:"h3"}}),Qn=new $({props:{name:"class optimum.neuron.NeuronPixArtAlphaPipeline",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1601"}}),Yn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),An=new k({props:{title:"NeuronStableDiffusionXLPipeline",local:"optimum.neuron.NeuronStableDiffusionXLPipeline",headingTag:"h3"}}),On=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1619"}}),Kn=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),eo=new k({props:{title:"NeuronStableDiffusionXLImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",headingTag:"h3"}}),to=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1632"}}),no=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),oo=new k({props:{title:"NeuronStableDiffusionXLInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",headingTag:"h3"}}),ro=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1639"}}),ao=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1165"}}),so=new k({props:{title:"NeuronStableDiffusionXLControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",headingTag:"h3"}}),lo=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",parameters:[{name:"config",val:": typing.Dict[str, typing.Any]"},{name:"configs",val:": typing.Dict[str, ForwardRef('PretrainedConfig')]"},{name:"neuron_configs",val:": typing.Dict[str, ForwardRef('NeuronDefaultConfig')]"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": typing.Optional[diffusers.schedulers.scheduling_utils.SchedulerMixin]"},{name:"vae_decoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeDecoder')]"},{name:"text_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"text_encoder_2",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTextEncoder'), NoneType] = None"},{name:"unet",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelUnet'), NoneType] = None"},{name:"transformer",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelTransformer'), NoneType] = None"},{name:"vae_encoder",val:": typing.Union[torch.jit._script.ScriptModule, ForwardRef('NeuronModelVaeEncoder'), NoneType] = None"},{name:"image_encoder",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"safety_checker",val:": typing.Optional[torch.jit._script.ScriptModule] = None"},{name:"tokenizer",val:": typing.Union[transformers.models.clip.tokenization_clip.CLIPTokenizer, transformers.utils.dummy_sentencepiece_objects.T5Tokenizer, NoneType] = None"},{name:"tokenizer_2",val:": typing.Optional[transformers.models.clip.tokenization_clip.CLIPTokenizer] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor] = None"},{name:"controlnet",val:": typing.Union[torch.jit._script.ScriptModule, typing.List[torch.jit._script.ScriptModule], ForwardRef('NeuronControlNetModel'), ForwardRef('NeuronMultiControlNetModel'), NoneType] = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"model_and_config_save_paths",val:": typing.Optional[typing.Dict[str, typing.Tuple[str, pathlib.Path]]] = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/modeling_diffusion.py#L1646"}}),io=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"denoising_end",val:": typing.Optional[float] = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_original_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"negative_crops_coords_top_left",val:": typing.Tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": typing.Optional[typing.Tuple[int, int]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>Optional[&quot;PipelineImageInput&quot;]</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>Optional[List[int]]</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>Optional[float]</code>, defaults to <code>None</code>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>Optional[Union[str, List[str]]]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>Optional[Union[torch.Generator, List[torch.Generator]]]</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>Optional[torch.Tensor]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>Optional[PipelineImageInput]</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>Optional[List[torch.Tensor]]</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>Optional[str]</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>Union[float, List[float]]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>Union[float, List[float]]</code>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>Tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>Optional[Tuple[int, int]]</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be as same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>Optional[int]</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Optional[Union[Callable[[int, int, Dict], None], PipelineCallback, MultiPipelineCallbacks]]</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/v0.2.0.dev2/optimum/neuron/pipelines/diffusers/pipeline_controlnet_sd_xl.py#L37",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){l=i("meta"),N=o(),y=i("p"),c=o(),m(M.$$.fragment),t=o(),m(v.$$.fragment),aa=o(),m(Mt.$$.fragment),sa=o(),vt=i("p"),vt.innerHTML=ed,la=o(),C=i("div"),m(Nt.$$.fragment),xs=o(),go=i("p"),go.textContent=td,Us=o(),fo=i("p"),fo.innerHTML=nd,Fs=o(),ho=i("p"),ho.textContent=od,Is=o(),_o=i("ul"),_o.innerHTML=rd,Zs=o(),bo=i("p"),bo.textContent=ad,Xs=o(),yo=i("ul"),yo.innerHTML=sd,Ss=o(),De=i("div"),m(wt.$$.fragment),Vs=o(),Mo=i("p"),Mo.innerHTML=ld,Ws=o(),qe=i("div"),m(Tt.$$.fragment),Rs=o(),vo=i("p"),vo.textContent=id,zs=o(),He=i("div"),m($t.$$.fragment),Ls=o(),No=i("p"),No.innerHTML=dd,Bs=o(),Qe=i("div"),m(jt.$$.fragment),Ps=o(),wo=i("p"),wo.textContent=cd,ia=o(),m(kt.$$.fragment),da=o(),Ct=i("p"),Ct.innerHTML=pd,ca=o(),Z=i("div"),m(Jt.$$.fragment),Gs=o(),To=i("p"),To.textContent=md,Es=o(),$o=i("p"),$o.textContent=ud,Ds=o(),jo=i("ul"),jo.innerHTML=gd,qs=o(),ko=i("p"),ko.textContent=fd,Hs=o(),Co=i("ul"),Co.innerHTML=hd,pa=o(),m(xt.$$.fragment),ma=o(),Ut=i("p"),Ut.textContent=_d,ua=o(),m(Ft.$$.fragment),ga=o(),X=i("div"),m(It.$$.fragment),Qs=o(),Jo=i("p"),Jo.textContent=bd,Ys=o(),xo=i("p"),xo.innerHTML=yd,As=o(),Uo=i("p"),Uo.textContent=Md,Os=o(),de=i("div"),m(Zt.$$.fragment),Ks=o(),Fo=i("p"),Fo.innerHTML=vd,el=o(),m(Ye.$$.fragment),fa=o(),m(Xt.$$.fragment),ha=o(),S=i("div"),m(St.$$.fragment),tl=o(),Io=i("p"),Io.textContent=Nd,nl=o(),Zo=i("p"),Zo.innerHTML=wd,ol=o(),Xo=i("p"),Xo.textContent=Td,rl=o(),se=i("div"),m(Vt.$$.fragment),al=o(),So=i("p"),So.innerHTML=$d,sl=o(),m(Ae.$$.fragment),ll=o(),m(Oe.$$.fragment),_a=o(),m(Wt.$$.fragment),ba=o(),V=i("div"),m(Rt.$$.fragment),il=o(),Vo=i("p"),Vo.textContent=jd,dl=o(),Wo=i("p"),Wo.innerHTML=kd,cl=o(),Ro=i("p"),Ro.textContent=Cd,pl=o(),ce=i("div"),m(zt.$$.fragment),ml=o(),zo=i("p"),zo.innerHTML=Jd,ul=o(),m(Ke.$$.fragment),ya=o(),m(Lt.$$.fragment),Ma=o(),W=i("div"),m(Bt.$$.fragment),gl=o(),Lo=i("p"),Lo.textContent=xd,fl=o(),Bo=i("p"),Bo.innerHTML=Ud,hl=o(),Po=i("p"),Po.textContent=Fd,_l=o(),pe=i("div"),m(Pt.$$.fragment),bl=o(),Go=i("p"),Go.innerHTML=Id,yl=o(),m(et.$$.fragment),va=o(),m(Gt.$$.fragment),Na=o(),R=i("div"),m(Et.$$.fragment),Ml=o(),Eo=i("p"),Eo.textContent=Zd,vl=o(),Do=i("p"),Do.innerHTML=Xd,Nl=o(),qo=i("p"),qo.textContent=Sd,wl=o(),me=i("div"),m(Dt.$$.fragment),Tl=o(),Ho=i("p"),Ho.innerHTML=Vd,$l=o(),m(tt.$$.fragment),wa=o(),m(qt.$$.fragment),Ta=o(),z=i("div"),m(Ht.$$.fragment),jl=o(),Qo=i("p"),Qo.textContent=Wd,kl=o(),Yo=i("p"),Yo.innerHTML=Rd,Cl=o(),Ao=i("p"),Ao.textContent=zd,Jl=o(),ue=i("div"),m(Qt.$$.fragment),xl=o(),Oo=i("p"),Oo.innerHTML=Ld,Ul=o(),m(nt.$$.fragment),$a=o(),m(Yt.$$.fragment),ja=o(),L=i("div"),m(At.$$.fragment),Fl=o(),Ko=i("p"),Ko.textContent=Bd,Il=o(),er=i("p"),er.innerHTML=Pd,Zl=o(),tr=i("p"),tr.textContent=Gd,Xl=o(),ge=i("div"),m(Ot.$$.fragment),Sl=o(),nr=i("p"),nr.innerHTML=Ed,Vl=o(),m(ot.$$.fragment),ka=o(),m(Kt.$$.fragment),Ca=o(),A=i("div"),m(en.$$.fragment),Wl=o(),or=i("p"),or.textContent=Dd,Rl=o(),rr=i("p"),rr.innerHTML=qd,zl=o(),fe=i("div"),m(tn.$$.fragment),Ll=o(),ar=i("p"),ar.innerHTML=Hd,Bl=o(),m(rt.$$.fragment),Ja=o(),m(nn.$$.fragment),xa=o(),O=i("div"),m(on.$$.fragment),Pl=o(),sr=i("p"),sr.textContent=Qd,Gl=o(),lr=i("p"),lr.innerHTML=Yd,El=o(),I=i("div"),m(rn.$$.fragment),Dl=o(),ir=i("p"),ir.innerHTML=Ad,ql=o(),m(at.$$.fragment),Hl=o(),dr=i("p"),dr.innerHTML=Od,Ql=o(),m(st.$$.fragment),Yl=o(),cr=i("p"),cr.innerHTML=Kd,Al=o(),m(lt.$$.fragment),Ua=o(),m(an.$$.fragment),Fa=o(),sn=i("p"),sn.textContent=ec,Ia=o(),m(ln.$$.fragment),Za=o(),B=i("div"),m(dn.$$.fragment),Ol=o(),pr=i("p"),pr.textContent=tc,Kl=o(),mr=i("p"),mr.innerHTML=nc,ei=o(),ur=i("p"),ur.textContent=oc,ti=o(),he=i("div"),m(cn.$$.fragment),ni=o(),gr=i("p"),gr.innerHTML=rc,oi=o(),m(it.$$.fragment),Xa=o(),m(pn.$$.fragment),Sa=o(),P=i("div"),m(mn.$$.fragment),ri=o(),fr=i("p"),fr.textContent=ac,ai=o(),hr=i("p"),hr.innerHTML=sc,si=o(),_r=i("p"),_r.textContent=lc,li=o(),_e=i("div"),m(un.$$.fragment),ii=o(),br=i("p"),br.innerHTML=ic,di=o(),m(dt.$$.fragment),Va=o(),m(gn.$$.fragment),Wa=o(),G=i("div"),m(fn.$$.fragment),ci=o(),yr=i("p"),yr.textContent=dc,pi=o(),Mr=i("p"),Mr.innerHTML=cc,mi=o(),vr=i("p"),vr.textContent=pc,ui=o(),be=i("div"),m(hn.$$.fragment),gi=o(),Nr=i("p"),Nr.innerHTML=mc,fi=o(),m(ct.$$.fragment),Ra=o(),m(_n.$$.fragment),za=o(),bn=i("p"),bn.textContent=uc,La=o(),m(yn.$$.fragment),Ba=o(),E=i("div"),m(Mn.$$.fragment),hi=o(),wr=i("p"),wr.textContent=gc,_i=o(),Tr=i("p"),Tr.innerHTML=fc,bi=o(),$r=i("p"),$r.textContent=hc,yi=o(),ye=i("div"),m(vn.$$.fragment),Mi=o(),jr=i("p"),jr.innerHTML=_c,vi=o(),m(pt.$$.fragment),Pa=o(),m(Nn.$$.fragment),Ga=o(),D=i("div"),m(wn.$$.fragment),Ni=o(),kr=i("p"),kr.textContent=bc,wi=o(),Cr=i("p"),Cr.innerHTML=yc,Ti=o(),Jr=i("p"),Jr.textContent=Mc,$i=o(),Me=i("div"),m(Tn.$$.fragment),ji=o(),xr=i("p"),xr.innerHTML=vc,ki=o(),m(mt.$$.fragment),Ea=o(),m($n.$$.fragment),Da=o(),q=i("div"),m(jn.$$.fragment),Ci=o(),Ur=i("p"),Ur.textContent=Nc,Ji=o(),Fr=i("p"),Fr.innerHTML=wc,xi=o(),Ir=i("p"),Ir.textContent=Tc,Ui=o(),le=i("div"),m(kn.$$.fragment),Fi=o(),Zr=i("p"),Zr.innerHTML=$c,Ii=o(),m(ut.$$.fragment),Zi=o(),m(gt.$$.fragment),qa=o(),m(Cn.$$.fragment),Ha=o(),H=i("div"),m(Jn.$$.fragment),Xi=o(),Xr=i("p"),Xr.textContent=jc,Si=o(),Sr=i("p"),Sr.innerHTML=kc,Vi=o(),Vr=i("p"),Vr.textContent=Cc,Wi=o(),ve=i("div"),m(xn.$$.fragment),Ri=o(),Wr=i("p"),Wr.innerHTML=Jc,zi=o(),m(ft.$$.fragment),Qa=o(),m(Un.$$.fragment),Ya=o(),Fn=i("p"),Fn.textContent=xc,Aa=o(),m(In.$$.fragment),Oa=o(),xe=i("div"),m(Zn.$$.fragment),Li=o(),Rr=i("div"),m(Xn.$$.fragment),Ka=o(),m(Sn.$$.fragment),es=o(),Ue=i("div"),m(Vn.$$.fragment),Bi=o(),zr=i("div"),m(Wn.$$.fragment),ts=o(),m(Rn.$$.fragment),ns=o(),Fe=i("div"),m(zn.$$.fragment),Pi=o(),Lr=i("div"),m(Ln.$$.fragment),os=o(),m(Bn.$$.fragment),rs=o(),Ie=i("div"),m(Pn.$$.fragment),Gi=o(),Br=i("div"),m(Gn.$$.fragment),as=o(),m(En.$$.fragment),ss=o(),Ze=i("div"),m(Dn.$$.fragment),Ei=o(),ht=i("div"),m(qn.$$.fragment),Di=o(),Pr=i("p"),Pr.textContent=Uc,ls=o(),m(Hn.$$.fragment),is=o(),Xe=i("div"),m(Qn.$$.fragment),qi=o(),Gr=i("div"),m(Yn.$$.fragment),ds=o(),m(An.$$.fragment),cs=o(),Se=i("div"),m(On.$$.fragment),Hi=o(),Er=i("div"),m(Kn.$$.fragment),ps=o(),m(eo.$$.fragment),ms=o(),Ve=i("div"),m(to.$$.fragment),Qi=o(),Dr=i("div"),m(no.$$.fragment),us=o(),m(oo.$$.fragment),gs=o(),We=i("div"),m(ro.$$.fragment),Yi=o(),qr=i("div"),m(ao.$$.fragment),fs=o(),m(so.$$.fragment),hs=o(),Re=i("div"),m(lo.$$.fragment),Ai=o(),Ne=i("div"),m(io.$$.fragment),Oi=o(),Hr=i("p"),Hr.textContent=Fc,Ki=o(),Qr=i("p"),Qr.textContent=Ic,_s=o(),ra=i("p"),this.h()},l(e){const s=Dc("svelte-u9bgzb",document.head);l=d(s,"META",{name:!0,content:!0}),s.forEach(a),N=r(e),y=d(e,"P",{}),w(y).forEach(a),c=r(e),u(M.$$.fragment,e),t=r(e),u(v.$$.fragment,e),aa=r(e),u(Mt.$$.fragment,e),sa=r(e),vt=d(e,"P",{"data-svelte-h":!0}),b(vt)!=="svelte-1wqojdr"&&(vt.innerHTML=ed),la=r(e),C=d(e,"DIV",{class:!0});var J=w(C);u(Nt.$$.fragment,J),xs=r(J),go=d(J,"P",{"data-svelte-h":!0}),b(go)!=="svelte-14ur69o"&&(go.textContent=td),Us=r(J),fo=d(J,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-1chwlbt"&&(fo.innerHTML=nd),Fs=r(J),ho=d(J,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-wz8va1"&&(ho.textContent=od),Is=r(J),_o=d(J,"UL",{"data-svelte-h":!0}),b(_o)!=="svelte-7z1nij"&&(_o.innerHTML=rd),Zs=r(J),bo=d(J,"P",{"data-svelte-h":!0}),b(bo)!=="svelte-86gko0"&&(bo.textContent=ad),Xs=r(J),yo=d(J,"UL",{"data-svelte-h":!0}),b(yo)!=="svelte-6hp2og"&&(yo.innerHTML=sd),Ss=r(J),De=d(J,"DIV",{class:!0});var co=w(De);u(wt.$$.fragment,co),Vs=r(co),Mo=d(co,"P",{"data-svelte-h":!0}),b(Mo)!=="svelte-1r2xt0l"&&(Mo.innerHTML=ld),co.forEach(a),Ws=r(J),qe=d(J,"DIV",{class:!0});var po=w(qe);u(Tt.$$.fragment,po),Rs=r(po),vo=d(po,"P",{"data-svelte-h":!0}),b(vo)!=="svelte-fniwno"&&(vo.textContent=id),po.forEach(a),zs=r(J),He=d(J,"DIV",{class:!0});var mo=w(He);u($t.$$.fragment,mo),Ls=r(mo),No=d(mo,"P",{"data-svelte-h":!0}),b(No)!=="svelte-o2sfh1"&&(No.innerHTML=dd),mo.forEach(a),Bs=r(J),Qe=d(J,"DIV",{class:!0});var uo=w(Qe);u(jt.$$.fragment,uo),Ps=r(uo),wo=d(uo,"P",{"data-svelte-h":!0}),b(wo)!=="svelte-2mtl9d"&&(wo.textContent=cd),uo.forEach(a),J.forEach(a),ia=r(e),u(kt.$$.fragment,e),da=r(e),Ct=d(e,"P",{"data-svelte-h":!0}),b(Ct)!=="svelte-zezpv4"&&(Ct.innerHTML=pd),ca=r(e),Z=d(e,"DIV",{class:!0});var Q=w(Z);u(Jt.$$.fragment,Q),Gs=r(Q),To=d(Q,"P",{"data-svelte-h":!0}),b(To)!=="svelte-1gile5t"&&(To.textContent=md),Es=r(Q),$o=d(Q,"P",{"data-svelte-h":!0}),b($o)!=="svelte-1gmwpt4"&&($o.textContent=ud),Ds=r(Q),jo=d(Q,"UL",{"data-svelte-h":!0}),b(jo)!=="svelte-f1my6c"&&(jo.innerHTML=gd),qs=r(Q),ko=d(Q,"P",{"data-svelte-h":!0}),b(ko)!=="svelte-86gko0"&&(ko.textContent=fd),Hs=r(Q),Co=d(Q,"UL",{"data-svelte-h":!0}),b(Co)!=="svelte-21fuuc"&&(Co.innerHTML=hd),Q.forEach(a),pa=r(e),u(xt.$$.fragment,e),ma=r(e),Ut=d(e,"P",{"data-svelte-h":!0}),b(Ut)!=="svelte-1j76tak"&&(Ut.textContent=_d),ua=r(e),u(Ft.$$.fragment,e),ga=r(e),X=d(e,"DIV",{class:!0});var K=w(X);u(It.$$.fragment,K),Qs=r(K),Jo=d(K,"P",{"data-svelte-h":!0}),b(Jo)!=="svelte-tyb6d9"&&(Jo.textContent=bd),Ys=r(K),xo=d(K,"P",{"data-svelte-h":!0}),b(xo)!=="svelte-t21i2g"&&(xo.innerHTML=yd),As=r(K),Uo=d(K,"P",{"data-svelte-h":!0}),b(Uo)!=="svelte-1nitj0t"&&(Uo.textContent=Md),Os=r(K),de=d(K,"DIV",{class:!0});var ze=w(de);u(Zt.$$.fragment,ze),Ks=r(ze),Fo=d(ze,"P",{"data-svelte-h":!0}),b(Fo)!=="svelte-cgjaxs"&&(Fo.innerHTML=vd),el=r(ze),u(Ye.$$.fragment,ze),ze.forEach(a),K.forEach(a),fa=r(e),u(Xt.$$.fragment,e),ha=r(e),S=d(e,"DIV",{class:!0});var ee=w(S);u(St.$$.fragment,ee),tl=r(ee),Io=d(ee,"P",{"data-svelte-h":!0}),b(Io)!=="svelte-o9alfo"&&(Io.textContent=Nd),nl=r(ee),Zo=d(ee,"P",{"data-svelte-h":!0}),b(Zo)!=="svelte-t21i2g"&&(Zo.innerHTML=wd),ol=r(ee),Xo=d(ee,"P",{"data-svelte-h":!0}),b(Xo)!=="svelte-fib3qb"&&(Xo.textContent=Td),rl=r(ee),se=d(ee,"DIV",{class:!0});var ie=w(se);u(Vt.$$.fragment,ie),al=r(ie),So=d(ie,"P",{"data-svelte-h":!0}),b(So)!=="svelte-mm1jdo"&&(So.innerHTML=$d),sl=r(ie),u(Ae.$$.fragment,ie),ll=r(ie),u(Oe.$$.fragment,ie),ie.forEach(a),ee.forEach(a),_a=r(e),u(Wt.$$.fragment,e),ba=r(e),V=d(e,"DIV",{class:!0});var te=w(V);u(Rt.$$.fragment,te),il=r(te),Vo=d(te,"P",{"data-svelte-h":!0}),b(Vo)!=="svelte-12nn25"&&(Vo.textContent=jd),dl=r(te),Wo=d(te,"P",{"data-svelte-h":!0}),b(Wo)!=="svelte-t21i2g"&&(Wo.innerHTML=kd),cl=r(te),Ro=d(te,"P",{"data-svelte-h":!0}),b(Ro)!=="svelte-1y0nyf2"&&(Ro.textContent=Cd),pl=r(te),ce=d(te,"DIV",{class:!0});var Le=w(ce);u(zt.$$.fragment,Le),ml=r(Le),zo=d(Le,"P",{"data-svelte-h":!0}),b(zo)!=="svelte-8d129p"&&(zo.innerHTML=Jd),ul=r(Le),u(Ke.$$.fragment,Le),Le.forEach(a),te.forEach(a),ya=r(e),u(Lt.$$.fragment,e),Ma=r(e),W=d(e,"DIV",{class:!0});var ne=w(W);u(Bt.$$.fragment,ne),gl=r(ne),Lo=d(ne,"P",{"data-svelte-h":!0}),b(Lo)!=="svelte-sy64kq"&&(Lo.textContent=xd),fl=r(ne),Bo=d(ne,"P",{"data-svelte-h":!0}),b(Bo)!=="svelte-t21i2g"&&(Bo.innerHTML=Ud),hl=r(ne),Po=d(ne,"P",{"data-svelte-h":!0}),b(Po)!=="svelte-1pso76n"&&(Po.textContent=Fd),_l=r(ne),pe=d(ne,"DIV",{class:!0});var Be=w(pe);u(Pt.$$.fragment,Be),bl=r(Be),Go=d(Be,"P",{"data-svelte-h":!0}),b(Go)!=="svelte-1qtopj4"&&(Go.innerHTML=Id),yl=r(Be),u(et.$$.fragment,Be),Be.forEach(a),ne.forEach(a),va=r(e),u(Gt.$$.fragment,e),Na=r(e),R=d(e,"DIV",{class:!0});var oe=w(R);u(Et.$$.fragment,oe),Ml=r(oe),Eo=d(oe,"P",{"data-svelte-h":!0}),b(Eo)!=="svelte-196ytxv"&&(Eo.textContent=Zd),vl=r(oe),Do=d(oe,"P",{"data-svelte-h":!0}),b(Do)!=="svelte-t21i2g"&&(Do.innerHTML=Xd),Nl=r(oe),qo=d(oe,"P",{"data-svelte-h":!0}),b(qo)!=="svelte-8xyl8y"&&(qo.textContent=Sd),wl=r(oe),me=d(oe,"DIV",{class:!0});var Pe=w(me);u(Dt.$$.fragment,Pe),Tl=r(Pe),Ho=d(Pe,"P",{"data-svelte-h":!0}),b(Ho)!=="svelte-1il3s71"&&(Ho.innerHTML=Vd),$l=r(Pe),u(tt.$$.fragment,Pe),Pe.forEach(a),oe.forEach(a),wa=r(e),u(qt.$$.fragment,e),Ta=r(e),z=d(e,"DIV",{class:!0});var re=w(z);u(Ht.$$.fragment,re),jl=r(re),Qo=d(re,"P",{"data-svelte-h":!0}),b(Qo)!=="svelte-16p5zms"&&(Qo.textContent=Wd),kl=r(re),Yo=d(re,"P",{"data-svelte-h":!0}),b(Yo)!=="svelte-t21i2g"&&(Yo.innerHTML=Rd),Cl=r(re),Ao=d(re,"P",{"data-svelte-h":!0}),b(Ao)!=="svelte-1hvccyd"&&(Ao.textContent=zd),Jl=r(re),ue=d(re,"DIV",{class:!0});var Ge=w(ue);u(Qt.$$.fragment,Ge),xl=r(Ge),Oo=d(Ge,"P",{"data-svelte-h":!0}),b(Oo)!=="svelte-x5ht8e"&&(Oo.innerHTML=Ld),Ul=r(Ge),u(nt.$$.fragment,Ge),Ge.forEach(a),re.forEach(a),$a=r(e),u(Yt.$$.fragment,e),ja=r(e),L=d(e,"DIV",{class:!0});var ae=w(L);u(At.$$.fragment,ae),Fl=r(ae),Ko=d(ae,"P",{"data-svelte-h":!0}),b(Ko)!=="svelte-1kpvzm3"&&(Ko.textContent=Bd),Il=r(ae),er=d(ae,"P",{"data-svelte-h":!0}),b(er)!=="svelte-t21i2g"&&(er.innerHTML=Pd),Zl=r(ae),tr=d(ae,"P",{"data-svelte-h":!0}),b(tr)!=="svelte-v7xrhz"&&(tr.textContent=Gd),Xl=r(ae),ge=d(ae,"DIV",{class:!0});var Ee=w(ge);u(Ot.$$.fragment,Ee),Sl=r(Ee),nr=d(Ee,"P",{"data-svelte-h":!0}),b(nr)!=="svelte-kejd1q"&&(nr.innerHTML=Ed),Vl=r(Ee),u(ot.$$.fragment,Ee),Ee.forEach(a),ae.forEach(a),ka=r(e),u(Kt.$$.fragment,e),Ca=r(e),A=d(e,"DIV",{class:!0});var _t=w(A);u(en.$$.fragment,_t),Wl=r(_t),or=d(_t,"P",{"data-svelte-h":!0}),b(or)!=="svelte-1dh7ria"&&(or.textContent=Dd),Rl=r(_t),rr=d(_t,"P",{"data-svelte-h":!0}),b(rr)!=="svelte-1k2rogh"&&(rr.innerHTML=qd),zl=r(_t),fe=d(_t,"DIV",{class:!0});var Yr=w(fe);u(tn.$$.fragment,Yr),Ll=r(Yr),ar=d(Yr,"P",{"data-svelte-h":!0}),b(ar)!=="svelte-1i4ci8l"&&(ar.innerHTML=Hd),Bl=r(Yr),u(rt.$$.fragment,Yr),Yr.forEach(a),_t.forEach(a),Ja=r(e),u(nn.$$.fragment,e),xa=r(e),O=d(e,"DIV",{class:!0});var bt=w(O);u(on.$$.fragment,bt),Pl=r(bt),sr=d(bt,"P",{"data-svelte-h":!0}),b(sr)!=="svelte-12et8hl"&&(sr.textContent=Qd),Gl=r(bt),lr=d(bt,"P",{"data-svelte-h":!0}),b(lr)!=="svelte-t21i2g"&&(lr.innerHTML=Yd),El=r(bt),I=d(bt,"DIV",{class:!0});var Y=w(I);u(rn.$$.fragment,Y),Dl=r(Y),ir=d(Y,"P",{"data-svelte-h":!0}),b(ir)!=="svelte-1joduis"&&(ir.innerHTML=Ad),ql=r(Y),u(at.$$.fragment,Y),Hl=r(Y),dr=d(Y,"P",{"data-svelte-h":!0}),b(dr)!=="svelte-1osiy1t"&&(dr.innerHTML=Od),Ql=r(Y),u(st.$$.fragment,Y),Yl=r(Y),cr=d(Y,"P",{"data-svelte-h":!0}),b(cr)!=="svelte-89pj2f"&&(cr.innerHTML=Kd),Al=r(Y),u(lt.$$.fragment,Y),Y.forEach(a),bt.forEach(a),Ua=r(e),u(an.$$.fragment,e),Fa=r(e),sn=d(e,"P",{"data-svelte-h":!0}),b(sn)!=="svelte-dmb9sp"&&(sn.textContent=ec),Ia=r(e),u(ln.$$.fragment,e),Za=r(e),B=d(e,"DIV",{class:!0});var we=w(B);u(dn.$$.fragment,we),Ol=r(we),pr=d(we,"P",{"data-svelte-h":!0}),b(pr)!=="svelte-iobswt"&&(pr.textContent=tc),Kl=r(we),mr=d(we,"P",{"data-svelte-h":!0}),b(mr)!=="svelte-t21i2g"&&(mr.innerHTML=nc),ei=r(we),ur=d(we,"P",{"data-svelte-h":!0}),b(ur)!=="svelte-1g4h8eb"&&(ur.textContent=oc),ti=r(we),he=d(we,"DIV",{class:!0});var Ar=w(he);u(cn.$$.fragment,Ar),ni=r(Ar),gr=d(Ar,"P",{"data-svelte-h":!0}),b(gr)!=="svelte-4a7c7i"&&(gr.innerHTML=rc),oi=r(Ar),u(it.$$.fragment,Ar),Ar.forEach(a),we.forEach(a),Xa=r(e),u(pn.$$.fragment,e),Sa=r(e),P=d(e,"DIV",{class:!0});var Te=w(P);u(mn.$$.fragment,Te),ri=r(Te),fr=d(Te,"P",{"data-svelte-h":!0}),b(fr)!=="svelte-a522e4"&&(fr.textContent=ac),ai=r(Te),hr=d(Te,"P",{"data-svelte-h":!0}),b(hr)!=="svelte-t21i2g"&&(hr.innerHTML=sc),si=r(Te),_r=d(Te,"P",{"data-svelte-h":!0}),b(_r)!=="svelte-jb8c8r"&&(_r.textContent=lc),li=r(Te),_e=d(Te,"DIV",{class:!0});var Or=w(_e);u(un.$$.fragment,Or),ii=r(Or),br=d(Or,"P",{"data-svelte-h":!0}),b(br)!=="svelte-kcdbet"&&(br.innerHTML=ic),di=r(Or),u(dt.$$.fragment,Or),Or.forEach(a),Te.forEach(a),Va=r(e),u(gn.$$.fragment,e),Wa=r(e),G=d(e,"DIV",{class:!0});var $e=w(G);u(fn.$$.fragment,$e),ci=r($e),yr=d($e,"P",{"data-svelte-h":!0}),b(yr)!=="svelte-1jokdk4"&&(yr.textContent=dc),pi=r($e),Mr=d($e,"P",{"data-svelte-h":!0}),b(Mr)!=="svelte-t21i2g"&&(Mr.innerHTML=cc),mi=r($e),vr=d($e,"P",{"data-svelte-h":!0}),b(vr)!=="svelte-pqeh18"&&(vr.textContent=pc),ui=r($e),be=d($e,"DIV",{class:!0});var Kr=w(be);u(hn.$$.fragment,Kr),gi=r(Kr),Nr=d(Kr,"P",{"data-svelte-h":!0}),b(Nr)!=="svelte-rg1qqx"&&(Nr.innerHTML=mc),fi=r(Kr),u(ct.$$.fragment,Kr),Kr.forEach(a),$e.forEach(a),Ra=r(e),u(_n.$$.fragment,e),za=r(e),bn=d(e,"P",{"data-svelte-h":!0}),b(bn)!=="svelte-1htpfc5"&&(bn.textContent=uc),La=r(e),u(yn.$$.fragment,e),Ba=r(e),E=d(e,"DIV",{class:!0});var je=w(E);u(Mn.$$.fragment,je),hi=r(je),wr=d(je,"P",{"data-svelte-h":!0}),b(wr)!=="svelte-13994kt"&&(wr.textContent=gc),_i=r(je),Tr=d(je,"P",{"data-svelte-h":!0}),b(Tr)!=="svelte-t21i2g"&&(Tr.innerHTML=fc),bi=r(je),$r=d(je,"P",{"data-svelte-h":!0}),b($r)!=="svelte-iwso1f"&&($r.textContent=hc),yi=r(je),ye=d(je,"DIV",{class:!0});var ea=w(ye);u(vn.$$.fragment,ea),Mi=r(ea),jr=d(ea,"P",{"data-svelte-h":!0}),b(jr)!=="svelte-1mrzugx"&&(jr.innerHTML=_c),vi=r(ea),u(pt.$$.fragment,ea),ea.forEach(a),je.forEach(a),Pa=r(e),u(Nn.$$.fragment,e),Ga=r(e),D=d(e,"DIV",{class:!0});var ke=w(D);u(wn.$$.fragment,ke),Ni=r(ke),kr=d(ke,"P",{"data-svelte-h":!0}),b(kr)!=="svelte-1wtizei"&&(kr.textContent=bc),wi=r(ke),Cr=d(ke,"P",{"data-svelte-h":!0}),b(Cr)!=="svelte-t21i2g"&&(Cr.innerHTML=yc),Ti=r(ke),Jr=d(ke,"P",{"data-svelte-h":!0}),b(Jr)!=="svelte-484vqn"&&(Jr.textContent=Mc),$i=r(ke),Me=d(ke,"DIV",{class:!0});var ta=w(Me);u(Tn.$$.fragment,ta),ji=r(ta),xr=d(ta,"P",{"data-svelte-h":!0}),b(xr)!=="svelte-hohte"&&(xr.innerHTML=vc),ki=r(ta),u(mt.$$.fragment,ta),ta.forEach(a),ke.forEach(a),Ea=r(e),u($n.$$.fragment,e),Da=r(e),q=d(e,"DIV",{class:!0});var Ce=w(q);u(jn.$$.fragment,Ce),Ci=r(Ce),Ur=d(Ce,"P",{"data-svelte-h":!0}),b(Ur)!=="svelte-1minwrj"&&(Ur.textContent=Nc),Ji=r(Ce),Fr=d(Ce,"P",{"data-svelte-h":!0}),b(Fr)!=="svelte-t21i2g"&&(Fr.innerHTML=wc),xi=r(Ce),Ir=d(Ce,"P",{"data-svelte-h":!0}),b(Ir)!=="svelte-1dft1qw"&&(Ir.textContent=Tc),Ui=r(Ce),le=d(Ce,"DIV",{class:!0});var yt=w(le);u(kn.$$.fragment,yt),Fi=r(yt),Zr=d(yt,"P",{"data-svelte-h":!0}),b(Zr)!=="svelte-33b8wf"&&(Zr.innerHTML=$c),Ii=r(yt),u(ut.$$.fragment,yt),Zi=r(yt),u(gt.$$.fragment,yt),yt.forEach(a),Ce.forEach(a),qa=r(e),u(Cn.$$.fragment,e),Ha=r(e),H=d(e,"DIV",{class:!0});var Je=w(H);u(Jn.$$.fragment,Je),Xi=r(Je),Xr=d(Je,"P",{"data-svelte-h":!0}),b(Xr)!=="svelte-ylsbuv"&&(Xr.textContent=jc),Si=r(Je),Sr=d(Je,"P",{"data-svelte-h":!0}),b(Sr)!=="svelte-t21i2g"&&(Sr.innerHTML=kc),Vi=r(Je),Vr=d(Je,"P",{"data-svelte-h":!0}),b(Vr)!=="svelte-ylsbuv"&&(Vr.textContent=Cc),Wi=r(Je),ve=d(Je,"DIV",{class:!0});var na=w(ve);u(xn.$$.fragment,na),Ri=r(na),Wr=d(na,"P",{"data-svelte-h":!0}),b(Wr)!=="svelte-190wczg"&&(Wr.innerHTML=Jc),zi=r(na),u(ft.$$.fragment,na),na.forEach(a),Je.forEach(a),Qa=r(e),u(Un.$$.fragment,e),Ya=r(e),Fn=d(e,"P",{"data-svelte-h":!0}),b(Fn)!=="svelte-149jhtw"&&(Fn.textContent=xc),Aa=r(e),u(In.$$.fragment,e),Oa=r(e),xe=d(e,"DIV",{class:!0});var ys=w(xe);u(Zn.$$.fragment,ys),Li=r(ys),Rr=d(ys,"DIV",{class:!0});var Zc=w(Rr);u(Xn.$$.fragment,Zc),Zc.forEach(a),ys.forEach(a),Ka=r(e),u(Sn.$$.fragment,e),es=r(e),Ue=d(e,"DIV",{class:!0});var Ms=w(Ue);u(Vn.$$.fragment,Ms),Bi=r(Ms),zr=d(Ms,"DIV",{class:!0});var Xc=w(zr);u(Wn.$$.fragment,Xc),Xc.forEach(a),Ms.forEach(a),ts=r(e),u(Rn.$$.fragment,e),ns=r(e),Fe=d(e,"DIV",{class:!0});var vs=w(Fe);u(zn.$$.fragment,vs),Pi=r(vs),Lr=d(vs,"DIV",{class:!0});var Sc=w(Lr);u(Ln.$$.fragment,Sc),Sc.forEach(a),vs.forEach(a),os=r(e),u(Bn.$$.fragment,e),rs=r(e),Ie=d(e,"DIV",{class:!0});var Ns=w(Ie);u(Pn.$$.fragment,Ns),Gi=r(Ns),Br=d(Ns,"DIV",{class:!0});var Vc=w(Br);u(Gn.$$.fragment,Vc),Vc.forEach(a),Ns.forEach(a),as=r(e),u(En.$$.fragment,e),ss=r(e),Ze=d(e,"DIV",{class:!0});var ws=w(Ze);u(Dn.$$.fragment,ws),Ei=r(ws),ht=d(ws,"DIV",{class:!0});var Ts=w(ht);u(qn.$$.fragment,Ts),Di=r(Ts),Pr=d(Ts,"P",{"data-svelte-h":!0}),b(Pr)!=="svelte-50j04k"&&(Pr.textContent=Uc),Ts.forEach(a),ws.forEach(a),ls=r(e),u(Hn.$$.fragment,e),is=r(e),Xe=d(e,"DIV",{class:!0});var $s=w(Xe);u(Qn.$$.fragment,$s),qi=r($s),Gr=d($s,"DIV",{class:!0});var Wc=w(Gr);u(Yn.$$.fragment,Wc),Wc.forEach(a),$s.forEach(a),ds=r(e),u(An.$$.fragment,e),cs=r(e),Se=d(e,"DIV",{class:!0});var js=w(Se);u(On.$$.fragment,js),Hi=r(js),Er=d(js,"DIV",{class:!0});var Rc=w(Er);u(Kn.$$.fragment,Rc),Rc.forEach(a),js.forEach(a),ps=r(e),u(eo.$$.fragment,e),ms=r(e),Ve=d(e,"DIV",{class:!0});var ks=w(Ve);u(to.$$.fragment,ks),Qi=r(ks),Dr=d(ks,"DIV",{class:!0});var zc=w(Dr);u(no.$$.fragment,zc),zc.forEach(a),ks.forEach(a),us=r(e),u(oo.$$.fragment,e),gs=r(e),We=d(e,"DIV",{class:!0});var Cs=w(We);u(ro.$$.fragment,Cs),Yi=r(Cs),qr=d(Cs,"DIV",{class:!0});var Lc=w(qr);u(ao.$$.fragment,Lc),Lc.forEach(a),Cs.forEach(a),fs=r(e),u(so.$$.fragment,e),hs=r(e),Re=d(e,"DIV",{class:!0});var Js=w(Re);u(lo.$$.fragment,Js),Ai=r(Js),Ne=d(Js,"DIV",{class:!0});var oa=w(Ne);u(io.$$.fragment,oa),Oi=r(oa),Hr=d(oa,"P",{"data-svelte-h":!0}),b(Hr)!=="svelte-50j04k"&&(Hr.textContent=Fc),Ki=r(oa),Qr=d(oa,"P",{"data-svelte-h":!0}),b(Qr)!=="svelte-kvfsh7"&&(Qr.textContent=Ic),oa.forEach(a),Js.forEach(a),_s=r(e),ra=d(e,"P",{}),w(ra).forEach(a),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",fp),T(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Rr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(zr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Lr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Br,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ht,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Gr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Er,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Dr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){n(document.head,l),p(e,N,s),p(e,y,s),p(e,c,s),g(M,e,s),p(e,t,s),g(v,e,s),p(e,aa,s),g(Mt,e,s),p(e,sa,s),p(e,vt,s),p(e,la,s),p(e,C,s),g(Nt,C,null),n(C,xs),n(C,go),n(C,Us),n(C,fo),n(C,Fs),n(C,ho),n(C,Is),n(C,_o),n(C,Zs),n(C,bo),n(C,Xs),n(C,yo),n(C,Ss),n(C,De),g(wt,De,null),n(De,Vs),n(De,Mo),n(C,Ws),n(C,qe),g(Tt,qe,null),n(qe,Rs),n(qe,vo),n(C,zs),n(C,He),g($t,He,null),n(He,Ls),n(He,No),n(C,Bs),n(C,Qe),g(jt,Qe,null),n(Qe,Ps),n(Qe,wo),p(e,ia,s),g(kt,e,s),p(e,da,s),p(e,Ct,s),p(e,ca,s),p(e,Z,s),g(Jt,Z,null),n(Z,Gs),n(Z,To),n(Z,Es),n(Z,$o),n(Z,Ds),n(Z,jo),n(Z,qs),n(Z,ko),n(Z,Hs),n(Z,Co),p(e,pa,s),g(xt,e,s),p(e,ma,s),p(e,Ut,s),p(e,ua,s),g(Ft,e,s),p(e,ga,s),p(e,X,s),g(It,X,null),n(X,Qs),n(X,Jo),n(X,Ys),n(X,xo),n(X,As),n(X,Uo),n(X,Os),n(X,de),g(Zt,de,null),n(de,Ks),n(de,Fo),n(de,el),g(Ye,de,null),p(e,fa,s),g(Xt,e,s),p(e,ha,s),p(e,S,s),g(St,S,null),n(S,tl),n(S,Io),n(S,nl),n(S,Zo),n(S,ol),n(S,Xo),n(S,rl),n(S,se),g(Vt,se,null),n(se,al),n(se,So),n(se,sl),g(Ae,se,null),n(se,ll),g(Oe,se,null),p(e,_a,s),g(Wt,e,s),p(e,ba,s),p(e,V,s),g(Rt,V,null),n(V,il),n(V,Vo),n(V,dl),n(V,Wo),n(V,cl),n(V,Ro),n(V,pl),n(V,ce),g(zt,ce,null),n(ce,ml),n(ce,zo),n(ce,ul),g(Ke,ce,null),p(e,ya,s),g(Lt,e,s),p(e,Ma,s),p(e,W,s),g(Bt,W,null),n(W,gl),n(W,Lo),n(W,fl),n(W,Bo),n(W,hl),n(W,Po),n(W,_l),n(W,pe),g(Pt,pe,null),n(pe,bl),n(pe,Go),n(pe,yl),g(et,pe,null),p(e,va,s),g(Gt,e,s),p(e,Na,s),p(e,R,s),g(Et,R,null),n(R,Ml),n(R,Eo),n(R,vl),n(R,Do),n(R,Nl),n(R,qo),n(R,wl),n(R,me),g(Dt,me,null),n(me,Tl),n(me,Ho),n(me,$l),g(tt,me,null),p(e,wa,s),g(qt,e,s),p(e,Ta,s),p(e,z,s),g(Ht,z,null),n(z,jl),n(z,Qo),n(z,kl),n(z,Yo),n(z,Cl),n(z,Ao),n(z,Jl),n(z,ue),g(Qt,ue,null),n(ue,xl),n(ue,Oo),n(ue,Ul),g(nt,ue,null),p(e,$a,s),g(Yt,e,s),p(e,ja,s),p(e,L,s),g(At,L,null),n(L,Fl),n(L,Ko),n(L,Il),n(L,er),n(L,Zl),n(L,tr),n(L,Xl),n(L,ge),g(Ot,ge,null),n(ge,Sl),n(ge,nr),n(ge,Vl),g(ot,ge,null),p(e,ka,s),g(Kt,e,s),p(e,Ca,s),p(e,A,s),g(en,A,null),n(A,Wl),n(A,or),n(A,Rl),n(A,rr),n(A,zl),n(A,fe),g(tn,fe,null),n(fe,Ll),n(fe,ar),n(fe,Bl),g(rt,fe,null),p(e,Ja,s),g(nn,e,s),p(e,xa,s),p(e,O,s),g(on,O,null),n(O,Pl),n(O,sr),n(O,Gl),n(O,lr),n(O,El),n(O,I),g(rn,I,null),n(I,Dl),n(I,ir),n(I,ql),g(at,I,null),n(I,Hl),n(I,dr),n(I,Ql),g(st,I,null),n(I,Yl),n(I,cr),n(I,Al),g(lt,I,null),p(e,Ua,s),g(an,e,s),p(e,Fa,s),p(e,sn,s),p(e,Ia,s),g(ln,e,s),p(e,Za,s),p(e,B,s),g(dn,B,null),n(B,Ol),n(B,pr),n(B,Kl),n(B,mr),n(B,ei),n(B,ur),n(B,ti),n(B,he),g(cn,he,null),n(he,ni),n(he,gr),n(he,oi),g(it,he,null),p(e,Xa,s),g(pn,e,s),p(e,Sa,s),p(e,P,s),g(mn,P,null),n(P,ri),n(P,fr),n(P,ai),n(P,hr),n(P,si),n(P,_r),n(P,li),n(P,_e),g(un,_e,null),n(_e,ii),n(_e,br),n(_e,di),g(dt,_e,null),p(e,Va,s),g(gn,e,s),p(e,Wa,s),p(e,G,s),g(fn,G,null),n(G,ci),n(G,yr),n(G,pi),n(G,Mr),n(G,mi),n(G,vr),n(G,ui),n(G,be),g(hn,be,null),n(be,gi),n(be,Nr),n(be,fi),g(ct,be,null),p(e,Ra,s),g(_n,e,s),p(e,za,s),p(e,bn,s),p(e,La,s),g(yn,e,s),p(e,Ba,s),p(e,E,s),g(Mn,E,null),n(E,hi),n(E,wr),n(E,_i),n(E,Tr),n(E,bi),n(E,$r),n(E,yi),n(E,ye),g(vn,ye,null),n(ye,Mi),n(ye,jr),n(ye,vi),g(pt,ye,null),p(e,Pa,s),g(Nn,e,s),p(e,Ga,s),p(e,D,s),g(wn,D,null),n(D,Ni),n(D,kr),n(D,wi),n(D,Cr),n(D,Ti),n(D,Jr),n(D,$i),n(D,Me),g(Tn,Me,null),n(Me,ji),n(Me,xr),n(Me,ki),g(mt,Me,null),p(e,Ea,s),g($n,e,s),p(e,Da,s),p(e,q,s),g(jn,q,null),n(q,Ci),n(q,Ur),n(q,Ji),n(q,Fr),n(q,xi),n(q,Ir),n(q,Ui),n(q,le),g(kn,le,null),n(le,Fi),n(le,Zr),n(le,Ii),g(ut,le,null),n(le,Zi),g(gt,le,null),p(e,qa,s),g(Cn,e,s),p(e,Ha,s),p(e,H,s),g(Jn,H,null),n(H,Xi),n(H,Xr),n(H,Si),n(H,Sr),n(H,Vi),n(H,Vr),n(H,Wi),n(H,ve),g(xn,ve,null),n(ve,Ri),n(ve,Wr),n(ve,zi),g(ft,ve,null),p(e,Qa,s),g(Un,e,s),p(e,Ya,s),p(e,Fn,s),p(e,Aa,s),g(In,e,s),p(e,Oa,s),p(e,xe,s),g(Zn,xe,null),n(xe,Li),n(xe,Rr),g(Xn,Rr,null),p(e,Ka,s),g(Sn,e,s),p(e,es,s),p(e,Ue,s),g(Vn,Ue,null),n(Ue,Bi),n(Ue,zr),g(Wn,zr,null),p(e,ts,s),g(Rn,e,s),p(e,ns,s),p(e,Fe,s),g(zn,Fe,null),n(Fe,Pi),n(Fe,Lr),g(Ln,Lr,null),p(e,os,s),g(Bn,e,s),p(e,rs,s),p(e,Ie,s),g(Pn,Ie,null),n(Ie,Gi),n(Ie,Br),g(Gn,Br,null),p(e,as,s),g(En,e,s),p(e,ss,s),p(e,Ze,s),g(Dn,Ze,null),n(Ze,Ei),n(Ze,ht),g(qn,ht,null),n(ht,Di),n(ht,Pr),p(e,ls,s),g(Hn,e,s),p(e,is,s),p(e,Xe,s),g(Qn,Xe,null),n(Xe,qi),n(Xe,Gr),g(Yn,Gr,null),p(e,ds,s),g(An,e,s),p(e,cs,s),p(e,Se,s),g(On,Se,null),n(Se,Hi),n(Se,Er),g(Kn,Er,null),p(e,ps,s),g(eo,e,s),p(e,ms,s),p(e,Ve,s),g(to,Ve,null),n(Ve,Qi),n(Ve,Dr),g(no,Dr,null),p(e,us,s),g(oo,e,s),p(e,gs,s),p(e,We,s),g(ro,We,null),n(We,Yi),n(We,qr),g(ao,qr,null),p(e,fs,s),g(so,e,s),p(e,hs,s),p(e,Re,s),g(lo,Re,null),n(Re,Ai),n(Re,Ne),g(io,Ne,null),n(Ne,Oi),n(Ne,Hr),n(Ne,Ki),n(Ne,Qr),p(e,_s,s),p(e,ra,s),bs=!0},p(e,[s]){const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),Ye.$set(J);const co={};s&2&&(co.$$scope={dirty:s,ctx:e}),Ae.$set(co);const po={};s&2&&(po.$$scope={dirty:s,ctx:e}),Oe.$set(po);const mo={};s&2&&(mo.$$scope={dirty:s,ctx:e}),Ke.$set(mo);const uo={};s&2&&(uo.$$scope={dirty:s,ctx:e}),et.$set(uo);const Q={};s&2&&(Q.$$scope={dirty:s,ctx:e}),tt.$set(Q);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),nt.$set(K);const ze={};s&2&&(ze.$$scope={dirty:s,ctx:e}),ot.$set(ze);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),rt.$set(ee);const ie={};s&2&&(ie.$$scope={dirty:s,ctx:e}),at.$set(ie);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),st.$set(te);const Le={};s&2&&(Le.$$scope={dirty:s,ctx:e}),lt.$set(Le);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),it.$set(ne);const Be={};s&2&&(Be.$$scope={dirty:s,ctx:e}),dt.$set(Be);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),ct.$set(oe);const Pe={};s&2&&(Pe.$$scope={dirty:s,ctx:e}),pt.$set(Pe);const re={};s&2&&(re.$$scope={dirty:s,ctx:e}),mt.$set(re);const Ge={};s&2&&(Ge.$$scope={dirty:s,ctx:e}),ut.$set(Ge);const ae={};s&2&&(ae.$$scope={dirty:s,ctx:e}),gt.$set(ae);const Ee={};s&2&&(Ee.$$scope={dirty:s,ctx:e}),ft.$set(Ee)},i(e){bs||(f(M.$$.fragment,e),f(v.$$.fragment,e),f(Mt.$$.fragment,e),f(Nt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f($t.$$.fragment,e),f(jt.$$.fragment,e),f(kt.$$.fragment,e),f(Jt.$$.fragment,e),f(xt.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(Zt.$$.fragment,e),f(Ye.$$.fragment,e),f(Xt.$$.fragment,e),f(St.$$.fragment,e),f(Vt.$$.fragment,e),f(Ae.$$.fragment,e),f(Oe.$$.fragment,e),f(Wt.$$.fragment,e),f(Rt.$$.fragment,e),f(zt.$$.fragment,e),f(Ke.$$.fragment,e),f(Lt.$$.fragment,e),f(Bt.$$.fragment,e),f(Pt.$$.fragment,e),f(et.$$.fragment,e),f(Gt.$$.fragment,e),f(Et.$$.fragment,e),f(Dt.$$.fragment,e),f(tt.$$.fragment,e),f(qt.$$.fragment,e),f(Ht.$$.fragment,e),f(Qt.$$.fragment,e),f(nt.$$.fragment,e),f(Yt.$$.fragment,e),f(At.$$.fragment,e),f(Ot.$$.fragment,e),f(ot.$$.fragment,e),f(Kt.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(rt.$$.fragment,e),f(nn.$$.fragment,e),f(on.$$.fragment,e),f(rn.$$.fragment,e),f(at.$$.fragment,e),f(st.$$.fragment,e),f(lt.$$.fragment,e),f(an.$$.fragment,e),f(ln.$$.fragment,e),f(dn.$$.fragment,e),f(cn.$$.fragment,e),f(it.$$.fragment,e),f(pn.$$.fragment,e),f(mn.$$.fragment,e),f(un.$$.fragment,e),f(dt.$$.fragment,e),f(gn.$$.fragment,e),f(fn.$$.fragment,e),f(hn.$$.fragment,e),f(ct.$$.fragment,e),f(_n.$$.fragment,e),f(yn.$$.fragment,e),f(Mn.$$.fragment,e),f(vn.$$.fragment,e),f(pt.$$.fragment,e),f(Nn.$$.fragment,e),f(wn.$$.fragment,e),f(Tn.$$.fragment,e),f(mt.$$.fragment,e),f($n.$$.fragment,e),f(jn.$$.fragment,e),f(kn.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(Cn.$$.fragment,e),f(Jn.$$.fragment,e),f(xn.$$.fragment,e),f(ft.$$.fragment,e),f(Un.$$.fragment,e),f(In.$$.fragment,e),f(Zn.$$.fragment,e),f(Xn.$$.fragment,e),f(Sn.$$.fragment,e),f(Vn.$$.fragment,e),f(Wn.$$.fragment,e),f(Rn.$$.fragment,e),f(zn.$$.fragment,e),f(Ln.$$.fragment,e),f(Bn.$$.fragment,e),f(Pn.$$.fragment,e),f(Gn.$$.fragment,e),f(En.$$.fragment,e),f(Dn.$$.fragment,e),f(qn.$$.fragment,e),f(Hn.$$.fragment,e),f(Qn.$$.fragment,e),f(Yn.$$.fragment,e),f(An.$$.fragment,e),f(On.$$.fragment,e),f(Kn.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(no.$$.fragment,e),f(oo.$$.fragment,e),f(ro.$$.fragment,e),f(ao.$$.fragment,e),f(so.$$.fragment,e),f(lo.$$.fragment,e),f(io.$$.fragment,e),bs=!0)},o(e){h(M.$$.fragment,e),h(v.$$.fragment,e),h(Mt.$$.fragment,e),h(Nt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h($t.$$.fragment,e),h(jt.$$.fragment,e),h(kt.$$.fragment,e),h(Jt.$$.fragment,e),h(xt.$$.fragment,e),h(Ft.$$.fragment,e),h(It.$$.fragment,e),h(Zt.$$.fragment,e),h(Ye.$$.fragment,e),h(Xt.$$.fragment,e),h(St.$$.fragment,e),h(Vt.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(Wt.$$.fragment,e),h(Rt.$$.fragment,e),h(zt.$$.fragment,e),h(Ke.$$.fragment,e),h(Lt.$$.fragment,e),h(Bt.$$.fragment,e),h(Pt.$$.fragment,e),h(et.$$.fragment,e),h(Gt.$$.fragment,e),h(Et.$$.fragment,e),h(Dt.$$.fragment,e),h(tt.$$.fragment,e),h(qt.$$.fragment,e),h(Ht.$$.fragment,e),h(Qt.$$.fragment,e),h(nt.$$.fragment,e),h(Yt.$$.fragment,e),h(At.$$.fragment,e),h(Ot.$$.fragment,e),h(ot.$$.fragment,e),h(Kt.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(rt.$$.fragment,e),h(nn.$$.fragment,e),h(on.$$.fragment,e),h(rn.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(an.$$.fragment,e),h(ln.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(it.$$.fragment,e),h(pn.$$.fragment,e),h(mn.$$.fragment,e),h(un.$$.fragment,e),h(dt.$$.fragment,e),h(gn.$$.fragment,e),h(fn.$$.fragment,e),h(hn.$$.fragment,e),h(ct.$$.fragment,e),h(_n.$$.fragment,e),h(yn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(pt.$$.fragment,e),h(Nn.$$.fragment,e),h(wn.$$.fragment,e),h(Tn.$$.fragment,e),h(mt.$$.fragment,e),h($n.$$.fragment,e),h(jn.$$.fragment,e),h(kn.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(Cn.$$.fragment,e),h(Jn.$$.fragment,e),h(xn.$$.fragment,e),h(ft.$$.fragment,e),h(Un.$$.fragment,e),h(In.$$.fragment,e),h(Zn.$$.fragment,e),h(Xn.$$.fragment,e),h(Sn.$$.fragment,e),h(Vn.$$.fragment,e),h(Wn.$$.fragment,e),h(Rn.$$.fragment,e),h(zn.$$.fragment,e),h(Ln.$$.fragment,e),h(Bn.$$.fragment,e),h(Pn.$$.fragment,e),h(Gn.$$.fragment,e),h(En.$$.fragment,e),h(Dn.$$.fragment,e),h(qn.$$.fragment,e),h(Hn.$$.fragment,e),h(Qn.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(no.$$.fragment,e),h(oo.$$.fragment,e),h(ro.$$.fragment,e),h(ao.$$.fragment,e),h(so.$$.fragment,e),h(lo.$$.fragment,e),h(io.$$.fragment,e),bs=!1},d(e){e&&(a(N),a(y),a(c),a(t),a(aa),a(sa),a(vt),a(la),a(C),a(ia),a(da),a(Ct),a(ca),a(Z),a(pa),a(ma),a(Ut),a(ua),a(ga),a(X),a(fa),a(ha),a(S),a(_a),a(ba),a(V),a(ya),a(Ma),a(W),a(va),a(Na),a(R),a(wa),a(Ta),a(z),a($a),a(ja),a(L),a(ka),a(Ca),a(A),a(Ja),a(xa),a(O),a(Ua),a(Fa),a(sn),a(Ia),a(Za),a(B),a(Xa),a(Sa),a(P),a(Va),a(Wa),a(G),a(Ra),a(za),a(bn),a(La),a(Ba),a(E),a(Pa),a(Ga),a(D),a(Ea),a(Da),a(q),a(qa),a(Ha),a(H),a(Qa),a(Ya),a(Fn),a(Aa),a(Oa),a(xe),a(Ka),a(es),a(Ue),a(ts),a(ns),a(Fe),a(os),a(rs),a(Ie),a(as),a(ss),a(Ze),a(ls),a(is),a(Xe),a(ds),a(cs),a(Se),a(ps),a(ms),a(Ve),a(us),a(gs),a(We),a(fs),a(hs),a(Re),a(_s),a(ra)),a(l),_(M,e),_(v,e),_(Mt,e),_(Nt),_(wt),_(Tt),_($t),_(jt),_(kt,e),_(Jt),_(xt,e),_(Ft,e),_(It),_(Zt),_(Ye),_(Xt,e),_(St),_(Vt),_(Ae),_(Oe),_(Wt,e),_(Rt),_(zt),_(Ke),_(Lt,e),_(Bt),_(Pt),_(et),_(Gt,e),_(Et),_(Dt),_(tt),_(qt,e),_(Ht),_(Qt),_(nt),_(Yt,e),_(At),_(Ot),_(ot),_(Kt,e),_(en),_(tn),_(rt),_(nn,e),_(on),_(rn),_(at),_(st),_(lt),_(an,e),_(ln,e),_(dn),_(cn),_(it),_(pn,e),_(mn),_(un),_(dt),_(gn,e),_(fn),_(hn),_(ct),_(_n,e),_(yn,e),_(Mn),_(vn),_(pt),_(Nn,e),_(wn),_(Tn),_(mt),_($n,e),_(jn),_(kn),_(ut),_(gt),_(Cn,e),_(Jn),_(xn),_(ft),_(Un,e),_(In,e),_(Zn),_(Xn),_(Sn,e),_(Vn),_(Wn),_(Rn,e),_(zn),_(Ln),_(Bn,e),_(Pn),_(Gn),_(En,e),_(Dn),_(qn),_(Hn,e),_(Qn),_(Yn),_(An,e),_(On),_(Kn),_(eo,e),_(to),_(no),_(oo,e),_(ro),_(ao),_(so,e),_(lo),_(io)}}}const fp='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"NeuronTracedModel","local":"optimum.neuron.NeuronTracedModel","sections":[],"depth":3},{"title":"NeuronDecoderModel","local":"optimum.neuron.NeuronDecoderModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"NeuronModelForFeatureExtraction","local":"optimum.neuron.NeuronModelForFeatureExtraction","sections":[],"depth":3},{"title":"NeuronModelForSentenceTransformers","local":"optimum.neuron.NeuronModelForSentenceTransformers","sections":[],"depth":3},{"title":"NeuronModelForMaskedLM","local":"optimum.neuron.NeuronModelForMaskedLM","sections":[],"depth":3},{"title":"NeuronModelForSequenceClassification","local":"optimum.neuron.NeuronModelForSequenceClassification","sections":[],"depth":3},{"title":"NeuronModelForQuestionAnswering","local":"optimum.neuron.NeuronModelForQuestionAnswering","sections":[],"depth":3},{"title":"NeuronModelForTokenClassification","local":"optimum.neuron.NeuronModelForTokenClassification","sections":[],"depth":3},{"title":"NeuronModelForMultipleChoice","local":"optimum.neuron.NeuronModelForMultipleChoice","sections":[],"depth":3},{"title":"NeuronModelForCausalLM","local":"optimum.neuron.NeuronModelForCausalLM","sections":[],"depth":3},{"title":"NeuronModelForSeq2SeqLM","local":"optimum.neuron.NeuronModelForSeq2SeqLM","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"NeuronModelForImageClassification","local":"optimum.neuron.NeuronModelForImageClassification","sections":[],"depth":3},{"title":"NeuronModelForSemanticSegmentation","local":"optimum.neuron.NeuronModelForSemanticSegmentation","sections":[],"depth":3},{"title":"NeuronModelForObjectDetection","local":"optimum.neuron.NeuronModelForObjectDetection","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"NeuronModelForAudioClassification","local":"optimum.neuron.NeuronModelForAudioClassification","sections":[],"depth":3},{"title":"NeuronModelForAudioFrameClassification","local":"optimum.neuron.NeuronModelForAudioFrameClassification","sections":[],"depth":3},{"title":"NeuronModelForCTC","local":"optimum.neuron.NeuronModelForCTC","sections":[],"depth":3},{"title":"NeuronModelForXVector","local":"optimum.neuron.NeuronModelForXVector","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"NeuronStableDiffusionPipeline","local":"optimum.neuron.NeuronStableDiffusionPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionInpaintPipeline","sections":[],"depth":3},{"title":"NeuronLatentConsistencyModelPipeline","local":"optimum.neuron.NeuronLatentConsistencyModelPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionControlNetPipeline","sections":[],"depth":3},{"title":"NeuronPixArtAlphaPipeline","local":"optimum.neuron.NeuronPixArtAlphaPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLPipeline","local":"optimum.neuron.NeuronStableDiffusionXLPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline","sections":[],"depth":3}],"depth":2}],"depth":1}';function hp(j){return Pc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tp extends Gc{constructor(l){super(),Ec(this,l,hp,gp,Bc,{})}}export{Tp as component};
