import{s as Ea,o as Na,n as oe}from"../chunks/scheduler.182ea377.js";import{S as Fa,i as Da,g as r,s as o,r as g,A as Ra,h as l,f as i,c as a,j as M,u,x as y,k as I,y as t,a as p,v as f,d as _,t as h,w as b}from"../chunks/index.abf12888.js";import{T as Ba}from"../chunks/Tip.230e2334.js";import{D as P}from"../chunks/Docstring.93f6f462.js";import{C as xe}from"../chunks/CodeBlock.57fe6e13.js";import{E as Te}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as N}from"../chunks/Heading.16916d63.js";function Qa(T){let s,w='Check out the <a href="https://huggingface.co/kandinsky-community" rel="nofollow">Kandinsky Community</a> organization on the Hub for the official model checkpoints for tasks like text-to-image, image-to-image, and inpainting.';return{c(){s=r("p"),s.innerHTML=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1nfky5i"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:oe,d(m){m&&i(s)}}}function Xa(T){let s,w='Make sure to check out the schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){s=r("p"),s.innerHTML=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),y(s)!=="svelte-1rr33yw"&&(s.innerHTML=w)},m(m,c){p(m,s,c)},p:oe,d(m){m&&i(s)}}}function za(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBaW1hZ2VfZW1iJTJDJTIwbmVnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpLnRvX3R1cGxlKCklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0RuZWdhdGl2ZV9pbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBoZWlnaHQlM0Q3NjglMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSkuaW1hZ2VzJTBBaW1hZ2UlNUIwJTVELnNhdmUoJTIyY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, negative_image_emb = pipe_prior(prompt).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Ya(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUlMkMlMjBLYW5kaW5za3lWMjJQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBaW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2h2aXNpb24lMjBpbXBvcnQlMjB0cmFuc2Zvcm1zJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFpbWcxJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGY2F0LnBuZyUyMiUwQSklMEFpbWcyJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZGlmZnVzZXJzLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTIyJTBBJTIwJTIwJTIwJTIwJTIyJTJGa2FuZGluc2t5JTJGc3RhcnJ5X25pZ2h0LmpwZWclMjIlMEEpJTBBaW1hZ2VzX3RleHRzJTIwJTNEJTIwJTVCJTIyYSUyMGNhdCUyMiUyQyUyMGltZzElMkMlMjBpbWcyJTVEJTBBd2VpZ2h0cyUyMCUzRCUyMCU1QjAuMyUyQyUyMDAuMyUyQyUyMDAuNCU1RCUwQW91dCUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RvdXQuaW1hZ2VfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJzdGFycnlfY2F0LnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior.interpolate(images_texts, weights)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=out.image_embeds,
<span class="hljs-meta">... </span>    negative_image_embeds=out.negative_image_embeds,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Sa(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZV9wcmlvciUyMCUzRCUyMEthbmRpbnNreVYyMlByaW9yUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLXByaW9yJTIyKSUwQXBpcGVfcHJpb3IudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJyZWQlMjBjYXQlMkMlMjA0ayUyMHBob3RvJTIyJTBBb3V0JTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQpJTBBaW1hZ2VfZW1iJTIwJTNEJTIwb3V0LmltYWdlX2VtYmVkcyUwQXplcm9faW1hZ2VfZW1iJTIwJTNEJTIwb3V0Lm5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUwQXBpcGUlMjAlM0QlMjBLYW5kaW5za3lWMjJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMGltYWdlX2VtYmVkcyUzRGltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX2ltYWdlX2VtYmVkcyUzRHplcm9faW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEEpLmltYWdlcyUwQWltYWdlJTVCMCU1RC5zYXZlKCUyMmNhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>out = pipe_prior(prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb = out.image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>zero_image_emb = out.negative_image_embeds
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(<span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Ha(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQXBpcGUuZW5hYmxlX21vZGVsX2NwdV9vZmZsb2FkKCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwbGlvbiUyMGluJTIwZ2FsYXhpZXMlMkMlMjBzcGlyYWxzJTJDJTIwbmVidWxhZSUyQyUyMHN0YXJzJTJDJTIwc21va2UlMkMlMjBpcmlkZXNjZW50JTJDJTIwaW50cmljYXRlJTIwZGV0YWlsJTJDJTIwb2N0YW5lJTIwcmVuZGVyJTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDI1KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipe = AutoPipelineForText2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A lion in galaxies, spirals, nebulae, stars, smoke, iridescent, intricate detail, octane render, 8k&quot;</span>

image = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Aa(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUHJpb3JFbWIyRW1iUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIycmVkJTIwY2F0JTJDJTIwNGslMjBwaG90byUyMiUwQWltZyUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBaW1hZ2VfZW1iJTJDJTIwbmFnYXRpdmVfaW1hZ2VfZW1iJTIwJTNEJTIwcGlwZV9wcmlvcihwcm9tcHQlMkMlMjBpbWFnZSUzRGltZyUyQyUyMHN0cmVuZ3RoJTNEMC4yKS50b190dXBsZSgpJTBBJTBBcGlwZSUyMCUzRCUyMEthbmRpbnNreVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1kZWNvZGVyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTIyJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2VfZW1iZWRzJTNEaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfaW1hZ2VfZW1iZWRzJTNEbmVnYXRpdmVfaW1hZ2VfZW1iJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0Q3NjglMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAwJTJDJTBBKS5pbWFnZXMlMEElMEFpbWFnZSU1QjAlNUQuc2F2ZSglMjJjYXQucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22Pipeline, KandinskyV22PriorEmb2EmbPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyPriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;red cat, 4k photo&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>img = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, nagative_image_emb = pipe_prior(prompt, image=img, strength=<span class="hljs-number">0.2</span>).to_tuple()

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder, torch_dtype=torch.float16&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=negative_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>).images

<span class="hljs-meta">&gt;&gt;&gt; </span>image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function Oa(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEthbmRpbnNreVYyMlByaW9yRW1iMkVtYlBpcGVsaW5lJTJDJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMFBJTCUwQSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMHRvcmNodmlzaW9uJTIwaW1wb3J0JTIwdHJhbnNmb3JtcyUwQSUwQXBpcGVfcHJpb3IlMjAlM0QlMjBLYW5kaW5za3lWMjJQcmlvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJrYW5kaW5za3ktY29tbXVuaXR5JTJGa2FuZGluc2t5LTItMi1wcmlvciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlX3ByaW9yLnRvKCUyMmN1ZGElMjIpJTBBJTBBaW1nMSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRmNhdC5wbmclMjIlMEEpJTBBJTBBaW1nMiUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyMiUwQSUyMCUyMCUyMCUyMCUyMiUyRmthbmRpbnNreSUyRnN0YXJyeV9uaWdodC5qcGVnJTIyJTBBKSUwQSUwQWltYWdlc190ZXh0cyUyMCUzRCUyMCU1QiUyMmElMjBjYXQlMjIlMkMlMjBpbWcxJTJDJTIwaW1nMiU1RCUwQXdlaWdodHMlMjAlM0QlMjAlNUIwLjMlMkMlMjAwLjMlMkMlMjAwLjQlNUQlMEFpbWFnZV9lbWIlMkMlMjB6ZXJvX2ltYWdlX2VtYiUyMCUzRCUyMHBpcGVfcHJpb3IuaW50ZXJwb2xhdGUoaW1hZ2VzX3RleHRzJTJDJTIwd2VpZ2h0cyklMEElMEFwaXBlJTIwJTNEJTIwS2FuZGluc2t5VjIyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBpbWFnZV9lbWJlZHMlM0RpbWFnZV9lbWIlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9pbWFnZV9lbWJlZHMlM0R6ZXJvX2ltYWdlX2VtYiUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNENzY4JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDE1MCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUwQWltYWdlLnNhdmUoJTIyc3RhcnJ5X2NhdC5wbmclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> KandinskyV22PriorEmb2EmbPipeline, KandinskyV22Pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision <span class="hljs-keyword">import</span> transforms

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior = KandinskyV22PriorPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-prior&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe_prior.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img1 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>img2 = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;/kandinsky/starry_night.jpeg&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>images_texts = [<span class="hljs-string">&quot;a cat&quot;</span>, img1, img2]
<span class="hljs-meta">&gt;&gt;&gt; </span>weights = [<span class="hljs-number">0.3</span>, <span class="hljs-number">0.3</span>, <span class="hljs-number">0.4</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image_emb, zero_image_emb = pipe_prior.interpolate(images_texts, weights)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = KandinskyV22Pipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    image_embeds=image_emb,
<span class="hljs-meta">... </span>    negative_image_embeds=zero_image_emb,
<span class="hljs-meta">... </span>    height=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    width=<span class="hljs-number">768</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">150</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;starry_cat.png&quot;</span>)`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ei(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBvcyUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIya2FuZGluc2t5LWNvbW11bml0eSUyRmthbmRpbnNreS0yLTItZGVjb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGQ29tcFZpcyUyRnN0YWJsZS1kaWZmdXNpb24lMkZtYWluJTJGYXNzZXRzJTJGc3RhYmxlLXNhbXBsZXMlMkZpbWcyaW1nJTJGc2tldGNoLW1vdW50YWlucy1pbnB1dC5qcGclMjIlMEElMEFyZXNwb25zZSUyMCUzRCUyMHJlcXVlc3RzLmdldCh1cmwpJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQWltYWdlLnRodW1ibmFpbCgoNzY4JTJDJTIwNzY4KSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0RvcmlnaW5hbF9pbWFnZSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> os

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>

response = requests.get(url)
image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image.thumbnail((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>))

image = pipe(prompt=prompt, image=original_image, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ni(T){let s,w="Examples:",m,c,k;return c=new xe({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmclMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWltcG9ydCUyMHRvcmNoJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmthbmRpbnNreS1jb21tdW5pdHklMkZrYW5kaW5za3ktMi0yLWRlY29kZXItaW5wYWludCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjBDaW5lbWF0aWMlMjBsaWdodGluZyUyMiUwQW5lZ2F0aXZlX3Byb21wdCUyMCUzRCUyMCUyMmxvdyUyMHF1YWxpdHklMkMlMjBiYWQlMjBxdWFsaXR5JTIyJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZkaWZmdXNlcnMtaW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMjIlMjAlMjIlMkZrYW5kaW5za3klMkZjYXQucG5nJTIyJTBBKSUwQSUwQW1hc2slMjAlM0QlMjBucC56ZXJvcygoNzY4JTJDJTIwNzY4KSUyQyUyMGR0eXBlJTNEbnAuZmxvYXQzMiklMEElMjMlMjBMZXQncyUyMG1hc2slMjBvdXQlMjBhbiUyMGFyZWElMjBhYm92ZSUyMHRoZSUyMGNhdCdzJTIwaGVhZCUwQW1hc2slNUIlM0EyNTAlMkMlMjAyNTAlM0EtMjUwJTVEJTIwJTNEJTIwMSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRG9yaWdpbmFsX2ltYWdlJTJDJTIwbWFza19pbWFnZSUzRG1hc2slMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;kandinsky-community/kandinsky-2-2-decoder-inpaint&quot;</span>, torch_dtype=torch.float16
)
pipe.enable_model_cpu_offload()

prompt = <span class="hljs-string">&quot;A fantasy landscape, Cinematic lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main&quot;</span> <span class="hljs-string">&quot;/kandinsky/cat.png&quot;</span>
)

mask = np.zeros((<span class="hljs-number">768</span>, <span class="hljs-number">768</span>), dtype=np.float32)
<span class="hljs-comment"># Let&#x27;s mask out an area above the cat&#x27;s head</span>
mask[:<span class="hljs-number">250</span>, <span class="hljs-number">250</span>:-<span class="hljs-number">250</span>] = <span class="hljs-number">1</span>

image = pipe(prompt=prompt, image=original_image, mask_image=mask, num_inference_steps=<span class="hljs-number">25</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=r("p"),s.textContent=w,m=o(),g(c.$$.fragment)},l(n){s=l(n,"P",{"data-svelte-h":!0}),y(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=a(n),u(c.$$.fragment,n)},m(n,v){p(n,s,v),p(n,m,v),f(c,n,v),k=!0},p:oe,i(n){k||(_(c.$$.fragment,n),k=!0)},o(n){h(c.$$.fragment,n),k=!1},d(n){n&&(i(s),i(m)),b(c,n)}}}function ti(T){let s,w,m,c,k,n,v,So='Kandinsky 2.2 is created by <a href="https://github.com/cene555" rel="nofollow">Arseniy Shakhmatov</a>, <a href="https://github.com/razzant" rel="nofollow">Anton Razzhigaev</a>, <a href="https://github.com/AlexWortega" rel="nofollow">Aleksandr Nikolich</a>, <a href="https://github.com/oriBetelgeuse" rel="nofollow">Vladimir Arkhipkin</a>, <a href="https://github.com/boomb0om" rel="nofollow">Igor Pavlov</a>, <a href="https://github.com/kuznetsoffandrey" rel="nofollow">Andrey Kuznetsov</a>, and <a href="https://github.com/denndimitrov" rel="nofollow">Denis Dimitrov</a>.',dt,Ce,Ho="The description from it’s GitHub page is:",ct,Ve,Ao="<em>Kandinsky 2.2 brings substantial improvements upon its predecessor, Kandinsky 2.1, by introducing a new, more powerful image encoder - CLIP-ViT-G and the ControlNet support. The switch to CLIP-ViT-G as the image encoder significantly increases the model’s capability to generate more aesthetic pictures and better understand text, thus enhancing the model’s overall performance. The addition of the ControlNet mechanism allows the model to effectively control the process of generating images. This leads to more accurate and visually appealing outputs and opens new possibilities for text-guided image manipulation.</em>",pt,Je,Oo='The original codebase can be found at <a href="https://github.com/ai-forever/Kandinsky-2" rel="nofollow">ai-forever/Kandinsky-2</a>.',mt,de,gt,ce,ut,Ue,ft,C,$e,Lt,fn,ea="Pipeline for generating image prior for Kandinsky",Bt,_n,na=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Et,F,je,Nt,hn,ta="Function invoked when calling the pipeline for generation.",Ft,pe,Dt,D,Ze,Rt,bn,oa="Function invoked when using the prior pipeline for interpolation.",Qt,me,_t,We,ht,$,Ke,Xt,yn,aa="Pipeline for text-to-image generation using Kandinsky",zt,kn,ia=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Yt,R,Ge,St,vn,sa="Function invoked when calling the pipeline for generation.",Ht,ge,bt,qe,yt,V,Le,At,wn,ra="Combined Pipeline for text-to-image generation using Kandinsky",Ot,Mn,la=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,eo,Q,Be,no,In,da="Function invoked when calling the pipeline for generation.",to,ue,oo,fe,Ee,ao,Pn,ca=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,kt,Ne,vt,j,Fe,io,Tn,pa="Pipeline for text-to-image generation using Kandinsky",so,xn,ma=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,ro,X,De,lo,Cn,ga="Function invoked when calling the pipeline for generation.",co,Vn,ua="Examples:",wt,Re,Mt,J,Qe,po,Jn,fa="Pipeline for generating image prior for Kandinsky",mo,Un,_a=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,go,z,Xe,uo,$n,ha="Function invoked when calling the pipeline for generation.",fo,_e,_o,Y,ze,ho,jn,ba="Function invoked when using the prior pipeline for interpolation.",bo,he,It,Ye,Pt,Z,Se,yo,Zn,ya="Pipeline for image-to-image generation using Kandinsky",ko,Wn,ka=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,vo,S,He,wo,Kn,va="Function invoked when calling the pipeline for generation.",Mo,Gn,wa="Examples:",Tt,Ae,xt,x,Oe,Io,qn,Ma="Combined Pipeline for image-to-image generation using Kandinsky",Po,Ln,Ia=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,To,H,en,xo,Bn,Pa="Function invoked when calling the pipeline for generation.",Co,be,Vo,ye,nn,Jo,En,Ta=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Uo,ke,tn,$o,Nn,xa=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Ct,on,Vt,W,an,jo,Fn,Ca="Pipeline for image-to-image generation using Kandinsky",Zo,Dn,Va=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Wo,A,sn,Ko,Rn,Ja="Function invoked when calling the pipeline for generation.",Go,Qn,Ua="Examples:",Jt,rn,Ut,K,ln,qo,Xn,$a="Pipeline for text-guided image inpainting using Kandinsky2.1",Lo,zn,ja=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Bo,O,dn,Eo,Yn,Za="Function invoked when calling the pipeline for generation.",No,Sn,Wa="Examples:",$t,cn,jt,U,pn,Fo,Hn,Ka="Combined Pipeline for inpainting generation using Kandinsky",Do,An,Ga=`This model inherits from <a href="/docs/diffusers/v0.26.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,Ro,ee,mn,Qo,On,qa="Function invoked when calling the pipeline for generation.",Xo,ve,zo,we,gn,Yo,et,La=`Offloads all models to CPU using accelerate, significantly reducing memory usage. When called, unet,
text_encoder, vae and safety checker have their state dicts saved to CPU and then are moved to a
<code>torch.device(&#39;meta&#39;) and loaded to GPU only when their specific submodule has its </code>forward<code>method called. Note that offloading happens on a submodule basis. Memory savings are higher than with</code>enable_model_cpu_offload\`, but performance is lower.`,Zt,lt,Wt;return k=new N({props:{title:"Kandinsky 2.2",local:"kandinsky-22",headingTag:"h1"}}),de=new Ba({props:{$$slots:{default:[Qa]},$$scope:{ctx:T}}}),ce=new Ba({props:{$$slots:{default:[Xa]},$$scope:{ctx:T}}}),Ue=new N({props:{title:"KandinskyV22PriorPipeline",local:"diffusers.KandinskyV22PriorPipeline",headingTag:"h2"}}),$e=new P({props:{name:"class diffusers.KandinskyV22PriorPipeline",anchor:"diffusers.KandinskyV22PriorPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22PriorPipeline.image_processor",description:`<strong>image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"image_processor"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L84"}}),je=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L370",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),pe=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.__call__.example",$$slots:{default:[za]},$$scope:{ctx:T}}}),Ze=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior.py#L131",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),me=new Te({props:{anchor:"diffusers.KandinskyV22PriorPipeline.interpolate.example",$$slots:{default:[Ya]},$$scope:{ctx:T}}}),We=new N({props:{title:"KandinskyV22Pipeline",local:"diffusers.KandinskyV22Pipeline",headingTag:"h2"}}),Ke=new P({props:{name:"class diffusers.KandinskyV22Pipeline",anchor:"diffusers.KandinskyV22Pipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Pipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L64"}}),Ge=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Pipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Pipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Pipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2.py#L122",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ge=new Te({props:{anchor:"diffusers.KandinskyV22Pipeline.__call__.example",$$slots:{default:[Sa]},$$scope:{ctx:T}}}),qe=new N({props:{title:"KandinskyV22CombinedPipeline",local:"diffusers.KandinskyV22CombinedPipeline",headingTag:"h2"}}),Le=new P({props:{name:"class diffusers.KandinskyV22CombinedPipeline",anchor:"diffusers.KandinskyV22CombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22CombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22CombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L107"}}),Be=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22CombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the prior pipeline.
The function is called with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your prior pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference of the decoder pipeline.
The function is called with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors
as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L201",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ue=new Te({props:{anchor:"diffusers.KandinskyV22CombinedPipeline.__call__.example",$$slots:{default:[Ha]},$$scope:{ctx:T}}}),Ee=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22CombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L181"}}),Ne=new N({props:{title:"KandinskyV22ControlnetPipeline",local:"diffusers.KandinskyV22ControlnetPipeline",headingTag:"h2"}}),Fe=new P({props:{name:"class diffusers.KandinskyV22ControlnetPipeline",anchor:"diffusers.KandinskyV22ControlnetPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L106"}}),De=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet.py#L151",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Re=new N({props:{title:"KandinskyV22PriorEmb2EmbPipeline",local:"diffusers.KandinskyV22PriorEmb2EmbPipeline",headingTag:"h2"}}),Qe=new P({props:{name:"class diffusers.KandinskyV22PriorEmb2EmbPipeline",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline",parameters:[{name:"prior",val:": PriorTransformer"},{name:"image_encoder",val:": CLIPVisionModelWithProjection"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"scheduler",val:": UnCLIPScheduler"},{name:"image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.prior",description:`<strong>prior</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"image_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"text_encoder"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.scheduler",description:`<strong>scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"scheduler"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L102"}}),Xe=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"strength",val:": float = 0.3"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"guidance_scale",val:": float = 4.0"},{name:"output_type",val:": Optional = 'pt'"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>emb</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added.`,name:"strength"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.emb",description:`<strong>emb</strong> (<code>torch.FloatTensor</code>) &#x2014;
The image embedding.`,name:"emb"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pt&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;np&quot;</code> (<code>np.array</code>) or <code>&quot;pt&quot;</code>
(<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L396",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),_e=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.__call__.example",$$slots:{default:[Aa]},$$scope:{ctx:T}}}),ze=new P({props:{name:"interpolate",anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate",parameters:[{name:"images_and_prompts",val:": List"},{name:"weights",val:": List"},{name:"num_images_per_prompt",val:": int = 1"},{name:"num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"negative_prior_prompt",val:": Optional = None"},{name:"negative_prompt",val:": str = ''"},{name:"guidance_scale",val:": float = 4.0"},{name:"device",val:" = None"}],parametersDescription:[{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.images_and_prompts",description:`<strong>images_and_prompts</strong> (<code>List[Union[str, PIL.Image.Image, torch.FloatTensor]]</code>) &#x2014;
list of prompts and images to guide the image generation.
weights &#x2014; (<code>List[float]</code>):
list of weights for each condition in <code>images_and_prompts</code>`,name:"images_and_prompts"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prior_prompt",description:`<strong>negative_prior_prompt</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The prompt not to guide the prior diffusion process. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prior_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt not to guide the image generation. Ignored when not using guidance (i.e., ignored if
<code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_prior_emb2emb.py#L155",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>KandinskyPriorPipelineOutput</code> or <code>tuple</code></p>
`}}),he=new Te({props:{anchor:"diffusers.KandinskyV22PriorEmb2EmbPipeline.interpolate.example",$$slots:{default:[Oa]},$$scope:{ctx:T}}}),Ye=new N({props:{title:"KandinskyV22Img2ImgPipeline",local:"diffusers.KandinskyV22Img2ImgPipeline",headingTag:"h2"}}),Se=new P({props:{name:"class diffusers.KandinskyV22Img2ImgPipeline",anchor:"diffusers.KandinskyV22Img2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L92"}}),He=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22Img2ImgPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_img2img.py#L190",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),Ae=new N({props:{title:"KandinskyV22Img2ImgCombinedPipeline",local:"diffusers.KandinskyV22Img2ImgCombinedPipeline",headingTag:"h2"}}),Oe=new P({props:{name:"class diffusers.KandinskyV22Img2ImgCombinedPipeline",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L334"}}),en=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"}],parametersDescription:[{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.3) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L438",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),be=new Te({props:{anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.__call__.example",$$slots:{default:[ei]},$$scope:{ctx:T}}}),nn=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L408"}}),tn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22Img2ImgCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L418"}}),on=new N({props:{title:"KandinskyV22ControlnetImg2ImgPipeline",local:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",headingTag:"h2"}}),an=new P({props:{name:"class diffusers.KandinskyV22ControlnetImg2ImgPipeline",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L120"}}),sn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"hint",val:": FloatTensor"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"strength",val:": float = 0.3"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.strength",description:`<strong>strength</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
Conceptually, indicates how much to transform the reference <code>image</code>. Must be between 0 and 1. <code>image</code>
will be used as a starting point, adding more noise to it the larger the <code>strength</code>. The number of
denoising steps depends on the amount of noise initially added. When <code>strength</code> is 1, added noise will
be maximum and the denoising process will run for the full number of iterations specified in
<code>num_inference_steps</code>. A value of 1, therefore, essentially ignores <code>image</code>.`,name:"strength"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.hint",description:`<strong>hint</strong> (<code>torch.FloatTensor</code>) &#x2014;
The controlnet condition.`,name:"hint"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.KandinskyV22ControlnetImg2ImgPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_controlnet_img2img.py#L206",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),rn=new N({props:{title:"KandinskyV22InpaintPipeline",local:"diffusers.KandinskyV22InpaintPipeline",headingTag:"h2"}}),ln=new P({props:{name:"class diffusers.KandinskyV22InpaintPipeline",anchor:"diffusers.KandinskyV22InpaintPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.26.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L235"}}),dn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintPipeline.__call__",parameters:[{name:"image_embeds",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_image_embeds",val:": Union"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image_embeds",description:`<strong>image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for text prompt, that will be used to condition the image generation.`,name:"image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.image",description:`<strong>image</strong> (<code>PIL.Image.Image</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch which will be inpainted, <em>i.e.</em> parts of the image will
be masked out with <code>mask_image</code> and repainted according to <code>prompt</code>.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.negative_image_embeds",description:`<strong>negative_image_embeds</strong> (<code>torch.FloatTensor</code> or <code>List[torch.FloatTensor]</code>) &#x2014;
The clip image embeddings for negative text prompt, will be used to condition the image generation.`,name:"negative_image_embeds"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_inpainting.py#L294",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),cn=new N({props:{title:"KandinskyV22InpaintCombinedPipeline",local:"diffusers.KandinskyV22InpaintCombinedPipeline",headingTag:"h2"}}),pn=new P({props:{name:"class diffusers.KandinskyV22InpaintCombinedPipeline",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline",parameters:[{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": DDPMScheduler"},{name:"movq",val:": VQModel"},{name:"prior_prior",val:": PriorTransformer"},{name:"prior_image_encoder",val:": CLIPVisionModelWithProjection"},{name:"prior_text_encoder",val:": CLIPTextModelWithProjection"},{name:"prior_tokenizer",val:": CLIPTokenizer"},{name:"prior_scheduler",val:": UnCLIPScheduler"},{name:"prior_image_processor",val:": CLIPImageProcessor"}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.scheduler",description:`<strong>scheduler</strong> (Union[<code>DDIMScheduler</code>,<code>DDPMScheduler</code>]) &#x2014;
A scheduler to be used in combination with <code>unet</code> to generate image latents.`,name:"scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
Conditional U-Net architecture to denoise the image embedding.`,name:"unet"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.movq",description:`<strong>movq</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/vq#diffusers.VQModel">VQModel</a>) &#x2014;
MoVQ Decoder to generate the image from the latents.`,name:"movq"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_prior",description:`<strong>prior_prior</strong> (<a href="/docs/diffusers/v0.26.0/en/api/models/prior_transformer#diffusers.PriorTransformer">PriorTransformer</a>) &#x2014;
The canonincal unCLIP prior to approximate the image embedding from the text embedding.`,name:"prior_prior"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_encoder",description:`<strong>prior_image_encoder</strong> (<code>CLIPVisionModelWithProjection</code>) &#x2014;
Frozen image-encoder.`,name:"prior_image_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_text_encoder",description:`<strong>prior_text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
Frozen text-encoder.`,name:"prior_text_encoder"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_tokenizer",description:`<strong>prior_tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"prior_tokenizer"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_scheduler",description:`<strong>prior_scheduler</strong> (<code>UnCLIPScheduler</code>) &#x2014;
A scheduler to be used in combination with <code>prior</code> to generate image embedding.`,name:"prior_scheduler"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.prior_image_processor",description:`<strong>prior_image_processor</strong> (<code>CLIPImageProcessor</code>) &#x2014;
A image_processor to be used to preprocess image from clip.`,name:"prior_image_processor"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L582"}}),mn=new P({props:{name:"__call__",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__",parameters:[{name:"prompt",val:": Union"},{name:"image",val:": Union"},{name:"mask_image",val:": Union"},{name:"negative_prompt",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 4.0"},{name:"num_images_per_prompt",val:": int = 1"},{name:"height",val:": int = 512"},{name:"width",val:": int = 512"},{name:"prior_guidance_scale",val:": float = 4.0"},{name:"prior_num_inference_steps",val:": int = 25"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"prior_callback_on_step_end",val:": Optional = None"},{name:"prior_callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
The prompt or prompts to guide the image generation.`,name:"prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, or tensor representing an image batch, that will be used as the starting point for the
process. Can also accept image latents as <code>image</code>, if passing latents directly, it will not be encoded
again.`,name:"image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.mask_image",description:`<strong>mask_image</strong> (<code>np.array</code>) &#x2014;
Tensor representing an image batch, to mask <code>image</code>. White pixels in the mask will be repainted, while
black pixels will be preserved. If <code>mask_image</code> is a PIL image, it will be converted to a single
channel (luminance) before use. If it&#x2019;s a tensor, it should contain one color channel (L) instead of 3,
so the expected shape would be <code>(B, H, W, 1)</code>.`,name:"mask_image"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. Ignored when not using guidance (i.e., ignored
if <code>guidance_scale</code> is less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_guidance_scale",description:`<strong>prior_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 4.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"prior_guidance_scale"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_num_inference_steps",description:`<strong>prior_num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"prior_num_inference_steps"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between: <code>&quot;pil&quot;</code> (<code>PIL.Image.Image</code>), <code>&quot;np&quot;</code>
(<code>np.array</code>) or <code>&quot;pt&quot;</code> (<code>torch.Tensor</code>).`,name:"output_type"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput">ImagePipelineOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end",description:`<strong>prior_callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>prior_callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>.`,name:"prior_callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.prior_callback_on_step_end_tensor_inputs",description:`<strong>prior_callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>prior_callback_on_step_end</code> function. The tensors specified in the
list will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in
the <code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"prior_callback_on_step_end_tensor_inputs"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L676",returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.26.0/en/api/pipelines/latent_diffusion#diffusers.ImagePipelineOutput"
>ImagePipelineOutput</a> or <code>tuple</code></p>
`}}),ve=new Te({props:{anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.__call__.example",$$slots:{default:[ni]},$$scope:{ctx:T}}}),gn=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.KandinskyV22InpaintCombinedPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.26.0/src/diffusers/pipelines/kandinsky2_2/pipeline_kandinsky2_2_combined.py#L656"}}),{c(){s=r("meta"),w=o(),m=r("p"),c=o(),g(k.$$.fragment),n=o(),v=r("p"),v.innerHTML=So,dt=o(),Ce=r("p"),Ce.textContent=Ho,ct=o(),Ve=r("p"),Ve.innerHTML=Ao,pt=o(),Je=r("p"),Je.innerHTML=Oo,mt=o(),g(de.$$.fragment),gt=o(),g(ce.$$.fragment),ut=o(),g(Ue.$$.fragment),ft=o(),C=r("div"),g($e.$$.fragment),Lt=o(),fn=r("p"),fn.textContent=ea,Bt=o(),_n=r("p"),_n.innerHTML=na,Et=o(),F=r("div"),g(je.$$.fragment),Nt=o(),hn=r("p"),hn.textContent=ta,Ft=o(),g(pe.$$.fragment),Dt=o(),D=r("div"),g(Ze.$$.fragment),Rt=o(),bn=r("p"),bn.textContent=oa,Qt=o(),g(me.$$.fragment),_t=o(),g(We.$$.fragment),ht=o(),$=r("div"),g(Ke.$$.fragment),Xt=o(),yn=r("p"),yn.textContent=aa,zt=o(),kn=r("p"),kn.innerHTML=ia,Yt=o(),R=r("div"),g(Ge.$$.fragment),St=o(),vn=r("p"),vn.textContent=sa,Ht=o(),g(ge.$$.fragment),bt=o(),g(qe.$$.fragment),yt=o(),V=r("div"),g(Le.$$.fragment),At=o(),wn=r("p"),wn.textContent=ra,Ot=o(),Mn=r("p"),Mn.innerHTML=la,eo=o(),Q=r("div"),g(Be.$$.fragment),no=o(),In=r("p"),In.textContent=da,to=o(),g(ue.$$.fragment),oo=o(),fe=r("div"),g(Ee.$$.fragment),ao=o(),Pn=r("p"),Pn.innerHTML=ca,kt=o(),g(Ne.$$.fragment),vt=o(),j=r("div"),g(Fe.$$.fragment),io=o(),Tn=r("p"),Tn.textContent=pa,so=o(),xn=r("p"),xn.innerHTML=ma,ro=o(),X=r("div"),g(De.$$.fragment),lo=o(),Cn=r("p"),Cn.textContent=ga,co=o(),Vn=r("p"),Vn.textContent=ua,wt=o(),g(Re.$$.fragment),Mt=o(),J=r("div"),g(Qe.$$.fragment),po=o(),Jn=r("p"),Jn.textContent=fa,mo=o(),Un=r("p"),Un.innerHTML=_a,go=o(),z=r("div"),g(Xe.$$.fragment),uo=o(),$n=r("p"),$n.textContent=ha,fo=o(),g(_e.$$.fragment),_o=o(),Y=r("div"),g(ze.$$.fragment),ho=o(),jn=r("p"),jn.textContent=ba,bo=o(),g(he.$$.fragment),It=o(),g(Ye.$$.fragment),Pt=o(),Z=r("div"),g(Se.$$.fragment),yo=o(),Zn=r("p"),Zn.textContent=ya,ko=o(),Wn=r("p"),Wn.innerHTML=ka,vo=o(),S=r("div"),g(He.$$.fragment),wo=o(),Kn=r("p"),Kn.textContent=va,Mo=o(),Gn=r("p"),Gn.textContent=wa,Tt=o(),g(Ae.$$.fragment),xt=o(),x=r("div"),g(Oe.$$.fragment),Io=o(),qn=r("p"),qn.textContent=Ma,Po=o(),Ln=r("p"),Ln.innerHTML=Ia,To=o(),H=r("div"),g(en.$$.fragment),xo=o(),Bn=r("p"),Bn.textContent=Pa,Co=o(),g(be.$$.fragment),Vo=o(),ye=r("div"),g(nn.$$.fragment),Jo=o(),En=r("p"),En.innerHTML=Ta,Uo=o(),ke=r("div"),g(tn.$$.fragment),$o=o(),Nn=r("p"),Nn.innerHTML=xa,Ct=o(),g(on.$$.fragment),Vt=o(),W=r("div"),g(an.$$.fragment),jo=o(),Fn=r("p"),Fn.textContent=Ca,Zo=o(),Dn=r("p"),Dn.innerHTML=Va,Wo=o(),A=r("div"),g(sn.$$.fragment),Ko=o(),Rn=r("p"),Rn.textContent=Ja,Go=o(),Qn=r("p"),Qn.textContent=Ua,Jt=o(),g(rn.$$.fragment),Ut=o(),K=r("div"),g(ln.$$.fragment),qo=o(),Xn=r("p"),Xn.textContent=$a,Lo=o(),zn=r("p"),zn.innerHTML=ja,Bo=o(),O=r("div"),g(dn.$$.fragment),Eo=o(),Yn=r("p"),Yn.textContent=Za,No=o(),Sn=r("p"),Sn.textContent=Wa,$t=o(),g(cn.$$.fragment),jt=o(),U=r("div"),g(pn.$$.fragment),Fo=o(),Hn=r("p"),Hn.textContent=Ka,Do=o(),An=r("p"),An.innerHTML=Ga,Ro=o(),ee=r("div"),g(mn.$$.fragment),Qo=o(),On=r("p"),On.textContent=qa,Xo=o(),g(ve.$$.fragment),zo=o(),we=r("div"),g(gn.$$.fragment),Yo=o(),et=r("p"),et.innerHTML=La,Zt=o(),lt=r("p"),this.h()},l(e){const d=Ra("svelte-u9bgzb",document.head);s=l(d,"META",{name:!0,content:!0}),d.forEach(i),w=a(e),m=l(e,"P",{}),M(m).forEach(i),c=a(e),u(k.$$.fragment,e),n=a(e),v=l(e,"P",{"data-svelte-h":!0}),y(v)!=="svelte-1a9feuc"&&(v.innerHTML=So),dt=a(e),Ce=l(e,"P",{"data-svelte-h":!0}),y(Ce)!=="svelte-1og8lwg"&&(Ce.textContent=Ho),ct=a(e),Ve=l(e,"P",{"data-svelte-h":!0}),y(Ve)!=="svelte-xseaz5"&&(Ve.innerHTML=Ao),pt=a(e),Je=l(e,"P",{"data-svelte-h":!0}),y(Je)!=="svelte-14rg3yz"&&(Je.innerHTML=Oo),mt=a(e),u(de.$$.fragment,e),gt=a(e),u(ce.$$.fragment,e),ut=a(e),u(Ue.$$.fragment,e),ft=a(e),C=l(e,"DIV",{class:!0});var G=M(C);u($e.$$.fragment,G),Lt=a(G),fn=l(G,"P",{"data-svelte-h":!0}),y(fn)!=="svelte-gfz7tn"&&(fn.textContent=ea),Bt=a(G),_n=l(G,"P",{"data-svelte-h":!0}),y(_n)!=="svelte-1c3yl5e"&&(_n.innerHTML=na),Et=a(G),F=l(G,"DIV",{class:!0});var ae=M(F);u(je.$$.fragment,ae),Nt=a(ae),hn=l(ae,"P",{"data-svelte-h":!0}),y(hn)!=="svelte-v78lg8"&&(hn.textContent=ta),Ft=a(ae),u(pe.$$.fragment,ae),ae.forEach(i),Dt=a(G),D=l(G,"DIV",{class:!0});var ie=M(D);u(Ze.$$.fragment,ie),Rt=a(ie),bn=l(ie,"P",{"data-svelte-h":!0}),y(bn)!=="svelte-1k7d7q8"&&(bn.textContent=oa),Qt=a(ie),u(me.$$.fragment,ie),ie.forEach(i),G.forEach(i),_t=a(e),u(We.$$.fragment,e),ht=a(e),$=l(e,"DIV",{class:!0});var B=M($);u(Ke.$$.fragment,B),Xt=a(B),yn=l(B,"P",{"data-svelte-h":!0}),y(yn)!=="svelte-jhhofy"&&(yn.textContent=aa),zt=a(B),kn=l(B,"P",{"data-svelte-h":!0}),y(kn)!=="svelte-1c3yl5e"&&(kn.innerHTML=ia),Yt=a(B),R=l(B,"DIV",{class:!0});var se=M(R);u(Ge.$$.fragment,se),St=a(se),vn=l(se,"P",{"data-svelte-h":!0}),y(vn)!=="svelte-v78lg8"&&(vn.textContent=sa),Ht=a(se),u(ge.$$.fragment,se),se.forEach(i),B.forEach(i),bt=a(e),u(qe.$$.fragment,e),yt=a(e),V=l(e,"DIV",{class:!0});var q=M(V);u(Le.$$.fragment,q),At=a(q),wn=l(q,"P",{"data-svelte-h":!0}),y(wn)!=="svelte-1spbql3"&&(wn.textContent=ra),Ot=a(q),Mn=l(q,"P",{"data-svelte-h":!0}),y(Mn)!=="svelte-1c3yl5e"&&(Mn.innerHTML=la),eo=a(q),Q=l(q,"DIV",{class:!0});var re=M(Q);u(Be.$$.fragment,re),no=a(re),In=l(re,"P",{"data-svelte-h":!0}),y(In)!=="svelte-v78lg8"&&(In.textContent=da),to=a(re),u(ue.$$.fragment,re),re.forEach(i),oo=a(q),fe=l(q,"DIV",{class:!0});var un=M(fe);u(Ee.$$.fragment,un),ao=a(un),Pn=l(un,"P",{"data-svelte-h":!0}),y(Pn)!=="svelte-1ff7ilh"&&(Pn.innerHTML=ca),un.forEach(i),q.forEach(i),kt=a(e),u(Ne.$$.fragment,e),vt=a(e),j=l(e,"DIV",{class:!0});var E=M(j);u(Fe.$$.fragment,E),io=a(E),Tn=l(E,"P",{"data-svelte-h":!0}),y(Tn)!=="svelte-jhhofy"&&(Tn.textContent=pa),so=a(E),xn=l(E,"P",{"data-svelte-h":!0}),y(xn)!=="svelte-1c3yl5e"&&(xn.innerHTML=ma),ro=a(E),X=l(E,"DIV",{class:!0});var le=M(X);u(De.$$.fragment,le),lo=a(le),Cn=l(le,"P",{"data-svelte-h":!0}),y(Cn)!=="svelte-v78lg8"&&(Cn.textContent=ga),co=a(le),Vn=l(le,"P",{"data-svelte-h":!0}),y(Vn)!=="svelte-kvfsh7"&&(Vn.textContent=ua),le.forEach(i),E.forEach(i),wt=a(e),u(Re.$$.fragment,e),Mt=a(e),J=l(e,"DIV",{class:!0});var ne=M(J);u(Qe.$$.fragment,ne),po=a(ne),Jn=l(ne,"P",{"data-svelte-h":!0}),y(Jn)!=="svelte-gfz7tn"&&(Jn.textContent=fa),mo=a(ne),Un=l(ne,"P",{"data-svelte-h":!0}),y(Un)!=="svelte-1c3yl5e"&&(Un.innerHTML=_a),go=a(ne),z=l(ne,"DIV",{class:!0});var nt=M(z);u(Xe.$$.fragment,nt),uo=a(nt),$n=l(nt,"P",{"data-svelte-h":!0}),y($n)!=="svelte-v78lg8"&&($n.textContent=ha),fo=a(nt),u(_e.$$.fragment,nt),nt.forEach(i),_o=a(ne),Y=l(ne,"DIV",{class:!0});var tt=M(Y);u(ze.$$.fragment,tt),ho=a(tt),jn=l(tt,"P",{"data-svelte-h":!0}),y(jn)!=="svelte-1k7d7q8"&&(jn.textContent=ba),bo=a(tt),u(he.$$.fragment,tt),tt.forEach(i),ne.forEach(i),It=a(e),u(Ye.$$.fragment,e),Pt=a(e),Z=l(e,"DIV",{class:!0});var Me=M(Z);u(Se.$$.fragment,Me),yo=a(Me),Zn=l(Me,"P",{"data-svelte-h":!0}),y(Zn)!=="svelte-1nm2rj2"&&(Zn.textContent=ya),ko=a(Me),Wn=l(Me,"P",{"data-svelte-h":!0}),y(Wn)!=="svelte-1c3yl5e"&&(Wn.innerHTML=ka),vo=a(Me),S=l(Me,"DIV",{class:!0});var ot=M(S);u(He.$$.fragment,ot),wo=a(ot),Kn=l(ot,"P",{"data-svelte-h":!0}),y(Kn)!=="svelte-v78lg8"&&(Kn.textContent=va),Mo=a(ot),Gn=l(ot,"P",{"data-svelte-h":!0}),y(Gn)!=="svelte-kvfsh7"&&(Gn.textContent=wa),ot.forEach(i),Me.forEach(i),Tt=a(e),u(Ae.$$.fragment,e),xt=a(e),x=l(e,"DIV",{class:!0});var L=M(x);u(Oe.$$.fragment,L),Io=a(L),qn=l(L,"P",{"data-svelte-h":!0}),y(qn)!=="svelte-1ql3mrb"&&(qn.textContent=Ma),Po=a(L),Ln=l(L,"P",{"data-svelte-h":!0}),y(Ln)!=="svelte-1c3yl5e"&&(Ln.innerHTML=Ia),To=a(L),H=l(L,"DIV",{class:!0});var at=M(H);u(en.$$.fragment,at),xo=a(at),Bn=l(at,"P",{"data-svelte-h":!0}),y(Bn)!=="svelte-v78lg8"&&(Bn.textContent=Pa),Co=a(at),u(be.$$.fragment,at),at.forEach(i),Vo=a(L),ye=l(L,"DIV",{class:!0});var Kt=M(ye);u(nn.$$.fragment,Kt),Jo=a(Kt),En=l(Kt,"P",{"data-svelte-h":!0}),y(En)!=="svelte-d7vywi"&&(En.innerHTML=Ta),Kt.forEach(i),Uo=a(L),ke=l(L,"DIV",{class:!0});var Gt=M(ke);u(tn.$$.fragment,Gt),$o=a(Gt),Nn=l(Gt,"P",{"data-svelte-h":!0}),y(Nn)!=="svelte-1ff7ilh"&&(Nn.innerHTML=xa),Gt.forEach(i),L.forEach(i),Ct=a(e),u(on.$$.fragment,e),Vt=a(e),W=l(e,"DIV",{class:!0});var Ie=M(W);u(an.$$.fragment,Ie),jo=a(Ie),Fn=l(Ie,"P",{"data-svelte-h":!0}),y(Fn)!=="svelte-1nm2rj2"&&(Fn.textContent=Ca),Zo=a(Ie),Dn=l(Ie,"P",{"data-svelte-h":!0}),y(Dn)!=="svelte-1c3yl5e"&&(Dn.innerHTML=Va),Wo=a(Ie),A=l(Ie,"DIV",{class:!0});var it=M(A);u(sn.$$.fragment,it),Ko=a(it),Rn=l(it,"P",{"data-svelte-h":!0}),y(Rn)!=="svelte-v78lg8"&&(Rn.textContent=Ja),Go=a(it),Qn=l(it,"P",{"data-svelte-h":!0}),y(Qn)!=="svelte-kvfsh7"&&(Qn.textContent=Ua),it.forEach(i),Ie.forEach(i),Jt=a(e),u(rn.$$.fragment,e),Ut=a(e),K=l(e,"DIV",{class:!0});var Pe=M(K);u(ln.$$.fragment,Pe),qo=a(Pe),Xn=l(Pe,"P",{"data-svelte-h":!0}),y(Xn)!=="svelte-2p9m8a"&&(Xn.textContent=$a),Lo=a(Pe),zn=l(Pe,"P",{"data-svelte-h":!0}),y(zn)!=="svelte-1c3yl5e"&&(zn.innerHTML=ja),Bo=a(Pe),O=l(Pe,"DIV",{class:!0});var st=M(O);u(dn.$$.fragment,st),Eo=a(st),Yn=l(st,"P",{"data-svelte-h":!0}),y(Yn)!=="svelte-v78lg8"&&(Yn.textContent=Za),No=a(st),Sn=l(st,"P",{"data-svelte-h":!0}),y(Sn)!=="svelte-kvfsh7"&&(Sn.textContent=Wa),st.forEach(i),Pe.forEach(i),$t=a(e),u(cn.$$.fragment,e),jt=a(e),U=l(e,"DIV",{class:!0});var te=M(U);u(pn.$$.fragment,te),Fo=a(te),Hn=l(te,"P",{"data-svelte-h":!0}),y(Hn)!=="svelte-ydcvxp"&&(Hn.textContent=Ka),Do=a(te),An=l(te,"P",{"data-svelte-h":!0}),y(An)!=="svelte-1c3yl5e"&&(An.innerHTML=Ga),Ro=a(te),ee=l(te,"DIV",{class:!0});var rt=M(ee);u(mn.$$.fragment,rt),Qo=a(rt),On=l(rt,"P",{"data-svelte-h":!0}),y(On)!=="svelte-v78lg8"&&(On.textContent=qa),Xo=a(rt),u(ve.$$.fragment,rt),rt.forEach(i),zo=a(te),we=l(te,"DIV",{class:!0});var qt=M(we);u(gn.$$.fragment,qt),Yo=a(qt),et=l(qt,"P",{"data-svelte-h":!0}),y(et)!=="svelte-1ff7ilh"&&(et.innerHTML=La),qt.forEach(i),te.forEach(i),Zt=a(e),lt=l(e,"P",{}),M(lt).forEach(i),this.h()},h(){I(s,"name","hf:doc:metadata"),I(s,"content",oi),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,d){t(document.head,s),p(e,w,d),p(e,m,d),p(e,c,d),f(k,e,d),p(e,n,d),p(e,v,d),p(e,dt,d),p(e,Ce,d),p(e,ct,d),p(e,Ve,d),p(e,pt,d),p(e,Je,d),p(e,mt,d),f(de,e,d),p(e,gt,d),f(ce,e,d),p(e,ut,d),f(Ue,e,d),p(e,ft,d),p(e,C,d),f($e,C,null),t(C,Lt),t(C,fn),t(C,Bt),t(C,_n),t(C,Et),t(C,F),f(je,F,null),t(F,Nt),t(F,hn),t(F,Ft),f(pe,F,null),t(C,Dt),t(C,D),f(Ze,D,null),t(D,Rt),t(D,bn),t(D,Qt),f(me,D,null),p(e,_t,d),f(We,e,d),p(e,ht,d),p(e,$,d),f(Ke,$,null),t($,Xt),t($,yn),t($,zt),t($,kn),t($,Yt),t($,R),f(Ge,R,null),t(R,St),t(R,vn),t(R,Ht),f(ge,R,null),p(e,bt,d),f(qe,e,d),p(e,yt,d),p(e,V,d),f(Le,V,null),t(V,At),t(V,wn),t(V,Ot),t(V,Mn),t(V,eo),t(V,Q),f(Be,Q,null),t(Q,no),t(Q,In),t(Q,to),f(ue,Q,null),t(V,oo),t(V,fe),f(Ee,fe,null),t(fe,ao),t(fe,Pn),p(e,kt,d),f(Ne,e,d),p(e,vt,d),p(e,j,d),f(Fe,j,null),t(j,io),t(j,Tn),t(j,so),t(j,xn),t(j,ro),t(j,X),f(De,X,null),t(X,lo),t(X,Cn),t(X,co),t(X,Vn),p(e,wt,d),f(Re,e,d),p(e,Mt,d),p(e,J,d),f(Qe,J,null),t(J,po),t(J,Jn),t(J,mo),t(J,Un),t(J,go),t(J,z),f(Xe,z,null),t(z,uo),t(z,$n),t(z,fo),f(_e,z,null),t(J,_o),t(J,Y),f(ze,Y,null),t(Y,ho),t(Y,jn),t(Y,bo),f(he,Y,null),p(e,It,d),f(Ye,e,d),p(e,Pt,d),p(e,Z,d),f(Se,Z,null),t(Z,yo),t(Z,Zn),t(Z,ko),t(Z,Wn),t(Z,vo),t(Z,S),f(He,S,null),t(S,wo),t(S,Kn),t(S,Mo),t(S,Gn),p(e,Tt,d),f(Ae,e,d),p(e,xt,d),p(e,x,d),f(Oe,x,null),t(x,Io),t(x,qn),t(x,Po),t(x,Ln),t(x,To),t(x,H),f(en,H,null),t(H,xo),t(H,Bn),t(H,Co),f(be,H,null),t(x,Vo),t(x,ye),f(nn,ye,null),t(ye,Jo),t(ye,En),t(x,Uo),t(x,ke),f(tn,ke,null),t(ke,$o),t(ke,Nn),p(e,Ct,d),f(on,e,d),p(e,Vt,d),p(e,W,d),f(an,W,null),t(W,jo),t(W,Fn),t(W,Zo),t(W,Dn),t(W,Wo),t(W,A),f(sn,A,null),t(A,Ko),t(A,Rn),t(A,Go),t(A,Qn),p(e,Jt,d),f(rn,e,d),p(e,Ut,d),p(e,K,d),f(ln,K,null),t(K,qo),t(K,Xn),t(K,Lo),t(K,zn),t(K,Bo),t(K,O),f(dn,O,null),t(O,Eo),t(O,Yn),t(O,No),t(O,Sn),p(e,$t,d),f(cn,e,d),p(e,jt,d),p(e,U,d),f(pn,U,null),t(U,Fo),t(U,Hn),t(U,Do),t(U,An),t(U,Ro),t(U,ee),f(mn,ee,null),t(ee,Qo),t(ee,On),t(ee,Xo),f(ve,ee,null),t(U,zo),t(U,we),f(gn,we,null),t(we,Yo),t(we,et),p(e,Zt,d),p(e,lt,d),Wt=!0},p(e,[d]){const G={};d&2&&(G.$$scope={dirty:d,ctx:e}),de.$set(G);const ae={};d&2&&(ae.$$scope={dirty:d,ctx:e}),ce.$set(ae);const ie={};d&2&&(ie.$$scope={dirty:d,ctx:e}),pe.$set(ie);const B={};d&2&&(B.$$scope={dirty:d,ctx:e}),me.$set(B);const se={};d&2&&(se.$$scope={dirty:d,ctx:e}),ge.$set(se);const q={};d&2&&(q.$$scope={dirty:d,ctx:e}),ue.$set(q);const re={};d&2&&(re.$$scope={dirty:d,ctx:e}),_e.$set(re);const un={};d&2&&(un.$$scope={dirty:d,ctx:e}),he.$set(un);const E={};d&2&&(E.$$scope={dirty:d,ctx:e}),be.$set(E);const le={};d&2&&(le.$$scope={dirty:d,ctx:e}),ve.$set(le)},i(e){Wt||(_(k.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(Ue.$$.fragment,e),_($e.$$.fragment,e),_(je.$$.fragment,e),_(pe.$$.fragment,e),_(Ze.$$.fragment,e),_(me.$$.fragment,e),_(We.$$.fragment,e),_(Ke.$$.fragment,e),_(Ge.$$.fragment,e),_(ge.$$.fragment,e),_(qe.$$.fragment,e),_(Le.$$.fragment,e),_(Be.$$.fragment,e),_(ue.$$.fragment,e),_(Ee.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(De.$$.fragment,e),_(Re.$$.fragment,e),_(Qe.$$.fragment,e),_(Xe.$$.fragment,e),_(_e.$$.fragment,e),_(ze.$$.fragment,e),_(he.$$.fragment,e),_(Ye.$$.fragment,e),_(Se.$$.fragment,e),_(He.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(en.$$.fragment,e),_(be.$$.fragment,e),_(nn.$$.fragment,e),_(tn.$$.fragment,e),_(on.$$.fragment,e),_(an.$$.fragment,e),_(sn.$$.fragment,e),_(rn.$$.fragment,e),_(ln.$$.fragment,e),_(dn.$$.fragment,e),_(cn.$$.fragment,e),_(pn.$$.fragment,e),_(mn.$$.fragment,e),_(ve.$$.fragment,e),_(gn.$$.fragment,e),Wt=!0)},o(e){h(k.$$.fragment,e),h(de.$$.fragment,e),h(ce.$$.fragment,e),h(Ue.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(pe.$$.fragment,e),h(Ze.$$.fragment,e),h(me.$$.fragment,e),h(We.$$.fragment,e),h(Ke.$$.fragment,e),h(Ge.$$.fragment,e),h(ge.$$.fragment,e),h(qe.$$.fragment,e),h(Le.$$.fragment,e),h(Be.$$.fragment,e),h(ue.$$.fragment,e),h(Ee.$$.fragment,e),h(Ne.$$.fragment,e),h(Fe.$$.fragment,e),h(De.$$.fragment,e),h(Re.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(_e.$$.fragment,e),h(ze.$$.fragment,e),h(he.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(He.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(en.$$.fragment,e),h(be.$$.fragment,e),h(nn.$$.fragment,e),h(tn.$$.fragment,e),h(on.$$.fragment,e),h(an.$$.fragment,e),h(sn.$$.fragment,e),h(rn.$$.fragment,e),h(ln.$$.fragment,e),h(dn.$$.fragment,e),h(cn.$$.fragment,e),h(pn.$$.fragment,e),h(mn.$$.fragment,e),h(ve.$$.fragment,e),h(gn.$$.fragment,e),Wt=!1},d(e){e&&(i(w),i(m),i(c),i(n),i(v),i(dt),i(Ce),i(ct),i(Ve),i(pt),i(Je),i(mt),i(gt),i(ut),i(ft),i(C),i(_t),i(ht),i($),i(bt),i(yt),i(V),i(kt),i(vt),i(j),i(wt),i(Mt),i(J),i(It),i(Pt),i(Z),i(Tt),i(xt),i(x),i(Ct),i(Vt),i(W),i(Jt),i(Ut),i(K),i($t),i(jt),i(U),i(Zt),i(lt)),i(s),b(k,e),b(de,e),b(ce,e),b(Ue,e),b($e),b(je),b(pe),b(Ze),b(me),b(We,e),b(Ke),b(Ge),b(ge),b(qe,e),b(Le),b(Be),b(ue),b(Ee),b(Ne,e),b(Fe),b(De),b(Re,e),b(Qe),b(Xe),b(_e),b(ze),b(he),b(Ye,e),b(Se),b(He),b(Ae,e),b(Oe),b(en),b(be),b(nn),b(tn),b(on,e),b(an),b(sn),b(rn,e),b(ln),b(dn),b(cn,e),b(pn),b(mn),b(ve),b(gn)}}}const oi='{"title":"Kandinsky 2.2","local":"kandinsky-22","sections":[{"title":"KandinskyV22PriorPipeline","local":"diffusers.KandinskyV22PriorPipeline","sections":[],"depth":2},{"title":"KandinskyV22Pipeline","local":"diffusers.KandinskyV22Pipeline","sections":[],"depth":2},{"title":"KandinskyV22CombinedPipeline","local":"diffusers.KandinskyV22CombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetPipeline","local":"diffusers.KandinskyV22ControlnetPipeline","sections":[],"depth":2},{"title":"KandinskyV22PriorEmb2EmbPipeline","local":"diffusers.KandinskyV22PriorEmb2EmbPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgPipeline","local":"diffusers.KandinskyV22Img2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22Img2ImgCombinedPipeline","local":"diffusers.KandinskyV22Img2ImgCombinedPipeline","sections":[],"depth":2},{"title":"KandinskyV22ControlnetImg2ImgPipeline","local":"diffusers.KandinskyV22ControlnetImg2ImgPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintPipeline","local":"diffusers.KandinskyV22InpaintPipeline","sections":[],"depth":2},{"title":"KandinskyV22InpaintCombinedPipeline","local":"diffusers.KandinskyV22InpaintCombinedPipeline","sections":[],"depth":2}],"depth":1}';function ai(T){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class mi extends Fa{constructor(s){super(),Da(this,s,ai,ti,Ea,{})}}export{mi as component};
