import{s as Ja,n as Ia,o as ka}from"../chunks/scheduler.9039eef2.js";import{S as Aa,i as Na,g as i,s as n,r as p,A as qa,h as s,f as t,c as o,j as v,u as h,x as d,k as b,y as l,a as r,v as g,d as u,t as _,w as f}from"../chunks/index.ded8f90d.js";import{D as C}from"../chunks/Docstring.2eae8017.js";import{C as Yt}from"../chunks/CodeBlock.8580f3e8.js";import{H as A,E as Fa}from"../chunks/EditOnGithub.b5540897.js";function Ea(Kt){let $,De,Le,Be,N,We,q,ea=`Contrastive Preference Optimization (CPO) as introduced in the paper <a href="https://huggingface.co/papers/2401.08417" rel="nofollow">Contrastive Preference Optimization: Pushing the Boundaries of LLM Performance in Machine Translation</a> by Haoran Xu, Amr Sharaf, Yunmo Chen, Weiting Tan, Lingfeng Shen, Benjamin Van Durme, Kenton Murray, and Young Jin Kim. At a high-level, CPO  trains models to
avoid generating adequate, but not perfect translations in Machine Translation (MT) tasks. However, CPO is a general approximation to the DPO loss and can be applied to other domains like chat.`,He,F,ta="CPO aims to mitigate two fundamental shortcomings of SFT. First, SFT’s methodology of minimizing the discrepancy between predicted outputs and gold-standard references inherently caps model performance at the quality level of the training data. Secondly, SFT lacks a mechanism to prevent the model from rejecting mistakes in translations. The CPO objective is derived from the DPO objective.",Se,E,Qe,L,aa="The CPO trainer expects a format identical to the DPO trainer, which should include three entries. These entries should be named as follows:",Ze,z,na="<li><code>prompt</code></li> <li><code>chosen</code></li> <li><code>rejected</code></li>",Re,D,oa="for example:",Xe,B,Ge,W,la="where the <code>prompt</code> contains the context inputs, <code>chosen</code> contains the corresponding chosen responses and <code>rejected</code> contains the corresponding negative (rejected) responses. As can be seen a prompt can have multiple responses and this is reflected in the entries being repeated in the dictionary’s value arrays.",Ve,H,Ye,S,ra="The CPO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Ke,Q,et,Z,ia="For a detailed example have a look at the <code>examples/scripts/cpo.py</code> script. At a high level we need to initialize the <code>CPOTrainer</code> with a <code>model</code> we wish to train. <strong>Note that CPOTrainer eliminates the need to use the reference model, simplifying the optimization process.</strong> The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above.",tt,R,at,X,sa="After this one can then call:",nt,G,ot,V,lt,Y,da="Given the preference data, the <code>CPOTrainer</code> uses the sigmoid loss on the normalized likelihood via the <code>logsigmoid</code> to fit a logistic regression.",rt,K,ca='The <a href="https://arxiv.org/abs/2309.06657" rel="nofollow">RSO</a> authors propose to use a hinge loss on the normalized likelihood from the <a href="https://arxiv.org/abs/2305.10425" rel="nofollow">SLiC</a> paper. The <code>CPOTrainer</code> can be switched to this loss via the <code>loss_type=&quot;hinge&quot;</code> argument and the <code>beta</code> in this case is the reciprocal of the margin.',it,ee,ma='The <a href="https://arxiv.org/abs/2310.12036" rel="nofollow">IPO</a> authors provide a deeper theoretical understanding of the CPO algorithms and identify an issue with overfitting and propose an alternative loss which can be used via the <code>loss_type=&quot;ipo&quot;</code> argument to the trainer. Note that the <code>beta</code>  parameter is the reciprocal of the gap between the log-likelihood ratios of the chosen vs the rejected completion pair and thus the smaller the <code>beta</code> the larger this gaps is. As per the paper the loss is averaged over log-likelihoods of the completion (unlike CPO which is summed only).',st,te,dt,ae,pa="While training and evaluating we record the following reward metrics:",ct,ne,ha="<li><code>rewards/chosen</code>: the mean log probabilities of the policy model for the chosen responses scaled by beta</li> <li><code>rewards/rejected</code>: the mean log probabilities of the policy model for the rejected responses scaled by beta</li> <li><code>rewards/accuracies</code>: mean of how often the chosen rewards are &gt; than the corresponding rejected rewards</li> <li><code>rewards/margins</code>: the mean difference between the chosen and corresponding rejected rewards</li> <li><code>nll_loss</code>: the mean negative log likelihood loss of the policy model for the chosen responses</li>",mt,oe,pt,c,le,$t,be,ga="Initialize CPOTrainer.",jt,j,re,Ut,Me,ua=`Llama tokenizer does satisfy <code>enc(a + b) = enc(a) + enc(b)</code>.
It does ensure <code>enc(a + b) = enc(a) + enc(a + b)[len(enc(a)):]</code>.
Reference:
<a href="https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257" rel="nofollow">https://github.com/EleutherAI/lm-evaluation-harness/pull/531#issuecomment-1595586257</a>`,xt,T,ie,Ot,Ce,_a="Run the given model on the given batch of inputs, concatenating the chosen and rejected inputs together.",Pt,ye,fa="We do this to avoid doing two forward passes, because it’s faster for FSDP.",Jt,U,se,It,Te,va="Concatenate the chosen and rejected inputs into a single tensor.",kt,x,de,At,we,ba="Compute the CPO loss for a batch of policy and reference model log probabilities.",Nt,w,ce,qt,$e,Ma=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,Ft,je,Ca="Works both with or without labels.",Et,O,me,Lt,Ue,ya="Compute the log probabilities of the given labels under the given logits.",zt,P,pe,Dt,xe,Ta="Compute the CPO loss and other metrics for the given batch of inputs for train or test.",Bt,J,he,Wt,Oe,wa="Generate samples from the model and reference model for the given batch of inputs.",Ht,I,ge,St,Pe,$a="Log <code>logs</code> on the various objects watching training, including stored metrics.",Qt,M,ue,Zt,Je,ja="Tokenize a single row from a CPO specific dataset.",Rt,Ie,Ua=`At this stage, we don’t convert to PyTorch tensors yet; we just handle the truncation
in case the prompt + chosen or prompt + rejected responses is/are too long. First
we truncate the prompt; if we’re still too long, we truncate the chosen/rejected.`,Xt,ke,xa=`We also create the labels for the chosen/rejected responses, which are of length equal to
the sum of the length of the prompt and the chosen/rejected response, with
label_pad_token_id  for the prompt tokens.`,ht,_e,gt,y,fe,Gt,Ae,Oa='CPOConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.CPOTrainer">CPOTrainer</a> class.',Vt,Ne,Pa=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ut,ve,_t,ze,ft;return N=new A({props:{title:"CPO Trainer",local:"cpo-trainer",headingTag:"h1"}}),E=new A({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),B=new Yt({props:{code:"Y3BvX2RhdGFzZXRfZGljdCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnByb21wdCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhlbGxvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaG93JTIwYXJlJTIweW91JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdCUyMGlzJTIweW91ciUyMG5hbWUlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMldoaWNoJTIwaXMlMjB0aGUlMjBiZXN0JTIwcHJvZ3JhbW1pbmclMjBsYW5ndWFnZSUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMmNob3NlbiUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmhpJTIwbmljZSUyMHRvJTIwbWVldCUyMHlvdSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkklMjBhbSUyMGZpbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJNeSUyMG5hbWUlMjBpcyUyME1hcnklMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJQeXRob24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIycmVqZWN0ZWQlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsZWF2ZSUyMG1lJTIwYWxvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJJJTIwYW0lMjBub3QlMjBmaW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBpdCUyMHRvJTIweW91JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySSUyMGRvbnQlMjBoYXZlJTIwYSUyMG5hbWUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJKYXZhc2NyaXB0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyQyUyQiUyQiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkMlMkIlMkIlMjIlMkMlMEElMjAlMjAlMjAlMjAlNUQlMkMlMEElN0Q=",highlighted:`cpo_dataset_dict = {
    <span class="hljs-string">&quot;prompt&quot;</span>: [
        <span class="hljs-string">&quot;hello&quot;</span>,
        <span class="hljs-string">&quot;how are you&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;What is your name?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
        <span class="hljs-string">&quot;Which is the best programming language?&quot;</span>,
    ],
    <span class="hljs-string">&quot;chosen&quot;</span>: [
        <span class="hljs-string">&quot;hi nice to meet you&quot;</span>,
        <span class="hljs-string">&quot;I am fine&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;My name is Mary&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Python&quot;</span>,
        <span class="hljs-string">&quot;Java&quot;</span>,
    ],
    <span class="hljs-string">&quot;rejected&quot;</span>: [
        <span class="hljs-string">&quot;leave me alone&quot;</span>,
        <span class="hljs-string">&quot;I am not fine&quot;</span>,
        <span class="hljs-string">&quot;Whats it to you?&quot;</span>,
        <span class="hljs-string">&quot;I dont have a name&quot;</span>,
        <span class="hljs-string">&quot;Javascript&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
        <span class="hljs-string">&quot;C++&quot;</span>,
    ],
}`,wrap:!1}}),H=new A({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),Q=new A({props:{title:"Using the CPOTrainer",local:"using-the-cpotrainer",headingTag:"h2"}}),R=new Yt({props:{code:"Y3BvX2NvbmZpZyUyMCUzRCUyMENQT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWNwb190cmFpbmVyJTIwJTNEJTIwQ1BPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RjcG9fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`cpo_config = CPOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

cpo_trainer = CPOTrainer(
    model,
    args=cpo_config,
    train_dataset=train_dataset,
    tokenizer=tokenizer,
)`,wrap:!1}}),G=new Yt({props:{code:"Y3BvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"cpo_trainer.train()",wrap:!1}}),V=new A({props:{title:"Loss functions",local:"loss-functions",headingTag:"h2"}}),te=new A({props:{title:"Logging",local:"logging",headingTag:"h2"}}),oe=new A({props:{title:"CPOTrainer",local:"trl.CPOTrainer",headingTag:"h2"}}),le=new C({props:{name:"class trl.CPOTrainer",anchor:"trl.CPOTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"peft_config",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.CPOTrainer.args",description:`<strong>args</strong> (<code>CPOConfig</code>) &#x2014;
The CPO config arguments to use for training.`,name:"args"},{anchor:"trl.CPOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.CPOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.CPOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.CPOTrainer.tokenizer",description:`<strong>tokenizer</strong> (<code>transformers.PreTrainedTokenizerBase</code>) &#x2014;
The tokenizer to use for training. This argument is required if you want to use the default data collator.`,name:"tokenizer"},{anchor:"trl.CPOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.CPOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.CPOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.CPOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.CPOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.CPOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L55"}}),re=new C({props:{name:"build_tokenized_answer",anchor:"trl.CPOTrainer.build_tokenized_answer",parameters:[{name:"prompt",val:""},{name:"answer",val:""}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L304"}}),ie=new C({props:{name:"concatenated_forward",anchor:"trl.CPOTrainer.concatenated_forward",parameters:[{name:"model",val:": Module"},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L642"}}),se=new C({props:{name:"concatenated_inputs",anchor:"trl.CPOTrainer.concatenated_inputs",parameters:[{name:"batch",val:": Dict"},{name:"is_encoder_decoder",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = 0"},{name:"device",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L500",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary containing the concatenated inputs under the key ‘concatenated_input_ids’.</p>
`}}),de=new C({props:{name:"cpo_loss",anchor:"trl.CPOTrainer.cpo_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L562",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards).
The losses tensor contains the CPO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of three tensors</p>
`}}),ce=new C({props:{name:"evaluation_loop",anchor:"trl.CPOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": Optional = None"},{name:"ignore_keys",val:": Optional = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L834"}}),me=new C({props:{name:"get_batch_logps",anchor:"trl.CPOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L604",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),pe=new C({props:{name:"get_batch_loss_metrics",anchor:"trl.CPOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"},{name:"train_eval",val:": Literal = 'train'"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L707"}}),he=new C({props:{name:"get_batch_samples",anchor:"trl.CPOTrainer.get_batch_samples",parameters:[{name:"model",val:""},{name:"batch",val:": Dict"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L769"}}),ge=new C({props:{name:"log",anchor:"trl.CPOTrainer.log",parameters:[{name:"logs",val:": Dict"}],parametersDescription:[{anchor:"trl.CPOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L882"}}),ue=new C({props:{name:"tokenize_row",anchor:"trl.CPOTrainer.tokenize_row",parameters:[{name:"feature",val:""},{name:"model",val:": Union = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_trainer.py#L354"}}),_e=new A({props:{title:"CPOConfig",local:"trl.CPOConfig",headingTag:"h2"}}),fe=new C({props:{name:"class trl.CPOConfig",anchor:"trl.CPOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"max_prompt_length",val:": Optional = None"},{name:"max_completion_length",val:": Optional = None"},{name:"max_target_length",val:": Optional = None"},{name:"beta",val:": float = 0.1"},{name:"label_smoothing",val:": float = 0"},{name:"loss_type",val:": Literal = 'sigmoid'"},{name:"disable_dropout",val:": bool = True"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": int = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": Optional = None"},{name:"model_init_kwargs",val:": Optional = None"},{name:"dataset_num_proc",val:": Optional = None"}],parametersDescription:[{anchor:"trl.CPOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.CPOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.CPOConfig.max_target_length",description:`<strong>max_target_length</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The maximum length of the target. This argument is required if you want to use the default data collator and your model is an encoder-decoder.`,name:"max_target_length"},{anchor:"trl.CPOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, defaults to 0.1) &#x2014;
The beta factor in CPO loss.`,name:"beta"},{anchor:"trl.CPOConfig.label_smoothing",description:`<strong>label_smoothing</strong> (<code>float</code>, defaults to 0) &#x2014;
The label smoothing factor. This argument is required if you want to use the default data collator.`,name:"label_smoothing"},{anchor:"trl.CPOConfig.loss_type",description:`<strong>loss_type</strong> (<code>str</code>, defaults to <code>sigmoid</code>) &#x2014;
The type of loss to use. This argument is required if you want to use the default data collator.`,name:"loss_type"},{anchor:"trl.CPOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>, defaults to <code>-100</code>) &#x2014;
The label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.CPOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code>, defaults to <code>None</code>) &#x2014;
The padding value if it is different to the tokenizer&#x2019;s pad_token_id.`,name:"padding_value"},{anchor:"trl.CPOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, defaults to <code>keep_end</code>) &#x2014;
The truncation mode to use, either <code>keep_end</code> or <code>keep_start</code>. This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.CPOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to sample and log generations during evaluation step.`,name:"generate_during_eval"},{anchor:"trl.CPOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <code>optional</code>, defaults to <code>None</code>) &#x2014;
If no model is provided, we need to know if the model_init returns an encoder-decoder.`,name:"is_encoder_decoder"},{anchor:"trl.CPOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code>.`,name:"disable_dropout"},{anchor:"trl.CPOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict]</code>, <em>optional</em>) &#x2014;
Dict of Optional kwargs to pass when instantiating the model from a string`,name:"model_init_kwargs"},{anchor:"trl.CPOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>) &#x2014;
The number of workers to use to tokenize the data. Defaults to None.`,name:"dataset_num_proc"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/cpo_config.py#L20"}}),ve=new Fa({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/cpo_trainer.mdx"}}),{c(){$=i("meta"),De=n(),Le=i("p"),Be=n(),p(N.$$.fragment),We=n(),q=i("p"),q.innerHTML=ea,He=n(),F=i("p"),F.textContent=ta,Se=n(),p(E.$$.fragment),Qe=n(),L=i("p"),L.textContent=aa,Ze=n(),z=i("ul"),z.innerHTML=na,Re=n(),D=i("p"),D.textContent=oa,Xe=n(),p(B.$$.fragment),Ge=n(),W=i("p"),W.innerHTML=la,Ve=n(),p(H.$$.fragment),Ye=n(),S=i("p"),S.innerHTML=ra,Ke=n(),p(Q.$$.fragment),et=n(),Z=i("p"),Z.innerHTML=ia,tt=n(),p(R.$$.fragment),at=n(),X=i("p"),X.textContent=sa,nt=n(),p(G.$$.fragment),ot=n(),p(V.$$.fragment),lt=n(),Y=i("p"),Y.innerHTML=da,rt=n(),K=i("p"),K.innerHTML=ca,it=n(),ee=i("p"),ee.innerHTML=ma,st=n(),p(te.$$.fragment),dt=n(),ae=i("p"),ae.textContent=pa,ct=n(),ne=i("ul"),ne.innerHTML=ha,mt=n(),p(oe.$$.fragment),pt=n(),c=i("div"),p(le.$$.fragment),$t=n(),be=i("p"),be.textContent=ga,jt=n(),j=i("div"),p(re.$$.fragment),Ut=n(),Me=i("p"),Me.innerHTML=ua,xt=n(),T=i("div"),p(ie.$$.fragment),Ot=n(),Ce=i("p"),Ce.textContent=_a,Pt=n(),ye=i("p"),ye.textContent=fa,Jt=n(),U=i("div"),p(se.$$.fragment),It=n(),Te=i("p"),Te.textContent=va,kt=n(),x=i("div"),p(de.$$.fragment),At=n(),we=i("p"),we.textContent=ba,Nt=n(),w=i("div"),p(ce.$$.fragment),qt=n(),$e=i("p"),$e.innerHTML=Ma,Ft=n(),je=i("p"),je.textContent=Ca,Et=n(),O=i("div"),p(me.$$.fragment),Lt=n(),Ue=i("p"),Ue.textContent=ya,zt=n(),P=i("div"),p(pe.$$.fragment),Dt=n(),xe=i("p"),xe.textContent=Ta,Bt=n(),J=i("div"),p(he.$$.fragment),Wt=n(),Oe=i("p"),Oe.textContent=wa,Ht=n(),I=i("div"),p(ge.$$.fragment),St=n(),Pe=i("p"),Pe.innerHTML=$a,Qt=n(),M=i("div"),p(ue.$$.fragment),Zt=n(),Je=i("p"),Je.textContent=ja,Rt=n(),Ie=i("p"),Ie.textContent=Ua,Xt=n(),ke=i("p"),ke.textContent=xa,ht=n(),p(_e.$$.fragment),gt=n(),y=i("div"),p(fe.$$.fragment),Gt=n(),Ae=i("p"),Ae.innerHTML=Oa,Vt=n(),Ne=i("p"),Ne.innerHTML=Pa,ut=n(),p(ve.$$.fragment),_t=n(),ze=i("p"),this.h()},l(e){const a=qa("svelte-u9bgzb",document.head);$=s(a,"META",{name:!0,content:!0}),a.forEach(t),De=o(e),Le=s(e,"P",{}),v(Le).forEach(t),Be=o(e),h(N.$$.fragment,e),We=o(e),q=s(e,"P",{"data-svelte-h":!0}),d(q)!=="svelte-1grcdr2"&&(q.innerHTML=ea),He=o(e),F=s(e,"P",{"data-svelte-h":!0}),d(F)!=="svelte-10wbspk"&&(F.textContent=ta),Se=o(e),h(E.$$.fragment,e),Qe=o(e),L=s(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1t3enyx"&&(L.textContent=aa),Ze=o(e),z=s(e,"UL",{"data-svelte-h":!0}),d(z)!=="svelte-17vxuta"&&(z.innerHTML=na),Re=o(e),D=s(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-1gl9mvz"&&(D.textContent=oa),Xe=o(e),h(B.$$.fragment,e),Ge=o(e),W=s(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-1a8oxjk"&&(W.innerHTML=la),Ve=o(e),h(H.$$.fragment,e),Ye=o(e),S=s(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-187gqrp"&&(S.innerHTML=ra),Ke=o(e),h(Q.$$.fragment,e),et=o(e),Z=s(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-1mkccty"&&(Z.innerHTML=ia),tt=o(e),h(R.$$.fragment,e),at=o(e),X=s(e,"P",{"data-svelte-h":!0}),d(X)!=="svelte-1lg6q1l"&&(X.textContent=sa),nt=o(e),h(G.$$.fragment,e),ot=o(e),h(V.$$.fragment,e),lt=o(e),Y=s(e,"P",{"data-svelte-h":!0}),d(Y)!=="svelte-1nbvuj3"&&(Y.innerHTML=da),rt=o(e),K=s(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-v1u5f4"&&(K.innerHTML=ca),it=o(e),ee=s(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-j24bt8"&&(ee.innerHTML=ma),st=o(e),h(te.$$.fragment,e),dt=o(e),ae=s(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-132s7j9"&&(ae.textContent=pa),ct=o(e),ne=s(e,"UL",{"data-svelte-h":!0}),d(ne)!=="svelte-yjg2sp"&&(ne.innerHTML=ha),mt=o(e),h(oe.$$.fragment,e),pt=o(e),c=s(e,"DIV",{class:!0});var m=v(c);h(le.$$.fragment,m),$t=o(m),be=s(m,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1qqtmoh"&&(be.textContent=ga),jt=o(m),j=s(m,"DIV",{class:!0});var vt=v(j);h(re.$$.fragment,vt),Ut=o(vt),Me=s(vt,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-mcz8nm"&&(Me.innerHTML=ua),vt.forEach(t),xt=o(m),T=s(m,"DIV",{class:!0});var qe=v(T);h(ie.$$.fragment,qe),Ot=o(qe),Ce=s(qe,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-16i1nac"&&(Ce.textContent=_a),Pt=o(qe),ye=s(qe,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-tgti68"&&(ye.textContent=fa),qe.forEach(t),Jt=o(m),U=s(m,"DIV",{class:!0});var bt=v(U);h(se.$$.fragment,bt),It=o(bt),Te=s(bt,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1cvsgkk"&&(Te.textContent=va),bt.forEach(t),kt=o(m),x=s(m,"DIV",{class:!0});var Mt=v(x);h(de.$$.fragment,Mt),At=o(Mt),we=s(Mt,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1l2rxe2"&&(we.textContent=ba),Mt.forEach(t),Nt=o(m),w=s(m,"DIV",{class:!0});var Fe=v(w);h(ce.$$.fragment,Fe),qt=o(Fe),$e=s(Fe,"P",{"data-svelte-h":!0}),d($e)!=="svelte-8qlty5"&&($e.innerHTML=Ma),Ft=o(Fe),je=s(Fe,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1tyo99t"&&(je.textContent=Ca),Fe.forEach(t),Et=o(m),O=s(m,"DIV",{class:!0});var Ct=v(O);h(me.$$.fragment,Ct),Lt=o(Ct),Ue=s(Ct,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-4nmimv"&&(Ue.textContent=ya),Ct.forEach(t),zt=o(m),P=s(m,"DIV",{class:!0});var yt=v(P);h(pe.$$.fragment,yt),Dt=o(yt),xe=s(yt,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-4kzfyw"&&(xe.textContent=Ta),yt.forEach(t),Bt=o(m),J=s(m,"DIV",{class:!0});var Tt=v(J);h(he.$$.fragment,Tt),Wt=o(Tt),Oe=s(Tt,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-18uwvbi"&&(Oe.textContent=wa),Tt.forEach(t),Ht=o(m),I=s(m,"DIV",{class:!0});var wt=v(I);h(ge.$$.fragment,wt),St=o(wt),Pe=s(wt,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-nqksfz"&&(Pe.innerHTML=$a),wt.forEach(t),Qt=o(m),M=s(m,"DIV",{class:!0});var k=v(M);h(ue.$$.fragment,k),Zt=o(k),Je=s(k,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-1a53vwp"&&(Je.textContent=ja),Rt=o(k),Ie=s(k,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-1mn1gnw"&&(Ie.textContent=Ua),Xt=o(k),ke=s(k,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1xvpyih"&&(ke.textContent=xa),k.forEach(t),m.forEach(t),ht=o(e),h(_e.$$.fragment,e),gt=o(e),y=s(e,"DIV",{class:!0});var Ee=v(y);h(fe.$$.fragment,Ee),Gt=o(Ee),Ae=s(Ee,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1w6qkim"&&(Ae.innerHTML=Oa),Vt=o(Ee),Ne=s(Ee,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1xl7jqc"&&(Ne.innerHTML=Pa),Ee.forEach(t),ut=o(e),h(ve.$$.fragment,e),_t=o(e),ze=s(e,"P",{}),v(ze).forEach(t),this.h()},h(){b($,"name","hf:doc:metadata"),b($,"content",La),b(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){l(document.head,$),r(e,De,a),r(e,Le,a),r(e,Be,a),g(N,e,a),r(e,We,a),r(e,q,a),r(e,He,a),r(e,F,a),r(e,Se,a),g(E,e,a),r(e,Qe,a),r(e,L,a),r(e,Ze,a),r(e,z,a),r(e,Re,a),r(e,D,a),r(e,Xe,a),g(B,e,a),r(e,Ge,a),r(e,W,a),r(e,Ve,a),g(H,e,a),r(e,Ye,a),r(e,S,a),r(e,Ke,a),g(Q,e,a),r(e,et,a),r(e,Z,a),r(e,tt,a),g(R,e,a),r(e,at,a),r(e,X,a),r(e,nt,a),g(G,e,a),r(e,ot,a),g(V,e,a),r(e,lt,a),r(e,Y,a),r(e,rt,a),r(e,K,a),r(e,it,a),r(e,ee,a),r(e,st,a),g(te,e,a),r(e,dt,a),r(e,ae,a),r(e,ct,a),r(e,ne,a),r(e,mt,a),g(oe,e,a),r(e,pt,a),r(e,c,a),g(le,c,null),l(c,$t),l(c,be),l(c,jt),l(c,j),g(re,j,null),l(j,Ut),l(j,Me),l(c,xt),l(c,T),g(ie,T,null),l(T,Ot),l(T,Ce),l(T,Pt),l(T,ye),l(c,Jt),l(c,U),g(se,U,null),l(U,It),l(U,Te),l(c,kt),l(c,x),g(de,x,null),l(x,At),l(x,we),l(c,Nt),l(c,w),g(ce,w,null),l(w,qt),l(w,$e),l(w,Ft),l(w,je),l(c,Et),l(c,O),g(me,O,null),l(O,Lt),l(O,Ue),l(c,zt),l(c,P),g(pe,P,null),l(P,Dt),l(P,xe),l(c,Bt),l(c,J),g(he,J,null),l(J,Wt),l(J,Oe),l(c,Ht),l(c,I),g(ge,I,null),l(I,St),l(I,Pe),l(c,Qt),l(c,M),g(ue,M,null),l(M,Zt),l(M,Je),l(M,Rt),l(M,Ie),l(M,Xt),l(M,ke),r(e,ht,a),g(_e,e,a),r(e,gt,a),r(e,y,a),g(fe,y,null),l(y,Gt),l(y,Ae),l(y,Vt),l(y,Ne),r(e,ut,a),g(ve,e,a),r(e,_t,a),r(e,ze,a),ft=!0},p:Ia,i(e){ft||(u(N.$$.fragment,e),u(E.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(Q.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(oe.$$.fragment,e),u(le.$$.fragment,e),u(re.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(fe.$$.fragment,e),u(ve.$$.fragment,e),ft=!0)},o(e){_(N.$$.fragment,e),_(E.$$.fragment,e),_(B.$$.fragment,e),_(H.$$.fragment,e),_(Q.$$.fragment,e),_(R.$$.fragment,e),_(G.$$.fragment,e),_(V.$$.fragment,e),_(te.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(re.$$.fragment,e),_(ie.$$.fragment,e),_(se.$$.fragment,e),_(de.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(pe.$$.fragment,e),_(he.$$.fragment,e),_(ge.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(fe.$$.fragment,e),_(ve.$$.fragment,e),ft=!1},d(e){e&&(t(De),t(Le),t(Be),t(We),t(q),t(He),t(F),t(Se),t(Qe),t(L),t(Ze),t(z),t(Re),t(D),t(Xe),t(Ge),t(W),t(Ve),t(Ye),t(S),t(Ke),t(et),t(Z),t(tt),t(at),t(X),t(nt),t(ot),t(lt),t(Y),t(rt),t(K),t(it),t(ee),t(st),t(dt),t(ae),t(ct),t(ne),t(mt),t(pt),t(c),t(ht),t(gt),t(y),t(ut),t(_t),t(ze)),t($),f(N,e),f(E,e),f(B,e),f(H,e),f(Q,e),f(R,e),f(G,e),f(V,e),f(te,e),f(oe,e),f(le),f(re),f(ie),f(se),f(de),f(ce),f(me),f(pe),f(he),f(ge),f(ue),f(_e,e),f(fe),f(ve,e)}}}const La='{"title":"CPO Trainer","local":"cpo-trainer","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the CPOTrainer","local":"using-the-cpotrainer","sections":[],"depth":2},{"title":"Loss functions","local":"loss-functions","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"CPOTrainer","local":"trl.CPOTrainer","sections":[],"depth":2},{"title":"CPOConfig","local":"trl.CPOConfig","sections":[],"depth":2}],"depth":1}';function za(Kt){return ka(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Aa{constructor($){super(),Na(this,$,za,Ea,Ja,{})}}export{Qa as component};
