import{s as Ze,n as Se,o as De}from"../chunks/scheduler.9039eef2.js";import{S as Xe,i as Ye,g as r,s as l,r as p,A as Qe,h as i,f as t,c as o,j as Te,u as c,x as m,k as $e,l as Ke,y as d,a as n,v as _,d as f,t as u,w as h}from"../chunks/index.ded8f90d.js";import{D as Ge}from"../chunks/Docstring.2eae8017.js";import{C as Ve}from"../chunks/CodeBlock.8580f3e8.js";import{H as E,E as ea}from"../chunks/EditOnGithub.b5540897.js";function aa(Me){let w,Y,D,Q,T,K,$,Ce="TRL supports custom reward modeling for anyone to perform reward modeling on their dataset and model.",ee,y,Re='Check out a complete flexible example at <a href="https://github.com/huggingface/trl/tree/main/examples/scripts/reward_modeling.py" rel="nofollow"><code>examples/scripts/reward_modeling.py</code></a>.',ae,x,te,N,je='The <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a> expects a very specific format for the dataset since the model will be trained on pairs of examples to predict which of the two is preferred. We provide an example from the <a href="https://huggingface.co/datasets/Anthropic/hh-rlhf" rel="nofollow"><code>Anthropic/hh-rlhf</code></a> dataset below:',ne,b,Le='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/rlhf-antropic-example.png" ,="" width="50%"/>',le,k,Je="Therefore the final dataset object should contain two 4 entries at least if you use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named:",oe,O,Ue="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",re,F,ie,M,He=`After preparing your dataset, you can use the <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a> in the same way as the <code>Trainer</code> class from 🤗 Transformers.
You should pass an <code>AutoModelForSequenceClassification</code> model to the <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a>, along with a <a href="/docs/trl/main/en/trainer#trl.RewardConfig">RewardConfig</a> which configures the hyperparameters of the training.`,se,C,me,R,Ie='Just pass a <code>peft_config</code> in the keyword arguments of <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a>, and the trainer should automatically take care of converting the model into a PEFT model!',de,j,pe,L,ce,J,Be='As in the <a href="https://huggingface.co/papers/2307.09288" rel="nofollow">Llama 2 paper</a>, you can add a margin to the loss by adding a <code>margin</code> column to the dataset. The reward collator will automatically pass it through and the loss will be computed accordingly.',_e,U,fe,H,ue,v,I,ye,A,Pe='RewardConfig collects all training arguments related to the <a href="/docs/trl/main/en/trainer#trl.RewardTrainer">RewardTrainer</a> class.',xe,q,ze=`Using <code>HfArgumentParser</code> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,he,B,ve,s,P,Ne,W,Ee=`The RewardTrainer can be used to train your custom Reward Model. It is a subclass of the
<code>transformers.Trainer</code> class and inherits all of its attributes and methods. It is recommended to use
an <code>AutoModelForSequenceClassification</code> as the reward model. The reward model should be trained on a dataset
of paired examples, where each example is a tuple of two sequences. The reward model should be trained to
predict which example in the pair is more relevant to the task at hand.`,ke,G,Ae=`The reward trainer expects a very specific format for the dataset. The dataset should contain two 4 entries at least
if you don’t use the default <code>RewardDataCollatorWithPadding</code> data collator. The entries should be named`,Oe,V,qe="<li><code>input_ids_chosen</code></li> <li><code>attention_mask_chosen</code></li> <li><code>input_ids_rejected</code></li> <li><code>attention_mask_rejected</code></li>",Fe,Z,We=`Optionally, you can also pass a <code>margin</code> entry to the dataset. This entry should contain the margin used to modulate the
loss of the reward model as outlined in <a href="https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/" rel="nofollow">https://ai.meta.com/research/publications/llama-2-open-foundation-and-fine-tuned-chat-models/</a>.
If you don’t pass a margin, no margin will be used.`,ge,z,we,X,be;return T=new E({props:{title:"Reward Modeling",local:"reward-modeling",headingTag:"h1"}}),x=new E({props:{title:"Expected dataset format",local:"expected-dataset-format",headingTag:"h2"}}),F=new E({props:{title:"Using the RewardTrainer",local:"using-the-rewardtrainer",headingTag:"h2"}}),C=new E({props:{title:"Leveraging 🤗 PEFT to train a reward model",local:"leveraging--peft-to-train-a-reward-model",headingTag:"h3"}}),j=new Ve({props:{code:"JTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, AutoTokenizer
<span class="hljs-keyword">from</span> trl <span class="hljs-keyword">import</span> RewardTrainer, RewardConfig

model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
peft_config = LoraConfig(
    task_type=TaskType.SEQ_CLS,
    inference_mode=<span class="hljs-literal">False</span>,
    r=<span class="hljs-number">8</span>,
    lora_alpha=<span class="hljs-number">32</span>,
    lora_dropout=<span class="hljs-number">0.1</span>,
)

...

trainer = RewardTrainer(
    model=model,
    args=training_args,
    tokenizer=tokenizer,
    train_dataset=dataset,
    peft_config=peft_config,
)

trainer.train()
`,wrap:!1}}),L=new E({props:{title:"Adding a margin to the loss",local:"adding-a-margin-to-the-loss",headingTag:"h3"}}),U=new Ve({props:{code:"ZGVmJTIwYWRkX21hcmdpbihyb3cpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwQXNzdW1lJTIweW91JTIwaGF2ZSUyMGElMjBzY29yZV9jaG9zZW4lMjBhbmQlMjBzY29yZV9yZWplY3RlZCUyMGNvbHVtbnMlMjB0aGF0JTIweW91JTIwd2FudCUyMHRvJTIwdXNlJTIwdG8lMjBjb21wdXRlJTIwdGhlJTIwbWFyZ2luJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJ21hcmdpbiclM0ElMjByb3clNUInc2NvcmVfY2hvc2VuJyU1RCUyMC0lMjByb3clNUInc2NvcmVfcmVqZWN0ZWQnJTVEJTdEJTBBJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGFkZF9tYXJnaW4p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">add_margin</span>(<span class="hljs-params">row</span>):
    <span class="hljs-comment"># Assume you have a score_chosen and score_rejected columns that you want to use to compute the margin</span>
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&#x27;margin&#x27;</span>: row[<span class="hljs-string">&#x27;score_chosen&#x27;</span>] - row[<span class="hljs-string">&#x27;score_rejected&#x27;</span>]}

dataset = dataset.<span class="hljs-built_in">map</span>(add_margin)`,wrap:!1}}),H=new E({props:{title:"RewardConfig",local:"trl.RewardConfig",headingTag:"h2"}}),I=new Ge({props:{name:"class trl.RewardConfig",anchor:"trl.RewardConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": Union = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": Optional = None"},{name:"per_gpu_eval_batch_size",val:": Optional = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": Optional = None"},{name:"eval_delay",val:": Optional = 0"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": Union = 'linear'"},{name:"lr_scheduler_kwargs",val:": Union = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": Optional = 'passive'"},{name:"log_level_replica",val:": Optional = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": Optional = None"},{name:"logging_strategy",val:": Union = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": Union = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": Optional = None"},{name:"save_safetensors",val:": Optional = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": Optional = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": Optional = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": Optional = None"},{name:"tpu_num_cores",val:": Optional = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": Union = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": Optional = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": Optional = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": Optional = None"},{name:"disable_tqdm",val:": Optional = None"},{name:"remove_unused_columns",val:": Optional = True"},{name:"label_names",val:": Optional = None"},{name:"load_best_model_at_end",val:": Optional = False"},{name:"metric_for_best_model",val:": Optional = None"},{name:"greater_is_better",val:": Optional = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": Union = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": Union = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": Optional = None"},{name:"accelerator_config",val:": Union = None"},{name:"deepspeed",val:": Union = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": Union = 'adamw_torch'"},{name:"optim_args",val:": Optional = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": Optional = 'length'"},{name:"report_to",val:": Union = None"},{name:"ddp_find_unused_parameters",val:": Optional = None"},{name:"ddp_bucket_cap_mb",val:": Optional = None"},{name:"ddp_broadcast_buffers",val:": Optional = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": Optional = None"},{name:"hub_model_id",val:": Optional = None"},{name:"hub_strategy",val:": Union = 'every_save'"},{name:"hub_token",val:": Optional = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": Union = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": Union = None"},{name:"push_to_hub_model_id",val:": Optional = None"},{name:"push_to_hub_organization",val:": Optional = None"},{name:"push_to_hub_token",val:": Optional = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": Optional = None"},{name:"ray_scope",val:": Optional = 'last'"},{name:"ddp_timeout",val:": Optional = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": Optional = None"},{name:"torch_compile_mode",val:": Optional = None"},{name:"dispatch_batches",val:": Optional = None"},{name:"split_batches",val:": Optional = None"},{name:"include_tokens_per_second",val:": Optional = False"},{name:"include_num_input_tokens_seen",val:": Optional = False"},{name:"neftune_noise_alpha",val:": Optional = None"},{name:"optim_target_modules",val:": Union = None"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"trl.RewardConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The maximum length of the sequences in the batch. This argument is required if you want to use the default data collator.`,name:"max_length"},{anchor:"trl.RewardConfig.gradient_checkpointing",description:`<strong>gradient_checkpointing</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, use gradient checkpointing to save memory at the expense of slower backward pass.`,name:"gradient_checkpointing"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_config.py#L21"}}),B=new E({props:{title:"RewardTrainer",local:"trl.RewardTrainer",headingTag:"h2"}}),P=new Ge({props:{name:"class trl.RewardTrainer",anchor:"trl.RewardTrainer",parameters:[{name:"model",val:": Union = None"},{name:"args",val:": Optional = None"},{name:"data_collator",val:": Optional = None"},{name:"train_dataset",val:": Optional = None"},{name:"eval_dataset",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"model_init",val:": Optional = None"},{name:"compute_metrics",val:": Optional = None"},{name:"callbacks",val:": Optional = None"},{name:"optimizers",val:": Tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": Optional = None"},{name:"max_length",val:": Optional = None"},{name:"peft_config",val:": Optional = None"}],source:"https://github.com/huggingface/trl/blob/main/trl/trainer/reward_trainer.py#L36"}}),z=new ea({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/reward_trainer.mdx"}}),{c(){w=r("meta"),Y=l(),D=r("p"),Q=l(),p(T.$$.fragment),K=l(),$=r("p"),$.textContent=Ce,ee=l(),y=r("p"),y.innerHTML=Re,ae=l(),p(x.$$.fragment),te=l(),N=r("p"),N.innerHTML=je,ne=l(),b=r("div"),b.innerHTML=Le,le=l(),k=r("p"),k.innerHTML=Je,oe=l(),O=r("ul"),O.innerHTML=Ue,re=l(),p(F.$$.fragment),ie=l(),M=r("p"),M.innerHTML=He,se=l(),p(C.$$.fragment),me=l(),R=r("p"),R.innerHTML=Ie,de=l(),p(j.$$.fragment),pe=l(),p(L.$$.fragment),ce=l(),J=r("p"),J.innerHTML=Be,_e=l(),p(U.$$.fragment),fe=l(),p(H.$$.fragment),ue=l(),v=r("div"),p(I.$$.fragment),ye=l(),A=r("p"),A.innerHTML=Pe,xe=l(),q=r("p"),q.innerHTML=ze,he=l(),p(B.$$.fragment),ve=l(),s=r("div"),p(P.$$.fragment),Ne=l(),W=r("p"),W.innerHTML=Ee,ke=l(),G=r("p"),G.innerHTML=Ae,Oe=l(),V=r("ul"),V.innerHTML=qe,Fe=l(),Z=r("p"),Z.innerHTML=We,ge=l(),p(z.$$.fragment),we=l(),X=r("p"),this.h()},l(e){const a=Qe("svelte-u9bgzb",document.head);w=i(a,"META",{name:!0,content:!0}),a.forEach(t),Y=o(e),D=i(e,"P",{}),Te(D).forEach(t),Q=o(e),c(T.$$.fragment,e),K=o(e),$=i(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-wgcft"&&($.textContent=Ce),ee=o(e),y=i(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-19du5x9"&&(y.innerHTML=Re),ae=o(e),c(x.$$.fragment,e),te=o(e),N=i(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1gyp09o"&&(N.innerHTML=je),ne=o(e),b=i(e,"DIV",{style:!0,"data-svelte-h":!0}),m(b)!=="svelte-z15c7z"&&(b.innerHTML=Le),le=o(e),k=i(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-u17vu1"&&(k.innerHTML=Je),oe=o(e),O=i(e,"UL",{"data-svelte-h":!0}),m(O)!=="svelte-1ytuxgw"&&(O.innerHTML=Ue),re=o(e),c(F.$$.fragment,e),ie=o(e),M=i(e,"P",{"data-svelte-h":!0}),m(M)!=="svelte-xu1rr5"&&(M.innerHTML=He),se=o(e),c(C.$$.fragment,e),me=o(e),R=i(e,"P",{"data-svelte-h":!0}),m(R)!=="svelte-wk02l7"&&(R.innerHTML=Ie),de=o(e),c(j.$$.fragment,e),pe=o(e),c(L.$$.fragment,e),ce=o(e),J=i(e,"P",{"data-svelte-h":!0}),m(J)!=="svelte-175anp9"&&(J.innerHTML=Be),_e=o(e),c(U.$$.fragment,e),fe=o(e),c(H.$$.fragment,e),ue=o(e),v=i(e,"DIV",{class:!0});var S=Te(v);c(I.$$.fragment,S),ye=o(S),A=i(S,"P",{"data-svelte-h":!0}),m(A)!=="svelte-u4tkv1"&&(A.innerHTML=Pe),xe=o(S),q=i(S,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1xl7jqc"&&(q.innerHTML=ze),S.forEach(t),he=o(e),c(B.$$.fragment,e),ve=o(e),s=i(e,"DIV",{class:!0});var g=Te(s);c(P.$$.fragment,g),Ne=o(g),W=i(g,"P",{"data-svelte-h":!0}),m(W)!=="svelte-qafafj"&&(W.innerHTML=Ee),ke=o(g),G=i(g,"P",{"data-svelte-h":!0}),m(G)!=="svelte-bkmbwh"&&(G.innerHTML=Ae),Oe=o(g),V=i(g,"UL",{"data-svelte-h":!0}),m(V)!=="svelte-1ytuxgw"&&(V.innerHTML=qe),Fe=o(g),Z=i(g,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-18tbp4c"&&(Z.innerHTML=We),g.forEach(t),ge=o(e),c(z.$$.fragment,e),we=o(e),X=i(e,"P",{}),Te(X).forEach(t),this.h()},h(){$e(w,"name","hf:doc:metadata"),$e(w,"content",ta),Ke(b,"text-align","center"),$e(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$e(s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){d(document.head,w),n(e,Y,a),n(e,D,a),n(e,Q,a),_(T,e,a),n(e,K,a),n(e,$,a),n(e,ee,a),n(e,y,a),n(e,ae,a),_(x,e,a),n(e,te,a),n(e,N,a),n(e,ne,a),n(e,b,a),n(e,le,a),n(e,k,a),n(e,oe,a),n(e,O,a),n(e,re,a),_(F,e,a),n(e,ie,a),n(e,M,a),n(e,se,a),_(C,e,a),n(e,me,a),n(e,R,a),n(e,de,a),_(j,e,a),n(e,pe,a),_(L,e,a),n(e,ce,a),n(e,J,a),n(e,_e,a),_(U,e,a),n(e,fe,a),_(H,e,a),n(e,ue,a),n(e,v,a),_(I,v,null),d(v,ye),d(v,A),d(v,xe),d(v,q),n(e,he,a),_(B,e,a),n(e,ve,a),n(e,s,a),_(P,s,null),d(s,Ne),d(s,W),d(s,ke),d(s,G),d(s,Oe),d(s,V),d(s,Fe),d(s,Z),n(e,ge,a),_(z,e,a),n(e,we,a),n(e,X,a),be=!0},p:Se,i(e){be||(f(T.$$.fragment,e),f(x.$$.fragment,e),f(F.$$.fragment,e),f(C.$$.fragment,e),f(j.$$.fragment,e),f(L.$$.fragment,e),f(U.$$.fragment,e),f(H.$$.fragment,e),f(I.$$.fragment,e),f(B.$$.fragment,e),f(P.$$.fragment,e),f(z.$$.fragment,e),be=!0)},o(e){u(T.$$.fragment,e),u(x.$$.fragment,e),u(F.$$.fragment,e),u(C.$$.fragment,e),u(j.$$.fragment,e),u(L.$$.fragment,e),u(U.$$.fragment,e),u(H.$$.fragment,e),u(I.$$.fragment,e),u(B.$$.fragment,e),u(P.$$.fragment,e),u(z.$$.fragment,e),be=!1},d(e){e&&(t(Y),t(D),t(Q),t(K),t($),t(ee),t(y),t(ae),t(te),t(N),t(ne),t(b),t(le),t(k),t(oe),t(O),t(re),t(ie),t(M),t(se),t(me),t(R),t(de),t(pe),t(ce),t(J),t(_e),t(fe),t(ue),t(v),t(he),t(ve),t(s),t(ge),t(we),t(X)),t(w),h(T,e),h(x,e),h(F,e),h(C,e),h(j,e),h(L,e),h(U,e),h(H,e),h(I),h(B,e),h(P),h(z,e)}}}const ta='{"title":"Reward Modeling","local":"reward-modeling","sections":[{"title":"Expected dataset format","local":"expected-dataset-format","sections":[],"depth":2},{"title":"Using the RewardTrainer","local":"using-the-rewardtrainer","sections":[{"title":"Leveraging 🤗 PEFT to train a reward model","local":"leveraging--peft-to-train-a-reward-model","sections":[],"depth":3},{"title":"Adding a margin to the loss","local":"adding-a-margin-to-the-loss","sections":[],"depth":3}],"depth":2},{"title":"RewardConfig","local":"trl.RewardConfig","sections":[],"depth":2},{"title":"RewardTrainer","local":"trl.RewardTrainer","sections":[],"depth":2}],"depth":1}';function na(Me){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ma extends Xe{constructor(w){super(),Ye(this,w,na,aa,Ze,{})}}export{ma as component};
