import{s as Gt,o as Vt,n as Le}from"../chunks/scheduler.9bc65507.js";import{S as Yt,i as xt,g as a,s as n,r as o,A as Qt,h as p,f as t,c as M,j as vt,u as m,x as i,k as Xt,y as zt,a as s,v as J,d as r,t as T,w as c}from"../chunks/index.24549926.js";import{T as Fe}from"../chunks/Tip.2b78d0ae.js";import{C as w}from"../chunks/CodeBlock.6ca813ee.js";import{H as Nl}from"../chunks/Heading.cc20227a.js";function Et(f){let y,j="如果你的模型与库中的某个模型非常相似，你可以重用与该模型相同的配置。";return{c(){y=a("p"),y.textContent=j},l(d){y=p(d,"P",{"data-svelte-h":!0}),i(y)!=="svelte-1t5zcat"&&(y.textContent=j)},m(d,U){s(d,y,U)},p:Le,d(d){d&&t(y)}}}function Ht(f){let y,j="此 API 是实验性的，未来的发布中可能会有一些轻微的不兼容更改。";return{c(){y=a("p"),y.textContent=j},l(d){y=p(d,"P",{"data-svelte-h":!0}),i(y)!=="svelte-k4mbd2"&&(y.textContent=j)},m(d,U){s(d,y,U)},p:Le,d(d){d&&t(y)}}}function Ft(f){let y,j="如果从库中复制模型文件，你需要将文件顶部的所有相对导入替换为从 <code>transformers</code> 包中的导入。";return{c(){y=a("p"),y.innerHTML=j},l(d){y=p(d,"P",{"data-svelte-h":!0}),i(y)!=="svelte-3nrr3e"&&(y.innerHTML=j)},m(d,U){s(d,y,U)},p:Le,d(d){d&&t(y)}}}function Lt(f){let y,j,d,U,I,Wl,_,Se="🤗 Transformers 库设计得易于扩展。每个模型的代码都在仓库给定的子文件夹中，没有进行抽象，因此你可以轻松复制模型代码文件并根据需要进行调整。",Rl,Z,Pe="如果你要编写全新的模型，从头开始可能更容易。在本教程中，我们将向你展示如何编写自定义模型及其配置，以便可以在 Transformers 中使用它；以及如何与社区共享它（及其依赖的代码），以便任何人都可以使用，即使它不在 🤗 Transformers 库中。",vl,h,qe='我们将以 ResNet 模型为例，通过将 <a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">timm 库</a> 的 ResNet 类封装到 <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> 中来进行说明。',Xl,A,Gl,$,De="在深入研究模型之前，让我们首先编写其配置。模型的配置是一个对象，其中包含构建模型所需的所有信息。我们将在下一节中看到，模型只能接受一个 <code>config</code> 来进行初始化，因此我们很需要使该对象尽可能完整。",Vl,k,Ke="我们将采用一些我们可能想要调整的 ResNet 类的参数举例。不同的配置将为我们提供不同类型可能的 ResNet 模型。在确认其中一些参数的有效性后，我们只需存储这些参数。",Yl,g,xl,N,Oe="编写自定义配置时需要记住的三个重要事项如下：",Ql,B,lt="<li>必须继承自 <code>PretrainedConfig</code>，</li> <li><code>PretrainedConfig</code> 的 <code>__init__</code> 方法必须接受任何 kwargs，</li> <li>这些 <code>kwargs</code> 需要传递给超类的 <code>__init__</code> 方法。</li>",zl,W,et="继承是为了确保你获得来自 🤗 Transformers 库的所有功能，而另外两个约束源于 <code>PretrainedConfig</code> 的字段比你设置的字段多。在使用 <code>from_pretrained</code> 方法重新加载配置时，这些字段需要被你的配置接受，然后传递给超类。",El,R,tt="为你的配置定义 <code>model_type</code>（此处为 <code>model_type=&quot;resnet&quot;</code>）不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",Hl,v,st="做完这些以后，就可以像使用库里任何其他模型配置一样，轻松地创建和保存配置。以下代码展示了如何创建并保存 resnet50d 配置：",Fl,X,Ll,G,nt="这行代码将在 <code>custom-resnet</code> 文件夹内保存一个名为 <code>config.json</code> 的文件。然后，你可以使用 <code>from_pretrained</code> 方法重新加载配置：",Sl,V,Pl,Y,Mt='你还可以使用 <a href="/docs/transformers/main/zh/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> 类的任何其他方法，例如 <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a>，直接将配置上传到 Hub。',ql,x,Dl,Q,at="有了 ResNet 配置后，就可以继续编写模型了。实际上，我们将编写两个模型：一个模型用于从一批图像中提取隐藏特征（类似于 <code>BertModel</code>），另一个模型适用于图像分类（类似于 <code>BertForSequenceClassification</code>）。",Kl,z,pt="正如之前提到的，我们只会编写一个松散的模型包装，以使示例保持简洁。在编写此类之前，只需要建立起块类型（block types）与实际块类（block classes）之间的映射。然后，通过将所有内容传递给ResNet类，从配置中定义模型：",Ol,E,le,H,it="对用于进行图像分类的模型，我们只需更改前向方法：",ee,F,te,L,yt="在这两种情况下，请注意我们如何继承 <code>PreTrainedModel</code> 并使用 <code>config</code> 调用了超类的初始化（有点像编写常规的torch.nn.Module）。设置 <code>config_class</code> 的那行代码不是必须的，除非你想使用自动类注册你的模型（请参阅最后一节）。",se,C,ne,S,ot="你可以让模型返回任何你想要的内容，但是像我们为 <code>ResnetModelForImageClassification</code> 做的那样返回一个字典，并在传递标签时包含loss，可以使你的模型能够在 <code>Trainer</code> 类中直接使用。只要你计划使用自己的训练循环或其他库进行训练，也可以使用其他输出格式。",Me,P,mt="现在我们已经有了模型类，让我们创建一个：",ae,q,pe,D,Jt='同样的，你可以使用 <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a> 的任何方法，比如 <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> 或者 <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a>。我们将在下一节中使用第二种方法，并了解如何如何使用我们的模型的代码推送模型权重。但首先，让我们在模型内加载一些预训练权重。',ie,K,rt="在你自己的用例中，你可能会在自己的数据上训练自定义模型。为了快速完成本教程，我们将使用 resnet50d 的预训练版本。由于我们的模型只是它的包装，转移这些权重将会很容易：",ye,O,oe,ll,Tt='现在让我们看看，如何确保在执行 <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel.save_pretrained">save_pretrained()</a> 或 <a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.push_to_hub">push_to_hub()</a> 时，模型的代码被保存。',me,el,Je,u,re,tl,ct="首先，确保你的模型在一个 <code>.py</code> 文件中完全定义。只要所有文件都位于同一目录中，它就可以依赖于某些其他文件的相对导入（目前我们还不为子模块支持此功能）。对于我们的示例，我们将在当前工作目录中名为 <code>resnet_model</code> 的文件夹中定义一个 <code>modeling_resnet.py</code> 文件和一个 <code>configuration_resnet.py</code> 文件。 配置文件包含 <code>ResnetConfig</code> 的代码，模型文件包含 <code>ResnetModel</code> 和 <code>ResnetModelForImageClassification</code> 的代码。",Te,sl,ce,nl,dt="<code>__init__.py</code> 可以为空，它的存在只是为了让 Python 检测到 <code>resnet_model</code> 可以用作模块。",de,b,we,Ml,wt="请注意，你可以重用（或子类化）现有的配置/模型。",je,al,jt="要与社区共享您的模型，请参照以下步骤：首先从新创建的文件中导入ResNet模型和配置：",Ue,pl,fe,il,Ut="接下来，你需要告诉库，当使用 <code>save_pretrained</code> 方法时，你希望复制这些对象的代码文件，并将它们正确注册到给定的 Auto 类（特别是对于模型），只需要运行以下代码：",Ce,yl,ue,ol,ft="请注意，对于配置（只有一个自动类 <code>AutoConfig</code>），不需要指定自动类，但对于模型来说情况不同。 你的自定义模型可能适用于许多不同的任务，因此你必须指定哪一个自动类适合你的模型。",be,ml,Ct="接下来，让我们像之前一样创建配置和模型：",Ie,Jl,_e,rl,ut="现在要将模型推送到集线器，请确保你已登录。你看可以在终端中运行以下命令：",Ze,Tl,he,cl,bt="或者在笔记本中运行以下代码：",Ae,dl,$e,wl,It="然后，可以这样将模型推送到自己的命名空间（或你所属的组织）：",ke,jl,ge,Ul,_t='除了模型权重和 JSON 格式的配置外，这行代码也会复制 <code>custom-resnet50d</code> 文件夹内的模型以及配置的 <code>.py</code> 文件并将结果上传至 Hub。你可以在此<a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">模型仓库</a>中查看结果。',Ne,fl,Zt='有关推推送至 Hub 方法的更多信息，请参阅<a href="model_sharing">共享教程</a>。',Be,Cl,We,ul,ht='可以使用自动类（auto-classes）和 <code>from_pretrained</code> 方法，使用模型仓库里带有自定义代码的配置、模型或分词器文件。所有上传到 Hub 的文件和代码都会进行恶意软件扫描（有关更多信息，请参阅 <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Hub 安全</a> 文档）, 但你仍应查看模型代码和作者，以避免在你的计算机上执行恶意代码。 设置 <code>trust_remote_code=True</code> 以使用带有自定义代码的模型：',Re,bl,ve,Il,At="我们强烈建议为 <code>revision</code> 参数传递提交哈希（commit hash），以确保模型的作者没有使用一些恶意的代码行更新了代码（除非您完全信任模型的作者）。",Xe,_l,Ge,Zl,$t="在 Hub 上浏览模型仓库的提交历史时，有一个按钮可以轻松复制任何提交的提交哈希。",Ve,hl,Ye,Al,kt="如果你在编写一个扩展 🤗 Transformers 的库，你可能想要扩展自动类以包含您自己的模型。这与将代码推送到 Hub 不同，因为用户需要导入你的库才能获取自定义模型（与从 Hub 自动下载模型代码相反）。",xe,$l,gt="只要你的配置 <code>model_type</code> 属性与现有模型类型不同，并且你的模型类有正确的 <code>config_class</code> 属性，你可以像这样将它们添加到自动类中：",Qe,kl,ze,gl,Nt="请注意，将自定义配置注册到 <code>AutoConfig</code> 时，使用的第一个参数需要与自定义配置的 <code>model_type</code> 匹配；而将自定义模型注册到任何自动模型类时，使用的第一个参数需要与 <code>config_class</code> 匹配。",Ee,Bl,He;return I=new Nl({props:{title:"共享自定义模型",local:"共享自定义模型",headingTag:"h1"}}),A=new Nl({props:{title:"编写自定义配置",local:"编写自定义配置",headingTag:"h2"}}),g=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),X=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),V=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),x=new Nl({props:{title:"编写自定义模型",local:"编写自定义模型",headingTag:"h2"}}),E=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),F=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),C=new Fe({props:{$$slots:{default:[Et]},$$scope:{ctx:f}}}),q=new w({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),O=new w({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),el=new Nl({props:{title:"将代码发送到 Hub",local:"将代码发送到-hub",headingTag:"h2"}}),u=new Fe({props:{warning:!0,$$slots:{default:[Ht]},$$scope:{ctx:f}}}),sl=new w({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),b=new Fe({props:{warning:!0,$$slots:{default:[Ft]},$$scope:{ctx:f}}}),pl=new w({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),yl=new w({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),Jl=new w({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Tl=new w({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),dl=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),jl=new w({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),Cl=new Nl({props:{title:"使用带有自定义代码的模型",local:"使用带有自定义代码的模型",headingTag:"h2"}}),bl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),_l=new w({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),hl=new Nl({props:{title:"将自定义代码的模型注册到自动类",local:"将自定义代码的模型注册到自动类",headingTag:"h2"}}),kl=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){y=a("meta"),j=n(),d=a("p"),U=n(),o(I.$$.fragment),Wl=n(),_=a("p"),_.textContent=Se,Rl=n(),Z=a("p"),Z.textContent=Pe,vl=n(),h=a("p"),h.innerHTML=qe,Xl=n(),o(A.$$.fragment),Gl=n(),$=a("p"),$.innerHTML=De,Vl=n(),k=a("p"),k.textContent=Ke,Yl=n(),o(g.$$.fragment),xl=n(),N=a("p"),N.textContent=Oe,Ql=n(),B=a("ul"),B.innerHTML=lt,zl=n(),W=a("p"),W.innerHTML=et,El=n(),R=a("p"),R.innerHTML=tt,Hl=n(),v=a("p"),v.textContent=st,Fl=n(),o(X.$$.fragment),Ll=n(),G=a("p"),G.innerHTML=nt,Sl=n(),o(V.$$.fragment),Pl=n(),Y=a("p"),Y.innerHTML=Mt,ql=n(),o(x.$$.fragment),Dl=n(),Q=a("p"),Q.innerHTML=at,Kl=n(),z=a("p"),z.textContent=pt,Ol=n(),o(E.$$.fragment),le=n(),H=a("p"),H.textContent=it,ee=n(),o(F.$$.fragment),te=n(),L=a("p"),L.innerHTML=yt,se=n(),o(C.$$.fragment),ne=n(),S=a("p"),S.innerHTML=ot,Me=n(),P=a("p"),P.textContent=mt,ae=n(),o(q.$$.fragment),pe=n(),D=a("p"),D.innerHTML=Jt,ie=n(),K=a("p"),K.textContent=rt,ye=n(),o(O.$$.fragment),oe=n(),ll=a("p"),ll.innerHTML=Tt,me=n(),o(el.$$.fragment),Je=n(),o(u.$$.fragment),re=n(),tl=a("p"),tl.innerHTML=ct,Te=n(),o(sl.$$.fragment),ce=n(),nl=a("p"),nl.innerHTML=dt,de=n(),o(b.$$.fragment),we=n(),Ml=a("p"),Ml.textContent=wt,je=n(),al=a("p"),al.textContent=jt,Ue=n(),o(pl.$$.fragment),fe=n(),il=a("p"),il.innerHTML=Ut,Ce=n(),o(yl.$$.fragment),ue=n(),ol=a("p"),ol.innerHTML=ft,be=n(),ml=a("p"),ml.textContent=Ct,Ie=n(),o(Jl.$$.fragment),_e=n(),rl=a("p"),rl.textContent=ut,Ze=n(),o(Tl.$$.fragment),he=n(),cl=a("p"),cl.textContent=bt,Ae=n(),o(dl.$$.fragment),$e=n(),wl=a("p"),wl.textContent=It,ke=n(),o(jl.$$.fragment),ge=n(),Ul=a("p"),Ul.innerHTML=_t,Ne=n(),fl=a("p"),fl.innerHTML=Zt,Be=n(),o(Cl.$$.fragment),We=n(),ul=a("p"),ul.innerHTML=ht,Re=n(),o(bl.$$.fragment),ve=n(),Il=a("p"),Il.innerHTML=At,Xe=n(),o(_l.$$.fragment),Ge=n(),Zl=a("p"),Zl.textContent=$t,Ve=n(),o(hl.$$.fragment),Ye=n(),Al=a("p"),Al.textContent=kt,xe=n(),$l=a("p"),$l.innerHTML=gt,Qe=n(),o(kl.$$.fragment),ze=n(),gl=a("p"),gl.innerHTML=Nt,Ee=n(),Bl=a("p"),this.h()},l(l){const e=Qt("svelte-u9bgzb",document.head);y=p(e,"META",{name:!0,content:!0}),e.forEach(t),j=M(l),d=p(l,"P",{}),vt(d).forEach(t),U=M(l),m(I.$$.fragment,l),Wl=M(l),_=p(l,"P",{"data-svelte-h":!0}),i(_)!=="svelte-9nxend"&&(_.textContent=Se),Rl=M(l),Z=p(l,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-19a103f"&&(Z.textContent=Pe),vl=M(l),h=p(l,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1b61zv2"&&(h.innerHTML=qe),Xl=M(l),m(A.$$.fragment,l),Gl=M(l),$=p(l,"P",{"data-svelte-h":!0}),i($)!=="svelte-1227xwf"&&($.innerHTML=De),Vl=M(l),k=p(l,"P",{"data-svelte-h":!0}),i(k)!=="svelte-i8hsxz"&&(k.textContent=Ke),Yl=M(l),m(g.$$.fragment,l),xl=M(l),N=p(l,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1a7oeqv"&&(N.textContent=Oe),Ql=M(l),B=p(l,"UL",{"data-svelte-h":!0}),i(B)!=="svelte-1s6yo4g"&&(B.innerHTML=lt),zl=M(l),W=p(l,"P",{"data-svelte-h":!0}),i(W)!=="svelte-tl0pjo"&&(W.innerHTML=et),El=M(l),R=p(l,"P",{"data-svelte-h":!0}),i(R)!=="svelte-1atr0z9"&&(R.innerHTML=tt),Hl=M(l),v=p(l,"P",{"data-svelte-h":!0}),i(v)!=="svelte-1p70ds2"&&(v.textContent=st),Fl=M(l),m(X.$$.fragment,l),Ll=M(l),G=p(l,"P",{"data-svelte-h":!0}),i(G)!=="svelte-o9rk46"&&(G.innerHTML=nt),Sl=M(l),m(V.$$.fragment,l),Pl=M(l),Y=p(l,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-1vmurqt"&&(Y.innerHTML=Mt),ql=M(l),m(x.$$.fragment,l),Dl=M(l),Q=p(l,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-bmcwbb"&&(Q.innerHTML=at),Kl=M(l),z=p(l,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1lbtc6j"&&(z.textContent=pt),Ol=M(l),m(E.$$.fragment,l),le=M(l),H=p(l,"P",{"data-svelte-h":!0}),i(H)!=="svelte-16341pc"&&(H.textContent=it),ee=M(l),m(F.$$.fragment,l),te=M(l),L=p(l,"P",{"data-svelte-h":!0}),i(L)!=="svelte-18rfxea"&&(L.innerHTML=yt),se=M(l),m(C.$$.fragment,l),ne=M(l),S=p(l,"P",{"data-svelte-h":!0}),i(S)!=="svelte-od54k8"&&(S.innerHTML=ot),Me=M(l),P=p(l,"P",{"data-svelte-h":!0}),i(P)!=="svelte-ym2h95"&&(P.textContent=mt),ae=M(l),m(q.$$.fragment,l),pe=M(l),D=p(l,"P",{"data-svelte-h":!0}),i(D)!=="svelte-gmforu"&&(D.innerHTML=Jt),ie=M(l),K=p(l,"P",{"data-svelte-h":!0}),i(K)!=="svelte-36p84q"&&(K.textContent=rt),ye=M(l),m(O.$$.fragment,l),oe=M(l),ll=p(l,"P",{"data-svelte-h":!0}),i(ll)!=="svelte-k1uac7"&&(ll.innerHTML=Tt),me=M(l),m(el.$$.fragment,l),Je=M(l),m(u.$$.fragment,l),re=M(l),tl=p(l,"P",{"data-svelte-h":!0}),i(tl)!=="svelte-3w8bak"&&(tl.innerHTML=ct),Te=M(l),m(sl.$$.fragment,l),ce=M(l),nl=p(l,"P",{"data-svelte-h":!0}),i(nl)!=="svelte-n806b8"&&(nl.innerHTML=dt),de=M(l),m(b.$$.fragment,l),we=M(l),Ml=p(l,"P",{"data-svelte-h":!0}),i(Ml)!=="svelte-18wuvr2"&&(Ml.textContent=wt),je=M(l),al=p(l,"P",{"data-svelte-h":!0}),i(al)!=="svelte-7gjgjm"&&(al.textContent=jt),Ue=M(l),m(pl.$$.fragment,l),fe=M(l),il=p(l,"P",{"data-svelte-h":!0}),i(il)!=="svelte-nsc87p"&&(il.innerHTML=Ut),Ce=M(l),m(yl.$$.fragment,l),ue=M(l),ol=p(l,"P",{"data-svelte-h":!0}),i(ol)!=="svelte-1dt591c"&&(ol.innerHTML=ft),be=M(l),ml=p(l,"P",{"data-svelte-h":!0}),i(ml)!=="svelte-1vunet5"&&(ml.textContent=Ct),Ie=M(l),m(Jl.$$.fragment,l),_e=M(l),rl=p(l,"P",{"data-svelte-h":!0}),i(rl)!=="svelte-11g63u9"&&(rl.textContent=ut),Ze=M(l),m(Tl.$$.fragment,l),he=M(l),cl=p(l,"P",{"data-svelte-h":!0}),i(cl)!=="svelte-1emymh6"&&(cl.textContent=bt),Ae=M(l),m(dl.$$.fragment,l),$e=M(l),wl=p(l,"P",{"data-svelte-h":!0}),i(wl)!=="svelte-1xi8u2o"&&(wl.textContent=It),ke=M(l),m(jl.$$.fragment,l),ge=M(l),Ul=p(l,"P",{"data-svelte-h":!0}),i(Ul)!=="svelte-1qq9kbx"&&(Ul.innerHTML=_t),Ne=M(l),fl=p(l,"P",{"data-svelte-h":!0}),i(fl)!=="svelte-1e6fo38"&&(fl.innerHTML=Zt),Be=M(l),m(Cl.$$.fragment,l),We=M(l),ul=p(l,"P",{"data-svelte-h":!0}),i(ul)!=="svelte-xah23j"&&(ul.innerHTML=ht),Re=M(l),m(bl.$$.fragment,l),ve=M(l),Il=p(l,"P",{"data-svelte-h":!0}),i(Il)!=="svelte-1dvm79h"&&(Il.innerHTML=At),Xe=M(l),m(_l.$$.fragment,l),Ge=M(l),Zl=p(l,"P",{"data-svelte-h":!0}),i(Zl)!=="svelte-8xcaeg"&&(Zl.textContent=$t),Ve=M(l),m(hl.$$.fragment,l),Ye=M(l),Al=p(l,"P",{"data-svelte-h":!0}),i(Al)!=="svelte-1y2zt0l"&&(Al.textContent=kt),xe=M(l),$l=p(l,"P",{"data-svelte-h":!0}),i($l)!=="svelte-l7gnnd"&&($l.innerHTML=gt),Qe=M(l),m(kl.$$.fragment,l),ze=M(l),gl=p(l,"P",{"data-svelte-h":!0}),i(gl)!=="svelte-zrvvjw"&&(gl.innerHTML=Nt),Ee=M(l),Bl=p(l,"P",{}),vt(Bl).forEach(t),this.h()},h(){Xt(y,"name","hf:doc:metadata"),Xt(y,"content",St)},m(l,e){zt(document.head,y),s(l,j,e),s(l,d,e),s(l,U,e),J(I,l,e),s(l,Wl,e),s(l,_,e),s(l,Rl,e),s(l,Z,e),s(l,vl,e),s(l,h,e),s(l,Xl,e),J(A,l,e),s(l,Gl,e),s(l,$,e),s(l,Vl,e),s(l,k,e),s(l,Yl,e),J(g,l,e),s(l,xl,e),s(l,N,e),s(l,Ql,e),s(l,B,e),s(l,zl,e),s(l,W,e),s(l,El,e),s(l,R,e),s(l,Hl,e),s(l,v,e),s(l,Fl,e),J(X,l,e),s(l,Ll,e),s(l,G,e),s(l,Sl,e),J(V,l,e),s(l,Pl,e),s(l,Y,e),s(l,ql,e),J(x,l,e),s(l,Dl,e),s(l,Q,e),s(l,Kl,e),s(l,z,e),s(l,Ol,e),J(E,l,e),s(l,le,e),s(l,H,e),s(l,ee,e),J(F,l,e),s(l,te,e),s(l,L,e),s(l,se,e),J(C,l,e),s(l,ne,e),s(l,S,e),s(l,Me,e),s(l,P,e),s(l,ae,e),J(q,l,e),s(l,pe,e),s(l,D,e),s(l,ie,e),s(l,K,e),s(l,ye,e),J(O,l,e),s(l,oe,e),s(l,ll,e),s(l,me,e),J(el,l,e),s(l,Je,e),J(u,l,e),s(l,re,e),s(l,tl,e),s(l,Te,e),J(sl,l,e),s(l,ce,e),s(l,nl,e),s(l,de,e),J(b,l,e),s(l,we,e),s(l,Ml,e),s(l,je,e),s(l,al,e),s(l,Ue,e),J(pl,l,e),s(l,fe,e),s(l,il,e),s(l,Ce,e),J(yl,l,e),s(l,ue,e),s(l,ol,e),s(l,be,e),s(l,ml,e),s(l,Ie,e),J(Jl,l,e),s(l,_e,e),s(l,rl,e),s(l,Ze,e),J(Tl,l,e),s(l,he,e),s(l,cl,e),s(l,Ae,e),J(dl,l,e),s(l,$e,e),s(l,wl,e),s(l,ke,e),J(jl,l,e),s(l,ge,e),s(l,Ul,e),s(l,Ne,e),s(l,fl,e),s(l,Be,e),J(Cl,l,e),s(l,We,e),s(l,ul,e),s(l,Re,e),J(bl,l,e),s(l,ve,e),s(l,Il,e),s(l,Xe,e),J(_l,l,e),s(l,Ge,e),s(l,Zl,e),s(l,Ve,e),J(hl,l,e),s(l,Ye,e),s(l,Al,e),s(l,xe,e),s(l,$l,e),s(l,Qe,e),J(kl,l,e),s(l,ze,e),s(l,gl,e),s(l,Ee,e),s(l,Bl,e),He=!0},p(l,[e]){const Bt={};e&2&&(Bt.$$scope={dirty:e,ctx:l}),C.$set(Bt);const Wt={};e&2&&(Wt.$$scope={dirty:e,ctx:l}),u.$set(Wt);const Rt={};e&2&&(Rt.$$scope={dirty:e,ctx:l}),b.$set(Rt)},i(l){He||(r(I.$$.fragment,l),r(A.$$.fragment,l),r(g.$$.fragment,l),r(X.$$.fragment,l),r(V.$$.fragment,l),r(x.$$.fragment,l),r(E.$$.fragment,l),r(F.$$.fragment,l),r(C.$$.fragment,l),r(q.$$.fragment,l),r(O.$$.fragment,l),r(el.$$.fragment,l),r(u.$$.fragment,l),r(sl.$$.fragment,l),r(b.$$.fragment,l),r(pl.$$.fragment,l),r(yl.$$.fragment,l),r(Jl.$$.fragment,l),r(Tl.$$.fragment,l),r(dl.$$.fragment,l),r(jl.$$.fragment,l),r(Cl.$$.fragment,l),r(bl.$$.fragment,l),r(_l.$$.fragment,l),r(hl.$$.fragment,l),r(kl.$$.fragment,l),He=!0)},o(l){T(I.$$.fragment,l),T(A.$$.fragment,l),T(g.$$.fragment,l),T(X.$$.fragment,l),T(V.$$.fragment,l),T(x.$$.fragment,l),T(E.$$.fragment,l),T(F.$$.fragment,l),T(C.$$.fragment,l),T(q.$$.fragment,l),T(O.$$.fragment,l),T(el.$$.fragment,l),T(u.$$.fragment,l),T(sl.$$.fragment,l),T(b.$$.fragment,l),T(pl.$$.fragment,l),T(yl.$$.fragment,l),T(Jl.$$.fragment,l),T(Tl.$$.fragment,l),T(dl.$$.fragment,l),T(jl.$$.fragment,l),T(Cl.$$.fragment,l),T(bl.$$.fragment,l),T(_l.$$.fragment,l),T(hl.$$.fragment,l),T(kl.$$.fragment,l),He=!1},d(l){l&&(t(j),t(d),t(U),t(Wl),t(_),t(Rl),t(Z),t(vl),t(h),t(Xl),t(Gl),t($),t(Vl),t(k),t(Yl),t(xl),t(N),t(Ql),t(B),t(zl),t(W),t(El),t(R),t(Hl),t(v),t(Fl),t(Ll),t(G),t(Sl),t(Pl),t(Y),t(ql),t(Dl),t(Q),t(Kl),t(z),t(Ol),t(le),t(H),t(ee),t(te),t(L),t(se),t(ne),t(S),t(Me),t(P),t(ae),t(pe),t(D),t(ie),t(K),t(ye),t(oe),t(ll),t(me),t(Je),t(re),t(tl),t(Te),t(ce),t(nl),t(de),t(we),t(Ml),t(je),t(al),t(Ue),t(fe),t(il),t(Ce),t(ue),t(ol),t(be),t(ml),t(Ie),t(_e),t(rl),t(Ze),t(he),t(cl),t(Ae),t($e),t(wl),t(ke),t(ge),t(Ul),t(Ne),t(fl),t(Be),t(We),t(ul),t(Re),t(ve),t(Il),t(Xe),t(Ge),t(Zl),t(Ve),t(Ye),t(Al),t(xe),t($l),t(Qe),t(ze),t(gl),t(Ee),t(Bl)),t(y),c(I,l),c(A,l),c(g,l),c(X,l),c(V,l),c(x,l),c(E,l),c(F,l),c(C,l),c(q,l),c(O,l),c(el,l),c(u,l),c(sl,l),c(b,l),c(pl,l),c(yl,l),c(Jl,l),c(Tl,l),c(dl,l),c(jl,l),c(Cl,l),c(bl,l),c(_l,l),c(hl,l),c(kl,l)}}}const St='{"title":"共享自定义模型","local":"共享自定义模型","sections":[{"title":"编写自定义配置","local":"编写自定义配置","sections":[],"depth":2},{"title":"编写自定义模型","local":"编写自定义模型","sections":[],"depth":2},{"title":"将代码发送到 Hub","local":"将代码发送到-hub","sections":[],"depth":2},{"title":"使用带有自定义代码的模型","local":"使用带有自定义代码的模型","sections":[],"depth":2},{"title":"将自定义代码的模型注册到自动类","local":"将自定义代码的模型注册到自动类","sections":[],"depth":2}],"depth":1}';function Pt(f){return Vt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class es extends Yt{constructor(y){super(),xt(this,y,Pt,Lt,Gt,{})}}export{es as component};
