import{s as Ta,o as xa,n as S}from"../chunks/scheduler.9bc65507.js";import{S as Aa,i as Ma,g as i,s as n,r as c,A as ka,h as m,f as o,c as r,j as T,u as g,x as b,k as x,y as t,a as d,v as f,d as u,t as h,w as $}from"../chunks/index.24549926.js";import{T as Jr}from"../chunks/Tip.2b78d0ae.js";import{D as A}from"../chunks/Docstring.faf778e5.js";import{C as Pt}from"../chunks/CodeBlock.6ca813ee.js";import{E as Jt}from"../chunks/ExampleCodeBlock.e4699344.js";import{H}from"../chunks/Heading.cc20227a.js";function Ia(k){let l,w="Transformers Agents是一个实验性的API，它随时可能发生变化。由于API或底层模型容易发生变化，因此由agents返回的结果可能会有所不同。";return{c(){l=i("p"),l.textContent=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-1uf8w5a"&&(l.textContent=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function Ca(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ha(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTG9jYWxBZ2VudCUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJiaWdjb2RlJTJGc3RhcmNvZGVyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudChtb2RlbCUyQyUyMHRva2VuaXplciklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LocalAgent

checkpoint = <span class="hljs-string">&quot;bigcode/starcoder&quot;</span>
model = AutoModelForCausalLM.from_pretrained(checkpoint, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

agent = LocalAgent(model, tokenizer)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function La(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwTG9jYWxBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LocalAgent

agent = LocalAgent.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ja(k){let l,w=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-3idp4e"&&(l.innerHTML=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function Pa(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BaUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBPcGVuQWlBZ2VudChtb2RlbCUzRCUyMnRleHQtZGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4KSUwQWFnZW50LnJ1biglMjJJcyUyMHRoZSUyMGZvbGxvd2luZyUyMCU2MHRleHQlNjAlMjAoaW4lMjBTcGFuaXNoKSUyMHBvc2l0aXZlJTIwb3IlMjBuZWdhdGl2ZSUzRiUyMiUyQyUyMHRleHQlM0QlMjIlQzIlQTFFc3RlJTIwZXMlMjB1biUyMEFQSSUyMG11eSUyMGFncmFkYWJsZSElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAiAgent

agent = OpenAiAgent(model=<span class="hljs-string">&quot;text-davinci-003&quot;</span>, api_key=xxx)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ua(k){let l,w=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){l=i("p"),l.innerHTML=w},l(_){l=m(_,"P",{"data-svelte-h":!0}),b(l)!=="svelte-3idp4e"&&(l.innerHTML=w)},m(_,p){d(_,l,p)},p:S,d(_){_&&o(l)}}}function ja(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF6dXJlT3BlbkFpQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEF6dXJlQWlBZ2VudChkZXBsb3ltZW50X2lkJTNEJTIyRGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4JTJDJTIwcmVzb3VyY2VfbmFtZSUzRHl5eSklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AzureOpenAiAgent

agent = AzureAiAgent(deployment_id=<span class="hljs-string">&quot;Davinci-003&quot;</span>, api_key=xxx, resource_name=yyy)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function qa(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5jaGF0KCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMiklMEElMEFhZ2VudC5jaGF0KCUyMlRyYW5zZm9ybSUyMHRoZSUyMHBpY3R1cmUlMjBzbyUyMHRoYXQlMjB0aGVyZSUyMGlzJTIwYSUyMHJvY2slMjBpbiUyMHRoZXJlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.chat(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)

agent.chat(<span class="hljs-string">&quot;Transform the picture so that there is a rock in there&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Ea(k){let l,w="Example:",_,p,v;return p=new Pt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=w,_=n(),c(p.$$.fragment)},l(a){l=m(a,"P",{"data-svelte-h":!0}),b(l)!=="svelte-11lpom8"&&(l.textContent=w),_=r(a),g(p.$$.fragment,a)},m(a,y){d(a,l,y),d(a,_,y),f(p,a,y),v=!0},p:S,i(a){v||(u(p.$$.fragment,a),v=!0)},o(a){h(p.$$.fragment,a),v=!1},d(a){a&&(o(l),o(_)),$(p,a)}}}function Za(k){let l,w,_,p,v,a,y,yo,He,Pr='要了解更多关于agents和工具的信息，请确保阅读<a href="../transformers_agents">介绍指南</a>。此页面包含底层类的API文档。',wo,Le,To,Je,Ur='我们提供三种类型的agents：<a href="/docs/transformers/main/zh/main_classes/agent#transformers.HfAgent">HfAgent</a>使用开源模型的推理端点，<a href="/docs/transformers/main/zh/main_classes/agent#transformers.LocalAgent">LocalAgent</a>使用您在本地选择的模型，<a href="/docs/transformers/main/zh/main_classes/agent#transformers.OpenAiAgent">OpenAiAgent</a>使用OpenAI封闭模型。',xo,Pe,Ao,R,Ue,vn,Ut,jr="Agent that uses an inference endpoint to generate code.",yn,ne,Mo,je,ko,P,qe,wn,jt,qr="Agent that uses a local model and tokenizer to generate code.",Tn,re,xn,D,Ee,An,qt,Er="Convenience method to build a <code>LocalAgent</code> from a pretrained checkpoint.",Mn,ae,Io,Ze,Co,U,ze,kn,Et,Zr="Agent that uses the openai API to generate code.",In,se,Cn,le,Ho,We,Lo,j,Re,Hn,Zt,zr=`Agent that uses Azure OpenAI to generate code. See the <a href="https://learn.microsoft.com/en-us/azure/cognitive-services/openai/" rel="nofollow">official
documentation</a> to learn how to deploy an openAI
model on Azure`,Ln,ie,Jn,me,Jo,Ge,Po,L,Ve,Pn,zt,Wr="Base class for all agents which contains the main API methods.",Un,B,Ne,jn,Wt,Rr="Sends a new request to the agent in a chat. Will use the previous ones in its history.",qn,de,En,Y,De,Zn,Rt,Gr="Sends a request to the agent.",zn,pe,Wn,ce,Be,Rn,Gt,Vr='Clears the history of prior calls to <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Agent.chat">chat()</a>.',Uo,Ye,jo,Fe,qo,Q,Se,Gn,Vt,Nr="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",Eo,Qe,Zo,M,Xe,Vn,Nt,Dr=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,Nn,Dt,Br=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>List[str]</code>) — The list of modalities expected for the inputs (in the same order as in the call).
Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code> or to make a
nice space from your tool.</li> <li><strong>outputs</strong> (<code>List[str]</code>) — The list of modalities returned but the tool (in the same order as the return of the
call method). Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code>
or to make a nice space from your tool.</li>`,Dn,Bt,Yr=`You can also override the method <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,Bn,ge,Oe,Yn,Yt,Fr='Creates a <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',Fn,fe,Ke,Sn,Ft,Sr="Loads a tool defined on the Hub.",Qn,ue,et,Xn,St,Qr="Upload the tool to the Hub.",On,W,tt,Kn,Qt,Xr=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,er,Xt,Or=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,tr,Ot,Kr="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",or,he,ot,nr,Kt,ea=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,zo,nt,Wo,I,rt,rr,eo,ta=`A <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,ar,to,oa=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <code>AutoProcessor</code>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <code>AutoProcessor</code>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,sr,$e,at,lr,oo,na="Uses the <code>post_processor</code> to decode the model output.",ir,_e,st,mr,no,ra="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",dr,be,lt,pr,ro,aa="Sends the inputs through the <code>model</code>.",cr,ve,it,gr,ao,sa="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",Ro,mt,Go,q,dt,fr,so,la='A <a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a> that will make requests to an inference endpoint.',ur,ye,pt,hr,lo,ia=`You can override this method in your custom class of <a href="/docs/transformers/main/zh/main_classes/agent#transformers.RemoteTool">RemoteTool</a> to apply some custom post-processing of the
outputs of the endpoint.`,$r,F,ct,_r,io,ma=`Prepare the inputs received for the HTTP client sending data to the endpoint. Positional arguments will be
matched with the signature of the <code>tool_class</code> if it was provided at instantation. Images will be encoded into
bytes.`,br,mo,da='You can override this method in your custom class of <a href="/docs/transformers/main/zh/main_classes/agent#transformers.RemoteTool">RemoteTool</a>.',Vo,gt,No,X,ft,vr,po,pa=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>outputs</code>.`,Do,ut,Bo,ht,ca="Agents可以处理工具之间任何类型的对象；工具是多模态的，可以接受和返回文本、图像、音频、视频等类型。为了增加工具之间的兼容性，以及正确地在ipython（jupyter、colab、ipython notebooks等）中呈现这些返回值，我们实现了这些类型的包装类。",Yo,$t,ga="被包装的对象应该继续按照最初的行为方式运作；文本对象应该仍然像字符串一样运作，图像对象应该仍然像<code>PIL.Image</code>一样运作。",Fo,_t,fa="这些类型有三个特定目的：",So,bt,ua="<li>对类型调用 <code>to_raw</code> 应该返回底层对象</li> <li>对类型调用 <code>to_string</code> 应该将对象作为字符串返回：在<code>AgentText</code>的情况下可能是字符串，但在其他情况下可能是对象序列化版本的路径</li> <li>在ipython内核中显示它应该正确显示对象</li>",Qo,vt,Xo,O,yt,yr,co,ha="Text type returned by the agent. Behaves as a string.",Oo,wt,Ko,E,Tt,wr,go,$a="Image type returned by the agent. Behaves as a PIL.Image.",Tr,we,xt,xr,fo,_a="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",Ar,Te,At,Mr,uo,ba=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,en,Mt,tn,Z,kt,kr,ho,va="Audio type returned by the agent.",Ir,xe,It,Cr,$o,ya="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Hr,Ae,Ct,Lr,_o,wa=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,on,vo,nn;return v=new H({props:{title:"Agents和工具",local:"agents和工具",headingTag:"h1"}}),y=new Jr({props:{warning:!0,$$slots:{default:[Ia]},$$scope:{ctx:k}}}),Le=new H({props:{title:"Agents",local:"agents",headingTag:"h2"}}),Pe=new H({props:{title:"HfAgent",local:"transformers.HfAgent",headingTag:"h3"}}),Ue=new A({props:{name:"class transformers.HfAgent",anchor:"transformers.HfAgent",parameters:[{name:"url_endpoint",val:""},{name:"token",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.HfAgent.url_endpoint",description:`<strong>url_endpoint</strong> (<code>str</code>) &#x2014;
The name of the url endpoint to use.`,name:"url_endpoint"},{anchor:"transformers.HfAgent.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.HfAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.HfAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.HfAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L588"}}),ne=new Jt({props:{anchor:"transformers.HfAgent.example",$$slots:{default:[Ca]},$$scope:{ctx:k}}}),je=new H({props:{title:"LocalAgent",local:"transformers.LocalAgent",headingTag:"h3"}}),qe=new A({props:{name:"class transformers.LocalAgent",anchor:"transformers.LocalAgent",parameters:[{name:"model",val:""},{name:"tokenizer",val:""},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.LocalAgent.model",description:`<strong>model</strong> (<a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>) &#x2014;
The model to use for the agent.`,name:"model"},{anchor:"transformers.LocalAgent.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/zh/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for the agent.`,name:"tokenizer"},{anchor:"transformers.LocalAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.LocalAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.LocalAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L659"}}),re=new Jt({props:{anchor:"transformers.LocalAgent.example",$$slots:{default:[Ha]},$$scope:{ctx:k}}}),Ee=new A({props:{name:"from_pretrained",anchor:"transformers.LocalAgent.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LocalAgent.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of a repo on the Hub or a local path to a folder containing both model and tokenizer.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.LocalAgent.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments passed along to <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L704"}}),ae=new Jt({props:{anchor:"transformers.LocalAgent.from_pretrained.example",$$slots:{default:[La]},$$scope:{ctx:k}}}),Ze=new H({props:{title:"OpenAiAgent",local:"transformers.OpenAiAgent",headingTag:"h3"}}),ze=new A({props:{name:"class transformers.OpenAiAgent",anchor:"transformers.OpenAiAgent",parameters:[{name:"model",val:" = 'text-davinci-003'"},{name:"api_key",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.OpenAiAgent.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text-davinci-003&quot;</code>) &#x2014;
The name of the OpenAI model to use.`,name:"model"},{anchor:"transformers.OpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.OpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.OpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.OpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L364"}}),se=new Jr({props:{warning:!0,$$slots:{default:[Ja]},$$scope:{ctx:k}}}),le=new Jt({props:{anchor:"transformers.OpenAiAgent.example",$$slots:{default:[Pa]},$$scope:{ctx:k}}}),We=new H({props:{title:"AzureOpenAiAgent",local:"transformers.AzureOpenAiAgent",headingTag:"h3"}}),Re=new A({props:{name:"class transformers.AzureOpenAiAgent",anchor:"transformers.AzureOpenAiAgent",parameters:[{name:"deployment_id",val:""},{name:"api_key",val:" = None"},{name:"resource_name",val:" = None"},{name:"api_version",val:" = '2022-12-01'"},{name:"is_chat_model",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.AzureOpenAiAgent.deployment_id",description:`<strong>deployment_id</strong> (<code>str</code>) &#x2014;
The name of the deployed Azure openAI model to use.`,name:"deployment_id"},{anchor:"transformers.AzureOpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;AZURE_OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.AzureOpenAiAgent.resource_name",description:`<strong>resource_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of your Azure OpenAI Resource. If unset, will look for the environment variable
<code>&quot;AZURE_OPENAI_RESOURCE_NAME&quot;</code>.`,name:"resource_name"},{anchor:"transformers.AzureOpenAiAgent.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;2022-12-01&quot;</code>) &#x2014;
The API version to use for this agent.`,name:"api_version"},{anchor:"transformers.AzureOpenAiAgent.is_chat_mode",description:`<strong>is_chat_mode</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether you are using a completion model or a chat model (see note above, chat models won&#x2019;t be as
efficient). Will default to <code>gpt</code> being in the <code>deployment_id</code> or not.`,name:"is_chat_mode"},{anchor:"transformers.AzureOpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L462"}}),ie=new Jr({props:{warning:!0,$$slots:{default:[Ua]},$$scope:{ctx:k}}}),me=new Jt({props:{anchor:"transformers.AzureOpenAiAgent.example",$$slots:{default:[ja]},$$scope:{ctx:k}}}),Ge=new H({props:{title:"Agent",local:"transformers.Agent",headingTag:"h3"}}),Ve=new A({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.Agent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.Agent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.Agent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/main/zh/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L196"}}),Ne=new A({props:{name:"chat",anchor:"transformers.Agent.chat",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.chat.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.chat.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.chat.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.chat.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L268"}}),de=new Jt({props:{anchor:"transformers.Agent.chat.example",$$slots:{default:[qa]},$$scope:{ctx:k}}}),De=new A({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.run.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.run.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L318"}}),pe=new Jt({props:{anchor:"transformers.Agent.run.example",$$slots:{default:[Ea]},$$scope:{ctx:k}}}),Be=new A({props:{name:"prepare_for_new_chat",anchor:"transformers.Agent.prepare_for_new_chat",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agents.py#L310"}}),Ye=new H({props:{title:"工具",local:"工具",headingTag:"h2"}}),Fe=new H({props:{title:"load_tool",local:"transformers.load_tool",headingTag:"h3"}}),Se=new A({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"remote",val:" = False"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document-question-answering&quot;</code></li>
<li><code>&quot;image-captioning&quot;</code></li>
<li><code>&quot;image-question-answering&quot;</code></li>
<li><code>&quot;image-segmentation&quot;</code></li>
<li><code>&quot;speech-to-text&quot;</code></li>
<li><code>&quot;summarization&quot;</code></li>
<li><code>&quot;text-classification&quot;</code></li>
<li><code>&quot;text-question-answering&quot;</code></li>
<li><code>&quot;text-to-speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L643"}}),Qe=new H({props:{title:"Tool",local:"transformers.Tool",headingTag:"h3"}}),Xe=new A({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L81"}}),Oe=new A({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L330"}}),Ke=new A({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"remote",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L176"}}),et=new A({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L286"}}),tt=new A({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L122"}}),ot=new A({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L115"}}),nt=new H({props:{title:"PipelineTool",local:"transformers.PipelineTool",headingTag:"h3"}}),rt=new A({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/main/zh/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L433"}}),at=new A({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L552"}}),st=new A({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L539"}}),lt=new A({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L545"}}),it=new A({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L513"}}),mt=new H({props:{title:"RemoteTool",local:"transformers.RemoteTool",headingTag:"h3"}}),dt=new A({props:{name:"class transformers.RemoteTool",anchor:"transformers.RemoteTool",parameters:[{name:"endpoint_url",val:" = None"},{name:"token",val:" = None"},{name:"tool_class",val:" = None"}],parametersDescription:[{anchor:"transformers.RemoteTool.endpoint_url",description:`<strong>endpoint_url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The url of the endpoint to use.`,name:"endpoint_url"},{anchor:"transformers.RemoteTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.RemoteTool.tool_class",description:`<strong>tool_class</strong> (<code>type</code>, <em>optional</em>) &#x2014;
The corresponding <code>tool_class</code> if this is a remote version of an existing tool. Will help determine when
the output should be converted to another type (like images).`,name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L346"}}),pt=new A({props:{name:"extract_outputs",anchor:"transformers.RemoteTool.extract_outputs",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L409"}}),ct=new A({props:{name:"prepare_inputs",anchor:"transformers.RemoteTool.prepare_inputs",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L366"}}),gt=new H({props:{title:"launch_gradio_demo",local:"transformers.launch_gradio_demo",headingTag:"h3"}}),ft=new A({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/base.py#L573"}}),ut=new H({props:{title:"Agent类型",local:"agent类型",headingTag:"h2"}}),vt=new H({props:{title:"AgentText",local:"transformers.tools.agent_types.AgentText",headingTag:"h3"}}),yt=new A({props:{name:"class transformers.tools.agent_types.AgentText",anchor:"transformers.tools.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L71"}}),wt=new H({props:{title:"AgentImage",local:"transformers.tools.agent_types.AgentImage",headingTag:"h3"}}),Tt=new A({props:{name:"class transformers.tools.agent_types.AgentImage",anchor:"transformers.tools.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L83"}}),xt=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L115"}}),At=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L126"}}),Mt=new H({props:{title:"AgentAudio",local:"transformers.tools.agent_types.AgentAudio",headingTag:"h3"}}),kt=new A({props:{name:"class transformers.tools.agent_types.AgentAudio",anchor:"transformers.tools.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L155"}}),It=new A({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L186"}}),Ct=new A({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/tools/agent_types.py#L198"}}),{c(){l=i("meta"),w=n(),_=i("p"),p=n(),c(v.$$.fragment),a=n(),c(y.$$.fragment),yo=n(),He=i("p"),He.innerHTML=Pr,wo=n(),c(Le.$$.fragment),To=n(),Je=i("p"),Je.innerHTML=Ur,xo=n(),c(Pe.$$.fragment),Ao=n(),R=i("div"),c(Ue.$$.fragment),vn=n(),Ut=i("p"),Ut.textContent=jr,yn=n(),c(ne.$$.fragment),Mo=n(),c(je.$$.fragment),ko=n(),P=i("div"),c(qe.$$.fragment),wn=n(),jt=i("p"),jt.textContent=qr,Tn=n(),c(re.$$.fragment),xn=n(),D=i("div"),c(Ee.$$.fragment),An=n(),qt=i("p"),qt.innerHTML=Er,Mn=n(),c(ae.$$.fragment),Io=n(),c(Ze.$$.fragment),Co=n(),U=i("div"),c(ze.$$.fragment),kn=n(),Et=i("p"),Et.textContent=Zr,In=n(),c(se.$$.fragment),Cn=n(),c(le.$$.fragment),Ho=n(),c(We.$$.fragment),Lo=n(),j=i("div"),c(Re.$$.fragment),Hn=n(),Zt=i("p"),Zt.innerHTML=zr,Ln=n(),c(ie.$$.fragment),Jn=n(),c(me.$$.fragment),Jo=n(),c(Ge.$$.fragment),Po=n(),L=i("div"),c(Ve.$$.fragment),Pn=n(),zt=i("p"),zt.textContent=Wr,Un=n(),B=i("div"),c(Ne.$$.fragment),jn=n(),Wt=i("p"),Wt.textContent=Rr,qn=n(),c(de.$$.fragment),En=n(),Y=i("div"),c(De.$$.fragment),Zn=n(),Rt=i("p"),Rt.textContent=Gr,zn=n(),c(pe.$$.fragment),Wn=n(),ce=i("div"),c(Be.$$.fragment),Rn=n(),Gt=i("p"),Gt.innerHTML=Vr,Uo=n(),c(Ye.$$.fragment),jo=n(),c(Fe.$$.fragment),qo=n(),Q=i("div"),c(Se.$$.fragment),Gn=n(),Vt=i("p"),Vt.textContent=Nr,Eo=n(),c(Qe.$$.fragment),Zo=n(),M=i("div"),c(Xe.$$.fragment),Vn=n(),Nt=i("p"),Nt.innerHTML=Dr,Nn=n(),Dt=i("ul"),Dt.innerHTML=Br,Dn=n(),Bt=i("p"),Bt.innerHTML=Yr,Bn=n(),ge=i("div"),c(Oe.$$.fragment),Yn=n(),Yt=i("p"),Yt.innerHTML=Fr,Fn=n(),fe=i("div"),c(Ke.$$.fragment),Sn=n(),Ft=i("p"),Ft.textContent=Sr,Qn=n(),ue=i("div"),c(et.$$.fragment),Xn=n(),St=i("p"),St.textContent=Qr,On=n(),W=i("div"),c(tt.$$.fragment),Kn=n(),Qt=i("p"),Qt.innerHTML=Xr,er=n(),Xt=i("ul"),Xt.innerHTML=Or,tr=n(),Ot=i("p"),Ot.innerHTML=Kr,or=n(),he=i("div"),c(ot.$$.fragment),nr=n(),Kt=i("p"),Kt.textContent=ea,zo=n(),c(nt.$$.fragment),Wo=n(),I=i("div"),c(rt.$$.fragment),rr=n(),eo=i("p"),eo.innerHTML=ta,ar=n(),to=i("ul"),to.innerHTML=oa,sr=n(),$e=i("div"),c(at.$$.fragment),lr=n(),oo=i("p"),oo.innerHTML=na,ir=n(),_e=i("div"),c(st.$$.fragment),mr=n(),no=i("p"),no.innerHTML=ra,dr=n(),be=i("div"),c(lt.$$.fragment),pr=n(),ro=i("p"),ro.innerHTML=aa,cr=n(),ve=i("div"),c(it.$$.fragment),gr=n(),ao=i("p"),ao.innerHTML=sa,Ro=n(),c(mt.$$.fragment),Go=n(),q=i("div"),c(dt.$$.fragment),fr=n(),so=i("p"),so.innerHTML=la,ur=n(),ye=i("div"),c(pt.$$.fragment),hr=n(),lo=i("p"),lo.innerHTML=ia,$r=n(),F=i("div"),c(ct.$$.fragment),_r=n(),io=i("p"),io.innerHTML=ma,br=n(),mo=i("p"),mo.innerHTML=da,Vo=n(),c(gt.$$.fragment),No=n(),X=i("div"),c(ft.$$.fragment),vr=n(),po=i("p"),po.innerHTML=pa,Do=n(),c(ut.$$.fragment),Bo=n(),ht=i("p"),ht.textContent=ca,Yo=n(),$t=i("p"),$t.innerHTML=ga,Fo=n(),_t=i("p"),_t.textContent=fa,So=n(),bt=i("ul"),bt.innerHTML=ua,Qo=n(),c(vt.$$.fragment),Xo=n(),O=i("div"),c(yt.$$.fragment),yr=n(),co=i("p"),co.textContent=ha,Oo=n(),c(wt.$$.fragment),Ko=n(),E=i("div"),c(Tt.$$.fragment),wr=n(),go=i("p"),go.textContent=$a,Tr=n(),we=i("div"),c(xt.$$.fragment),xr=n(),fo=i("p"),fo.textContent=_a,Ar=n(),Te=i("div"),c(At.$$.fragment),Mr=n(),uo=i("p"),uo.textContent=ba,en=n(),c(Mt.$$.fragment),tn=n(),Z=i("div"),c(kt.$$.fragment),kr=n(),ho=i("p"),ho.textContent=va,Ir=n(),xe=i("div"),c(It.$$.fragment),Cr=n(),$o=i("p"),$o.innerHTML=ya,Hr=n(),Ae=i("div"),c(Ct.$$.fragment),Lr=n(),_o=i("p"),_o.textContent=wa,on=n(),vo=i("p"),this.h()},l(e){const s=ka("svelte-u9bgzb",document.head);l=m(s,"META",{name:!0,content:!0}),s.forEach(o),w=r(e),_=m(e,"P",{}),T(_).forEach(o),p=r(e),g(v.$$.fragment,e),a=r(e),g(y.$$.fragment,e),yo=r(e),He=m(e,"P",{"data-svelte-h":!0}),b(He)!=="svelte-170uv2v"&&(He.innerHTML=Pr),wo=r(e),g(Le.$$.fragment,e),To=r(e),Je=m(e,"P",{"data-svelte-h":!0}),b(Je)!=="svelte-fczon4"&&(Je.innerHTML=Ur),xo=r(e),g(Pe.$$.fragment,e),Ao=r(e),R=m(e,"DIV",{class:!0});var K=T(R);g(Ue.$$.fragment,K),vn=r(K),Ut=m(K,"P",{"data-svelte-h":!0}),b(Ut)!=="svelte-1uej11q"&&(Ut.textContent=jr),yn=r(K),g(ne.$$.fragment,K),K.forEach(o),Mo=r(e),g(je.$$.fragment,e),ko=r(e),P=m(e,"DIV",{class:!0});var G=T(P);g(qe.$$.fragment,G),wn=r(G),jt=m(G,"P",{"data-svelte-h":!0}),b(jt)!=="svelte-1q3iegi"&&(jt.textContent=qr),Tn=r(G),g(re.$$.fragment,G),xn=r(G),D=m(G,"DIV",{class:!0});var ee=T(D);g(Ee.$$.fragment,ee),An=r(ee),qt=m(ee,"P",{"data-svelte-h":!0}),b(qt)!=="svelte-1qh3hl2"&&(qt.innerHTML=Er),Mn=r(ee),g(ae.$$.fragment,ee),ee.forEach(o),G.forEach(o),Io=r(e),g(Ze.$$.fragment,e),Co=r(e),U=m(e,"DIV",{class:!0});var V=T(U);g(ze.$$.fragment,V),kn=r(V),Et=m(V,"P",{"data-svelte-h":!0}),b(Et)!=="svelte-182hy5g"&&(Et.textContent=Zr),In=r(V),g(se.$$.fragment,V),Cn=r(V),g(le.$$.fragment,V),V.forEach(o),Ho=r(e),g(We.$$.fragment,e),Lo=r(e),j=m(e,"DIV",{class:!0});var N=T(j);g(Re.$$.fragment,N),Hn=r(N),Zt=m(N,"P",{"data-svelte-h":!0}),b(Zt)!=="svelte-1eoncpw"&&(Zt.innerHTML=zr),Ln=r(N),g(ie.$$.fragment,N),Jn=r(N),g(me.$$.fragment,N),N.forEach(o),Jo=r(e),g(Ge.$$.fragment,e),Po=r(e),L=m(e,"DIV",{class:!0});var z=T(L);g(Ve.$$.fragment,z),Pn=r(z),zt=m(z,"P",{"data-svelte-h":!0}),b(zt)!=="svelte-1phtukb"&&(zt.textContent=Wr),Un=r(z),B=m(z,"DIV",{class:!0});var te=T(B);g(Ne.$$.fragment,te),jn=r(te),Wt=m(te,"P",{"data-svelte-h":!0}),b(Wt)!=="svelte-1s1qxmr"&&(Wt.textContent=Rr),qn=r(te),g(de.$$.fragment,te),te.forEach(o),En=r(z),Y=m(z,"DIV",{class:!0});var oe=T(Y);g(De.$$.fragment,oe),Zn=r(oe),Rt=m(oe,"P",{"data-svelte-h":!0}),b(Rt)!=="svelte-1685qxi"&&(Rt.textContent=Gr),zn=r(oe),g(pe.$$.fragment,oe),oe.forEach(o),Wn=r(z),ce=m(z,"DIV",{class:!0});var Ht=T(ce);g(Be.$$.fragment,Ht),Rn=r(Ht),Gt=m(Ht,"P",{"data-svelte-h":!0}),b(Gt)!=="svelte-hgujkl"&&(Gt.innerHTML=Vr),Ht.forEach(o),z.forEach(o),Uo=r(e),g(Ye.$$.fragment,e),jo=r(e),g(Fe.$$.fragment,e),qo=r(e),Q=m(e,"DIV",{class:!0});var Lt=T(Q);g(Se.$$.fragment,Lt),Gn=r(Lt),Vt=m(Lt,"P",{"data-svelte-h":!0}),b(Vt)!=="svelte-16uh3p8"&&(Vt.textContent=Nr),Lt.forEach(o),Eo=r(e),g(Qe.$$.fragment,e),Zo=r(e),M=m(e,"DIV",{class:!0});var C=T(M);g(Xe.$$.fragment,C),Vn=r(C),Nt=m(C,"P",{"data-svelte-h":!0}),b(Nt)!=="svelte-cca4c5"&&(Nt.innerHTML=Dr),Nn=r(C),Dt=m(C,"UL",{"data-svelte-h":!0}),b(Dt)!=="svelte-1lb1si5"&&(Dt.innerHTML=Br),Dn=r(C),Bt=m(C,"P",{"data-svelte-h":!0}),b(Bt)!=="svelte-1qwxquy"&&(Bt.innerHTML=Yr),Bn=r(C),ge=m(C,"DIV",{class:!0});var rn=T(ge);g(Oe.$$.fragment,rn),Yn=r(rn),Yt=m(rn,"P",{"data-svelte-h":!0}),b(Yt)!=="svelte-ser18y"&&(Yt.innerHTML=Fr),rn.forEach(o),Fn=r(C),fe=m(C,"DIV",{class:!0});var an=T(fe);g(Ke.$$.fragment,an),Sn=r(an),Ft=m(an,"P",{"data-svelte-h":!0}),b(Ft)!=="svelte-yy7b2c"&&(Ft.textContent=Sr),an.forEach(o),Qn=r(C),ue=m(C,"DIV",{class:!0});var sn=T(ue);g(et.$$.fragment,sn),Xn=r(sn),St=m(sn,"P",{"data-svelte-h":!0}),b(St)!=="svelte-1u3gku9"&&(St.textContent=Qr),sn.forEach(o),On=r(C),W=m(C,"DIV",{class:!0});var Me=T(W);g(tt.$$.fragment,Me),Kn=r(Me),Qt=m(Me,"P",{"data-svelte-h":!0}),b(Qt)!=="svelte-19evuwa"&&(Qt.innerHTML=Xr),er=r(Me),Xt=m(Me,"UL",{"data-svelte-h":!0}),b(Xt)!=="svelte-15of9ze"&&(Xt.innerHTML=Or),tr=r(Me),Ot=m(Me,"P",{"data-svelte-h":!0}),b(Ot)!=="svelte-msa4ge"&&(Ot.innerHTML=Kr),Me.forEach(o),or=r(C),he=m(C,"DIV",{class:!0});var ln=T(he);g(ot.$$.fragment,ln),nr=r(ln),Kt=m(ln,"P",{"data-svelte-h":!0}),b(Kt)!=="svelte-63kthh"&&(Kt.textContent=ea),ln.forEach(o),C.forEach(o),zo=r(e),g(nt.$$.fragment,e),Wo=r(e),I=m(e,"DIV",{class:!0});var J=T(I);g(rt.$$.fragment,J),rr=r(J),eo=m(J,"P",{"data-svelte-h":!0}),b(eo)!=="svelte-44p28z"&&(eo.innerHTML=ta),ar=r(J),to=m(J,"UL",{"data-svelte-h":!0}),b(to)!=="svelte-1ccblfi"&&(to.innerHTML=oa),sr=r(J),$e=m(J,"DIV",{class:!0});var mn=T($e);g(at.$$.fragment,mn),lr=r(mn),oo=m(mn,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-zkjq4t"&&(oo.innerHTML=na),mn.forEach(o),ir=r(J),_e=m(J,"DIV",{class:!0});var dn=T(_e);g(st.$$.fragment,dn),mr=r(dn),no=m(dn,"P",{"data-svelte-h":!0}),b(no)!=="svelte-1vxzk80"&&(no.innerHTML=ra),dn.forEach(o),dr=r(J),be=m(J,"DIV",{class:!0});var pn=T(be);g(lt.$$.fragment,pn),pr=r(pn),ro=m(pn,"P",{"data-svelte-h":!0}),b(ro)!=="svelte-1qgsi13"&&(ro.innerHTML=aa),pn.forEach(o),cr=r(J),ve=m(J,"DIV",{class:!0});var cn=T(ve);g(it.$$.fragment,cn),gr=r(cn),ao=m(cn,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-1ojxz66"&&(ao.innerHTML=sa),cn.forEach(o),J.forEach(o),Ro=r(e),g(mt.$$.fragment,e),Go=r(e),q=m(e,"DIV",{class:!0});var ke=T(q);g(dt.$$.fragment,ke),fr=r(ke),so=m(ke,"P",{"data-svelte-h":!0}),b(so)!=="svelte-1t7m765"&&(so.innerHTML=la),ur=r(ke),ye=m(ke,"DIV",{class:!0});var gn=T(ye);g(pt.$$.fragment,gn),hr=r(gn),lo=m(gn,"P",{"data-svelte-h":!0}),b(lo)!=="svelte-1i2c2c2"&&(lo.innerHTML=ia),gn.forEach(o),$r=r(ke),F=m(ke,"DIV",{class:!0});var bo=T(F);g(ct.$$.fragment,bo),_r=r(bo),io=m(bo,"P",{"data-svelte-h":!0}),b(io)!=="svelte-14yhe1"&&(io.innerHTML=ma),br=r(bo),mo=m(bo,"P",{"data-svelte-h":!0}),b(mo)!=="svelte-86pqkx"&&(mo.innerHTML=da),bo.forEach(o),ke.forEach(o),Vo=r(e),g(gt.$$.fragment,e),No=r(e),X=m(e,"DIV",{class:!0});var fn=T(X);g(ft.$$.fragment,fn),vr=r(fn),po=m(fn,"P",{"data-svelte-h":!0}),b(po)!=="svelte-78dinl"&&(po.innerHTML=pa),fn.forEach(o),Do=r(e),g(ut.$$.fragment,e),Bo=r(e),ht=m(e,"P",{"data-svelte-h":!0}),b(ht)!=="svelte-15sqpbc"&&(ht.textContent=ca),Yo=r(e),$t=m(e,"P",{"data-svelte-h":!0}),b($t)!=="svelte-w6e0lu"&&($t.innerHTML=ga),Fo=r(e),_t=m(e,"P",{"data-svelte-h":!0}),b(_t)!=="svelte-1xz2jmd"&&(_t.textContent=fa),So=r(e),bt=m(e,"UL",{"data-svelte-h":!0}),b(bt)!=="svelte-u8cugp"&&(bt.innerHTML=ua),Qo=r(e),g(vt.$$.fragment,e),Xo=r(e),O=m(e,"DIV",{class:!0});var un=T(O);g(yt.$$.fragment,un),yr=r(un),co=m(un,"P",{"data-svelte-h":!0}),b(co)!=="svelte-57fhj7"&&(co.textContent=ha),un.forEach(o),Oo=r(e),g(wt.$$.fragment,e),Ko=r(e),E=m(e,"DIV",{class:!0});var Ie=T(E);g(Tt.$$.fragment,Ie),wr=r(Ie),go=m(Ie,"P",{"data-svelte-h":!0}),b(go)!=="svelte-1hsb0qs"&&(go.textContent=$a),Tr=r(Ie),we=m(Ie,"DIV",{class:!0});var hn=T(we);g(xt.$$.fragment,hn),xr=r(hn),fo=m(hn,"P",{"data-svelte-h":!0}),b(fo)!=="svelte-ybie7i"&&(fo.textContent=_a),hn.forEach(o),Ar=r(Ie),Te=m(Ie,"DIV",{class:!0});var $n=T(Te);g(At.$$.fragment,$n),Mr=r($n),uo=m($n,"P",{"data-svelte-h":!0}),b(uo)!=="svelte-chc6sp"&&(uo.textContent=ba),$n.forEach(o),Ie.forEach(o),en=r(e),g(Mt.$$.fragment,e),tn=r(e),Z=m(e,"DIV",{class:!0});var Ce=T(Z);g(kt.$$.fragment,Ce),kr=r(Ce),ho=m(Ce,"P",{"data-svelte-h":!0}),b(ho)!=="svelte-ckiqb6"&&(ho.textContent=va),Ir=r(Ce),xe=m(Ce,"DIV",{class:!0});var _n=T(xe);g(It.$$.fragment,_n),Cr=r(_n),$o=m(_n,"P",{"data-svelte-h":!0}),b($o)!=="svelte-10rnn1x"&&($o.innerHTML=ya),_n.forEach(o),Hr=r(Ce),Ae=m(Ce,"DIV",{class:!0});var bn=T(Ae);g(Ct.$$.fragment,bn),Lr=r(bn),_o=m(bn,"P",{"data-svelte-h":!0}),b(_o)!=="svelte-1xu9o93"&&(_o.textContent=wa),bn.forEach(o),Ce.forEach(o),on=r(e),vo=m(e,"P",{}),T(vo).forEach(o),this.h()},h(){x(l,"name","hf:doc:metadata"),x(l,"content",za),x(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){t(document.head,l),d(e,w,s),d(e,_,s),d(e,p,s),f(v,e,s),d(e,a,s),f(y,e,s),d(e,yo,s),d(e,He,s),d(e,wo,s),f(Le,e,s),d(e,To,s),d(e,Je,s),d(e,xo,s),f(Pe,e,s),d(e,Ao,s),d(e,R,s),f(Ue,R,null),t(R,vn),t(R,Ut),t(R,yn),f(ne,R,null),d(e,Mo,s),f(je,e,s),d(e,ko,s),d(e,P,s),f(qe,P,null),t(P,wn),t(P,jt),t(P,Tn),f(re,P,null),t(P,xn),t(P,D),f(Ee,D,null),t(D,An),t(D,qt),t(D,Mn),f(ae,D,null),d(e,Io,s),f(Ze,e,s),d(e,Co,s),d(e,U,s),f(ze,U,null),t(U,kn),t(U,Et),t(U,In),f(se,U,null),t(U,Cn),f(le,U,null),d(e,Ho,s),f(We,e,s),d(e,Lo,s),d(e,j,s),f(Re,j,null),t(j,Hn),t(j,Zt),t(j,Ln),f(ie,j,null),t(j,Jn),f(me,j,null),d(e,Jo,s),f(Ge,e,s),d(e,Po,s),d(e,L,s),f(Ve,L,null),t(L,Pn),t(L,zt),t(L,Un),t(L,B),f(Ne,B,null),t(B,jn),t(B,Wt),t(B,qn),f(de,B,null),t(L,En),t(L,Y),f(De,Y,null),t(Y,Zn),t(Y,Rt),t(Y,zn),f(pe,Y,null),t(L,Wn),t(L,ce),f(Be,ce,null),t(ce,Rn),t(ce,Gt),d(e,Uo,s),f(Ye,e,s),d(e,jo,s),f(Fe,e,s),d(e,qo,s),d(e,Q,s),f(Se,Q,null),t(Q,Gn),t(Q,Vt),d(e,Eo,s),f(Qe,e,s),d(e,Zo,s),d(e,M,s),f(Xe,M,null),t(M,Vn),t(M,Nt),t(M,Nn),t(M,Dt),t(M,Dn),t(M,Bt),t(M,Bn),t(M,ge),f(Oe,ge,null),t(ge,Yn),t(ge,Yt),t(M,Fn),t(M,fe),f(Ke,fe,null),t(fe,Sn),t(fe,Ft),t(M,Qn),t(M,ue),f(et,ue,null),t(ue,Xn),t(ue,St),t(M,On),t(M,W),f(tt,W,null),t(W,Kn),t(W,Qt),t(W,er),t(W,Xt),t(W,tr),t(W,Ot),t(M,or),t(M,he),f(ot,he,null),t(he,nr),t(he,Kt),d(e,zo,s),f(nt,e,s),d(e,Wo,s),d(e,I,s),f(rt,I,null),t(I,rr),t(I,eo),t(I,ar),t(I,to),t(I,sr),t(I,$e),f(at,$e,null),t($e,lr),t($e,oo),t(I,ir),t(I,_e),f(st,_e,null),t(_e,mr),t(_e,no),t(I,dr),t(I,be),f(lt,be,null),t(be,pr),t(be,ro),t(I,cr),t(I,ve),f(it,ve,null),t(ve,gr),t(ve,ao),d(e,Ro,s),f(mt,e,s),d(e,Go,s),d(e,q,s),f(dt,q,null),t(q,fr),t(q,so),t(q,ur),t(q,ye),f(pt,ye,null),t(ye,hr),t(ye,lo),t(q,$r),t(q,F),f(ct,F,null),t(F,_r),t(F,io),t(F,br),t(F,mo),d(e,Vo,s),f(gt,e,s),d(e,No,s),d(e,X,s),f(ft,X,null),t(X,vr),t(X,po),d(e,Do,s),f(ut,e,s),d(e,Bo,s),d(e,ht,s),d(e,Yo,s),d(e,$t,s),d(e,Fo,s),d(e,_t,s),d(e,So,s),d(e,bt,s),d(e,Qo,s),f(vt,e,s),d(e,Xo,s),d(e,O,s),f(yt,O,null),t(O,yr),t(O,co),d(e,Oo,s),f(wt,e,s),d(e,Ko,s),d(e,E,s),f(Tt,E,null),t(E,wr),t(E,go),t(E,Tr),t(E,we),f(xt,we,null),t(we,xr),t(we,fo),t(E,Ar),t(E,Te),f(At,Te,null),t(Te,Mr),t(Te,uo),d(e,en,s),f(Mt,e,s),d(e,tn,s),d(e,Z,s),f(kt,Z,null),t(Z,kr),t(Z,ho),t(Z,Ir),t(Z,xe),f(It,xe,null),t(xe,Cr),t(xe,$o),t(Z,Hr),t(Z,Ae),f(Ct,Ae,null),t(Ae,Lr),t(Ae,_o),d(e,on,s),d(e,vo,s),nn=!0},p(e,[s]){const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),y.$set(K);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),ne.$set(G);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),re.$set(ee);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),ae.$set(V);const N={};s&2&&(N.$$scope={dirty:s,ctx:e}),se.$set(N);const z={};s&2&&(z.$$scope={dirty:s,ctx:e}),le.$set(z);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),ie.$set(te);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),me.$set(oe);const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),de.$set(Ht);const Lt={};s&2&&(Lt.$$scope={dirty:s,ctx:e}),pe.$set(Lt)},i(e){nn||(u(v.$$.fragment,e),u(y.$$.fragment,e),u(Le.$$.fragment,e),u(Pe.$$.fragment,e),u(Ue.$$.fragment,e),u(ne.$$.fragment,e),u(je.$$.fragment,e),u(qe.$$.fragment,e),u(re.$$.fragment,e),u(Ee.$$.fragment,e),u(ae.$$.fragment,e),u(Ze.$$.fragment,e),u(ze.$$.fragment,e),u(se.$$.fragment,e),u(le.$$.fragment,e),u(We.$$.fragment,e),u(Re.$$.fragment,e),u(ie.$$.fragment,e),u(me.$$.fragment,e),u(Ge.$$.fragment,e),u(Ve.$$.fragment,e),u(Ne.$$.fragment,e),u(de.$$.fragment,e),u(De.$$.fragment,e),u(pe.$$.fragment,e),u(Be.$$.fragment,e),u(Ye.$$.fragment,e),u(Fe.$$.fragment,e),u(Se.$$.fragment,e),u(Qe.$$.fragment,e),u(Xe.$$.fragment,e),u(Oe.$$.fragment,e),u(Ke.$$.fragment,e),u(et.$$.fragment,e),u(tt.$$.fragment,e),u(ot.$$.fragment,e),u(nt.$$.fragment,e),u(rt.$$.fragment,e),u(at.$$.fragment,e),u(st.$$.fragment,e),u(lt.$$.fragment,e),u(it.$$.fragment,e),u(mt.$$.fragment,e),u(dt.$$.fragment,e),u(pt.$$.fragment,e),u(ct.$$.fragment,e),u(gt.$$.fragment,e),u(ft.$$.fragment,e),u(ut.$$.fragment,e),u(vt.$$.fragment,e),u(yt.$$.fragment,e),u(wt.$$.fragment,e),u(Tt.$$.fragment,e),u(xt.$$.fragment,e),u(At.$$.fragment,e),u(Mt.$$.fragment,e),u(kt.$$.fragment,e),u(It.$$.fragment,e),u(Ct.$$.fragment,e),nn=!0)},o(e){h(v.$$.fragment,e),h(y.$$.fragment,e),h(Le.$$.fragment,e),h(Pe.$$.fragment,e),h(Ue.$$.fragment,e),h(ne.$$.fragment,e),h(je.$$.fragment,e),h(qe.$$.fragment,e),h(re.$$.fragment,e),h(Ee.$$.fragment,e),h(ae.$$.fragment,e),h(Ze.$$.fragment,e),h(ze.$$.fragment,e),h(se.$$.fragment,e),h(le.$$.fragment,e),h(We.$$.fragment,e),h(Re.$$.fragment,e),h(ie.$$.fragment,e),h(me.$$.fragment,e),h(Ge.$$.fragment,e),h(Ve.$$.fragment,e),h(Ne.$$.fragment,e),h(de.$$.fragment,e),h(De.$$.fragment,e),h(pe.$$.fragment,e),h(Be.$$.fragment,e),h(Ye.$$.fragment,e),h(Fe.$$.fragment,e),h(Se.$$.fragment,e),h(Qe.$$.fragment,e),h(Xe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(rt.$$.fragment,e),h(at.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(mt.$$.fragment,e),h(dt.$$.fragment,e),h(pt.$$.fragment,e),h(ct.$$.fragment,e),h(gt.$$.fragment,e),h(ft.$$.fragment,e),h(ut.$$.fragment,e),h(vt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(xt.$$.fragment,e),h(At.$$.fragment,e),h(Mt.$$.fragment,e),h(kt.$$.fragment,e),h(It.$$.fragment,e),h(Ct.$$.fragment,e),nn=!1},d(e){e&&(o(w),o(_),o(p),o(a),o(yo),o(He),o(wo),o(To),o(Je),o(xo),o(Ao),o(R),o(Mo),o(ko),o(P),o(Io),o(Co),o(U),o(Ho),o(Lo),o(j),o(Jo),o(Po),o(L),o(Uo),o(jo),o(qo),o(Q),o(Eo),o(Zo),o(M),o(zo),o(Wo),o(I),o(Ro),o(Go),o(q),o(Vo),o(No),o(X),o(Do),o(Bo),o(ht),o(Yo),o($t),o(Fo),o(_t),o(So),o(bt),o(Qo),o(Xo),o(O),o(Oo),o(Ko),o(E),o(en),o(tn),o(Z),o(on),o(vo)),o(l),$(v,e),$(y,e),$(Le,e),$(Pe,e),$(Ue),$(ne),$(je,e),$(qe),$(re),$(Ee),$(ae),$(Ze,e),$(ze),$(se),$(le),$(We,e),$(Re),$(ie),$(me),$(Ge,e),$(Ve),$(Ne),$(de),$(De),$(pe),$(Be),$(Ye,e),$(Fe,e),$(Se),$(Qe,e),$(Xe),$(Oe),$(Ke),$(et),$(tt),$(ot),$(nt,e),$(rt),$(at),$(st),$(lt),$(it),$(mt,e),$(dt),$(pt),$(ct),$(gt,e),$(ft),$(ut,e),$(vt,e),$(yt),$(wt,e),$(Tt),$(xt),$(At),$(Mt,e),$(kt),$(It),$(Ct)}}}const za='{"title":"Agents和工具","local":"agents和工具","sections":[{"title":"Agents","local":"agents","sections":[{"title":"HfAgent","local":"transformers.HfAgent","sections":[],"depth":3},{"title":"LocalAgent","local":"transformers.LocalAgent","sections":[],"depth":3},{"title":"OpenAiAgent","local":"transformers.OpenAiAgent","sections":[],"depth":3},{"title":"AzureOpenAiAgent","local":"transformers.AzureOpenAiAgent","sections":[],"depth":3},{"title":"Agent","local":"transformers.Agent","sections":[],"depth":3}],"depth":2},{"title":"工具","local":"工具","sections":[{"title":"load_tool","local":"transformers.load_tool","sections":[],"depth":3},{"title":"Tool","local":"transformers.Tool","sections":[],"depth":3},{"title":"PipelineTool","local":"transformers.PipelineTool","sections":[],"depth":3},{"title":"RemoteTool","local":"transformers.RemoteTool","sections":[],"depth":3},{"title":"launch_gradio_demo","local":"transformers.launch_gradio_demo","sections":[],"depth":3}],"depth":2},{"title":"Agent类型","local":"agent类型","sections":[{"title":"AgentText","local":"transformers.tools.agent_types.AgentText","sections":[],"depth":3},{"title":"AgentImage","local":"transformers.tools.agent_types.AgentImage","sections":[],"depth":3},{"title":"AgentAudio","local":"transformers.tools.agent_types.AgentAudio","sections":[],"depth":3}],"depth":2}],"depth":1}';function Wa(k){return xa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fa extends Aa{constructor(l){super(),Ma(this,l,Wa,Za,Ta,{})}}export{Fa as component};
