import{s as F,n as K,o as O}from"../chunks/scheduler.22bf70d2.js";import{S as ee,i as te,g as o,s as n,r as S,A as ie,h as r,f as i,c as s,j as D,u as E,x as T,k as I,y as ae,a,v as B,d as J,t as N,w as V}from"../chunks/index.59178e06.js";import{C as ne}from"../chunks/CodeBlock.f7047b13.js";import{H as W}from"../chunks/Heading.f8746c79.js";function se(X){let l,v,$,P,p,b,m,Z='A <a href="https://cloud.google.com/tpu/docs/intro-to-tpu" rel="nofollow">TPU (Tensor Processing Unit)</a> is a type of hardware specifically designed for training models efficiently. Accelerate supports TPU training, but there are a few things you should be aware of, namely graph compilation. This tutorial briefly discusses compilation, and for more details, take a look at the <a href="../concept_guides/training_tpu">Training on TPUs with Accelerate</a> guide.',x,h,U,c,j="A TPU creates a graph of all the operations in the training step such as the forward pass, backward pass and optimizer step. This is why the first training step always takes a while because building and compiling this graph takes time. But once compilation is complete, it is cached and all subsequent steps are much faster.",C,f,G="The key is to avoid compiling your code again or else training is super slow. This means all your operations must be exactly the same:",M,d,Y="<li>all tensors in your batches must have the same length (for example, no dynamic padding for NLP tasks)</li> <li>your code must be static (for example, no layers with for loops that have different lengths depending on the input such as a LSTM)</li>",k,u,L,g,q='A common language model design is to tie the weights of the embedding and softmax layers. However, moving the model to a TPU (either yourself or passing it to the <a href="/docs/accelerate/v0.29.2/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method) breaks the weight tying and you’ll need to retie the weights.',H,y,Q='To add special behavior (like weight tying) in your script for TPUs, set <code>distributed_type</code> to <code>DistributedType.TPU</code> first. Then you can use the <a href="https://huggingface.co/docs/transformers/v4.39.3/en/main_classes/model#transformers.PreTrainedModel.tie_weights" rel="nofollow">tie_weights</a> method to tie the weights.',z,w,A,_,R;return p=new W({props:{title:"TPU training",local:"tpu-training",headingTag:"h1"}}),h=new W({props:{title:"Compilation",local:"compilation",headingTag:"h2"}}),u=new W({props:{title:"Weight tying",local:"weight-tying",headingTag:"h2"}}),w=new ne({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLlRQVSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnRpZV93ZWlnaHRzKCk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.TPU:
    model.tie_weights()`,wrap:!1}}),{c(){l=o("meta"),v=n(),$=o("p"),P=n(),S(p.$$.fragment),b=n(),m=o("p"),m.innerHTML=Z,x=n(),S(h.$$.fragment),U=n(),c=o("p"),c.textContent=j,C=n(),f=o("p"),f.textContent=G,M=n(),d=o("ul"),d.innerHTML=Y,k=n(),S(u.$$.fragment),L=n(),g=o("p"),g.innerHTML=q,H=n(),y=o("p"),y.innerHTML=Q,z=n(),S(w.$$.fragment),A=n(),_=o("p"),this.h()},l(e){const t=ie("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(i),v=s(e),$=r(e,"P",{}),D($).forEach(i),P=s(e),E(p.$$.fragment,e),b=s(e),m=r(e,"P",{"data-svelte-h":!0}),T(m)!=="svelte-1efoa6g"&&(m.innerHTML=Z),x=s(e),E(h.$$.fragment,e),U=s(e),c=r(e,"P",{"data-svelte-h":!0}),T(c)!=="svelte-76he8q"&&(c.textContent=j),C=s(e),f=r(e,"P",{"data-svelte-h":!0}),T(f)!=="svelte-1ga0n4t"&&(f.textContent=G),M=s(e),d=r(e,"UL",{"data-svelte-h":!0}),T(d)!=="svelte-fxztf"&&(d.innerHTML=Y),k=s(e),E(u.$$.fragment,e),L=s(e),g=r(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1yp6zx1"&&(g.innerHTML=q),H=s(e),y=r(e,"P",{"data-svelte-h":!0}),T(y)!=="svelte-1n2hjzx"&&(y.innerHTML=Q),z=s(e),E(w.$$.fragment,e),A=s(e),_=r(e,"P",{}),D(_).forEach(i),this.h()},h(){I(l,"name","hf:doc:metadata"),I(l,"content",le)},m(e,t){ae(document.head,l),a(e,v,t),a(e,$,t),a(e,P,t),B(p,e,t),a(e,b,t),a(e,m,t),a(e,x,t),B(h,e,t),a(e,U,t),a(e,c,t),a(e,C,t),a(e,f,t),a(e,M,t),a(e,d,t),a(e,k,t),B(u,e,t),a(e,L,t),a(e,g,t),a(e,H,t),a(e,y,t),a(e,z,t),B(w,e,t),a(e,A,t),a(e,_,t),R=!0},p:K,i(e){R||(J(p.$$.fragment,e),J(h.$$.fragment,e),J(u.$$.fragment,e),J(w.$$.fragment,e),R=!0)},o(e){N(p.$$.fragment,e),N(h.$$.fragment,e),N(u.$$.fragment,e),N(w.$$.fragment,e),R=!1},d(e){e&&(i(v),i($),i(P),i(b),i(m),i(x),i(U),i(c),i(C),i(f),i(M),i(d),i(k),i(L),i(g),i(H),i(y),i(z),i(A),i(_)),i(l),V(p,e),V(h,e),V(u,e),V(w,e)}}}const le='{"title":"TPU training","local":"tpu-training","sections":[{"title":"Compilation","local":"compilation","sections":[],"depth":2},{"title":"Weight tying","local":"weight-tying","sections":[],"depth":2}],"depth":1}';function oe(X){return O(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ce extends ee{constructor(l){super(),te(this,l,oe,se,F,{})}}export{ce as component};
