import{s as nn,n as pn,o as on}from"../chunks/scheduler.ddeee2a5.js";import{S as rn,i as Mn,e as i,s as a,c as r,h as un,a as p,d as s,b as n,f as an,g as M,j as o,k as J,l as cn,m as l,n as u,t as c,o as y,p as h}from"../chunks/index.10b70568.js";import{C as yn}from"../chunks/CopyLLMTxtMenu.68696f97.js";import{C as m}from"../chunks/CodeBlock.7ca4c11d.js";import{H as d,E as hn}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.d66d689f.js";function dn(Rl){let T,xt,bt,kt,A,At,q,qt,U,Sl='<p>Want to be listed as an Inference Provider on the Hugging Face Hub? Let’s get in touch!</p> <p>Please reach out to us on social networks or <a href="https://huggingface.co/spaces/huggingface/HuggingDiscussions/discussions/49" rel="nofollow">here on the Hub</a>.</p>',Bt,j,Wl='<p>Note that Step 3 will require your organization to upgrade their Hub account to a <a href="https://huggingface.co/pricing" rel="nofollow">Team or Enterprise plan</a>.</p>',$t,B,Vl="This guide details the steps for registering as an inference provider on the Hub and provides implementation guidance.",Ht,$,Xl='<li><strong>Implement standard task APIs</strong> - Follow our task API schemas for compatibility (see <a href="#1-prerequisites">Prerequisites</a>).</li> <li><strong>Submit a PR for JS client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> (see <a href="#2-js-client-integration">JS Client Integration</a>).</li> <li><strong>Register model mappings</strong> - Use our Model Mapping API to link your models to Hub models (see <a href="#3-model-mapping-api">Model Mapping API</a>).</li> <li><strong>Implement a billing endpoint</strong> - Provide an API for billing (see <a href="#4-billing">Billing</a>).</li> <li><strong>Submit a PR for Python client integration</strong> - Add your provider to <a href="https://github.com/huggingface/huggingface_hub" rel="nofollow">huggingface_hub</a> (see <a href="#5-python-client-integration">Python client integration</a>).</li> <li><strong>Register your provider server-side and provide an icon</strong> - Reach out to us to add your provider server-side and provide your SVG icon.</li> <li><strong>Create documentation on your side</strong> - Add documentation and do a lot of communication on your side.</li> <li><strong>Add a documentation page</strong> - Open a Pull Request in this repo (huggingface/hub-docs) to add a provider-specific page in the documentation.</li> <li><strong>Share share share</strong> do a lot of comms so that your integration is as successful as possible!</li>',Gt,H,Zt,w,Ql='<p>If your implementation strictly follows the OpenAI API for LLMs and VLMs, you may be able to skip most of this section. In that case, simply open a PR on <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> to register.</p>',_t,G,El=`The first step to understand the integration is to take a look at the JS inference client that lives
inside the <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">huggingface.js</a> repo.`,Rt,Z,Yl=`This is the client that powers our Inference widgets on model pages, and is the blueprint
implementation downstream (for Python SDK, to generate code snippets, etc.).`,St,_,Wt,R,Fl=`You will see that inference methods (<code>textToImage</code>, <code>chatCompletion</code>, etc.) have names that closely
mirror the task names. A task, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of
model (basically which types of inputs and outputs the model has), for instance “text-generation”
or “text-to-image”. It is indicated prominently on model pages, here:`,Vt,f,Nl='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/pipeline-tag-on-model-page-dark.png"/></picture>',Xt,S,zl='The list of all possible tasks can be found at <a href="https://huggingface.co/tasks" rel="nofollow">https://huggingface.co/tasks</a> and the list of JS method names is documented in the README at <a href="https://github.com/huggingface/huggingface.js/tree/main/packages/inference" rel="nofollow">https://github.com/huggingface/huggingface.js/tree/main/packages/inference</a>.',Qt,g,Pl=`<p>Note that <code>chatCompletion</code> is an exception as it is not a pipeline_tag, per se. Instead, it
includes models with either <code>pipeline_tag=&quot;text-generation&quot;</code> or <code>pipeline_tag=&quot;image-text-to-text&quot;</code>
which are tagged as “conversational”.</p>`,Et,W,Yt,V,Ll=`For each task type, we enforce an API schema to make it easier for end users to use different
models interchangeably. To be compatible, your third-party API must adhere to a “standard” shape API we expect on HF model pages for each pipeline task type.`,Ft,X,Dl=`This is not an issue for LLMs as everyone converged on the OpenAI API anyways, but can be
more tricky for other tasks like “text-to-image” or “automatic-speech-recognition” where there
exists no standard API.`,Nt,Q,Ol='For example, you can find the expected schema for Text to Speech here: <a href="https://github.com/huggingface/huggingface.js/blob/0a690a14d52041a872dc103846225603599f4a33/packages/tasks/src/tasks/text-to-speech/spec/input.json#L4" rel="nofollow">https://github.com/huggingface/huggingface.js/packages/src/tasks/text-to-speech/spec/input.json#L4</a>, and similarly for other supported tasks. If your API for a given task is different from HF’s, it is not an issue: you can tweak the code in <code>huggingface.js</code> to be able to call your models, i.e., provide some kind of “translation” of parameter names and output names. However, API specs should not be model-specific, only task-specific. Run the JS code and add some <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/test/HfInference.spec.ts" rel="nofollow">tests</a> to make sure it works well. We can help with this step!',zt,E,Pt,Y,Kl="Before proceeding with the next steps, ensure you’ve implemented the necessary code to integrate with the JS client and thoroughly tested your implementation. Here are the steps to follow:",Lt,F,Dt,N,ea="Create a new file under <code>packages/inference/src/providers/{provider_name}.ts</code> and copy-paste the following snippet.",Ot,z,Kt,P,ta="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. You have to define at least <code>makeRoute</code>, <code>preparePayload</code> and <code>getResponse</code>.",es,L,sa='If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern used in the existing providers implementation, e.g. <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/together.ts" rel="nofollow">Together AI provider implementation</a>.',ts,D,la='For text-generation and conversational tasks, you can just inherit from <code>BaseTextGenerationTask</code> and <code>BaseConversationalTask</code> respectively (defined in <a href="(https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/providerHelper.ts)">providerHelper.ts</a>) and override the methods if needed. Examples can be found in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/cerebras.ts" rel="nofollow">Cerebras</a> or <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/src/providers/fireworks.ts" rel="nofollow">Fireworks</a> provider implementations.',ss,O,ls,K,aa='Go to <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/lib/getProviderHelper.ts" rel="nofollow">packages/inference/src/lib/getProviderHelper.ts</a> and add your provider to <code>PROVIDERS</code>. You will need to add your provider to the <code>INFERENCE_PROVIDERS</code> list as well in <a href="https://github.com/huggingface/huggingface.js//blob/main/packages/inference/src/types.ts" rel="nofollow">packages/inference/src/types.ts</a>. Please try to respect alphabetical order.',as,ee,na='Update the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/inference/README.md" rel="nofollow">README.md</a> in the <code>packages/inference</code> directory to include your provider in the list of supported providers and the list of supported models links.',ns,te,is,se,ia="Congratulations! You now have a JS implementation to successfully make inference calls on your infra! Time to integrate with the Hub!",ps,le,pa="First step is to use the Model Mapping API to register which HF models are supported.",os,I,oa='<p>To proceed with this step, we have to enable your account server-side. Make sure you have an organization on the Hub for your company, and upgrade it to a <a href="https://huggingface.co/pricing" rel="nofollow">Team or Enterprise plan</a>.</p>',rs,ae,Ms,ne,us,ie,ra="Create a new mapping item, with the following body (JSON-encoded):",cs,pe,ys,oe,Ma=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>hfModel</code> is the model id on the Hub’s side.</li> <li><code>providerModel</code> is the model id on your side (can be the same or different. In general, we encourage you to use the HF model ids on your side as well, but this is up to you).</li>`,hs,re,ua="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",ds,Me,ms,ue,ca=`You need to be in the <em>provider</em> Hub organization (e.g. <a href="https://huggingface.co/togethercomputer" rel="nofollow">https://huggingface.co/togethercomputer</a>
for TogetherAI) with <strong>Write</strong> permissions to be able to access this endpoint.`,Js,ce,Ts,ye,ya="The endpoint validates that:",Us,he,ha=`<li><code>hfModel</code> is indeed of <code>pipeline_tag == task</code> OR <code>task</code> is “conversational” and the model is
compatible (i.e. the <code>pipeline_tag</code> is either “text-generation” or “image-text-to-text” AND the model is tagged as “conversational”).</li> <li>After the mapping creation (asynchronously) we automatically test whether the Partner API correctly handles huggingface.js/inference calls for the relevant task, ensuring the API specifications are valid. See the <a href="#automatic-validation">Automatic validation</a> section below.</li>`,js,de,ws,me,da=`We also support mapping HF models based on their <code>tags</code>. Using tag filters, you can automatically map multiple HF models to a single inference endpoint on your side.
For example, any model tagged with both <code>lora</code> and <code>base_model:adapter:black-forest-labs/FLUX.1-dev</code> can be mapped to your Flux-dev LoRA inference endpoint.`,fs,C,ma='<p>Important: Make sure that the JS client library can handle LoRA weights for your provider. Check out <a href="https://github.com/huggingface/huggingface.js/blob/904964c9f8cd10ed67114ccb88b9028e89fd6cad/packages/inference/src/providers/fal-ai.ts#L78-L124" rel="nofollow">fal’s implementation</a> for more details.</p>',gs,Je,Ja="The API is as follows:",Is,Te,Cs,Ue,Ta="Create a new mapping item, with the following body (JSON-encoded):",bs,je,vs,we,Ua=`<li><code>task</code>, also known as <code>pipeline_tag</code> in the HF ecosystem, is the type of model / type of API
(examples: “text-to-image”, “text-generation”, but you should use “conversational” for chat models)</li> <li><code>tags</code> is the set of model tags to match. For example, to match all LoRAs of Flux, you can use: <code>[&quot;lora&quot;, &quot;base_model:adapter:black-forest-labs/FLUX.1-dev&quot;]</code></li> <li><code>providerModel</code> is the model ID on your side (can be the same or different from the HF model ID).</li> <li><code>adapterType</code> is a literal value that helps client libraries interpret how to call your API. The only supported value at the moment is <code>&quot;lora&quot;</code>.</li>`,xs,fe,ja="The output of this route is a mapping ID that you can later use to update the mapping’s status or delete it.",ks,ge,As,Ie,qs,Ce,wa=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Bs,be,$s,ve,fa="Call this HTTP PUT endpoint:",Hs,xe,Gs,ke,ga="With the following body (JSON-encoded):",Zs,Ae,_s,qe,Ia=`Where <code>mapping ID</code> is the mapping’s <code>_id</code> field obtained upon creation.
You can also retrieve it from the <a href="#list-the-whole-mapping">list API endpoint</a>.`,Rs,Be,Ss,$e,Ws,He,Ca="This gets all mapping items from the DB. For clarity, the output is grouped by task.",Vs,b,ba="<p>This is publicly accessible. It’s useful to be transparent by default and it helps debug client SDKs, etc.</p>",Xs,Ge,va="Here is an example of response:",Qs,Ze,Es,_e,Ys,Re,xa="Once a mapping is created through the API, Hugging Face performs periodic automated tests to ensure the mapped endpoint functions correctly.",Fs,Se,ka="Each model is tested every 6 hours by making API calls to your service. If the test is successful, the model remains active and continues to be tested periodically. However, if the test fails (e.g., your service returns an HTTP error status during an inference request), the provider will be temporarily removed from the list of active providers.",Ns,v,Aa='<picture><img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-light.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/automatic-validation-dark.png"/></picture>',zs,We,qa="A failed mapping undergoes retesting every hour. Additionally, updating the status of a model mapping triggers an immediate validation test.",Ps,Ve,Ba="The validation process checks the following:",Ls,Xe,$a=`<li>The Inference API is reachable, and the HTTP call succeeds.</li> <li>The output format is compatible with the Hugging Face JavaScript Inference Client.</li> <li>Latency requirements are met:
<ul><li>For conversational and text models: under 5 seconds (time to first token in streaming mode).</li> <li>For other tasks: under 30 seconds.</li></ul></li>`,Ds,Qe,Ha="For large language models (LLMs), additional behavioral tests are conducted:",Os,Ee,Ga="<li>Tool calling support.</li> <li>Structured output support.</li>",Ks,Ye,Za="These tests involve sending specific inference requests to the model and verifying that the responses meet the expected format.",el,Fe,tl,Ne,_a=`For routed requests (see figure below), i.e. when users authenticate via HF, our intent is that
our users only pay the standard provider API rates. There’s no additional markup from us, we
just pass through the provider costs directly.
More details about the pricing structure can be found on the <a href="./pricing">pricing page</a>.`,sl,x,Ra='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/inference-providers/types_of_billing.png"/>',ll,ze,Sa=`We propose an easier way to figure out this cost and charge it to our users, by asking you to
provide the cost for each request via an HTTP API you host on your end.`,al,Pe,nl,Le,Wa=`We ask that you expose an API that supports a HTTP POST request.
The body of the request is a JSON-encoded object containing a list of request IDs for which we
request the cost.
The authentication system should be the same as your Inference service; for example, a bearer token.`,il,De,pl,Oe,Va=`The response is also JSON-encoded. The response contains an array of objects specifying the
request’s ID and its cost in nano-USD (10^-9 USD).`,ol,Ke,rl,et,Ml,tt,Xa="We require the price to be a <strong>non-negative integer</strong> number of <strong>nano-USDs</strong> (10^-9 USD).",ul,st,cl,lt,Qa=`For each request/generation you serve, you should define a unique request (or response) ID,
and provide it as a response Header. We will use this ID as the request ID for the billing API
above.`,yl,at,Ea="As part of those requirements, please let us know your Header name. If you don’t already have one, we suggest the <code>Inference-Id</code> name for instance, and it should contain a UUID character string.",hl,nt,Ya="<strong>Example</strong>: Defining an <code>Inference-Id</code> header in your inference response.",dl,it,ml,pt,Jl,k,Fa="<p>Before adding a new provider to the <code>huggingface_hub</code> Python library, make sure that all the previous steps have been completed and everything is working on the Hub. Support in the Python library comes as a second step.</p>",Tl,ot,Ul,rt,Na="Create a new file under <code>src/huggingface_hub/inference/_providers/{provider_name}.py</code> and copy-paste the following snippet.",jl,Mt,za="Implement the methods that require custom handling. Check out the base implementation to check default behavior. If you don’t need to override a method, just remove it. At least one of <code>_prepare_payload_as_dict</code> or <code>_prepare_payload_as_bytes</code> must be overwritten.",wl,ut,Pa="If the provider supports multiple tasks that require different implementations, create dedicated subclasses for each task, following the pattern shown in fal_ai.py.",fl,ct,La="For text-generation and conversational tasks, one can just inherit from BaseTextGenerationTask and BaseConversationalTask respectively (defined in _common.py) and override the methods if needed. Examples can be found in fireworks_ai.py and together.py.",gl,yt,Il,ht,Cl,dt,Da='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_providers/__init__.py" rel="nofollow">src/huggingface_hub/inference/_providers/<strong>init</strong>.py</a> and add your provider to <code>PROVIDER_T</code> and <code>PROVIDERS</code>. Please try to respect alphabetical order.</li> <li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/src/huggingface_hub/inference/_client.py" rel="nofollow">src/huggingface_hub/inference/_client.py</a> and update docstring in <code>InferenceClient.__init__</code> to document your provider.</li>',bl,mt,vl,Jt,Oa='<li>Go to <a href="https://github.com/huggingface/huggingface_hub/blob/main/tests/test_inference_providers.py" rel="nofollow">tests/test_inference_providers.py</a> and add static tests for overridden methods.</li>',xl,Tt,kl,Ut,Ka="Create a dedicated documentation page for your provider within the Hugging Face documentation. This page should contain a concise description of your provider services, highlight the benefits for users, set expectations regarding performance or features, and include any relevant details such as pricing models or data retention policies. Essentially, provide any information that would be valuable to end users.",Al,jt,en="Here’s how to add your documentation page:",ql,wt,tn=`<li>Provide Your Logo: You can send your logo files (separate light and dark mode versions) directly to us. This is often the simplest way. Alternatively, if you prefer, you can open a PR in the <a href="https://huggingface.co/datasets/huggingface/documentation-images/tree/main/inference-providers/logos" rel="nofollow">huggingface/documentation-images</a> repository. If you choose to open a PR:
<ul><li>Logos must be in <code>.png</code> format.</li> <li>Name them <code>{provider-name}-light.png</code> and <code>{provider-name}-dark.png</code>.</li> <li>Please ping <code>@Wauplin</code> and <code>@celinah</code> on the PR.</li></ul></li> <li>Create the Documentation File:
<ul><li>Use an existing provider page as a template. For example, check out the template for <a href="https://github.com/huggingface/hub-docs/blob/main/scripts/inference-providers/templates/providers/fal-ai.handlebars" rel="nofollow">Fal AI</a>.</li> <li>The file should be located under <code>scripts/inference-providers/templates/providers/{your-provider-name}.handlebars</code>.</li></ul></li> <li>Submit the Documentation PR:
<ul><li>Add your new <code>{provider-name}.handlebars</code> file.</li> <li>Update the <a href="./index#partners">partners table</a> to include your company or product.</li> <li>Update the <code>_toctree.yml</code> file in the <code>docs/inference-providers/</code> directory to include your new documentation page in the “Providers” section, maintaining alphabetical order.</li> <li>Update the <code>scripts/inference-providers/scripts/generate.ts</code> file to include your provider in the <code>PROVIDERS_HUB_ORGS</code> and <code>PROVIDERS_URLS</code> constants, maintaining alphabetical order.</li> <li>Run <code>pnpm install</code> (if you haven’t already) and then <code>pnpm run generate</code> at the root of the <code>scripts/inference-providers</code> repository to generate the documentation.</li> <li>Commit all your changes, including the manually edited files (provider page, <code>_toctree.yml</code>, partners table) and the files generated by the script.</li> <li>When you open the PR, please ping @Wauplin, @SBrandeis, @julien-c, and @hanouticelina for a review. If you need any assistance with these steps, please reach out – we’re here to help you!</li></ul></li>`,Bl,ft,$l,gt,sn="<strong>Question:</strong> By default, in which order do we list providers in the settings page?",Hl,It,ln="<strong>Answer:</strong> The default sort is by total number of requests routed by HF over the last 7 days. This order defines which provider will be used in priority by the widget on the model page (but the user’s order takes precedence).",Gl,Ct,Zl,vt,_l;return A=new yn({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),q=new d({props:{title:"How to be registered as an inference provider on the Hub?",local:"how-to-be-registered-as-an-inference-provider-on-the-hub",headingTag:"h1"}}),H=new d({props:{title:"1. Prerequisites",local:"1-prerequisites",headingTag:"h2"}}),_=new d({props:{title:"What is a Task",local:"what-is-a-task",headingTag:"h3"}}),W=new d({props:{title:"Task API schema",local:"task-api-schema",headingTag:"h3"}}),E=new d({props:{title:"2. JS Client Integration",local:"2-js-client-integration",headingTag:"h2"}}),F=new d({props:{title:"Implement the provider helper (JS)",local:"implement-the-provider-helper-js",headingTag:"h3"}}),z=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">TaskProviderHelper</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;./providerHelper&quot;</span>;

<span class="hljs-keyword">export</span> <span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTask</span> <span class="hljs-keyword">extends</span> <span class="hljs-title class_ inherited__">TaskProviderHelper</span> {

	<span class="hljs-title function_">constructor</span>(<span class="hljs-params"></span>) {
		<span class="hljs-variable language_">super</span>(<span class="hljs-string">&quot;your-provider-name&quot;</span>, <span class="hljs-string">&quot;your-api-base-url&quot;</span>, <span class="hljs-string">&quot;task-name&quot;</span>);
	}

    <span class="hljs-keyword">override</span> <span class="hljs-title function_">prepareHeaders</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">HeaderParams</span>, <span class="hljs-attr">binary</span>: <span class="hljs-built_in">boolean</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">string</span>&gt; {
        <span class="hljs-comment">// Override the headers to use for the request.</span>
        <span class="hljs-keyword">return</span> <span class="hljs-variable language_">super</span>.<span class="hljs-title function_">prepareHeaders</span>(params, binary);
    }

	<span class="hljs-title function_">makeRoute</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">UrlParams</span>): <span class="hljs-built_in">string</span> {
        <span class="hljs-comment">// Return the route to use for the request. e.g. /v1/chat/completions route is commonly use for chat completion.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">preparePayload</span>(<span class="hljs-attr">params</span>: <span class="hljs-title class_">BodyParams</span>): <span class="hljs-title class_">Record</span>&lt;<span class="hljs-built_in">string</span>, <span class="hljs-built_in">unknown</span>&gt; {
        <span class="hljs-comment">// Return the payload to use for the request, as a dict.</span>
		<span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
	}

	<span class="hljs-title function_">getResponse</span>(<span class="hljs-attr">response</span>: <span class="hljs-built_in">unknown</span>, outputType?: <span class="hljs-string">&quot;url&quot;</span> | <span class="hljs-string">&quot;blob&quot;</span>): <span class="hljs-built_in">string</span> | <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-title class_">Blob</span>&gt;{
		<span class="hljs-comment">// Return the response in the expected format.</span>
        <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Needs to be implemented&quot;</span>);
    }
}`,wrap:!1}}),O=new d({props:{title:"Register the provider",local:"register-the-provider",headingTag:"h3"}}),te=new d({props:{title:"3. Model Mapping API",local:"3-model-mapping-api",headingTag:"h2"}}),ae=new d({props:{title:"Register a mapping item",local:"register-a-mapping-item",headingTag:"h3"}}),ne=new m({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),pe=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydGFzayUyMiUzQSUyMCUyMldpZGdldFR5cGUlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMmhmTW9kZWwlMjIlM0ElMjAlMjJzdHJpbmclMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMG1vZGVsJTIwb24lMjBIRiUzQSUyMG5hbWVzcGFjZSUyRm1vZGVsLW5hbWUlMEElMjAlMjAlMjAlMjAlMjJwcm92aWRlck1vZGVsJTIyJTNBJTIwJTIyc3RyaW5nJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjB0aGUlMjBwYXJ0bmVyJ3MlMjAlMjJtb2RlbCUyMGlkJTIyJTIwaS5lLiUyMGlkJTIwb24lMjB5b3VyJTIwc2lkZSUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;hfModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the name of the model on HF: namespace/model-name</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Me=new d({props:{title:"Authentication",local:"authentication",headingTag:"h4"}}),ce=new d({props:{title:"Validation",local:"validation",headingTag:"h4"}}),de=new d({props:{title:"Using a tag-filter to map several HF models to a single inference endpoint",local:"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint",headingTag:"h3"}}),Te=new m({props:{code:"UE9TVCUyMCUyRmFwaSUyRnBhcnRuZXJzJTJGJTdCcHJvdmlkZXIlN0QlMkZtb2RlbHM=",highlighted:"POST /api/partners/{provider}/models",wrap:!1}}),je=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMnRhZy1maWx0ZXIlMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUwQSUyMCUyMCUyMCUyMCUyMnRhc2slMjIlM0ElMjAlMjJXaWRnZXRUeXBlJTIyJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlMEElMjAlMjAlMjAlMjAlMjJ0YWdzJTIyJTNBJTIwJTVCJTIyc3RyaW5nJTIyJTVEJTJDJTIwJTJGJTJGJTIwcmVxdWlyZWQlM0ElMjBhbnklMjBIRiUyMG1vZGVsJTIwd2l0aCUyMGFsbCUyMG9mJTIwdGhvc2UlMjB0YWdzJTIwd2lsbCUyMGJlJTIwbWFwcGVkJTIwdG8lMjBwcm92aWRlck1vZGVsJTBBJTIwJTIwJTIwJTIwJTIycHJvdmlkZXJNb2RlbCUyMiUzQSUyMCUyMnN0cmluZyUyMiUyQyUyMCUyRiUyRiUyMHJlcXVpcmVkJTNBJTIwdGhlJTIwcGFydG5lcidzJTIwJTIybW9kZWwlMjBpZCUyMiUyMGkuZS4lMjBpZCUyMG9uJTIweW91ciUyMHNpZGUlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyVHlwZSUyMiUzQSUyMCUyMmxvcmElMjIlMkMlMjAlMkYlMkYlMjByZXF1aXJlZCUzQSUyMG9ubHklMjAlMjJsb3JhJTIyJTIwaXMlMjBzdXBwb3J0ZWQlMjBhdCUyMHRoZSUyMG1vbWVudCUwQSUyMCUyMCUyMCUyMCUyMnN0YXR1cyUyMiUzQSUyMCUyMmxpdmUlMjIlMjAlN0MlMjAlMjJzdGFnaW5nJTIyJTIwJTJGJTJGJTIwT3B0aW9uYWwlM0ElMjBkZWZhdWx0cyUyMHRvJTIwJTIyc3RhZ2luZyUyMi4lMjAlMjJzdGFnaW5nJTIyJTIwbW9kZWxzJTIwYXJlJTIwb25seSUyMGF2YWlsYWJsZSUyMHRvJTIwbWVtYmVycyUyMG9mJTIwdGhlJTIwcGFydG5lcidzJTIwb3JnJTJDJTIwdGhlbiUyMHlvdSUyMHN3aXRjaCUyMHRoZW0lMjB0byUyMCUyMmxpdmUlMjIlMjB3aGVuJTIwdGhleSdyZSUyMHJlYWR5JTIwdG8lMjBnbyUyMGxpdmUlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tag-filter&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;task&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;WidgetType&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required</span>
    <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: any HF model with all of those tags will be mapped to providerModel</span>
    <span class="hljs-attr">&quot;providerModel&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: the partner&#x27;s &quot;model id&quot; i.e. id on your side</span>
    <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-comment">// required: only &quot;lora&quot; is supported at the moment</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// Optional: defaults to &quot;staging&quot;. &quot;staging&quot; models are only available to members of the partner&#x27;s org, then you switch them to &quot;live&quot; when they&#x27;re ready to go live</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ge=new d({props:{title:"Delete a mapping item",local:"delete-a-mapping-item",headingTag:"h3"}}),Ie=new m({props:{code:"REVMRVRFJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RA==",highlighted:"DELETE /api/partners/{provider}/models/{mapping ID}",wrap:!1}}),be=new d({props:{title:"Update a mapping item’s status",local:"update-a-mapping-items-status",headingTag:"h3"}}),xe=new m({props:{code:"UFVUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUyRiU3Qm1hcHBpbmclMjBJRCU3RCUyRnN0YXR1cw==",highlighted:"PUT /api/partners/{provider}/models/{mapping ID}/status",wrap:!1}}),Ae=new m({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJTIyc3RhdHVzJTIyJTNBJTIwJTIybGl2ZSUyMiUyMCU3QyUyMCUyMnN0YWdpbmclMjIlMjAlMkYlMkYlMjBUaGUlMjBuZXclMjBzdGF0dXMlMkMlMjBvbmUlMjBvZiUyMCUyMnN0YWdpbmclMjIlMjBvciUyMCUyMmxpdmUlMjIlMEElN0QlMjAlMjAlMjA=",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span> | <span class="hljs-string">&quot;staging&quot;</span> <span class="hljs-comment">// The new status, one of &quot;staging&quot; or &quot;live&quot;</span>
<span class="hljs-punctuation">}</span>   `,wrap:!1}}),Be=new d({props:{title:"List the whole mapping",local:"list-the-whole-mapping",headingTag:"h3"}}),$e=new m({props:{code:"R0VUJTIwJTJGYXBpJTJGcGFydG5lcnMlMkYlN0Jwcm92aWRlciU3RCUyRm1vZGVscyUzRnN0YXR1cyUzRHN0YWdpbmclN0NsaXZl",highlighted:"GET /api/partners/{provider}/models?status=staging|live",wrap:!1}}),Ze=new m({props:{code:"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",highlighted:`<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;text-to-image&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Canny-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-canny&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;black-forest-labs/FLUX.1-Depth-dev&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;black-forest-labs/FLUX.1-depth&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;tag-filter=base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0,lora&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;sdxl-lora-mutualized&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;adapterType&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;lora&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;tags&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
                <span class="hljs-string">&quot;base_model:adapter:stabilityai/stable-diffusion-xl-base-1.0&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-string">&quot;lora&quot;</span>
            <span class="hljs-punctuation">]</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;conversational&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;deepseek-ai/DeepSeek-R1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;text-generation&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;meta-llama/Llama-2-70b-hf&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;_id&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;xxxxxxxxxxxxxxxxxxxxxxxx&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;providerId&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;mistralai/Mixtral-8x7B-v0.1&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;status&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;live&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),_e=new d({props:{title:"Automatic validation",local:"automatic-validation",headingTag:"h3"}}),Fe=new d({props:{title:"4. Billing",local:"4-billing",headingTag:"h2"}}),Pe=new d({props:{title:"HTTP API Specs",local:"http-api-specs",headingTag:"h3"}}),De=new m({props:{code:"UE9TVCUyMCU3QnlvdXIlMjBVUkwlMjBoZXJlJTdEJTBBQXV0aG9yaXphdGlvbiUzQSUyMCU3QmF1dGhlbnRpY2F0aW9uJTIwaW5mbyUyMC0lMjBlZyUyMCUyMkJlYXJlciUyMHRva2VuJTIyJTdEJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdElkcyUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlYWRiZWVmMyUyMiUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`POST {your URL here}
<span class="hljs-attribute">Authorization</span><span class="hljs-punctuation">: </span>{authentication info - eg &quot;Bearer token&quot;}
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

{
    &quot;requestIds&quot;: [
        &quot;deadbeef0&quot;,
        &quot;deadbeef1&quot;,
        &quot;deadbeef2&quot;,
        &quot;deadbeef3&quot;
    ]
}`,wrap:!1}}),Ke=new m({props:{code:"SFRUUCUyRjEuMSUyMDIwMCUyME9LJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTBBJTdCJTBBJTIwJTIwJTIwJTIwJTIycmVxdWVzdHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjAlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMCUyMnJlcXVlc3RJZCUyMiUzQSUyMCUyMmRlYWRiZWVmMSUyMiUyQyUyMCUyMmNvc3ROYW5vVXNkJTIyJTNBJTIwMTAwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIwJTIycmVxdWVzdElkJTIyJTNBJTIwJTIyZGVhZGJlZWYyJTIyJTJDJTIwJTIyY29zdE5hbm9Vc2QlMjIlM0ElMjAxMDAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjAlMjJyZXF1ZXN0SWQlMjIlM0ElMjAlMjJkZWFkYmVlZjMlMjIlMkMlMjAlMjJjb3N0TmFub1VzZCUyMiUzQSUyMDEwMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json

<span class="language-prolog">{
    <span class="hljs-string">&quot;requests&quot;</span>: [
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef0&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef1&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef2&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> },
        { <span class="hljs-string">&quot;requestId&quot;</span>: <span class="hljs-string">&quot;deadbeef3&quot;</span>, <span class="hljs-string">&quot;costNanoUsd&quot;</span>: <span class="hljs-number">100</span> }
    ]
}</span>`,wrap:!1}}),et=new d({props:{title:"Price Unit",local:"price-unit",headingTag:"h3"}}),st=new d({props:{title:"How to define the request ID",local:"how-to-define-the-request-id",headingTag:"h3"}}),it=new m({props:{code:"UE9TVCUyMCUyRnYxJTJGY2hhdCUyRmNvbXBsZXRpb25zJTBBQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJTBBJTVCcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEElNUJyZXF1ZXN0JTIwYm9keSU1RCUwQS0tLS0tLSUwQUhUVFAlMkYxLjElMjAyMDAlMjBPSyUwQUNvbnRlbnQtVHlwZSUzQSUyMGFwcGxpY2F0aW9uJTJGanNvbiUwQSU1Qm90aGVyJTIwcmVxdWVzdCUyMGhlYWRlcnMlNUQlMEFJbmZlcmVuY2UtSWQlM0ElMjB1bmlxdWUtaWQtMDAxMzElMEElNUJyZXNwb25zZSUyMGJvZHklNUQ=",highlighted:`POST /v1/chat/completions
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[request headers]
[request body]
------
<span class="hljs-meta">HTTP/1.1</span> <span class="hljs-number">200</span> OK
<span class="hljs-attribute">Content-Type</span><span class="hljs-punctuation">: </span>application/json
[other request headers]
<span class="hljs-attribute">Inference-Id</span><span class="hljs-punctuation">: </span>unique-id-00131
[response body]`,wrap:!1}}),pt=new d({props:{title:"5. Python client integration",local:"5-python-client-integration",headingTag:"h2"}}),ot=new d({props:{title:"Implement the provider helper (Python)",local:"implement-the-provider-helper-python",headingTag:"h3"}}),yt=new m({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Any</span>, <span class="hljs-type">Dict</span>, <span class="hljs-type">Optional</span>, <span class="hljs-type">Union</span>

<span class="hljs-keyword">from</span> ._common <span class="hljs-keyword">import</span> TaskProviderHelper


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyNewProviderTaskProviderHelper</span>(<span class="hljs-title class_ inherited__">TaskProviderHelper</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Define high-level parameters.&quot;&quot;&quot;</span>
        <span class="hljs-built_in">super</span>().__init__(provider=..., base_url=..., task=...)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_response</span>(<span class="hljs-params">
        self,
        response: <span class="hljs-type">Union</span>[<span class="hljs-built_in">bytes</span>, <span class="hljs-type">Dict</span>],
        request_params: <span class="hljs-type">Optional</span>[RequestParameters] = <span class="hljs-literal">None</span>,
    </span>) -&gt; <span class="hljs-type">Any</span>:
        <span class="hljs-string">&quot;&quot;&quot;
        Return the response in the expected format.

        Override this method in subclasses for customized response handling.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>().get_response(response)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_headers</span>(<span class="hljs-params">self, headers: <span class="hljs-type">Dict</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Dict</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the headers to use for the request.

        Override this method in subclasses for customized headers.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_headers(headers, api_key)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_route</span>(<span class="hljs-params">self, mapped_model: <span class="hljs-built_in">str</span>, api_key: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-string">&quot;&quot;&quot;Return the route to use for the request.

        Override this method in subclasses for customized routes.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_route(mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_dict</span>(<span class="hljs-params">self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the payload to use for the request, as a dict.

        Override this method in subclasses for customized payloads.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_dict(inputs, parameters, mapped_model)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_prepare_payload_as_bytes</span>(<span class="hljs-params">
        self, inputs: <span class="hljs-type">Any</span>, parameters: <span class="hljs-type">Dict</span>, mapped_model: <span class="hljs-built_in">str</span>, extra_payload: <span class="hljs-type">Optional</span>[<span class="hljs-type">Dict</span>]
    </span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">bytes</span>]:
        <span class="hljs-string">&quot;&quot;&quot;Return the body to use for the request, as bytes.

        Override this method in subclasses for customized body data.
        Only one of \`_prepare_payload_as_dict\` and \`_prepare_payload_as_bytes\` should return a value.
        &quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">super</span>()._prepare_payload_as_bytes(inputs, parameters, mapped_model, extra_payload)`,wrap:!1}}),ht=new d({props:{title:"Register the Provider",local:"register-the-provider",headingTag:"h3"}}),mt=new d({props:{title:"Add tests",local:"add-tests",headingTag:"h3"}}),Tt=new d({props:{title:"6. Add provider documentation",local:"6-add-provider-documentation",headingTag:"h2"}}),ft=new d({props:{title:"FAQ",local:"faq",headingTag:"h2"}}),Ct=new hn({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/inference-providers/register-as-a-provider.md"}}),{c(){T=i("meta"),xt=a(),bt=i("p"),kt=a(),r(A.$$.fragment),At=a(),r(q.$$.fragment),qt=a(),U=i("blockquote"),U.innerHTML=Sl,Bt=a(),j=i("blockquote"),j.innerHTML=Wl,$t=a(),B=i("p"),B.textContent=Vl,Ht=a(),$=i("ol"),$.innerHTML=Xl,Gt=a(),r(H.$$.fragment),Zt=a(),w=i("blockquote"),w.innerHTML=Ql,_t=a(),G=i("p"),G.innerHTML=El,Rt=a(),Z=i("p"),Z.textContent=Yl,St=a(),r(_.$$.fragment),Wt=a(),R=i("p"),R.innerHTML=Fl,Vt=a(),f=i("div"),f.innerHTML=Nl,Xt=a(),S=i("p"),S.innerHTML=zl,Qt=a(),g=i("blockquote"),g.innerHTML=Pl,Et=a(),r(W.$$.fragment),Yt=a(),V=i("p"),V.textContent=Ll,Ft=a(),X=i("p"),X.textContent=Dl,Nt=a(),Q=i("p"),Q.innerHTML=Ol,zt=a(),r(E.$$.fragment),Pt=a(),Y=i("p"),Y.textContent=Kl,Lt=a(),r(F.$$.fragment),Dt=a(),N=i("p"),N.innerHTML=ea,Ot=a(),r(z.$$.fragment),Kt=a(),P=i("p"),P.innerHTML=ta,es=a(),L=i("p"),L.innerHTML=sa,ts=a(),D=i("p"),D.innerHTML=la,ss=a(),r(O.$$.fragment),ls=a(),K=i("p"),K.innerHTML=aa,as=a(),ee=i("p"),ee.innerHTML=na,ns=a(),r(te.$$.fragment),is=a(),se=i("p"),se.textContent=ia,ps=a(),le=i("p"),le.textContent=pa,os=a(),I=i("blockquote"),I.innerHTML=oa,rs=a(),r(ae.$$.fragment),Ms=a(),r(ne.$$.fragment),us=a(),ie=i("p"),ie.textContent=ra,cs=a(),r(pe.$$.fragment),ys=a(),oe=i("ul"),oe.innerHTML=Ma,hs=a(),re=i("p"),re.textContent=ua,ds=a(),r(Me.$$.fragment),ms=a(),ue=i("p"),ue.innerHTML=ca,Js=a(),r(ce.$$.fragment),Ts=a(),ye=i("p"),ye.textContent=ya,Us=a(),he=i("ul"),he.innerHTML=ha,js=a(),r(de.$$.fragment),ws=a(),me=i("p"),me.innerHTML=da,fs=a(),C=i("blockquote"),C.innerHTML=ma,gs=a(),Je=i("p"),Je.textContent=Ja,Is=a(),r(Te.$$.fragment),Cs=a(),Ue=i("p"),Ue.textContent=Ta,bs=a(),r(je.$$.fragment),vs=a(),we=i("ul"),we.innerHTML=Ua,xs=a(),fe=i("p"),fe.textContent=ja,ks=a(),r(ge.$$.fragment),As=a(),r(Ie.$$.fragment),qs=a(),Ce=i("p"),Ce.innerHTML=wa,Bs=a(),r(be.$$.fragment),$s=a(),ve=i("p"),ve.textContent=fa,Hs=a(),r(xe.$$.fragment),Gs=a(),ke=i("p"),ke.textContent=ga,Zs=a(),r(Ae.$$.fragment),_s=a(),qe=i("p"),qe.innerHTML=Ia,Rs=a(),r(Be.$$.fragment),Ss=a(),r($e.$$.fragment),Ws=a(),He=i("p"),He.textContent=Ca,Vs=a(),b=i("blockquote"),b.innerHTML=ba,Xs=a(),Ge=i("p"),Ge.textContent=va,Qs=a(),r(Ze.$$.fragment),Es=a(),r(_e.$$.fragment),Ys=a(),Re=i("p"),Re.textContent=xa,Fs=a(),Se=i("p"),Se.textContent=ka,Ns=a(),v=i("div"),v.innerHTML=Aa,zs=a(),We=i("p"),We.textContent=qa,Ps=a(),Ve=i("p"),Ve.textContent=Ba,Ls=a(),Xe=i("ul"),Xe.innerHTML=$a,Ds=a(),Qe=i("p"),Qe.textContent=Ha,Os=a(),Ee=i("ul"),Ee.innerHTML=Ga,Ks=a(),Ye=i("p"),Ye.textContent=Za,el=a(),r(Fe.$$.fragment),tl=a(),Ne=i("p"),Ne.innerHTML=_a,sl=a(),x=i("div"),x.innerHTML=Ra,ll=a(),ze=i("p"),ze.textContent=Sa,al=a(),r(Pe.$$.fragment),nl=a(),Le=i("p"),Le.textContent=Wa,il=a(),r(De.$$.fragment),pl=a(),Oe=i("p"),Oe.textContent=Va,ol=a(),r(Ke.$$.fragment),rl=a(),r(et.$$.fragment),Ml=a(),tt=i("p"),tt.innerHTML=Xa,ul=a(),r(st.$$.fragment),cl=a(),lt=i("p"),lt.textContent=Qa,yl=a(),at=i("p"),at.innerHTML=Ea,hl=a(),nt=i("p"),nt.innerHTML=Ya,dl=a(),r(it.$$.fragment),ml=a(),r(pt.$$.fragment),Jl=a(),k=i("blockquote"),k.innerHTML=Fa,Tl=a(),r(ot.$$.fragment),Ul=a(),rt=i("p"),rt.innerHTML=Na,jl=a(),Mt=i("p"),Mt.innerHTML=za,wl=a(),ut=i("p"),ut.textContent=Pa,fl=a(),ct=i("p"),ct.textContent=La,gl=a(),r(yt.$$.fragment),Il=a(),r(ht.$$.fragment),Cl=a(),dt=i("ul"),dt.innerHTML=Da,bl=a(),r(mt.$$.fragment),vl=a(),Jt=i("ul"),Jt.innerHTML=Oa,xl=a(),r(Tt.$$.fragment),kl=a(),Ut=i("p"),Ut.textContent=Ka,Al=a(),jt=i("p"),jt.textContent=en,ql=a(),wt=i("ul"),wt.innerHTML=tn,Bl=a(),r(ft.$$.fragment),$l=a(),gt=i("p"),gt.innerHTML=sn,Hl=a(),It=i("p"),It.innerHTML=ln,Gl=a(),r(Ct.$$.fragment),Zl=a(),vt=i("p"),this.h()},l(e){const t=un("svelte-u9bgzb",document.head);T=p(t,"META",{name:!0,content:!0}),t.forEach(s),xt=n(e),bt=p(e,"P",{}),an(bt).forEach(s),kt=n(e),M(A.$$.fragment,e),At=n(e),M(q.$$.fragment,e),qt=n(e),U=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(U)!=="svelte-x496yh"&&(U.innerHTML=Sl),Bt=n(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(j)!=="svelte-l0yerj"&&(j.innerHTML=Wl),$t=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-eo2v07"&&(B.textContent=Vl),Ht=n(e),$=p(e,"OL",{"data-svelte-h":!0}),o($)!=="svelte-8emskd"&&($.innerHTML=Xl),Gt=n(e),M(H.$$.fragment,e),Zt=n(e),w=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(w)!=="svelte-zeuxd7"&&(w.innerHTML=Ql),_t=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-iwney4"&&(G.innerHTML=El),Rt=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1xoupob"&&(Z.textContent=Yl),St=n(e),M(_.$$.fragment,e),Wt=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-hjt0h1"&&(R.innerHTML=Fl),Vt=n(e),f=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(f)!=="svelte-1cxy3tx"&&(f.innerHTML=Nl),Xt=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-vmhaok"&&(S.innerHTML=zl),Qt=n(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(g)!=="svelte-10s1rk5"&&(g.innerHTML=Pl),Et=n(e),M(W.$$.fragment,e),Yt=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-epfhsj"&&(V.textContent=Ll),Ft=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-n5dyw"&&(X.textContent=Dl),Nt=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-qm2nt8"&&(Q.innerHTML=Ol),zt=n(e),M(E.$$.fragment,e),Pt=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-aqaw0f"&&(Y.textContent=Kl),Lt=n(e),M(F.$$.fragment,e),Dt=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ccsiy1"&&(N.innerHTML=ea),Ot=n(e),M(z.$$.fragment,e),Kt=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-qutua8"&&(P.innerHTML=ta),es=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-uj5o95"&&(L.innerHTML=sa),ts=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1ozzcb1"&&(D.innerHTML=la),ss=n(e),M(O.$$.fragment,e),ls=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-dq2kwm"&&(K.innerHTML=aa),as=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-kajnqt"&&(ee.innerHTML=na),ns=n(e),M(te.$$.fragment,e),is=n(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1vjzmk"&&(se.textContent=ia),ps=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1147onl"&&(le.textContent=pa),os=n(e),I=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(I)!=="svelte-6sp0mg"&&(I.innerHTML=oa),rs=n(e),M(ae.$$.fragment,e),Ms=n(e),M(ne.$$.fragment,e),us=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-f1hll8"&&(ie.textContent=ra),cs=n(e),M(pe.$$.fragment,e),ys=n(e),oe=p(e,"UL",{"data-svelte-h":!0}),o(oe)!=="svelte-ul55gk"&&(oe.innerHTML=Ma),hs=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-khk897"&&(re.textContent=ua),ds=n(e),M(Me.$$.fragment,e),ms=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-1avk6lq"&&(ue.innerHTML=ca),Js=n(e),M(ce.$$.fragment,e),Ts=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-pwj71q"&&(ye.textContent=ya),Us=n(e),he=p(e,"UL",{"data-svelte-h":!0}),o(he)!=="svelte-gmdx7h"&&(he.innerHTML=ha),js=n(e),M(de.$$.fragment,e),ws=n(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1s9oaze"&&(me.innerHTML=da),fs=n(e),C=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(C)!=="svelte-1nwdy9v"&&(C.innerHTML=ma),gs=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-m8oll3"&&(Je.textContent=Ja),Is=n(e),M(Te.$$.fragment,e),Cs=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-f1hll8"&&(Ue.textContent=Ta),bs=n(e),M(je.$$.fragment,e),vs=n(e),we=p(e,"UL",{"data-svelte-h":!0}),o(we)!=="svelte-amxywc"&&(we.innerHTML=Ua),xs=n(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-khk897"&&(fe.textContent=ja),ks=n(e),M(ge.$$.fragment,e),As=n(e),M(Ie.$$.fragment,e),qs=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-1wwgzam"&&(Ce.innerHTML=wa),Bs=n(e),M(be.$$.fragment,e),$s=n(e),ve=p(e,"P",{"data-svelte-h":!0}),o(ve)!=="svelte-18yjufw"&&(ve.textContent=fa),Hs=n(e),M(xe.$$.fragment,e),Gs=n(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1ar1qn2"&&(ke.textContent=ga),Zs=n(e),M(Ae.$$.fragment,e),_s=n(e),qe=p(e,"P",{"data-svelte-h":!0}),o(qe)!=="svelte-1wwgzam"&&(qe.innerHTML=Ia),Rs=n(e),M(Be.$$.fragment,e),Ss=n(e),M($e.$$.fragment,e),Ws=n(e),He=p(e,"P",{"data-svelte-h":!0}),o(He)!=="svelte-16sv3hm"&&(He.textContent=Ca),Vs=n(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(b)!=="svelte-1tlxndq"&&(b.innerHTML=ba),Xs=n(e),Ge=p(e,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-1ovcz13"&&(Ge.textContent=va),Qs=n(e),M(Ze.$$.fragment,e),Es=n(e),M(_e.$$.fragment,e),Ys=n(e),Re=p(e,"P",{"data-svelte-h":!0}),o(Re)!=="svelte-aop9q6"&&(Re.textContent=xa),Fs=n(e),Se=p(e,"P",{"data-svelte-h":!0}),o(Se)!=="svelte-11lkosy"&&(Se.textContent=ka),Ns=n(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(v)!=="svelte-32c4s1"&&(v.innerHTML=Aa),zs=n(e),We=p(e,"P",{"data-svelte-h":!0}),o(We)!=="svelte-1s4io98"&&(We.textContent=qa),Ps=n(e),Ve=p(e,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-2tk9q6"&&(Ve.textContent=Ba),Ls=n(e),Xe=p(e,"UL",{"data-svelte-h":!0}),o(Xe)!=="svelte-3d87kx"&&(Xe.innerHTML=$a),Ds=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-kzwdhh"&&(Qe.textContent=Ha),Os=n(e),Ee=p(e,"UL",{"data-svelte-h":!0}),o(Ee)!=="svelte-ao16pi"&&(Ee.innerHTML=Ga),Ks=n(e),Ye=p(e,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-1rp1v84"&&(Ye.textContent=Za),el=n(e),M(Fe.$$.fragment,e),tl=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-lf5sv5"&&(Ne.innerHTML=_a),sl=n(e),x=p(e,"DIV",{class:!0,"data-svelte-h":!0}),o(x)!=="svelte-1roilif"&&(x.innerHTML=Ra),ll=n(e),ze=p(e,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1072wo1"&&(ze.textContent=Sa),al=n(e),M(Pe.$$.fragment,e),nl=n(e),Le=p(e,"P",{"data-svelte-h":!0}),o(Le)!=="svelte-ogq2gt"&&(Le.textContent=Wa),il=n(e),M(De.$$.fragment,e),pl=n(e),Oe=p(e,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-krncuc"&&(Oe.textContent=Va),ol=n(e),M(Ke.$$.fragment,e),rl=n(e),M(et.$$.fragment,e),Ml=n(e),tt=p(e,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-bpbibl"&&(tt.innerHTML=Xa),ul=n(e),M(st.$$.fragment,e),cl=n(e),lt=p(e,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-speu7d"&&(lt.textContent=Qa),yl=n(e),at=p(e,"P",{"data-svelte-h":!0}),o(at)!=="svelte-13ler1d"&&(at.innerHTML=Ea),hl=n(e),nt=p(e,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-ub059v"&&(nt.innerHTML=Ya),dl=n(e),M(it.$$.fragment,e),ml=n(e),M(pt.$$.fragment,e),Jl=n(e),k=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-yl0e6m"&&(k.innerHTML=Fa),Tl=n(e),M(ot.$$.fragment,e),Ul=n(e),rt=p(e,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-102eqn3"&&(rt.innerHTML=Na),jl=n(e),Mt=p(e,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-lavds"&&(Mt.innerHTML=za),wl=n(e),ut=p(e,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-f0qt8k"&&(ut.textContent=Pa),fl=n(e),ct=p(e,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-w9ft7n"&&(ct.textContent=La),gl=n(e),M(yt.$$.fragment,e),Il=n(e),M(ht.$$.fragment,e),Cl=n(e),dt=p(e,"UL",{"data-svelte-h":!0}),o(dt)!=="svelte-117ozzs"&&(dt.innerHTML=Da),bl=n(e),M(mt.$$.fragment,e),vl=n(e),Jt=p(e,"UL",{"data-svelte-h":!0}),o(Jt)!=="svelte-vl7c7p"&&(Jt.innerHTML=Oa),xl=n(e),M(Tt.$$.fragment,e),kl=n(e),Ut=p(e,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-ccionj"&&(Ut.textContent=Ka),Al=n(e),jt=p(e,"P",{"data-svelte-h":!0}),o(jt)!=="svelte-1dt3smc"&&(jt.textContent=en),ql=n(e),wt=p(e,"UL",{"data-svelte-h":!0}),o(wt)!=="svelte-1lgvq31"&&(wt.innerHTML=tn),Bl=n(e),M(ft.$$.fragment,e),$l=n(e),gt=p(e,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1yfr1yr"&&(gt.innerHTML=sn),Hl=n(e),It=p(e,"P",{"data-svelte-h":!0}),o(It)!=="svelte-1duzsqa"&&(It.innerHTML=ln),Gl=n(e),M(Ct.$$.fragment,e),Zl=n(e),vt=p(e,"P",{}),an(vt).forEach(s),this.h()},h(){J(T,"name","hf:doc:metadata"),J(T,"content",mn),J(U,"class","tip"),J(j,"class","warning"),J(w,"class","tip"),J(f,"class","flex justify-center"),J(g,"class","tip"),J(I,"class","tip"),J(C,"class","tip"),J(b,"class","warning"),J(v,"class","flex justify-center"),J(x,"class","flex justify-center"),J(k,"class","tip")},m(e,t){cn(document.head,T),l(e,xt,t),l(e,bt,t),l(e,kt,t),u(A,e,t),l(e,At,t),u(q,e,t),l(e,qt,t),l(e,U,t),l(e,Bt,t),l(e,j,t),l(e,$t,t),l(e,B,t),l(e,Ht,t),l(e,$,t),l(e,Gt,t),u(H,e,t),l(e,Zt,t),l(e,w,t),l(e,_t,t),l(e,G,t),l(e,Rt,t),l(e,Z,t),l(e,St,t),u(_,e,t),l(e,Wt,t),l(e,R,t),l(e,Vt,t),l(e,f,t),l(e,Xt,t),l(e,S,t),l(e,Qt,t),l(e,g,t),l(e,Et,t),u(W,e,t),l(e,Yt,t),l(e,V,t),l(e,Ft,t),l(e,X,t),l(e,Nt,t),l(e,Q,t),l(e,zt,t),u(E,e,t),l(e,Pt,t),l(e,Y,t),l(e,Lt,t),u(F,e,t),l(e,Dt,t),l(e,N,t),l(e,Ot,t),u(z,e,t),l(e,Kt,t),l(e,P,t),l(e,es,t),l(e,L,t),l(e,ts,t),l(e,D,t),l(e,ss,t),u(O,e,t),l(e,ls,t),l(e,K,t),l(e,as,t),l(e,ee,t),l(e,ns,t),u(te,e,t),l(e,is,t),l(e,se,t),l(e,ps,t),l(e,le,t),l(e,os,t),l(e,I,t),l(e,rs,t),u(ae,e,t),l(e,Ms,t),u(ne,e,t),l(e,us,t),l(e,ie,t),l(e,cs,t),u(pe,e,t),l(e,ys,t),l(e,oe,t),l(e,hs,t),l(e,re,t),l(e,ds,t),u(Me,e,t),l(e,ms,t),l(e,ue,t),l(e,Js,t),u(ce,e,t),l(e,Ts,t),l(e,ye,t),l(e,Us,t),l(e,he,t),l(e,js,t),u(de,e,t),l(e,ws,t),l(e,me,t),l(e,fs,t),l(e,C,t),l(e,gs,t),l(e,Je,t),l(e,Is,t),u(Te,e,t),l(e,Cs,t),l(e,Ue,t),l(e,bs,t),u(je,e,t),l(e,vs,t),l(e,we,t),l(e,xs,t),l(e,fe,t),l(e,ks,t),u(ge,e,t),l(e,As,t),u(Ie,e,t),l(e,qs,t),l(e,Ce,t),l(e,Bs,t),u(be,e,t),l(e,$s,t),l(e,ve,t),l(e,Hs,t),u(xe,e,t),l(e,Gs,t),l(e,ke,t),l(e,Zs,t),u(Ae,e,t),l(e,_s,t),l(e,qe,t),l(e,Rs,t),u(Be,e,t),l(e,Ss,t),u($e,e,t),l(e,Ws,t),l(e,He,t),l(e,Vs,t),l(e,b,t),l(e,Xs,t),l(e,Ge,t),l(e,Qs,t),u(Ze,e,t),l(e,Es,t),u(_e,e,t),l(e,Ys,t),l(e,Re,t),l(e,Fs,t),l(e,Se,t),l(e,Ns,t),l(e,v,t),l(e,zs,t),l(e,We,t),l(e,Ps,t),l(e,Ve,t),l(e,Ls,t),l(e,Xe,t),l(e,Ds,t),l(e,Qe,t),l(e,Os,t),l(e,Ee,t),l(e,Ks,t),l(e,Ye,t),l(e,el,t),u(Fe,e,t),l(e,tl,t),l(e,Ne,t),l(e,sl,t),l(e,x,t),l(e,ll,t),l(e,ze,t),l(e,al,t),u(Pe,e,t),l(e,nl,t),l(e,Le,t),l(e,il,t),u(De,e,t),l(e,pl,t),l(e,Oe,t),l(e,ol,t),u(Ke,e,t),l(e,rl,t),u(et,e,t),l(e,Ml,t),l(e,tt,t),l(e,ul,t),u(st,e,t),l(e,cl,t),l(e,lt,t),l(e,yl,t),l(e,at,t),l(e,hl,t),l(e,nt,t),l(e,dl,t),u(it,e,t),l(e,ml,t),u(pt,e,t),l(e,Jl,t),l(e,k,t),l(e,Tl,t),u(ot,e,t),l(e,Ul,t),l(e,rt,t),l(e,jl,t),l(e,Mt,t),l(e,wl,t),l(e,ut,t),l(e,fl,t),l(e,ct,t),l(e,gl,t),u(yt,e,t),l(e,Il,t),u(ht,e,t),l(e,Cl,t),l(e,dt,t),l(e,bl,t),u(mt,e,t),l(e,vl,t),l(e,Jt,t),l(e,xl,t),u(Tt,e,t),l(e,kl,t),l(e,Ut,t),l(e,Al,t),l(e,jt,t),l(e,ql,t),l(e,wt,t),l(e,Bl,t),u(ft,e,t),l(e,$l,t),l(e,gt,t),l(e,Hl,t),l(e,It,t),l(e,Gl,t),u(Ct,e,t),l(e,Zl,t),l(e,vt,t),_l=!0},p:pn,i(e){_l||(c(A.$$.fragment,e),c(q.$$.fragment,e),c(H.$$.fragment,e),c(_.$$.fragment,e),c(W.$$.fragment,e),c(E.$$.fragment,e),c(F.$$.fragment,e),c(z.$$.fragment,e),c(O.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(ne.$$.fragment,e),c(pe.$$.fragment,e),c(Me.$$.fragment,e),c(ce.$$.fragment,e),c(de.$$.fragment,e),c(Te.$$.fragment,e),c(je.$$.fragment,e),c(ge.$$.fragment,e),c(Ie.$$.fragment,e),c(be.$$.fragment,e),c(xe.$$.fragment,e),c(Ae.$$.fragment,e),c(Be.$$.fragment,e),c($e.$$.fragment,e),c(Ze.$$.fragment,e),c(_e.$$.fragment,e),c(Fe.$$.fragment,e),c(Pe.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(st.$$.fragment,e),c(it.$$.fragment,e),c(pt.$$.fragment,e),c(ot.$$.fragment,e),c(yt.$$.fragment,e),c(ht.$$.fragment,e),c(mt.$$.fragment,e),c(Tt.$$.fragment,e),c(ft.$$.fragment,e),c(Ct.$$.fragment,e),_l=!0)},o(e){y(A.$$.fragment,e),y(q.$$.fragment,e),y(H.$$.fragment,e),y(_.$$.fragment,e),y(W.$$.fragment,e),y(E.$$.fragment,e),y(F.$$.fragment,e),y(z.$$.fragment,e),y(O.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(Me.$$.fragment,e),y(ce.$$.fragment,e),y(de.$$.fragment,e),y(Te.$$.fragment,e),y(je.$$.fragment,e),y(ge.$$.fragment,e),y(Ie.$$.fragment,e),y(be.$$.fragment,e),y(xe.$$.fragment,e),y(Ae.$$.fragment,e),y(Be.$$.fragment,e),y($e.$$.fragment,e),y(Ze.$$.fragment,e),y(_e.$$.fragment,e),y(Fe.$$.fragment,e),y(Pe.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(st.$$.fragment,e),y(it.$$.fragment,e),y(pt.$$.fragment,e),y(ot.$$.fragment,e),y(yt.$$.fragment,e),y(ht.$$.fragment,e),y(mt.$$.fragment,e),y(Tt.$$.fragment,e),y(ft.$$.fragment,e),y(Ct.$$.fragment,e),_l=!1},d(e){e&&(s(xt),s(bt),s(kt),s(At),s(qt),s(U),s(Bt),s(j),s($t),s(B),s(Ht),s($),s(Gt),s(Zt),s(w),s(_t),s(G),s(Rt),s(Z),s(St),s(Wt),s(R),s(Vt),s(f),s(Xt),s(S),s(Qt),s(g),s(Et),s(Yt),s(V),s(Ft),s(X),s(Nt),s(Q),s(zt),s(Pt),s(Y),s(Lt),s(Dt),s(N),s(Ot),s(Kt),s(P),s(es),s(L),s(ts),s(D),s(ss),s(ls),s(K),s(as),s(ee),s(ns),s(is),s(se),s(ps),s(le),s(os),s(I),s(rs),s(Ms),s(us),s(ie),s(cs),s(ys),s(oe),s(hs),s(re),s(ds),s(ms),s(ue),s(Js),s(Ts),s(ye),s(Us),s(he),s(js),s(ws),s(me),s(fs),s(C),s(gs),s(Je),s(Is),s(Cs),s(Ue),s(bs),s(vs),s(we),s(xs),s(fe),s(ks),s(As),s(qs),s(Ce),s(Bs),s($s),s(ve),s(Hs),s(Gs),s(ke),s(Zs),s(_s),s(qe),s(Rs),s(Ss),s(Ws),s(He),s(Vs),s(b),s(Xs),s(Ge),s(Qs),s(Es),s(Ys),s(Re),s(Fs),s(Se),s(Ns),s(v),s(zs),s(We),s(Ps),s(Ve),s(Ls),s(Xe),s(Ds),s(Qe),s(Os),s(Ee),s(Ks),s(Ye),s(el),s(tl),s(Ne),s(sl),s(x),s(ll),s(ze),s(al),s(nl),s(Le),s(il),s(pl),s(Oe),s(ol),s(rl),s(Ml),s(tt),s(ul),s(cl),s(lt),s(yl),s(at),s(hl),s(nt),s(dl),s(ml),s(Jl),s(k),s(Tl),s(Ul),s(rt),s(jl),s(Mt),s(wl),s(ut),s(fl),s(ct),s(gl),s(Il),s(Cl),s(dt),s(bl),s(vl),s(Jt),s(xl),s(kl),s(Ut),s(Al),s(jt),s(ql),s(wt),s(Bl),s($l),s(gt),s(Hl),s(It),s(Gl),s(Zl),s(vt)),s(T),h(A,e),h(q,e),h(H,e),h(_,e),h(W,e),h(E,e),h(F,e),h(z,e),h(O,e),h(te,e),h(ae,e),h(ne,e),h(pe,e),h(Me,e),h(ce,e),h(de,e),h(Te,e),h(je,e),h(ge,e),h(Ie,e),h(be,e),h(xe,e),h(Ae,e),h(Be,e),h($e,e),h(Ze,e),h(_e,e),h(Fe,e),h(Pe,e),h(De,e),h(Ke,e),h(et,e),h(st,e),h(it,e),h(pt,e),h(ot,e),h(yt,e),h(ht,e),h(mt,e),h(Tt,e),h(ft,e),h(Ct,e)}}}const mn='{"title":"How to be registered as an inference provider on the Hub?","local":"how-to-be-registered-as-an-inference-provider-on-the-hub","sections":[{"title":"1. Prerequisites","local":"1-prerequisites","sections":[{"title":"What is a Task","local":"what-is-a-task","sections":[],"depth":3},{"title":"Task API schema","local":"task-api-schema","sections":[],"depth":3}],"depth":2},{"title":"2. JS Client Integration","local":"2-js-client-integration","sections":[{"title":"Implement the provider helper (JS)","local":"implement-the-provider-helper-js","sections":[],"depth":3},{"title":"Register the provider","local":"register-the-provider","sections":[],"depth":3}],"depth":2},{"title":"3. Model Mapping API","local":"3-model-mapping-api","sections":[{"title":"Register a mapping item","local":"register-a-mapping-item","sections":[{"title":"Authentication","local":"authentication","sections":[],"depth":4},{"title":"Validation","local":"validation","sections":[],"depth":4}],"depth":3},{"title":"Using a tag-filter to map several HF models to a single inference endpoint","local":"using-a-tag-filter-to-map-several-hf-models-to-a-single-inference-endpoint","sections":[],"depth":3},{"title":"Delete a mapping item","local":"delete-a-mapping-item","sections":[],"depth":3},{"title":"Update a mapping item’s status","local":"update-a-mapping-items-status","sections":[],"depth":3},{"title":"List the whole mapping","local":"list-the-whole-mapping","sections":[],"depth":3},{"title":"Automatic validation","local":"automatic-validation","sections":[],"depth":3}],"depth":2},{"title":"4. Billing","local":"4-billing","sections":[{"title":"HTTP API Specs","local":"http-api-specs","sections":[],"depth":3},{"title":"Price Unit","local":"price-unit","sections":[],"depth":3},{"title":"How to define the request ID","local":"how-to-define-the-request-id","sections":[],"depth":3}],"depth":2},{"title":"5. Python client integration","local":"5-python-client-integration","sections":[{"title":"Implement the provider helper (Python)","local":"implement-the-provider-helper-python","sections":[],"depth":3},{"title":"Register the Provider","local":"register-the-provider","sections":[],"depth":3},{"title":"Add tests","local":"add-tests","sections":[],"depth":3}],"depth":2},{"title":"6. Add provider documentation","local":"6-add-provider-documentation","sections":[],"depth":2},{"title":"FAQ","local":"faq","sections":[],"depth":2}],"depth":1}';function Jn(Rl){return on(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gn extends rn{constructor(T){super(),Mn(this,T,Jn,dn,nn,{})}}export{gn as component};
