import{s as Gt,o as Ct,n as vt}from"../chunks/scheduler.8c3d61f6.js";import{S as Xt,i as Qt,g as i,s as a,r as M,A as _t,h as o,f as t,c as n,j as El,u as y,x as p,k as w,y as Fl,a as s,v as r,d,t as c,w as m}from"../chunks/index.da70eac4.js";import{T as Vt}from"../chunks/Tip.6f698f24.js";import{C as J}from"../chunks/CodeBlock.a9c4becf.js";import{D as Rt}from"../chunks/DocNotebookDropdown.48852948.js";import{H as ve,E as Yt}from"../chunks/getInferenceSnippets.cb466318.js";function Ht(Qe){let u,k='If your favorite pipeline doesn’t have a <code>prompt_embeds</code> parameter, please open an <a href="https://github.com/huggingface/diffusers/issues/new/choose" rel="nofollow">issue</a> so we can add it!';return{c(){u=i("p"),u.innerHTML=k},l(h){u=o(h,"P",{"data-svelte-h":!0}),p(u)!=="svelte-nya19q"&&(u.innerHTML=k)},m(h,Ge){s(h,u,Ge)},p:vt,d(h){h&&t(u)}}}function xt(Qe){let u,k,h,Ge,G,_e,C,Ve,v,$l="Prompts are important because they describe what you want a diffusion model to generate. The best prompts are detailed, specific, and well-structured to help the model realize your vision. But crafting a great prompt takes time and effort and sometimes it may not be enough because language and words can be imprecise. This is where you need to boost your prompt with other techniques, such as prompt enhancing and prompt weighting, to get the results you want.",Re,X,Al="This guide will show you how you can use these prompt techniques to generate high-quality images with lower effort and adjust the weight of certain keywords in a prompt.",Ye,Q,He,U,Dl="<p>This is not an exhaustive guide on prompt engineering, but it will help you understand the necessary parts of a good prompt. We encourage you to continue experimenting with different prompts and combine them in new ways to see what works best. As you write more prompts, you’ll develop an intuition for what works and what doesn’t!</p>",xe,_,Ll="New diffusion models do a pretty good job of generating high-quality images from a basic prompt, but it is still important to create a well-written prompt to get the best results. Here are a few tips for writing a good prompt:",qe,V,Pl="<li>What is the image <em>medium</em>? Is it a photo, a painting, a 3D illustration, or something else?</li> <li>What is the image <em>subject</em>? Is it a person, animal, object, or scene?</li> <li>What <em>details</em> would you like to see in the image? This is where you can get really creative and have a lot of fun experimenting with different words to bring your image to life. For example, what is the lighting like? What is the vibe and aesthetic? What kind of art or illustration style are you looking for? The more specific and precise words you use, the better the model will understand what you want to generate.</li>",Se,T,Kl='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/plain-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A photo of a banana-shaped couch in a living room&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/detail-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;A vibrant yellow banana-shaped couch sits in a cozy living room, its curve cradling a pile of colorful cushions. on the wooden floor, a patterned rug adds a touch of eclectic charm, and a potted plant sits in the corner, reaching towards the sunlight filtering through the windows&quot;</figcaption></div>',Ne,R,ze,Y,Ol="Prompt enhancing is a technique for quickly improving prompt quality without spending too much effort constructing one. It uses a model like GPT2 pretrained on Stable Diffusion text prompts to automatically enrich a prompt with additional important keywords to generate high-quality images.",Ee,H,et="The technique works by curating a list of specific keywords and forcing the model to generate those words to enhance the original prompt. This way, your prompt can be “a cat” and GPT2 can enhance the prompt to “cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic”.",Fe,j,lt='<p>You should also use a <a href="https://www.crosslabs.org//blog/diffusion-with-offset-noise" rel="nofollow"><em>offset noise</em></a> LoRA to improve the contrast in bright and dark images and create better lighting overall. This <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/blob/main/sd_xl_offset_example-lora_1.0.safetensors" rel="nofollow">LoRA</a> is available from <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a>.</p>',$e,x,tt='Start by defining certain styles and a list of words (you can check out a more comprehensive list of <a href="https://hf.co/LykosAI/GPT-Prompt-Expansion-Fooocus-v2/blob/main/positive.txt" rel="nofollow">words</a> and <a href="https://github.com/lllyasviel/Fooocus/tree/main/sdxl_styles" rel="nofollow">styles</a> used by Fooocus) to enhance a prompt with.',Ae,q,De,S,st="You may have noticed in the <code>words</code> list, there are certain words that can be paired together to create something more meaningful. For example, the words “high” and “quality” can be combined to create “high quality”. Let’s pair these words together and remove the words that can’t be paired.",Le,N,Pe,z,at='Next, implement a custom <a href="https://huggingface.co/docs/transformers/main/en/internal/generation_utils#transformers.LogitsProcessor" rel="nofollow">LogitsProcessor</a> class that assigns tokens in the <code>words</code> list a value of 0 and assigns tokens not in the <code>words</code> list a negative value so they aren’t picked during generation. This way, generation is biased towards words in the <code>words</code> list. After a word from the list is used, it is also assigned a negative value so it isn’t picked again.',Ke,E,Oe,F,nt="Combine the prompt and the <code>cinematic</code> style prompt defined in the <code>styles</code> dictionary earlier.",el,$,ll,A,it='Load a GPT2 tokenizer and model from the <a href="https://huggingface.co/Gustavosta/MagicPrompt-Stable-Diffusion" rel="nofollow">Gustavosta/MagicPrompt-Stable-Diffusion</a> checkpoint (this specific checkpoint is trained to generate prompts) to enhance the prompt.',tl,D,sl,L,ot="Then you can combine the input prompt and the generated prompt. Feel free to take a look at what the generated prompt (<code>generated_part</code>) is, the word pairs that were found (<code>pairs</code>), and the remaining words (<code>words</code>). This is all packed together in the <code>enhanced_prompt</code>.",al,P,nl,K,pt="Finally, load a pipeline and the offset noise LoRA with a <em>low weight</em> to generate an image with the enhanced prompt.",il,O,ol,f,Mt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;a cat basking in the sun on a roof in Turkey&quot;</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/enhanced-prompt.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</figcaption></div>',pl,ee,Ml,le,yt='Prompt weighting provides a way to emphasize or de-emphasize certain parts of a prompt, allowing for more control over the generated image. A prompt can include several concepts, which gets turned into contextualized text embeddings. The embeddings are used by the model to condition its cross-attention layers to generate an image (read the Stable Diffusion <a href="https://huggingface.co/blog/stable_diffusion" rel="nofollow">blog post</a> to learn more about how it works).',yl,te,rt='Prompt weighting works by increasing or decreasing the scale of the text embedding vector that corresponds to its concept in the prompt because you may not necessarily want the model to focus on all concepts equally. The easiest way to prepare the prompt embeddings is to use <a href="https://github.com/xhinker/sd_embed" rel="nofollow">Stable Diffusion Long Prompt Weighted Embedding</a> (sd_embed). Once you have the prompt-weighted embeddings, you can pass them to any pipeline that has a <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.prompt_embeds" rel="nofollow">prompt_embeds</a> (and optionally <a href="https://huggingface.co/docs/diffusers/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds" rel="nofollow">negative_prompt_embeds</a>) parameter, such as <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>, and <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',rl,g,dl,se,dt="This guide will show you how to weight your prompts with sd_embed.",cl,ae,ct="Before you begin, make sure you have the latest version of sd_embed installed:",ml,ne,ul,ie,mt='For this example, let’s use <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Jl,oe,hl,pe,ut="To upweight or downweight a concept, surround the text with parentheses. More parentheses applies a heavier weight on the text. You can also append a numerical multiplier to the text to indicate how much you want to increase or decrease its weights by.",wl,Me,Jt="<thead><tr><th>format</th> <th>multiplier</th></tr></thead> <tbody><tr><td><code>(hippo)</code></td> <td>increase by 1.1x</td></tr> <tr><td><code>((hippo))</code></td> <td>increase by 1.21x</td></tr> <tr><td><code>(hippo:1.5)</code></td> <td>increase by 1.5x</td></tr> <tr><td><code>(hippo:0.5)</code></td> <td>decrease by 4x</td></tr></tbody>",bl,ye,ht="Create a prompt and use a combination of parentheses and numerical multipliers to upweight various text.",Ul,re,Tl,de,wt="Use the <code>get_weighted_text_embeddings_sdxl</code> function to generate the prompt embeddings and the negative prompt embeddings. It’ll also generated the pooled and negative pooled prompt embeddings since you’re using the SDXL model.",jl,b,Ce,bt="You can safely ignore the error message below about the token index length exceeding the models maximum sequence length. All your tokens will be used in the embedding process.",zl,ce,fl,me,gl,I,Ut='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_sdxl.png"/>',Il,Z,Tt='<p>Refer to the <a href="https://github.com/xhinker/sd_embed" rel="nofollow">sd_embed</a> repository for additional details about long prompt weighting for FLUX.1, Stable Cascade, and Stable Diffusion 1.5.</p>',Zl,ue,Wl,Je,jt='<a href="../training/text_inversion">Textual inversion</a> is a technique for learning a specific concept from some images which you can use to generate new images conditioned on that concept.',Bl,he,ft='Create a pipeline and use the <a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> function to load the textual inversion embeddings (feel free to browse the <a href="https://huggingface.co/spaces/sd-concepts-library/stable-diffusion-conceptualizer" rel="nofollow">Stable Diffusion Conceptualizer</a> for 100+ trained concepts):',kl,we,Gl,be,gt="Add the <code>&lt;midjourney-style&gt;</code> text to the prompt to trigger the textual inversion.",Cl,Ue,vl,Te,It="Use the <code>get_weighted_text_embeddings_sd15</code> function to generate the prompt embeddings and the negative prompt embeddings.",Xl,je,Ql,W,Zt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_textual_inversion.png"/>',_l,fe,Vl,ge,Wt='<a href="../training/dreambooth">DreamBooth</a> is a technique for generating contextualized images of a subject given just a few images of the subject to train on. It is similar to textual inversion, but DreamBooth trains the full model whereas textual inversion only fine-tunes the text embeddings. This means you should use <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to load the DreamBooth model (feel free to browse the <a href="https://huggingface.co/sd-dreambooth-library" rel="nofollow">Stable Diffusion Dreambooth Concepts Library</a> for 100+ trained models):',Rl,Ie,Yl,Ze,Bt="Depending on the model you use, you’ll need to incorporate the model’s unique identifier into your prompt. For example, the <code>dndcoverart-v1</code> model uses the identifier <code>dndcoverart</code>:",Hl,We,xl,B,kt='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sd_embed_dreambooth.png"/>',ql,Be,Sl,Xe,Nl;return G=new ve({props:{title:"Prompt techniques",local:"prompt-techniques",headingTag:"h1"}}),C=new Rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/weighted_prompts.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/weighted_prompts.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/weighted_prompts.ipynb"}]}}),Q=new ve({props:{title:"Prompt engineering",local:"prompt-engineering",headingTag:"h2"}}),R=new ve({props:{title:"Prompt enhancing with GPT2",local:"prompt-enhancing-with-gpt2",headingTag:"h2"}}),q=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig, GPT2LMHeadModel, GPT2Tokenizer, LogitsProcessor, LogitsProcessorList
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

styles = {
    <span class="hljs-string">&quot;cinematic&quot;</span>: <span class="hljs-string">&quot;cinematic film still of {prompt}, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>,
    <span class="hljs-string">&quot;anime&quot;</span>: <span class="hljs-string">&quot;anime artwork of {prompt}, anime style, key visual, vibrant, studio anime, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;photographic&quot;</span>: <span class="hljs-string">&quot;cinematic photo of {prompt}, 35mm photograph, film, professional, 4k, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;comic&quot;</span>: <span class="hljs-string">&quot;comic of {prompt}, graphic illustration, comic art, graphic novel art, vibrant, highly detailed&quot;</span>,
    <span class="hljs-string">&quot;lineart&quot;</span>: <span class="hljs-string">&quot;line art drawing {prompt}, professional, sleek, modern, minimalist, graphic, line art, vector graphics&quot;</span>,
    <span class="hljs-string">&quot;pixelart&quot;</span>: <span class="hljs-string">&quot; pixel-art {prompt}, low-res, blocky, pixel art style, 8-bit graphics&quot;</span>,
}

words = [
    <span class="hljs-string">&quot;aesthetic&quot;</span>, <span class="hljs-string">&quot;astonishing&quot;</span>, <span class="hljs-string">&quot;beautiful&quot;</span>, <span class="hljs-string">&quot;breathtaking&quot;</span>, <span class="hljs-string">&quot;composition&quot;</span>, <span class="hljs-string">&quot;contrasted&quot;</span>, <span class="hljs-string">&quot;epic&quot;</span>, <span class="hljs-string">&quot;moody&quot;</span>, <span class="hljs-string">&quot;enhanced&quot;</span>,
    <span class="hljs-string">&quot;exceptional&quot;</span>, <span class="hljs-string">&quot;fascinating&quot;</span>, <span class="hljs-string">&quot;flawless&quot;</span>, <span class="hljs-string">&quot;glamorous&quot;</span>, <span class="hljs-string">&quot;glorious&quot;</span>, <span class="hljs-string">&quot;illumination&quot;</span>, <span class="hljs-string">&quot;impressive&quot;</span>, <span class="hljs-string">&quot;improved&quot;</span>,
    <span class="hljs-string">&quot;inspirational&quot;</span>, <span class="hljs-string">&quot;magnificent&quot;</span>, <span class="hljs-string">&quot;majestic&quot;</span>, <span class="hljs-string">&quot;hyperrealistic&quot;</span>, <span class="hljs-string">&quot;smooth&quot;</span>, <span class="hljs-string">&quot;sharp&quot;</span>, <span class="hljs-string">&quot;focus&quot;</span>, <span class="hljs-string">&quot;stunning&quot;</span>, <span class="hljs-string">&quot;detailed&quot;</span>,
    <span class="hljs-string">&quot;intricate&quot;</span>, <span class="hljs-string">&quot;dramatic&quot;</span>, <span class="hljs-string">&quot;high&quot;</span>, <span class="hljs-string">&quot;quality&quot;</span>, <span class="hljs-string">&quot;perfect&quot;</span>, <span class="hljs-string">&quot;light&quot;</span>, <span class="hljs-string">&quot;ultra&quot;</span>, <span class="hljs-string">&quot;highly&quot;</span>, <span class="hljs-string">&quot;radiant&quot;</span>, <span class="hljs-string">&quot;satisfying&quot;</span>,
    <span class="hljs-string">&quot;soothing&quot;</span>, <span class="hljs-string">&quot;sophisticated&quot;</span>, <span class="hljs-string">&quot;stylish&quot;</span>, <span class="hljs-string">&quot;sublime&quot;</span>, <span class="hljs-string">&quot;terrific&quot;</span>, <span class="hljs-string">&quot;touching&quot;</span>, <span class="hljs-string">&quot;timeless&quot;</span>, <span class="hljs-string">&quot;wonderful&quot;</span>, <span class="hljs-string">&quot;unbelievable&quot;</span>,
    <span class="hljs-string">&quot;elegant&quot;</span>, <span class="hljs-string">&quot;awesome&quot;</span>, <span class="hljs-string">&quot;amazing&quot;</span>, <span class="hljs-string">&quot;dynamic&quot;</span>, <span class="hljs-string">&quot;trendy&quot;</span>,
]`,wrap:!1}}),N=new J({props:{code:"d29yZF9wYWlycyUyMCUzRCUyMCU1QiUyMmhpZ2hseSUyMGRldGFpbGVkJTIyJTJDJTIwJTIyaGlnaCUyMHF1YWxpdHklMjIlMkMlMjAlMjJlbmhhbmNlZCUyMHF1YWxpdHklMjIlMkMlMjAlMjJwZXJmZWN0JTIwY29tcG9zaXRpb24lMjIlMkMlMjAlMjJkeW5hbWljJTIwbGlnaHQlMjIlNUQlMEElMEFkZWYlMjBmaW5kX2FuZF9vcmRlcl9wYWlycyhzJTJDJTIwcGFpcnMpJTNBJTBBJTIwJTIwJTIwJTIwd29yZHMlMjAlM0QlMjBzLnNwbGl0KCklMEElMjAlMjAlMjAlMjBmb3VuZF9wYWlycyUyMCUzRCUyMCU1QiU1RCUwQSUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFpcl93b3JkcyUyMCUzRCUyMHBhaXIuc3BsaXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwcGFpcl93b3JkcyU1QjAlNUQlMjBpbiUyMHdvcmRzJTIwYW5kJTIwcGFpcl93b3JkcyU1QjElNUQlMjBpbiUyMHdvcmRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmRfcGFpcnMuYXBwZW5kKHBhaXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd29yZHMucmVtb3ZlKHBhaXJfd29yZHMlNUIwJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdvcmRzLnJlbW92ZShwYWlyX3dvcmRzJTVCMSU1RCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjB3b3JkJTIwaW4lMjB3b3JkcyU1QiUzQSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMHBhaXIlMjBpbiUyMHBhaXJzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjB3b3JkJTIwaW4lMjBwYWlyLnNwbGl0KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3b3Jkcy5yZW1vdmUod29yZCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBicmVhayUwQSUyMCUyMCUyMCUyMG9yZGVyZWRfcGFpcnMlMjAlM0QlMjAlMjIlMkMlMjAlMjIuam9pbihmb3VuZF9wYWlycyklMEElMjAlMjAlMjAlMjByZW1haW5pbmdfcyUyMCUzRCUyMCUyMiUyQyUyMCUyMi5qb2luKHdvcmRzKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9yZGVyZWRfcGFpcnMlMkMlMjByZW1haW5pbmdfcw==",highlighted:`word_pairs = [<span class="hljs-string">&quot;highly detailed&quot;</span>, <span class="hljs-string">&quot;high quality&quot;</span>, <span class="hljs-string">&quot;enhanced quality&quot;</span>, <span class="hljs-string">&quot;perfect composition&quot;</span>, <span class="hljs-string">&quot;dynamic light&quot;</span>]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">find_and_order_pairs</span>(<span class="hljs-params">s, pairs</span>):
    words = s.split()
    found_pairs = []
    <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
        pair_words = pair.split()
        <span class="hljs-keyword">if</span> pair_words[<span class="hljs-number">0</span>] <span class="hljs-keyword">in</span> words <span class="hljs-keyword">and</span> pair_words[<span class="hljs-number">1</span>] <span class="hljs-keyword">in</span> words:
            found_pairs.append(pair)
            words.remove(pair_words[<span class="hljs-number">0</span>])
            words.remove(pair_words[<span class="hljs-number">1</span>])

    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words[:]:
        <span class="hljs-keyword">for</span> pair <span class="hljs-keyword">in</span> pairs:
            <span class="hljs-keyword">if</span> word <span class="hljs-keyword">in</span> pair.split():
                words.remove(word)
                <span class="hljs-keyword">break</span>
    ordered_pairs = <span class="hljs-string">&quot;, &quot;</span>.join(found_pairs)
    remaining_s = <span class="hljs-string">&quot;, &quot;</span>.join(words)
    <span class="hljs-keyword">return</span> ordered_pairs, remaining_s`,wrap:!1}}),E=new J({props:{code:"Y2xhc3MlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoTG9naXRzUHJvY2Vzc29yKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBiaWFzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyUyMCUzRCUyMGJpYXMlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwaW5wdXRfaWRzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwbGVuKGlucHV0X2lkcy5zaGFwZSklMjAlM0QlM0QlMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFzdF90b2tlbl9pZCUyMCUzRCUyMGlucHV0X2lkcyU1QjAlMkMlMjAtMSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuYmlhcyU1Qmxhc3RfdG9rZW5faWQlNUQlMjAlM0QlMjAtMWUxMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNjb3JlcyUyMCUyQiUyMHNlbGYuYmlhcyUwQSUwQXdvcmRfaWRzJTIwJTNEJTIwJTVCdG9rZW5pemVyLmVuY29kZSh3b3JkJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTVCMCU1RCUyMGZvciUyMHdvcmQlMjBpbiUyMHdvcmRzJTVEJTBBYmlhcyUyMCUzRCUyMHRvcmNoLmZ1bGwoKHRva2VuaXplci52b2NhYl9zaXplJTJDKSUyQyUyMC1mbG9hdCglMjJJbmYlMjIpKS50byglMjJjdWRhJTIyKSUwQWJpYXMlNUJ3b3JkX2lkcyU1RCUyMCUzRCUyMDAlMEFwcm9jZXNzb3IlMjAlM0QlMjBDdXN0b21Mb2dpdHNQcm9jZXNzb3IoYmlhcyklMEFwcm9jZXNzb3JfbGlzdCUyMCUzRCUyMExvZ2l0c1Byb2Nlc3Nvckxpc3QoJTVCcHJvY2Vzc29yJTVEKQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomLogitsProcessor</span>(<span class="hljs-title class_ inherited__">LogitsProcessor</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, bias</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.bias = bias

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, input_ids, scores</span>):
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(input_ids.shape) == <span class="hljs-number">2</span>:
            last_token_id = input_ids[<span class="hljs-number">0</span>, -<span class="hljs-number">1</span>]
            self.bias[last_token_id] = -<span class="hljs-number">1e10</span>
        <span class="hljs-keyword">return</span> scores + self.bias

word_ids = [tokenizer.encode(word, add_prefix_space=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>] <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> words]
bias = torch.full((tokenizer.vocab_size,), -<span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;Inf&quot;</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
bias[word_ids] = <span class="hljs-number">0</span>
processor = CustomLogitsProcessor(bias)
processor_list = LogitsProcessorList([processor])`,wrap:!1}}),$=new J({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMGJhc2tpbmclMjBpbiUyMHRoZSUyMHN1biUyMG9uJTIwYSUyMHJvb2YlMjBpbiUyMFR1cmtleSUyMiUwQXN0eWxlJTIwJTNEJTIwJTIyY2luZW1hdGljJTIyJTBBJTBBcHJvbXB0JTIwJTNEJTIwc3R5bGVzJTVCc3R5bGUlNUQuZm9ybWF0KHByb21wdCUzRHByb21wdCklMEFwcm9tcHQlMEElMjJjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBiYXNraW5nJTIwaW4lMjB0aGUlMjBzdW4lMjBvbiUyMGElMjByb29mJTIwaW4lMjBUdXJrZXklMkMlMjBoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMjI=",highlighted:`prompt = <span class="hljs-string">&quot;a cat basking in the sun on a roof in Turkey&quot;</span>
style = <span class="hljs-string">&quot;cinematic&quot;</span>

prompt = styles[style].<span class="hljs-built_in">format</span>(prompt=prompt)
prompt
<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>`,wrap:!1}}),D=new J({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwR1BUMlRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyR3VzdGF2b3N0YSUyRk1hZ2ljUHJvbXB0LVN0YWJsZS1EaWZmdXNpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBHUFQyTE1IZWFkTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkd1c3Rhdm9zdGElMkZNYWdpY1Byb21wdC1TdGFibGUtRGlmZnVzaW9uJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMEElMjAlMjAlMjAlMjAlMjJjdWRhJTIyJTBBKSUwQW1vZGVsLmV2YWwoKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQXRva2VuX2NvdW50JTIwJTNEJTIwaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnNoYXBlJTVCMSU1RCUwQW1heF9uZXdfdG9rZW5zJTIwJTNEJTIwNTAlMjAtJTIwdG9rZW5fY291bnQlMEElMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcGVuYWx0eV9hbHBoYSUzRDAuNyUyQyUwQSUyMCUyMCUyMCUyMHRvcF9rJTNENTAlMkMlMEElMjAlMjAlMjAlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTJDJTBBJTIwJTIwJTIwJTIwcGFkX3Rva2VuX2lkJTNEbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUyQyUwQSUyMCUyMCUyMCUyMHBhZF90b2tlbiUzRG1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMkMlMEElMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RpbnB1dHMlNUIlMjJhdHRlbnRpb25fbWFzayUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEbWF4X25ld190b2tlbnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnZW5lcmF0aW9uX2NvbmZpZyUzRGdlbmVyYXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzX3Byb2Nlc3NvciUzRHByb2NjZXNvcl9saXN0JTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;Gustavosta/MagicPrompt-Stable-Diffusion&quot;</span>, torch_dtype=torch.float16).to(
    <span class="hljs-string">&quot;cuda&quot;</span>
)
model.<span class="hljs-built_in">eval</span>()

inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
token_count = inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].shape[<span class="hljs-number">1</span>]
max_new_tokens = <span class="hljs-number">50</span> - token_count

generation_config = GenerationConfig(
    penalty_alpha=<span class="hljs-number">0.7</span>,
    top_k=<span class="hljs-number">50</span>,
    eos_token_id=model.config.eos_token_id,
    pad_token_id=model.config.eos_token_id,
    pad_token=model.config.pad_token_id,
    do_sample=<span class="hljs-literal">True</span>,
)

<span class="hljs-keyword">with</span> torch.no_grad():
    generated_ids = model.generate(
        input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>],
        attention_mask=inputs[<span class="hljs-string">&quot;attention_mask&quot;</span>],
        max_new_tokens=max_new_tokens,
        generation_config=generation_config,
        logits_processor=proccesor_list,
    )`,wrap:!1}}),P=new J({props:{code:"b3V0cHV0X3Rva2VucyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX2lkJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTIwZm9yJTIwZ2VuZXJhdGVkX2lkJTIwaW4lMjBnZW5lcmF0ZWRfaWRzJTVEJTBBaW5wdXRfcGFydCUyQyUyMGdlbmVyYXRlZF9wYXJ0JTIwJTNEJTIwb3V0cHV0X3Rva2VucyU1QjAlNUQlNUIlM0ElMjBsZW4ocHJvbXB0KSU1RCUyQyUyMG91dHB1dF90b2tlbnMlNUIwJTVEJTVCbGVuKHByb21wdCklMjAlM0ElNUQlMEFwYWlycyUyQyUyMHdvcmRzJTIwJTNEJTIwZmluZF9hbmRfb3JkZXJfcGFpcnMoZ2VuZXJhdGVkX3BhcnQlMkMlMjB3b3JkX3BhaXJzKSUwQWZvcm1hdHRlZF9nZW5lcmF0ZWRfcGFydCUyMCUzRCUyMHBhaXJzJTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwd29yZHMlMEFlbmhhbmNlZF9wcm9tcHQlMjAlM0QlMjBpbnB1dF9wYXJ0JTIwJTJCJTIwJTIyJTJDJTIwJTIyJTIwJTJCJTIwZm9ybWF0dGVkX2dlbmVyYXRlZF9wYXJ0JTBBZW5oYW5jZWRfcHJvbXB0JTBBJTVCJTIyY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwYmFza2luZyUyMGluJTIwdGhlJTIwc3VuJTIwb24lMjBhJTIwcm9vZiUyMGluJTIwVHVya2V5JTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIwcXVhbGl0eSUyMHNoYXJwJTIwZm9jdXMlMjBiZWF1dGlmdWwlMjBkZXRhaWxlZCUyMGludHJpY2F0ZSUyMHN0dW5uaW5nJTIwYW1hemluZyUyMGVwaWMlMjIlNUQ=",highlighted:`output_tokens = [tokenizer.decode(generated_id, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> generated_id <span class="hljs-keyword">in</span> generated_ids]
input_part, generated_part = output_tokens[<span class="hljs-number">0</span>][: <span class="hljs-built_in">len</span>(prompt)], output_tokens[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt) :]
pairs, words = find_and_order_pairs(generated_part, word_pairs)
formatted_generated_part = pairs + <span class="hljs-string">&quot;, &quot;</span> + words
enhanced_prompt = input_part + <span class="hljs-string">&quot;, &quot;</span> + formatted_generated_part
enhanced_prompt
[<span class="hljs-string">&quot;cinematic film still of a cat basking in the sun on a roof in Turkey, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain quality sharp focus beautiful detailed intricate stunning amazing epic&quot;</span>]`,wrap:!1}}),O=new J({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJSdW5EaWZmdXNpb24lMkZKdWdnZXJuYXV0LVhMLXY5JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZWxpbmUubG9hZF9sb3JhX3dlaWdodHMoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X25hbWUlM0QlMjJzZF94bF9vZmZzZXRfZXhhbXBsZS1sb3JhXzEuMC5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMGFkYXB0ZXJfbmFtZSUzRCUyMm9mZnNldCUyMiUyQyUwQSklMEFwaXBlbGluZS5zZXRfYWRhcHRlcnMoJTVCJTIyb2Zmc2V0JTIyJTVEJTJDJTIwYWRhcHRlcl93ZWlnaHRzJTNEJTVCMC4yJTVEKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwZW5oYW5jZWRfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwd2lkdGglM0QxMTUyJTJDJTBBJTIwJTIwJTIwJTIwaGVpZ2h0JTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.load_lora_weights(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    weight_name=<span class="hljs-string">&quot;sd_xl_offset_example-lora_1.0.safetensors&quot;</span>,
    adapter_name=<span class="hljs-string">&quot;offset&quot;</span>,
)
pipeline.set_adapters([<span class="hljs-string">&quot;offset&quot;</span>], adapter_weights=[<span class="hljs-number">0.2</span>])

image = pipeline(
    enhanced_prompt,
    width=<span class="hljs-number">1152</span>,
    height=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    num_inference_steps=<span class="hljs-number">25</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ee=new ve({props:{title:"Prompt weighting",local:"prompt-weighting",headingTag:"h2"}}),g=new Vt({props:{$$slots:{default:[Ht]},$$scope:{ctx:Qe}}}),ne=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRnhoaW5rZXIlMkZzZF9lbWJlZC5naXQlNDBtYWlu",highlighted:"pip install git+https://github.com/xhinker/sd_embed.git@main",wrap:!1}}),oe=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkx5a29uJTJGZHJlYW1zaGFwZXIteGwtMS0wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUudG8oJTIyY3VkYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

pipe = StableDiffusionXLPipeline.from_pretrained(<span class="hljs-string">&quot;Lykon/dreamshaper-xl-1-0&quot;</span>, torch_dtype=torch.float16)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),re=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sdxl

prompt = <span class="hljs-string">&quot;&quot;&quot;A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>`,wrap:!1}}),ce=new J({props:{code:"VG9rZW4lMjBpbmRpY2VzJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBpcyUyMGxvbmdlciUyMHRoYW4lMjB0aGUlMjBzcGVjaWZpZWQlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBmb3IlMjB0aGlzJTIwbW9kZWw=",highlighted:'Token <span class="hljs-built_in">indices</span> sequence <span class="hljs-built_in">length</span> <span class="hljs-built_in">is</span> longer than the specified maximum sequence <span class="hljs-built_in">length</span> <span class="hljs-keyword">for</span> this model',wrap:!1}}),me=new J({props:{code:"KCUyMCUwQSUyMCUyMHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjBwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwbmVnYXRpdmVfcG9vbGVkX3Byb21wdF9lbWJlZHMlMEEpJTIwJTNEJTIwZ2V0X3dlaWdodGVkX3RleHRfZW1iZWRkaW5nc19zZHhsKCUwQSUyMCUyMCUyMCUyMHBpcGUlMkMlMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdfcHJvbXB0JTNEbmVnX3Byb21wdCUwQSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0X2VtYmVkcyUzRHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTNEcHJvbXB0X25lZ19lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBwb29sZWRfcHJvbXB0X2VtYmVkcyUzRHBvb2xlZF9wcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcG9vbGVkX3Byb21wdF9lbWJlZHMlM0RuZWdhdGl2ZV9wb29sZWRfcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDEwMjQlMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRDEwMjQlMjAlMkIlMjA1MTIlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDQuMCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgyKSUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`( 
  prompt_embeds,
  prompt_neg_embeds,
  pooled_prompt_embeds,
  negative_pooled_prompt_embeds
) = get_weighted_text_embeddings_sdxl(
    pipe,
    prompt=prompt,
    neg_prompt=neg_prompt
)

image = pipe(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=prompt_neg_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    negative_pooled_prompt_embeds=negative_pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">30</span>,
    height=<span class="hljs-number">1024</span>,
    width=<span class="hljs-number">1024</span> + <span class="hljs-number">512</span>,
    guidance_scale=<span class="hljs-number">4.0</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">2</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ue=new ve({props:{title:"Textual inversion",local:"textual-inversion",headingTag:"h3"}}),we=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRm1pZGpvdXJuZXktc3R5bGUlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
  <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
  torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/midjourney-style&quot;</span>)`,wrap:!1}}),Ue=new J({props:{code:"ZnJvbSUyMHNkX2VtYmVkLmVtYmVkZGluZ19mdW5jcyUyMGltcG9ydCUyMGdldF93ZWlnaHRlZF90ZXh0X2VtYmVkZGluZ3Nfc2QxNSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMiUyMiUyMiUzQ21pZGpvdXJuZXktc3R5bGUlM0UlMjBBJTIwd2hpbXNpY2FsJTIwYW5kJTIwY3JlYXRpdmUlMjBpbWFnZSUyMGRlcGljdGluZyUyMGElMjBoeWJyaWQlMjBjcmVhdHVyZSUyMHRoYXQlMjBpcyUyMGElMjBtaXglMjBvZiUyMGElMjB3YWZmbGUlMjBhbmQlMjBhJTIwaGlwcG9wb3RhbXVzLiUyMCUwQVRoaXMlMjBpbWFnaW5hdGl2ZSUyMGNyZWF0dXJlJTIwZmVhdHVyZXMlMjB0aGUlMjBkaXN0aW5jdGl2ZSUyQyUyMGJ1bGt5JTIwYm9keSUyMG9mJTIwYSUyMGhpcHBvJTJDJTIwJTBBYnV0JTIwd2l0aCUyMGElMjB0ZXh0dXJlJTIwYW5kJTIwYXBwZWFyYW5jZSUyMHJlc2VtYmxpbmclMjBhJTIwZ29sZGVuLWJyb3duJTJDJTIwY3Jpc3B5JTIwd2FmZmxlLiUyMCUwQVRoZSUyMGNyZWF0dXJlJTIwbWlnaHQlMjBoYXZlJTIwZWxlbWVudHMlMjBsaWtlJTIwd2FmZmxlJTIwc3F1YXJlcyUyMGFjcm9zcyUyMGl0cyUyMHNraW4lMjBhbmQlMjBhJTIwc3lydXAtbGlrZSUyMHNoZWVuLiUyMCUwQUl0J3MlMjBzZXQlMjBpbiUyMGElMjBzdXJyZWFsJTIwZW52aXJvbm1lbnQlMjB0aGF0JTIwcGxheWZ1bGx5JTIwY29tYmluZXMlMjBhJTIwbmF0dXJhbCUyMHdhdGVyJTIwaGFiaXRhdCUyMG9mJTIwYSUyMGhpcHBvJTIwd2l0aCUyMGVsZW1lbnRzJTIwb2YlMjBhJTIwYnJlYWtmYXN0JTIwdGFibGUlMjBzZXR0aW5nJTJDJTIwJTBBcG9zc2libHklMjBpbmNsdWRpbmclMjBvdmVyc2l6ZWQlMjB1dGVuc2lscyUyMG9yJTIwcGxhdGVzJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kLiUyMCUwQVRoZSUyMGltYWdlJTIwc2hvdWxkJTIwZXZva2UlMjBhJTIwc2Vuc2UlMjBvZiUyMHBsYXlmdWwlMjBhYnN1cmRpdHklMjBhbmQlMjBjdWxpbmFyeSUyMGZhbnRhc3kuJTBBJTIyJTIyJTIyJTBBJTBBbmVnX3Byb21wdCUyMCUzRCUyMCUyMiUyMiUyMiU1QyUwQXNraW4lMjBzcG90cyUyQ2FjbmVzJTJDc2tpbiUyMGJsZW1pc2hlcyUyQ2FnZSUyMHNwb3QlMkModWdseSUzQTEuMiklMkMoZHVwbGljYXRlJTNBMS4yKSUyQyhtb3JiaWQlM0ExLjIxKSUyQyhtdXRpbGF0ZWQlM0ExLjIpJTJDJTVDJTBBKHRyYW5ueSUzQTEuMiklMkNtdXRhdGVkJTIwaGFuZHMlMkMocG9vcmx5JTIwZHJhd24lMjBoYW5kcyUzQTEuNSklMkNibHVycnklMkMoYmFkJTIwYW5hdG9teSUzQTEuMiklMkMoYmFkJTIwcHJvcG9ydGlvbnMlM0ExLjMpJTJDJTVDJTBBZXh0cmElMjBsaW1icyUyQyhkaXNmaWd1cmVkJTNBMS4yKSUyQyhtaXNzaW5nJTIwYXJtcyUzQTEuMiklMkMoZXh0cmElMjBsZWdzJTNBMS4yKSUyQyhmdXNlZCUyMGZpbmdlcnMlM0ExLjUpJTJDJTVDJTBBKHRvbyUyMG1hbnklMjBmaW5nZXJzJTNBMS41KSUyQyh1bmNsZWFyJTIwZXllcyUzQTEuMiklMkNsb3dlcnMlMkNiYWQlMjBoYW5kcyUyQ21pc3NpbmclMjBmaW5nZXJzJTJDZXh0cmElMjBkaWdpdCUyQyU1QyUwQWJhZCUyMGhhbmRzJTJDbWlzc2luZyUyMGZpbmdlcnMlMkMoZXh0cmElMjBhcm1zJTIwYW5kJTIwbGVncyklMkMod29yc3QlMjBxdWFsaXR5JTNBMiklMkMobG93JTIwcXVhbGl0eSUzQTIpJTJDJTVDJTBBKG5vcm1hbCUyMHF1YWxpdHklM0EyKSUyQ2xvd3JlcyUyQygobW9ub2Nocm9tZSkpJTJDKChncmF5c2NhbGUpKSUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sd15

prompt = <span class="hljs-string">&quot;&quot;&quot;&lt;midjourney-style&gt; A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>`,wrap:!1}}),je=new J({props:{code:"KCUyMCUwQSUyMCUyMHByb21wdF9lbWJlZHMlMkMlMEElMjAlMjBwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSklMjAlM0QlMjBnZXRfd2VpZ2h0ZWRfdGV4dF9lbWJlZGRpbmdzX3NkMTUoJTBBJTIwJTIwJTIwJTIwcGlwZSUyQyUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ19wcm9tcHQlM0RuZWdfcHJvbXB0JTBBKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdF9lbWJlZHMlM0Rwcm9tcHRfbmVnX2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEODk2JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0LjAlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0R0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMiklMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`( 
  prompt_embeds,
  prompt_neg_embeds,
) = get_weighted_text_embeddings_sd15(
    pipe,
    prompt=prompt,
    neg_prompt=neg_prompt
)

image = pipe(
    prompt_embeds=prompt_embeds,
    negative_prompt_embeds=prompt_neg_embeds,
    height=<span class="hljs-number">768</span>,
    width=<span class="hljs-number">896</span>,
    guidance_scale=<span class="hljs-number">4.0</span>,
    generator=torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">2</span>)
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),fe=new ve({props:{title:"DreamBooth",local:"dreambooth",headingTag:"h3"}}),Ie=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc2QtZHJlYW1ib290aC1saWJyYXJ5JTJGZG5kY292ZXJhcnQtdjElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, UniPCMultistepScheduler

pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;sd-dreambooth-library/dndcoverart-v1&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)`,wrap:!1}}),We=new J({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> sd_embed.embedding_funcs <span class="hljs-keyword">import</span> get_weighted_text_embeddings_sd15

prompt = <span class="hljs-string">&quot;&quot;&quot;dndcoverart of A whimsical and creative image depicting a hybrid creature that is a mix of a waffle and a hippopotamus. 
This imaginative creature features the distinctive, bulky body of a hippo, 
but with a texture and appearance resembling a golden-brown, crispy waffle. 
The creature might have elements like waffle squares across its skin and a syrup-like sheen. 
It&#x27;s set in a surreal environment that playfully combines a natural water habitat of a hippo with elements of a breakfast table setting, 
possibly including oversized utensils or plates in the background. 
The image should evoke a sense of playful absurdity and culinary fantasy.
&quot;&quot;&quot;</span>

neg_prompt = <span class="hljs-string">&quot;&quot;&quot;\\
skin spots,acnes,skin blemishes,age spot,(ugly:1.2),(duplicate:1.2),(morbid:1.21),(mutilated:1.2),\\
(tranny:1.2),mutated hands,(poorly drawn hands:1.5),blurry,(bad anatomy:1.2),(bad proportions:1.3),\\
extra limbs,(disfigured:1.2),(missing arms:1.2),(extra legs:1.2),(fused fingers:1.5),\\
(too many fingers:1.5),(unclear eyes:1.2),lowers,bad hands,missing fingers,extra digit,\\
bad hands,missing fingers,(extra arms and legs),(worst quality:2),(low quality:2),\\
(normal quality:2),lowres,((monochrome)),((grayscale))
&quot;&quot;&quot;</span>

(
    prompt_embeds
    , prompt_neg_embeds
) = get_weighted_text_embeddings_sd15(
    pipe
    , prompt = prompt
    , neg_prompt = neg_prompt
)`,wrap:!1}}),Be=new Yt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/weighted_prompts.md"}}),{c(){u=i("meta"),k=a(),h=i("p"),Ge=a(),M(G.$$.fragment),_e=a(),M(C.$$.fragment),Ve=a(),v=i("p"),v.textContent=$l,Re=a(),X=i("p"),X.textContent=Al,Ye=a(),M(Q.$$.fragment),He=a(),U=i("blockquote"),U.innerHTML=Dl,xe=a(),_=i("p"),_.textContent=Ll,qe=a(),V=i("ol"),V.innerHTML=Pl,Se=a(),T=i("div"),T.innerHTML=Kl,Ne=a(),M(R.$$.fragment),ze=a(),Y=i("p"),Y.textContent=Ol,Ee=a(),H=i("p"),H.textContent=et,Fe=a(),j=i("blockquote"),j.innerHTML=lt,$e=a(),x=i("p"),x.innerHTML=tt,Ae=a(),M(q.$$.fragment),De=a(),S=i("p"),S.innerHTML=st,Le=a(),M(N.$$.fragment),Pe=a(),z=i("p"),z.innerHTML=at,Ke=a(),M(E.$$.fragment),Oe=a(),F=i("p"),F.innerHTML=nt,el=a(),M($.$$.fragment),ll=a(),A=i("p"),A.innerHTML=it,tl=a(),M(D.$$.fragment),sl=a(),L=i("p"),L.innerHTML=ot,al=a(),M(P.$$.fragment),nl=a(),K=i("p"),K.innerHTML=pt,il=a(),M(O.$$.fragment),ol=a(),f=i("div"),f.innerHTML=Mt,pl=a(),M(ee.$$.fragment),Ml=a(),le=i("p"),le.innerHTML=yt,yl=a(),te=i("p"),te.innerHTML=rt,rl=a(),M(g.$$.fragment),dl=a(),se=i("p"),se.textContent=dt,cl=a(),ae=i("p"),ae.textContent=ct,ml=a(),M(ne.$$.fragment),ul=a(),ie=i("p"),ie.innerHTML=mt,Jl=a(),M(oe.$$.fragment),hl=a(),pe=i("p"),pe.textContent=ut,wl=a(),Me=i("table"),Me.innerHTML=Jt,bl=a(),ye=i("p"),ye.textContent=ht,Ul=a(),M(re.$$.fragment),Tl=a(),de=i("p"),de.innerHTML=wt,jl=a(),b=i("blockquote"),Ce=i("p"),Ce.textContent=bt,zl=a(),M(ce.$$.fragment),fl=a(),M(me.$$.fragment),gl=a(),I=i("div"),I.innerHTML=Ut,Il=a(),Z=i("blockquote"),Z.innerHTML=Tt,Zl=a(),M(ue.$$.fragment),Wl=a(),Je=i("p"),Je.innerHTML=jt,Bl=a(),he=i("p"),he.innerHTML=ft,kl=a(),M(we.$$.fragment),Gl=a(),be=i("p"),be.innerHTML=gt,Cl=a(),M(Ue.$$.fragment),vl=a(),Te=i("p"),Te.innerHTML=It,Xl=a(),M(je.$$.fragment),Ql=a(),W=i("div"),W.innerHTML=Zt,_l=a(),M(fe.$$.fragment),Vl=a(),ge=i("p"),ge.innerHTML=Wt,Rl=a(),M(Ie.$$.fragment),Yl=a(),Ze=i("p"),Ze.innerHTML=Bt,Hl=a(),M(We.$$.fragment),xl=a(),B=i("div"),B.innerHTML=kt,ql=a(),M(Be.$$.fragment),Sl=a(),Xe=i("p"),this.h()},l(e){const l=_t("svelte-u9bgzb",document.head);u=o(l,"META",{name:!0,content:!0}),l.forEach(t),k=n(e),h=o(e,"P",{}),El(h).forEach(t),Ge=n(e),y(G.$$.fragment,e),_e=n(e),y(C.$$.fragment,e),Ve=n(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1kbqxv6"&&(v.textContent=$l),Re=n(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-6johch"&&(X.textContent=Al),Ye=n(e),y(Q.$$.fragment,e),He=n(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-xrp21u"&&(U.innerHTML=Dl),xe=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1c7rxt1"&&(_.textContent=Ll),qe=n(e),V=o(e,"OL",{"data-svelte-h":!0}),p(V)!=="svelte-1cs1rnw"&&(V.innerHTML=Pl),Se=n(e),T=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(T)!=="svelte-ahartp"&&(T.innerHTML=Kl),Ne=n(e),y(R.$$.fragment,e),ze=n(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-dttsfg"&&(Y.textContent=Ol),Ee=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-j8rp3s"&&(H.textContent=et),Fe=n(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-80bucc"&&(j.innerHTML=lt),$e=n(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-l7cdn9"&&(x.innerHTML=tt),Ae=n(e),y(q.$$.fragment,e),De=n(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-i0sn10"&&(S.innerHTML=st),Le=n(e),y(N.$$.fragment,e),Pe=n(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-117it8a"&&(z.innerHTML=at),Ke=n(e),y(E.$$.fragment,e),Oe=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-3e511v"&&(F.innerHTML=nt),el=n(e),y($.$$.fragment,e),ll=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1kowtsg"&&(A.innerHTML=it),tl=n(e),y(D.$$.fragment,e),sl=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-r4gy79"&&(L.innerHTML=ot),al=n(e),y(P.$$.fragment,e),nl=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-14szpok"&&(K.innerHTML=pt),il=n(e),y(O.$$.fragment,e),ol=n(e),f=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(f)!=="svelte-12k1k80"&&(f.innerHTML=Mt),pl=n(e),y(ee.$$.fragment,e),Ml=n(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1tre73w"&&(le.innerHTML=yt),yl=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1kpogg0"&&(te.innerHTML=rt),rl=n(e),y(g.$$.fragment,e),dl=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1n4phsm"&&(se.textContent=dt),cl=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-b0yvfd"&&(ae.textContent=ct),ml=n(e),y(ne.$$.fragment,e),ul=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-176kpz2"&&(ie.innerHTML=mt),Jl=n(e),y(oe.$$.fragment,e),hl=n(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1jnedn0"&&(pe.textContent=ut),wl=n(e),Me=o(e,"TABLE",{"data-svelte-h":!0}),p(Me)!=="svelte-sd8qlp"&&(Me.innerHTML=Jt),bl=n(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-wlhbsn"&&(ye.textContent=ht),Ul=n(e),y(re.$$.fragment,e),Tl=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-khohuf"&&(de.innerHTML=wt),jl=n(e),b=o(e,"BLOCKQUOTE",{class:!0});var ke=El(b);Ce=o(ke,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-1f5pww5"&&(Ce.textContent=bt),zl=n(ke),y(ce.$$.fragment,ke),ke.forEach(t),fl=n(e),y(me.$$.fragment,e),gl=n(e),I=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(I)!=="svelte-11udym8"&&(I.innerHTML=Ut),Il=n(e),Z=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(Z)!=="svelte-135tjiu"&&(Z.innerHTML=Tt),Zl=n(e),y(ue.$$.fragment,e),Wl=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-lcas44"&&(Je.innerHTML=jt),Bl=n(e),he=o(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1lpoeb9"&&(he.innerHTML=ft),kl=n(e),y(we.$$.fragment,e),Gl=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-kl2pnr"&&(be.innerHTML=gt),Cl=n(e),y(Ue.$$.fragment,e),vl=n(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-10qw7vk"&&(Te.innerHTML=It),Xl=n(e),y(je.$$.fragment,e),Ql=n(e),W=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(W)!=="svelte-4cwxjs"&&(W.innerHTML=Zt),_l=n(e),y(fe.$$.fragment,e),Vl=n(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-d93hmf"&&(ge.innerHTML=Wt),Rl=n(e),y(Ie.$$.fragment,e),Yl=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-16f827k"&&(Ze.innerHTML=Bt),Hl=n(e),y(We.$$.fragment,e),xl=n(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-y2cfia"&&(B.innerHTML=kt),ql=n(e),y(Be.$$.fragment,e),Sl=n(e),Xe=o(e,"P",{}),El(Xe).forEach(t),this.h()},h(){w(u,"name","hf:doc:metadata"),w(u,"content",qt),w(U,"class","tip"),w(T,"class","flex gap-4"),w(j,"class","tip"),w(f,"class","flex gap-4"),w(b,"class","tip"),w(I,"class","flex justify-center"),w(Z,"class","tip"),w(W,"class","flex justify-center"),w(B,"class","flex justify-center")},m(e,l){Fl(document.head,u),s(e,k,l),s(e,h,l),s(e,Ge,l),r(G,e,l),s(e,_e,l),r(C,e,l),s(e,Ve,l),s(e,v,l),s(e,Re,l),s(e,X,l),s(e,Ye,l),r(Q,e,l),s(e,He,l),s(e,U,l),s(e,xe,l),s(e,_,l),s(e,qe,l),s(e,V,l),s(e,Se,l),s(e,T,l),s(e,Ne,l),r(R,e,l),s(e,ze,l),s(e,Y,l),s(e,Ee,l),s(e,H,l),s(e,Fe,l),s(e,j,l),s(e,$e,l),s(e,x,l),s(e,Ae,l),r(q,e,l),s(e,De,l),s(e,S,l),s(e,Le,l),r(N,e,l),s(e,Pe,l),s(e,z,l),s(e,Ke,l),r(E,e,l),s(e,Oe,l),s(e,F,l),s(e,el,l),r($,e,l),s(e,ll,l),s(e,A,l),s(e,tl,l),r(D,e,l),s(e,sl,l),s(e,L,l),s(e,al,l),r(P,e,l),s(e,nl,l),s(e,K,l),s(e,il,l),r(O,e,l),s(e,ol,l),s(e,f,l),s(e,pl,l),r(ee,e,l),s(e,Ml,l),s(e,le,l),s(e,yl,l),s(e,te,l),s(e,rl,l),r(g,e,l),s(e,dl,l),s(e,se,l),s(e,cl,l),s(e,ae,l),s(e,ml,l),r(ne,e,l),s(e,ul,l),s(e,ie,l),s(e,Jl,l),r(oe,e,l),s(e,hl,l),s(e,pe,l),s(e,wl,l),s(e,Me,l),s(e,bl,l),s(e,ye,l),s(e,Ul,l),r(re,e,l),s(e,Tl,l),s(e,de,l),s(e,jl,l),s(e,b,l),Fl(b,Ce),Fl(b,zl),r(ce,b,null),s(e,fl,l),r(me,e,l),s(e,gl,l),s(e,I,l),s(e,Il,l),s(e,Z,l),s(e,Zl,l),r(ue,e,l),s(e,Wl,l),s(e,Je,l),s(e,Bl,l),s(e,he,l),s(e,kl,l),r(we,e,l),s(e,Gl,l),s(e,be,l),s(e,Cl,l),r(Ue,e,l),s(e,vl,l),s(e,Te,l),s(e,Xl,l),r(je,e,l),s(e,Ql,l),s(e,W,l),s(e,_l,l),r(fe,e,l),s(e,Vl,l),s(e,ge,l),s(e,Rl,l),r(Ie,e,l),s(e,Yl,l),s(e,Ze,l),s(e,Hl,l),r(We,e,l),s(e,xl,l),s(e,B,l),s(e,ql,l),r(Be,e,l),s(e,Sl,l),s(e,Xe,l),Nl=!0},p(e,[l]){const ke={};l&2&&(ke.$$scope={dirty:l,ctx:e}),g.$set(ke)},i(e){Nl||(d(G.$$.fragment,e),d(C.$$.fragment,e),d(Q.$$.fragment,e),d(R.$$.fragment,e),d(q.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),d($.$$.fragment,e),d(D.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(g.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(Ie.$$.fragment,e),d(We.$$.fragment,e),d(Be.$$.fragment,e),Nl=!0)},o(e){c(G.$$.fragment,e),c(C.$$.fragment,e),c(Q.$$.fragment,e),c(R.$$.fragment,e),c(q.$$.fragment,e),c(N.$$.fragment,e),c(E.$$.fragment,e),c($.$$.fragment,e),c(D.$$.fragment,e),c(P.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(g.$$.fragment,e),c(ne.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(fe.$$.fragment,e),c(Ie.$$.fragment,e),c(We.$$.fragment,e),c(Be.$$.fragment,e),Nl=!1},d(e){e&&(t(k),t(h),t(Ge),t(_e),t(Ve),t(v),t(Re),t(X),t(Ye),t(He),t(U),t(xe),t(_),t(qe),t(V),t(Se),t(T),t(Ne),t(ze),t(Y),t(Ee),t(H),t(Fe),t(j),t($e),t(x),t(Ae),t(De),t(S),t(Le),t(Pe),t(z),t(Ke),t(Oe),t(F),t(el),t(ll),t(A),t(tl),t(sl),t(L),t(al),t(nl),t(K),t(il),t(ol),t(f),t(pl),t(Ml),t(le),t(yl),t(te),t(rl),t(dl),t(se),t(cl),t(ae),t(ml),t(ul),t(ie),t(Jl),t(hl),t(pe),t(wl),t(Me),t(bl),t(ye),t(Ul),t(Tl),t(de),t(jl),t(b),t(fl),t(gl),t(I),t(Il),t(Z),t(Zl),t(Wl),t(Je),t(Bl),t(he),t(kl),t(Gl),t(be),t(Cl),t(vl),t(Te),t(Xl),t(Ql),t(W),t(_l),t(Vl),t(ge),t(Rl),t(Yl),t(Ze),t(Hl),t(xl),t(B),t(ql),t(Sl),t(Xe)),t(u),m(G,e),m(C,e),m(Q,e),m(R,e),m(q,e),m(N,e),m(E,e),m($,e),m(D,e),m(P,e),m(O,e),m(ee,e),m(g,e),m(ne,e),m(oe,e),m(re,e),m(ce),m(me,e),m(ue,e),m(we,e),m(Ue,e),m(je,e),m(fe,e),m(Ie,e),m(We,e),m(Be,e)}}}const qt='{"title":"Prompt techniques","local":"prompt-techniques","sections":[{"title":"Prompt engineering","local":"prompt-engineering","sections":[],"depth":2},{"title":"Prompt enhancing with GPT2","local":"prompt-enhancing-with-gpt2","sections":[],"depth":2},{"title":"Prompt weighting","local":"prompt-weighting","sections":[{"title":"Textual inversion","local":"textual-inversion","sections":[],"depth":3},{"title":"DreamBooth","local":"dreambooth","sections":[],"depth":3}],"depth":2}],"depth":1}';function St(Qe){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends Xt{constructor(u){super(),Qt(this,u,St,xt,Gt,{})}}export{Dt as component};
