import{s as Ft,n as At,o as Pt}from"../chunks/scheduler.8c3d61f6.js";import{S as Kt,i as Ot,g as n,s as i,r as c,A as es,h as p,f as s,c as a,j as Qt,u as o,x as r,k as f,y as ts,a as l,v as u,d,t as m,w as h}from"../chunks/index.da70eac4.js";import{C as Z}from"../chunks/CodeBlock.a9c4becf.js";import{D as ss}from"../chunks/DocNotebookDropdown.48852948.js";import{H as T,E as ls}from"../chunks/getInferenceSnippets.cb466318.js";function is(Mt){let M,Te,fe,ge,I,we,B,Je,G,Tt="A scheduler is an algorithm that provides instructions to the denoising process such as how much noise to remove at a certain step. It takes the model prediction from step <em>t</em> and applies an update for how to compute the next sample at step <em>t-1</em>. Different schedulers produce different results; some are faster while others are more accurate.",ye,x,gt="Diffusers supports many schedulers and allows you to modify their timestep schedules, timestep spacing, and more, to generate high-quality images in fewer steps.",be,W,wt="This guide will show you how to load and customize schedulers.",Ue,E,je,$,Jt="Schedulers don’t have any parameters and are defined in a configuration file. Access the <code>.scheduler</code> attribute of a pipeline to view the configuration.",ve,C,Ze,V,yt='Load a different scheduler with <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> and specify the <code>subfolder</code> argument to load the configuration file into the correct subfolder of the pipeline repository. Pass the new scheduler to the existing pipeline.',Ie,k,Be,S,Ge,_,bt="Timestep or noise schedule decides how noise is distributed over the denoising process. The schedule can be linear or more concentrated toward the beginning or end. It is a precomputed sequence of noise levels generated from the scheduler’s default configuration, but it can be customized to use other schedules.",xe,g,Ut="<p>The <code>timesteps</code> argument is only supported for a select list of schedulers and pipelines. Feel free to open a feature request if you want to extend these parameters to a scheduler and pipeline that does not currently support it!</p>",We,H,jt='The example below uses the <a href="https://research.nvidia.com/labs/toronto-ai/AlignYourSteps/" rel="nofollow">Align Your Steps (AYS)</a> schedule which can generate a high-quality image in 10 steps, significantly speeding up generation and reducing computation time.',Ee,N,vt="Import the schedule and pass it to the <code>timesteps</code> argument in the pipeline.",$e,R,Ce,w,Zt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/ays.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">AYS timestep schedule 10 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/10.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Linearly-spaced timestep schedule 10 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/25.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Linearly-spaced timestep schedule 25 steps</figcaption></div>',Ve,X,ke,Y,It="Denoising should begin with pure noise and the signal-to-noise (SNR) ration should be zero. However, some models don’t actually start from pure noise which makes it difficult to generate images at brightness extremes.",Se,J,Bt='<p>Train your own model with <code>v_prediction</code> by adding the <code>--prediction_type=&quot;v_prediction&quot;</code> flag to your training script. You can also <a href="https://huggingface.co/search/full-text?q=v_prediction&amp;type=model" rel="nofollow">search</a> for existing models trained with <code>v_prediction</code>.</p>',_e,L,Gt="To fix this, a model must be trained with <code>v_prediction</code>. If a model is trained with <code>v_prediction</code>, then enable the following arguments in the scheduler.",He,q,xt="<li>Set <code>rescale_betas_zero_snr=True</code> to rescale the noise schedule to the very last timestep with exactly zero SNR</li> <li>Set <code>timestep_spacing=&quot;trailing&quot;</code> to force sampling from the last timestep with pure noise</li>",Ne,z,Re,D,Wt="Set <code>guidance_rescale</code> in the pipeline to avoid overexposed images. A lower value increases brightness, but some details may appear washed out.",Xe,Q,Ye,y,Et='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/no-zero-snr.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">default Stable Diffusion v2-1 image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/zero-snr.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">image with zero SNR and trailing timestep spacing enabled</figcaption></div>',Le,F,qe,A,$t="Timestep spacing refers to the specific steps <em>t</em> to sample from from the schedule. Diffusers provides three spacing types as shown below.",ze,P,Ct="<thead><tr><th>spacing strategy</th> <th>spacing calculation</th> <th>example timesteps</th></tr></thead> <tbody><tr><td><code>leading</code></td> <td>evenly spaced steps</td> <td><code>[900, 800, 700, ..., 100, 0]</code></td></tr> <tr><td><code>linspace</code></td> <td>include first and last steps and evenly divide remaining intermediate steps</td> <td><code>[1000, 888.89, 777.78, ..., 111.11, 0]</code></td></tr> <tr><td><code>trailing</code></td> <td>include last step and evenly divide remaining intermediate steps beginning from the end</td> <td><code>[999, 899, 799, 699, 599, 499, 399, 299, 199, 99]</code></td></tr></tbody>",De,K,Vt="Pass the spacing strategy to the <code>timestep_spacing</code> argument in the scheduler.",Qe,b,kt="<p>The <code>trailing</code> strategy typically produces higher quality images with more details with fewer steps, but the difference in quality is not as obvious for more standard step values.</p>",Fe,O,Ae,U,St='<div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/trailing_spacing.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">trailing spacing after 5 steps</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/leading_spacing.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">leading spacing after 5 steps</figcaption></div>',Pe,ee,Ke,te,_t="Sigmas is a measure of how noisy a sample is at a certain step as defined by the schedule. When using custom <code>sigmas</code>, the <code>timesteps</code> are calculated from these values instead of the default scheduler configuration.",Oe,j,Ht="<p>The <code>sigmas</code> argument is only supported for a select list of schedulers and pipelines. Feel free to open a feature request if you want to extend these parameters to a scheduler and pipeline that does not currently support it!</p>",et,se,Nt='Pass the custom sigmas to the <code>sigmas</code> argument in the pipeline. The example below uses the <a href="https://github.com/huggingface/diffusers/blob/6529ee67ec02fcf58d2fd9242164ea002b351d75/src/diffusers/schedulers/scheduling_utils.py#L55" rel="nofollow">sigmas</a> from the 10-step AYS schedule.',tt,le,st,ie,lt,ae,Rt='<a href="https://huggingface.co/papers/2206.00364" rel="nofollow">Karras sigmas</a> resamples the noise schedule for more efficient sampling by clustering sigmas more densely in the middle of the sequence where structure reconstruction is critical, while using fewer sigmas at the beginning and end where noise changes have less impact. This can increase the level of details in a generated image.',it,ne,Xt="Set <code>use_karras_sigmas=True</code> in the scheduler to enable it.",at,pe,nt,v,Yt='<div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/karras_sigmas_true.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Karras sigmas enabled</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/stevhliu/testing-images/resolve/main/karras_sigmas_false.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">Karras sigmas disabled</figcaption></div>',pt,re,Lt='Refer to the scheduler API <a href="../api/schedulers/overview">overview</a> for a list of schedulers that support Karras sigmas. It should only be used for models trained with Karras sigmas.',rt,ce,ct,oe,qt="It’s important to try different schedulers to find the best one for your use case. Here are a few recommendations to help you get started.",ot,ue,zt='<li>DPM++ 2M SDE Karras is generally a good all-purpose option.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/tcd#diffusers.TCDScheduler">TCDScheduler</a> works well for distilled models.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a> and <a href="/docs/diffusers/main/en/api/schedulers/flow_match_heun_discrete#diffusers.FlowMatchHeunDiscreteScheduler">FlowMatchHeunDiscreteScheduler</a> for FlowMatch models.</li> <li><a href="/docs/diffusers/main/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> or <a href="/docs/diffusers/main/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a> for generating anime style images.</li> <li>DPM++ 2M paired with <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> on SDXL for generating realistic images.</li>',ut,de,dt,me,Dt='<li>Read the <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a> paper for more details about rescaling the noise schedule to enforce zero SNR.</li>',mt,he,ht,Me,ft;return I=new ss({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"}]}}),B=new T({props:{title:"Schedulers",local:"schedulers",headingTag:"h1"}}),E=new T({props:{title:"Loading schedulers",local:"loading-schedulers",headingTag:"h2"}}),C=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXI=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler`,wrap:!1}}),k=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRGRwbSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQXBpcGVsaW5lLnNjaGVkdWxlcg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

dpm = DPMSolverMultistepScheduler.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    scheduler=dpm,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler`,wrap:!1}}),S=new T({props:{title:"Timestep schedules",local:"timestep-schedules",headingTag:"h2"}}),R=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMlMjBpbXBvcnQlMjBBeXNTY2hlZHVsZXMlMEElMEFzYW1wbGluZ19zY2hlZHVsZSUyMCUzRCUyMEF5c1NjaGVkdWxlcyU1QiUyMlN0YWJsZURpZmZ1c2lvblhMVGltZXN0ZXBzJTIyJTVEJTBBcHJpbnQoc2FtcGxpbmdfc2NoZWR1bGUpJTBBJTIyJTVCOTk5JTJDJTIwODQ1JTJDJTIwNzMwJTJDJTIwNTg3JTJDJTIwNDQzJTJDJTIwMzEwJTJDJTIwMTkzJTJDJTIwMTE2JTJDJTIwNTMlMkMlMjAxMyU1RCUyMiUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlNHMTYxMjIyJTJGUmVhbFZpc1hMX1Y0LjAlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUyMiUwQSklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcoJTBBJTIwJTIwcGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGFsZ29yaXRobV90eXBlJTNEJTIyc2RlLWRwbXNvbHZlciUyQiUyQiUyMiUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2luZW1hdGljJTIwc2hvdCUyMG9mJTIwYSUyMGN1dGUlMjBsaXR0bGUlMjByYWJiaXQlMjB3ZWFyaW5nJTIwYSUyMGphY2tldCUyMGFuZCUyMGRvaW5nJTIwYSUyMHRodW1icyUyMHVwJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0QlMjIlMjIlMkMlMEElMjAlMjAlMjAlMjB0aW1lc3RlcHMlM0RzYW1wbGluZ19zY2hlZHVsZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler
<span class="hljs-keyword">from</span> diffusers.schedulers <span class="hljs-keyword">import</span> AysSchedules

sampling_schedule = AysSchedules[<span class="hljs-string">&quot;StableDiffusionXLTimesteps&quot;</span>]
<span class="hljs-built_in">print</span>(sampling_schedule)
<span class="hljs-string">&quot;[999, 845, 730, 587, 443, 310, 193, 116, 53, 13]&quot;</span>

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    timesteps=sampling_schedule,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),X=new T({props:{title:"Rescaling schedules",local:"rescaling-schedules",headingTag:"h3"}}),z=new Z({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRERJTVNjaGVkdWxlciUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnB0eDAlMkZwc2V1ZG8tam91cm5leS12MiUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERESU1TY2hlZHVsZXIuZnJvbV9jb25maWcoJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMHJlc2NhbGVfYmV0YXNfemVyb19zbnIlM0RUcnVlJTJDJTIwdGltZXN0ZXBfc3BhY2luZyUzRCUyMnRyYWlsaW5nJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DDIMScheduler

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;ptx0/pseudo-journey-v2&quot;</span>, device_map=<span class="hljs-string">&quot;cuda&quot;</span>)

pipeline.scheduler = DDIMScheduler.from_config(
    pipeline.scheduler.config, rescale_betas_zero_snr=<span class="hljs-literal">True</span>, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>
)`,wrap:!1}}),Q=new Z({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwcGhvdG8lMjBvZiUyMGElMjBzbm93eSUyMG1vdW50YWluJTIwYXQlMjBuaWdodCUyMHdpdGglMjB0aGUlMjBub3J0aGVybiUyMGxpZ2h0cyUyMGF1cm9yYSUyMGJvcmVhbGlzJTBBb3ZlcmhlYWQlMkMlMjAzNW1tJTIwcGhvdG9ncmFwaCUyQyUyMGZpbG0lMkMlMjBwcm9mZXNzaW9uYWwlMkMlMjA0ayUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTBBJTIyJTIyJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBndWlkYW5jZV9yZXNjYWxlJTNEMC43KS5pbWFnZXMlNUIwJTVE",highlighted:`prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic photo of a snowy mountain at night with the northern lights aurora borealis
overhead, 35mm photograph, film, professional, 4k, highly detailed
&quot;&quot;&quot;</span>
image = pipeline(prompt, guidance_rescale=<span class="hljs-number">0.7</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),F=new T({props:{title:"Timestep spacing",local:"timestep-spacing",headingTag:"h2"}}),O=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIydHJhaWxpbmclMjIlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwYmxhY2slMjBjYXQlMjBzaXR0aW5nJTIwb24lMjBhJTIwcHVtcGtpbiUyMGF0JTIwbmlnaHQlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMiUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little black cat sitting on a pumpkin at night&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    num_inference_steps=<span class="hljs-number">5</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ee=new T({props:{title:"Sigmas",local:"sigmas",headingTag:"h2"}}),le=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjBhbGdvcml0aG1fdHlwZSUzRCUyMnNkZS1kcG1zb2x2ZXIlMkIlMkIlMjIlMEEpJTBBJTBBc2lnbWFzJTIwJTNEJTIwJTVCMTQuNjE1JTJDJTIwNi4zMTUlMkMlMjAzLjc3MSUyQyUyMDIuMTgxJTJDJTIwMS4zNDIlMkMlMjAwLjg2MiUyQyUyMDAuNTU1JTJDJTIwMC4zODAlMkMlMjAwLjIzNCUyQyUyMDAuMTEzJTJDJTIwMC4wJTVEJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBqYWNrZXQlMjBhbmQlMjBkb2luZyUyMGElMjB0aHVtYnMlMjB1cCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2lnbWFzJTNEc2lnbWFzJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config, algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>
)

sigmas = [<span class="hljs-number">14.615</span>, <span class="hljs-number">6.315</span>, <span class="hljs-number">3.771</span>, <span class="hljs-number">2.181</span>, <span class="hljs-number">1.342</span>, <span class="hljs-number">0.862</span>, <span class="hljs-number">0.555</span>, <span class="hljs-number">0.380</span>, <span class="hljs-number">0.234</span>, <span class="hljs-number">0.113</span>, <span class="hljs-number">0.0</span>]
prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    sigmas=sigmas,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ie=new T({props:{title:"Karras sigmas",local:"karras-sigmas",headingTag:"h3"}}),pe=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTRzE2MTIyMiUyRlJlYWxWaXNYTF9WNC4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKCUwQSUyMCUyMHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMEElMjAlMjBhbGdvcml0aG1fdHlwZSUzRCUyMnNkZS1kcG1zb2x2ZXIlMkIlMkIlMjIlMkMlMEElMjAlMjB1c2Vfa2FycmFzX3NpZ21hcyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGNpbmVtYXRpYyUyMHNob3QlMjBvZiUyMGElMjBjdXRlJTIwbGl0dGxlJTIwcmFiYml0JTIwd2VhcmluZyUyMGElMjBqYWNrZXQlMjBhbmQlMjBkb2luZyUyMGElMjB0aHVtYnMlMjB1cCUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEJTIyJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2lnbWFzJTNEc2lnbWFzJTJDJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, DPMSolverMultistepScheduler

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;SG161222/RealVisXL_V4.0&quot;</span>,
    torch_dtype=torch.float16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)
pipeline.scheduler = DPMSolverMultistepScheduler.from_config(
  pipeline.scheduler.config,
  algorithm_type=<span class="hljs-string">&quot;sde-dpmsolver++&quot;</span>,
  use_karras_sigmas=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;A cinematic shot of a cute little rabbit wearing a jacket and doing a thumbs up&quot;</span>
image = pipeline(
    prompt=prompt,
    negative_prompt=<span class="hljs-string">&quot;&quot;</span>,
    sigmas=sigmas,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ce=new T({props:{title:"Choosing a scheduler",local:"choosing-a-scheduler",headingTag:"h2"}}),de=new T({props:{title:"Resources",local:"resources",headingTag:"h2"}}),he=new ls({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/schedulers.md"}}),{c(){M=n("meta"),Te=i(),fe=n("p"),ge=i(),c(I.$$.fragment),we=i(),c(B.$$.fragment),Je=i(),G=n("p"),G.innerHTML=Tt,ye=i(),x=n("p"),x.textContent=gt,be=i(),W=n("p"),W.textContent=wt,Ue=i(),c(E.$$.fragment),je=i(),$=n("p"),$.innerHTML=Jt,ve=i(),c(C.$$.fragment),Ze=i(),V=n("p"),V.innerHTML=yt,Ie=i(),c(k.$$.fragment),Be=i(),c(S.$$.fragment),Ge=i(),_=n("p"),_.textContent=bt,xe=i(),g=n("blockquote"),g.innerHTML=Ut,We=i(),H=n("p"),H.innerHTML=jt,Ee=i(),N=n("p"),N.innerHTML=vt,$e=i(),c(R.$$.fragment),Ce=i(),w=n("div"),w.innerHTML=Zt,Ve=i(),c(X.$$.fragment),ke=i(),Y=n("p"),Y.textContent=It,Se=i(),J=n("blockquote"),J.innerHTML=Bt,_e=i(),L=n("p"),L.innerHTML=Gt,He=i(),q=n("ul"),q.innerHTML=xt,Ne=i(),c(z.$$.fragment),Re=i(),D=n("p"),D.innerHTML=Wt,Xe=i(),c(Q.$$.fragment),Ye=i(),y=n("div"),y.innerHTML=Et,Le=i(),c(F.$$.fragment),qe=i(),A=n("p"),A.innerHTML=$t,ze=i(),P=n("table"),P.innerHTML=Ct,De=i(),K=n("p"),K.innerHTML=Vt,Qe=i(),b=n("blockquote"),b.innerHTML=kt,Fe=i(),c(O.$$.fragment),Ae=i(),U=n("div"),U.innerHTML=St,Pe=i(),c(ee.$$.fragment),Ke=i(),te=n("p"),te.innerHTML=_t,Oe=i(),j=n("blockquote"),j.innerHTML=Ht,et=i(),se=n("p"),se.innerHTML=Nt,tt=i(),c(le.$$.fragment),st=i(),c(ie.$$.fragment),lt=i(),ae=n("p"),ae.innerHTML=Rt,it=i(),ne=n("p"),ne.innerHTML=Xt,at=i(),c(pe.$$.fragment),nt=i(),v=n("div"),v.innerHTML=Yt,pt=i(),re=n("p"),re.innerHTML=Lt,rt=i(),c(ce.$$.fragment),ct=i(),oe=n("p"),oe.textContent=qt,ot=i(),ue=n("ul"),ue.innerHTML=zt,ut=i(),c(de.$$.fragment),dt=i(),me=n("ul"),me.innerHTML=Dt,mt=i(),c(he.$$.fragment),ht=i(),Me=n("p"),this.h()},l(e){const t=es("svelte-u9bgzb",document.head);M=p(t,"META",{name:!0,content:!0}),t.forEach(s),Te=a(e),fe=p(e,"P",{}),Qt(fe).forEach(s),ge=a(e),o(I.$$.fragment,e),we=a(e),o(B.$$.fragment,e),Je=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-102wtk8"&&(G.innerHTML=Tt),ye=a(e),x=p(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-7gdk9f"&&(x.textContent=gt),be=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-n44qmz"&&(W.textContent=wt),Ue=a(e),o(E.$$.fragment,e),je=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-thfjbi"&&($.innerHTML=Jt),ve=a(e),o(C.$$.fragment,e),Ze=a(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-7upath"&&(V.innerHTML=yt),Ie=a(e),o(k.$$.fragment,e),Be=a(e),o(S.$$.fragment,e),Ge=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-41eu0f"&&(_.textContent=bt),xe=a(e),g=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(g)!=="svelte-fdqszo"&&(g.innerHTML=Ut),We=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1ohacqg"&&(H.innerHTML=jt),Ee=a(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-rm6bho"&&(N.innerHTML=vt),$e=a(e),o(R.$$.fragment,e),Ce=a(e),w=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(w)!=="svelte-1wwk2vr"&&(w.innerHTML=Zt),Ve=a(e),o(X.$$.fragment,e),ke=a(e),Y=p(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-qyan8p"&&(Y.textContent=It),Se=a(e),J=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1ytgrjg"&&(J.innerHTML=Bt),_e=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-u69ydw"&&(L.innerHTML=Gt),He=a(e),q=p(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-4v39hu"&&(q.innerHTML=xt),Ne=a(e),o(z.$$.fragment,e),Re=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-bj3sil"&&(D.innerHTML=Wt),Xe=a(e),o(Q.$$.fragment,e),Ye=a(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-2pxhst"&&(y.innerHTML=Et),Le=a(e),o(F.$$.fragment,e),qe=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-p812a3"&&(A.innerHTML=$t),ze=a(e),P=p(e,"TABLE",{"data-svelte-h":!0}),r(P)!=="svelte-1e67q19"&&(P.innerHTML=Ct),De=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-d1j5xm"&&(K.innerHTML=Vt),Qe=a(e),b=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-15bsxi3"&&(b.innerHTML=kt),Fe=a(e),o(O.$$.fragment,e),Ae=a(e),U=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-106qvjp"&&(U.innerHTML=St),Pe=a(e),o(ee.$$.fragment,e),Ke=a(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-10a435k"&&(te.innerHTML=_t),Oe=a(e),j=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-118exvu"&&(j.innerHTML=Ht),et=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-x20l5u"&&(se.innerHTML=Nt),tt=a(e),o(le.$$.fragment,e),st=a(e),o(ie.$$.fragment,e),lt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-3ub125"&&(ae.innerHTML=Rt),it=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10otcr1"&&(ne.innerHTML=Xt),at=a(e),o(pe.$$.fragment,e),nt=a(e),v=p(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-gruv4r"&&(v.innerHTML=Yt),pt=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1livq9e"&&(re.innerHTML=Lt),rt=a(e),o(ce.$$.fragment,e),ct=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1gtdusx"&&(oe.textContent=qt),ot=a(e),ue=p(e,"UL",{"data-svelte-h":!0}),r(ue)!=="svelte-r7qw4m"&&(ue.innerHTML=zt),ut=a(e),o(de.$$.fragment,e),dt=a(e),me=p(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-t1vvcd"&&(me.innerHTML=Dt),mt=a(e),o(he.$$.fragment,e),ht=a(e),Me=p(e,"P",{}),Qt(Me).forEach(s),this.h()},h(){f(M,"name","hf:doc:metadata"),f(M,"content",as),f(g,"class","tip"),f(w,"class","flex gap-4"),f(J,"class","tip"),f(y,"class","flex gap-4"),f(b,"class","tip"),f(U,"class","flex gap-4"),f(j,"class","tip"),f(v,"class","flex gap-4")},m(e,t){ts(document.head,M),l(e,Te,t),l(e,fe,t),l(e,ge,t),u(I,e,t),l(e,we,t),u(B,e,t),l(e,Je,t),l(e,G,t),l(e,ye,t),l(e,x,t),l(e,be,t),l(e,W,t),l(e,Ue,t),u(E,e,t),l(e,je,t),l(e,$,t),l(e,ve,t),u(C,e,t),l(e,Ze,t),l(e,V,t),l(e,Ie,t),u(k,e,t),l(e,Be,t),u(S,e,t),l(e,Ge,t),l(e,_,t),l(e,xe,t),l(e,g,t),l(e,We,t),l(e,H,t),l(e,Ee,t),l(e,N,t),l(e,$e,t),u(R,e,t),l(e,Ce,t),l(e,w,t),l(e,Ve,t),u(X,e,t),l(e,ke,t),l(e,Y,t),l(e,Se,t),l(e,J,t),l(e,_e,t),l(e,L,t),l(e,He,t),l(e,q,t),l(e,Ne,t),u(z,e,t),l(e,Re,t),l(e,D,t),l(e,Xe,t),u(Q,e,t),l(e,Ye,t),l(e,y,t),l(e,Le,t),u(F,e,t),l(e,qe,t),l(e,A,t),l(e,ze,t),l(e,P,t),l(e,De,t),l(e,K,t),l(e,Qe,t),l(e,b,t),l(e,Fe,t),u(O,e,t),l(e,Ae,t),l(e,U,t),l(e,Pe,t),u(ee,e,t),l(e,Ke,t),l(e,te,t),l(e,Oe,t),l(e,j,t),l(e,et,t),l(e,se,t),l(e,tt,t),u(le,e,t),l(e,st,t),u(ie,e,t),l(e,lt,t),l(e,ae,t),l(e,it,t),l(e,ne,t),l(e,at,t),u(pe,e,t),l(e,nt,t),l(e,v,t),l(e,pt,t),l(e,re,t),l(e,rt,t),u(ce,e,t),l(e,ct,t),l(e,oe,t),l(e,ot,t),l(e,ue,t),l(e,ut,t),u(de,e,t),l(e,dt,t),l(e,me,t),l(e,mt,t),u(he,e,t),l(e,ht,t),l(e,Me,t),ft=!0},p:At,i(e){ft||(d(I.$$.fragment,e),d(B.$$.fragment,e),d(E.$$.fragment,e),d(C.$$.fragment,e),d(k.$$.fragment,e),d(S.$$.fragment,e),d(R.$$.fragment,e),d(X.$$.fragment,e),d(z.$$.fragment,e),d(Q.$$.fragment,e),d(F.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),ft=!0)},o(e){m(I.$$.fragment,e),m(B.$$.fragment,e),m(E.$$.fragment,e),m(C.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(R.$$.fragment,e),m(X.$$.fragment,e),m(z.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(O.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(ie.$$.fragment,e),m(pe.$$.fragment,e),m(ce.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),ft=!1},d(e){e&&(s(Te),s(fe),s(ge),s(we),s(Je),s(G),s(ye),s(x),s(be),s(W),s(Ue),s(je),s($),s(ve),s(Ze),s(V),s(Ie),s(Be),s(Ge),s(_),s(xe),s(g),s(We),s(H),s(Ee),s(N),s($e),s(Ce),s(w),s(Ve),s(ke),s(Y),s(Se),s(J),s(_e),s(L),s(He),s(q),s(Ne),s(Re),s(D),s(Xe),s(Ye),s(y),s(Le),s(qe),s(A),s(ze),s(P),s(De),s(K),s(Qe),s(b),s(Fe),s(Ae),s(U),s(Pe),s(Ke),s(te),s(Oe),s(j),s(et),s(se),s(tt),s(st),s(lt),s(ae),s(it),s(ne),s(at),s(nt),s(v),s(pt),s(re),s(rt),s(ct),s(oe),s(ot),s(ue),s(ut),s(dt),s(me),s(mt),s(ht),s(Me)),s(M),h(I,e),h(B,e),h(E,e),h(C,e),h(k,e),h(S,e),h(R,e),h(X,e),h(z,e),h(Q,e),h(F,e),h(O,e),h(ee,e),h(le,e),h(ie,e),h(pe,e),h(ce,e),h(de,e),h(he,e)}}}const as='{"title":"Schedulers","local":"schedulers","sections":[{"title":"Loading schedulers","local":"loading-schedulers","sections":[],"depth":2},{"title":"Timestep schedules","local":"timestep-schedules","sections":[{"title":"Rescaling schedules","local":"rescaling-schedules","sections":[],"depth":3}],"depth":2},{"title":"Timestep spacing","local":"timestep-spacing","sections":[],"depth":2},{"title":"Sigmas","local":"sigmas","sections":[{"title":"Karras sigmas","local":"karras-sigmas","sections":[],"depth":3}],"depth":2},{"title":"Choosing a scheduler","local":"choosing-a-scheduler","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function ns(Mt){return Pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends Kt{constructor(M){super(),Ot(this,M,ns,is,Ft,{})}}export{ds as component};
