import{s as ol,o as pl,n as v}from"../chunks/scheduler.8c3d61f6.js";import{S as rl,i as cl,g as J,s as d,r as T,A as ml,h as g,f as n,c as M,j as il,u as b,x as U,k as R,y as dl,a as p,v as j,d as Z,t as W,w as C}from"../chunks/index.da70eac4.js";import{C as N}from"../chunks/CodeBlock.a9c4becf.js";import{D as Ml}from"../chunks/DocNotebookDropdown.48852948.js";import{H as Q,E as ul}from"../chunks/getInferenceSnippets.cb466318.js";import{H as de,a as _}from"../chunks/HfOption.6c3b4e77.js";function hl(I){let s,y='To use LCMs, you need to load the LCM checkpoint for your supported model into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the pipeline as usual, and pass a text prompt to generate an image in just 4 steps.',r,o,l="A couple of notes to keep in mind when using LCMs are:",i,m,u="<li>Typically, batch size is doubled inside the pipeline for classifier-free guidance. But LCM applies guidance with guidance embeddings and doesn’t need to double the batch size, which leads to faster inference. The downside is that negative prompts don’t work with LCM because they don’t have any effect on the denoising process.</li> <li>The ideal range for <code>guidance_scale</code> is [3., 13.] because that is what the UNet was trained with. However, disabling <code>guidance_scale</code> with a value of 1.0 is also effective in most cases.</li>",t,f,G,a,w='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdxl_t2i.png"/>',E;return f=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tc2R4bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJTZWxmLXBvcnRyYWl0JTIwb2lsJTIwcGFpbnRpbmclMkMlMjBhJTIwYmVhdXRpZnVsJTIwY3lib3JnJTIwd2l0aCUyMGdvbGRlbiUyMGhhaXIlMkMlMjA4ayUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUzRHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q4LjAlMEEpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">8.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("p"),o.textContent=l,i=d(),m=J("ul"),m.innerHTML=u,t=d(),T(f.$$.fragment),G=d(),a=J("div"),a.innerHTML=w,this.h()},l(h){s=g(h,"P",{"data-svelte-h":!0}),U(s)!=="svelte-c1j69g"&&(s.innerHTML=y),r=M(h),o=g(h,"P",{"data-svelte-h":!0}),U(o)!=="svelte-185mgq9"&&(o.textContent=l),i=M(h),m=g(h,"UL",{"data-svelte-h":!0}),U(m)!=="svelte-1mvqiqn"&&(m.innerHTML=u),t=M(h),b(f.$$.fragment,h),G=M(h),a=g(h,"DIV",{class:!0,"data-svelte-h":!0}),U(a)!=="svelte-r54e1a"&&(a.innerHTML=w),this.h()},h(){R(a,"class","flex justify-center")},m(h,B){p(h,s,B),p(h,r,B),p(h,o,B),p(h,i,B),p(h,m,B),p(h,t,B),j(f,h,B),p(h,G,B),p(h,a,B),E=!0},p:v,i(h){E||(Z(f.$$.fragment,h),E=!0)},o(h){W(f.$$.fragment,h),E=!1},d(h){h&&(n(s),n(r),n(o),n(i),n(m),n(t),n(G),n(a)),C(f,h)}}}function yl(I){let s,y='To use LCM-LoRAs, you need to replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt to generate an image in just 4 steps.',r,o,l="A couple of notes to keep in mind when using LCM-LoRAs are:",i,m,u='<li>Typically, batch size is doubled inside the pipeline for classifier-free guidance. But LCM applies guidance with guidance embeddings and doesn’t need to double the batch size, which leads to faster inference. The downside is that negative prompts don’t work with LCM because they don’t have any effect on the denoising process.</li> <li>You could use guidance with LCM-LoRAs, but it is very sensitive to high <code>guidance_scale</code> values and can lead to artifacts in the generated image. The best values we’ve found are between [1.0, 2.0].</li> <li>Replace <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with any finetuned model. For example, try using the <a href="https://huggingface.co/Linaqruf/animagine-xl" rel="nofollow">animagine-xl</a> checkpoint to generate anime images with SDXL.</li>',t,f,G,a,w='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdxl_t2i.png"/>',E;return f=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyU2VsZi1wb3J0cmFpdCUyMG9pbCUyMHBhaW50aW5nJTJDJTIwYSUyMGJlYXV0aWZ1bCUyMGN5Ym9yZyUyMHdpdGglMjBnb2xkZW4lMjBoYWlyJTJDJTIwOGslMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDEuMCUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;Self-portrait oil painting, a beautiful cyborg with golden hair, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">42</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">1.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("p"),o.textContent=l,i=d(),m=J("ul"),m.innerHTML=u,t=d(),T(f.$$.fragment),G=d(),a=J("div"),a.innerHTML=w,this.h()},l(h){s=g(h,"P",{"data-svelte-h":!0}),U(s)!=="svelte-16y4sws"&&(s.innerHTML=y),r=M(h),o=g(h,"P",{"data-svelte-h":!0}),U(o)!=="svelte-1l0tu8o"&&(o.textContent=l),i=M(h),m=g(h,"UL",{"data-svelte-h":!0}),U(m)!=="svelte-yd1arq"&&(m.innerHTML=u),t=M(h),b(f.$$.fragment,h),G=M(h),a=g(h,"DIV",{class:!0,"data-svelte-h":!0}),U(a)!=="svelte-1qjqi5a"&&(a.innerHTML=w),this.h()},h(){R(a,"class","flex justify-center")},m(h,B){p(h,s,B),p(h,r,B),p(h,o,B),p(h,i,B),p(h,m,B),p(h,t,B),j(f,h,B),p(h,G,B),p(h,a,B),E=!0},p:v,i(h){E||(Z(f.$$.fragment,h),E=!0)},o(h){W(f.$$.fragment,h),E=!1},d(h){h&&(n(s),n(r),n(o),n(i),n(m),n(t),n(G),n(a)),C(f,h)}}}function fl(I){let s,y,r,o;return s=new _({props:{id:"lcm-text2img",option:"LCM",$$slots:{default:[hl]},$$scope:{ctx:I}}}),r=new _({props:{id:"lcm-text2img",option:"LCM-LoRA",$$slots:{default:[yl]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment),y=d(),T(r.$$.fragment)},l(l){b(s.$$.fragment,l),y=M(l),b(r.$$.fragment,l)},m(l,i){j(s,l,i),p(l,y,i),j(r,l,i),o=!0},p(l,i){const m={};i&2&&(m.$$scope={dirty:i,ctx:l}),s.$set(m);const u={};i&2&&(u.$$scope={dirty:i,ctx:l}),r.$set(u)},i(l){o||(Z(s.$$.fragment,l),Z(r.$$.fragment,l),o=!0)},o(l){W(s.$$.fragment,l),W(r.$$.fragment,l),o=!1},d(l){l&&n(y),C(s,l),C(r,l)}}}function Jl(I){let s,y='To use LCMs for image-to-image, you need to load the LCM checkpoint for your supported model into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the pipeline as usual, and pass a text prompt and initial image to generate an image in just 4 steps.',r,o,l="<p>Experiment with different values for <code>num_inference_steps</code>, <code>strength</code>, and <code>guidance_scale</code> to get the best results.</p>",i,m,u,t,f='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',G;return m=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJTaW1pYW5MdW8lMkZMQ01fRHJlYW1zaGFwZXJfdjclMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTHlrb24lMkZkcmVhbXNoYXBlci03JTIyJTJDJTBBJTIwJTIwJTIwJTIwdW5ldCUzRHVuZXQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW1nMmltZy1pbml0LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXRzJTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>,
    subfolder=<span class="hljs-string">&quot;unet&quot;</span>,
    torch_dtype=torch.float16,
)

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>,
    unet=unet,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronauts in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt,
    image=init_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">7.5</span>,
    strength=<span class="hljs-number">0.5</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("blockquote"),o.innerHTML=l,i=d(),T(m.$$.fragment),u=d(),t=J("div"),t.innerHTML=f,this.h()},l(a){s=g(a,"P",{"data-svelte-h":!0}),U(s)!=="svelte-1gm91p6"&&(s.innerHTML=y),r=M(a),o=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(o)!=="svelte-no4hyc"&&(o.innerHTML=l),i=M(a),b(m.$$.fragment,a),u=M(a),t=g(a,"DIV",{class:!0,"data-svelte-h":!0}),U(t)!=="svelte-f0uu5w"&&(t.innerHTML=f),this.h()},h(){R(o,"class","tip"),R(t,"class","flex gap-4")},m(a,w){p(a,s,w),p(a,r,w),p(a,o,w),p(a,i,w),j(m,a,w),p(a,u,w),p(a,t,w),G=!0},p:v,i(a){G||(Z(m.$$.fragment,a),G=!0)},o(a){W(m.$$.fragment,a),G=!1},d(a){a&&(n(s),n(r),n(o),n(i),n(u),n(t)),C(m,a)}}}function gl(I){let s,y='To use LCM-LoRAs for image-to-image, you need to replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt and initial image to generate an image in just 4 steps.',r,o,l="<p>Experiment with different values for <code>num_inference_steps</code>, <code>strength</code>, and <code>guidance_scale</code> to get the best results.</p>",i,m,u,t,f='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-img2img.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',G;return m=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW1hZ2UySW1hZ2UlMkMlMjBMQ01TY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbWFrZV9pbWFnZV9ncmlkJTJDJTIwbG9hZF9pbWFnZSUwQSUwQXBpcGUlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JJbWFnZTJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyTHlrb24lMkZkcmVhbXNoYXBlci03JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmltZzJpbWctaW5pdC5wbmclMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0cyUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMSUyQyUwQSUyMCUyMCUyMCUyMHN0cmVuZ3RoJTNEMC42JTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> make_image_grid, load_image

pipe = AutoPipelineForImage2Image.from_pretrained(
    <span class="hljs-string">&quot;Lykon/dreamshaper-7&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronauts in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt,
    image=init_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1</span>,
    strength=<span class="hljs-number">0.6</span>,
    generator=generator
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("blockquote"),o.innerHTML=l,i=d(),T(m.$$.fragment),u=d(),t=J("div"),t.innerHTML=f,this.h()},l(a){s=g(a,"P",{"data-svelte-h":!0}),U(s)!=="svelte-18m7zh0"&&(s.innerHTML=y),r=M(a),o=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(o)!=="svelte-no4hyc"&&(o.innerHTML=l),i=M(a),b(m.$$.fragment,a),u=M(a),t=g(a,"DIV",{class:!0,"data-svelte-h":!0}),U(t)!=="svelte-1n6qllf"&&(t.innerHTML=f),this.h()},h(){R(o,"class","tip"),R(t,"class","flex gap-4")},m(a,w){p(a,s,w),p(a,r,w),p(a,o,w),p(a,i,w),j(m,a,w),p(a,u,w),p(a,t,w),G=!0},p:v,i(a){G||(Z(m.$$.fragment,a),G=!0)},o(a){W(m.$$.fragment,a),G=!1},d(a){a&&(n(s),n(r),n(o),n(i),n(u),n(t)),C(m,a)}}}function Ul(I){let s,y,r,o;return s=new _({props:{id:"lcm-img2img",option:"LCM",$$slots:{default:[Jl]},$$scope:{ctx:I}}}),r=new _({props:{id:"lcm-img2img",option:"LCM-LoRA",$$slots:{default:[gl]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment),y=d(),T(r.$$.fragment)},l(l){b(s.$$.fragment,l),y=M(l),b(r.$$.fragment,l)},m(l,i){j(s,l,i),p(l,y,i),j(r,l,i),o=!0},p(l,i){const m={};i&2&&(m.$$scope={dirty:i,ctx:l}),s.$set(m);const u={};i&2&&(u.$$scope={dirty:i,ctx:l}),r.$set(u)},i(l){o||(Z(s.$$.fragment,l),Z(r.$$.fragment,l),o=!0)},o(l){W(s.$$.fragment,l),W(r.$$.fragment,l),o=!1},d(l){l&&n(y),C(s,l),C(r,l)}}}function wl(I){let s,y='Load the LCM checkpoint for your supported model into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LoRA weights into the LCM and generate a styled image in a few steps.',r,o,l,i,m='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdx_lora_mix.png"/>',u;return o=new N({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCUyQyUyMExDTVNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJsYXRlbnQtY29uc2lzdGVuY3klMkZsY20tc2R4bCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMlRoZUxhc3RCZW4lMkZQYXBlcmN1dF9TRFhMJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJwYXBlcmN1dC5zYWZldGVuc29ycyUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnBhcGVyY3V0JTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMnBhcGVyY3V0JTJDJTIwYSUyMGN1dGUlMjBmb3glMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEOC4wJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, UNet2DConditionModel, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipe.load_lora_weights(<span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>, weight_name=<span class="hljs-string">&quot;papercut.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;papercut&quot;</span>)

prompt = <span class="hljs-string">&quot;papercut, a cute fox&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt, num_inference_steps=<span class="hljs-number">4</span>, generator=generator, guidance_scale=<span class="hljs-number">8.0</span>
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),T(o.$$.fragment),l=d(),i=J("div"),i.innerHTML=m,this.h()},l(t){s=g(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-1hfr2gt"&&(s.innerHTML=y),r=M(t),b(o.$$.fragment,t),l=M(t),i=g(t,"DIV",{class:!0,"data-svelte-h":!0}),U(i)!=="svelte-1205m44"&&(i.innerHTML=m),this.h()},h(){R(i,"class","flex justify-center")},m(t,f){p(t,s,f),p(t,r,f),j(o,t,f),p(t,l,f),p(t,i,f),u=!0},p:v,i(t){u||(Z(o.$$.fragment,t),u=!0)},o(t){W(o.$$.fragment,t),u=!1},d(t){t&&(n(s),n(r),n(l),n(i)),C(o,t)}}}function Tl(I){let s,y='Replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Then you can use the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights and the style LoRA you want to use. Combine both LoRA adapters with the <code>~loaders.UNet2DConditionLoadersMixin.set_adapters</code> method and generate a styled image in a few steps.',r,o,l,i,m='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdx_lora_mix.png"/>',u;return o=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkeGwlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJsY20lMjIpJTBBcGlwZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJUaGVMYXN0QmVuJTJGUGFwZXJjdXRfU0RYTCUyMiUyQyUyMHdlaWdodF9uYW1lJTNEJTIycGFwZXJjdXQuc2FmZXRlbnNvcnMlMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJwYXBlcmN1dCUyMiklMEElMEFwaXBlLnNldF9hZGFwdGVycyglNUIlMjJsY20lMjIlMkMlMjAlMjJwYXBlcmN1dCUyMiU1RCUyQyUyMGFkYXB0ZXJfd2VpZ2h0cyUzRCU1QjEuMCUyQyUyMDAuOCU1RCklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJwYXBlcmN1dCUyQyUyMGElMjBjdXRlJTIwZm94JTIyJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2gubWFudWFsX3NlZWQoMCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDElMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, LCMScheduler

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
    torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;TheLastBen/Papercut_SDXL&quot;</span>, weight_name=<span class="hljs-string">&quot;papercut.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;papercut&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;papercut&quot;</span>], adapter_weights=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>])

prompt = <span class="hljs-string">&quot;papercut, a cute fox&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1</span>, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),T(o.$$.fragment),l=d(),i=J("div"),i.innerHTML=m,this.h()},l(t){s=g(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-1qos997"&&(s.innerHTML=y),r=M(t),b(o.$$.fragment,t),l=M(t),i=g(t,"DIV",{class:!0,"data-svelte-h":!0}),U(i)!=="svelte-1onami8"&&(i.innerHTML=m),this.h()},h(){R(i,"class","flex justify-center")},m(t,f){p(t,s,f),p(t,r,f),j(o,t,f),p(t,l,f),p(t,i,f),u=!0},p:v,i(t){u||(Z(o.$$.fragment,t),u=!0)},o(t){W(o.$$.fragment,t),u=!1},d(t){t&&(n(s),n(r),n(l),n(i)),C(o,t)}}}function bl(I){let s,y,r,o;return s=new _({props:{id:"lcm-lora",option:"LCM",$$slots:{default:[wl]},$$scope:{ctx:I}}}),r=new _({props:{id:"lcm-lora",option:"LCM-LoRA",$$slots:{default:[Tl]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment),y=d(),T(r.$$.fragment)},l(l){b(s.$$.fragment,l),y=M(l),b(r.$$.fragment,l)},m(l,i){j(s,l,i),p(l,y,i),j(r,l,i),o=!0},p(l,i){const m={};i&2&&(m.$$scope={dirty:i,ctx:l}),s.$set(m);const u={};i&2&&(u.$$scope={dirty:i,ctx:l}),r.$set(u)},i(l){o||(Z(s.$$.fragment,l),Z(r.$$.fragment,l),o=!0)},o(l){W(s.$$.fragment,l),W(r.$$.fragment,l),o=!1},d(l){l&&n(y),C(s,l),C(r,l)}}}function jl(I){let s,y='Load a ControlNet model trained on canny images and pass it to the <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. Then you can load a LCM model into <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Now pass the canny image to the pipeline and generate an image.',r,o,l="<p>Experiment with different values for <code>num_inference_steps</code>, <code>controlnet_conditioning_scale</code>, <code>cross_attention_kwargs</code>, and <code>guidance_scale</code> to get the best results.</p>",i,m,u,t,f='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_full_sdv1-5_controlnet.png"/>',G;return m=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
make_image_grid([canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("blockquote"),o.innerHTML=l,i=d(),T(m.$$.fragment),u=d(),t=J("div"),t.innerHTML=f,this.h()},l(a){s=g(a,"P",{"data-svelte-h":!0}),U(s)!=="svelte-1t6lo1z"&&(s.innerHTML=y),r=M(a),o=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(o)!=="svelte-1os48ku"&&(o.innerHTML=l),i=M(a),b(m.$$.fragment,a),u=M(a),t=g(a,"DIV",{class:!0,"data-svelte-h":!0}),U(t)!=="svelte-1f4gba0"&&(t.innerHTML=f),this.h()},h(){R(o,"class","tip"),R(t,"class","flex justify-center")},m(a,w){p(a,s,w),p(a,r,w),p(a,o,w),p(a,i,w),j(m,a,w),p(a,u,w),p(a,t,w),G=!0},p:v,i(a){G||(Z(m.$$.fragment,a),G=!0)},o(a){W(m.$$.fragment,a),G=!1},d(a){a&&(n(s),n(r),n(o),n(i),n(u),n(t)),C(m,a)}}}function Zl(I){let s,y='Load a ControlNet model trained on canny images and pass it to the <a href="/docs/diffusers/main/en/api/models/controlnet#diffusers.ControlNetModel">ControlNetModel</a>. Then you can load a Stable Diffusion v1.5 model into <a href="/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Use the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights, and pass the canny image to the pipeline and generate an image.',r,o,l="<p>Experiment with different values for <code>num_inference_steps</code>, <code>controlnet_conditioning_scale</code>, <code>cross_attention_kwargs</code>, and <code>guidance_scale</code> to get the best results.</p>",i,m,u,t,f='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm/lcm_sdv1-5_controlnet.png"/>',G;return m=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
    controlnet=controlnet,
    torch_dtype=torch.float16,
    safety_checker=<span class="hljs-literal">None</span>,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    controlnet_conditioning_scale=<span class="hljs-number">0.8</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    generator=generator,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),o=J("blockquote"),o.innerHTML=l,i=d(),T(m.$$.fragment),u=d(),t=J("div"),t.innerHTML=f,this.h()},l(a){s=g(a,"P",{"data-svelte-h":!0}),U(s)!=="svelte-1lodz5c"&&(s.innerHTML=y),r=M(a),o=g(a,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(o)!=="svelte-1os48ku"&&(o.innerHTML=l),i=M(a),b(m.$$.fragment,a),u=M(a),t=g(a,"DIV",{class:!0,"data-svelte-h":!0}),U(t)!=="svelte-1s0658k"&&(t.innerHTML=f),this.h()},h(){R(o,"class","tip"),R(t,"class","flex justify-center")},m(a,w){p(a,s,w),p(a,r,w),p(a,o,w),p(a,i,w),j(m,a,w),p(a,u,w),p(a,t,w),G=!0},p:v,i(a){G||(Z(m.$$.fragment,a),G=!0)},o(a){W(m.$$.fragment,a),G=!1},d(a){a&&(n(s),n(r),n(o),n(i),n(u),n(t)),C(m,a)}}}function Wl(I){let s,y,r,o;return s=new _({props:{id:"lcm-controlnet",option:"LCM",$$slots:{default:[jl]},$$scope:{ctx:I}}}),r=new _({props:{id:"lcm-controlnet",option:"LCM-LoRA",$$slots:{default:[Zl]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment),y=d(),T(r.$$.fragment)},l(l){b(s.$$.fragment,l),y=M(l),b(r.$$.fragment,l)},m(l,i){j(s,l,i),p(l,y,i),j(r,l,i),o=!0},p(l,i){const m={};i&2&&(m.$$scope={dirty:i,ctx:l}),s.$set(m);const u={};i&2&&(u.$$scope={dirty:i,ctx:l}),r.$set(u)},i(l){o||(Z(s.$$.fragment,l),Z(r.$$.fragment,l),o=!0)},o(l){W(s.$$.fragment,l),W(r.$$.fragment,l),o=!1},d(l){l&&n(y),C(s,l),C(r,l)}}}function Cl(I){let s,y='Load a T2IAdapter trained on canny images and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/adapter#diffusers.StableDiffusionXLAdapterPipeline">StableDiffusionXLAdapterPipeline</a>. Then load a LCM checkpoint into <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a> and replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>. Now pass the canny image to the pipeline and generate an image.',r,o,l,i,m='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-t2i.png"/>',u;return o=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, UNet2DConditionModel, T2IAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># detect the canny map in low resolution to avoid high-frequency details</span>
image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">384</span>, <span class="hljs-number">384</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1216</span>))

adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

unet = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;latent-consistency/lcm-sdxl&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
)
pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    unet=unet,
    adapter=adapter,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

prompt = <span class="hljs-string">&quot;the mona lisa, 4k picture, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;extra digit, fewer digits, cropped, worst quality, low quality, glitch, deformed, mutated, ugly, disfigured&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">5</span>,
    adapter_conditioning_scale=<span class="hljs-number">0.8</span>,
    adapter_conditioning_factor=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),T(o.$$.fragment),l=d(),i=J("div"),i.innerHTML=m,this.h()},l(t){s=g(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-83916k"&&(s.innerHTML=y),r=M(t),b(o.$$.fragment,t),l=M(t),i=g(t,"DIV",{class:!0,"data-svelte-h":!0}),U(i)!=="svelte-1m6j6i7"&&(i.innerHTML=m),this.h()},h(){R(i,"class","flex justify-center")},m(t,f){p(t,s,f),p(t,r,f),j(o,t,f),p(t,l,f),p(t,i,f),u=!0},p:v,i(t){u||(Z(o.$$.fragment,t),u=!0)},o(t){W(o.$$.fragment,t),u=!1},d(t){t&&(n(s),n(r),n(l),n(i)),C(o,t)}}}function Gl(I){let s,y='Load a T2IAdapter trained on canny images and pass it to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/adapter#diffusers.StableDiffusionXLAdapterPipeline">StableDiffusionXLAdapterPipeline</a>. Replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>, and use the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method to load the LCM-LoRA weights. Pass the canny image to the pipeline and generate an image.',r,o,l,i,m='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-t2i.png"/>',u;return o=new N({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLAdapterPipeline, UNet2DConditionModel, T2IAdapter, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># detect the canny map in low resolution to avoid high-frequency details</span>
image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
).resize((<span class="hljs-number">384</span>, <span class="hljs-number">384</span>))

image = np.array(image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

adapter = T2IAdapter.from_pretrained(<span class="hljs-string">&quot;TencentARC/t2i-adapter-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe = StableDiffusionXLAdapterPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    adapter=adapter,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdxl&quot;</span>)

prompt = <span class="hljs-string">&quot;the mona lisa, 4k picture, high quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;extra digit, fewer digits, cropped, worst quality, low quality, glitch, deformed, mutated, ugly, disfigured&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">1.5</span>,
    adapter_conditioning_scale=<span class="hljs-number">0.8</span>,
    adapter_conditioning_factor=<span class="hljs-number">1</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){s=J("p"),s.innerHTML=y,r=d(),T(o.$$.fragment),l=d(),i=J("div"),i.innerHTML=m,this.h()},l(t){s=g(t,"P",{"data-svelte-h":!0}),U(s)!=="svelte-uo979p"&&(s.innerHTML=y),r=M(t),b(o.$$.fragment,t),l=M(t),i=g(t,"DIV",{class:!0,"data-svelte-h":!0}),U(i)!=="svelte-djnrvk"&&(i.innerHTML=m),this.h()},h(){R(i,"class","flex justify-center")},m(t,f){p(t,s,f),p(t,r,f),j(o,t,f),p(t,l,f),p(t,i,f),u=!0},p:v,i(t){u||(Z(o.$$.fragment,t),u=!0)},o(t){W(o.$$.fragment,t),u=!1},d(t){t&&(n(s),n(r),n(l),n(i)),C(o,t)}}}function Il(I){let s,y,r,o;return s=new _({props:{id:"lcm-t2i",option:"LCM",$$slots:{default:[Cl]},$$scope:{ctx:I}}}),r=new _({props:{id:"lcm-t2i",option:"LCM-LoRA",$$slots:{default:[Gl]},$$scope:{ctx:I}}}),{c(){T(s.$$.fragment),y=d(),T(r.$$.fragment)},l(l){b(s.$$.fragment,l),y=M(l),b(r.$$.fragment,l)},m(l,i){j(s,l,i),p(l,y,i),j(r,l,i),o=!0},p(l,i){const m={};i&2&&(m.$$scope={dirty:i,ctx:l}),s.$set(m);const u={};i&2&&(u.$$scope={dirty:i,ctx:l}),r.$set(u)},i(l){o||(Z(s.$$.fragment,l),Z(r.$$.fragment,l),o=!0)},o(l){W(s.$$.fragment,l),W(r.$$.fragment,l),o=!1},d(l){l&&n(y),C(s,l),C(r,l)}}}function Bl(I){let s,y,r,o,l,i,m,u,t,f='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> enable fast high-quality image generation by directly predicting the reverse diffusion process in the latent rather than pixel space. In other words, LCMs try to predict the noiseless image from the noisy image in contrast to typical diffusion models that iteratively remove noise from the noisy image. By avoiding the iterative sampling process, LCMs are able to generate high-quality images in 2-4 steps instead of 20-30 steps.',G,a,w='LCMs are distilled from pretrained models which requires ~32 hours of A100 compute. To speed this up, <a href="https://hf.co/papers/2311.05556" rel="nofollow">LCM-LoRAs</a> train a <a href="https://huggingface.co/docs/peft/conceptual_guides/adapter#low-rank-adaptation-lora" rel="nofollow">LoRA adapter</a> which have much fewer parameters to train compared to the full model. The LCM-LoRA can be plugged into a diffusion model once it has been trained.',E,h,B="This guide will show you how to use LCMs and LCM-LoRAs for fast inference on tasks and how to use them with other adapters like ControlNet or T2I-Adapter.",Me,k,Ye='<p>LCMs and LCM-LoRAs are available for Stable Diffusion v1.5, Stable Diffusion XL, and the SSD-1B model. You can find their checkpoints on the <a href="https://hf.co/collections/latent-consistency/latent-consistency-models-weights-654ce61a95edd6dffccef6a8" rel="nofollow">Latent Consistency</a> Collections.</p>',ue,H,he,X,ye,x,fe,$,Je,A,ge,z,Fe='To use LCM-LoRAs for inpainting, you need to replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a> and load the LCM-LoRA weights with the <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> method. Then you can use the pipeline as usual, and pass a text prompt, initial image, and mask image to generate an image in just 4 steps.',Ue,q,we,V,He='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">initial image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-inpaint.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',Te,D,be,K,xe="LCMs are compatible with adapters like LoRA, ControlNet, T2I-Adapter, and AnimateDiff. You can bring the speed of LCMs to these adapters to generate images in a certain style or condition the model on another input like a canny image.",je,P,Ze,O,Ae='<a href="../using-diffusers/loading_adapters#lora">LoRA</a> adapters can be rapidly finetuned to learn a new style from just a few images and plugged into a pretrained model to generate images in that style.',We,L,Ce,ee,Ge,le,ze='<a href="./controlnet">ControlNet</a> are adapters that can be trained on a variety of inputs like canny edge, pose estimation, or depth. The ControlNet can be inserted into the pipeline to provide additional conditioning and control to the model for more accurate generation.',Ie,se,qe='You can find additional ControlNet models trained on other inputs in <a href="https://hf.co/lllyasviel" rel="nofollow">lllyasviel’s</a> repository.',Be,S,Re,te,Ee,ae,De='<a href="./t2i_adapter">T2I-Adapter</a> is an even more lightweight adapter than ControlNet, that provides an additional input to condition a pretrained model with. It is faster than ControlNet but the results may be slightly worse.',Ne,ne,Ke='You can find additional T2I-Adapter checkpoints trained on other inputs in <a href="https://hf.co/TencentARC" rel="nofollow">TencentArc’s</a> repository.',_e,Y,ve,ie,Qe,oe,Pe='<a href="../api/pipelines/animatediff">AnimateDiff</a> is an adapter that adds motion to an image. It can be used with most Stable Diffusion models, effectively turning them into “video generation” models. Generating good results with a video model usually requires generating multiple frames (16-24), which can be very slow with a regular Stable Diffusion model. LCM-LoRA can speed up this process by only taking 4-8 steps for each frame.',ke,pe,Oe='Load a <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and pass a <code>MotionAdapter</code> to it. Then replace the scheduler with the <a href="/docs/diffusers/main/en/api/schedulers/lcm#diffusers.LCMScheduler">LCMScheduler</a>, and combine both LoRA adapters with the <code>~loaders.UNet2DConditionLoadersMixin.set_adapters</code> method. Now you can pass a prompt to the pipeline and generate an animated image.',Xe,re,$e,F,el='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/lcm-lora-animatediff.gif"/>',Ve,ce,Le,me,Se;return l=new Q({props:{title:"Latent Consistency Model",local:"latent-consistency-model",headingTag:"h1"}}),m=new Ml({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/inference_with_lcm.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/inference_with_lcm.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/inference_with_lcm.ipynb"}]}}),H=new Q({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),X=new de({props:{id:"lcm-text2img",options:["LCM","LCM-LoRA"],$$slots:{default:[fl]},$$scope:{ctx:I}}}),x=new Q({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),$=new de({props:{id:"lcm-img2img",options:["LCM","LCM-LoRA"],$$slots:{default:[Ul]},$$scope:{ctx:I}}}),A=new Q({props:{title:"Inpainting",local:"inpainting",headingTag:"h2"}}),q=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b1BpcGVsaW5lRm9ySW5wYWludGluZyUyQyUyMExDTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBJTBBcGlwZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvcklucGFpbnRpbmcuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi1pbnBhaW50aW5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBMQ01TY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQXBpcGUubG9hZF9sb3JhX3dlaWdodHMoJTIybGF0ZW50LWNvbnNpc3RlbmN5JTJGbGNtLWxvcmEtc2R2MS01JTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnQucG5nJTIyKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmlucGFpbnRfbWFzay5wbmclMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29uY2VwdCUyMGFydCUyMGRpZ2l0YWwlMjBwYWludGluZyUyMG9mJTIwYW4lMjBlbHZlbiUyMGNhc3RsZSUyQyUyMGluc3BpcmVkJTIwYnklMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGluaXRfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBtYXNrX2ltYWdlJTNEbWFza19pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q0JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForInpainting, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

pipe = AutoPipelineForInpainting.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-inpainting&quot;</span>,
    torch_dtype=torch.float16,
    variant=<span class="hljs-string">&quot;fp16&quot;</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint.png&quot;</span>)
mask_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/inpaint_mask.png&quot;</span>)

prompt = <span class="hljs-string">&quot;concept art digital painting of an elven castle, inspired by lord of the rings, highly detailed, 8k&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
image = pipe(
    prompt=prompt,
    image=init_image,
    mask_image=mask_image,
    generator=generator,
    num_inference_steps=<span class="hljs-number">4</span>,
    guidance_scale=<span class="hljs-number">4</span>,
).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),D=new Q({props:{title:"Adapters",local:"adapters",headingTag:"h2"}}),P=new Q({props:{title:"LoRA",local:"lora",headingTag:"h3"}}),L=new de({props:{id:"lcm-lora",options:["LCM","LCM-LoRA"],$$slots:{default:[bl]},$$scope:{ctx:I}}}),ee=new Q({props:{title:"ControlNet",local:"controlnet",headingTag:"h3"}}),S=new de({props:{id:"lcm-controlnet",options:["LCM","LCM-LoRA"],$$slots:{default:[Wl]},$$scope:{ctx:I}}}),te=new Q({props:{title:"T2I-Adapter",local:"t2i-adapter",headingTag:"h3"}}),Y=new de({props:{id:"lcm-t2i",options:["LCM","LCM-LoRA"],$$slots:{default:[Il]},$$scope:{ctx:I}}}),ie=new Q({props:{title:"AnimateDiff",local:"animatediff",headingTag:"h3"}}),re=new N({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTW90aW9uQWRhcHRlciUyQyUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBERElNU2NoZWR1bGVyJTJDJTIwTENNU2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGV4cG9ydF90b19naWYlMEElMEFhZGFwdGVyJTIwJTNEJTIwTW90aW9uQWRhcHRlci5mcm9tX3ByZXRyYWluZWQoJTIyZ3VveXd3JTJGYW5pbWF0ZWRpZmYtbW90aW9uLWFkYXB0ZXItdjEtNSUyMiklMEFwaXBlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZnJhbmtqb3NodWElMkZ0b29ueW91X2JldGE2JTIyJTJDJTBBJTIwJTIwJTIwJTIwbW90aW9uX2FkYXB0ZXIlM0RhZGFwdGVyJTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMHNldCUyMHNjaGVkdWxlciUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwTENNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEElMjMlMjBsb2FkJTIwTENNLUxvUkElMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmxhdGVudC1jb25zaXN0ZW5jeSUyRmxjbS1sb3JhLXNkdjEtNSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmxjbSUyMiklMEFwaXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMmd1b3l3dyUyRmFuaW1hdGVkaWZmLW1vdGlvbi1sb3JhLXpvb20taW4lMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIybW90aW9uLWxvcmElMjIpJTBBJTBBcGlwZS5zZXRfYWRhcHRlcnMoJTVCJTIybGNtJTIyJTJDJTIwJTIybW90aW9uLWxvcmElMjIlNUQlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QlNUIwLjU1JTJDJTIwMS4yJTVEKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmJlc3QlMjBxdWFsaXR5JTJDJTIwbWFzdGVycGllY2UlMkMlMjAxZ2lybCUyQyUyMGxvb2tpbmclMjBhdCUyMHZpZXdlciUyQyUyMGJsdXJyeSUyMGJhY2tncm91bmQlMkMlMjB1cHBlciUyMGJvZHklMkMlMjBjb250ZW1wb3JhcnklMkMlMjBkcmVzcyUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLm1hbnVhbF9zZWVkKDApJTBBZnJhbWVzJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENSUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4yNSUyQyUwQSUyMCUyMCUyMCUyMGNyb3NzX2F0dGVudGlvbl9rd2FyZ3MlM0QlN0IlMjJzY2FsZSUyMiUzQSUyMDElN0QlMkMlMEElMjAlMjAlMjAlMjBudW1fZnJhbWVzJTNEMjQlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMEEpLmZyYW1lcyU1QjAlNUQlMEFleHBvcnRfdG9fZ2lmKGZyYW1lcyUyQyUyMCUyMmFuaW1hdGlvbi5naWYlMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> MotionAdapter, AnimateDiffPipeline, DDIMScheduler, LCMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5&quot;</span>)
pipe = AnimateDiffPipeline.from_pretrained(
    <span class="hljs-string">&quot;frankjoshua/toonyou_beta6&quot;</span>,
    motion_adapter=adapter,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># set scheduler</span>
pipe.scheduler = LCMScheduler.from_config(pipe.scheduler.config)

<span class="hljs-comment"># load LCM-LoRA</span>
pipe.load_lora_weights(<span class="hljs-string">&quot;latent-consistency/lcm-lora-sdv1-5&quot;</span>, adapter_name=<span class="hljs-string">&quot;lcm&quot;</span>)
pipe.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-in&quot;</span>, weight_name=<span class="hljs-string">&quot;diffusion_pytorch_model.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;motion-lora&quot;</span>)

pipe.set_adapters([<span class="hljs-string">&quot;lcm&quot;</span>, <span class="hljs-string">&quot;motion-lora&quot;</span>], adapter_weights=[<span class="hljs-number">0.55</span>, <span class="hljs-number">1.2</span>])

prompt = <span class="hljs-string">&quot;best quality, masterpiece, 1girl, looking at viewer, blurry background, upper body, contemporary, dress&quot;</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)
frames = pipe(
    prompt=prompt,
    num_inference_steps=<span class="hljs-number">5</span>,
    guidance_scale=<span class="hljs-number">1.25</span>,
    cross_attention_kwargs={<span class="hljs-string">&quot;scale&quot;</span>: <span class="hljs-number">1</span>},
    num_frames=<span class="hljs-number">24</span>,
    generator=generator
).frames[<span class="hljs-number">0</span>]
export_to_gif(frames, <span class="hljs-string">&quot;animation.gif&quot;</span>)`,wrap:!1}}),ce=new ul({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/inference_with_lcm.md"}}),{c(){s=J("meta"),y=d(),r=J("p"),o=d(),T(l.$$.fragment),i=d(),T(m.$$.fragment),u=d(),t=J("p"),t.innerHTML=f,G=d(),a=J("p"),a.innerHTML=w,E=d(),h=J("p"),h.textContent=B,Me=d(),k=J("blockquote"),k.innerHTML=Ye,ue=d(),T(H.$$.fragment),he=d(),T(X.$$.fragment),ye=d(),T(x.$$.fragment),fe=d(),T($.$$.fragment),Je=d(),T(A.$$.fragment),ge=d(),z=J("p"),z.innerHTML=Fe,Ue=d(),T(q.$$.fragment),we=d(),V=J("div"),V.innerHTML=He,Te=d(),T(D.$$.fragment),be=d(),K=J("p"),K.textContent=xe,je=d(),T(P.$$.fragment),Ze=d(),O=J("p"),O.innerHTML=Ae,We=d(),T(L.$$.fragment),Ce=d(),T(ee.$$.fragment),Ge=d(),le=J("p"),le.innerHTML=ze,Ie=d(),se=J("p"),se.innerHTML=qe,Be=d(),T(S.$$.fragment),Re=d(),T(te.$$.fragment),Ee=d(),ae=J("p"),ae.innerHTML=De,Ne=d(),ne=J("p"),ne.innerHTML=Ke,_e=d(),T(Y.$$.fragment),ve=d(),T(ie.$$.fragment),Qe=d(),oe=J("p"),oe.innerHTML=Pe,ke=d(),pe=J("p"),pe.innerHTML=Oe,Xe=d(),T(re.$$.fragment),$e=d(),F=J("div"),F.innerHTML=el,Ve=d(),T(ce.$$.fragment),Le=d(),me=J("p"),this.h()},l(e){const c=ml("svelte-u9bgzb",document.head);s=g(c,"META",{name:!0,content:!0}),c.forEach(n),y=M(e),r=g(e,"P",{}),il(r).forEach(n),o=M(e),b(l.$$.fragment,e),i=M(e),b(m.$$.fragment,e),u=M(e),t=g(e,"P",{"data-svelte-h":!0}),U(t)!=="svelte-fadb22"&&(t.innerHTML=f),G=M(e),a=g(e,"P",{"data-svelte-h":!0}),U(a)!=="svelte-1nhlbs8"&&(a.innerHTML=w),E=M(e),h=g(e,"P",{"data-svelte-h":!0}),U(h)!=="svelte-vcrp3b"&&(h.textContent=B),Me=M(e),k=g(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),U(k)!=="svelte-k4lcym"&&(k.innerHTML=Ye),ue=M(e),b(H.$$.fragment,e),he=M(e),b(X.$$.fragment,e),ye=M(e),b(x.$$.fragment,e),fe=M(e),b($.$$.fragment,e),Je=M(e),b(A.$$.fragment,e),ge=M(e),z=g(e,"P",{"data-svelte-h":!0}),U(z)!=="svelte-d6f0ch"&&(z.innerHTML=Fe),Ue=M(e),b(q.$$.fragment,e),we=M(e),V=g(e,"DIV",{class:!0,"data-svelte-h":!0}),U(V)!=="svelte-1olacag"&&(V.innerHTML=He),Te=M(e),b(D.$$.fragment,e),be=M(e),K=g(e,"P",{"data-svelte-h":!0}),U(K)!=="svelte-i3adm8"&&(K.textContent=xe),je=M(e),b(P.$$.fragment,e),Ze=M(e),O=g(e,"P",{"data-svelte-h":!0}),U(O)!=="svelte-1wvykf5"&&(O.innerHTML=Ae),We=M(e),b(L.$$.fragment,e),Ce=M(e),b(ee.$$.fragment,e),Ge=M(e),le=g(e,"P",{"data-svelte-h":!0}),U(le)!=="svelte-1fviti6"&&(le.innerHTML=ze),Ie=M(e),se=g(e,"P",{"data-svelte-h":!0}),U(se)!=="svelte-1wwp3s2"&&(se.innerHTML=qe),Be=M(e),b(S.$$.fragment,e),Re=M(e),b(te.$$.fragment,e),Ee=M(e),ae=g(e,"P",{"data-svelte-h":!0}),U(ae)!=="svelte-tl9wrs"&&(ae.innerHTML=De),Ne=M(e),ne=g(e,"P",{"data-svelte-h":!0}),U(ne)!=="svelte-18ngb4o"&&(ne.innerHTML=Ke),_e=M(e),b(Y.$$.fragment,e),ve=M(e),b(ie.$$.fragment,e),Qe=M(e),oe=g(e,"P",{"data-svelte-h":!0}),U(oe)!=="svelte-14vivd7"&&(oe.innerHTML=Pe),ke=M(e),pe=g(e,"P",{"data-svelte-h":!0}),U(pe)!=="svelte-1tdp050"&&(pe.innerHTML=Oe),Xe=M(e),b(re.$$.fragment,e),$e=M(e),F=g(e,"DIV",{class:!0,"data-svelte-h":!0}),U(F)!=="svelte-8kha3o"&&(F.innerHTML=el),Ve=M(e),b(ce.$$.fragment,e),Le=M(e),me=g(e,"P",{}),il(me).forEach(n),this.h()},h(){R(s,"name","hf:doc:metadata"),R(s,"content",Rl),R(k,"class","tip"),R(V,"class","flex gap-4"),R(F,"class","flex justify-center")},m(e,c){dl(document.head,s),p(e,y,c),p(e,r,c),p(e,o,c),j(l,e,c),p(e,i,c),j(m,e,c),p(e,u,c),p(e,t,c),p(e,G,c),p(e,a,c),p(e,E,c),p(e,h,c),p(e,Me,c),p(e,k,c),p(e,ue,c),j(H,e,c),p(e,he,c),j(X,e,c),p(e,ye,c),j(x,e,c),p(e,fe,c),j($,e,c),p(e,Je,c),j(A,e,c),p(e,ge,c),p(e,z,c),p(e,Ue,c),j(q,e,c),p(e,we,c),p(e,V,c),p(e,Te,c),j(D,e,c),p(e,be,c),p(e,K,c),p(e,je,c),j(P,e,c),p(e,Ze,c),p(e,O,c),p(e,We,c),j(L,e,c),p(e,Ce,c),j(ee,e,c),p(e,Ge,c),p(e,le,c),p(e,Ie,c),p(e,se,c),p(e,Be,c),j(S,e,c),p(e,Re,c),j(te,e,c),p(e,Ee,c),p(e,ae,c),p(e,Ne,c),p(e,ne,c),p(e,_e,c),j(Y,e,c),p(e,ve,c),j(ie,e,c),p(e,Qe,c),p(e,oe,c),p(e,ke,c),p(e,pe,c),p(e,Xe,c),j(re,e,c),p(e,$e,c),p(e,F,c),p(e,Ve,c),j(ce,e,c),p(e,Le,c),p(e,me,c),Se=!0},p(e,[c]){const ll={};c&2&&(ll.$$scope={dirty:c,ctx:e}),X.$set(ll);const sl={};c&2&&(sl.$$scope={dirty:c,ctx:e}),$.$set(sl);const tl={};c&2&&(tl.$$scope={dirty:c,ctx:e}),L.$set(tl);const al={};c&2&&(al.$$scope={dirty:c,ctx:e}),S.$set(al);const nl={};c&2&&(nl.$$scope={dirty:c,ctx:e}),Y.$set(nl)},i(e){Se||(Z(l.$$.fragment,e),Z(m.$$.fragment,e),Z(H.$$.fragment,e),Z(X.$$.fragment,e),Z(x.$$.fragment,e),Z($.$$.fragment,e),Z(A.$$.fragment,e),Z(q.$$.fragment,e),Z(D.$$.fragment,e),Z(P.$$.fragment,e),Z(L.$$.fragment,e),Z(ee.$$.fragment,e),Z(S.$$.fragment,e),Z(te.$$.fragment,e),Z(Y.$$.fragment,e),Z(ie.$$.fragment,e),Z(re.$$.fragment,e),Z(ce.$$.fragment,e),Se=!0)},o(e){W(l.$$.fragment,e),W(m.$$.fragment,e),W(H.$$.fragment,e),W(X.$$.fragment,e),W(x.$$.fragment,e),W($.$$.fragment,e),W(A.$$.fragment,e),W(q.$$.fragment,e),W(D.$$.fragment,e),W(P.$$.fragment,e),W(L.$$.fragment,e),W(ee.$$.fragment,e),W(S.$$.fragment,e),W(te.$$.fragment,e),W(Y.$$.fragment,e),W(ie.$$.fragment,e),W(re.$$.fragment,e),W(ce.$$.fragment,e),Se=!1},d(e){e&&(n(y),n(r),n(o),n(i),n(u),n(t),n(G),n(a),n(E),n(h),n(Me),n(k),n(ue),n(he),n(ye),n(fe),n(Je),n(ge),n(z),n(Ue),n(we),n(V),n(Te),n(be),n(K),n(je),n(Ze),n(O),n(We),n(Ce),n(Ge),n(le),n(Ie),n(se),n(Be),n(Re),n(Ee),n(ae),n(Ne),n(ne),n(_e),n(ve),n(Qe),n(oe),n(ke),n(pe),n(Xe),n($e),n(F),n(Ve),n(Le),n(me)),n(s),C(l,e),C(m,e),C(H,e),C(X,e),C(x,e),C($,e),C(A,e),C(q,e),C(D,e),C(P,e),C(L,e),C(ee,e),C(S,e),C(te,e),C(Y,e),C(ie,e),C(re,e),C(ce,e)}}}const Rl='{"title":"Latent Consistency Model","local":"latent-consistency-model","sections":[{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Inpainting","local":"inpainting","sections":[],"depth":2},{"title":"Adapters","local":"adapters","sections":[{"title":"LoRA","local":"lora","sections":[],"depth":3},{"title":"ControlNet","local":"controlnet","sections":[],"depth":3},{"title":"T2I-Adapter","local":"t2i-adapter","sections":[],"depth":3},{"title":"AnimateDiff","local":"animatediff","sections":[],"depth":3}],"depth":2}],"depth":1}';function El(I){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends rl{constructor(s){super(),cl(this,s,El,Bl,ol,{})}}export{$l as component};
