import{s as jl,n as Ul,o as Il}from"../chunks/scheduler.8c3d61f6.js";import{S as Zl,i as gl,g as i,s as a,r,A as _l,h as p,f as t,c as n,j as bl,u as c,x as o,k as De,y as Bl,a as s,v as d,d as m,t as M,w as J}from"../chunks/index.da70eac4.js";import{C as u}from"../chunks/CodeBlock.a9c4becf.js";import{H as ie,E as kl}from"../chunks/getInferenceSnippets.cb466318.js";function vl(Ke){let w,pe,ae,oe,h,re,f,Oe="Distributed inference splits the workload across multiple GPUs. It a useful technique for fitting larger models in memory and can process multiple prompts for higher throughput.",ce,T,el='This guide will show you how to use <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and <a href="https://pytorch.org/tutorials/beginner/dist_overview.html" rel="nofollow">PyTorch Distributed</a> for distributed inference.',de,b,me,j,ll="Accelerate is a library designed to simplify inference and training on multiple accelerators by handling the setup, allowing users to focus on their PyTorch code.",Me,U,tl="Install Accelerate with the following command.",Je,I,ue,Z,sl='Initialize a <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class in a Python file to create a distributed environment. The <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState" rel="nofollow">accelerate.PartialState</a> class manages process management, device control and distribution, and process coordination.',we,g,al='Move the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to <code>accelerate.PartialState.device</code> to assign a GPU to each process.',ye,_,he,B,nl='Use the <a href="https://huggingface.co/docs/accelerate/main/en/package_reference/state#accelerate.PartialState.split_between_processes" rel="nofollow">split_between_processes</a> utility as a context manager to automatically distribute the prompts between the number of processes.',fe,k,Te,v,il="Call <code>accelerate launch</code> to run the script and use the <code>--num_processes</code> argument to set the number of GPUs to use.",be,C,je,G,Ue,W,pl='PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel</a> enables <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook?section=data_parallelism" rel="nofollow">data parallelism</a>, which replicates the same model on each device, to process different batches of data in parallel.',Ie,$,ol="Import <code>torch.distributed</code> and <code>torch.multiprocessing</code> into a Python file to set up the distributed process group and to spawn the processes for inference on each GPU.",Ze,E,ge,X,rl='Create a function for inference with <a href="https://pytorch.org/docs/stable/distributed.html?highlight=init_process_group#torch.distributed.init_process_group" rel="nofollow">init_process_group</a>. This method creates a distributed environment with the backend type, the <code>rank</code> of the current process, and the <code>world_size</code> or number of processes participating (for example, 2 GPUs would be <code>world_size=2</code>).',_e,N,cl="Move the pipeline to <code>rank</code> and use <code>get_rank</code> to assign a GPU to each process. Each process handles a different prompt.",Be,R,ke,V,dl='Use <a href="https://pytorch.org/docs/stable/multiprocessing.html#torch.multiprocessing.spawn" rel="nofollow">mp.spawn</a> to create the number of processes defined in <code>world_size</code>.',ve,H,Ce,x,ml="Call <code>torchrun</code> to run the inference script and use the <code>--nproc_per_node</code> argument to set the number of GPUs to use.",Ge,Y,We,Q,$e,F,Ml="The <code>device_map</code> argument enables distributed inference by automatically placing model components on separate GPUs. This is especially useful when a model doesn’t fit on a single GPU. You can use <code>device_map</code> to selectively load and unload the required model components at a given stage as shown in the example below (assumes two GPUs are available).",Ee,A,Jl="Set <code>device_map=&quot;balanced&quot;</code> to evenly distributes the text encoders on all available GPUs. You can use the <code>max_memory</code> argument to allocate a maximum amount of memory for each text encoder. Don’t load any other pipeline components to avoid memory usage.",Xe,S,Ne,z,ul="After the text embeddings are computed, remove them from the GPU to make space for the diffusion transformer.",Re,q,Ve,L,wl="Set <code>device_map=&quot;auto&quot;</code> to automatically distribute the model on the two GPUs. This strategy places a model on the fastest device first before placing a model on a slower device like a CPU or hard drive if needed. The trade-off of storing model parameters on slower devices is slower inference latency.",He,P,xe,y,yl="<p>Run <code>pipeline.hf_device_map</code> to see how the various models are distributed across devices. This is useful for tracking model device placement. You can also call <code>hf_device_map</code> on the transformer model to see how it is distributed.</p>",Ye,D,hl="Add the transformer model to the pipeline and set the <code>output_type=&quot;latent&quot;</code> to generate the latents.",Qe,K,Fe,O,fl="Remove the pipeline and transformer from memory and load a VAE to decode the latents. The VAE is typically small enough to be loaded on a single device.",Ae,ee,Se,le,ze,te,Tl='<li>Take a look at this <a href="https://gist.github.com/sayakpaul/cfaebd221820d7b43fae638b4dfa01ba" rel="nofollow">script</a> for a minimal example of distributed inference with Accelerate.</li> <li>For more details, check out Accelerate’s <a href="https://huggingface.co/docs/accelerate/en/usage_guides/distributed_inference#distributed-inference-with-accelerate" rel="nofollow">Distributed inference</a> guide.</li> <li>The <code>device_map</code> argument assign models or an entire pipeline to devices. Refer to the <a href="../using-diffusers/loading#device-placement">device placement</a> docs for more information.</li>',qe,se,Le,ne,Pe;return h=new ie({props:{title:"Distributed inference",local:"distributed-inference",headingTag:"h1"}}),b=new ie({props:{title:"Accelerate",local:"accelerate",headingTag:"h2"}}),I=new u({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwYWNjZWxlcmF0ZQ==",highlighted:"uv pip install accelerate",wrap:!1}}),_=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMFBhcnRpYWxTdGF0ZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQWRpc3RyaWJ1dGVkX3N0YXRlJTIwJTNEJTIwUGFydGlhbFN0YXRlKCklMEFwaXBlbGluZS50byhkaXN0cmlidXRlZF9zdGF0ZS5kZXZpY2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> PartialState
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16
)
distributed_state = PartialState()
pipeline.to(distributed_state.device)`,wrap:!1}}),k=new u({props:{code:"d2l0aCUyMGRpc3RyaWJ1dGVkX3N0YXRlLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMmElMjBkb2clMjIlMkMlMjAlMjJhJTIwY2F0JTIyJTVEKSUyMGFzJTIwcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwcmVzdWx0LnNhdmUoZiUyMnJlc3VsdF8lN0JkaXN0cmlidXRlZF9zdGF0ZS5wcm9jZXNzX2luZGV4JTdELnBuZyUyMik=",highlighted:`<span class="hljs-keyword">with</span> distributed_state.split_between_processes([<span class="hljs-string">&quot;a dog&quot;</span>, <span class="hljs-string">&quot;a cat&quot;</span>]) <span class="hljs-keyword">as</span> prompt:
    result = pipeline(prompt).images[<span class="hljs-number">0</span>]
    result.save(<span class="hljs-string">f&quot;result_<span class="hljs-subst">{distributed_state.process_index}</span>.png&quot;</span>)`,wrap:!1}}),C=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHJ1bl9kaXN0cmlidXRlZC5weSUyMC0tbnVtX3Byb2Nlc3NlcyUzRDI=",highlighted:"accelerate launch run_distributed.py --num_processes=2",wrap:!1}}),G=new ie({props:{title:"PyTorch Distributed",local:"pytorch-distributed",headingTag:"h2"}}),E=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5kaXN0cmlidXRlZCUyMGFzJTIwZGlzdCUwQWltcG9ydCUyMHRvcmNoLm11bHRpcHJvY2Vzc2luZyUyMGFzJTIwbXAlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJRd2VuJTJGUXdlbi1JbWFnZSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.distributed <span class="hljs-keyword">as</span> dist
<span class="hljs-keyword">import</span> torch.multiprocessing <span class="hljs-keyword">as</span> mp

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.float16,
)`,wrap:!1}}),R=new u({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShyYW5rJTJDJTIwd29ybGRfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBkaXN0LmluaXRfcHJvY2Vzc19ncm91cCglMjJuY2NsJTIyJTJDJTIwcmFuayUzRHJhbmslMkMlMjB3b3JsZF9zaXplJTNEd29ybGRfc2l6ZSklMEElMEElMjAlMjAlMjAlMjBwaXBlbGluZS50byhyYW5rKSUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwdG9yY2guZGlzdHJpYnV0ZWQuZ2V0X3JhbmsoKSUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9tcHQlMjAlM0QlMjAlMjJhJTIwZG9nJTIyJTBBJTIwJTIwJTIwJTIwZWxpZiUyMHRvcmNoLmRpc3RyaWJ1dGVkLmdldF9yYW5rKCklMjAlM0QlM0QlMjAxJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGNhdCUyMiUwQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2QocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2Uuc2F2ZShmJTIyLiUyRiU3QidfJy5qb2luKHByb21wdCklN0QucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">rank, world_size</span>):
    dist.init_process_group(<span class="hljs-string">&quot;nccl&quot;</span>, rank=rank, world_size=world_size)

    pipeline.to(rank)

    <span class="hljs-keyword">if</span> torch.distributed.get_rank() == <span class="hljs-number">0</span>:
        prompt = <span class="hljs-string">&quot;a dog&quot;</span>
    <span class="hljs-keyword">elif</span> torch.distributed.get_rank() == <span class="hljs-number">1</span>:
        prompt = <span class="hljs-string">&quot;a cat&quot;</span>

    image = sd(prompt).images[<span class="hljs-number">0</span>]
    image.save(<span class="hljs-string">f&quot;./<span class="hljs-subst">{<span class="hljs-string">&#x27;_&#x27;</span>.join(prompt)}</span>.png&quot;</span>)`,wrap:!1}}),H=new u({props:{code:"ZGVmJTIwbWFpbigpJTNBJTBBJTIwJTIwJTIwJTIwd29ybGRfc2l6ZSUyMCUzRCUyMDIlMEElMjAlMjAlMjAlMjBtcC5zcGF3bihydW5faW5mZXJlbmNlJTJDJTIwYXJncyUzRCh3b3JsZF9zaXplJTJDKSUyQyUyMG5wcm9jcyUzRHdvcmxkX3NpemUlMkMlMjBqb2luJTNEVHJ1ZSklMEElMEElMEFpZiUyMF9fbmFtZV9fJTIwJTNEJTNEJTIwJTIyX19tYWluX18lMjIlM0ElMEElMjAlMjAlMjAlMjBtYWluKCk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    world_size = <span class="hljs-number">2</span>
    mp.spawn(run_inference, args=(world_size,), nprocs=world_size, join=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    main()`,wrap:!1}}),Y=new u({props:{code:"dG9yY2hydW4lMjBydW5fZGlzdHJpYnV0ZWQucHklMjAtLW5wcm9jX3Blcl9ub2RlJTNEMg==",highlighted:"torchrun run_distributed.py --nproc_per_node=2",wrap:!1}}),Q=new ie({props:{title:"device_map",local:"devicemap",headingTag:"h2"}}),S=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsdXhQaXBlbGluZSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBY2luZW1hdGljJTIwZmlsbSUyMHN0aWxsJTIwb2YlMjBhJTIwY2F0JTIwc2lwcGluZyUyMGElMjBtYXJnYXJpdGElMjBpbiUyMGElMjBwb29sJTIwaW4lMjBQYWxtJTIwU3ByaW5ncyUyQyUyMENhbGlmb3JuaWElMEFoaWdobHklMjBkZXRhaWxlZCUyQyUyMGhpZ2glMjBidWRnZXQlMjBob2xseXdvb2QlMjBtb3ZpZSUyQyUyMGNpbmVtYXNjb3BlJTJDJTIwbW9vZHklMkMlMjBlcGljJTJDJTIwZ29yZ2VvdXMlMkMlMjBmaWxtJTIwZ3JhaW4lMEElMjIlMjIlMjIlMEElMEFwaXBlbGluZSUyMCUzRCUyMEZsdXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJiYWxhbmNlZCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9tZW1vcnklM0QlN0IwJTNBJTIwJTIyMTZHQiUyMiUyQyUyMDElM0ElMjAlMjIxNkdCJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyRW5jb2RpbmclMjBwcm9tcHRzLiUyMiklMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTJDJTIwcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMjB0ZXh0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwcHJvbXB0XzIlM0ROb25lJTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSUyMCUyMCUyMCUyMCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline
<span class="hljs-keyword">import</span> torch

prompt = <span class="hljs-string">&quot;&quot;&quot;
cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>

pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    transformer=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    device_map=<span class="hljs-string">&quot;balanced&quot;</span>,
    max_memory={<span class="hljs-number">0</span>: <span class="hljs-string">&quot;16GB&quot;</span>, <span class="hljs-number">1</span>: <span class="hljs-string">&quot;16GB&quot;</span>},
    torch_dtype=torch.bfloat16
)
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Encoding prompts.&quot;</span>)
    prompt_embeds, pooled_prompt_embeds, text_ids = pipeline.encode_prompt(
        prompt=prompt, prompt_2=<span class="hljs-literal">None</span>, max_sequence_length=<span class="hljs-number">512</span>
    )`,wrap:!1}}),q=new u({props:{code:"aW1wb3J0JTIwZ2MlMjAlMEElMEFkZWYlMjBmbHVzaCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2MuY29sbGVjdCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5lbXB0eV9jYWNoZSgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9tYXhfbWVtb3J5X2FsbG9jYXRlZCgpJTBBJTIwJTIwJTIwJTIwdG9yY2guY3VkYS5yZXNldF9wZWFrX21lbW9yeV9zdGF0cygpJTBBJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyJTBBZGVsJTIwcGlwZWxpbmUudGV4dF9lbmNvZGVyXzIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXIlMEFkZWwlMjBwaXBlbGluZS50b2tlbml6ZXJfMiUwQWRlbCUyMHBpcGVsaW5lJTBBJTBBZmx1c2goKQ==",highlighted:`<span class="hljs-keyword">import</span> gc 

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
    gc.collect()
    torch.cuda.empty_cache()
    torch.cuda.reset_max_memory_allocated()
    torch.cuda.reset_peak_memory_stats()

<span class="hljs-keyword">del</span> pipeline.text_encoder
<span class="hljs-keyword">del</span> pipeline.text_encoder_2
<span class="hljs-keyword">del</span> pipeline.tokenizer
<span class="hljs-keyword">del</span> pipeline.tokenizer_2
<span class="hljs-keyword">del</span> pipeline

flush()`,wrap:!1}}),P=new u({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQWltcG9ydCUyMHRvcmNoJTIwJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
<span class="hljs-keyword">import</span> torch 

transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, 
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    torch_dtype=torch.bfloat16
)`,wrap:!1}}),K=new u({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2RlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXJfMiUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyXzIlM0ROb25lJTJDJTBBJTIwJTIwJTIwJTIwdmFlJTNETm9uZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQXByaW50KCUyMlJ1bm5pbmclMjBkZW5vaXNpbmcuJTIyKSUwQWhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwNzY4JTJDJTIwMTM2MCUwQWxhdGVudHMlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjBwcm9tcHRfZW1iZWRzJTNEcHJvbXB0X2VtYmVkcyUyQyUwQSUyMCUyMCUyMCUyMHBvb2xlZF9wcm9tcHRfZW1iZWRzJTNEcG9vbGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuNSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRGhlaWdodCUyQyUwQSUyMCUyMCUyMCUyMHdpZHRoJTNEd2lkdGglMkMlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMiUyQyUwQSkuaW1hZ2Vz",highlighted:`pipeline = FluxPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    text_encoder=<span class="hljs-literal">None</span>,
    text_encoder_2=<span class="hljs-literal">None</span>,
    tokenizer=<span class="hljs-literal">None</span>,
    tokenizer_2=<span class="hljs-literal">None</span>,
    vae=<span class="hljs-literal">None</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16
)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running denoising.&quot;</span>)
height, width = <span class="hljs-number">768</span>, <span class="hljs-number">1360</span>
latents = pipeline(
    prompt_embeds=prompt_embeds,
    pooled_prompt_embeds=pooled_prompt_embeds,
    num_inference_steps=<span class="hljs-number">50</span>,
    guidance_scale=<span class="hljs-number">3.5</span>,
    height=height,
    width=width,
    output_type=<span class="hljs-string">&quot;latent&quot;</span>,
).images`,wrap:!1}}),ee=new u({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMuaW1hZ2VfcHJvY2Vzc29yJTIwaW1wb3J0JTIwVmFlSW1hZ2VQcm9jZXNzb3IlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZChja3B0X2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIydmFlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEF2YWVfc2NhbGVfZmFjdG9yJTIwJTNEJTIwMiUyMCoqJTIwKGxlbih2YWUuY29uZmlnLmJsb2NrX291dF9jaGFubmVscyklMjAtJTIwMSklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWYWVJbWFnZVByb2Nlc3Nvcih2YWVfc2NhbGVfZmFjdG9yJTNEdmFlX3NjYWxlX2ZhY3RvciklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyUnVubmluZyUyMGRlY29kaW5nLiUyMiklMEElMjAlMjAlMjAlMjBsYXRlbnRzJTIwJTNEJTIwRmx1eFBpcGVsaW5lLl91bnBhY2tfbGF0ZW50cyhsYXRlbnRzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGglMkMlMjB2YWVfc2NhbGVfZmFjdG9yKSUwQSUyMCUyMCUyMCUyMGxhdGVudHMlMjAlM0QlMjAobGF0ZW50cyUyMCUyRiUyMHZhZS5jb25maWcuc2NhbGluZ19mYWN0b3IpJTIwJTJCJTIwdmFlLmNvbmZpZy5zaGlmdF9mYWN0b3IlMEElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHZhZS5kZWNvZGUobGF0ZW50cyUyQyUyMHJldHVybl9kaWN0JTNERmFsc2UpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3Rwcm9jZXNzKGltYWdlJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJwaWwlMjIpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlNUIwJTVELnNhdmUoJTIyc3BsaXRfdHJhbnNmb3JtZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.image_processor <span class="hljs-keyword">import</span> VaeImageProcessor

vae = AutoencoderKL.from_pretrained(ckpt_id, subfolder=<span class="hljs-string">&quot;vae&quot;</span>, torch_dtype=torch.bfloat16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
vae_scale_factor = <span class="hljs-number">2</span> ** (<span class="hljs-built_in">len</span>(vae.config.block_out_channels) - <span class="hljs-number">1</span>)
image_processor = VaeImageProcessor(vae_scale_factor=vae_scale_factor)

<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Running decoding.&quot;</span>)
    latents = FluxPipeline._unpack_latents(latents, height, width, vae_scale_factor)
    latents = (latents / vae.config.scaling_factor) + vae.config.shift_factor

    image = vae.decode(latents, return_dict=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
    image = image_processor.postprocess(image, output_type=<span class="hljs-string">&quot;pil&quot;</span>)
    image[<span class="hljs-number">0</span>].save(<span class="hljs-string">&quot;split_transformer.png&quot;</span>)`,wrap:!1}}),le=new ie({props:{title:"Resources",local:"resources",headingTag:"h2"}}),se=new kl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/distributed_inference.md"}}),{c(){w=i("meta"),pe=a(),ae=i("p"),oe=a(),r(h.$$.fragment),re=a(),f=i("p"),f.textContent=Oe,ce=a(),T=i("p"),T.innerHTML=el,de=a(),r(b.$$.fragment),me=a(),j=i("p"),j.textContent=ll,Me=a(),U=i("p"),U.textContent=tl,Je=a(),r(I.$$.fragment),ue=a(),Z=i("p"),Z.innerHTML=sl,we=a(),g=i("p"),g.innerHTML=al,ye=a(),r(_.$$.fragment),he=a(),B=i("p"),B.innerHTML=nl,fe=a(),r(k.$$.fragment),Te=a(),v=i("p"),v.innerHTML=il,be=a(),r(C.$$.fragment),je=a(),r(G.$$.fragment),Ue=a(),W=i("p"),W.innerHTML=pl,Ie=a(),$=i("p"),$.innerHTML=ol,Ze=a(),r(E.$$.fragment),ge=a(),X=i("p"),X.innerHTML=rl,_e=a(),N=i("p"),N.innerHTML=cl,Be=a(),r(R.$$.fragment),ke=a(),V=i("p"),V.innerHTML=dl,ve=a(),r(H.$$.fragment),Ce=a(),x=i("p"),x.innerHTML=ml,Ge=a(),r(Y.$$.fragment),We=a(),r(Q.$$.fragment),$e=a(),F=i("p"),F.innerHTML=Ml,Ee=a(),A=i("p"),A.innerHTML=Jl,Xe=a(),r(S.$$.fragment),Ne=a(),z=i("p"),z.textContent=ul,Re=a(),r(q.$$.fragment),Ve=a(),L=i("p"),L.innerHTML=wl,He=a(),r(P.$$.fragment),xe=a(),y=i("blockquote"),y.innerHTML=yl,Ye=a(),D=i("p"),D.innerHTML=hl,Qe=a(),r(K.$$.fragment),Fe=a(),O=i("p"),O.textContent=fl,Ae=a(),r(ee.$$.fragment),Se=a(),r(le.$$.fragment),ze=a(),te=i("ul"),te.innerHTML=Tl,qe=a(),r(se.$$.fragment),Le=a(),ne=i("p"),this.h()},l(e){const l=_l("svelte-u9bgzb",document.head);w=p(l,"META",{name:!0,content:!0}),l.forEach(t),pe=n(e),ae=p(e,"P",{}),bl(ae).forEach(t),oe=n(e),c(h.$$.fragment,e),re=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-eljq9f"&&(f.textContent=Oe),ce=n(e),T=p(e,"P",{"data-svelte-h":!0}),o(T)!=="svelte-og4l62"&&(T.innerHTML=el),de=n(e),c(b.$$.fragment,e),me=n(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-nz1tds"&&(j.textContent=ll),Me=n(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-1st21a7"&&(U.textContent=tl),Je=n(e),c(I.$$.fragment,e),ue=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-s7f0yp"&&(Z.innerHTML=sl),we=n(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1ibki3b"&&(g.innerHTML=al),ye=n(e),c(_.$$.fragment,e),he=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-dxnfoj"&&(B.innerHTML=nl),fe=n(e),c(k.$$.fragment,e),Te=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-xu0wll"&&(v.innerHTML=il),be=n(e),c(C.$$.fragment,e),je=n(e),c(G.$$.fragment,e),Ue=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-nym58p"&&(W.innerHTML=pl),Ie=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1q3d069"&&($.innerHTML=ol),Ze=n(e),c(E.$$.fragment,e),ge=n(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1vva4uo"&&(X.innerHTML=rl),_e=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1329uwh"&&(N.innerHTML=cl),Be=n(e),c(R.$$.fragment,e),ke=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-84sp40"&&(V.innerHTML=dl),ve=n(e),c(H.$$.fragment,e),Ce=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-17g6264"&&(x.innerHTML=ml),Ge=n(e),c(Y.$$.fragment,e),We=n(e),c(Q.$$.fragment,e),$e=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-19ricyq"&&(F.innerHTML=Ml),Ee=n(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-uepizv"&&(A.innerHTML=Jl),Xe=n(e),c(S.$$.fragment,e),Ne=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-m088j3"&&(z.textContent=ul),Re=n(e),c(q.$$.fragment,e),Ve=n(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-18jqegg"&&(L.innerHTML=wl),He=n(e),c(P.$$.fragment,e),xe=n(e),y=p(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),o(y)!=="svelte-eiyj9h"&&(y.innerHTML=yl),Ye=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-128ts8i"&&(D.innerHTML=hl),Qe=n(e),c(K.$$.fragment,e),Fe=n(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-jp9jpz"&&(O.textContent=fl),Ae=n(e),c(ee.$$.fragment,e),Se=n(e),c(le.$$.fragment,e),ze=n(e),te=p(e,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-gnco3l"&&(te.innerHTML=Tl),qe=n(e),c(se.$$.fragment,e),Le=n(e),ne=p(e,"P",{}),bl(ne).forEach(t),this.h()},h(){De(w,"name","hf:doc:metadata"),De(w,"content",Cl),De(y,"class","tip")},m(e,l){Bl(document.head,w),s(e,pe,l),s(e,ae,l),s(e,oe,l),d(h,e,l),s(e,re,l),s(e,f,l),s(e,ce,l),s(e,T,l),s(e,de,l),d(b,e,l),s(e,me,l),s(e,j,l),s(e,Me,l),s(e,U,l),s(e,Je,l),d(I,e,l),s(e,ue,l),s(e,Z,l),s(e,we,l),s(e,g,l),s(e,ye,l),d(_,e,l),s(e,he,l),s(e,B,l),s(e,fe,l),d(k,e,l),s(e,Te,l),s(e,v,l),s(e,be,l),d(C,e,l),s(e,je,l),d(G,e,l),s(e,Ue,l),s(e,W,l),s(e,Ie,l),s(e,$,l),s(e,Ze,l),d(E,e,l),s(e,ge,l),s(e,X,l),s(e,_e,l),s(e,N,l),s(e,Be,l),d(R,e,l),s(e,ke,l),s(e,V,l),s(e,ve,l),d(H,e,l),s(e,Ce,l),s(e,x,l),s(e,Ge,l),d(Y,e,l),s(e,We,l),d(Q,e,l),s(e,$e,l),s(e,F,l),s(e,Ee,l),s(e,A,l),s(e,Xe,l),d(S,e,l),s(e,Ne,l),s(e,z,l),s(e,Re,l),d(q,e,l),s(e,Ve,l),s(e,L,l),s(e,He,l),d(P,e,l),s(e,xe,l),s(e,y,l),s(e,Ye,l),s(e,D,l),s(e,Qe,l),d(K,e,l),s(e,Fe,l),s(e,O,l),s(e,Ae,l),d(ee,e,l),s(e,Se,l),d(le,e,l),s(e,ze,l),s(e,te,l),s(e,qe,l),d(se,e,l),s(e,Le,l),s(e,ne,l),Pe=!0},p:Ul,i(e){Pe||(m(h.$$.fragment,e),m(b.$$.fragment,e),m(I.$$.fragment,e),m(_.$$.fragment,e),m(k.$$.fragment,e),m(C.$$.fragment,e),m(G.$$.fragment,e),m(E.$$.fragment,e),m(R.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),Pe=!0)},o(e){M(h.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(_.$$.fragment,e),M(k.$$.fragment,e),M(C.$$.fragment,e),M(G.$$.fragment,e),M(E.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(Y.$$.fragment,e),M(Q.$$.fragment,e),M(S.$$.fragment,e),M(q.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(se.$$.fragment,e),Pe=!1},d(e){e&&(t(pe),t(ae),t(oe),t(re),t(f),t(ce),t(T),t(de),t(me),t(j),t(Me),t(U),t(Je),t(ue),t(Z),t(we),t(g),t(ye),t(he),t(B),t(fe),t(Te),t(v),t(be),t(je),t(Ue),t(W),t(Ie),t($),t(Ze),t(ge),t(X),t(_e),t(N),t(Be),t(ke),t(V),t(ve),t(Ce),t(x),t(Ge),t(We),t($e),t(F),t(Ee),t(A),t(Xe),t(Ne),t(z),t(Re),t(Ve),t(L),t(He),t(xe),t(y),t(Ye),t(D),t(Qe),t(Fe),t(O),t(Ae),t(Se),t(ze),t(te),t(qe),t(Le),t(ne)),t(w),J(h,e),J(b,e),J(I,e),J(_,e),J(k,e),J(C,e),J(G,e),J(E,e),J(R,e),J(H,e),J(Y,e),J(Q,e),J(S,e),J(q,e),J(P,e),J(K,e),J(ee,e),J(le,e),J(se,e)}}}const Cl='{"title":"Distributed inference","local":"distributed-inference","sections":[{"title":"Accelerate","local":"accelerate","sections":[],"depth":2},{"title":"PyTorch Distributed","local":"pytorch-distributed","sections":[],"depth":2},{"title":"device_map","local":"devicemap","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Gl(Ke){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Nl extends Zl{constructor(w){super(),gl(this,w,Gl,vl,jl,{})}}export{Nl as component};
