import{s as de,n as ce,o as ue}from"../chunks/scheduler.8c3d61f6.js";import{S as he,i as fe,g as s,s as n,r as p,A as ye,h as i,f as l,c as o,j as me,u as m,x as r,k as Qt,y as Me,a,v as d,d as c,t as u,w as h}from"../chunks/index.da70eac4.js";import{C as w}from"../chunks/CodeBlock.a9c4becf.js";import{H as O,E as we}from"../chunks/getInferenceSnippets.cb466318.js";function be(Et){let f,lt,tt,at,b,nt,J,Vt='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> provides high-performance dtypes and optimizations based on quantization and sparsity for inference and training PyTorch models. It is supported for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',ot,T,Ht="Make sure Pytorch 2.5+ and torchao are installed with the command below.",st,g,it,U,Yt='Each quantization dtype is available as a separate instance of a <a href="https://docs.pytorch.org/ao/main/api_ref_quantization.html#inference-apis-for-quantize" rel="nofollow">AOBaseConfig</a> class. This provides more flexible configuration options by exposing more available arguments.',rt,j,Nt='Pass the <code>AOBaseConfig</code> of a quantization dtype, like <a href="https://docs.pytorch.org/ao/main/generated/torchao.quantization.Int4WeightOnlyConfig" rel="nofollow">Int4WeightOnlyConfig</a> to <a href="/docs/diffusers/main/en/api/quantization#diffusers.TorchAoConfig">TorchAoConfig</a> in <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a>.',pt,Z,mt,v,At="For simple use cases, you could also provide a string identifier in <code>TorchAo</code> as shown below.",dt,W,ct,_,ut,q,Lt='torchao supports <a href="../optimization/fp16#torchcompile">torch.compile</a> which can speed up inference with one line of code.',ht,I,ft,B,St='Refer to this <a href="https://github.com/huggingface/diffusers/pull/10009#issue-2688781450" rel="nofollow">table</a> for inference speed and memory usage benchmarks with Flux and CogVideoX. More benchmarks on various hardware are also available in the torchao <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">repository</a>.',yt,y,Pt="<p>The FP8 post-training quantization schemes in torchao are effective for GPUs with compute capability of at least 8.9 (RTX-4090, Hopper, etc.). FP8 often provides the best speed, memory, and quality trade-off when generating images and videos. We recommend combining FP8 and torch.compile if your GPU is compatible.</p>",Mt,G,wt,C,Dt='torchao provides <a href="https://docs.pytorch.org/ao/stable/generated/torchao.quantization.autoquant.html#torchao.quantization.autoquant" rel="nofollow">autoquant</a> an automatic quantization API. Autoquantization chooses the best quantization strategy by comparing the performance of each strategy on chosen input types and shapes. This is only supported in Diffusers for individual models at the moment.',bt,X,Jt,z,Tt,k,Kt="torchao supports weight-only quantization and weight and dynamic-activation quantization for int8, float3-float8, and uint1-uint7.",gt,F,Ot="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",Ut,R,te="Dynamic activation quantization stores the model weights in a low-bit dtype, while also quantizing the activations on-the-fly to save additional memory. This lowers the memory requirements from model weights, while also lowering the memory overhead from activation computations. However, this may come at a quality tradeoff at times, so it is recommended to test different models thoroughly.",jt,$,ee="The quantization methods supported are as follows:",Zt,x,le="<thead><tr><th><strong>Category</strong></th> <th><strong>Full Function Names</strong></th> <th><strong>Shorthands</strong></th></tr></thead> <tbody><tr><td><strong>Integer quantization</strong></td> <td><code>int4_weight_only</code>, <code>int8_dynamic_activation_int4_weight</code>, <code>int8_weight_only</code>, <code>int8_dynamic_activation_int8_weight</code></td> <td><code>int4wo</code>, <code>int4dq</code>, <code>int8wo</code>, <code>int8dq</code></td></tr> <tr><td><strong>Floating point 8-bit quantization</strong></td> <td><code>float8_weight_only</code>, <code>float8_dynamic_activation_float8_weight</code>, <code>float8_static_activation_float8_weight</code></td> <td><code>float8wo</code>, <code>float8wo_e5m2</code>, <code>float8wo_e4m3</code>, <code>float8dq</code>, <code>float8dq_e4m3</code>, <code>float8dq_e4m3_tensor</code>, <code>float8dq_e4m3_row</code></td></tr> <tr><td><strong>Floating point X-bit quantization</strong></td> <td><code>fpx_weight_only</code></td> <td><code>fpX_eAwB</code> where <code>X</code> is the number of bits (1-7), <code>A</code> is exponent bits, and <code>B</code> is mantissa bits. Constraint: <code>X == A + B + 1</code></td></tr> <tr><td><strong>Unsigned Integer quantization</strong></td> <td><code>uintx_weight_only</code></td> <td><code>uint1wo</code>, <code>uint2wo</code>, <code>uint3wo</code>, <code>uint4wo</code>, <code>uint5wo</code>, <code>uint6wo</code>, <code>uint7wo</code></td></tr></tbody>",vt,Q,ae="Some quantization methods are aliases (for example, <code>int8wo</code> is the commonly used shorthand for <code>int8_weight_only</code>). This allows using the quantization methods described in the torchao docs as-is, while also making it convenient to remember their shorthand notations.",Wt,E,ne='Refer to the <a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">official torchao documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',_t,V,qt,H,oe='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',It,Y,Bt,N,se='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',Gt,A,Ct,L,ie="If you are using <code>torch&lt;=2.6.0</code>, some quantization methods, such as <code>uint4wo</code>, cannot be loaded directly and may result in an <code>UnpicklingError</code> when trying to load the models, but work as expected when saving them. In order to work around this, one can load the state dict manually into the model. Note, however, that this requires using <code>weights_only=False</code> in <code>torch.load</code>, so it should be run only if the weights were obtained from a trustable source.",Xt,S,zt,M,re='<p>The <a href="/docs/diffusers/main/en/api/models/auto_model#diffusers.AutoModel">AutoModel</a> API is supported for PyTorch &gt;= 2.6 as shown in the examples below.</p>',kt,P,Ft,D,pe='<li><a href="https://docs.pytorch.org/ao/stable/index.html" rel="nofollow">TorchAO Quantization API</a></li> <li><a href="https://github.com/sayakpaul/diffusers-torchao" rel="nofollow">Diffusers-TorchAO examples</a></li>',Rt,K,$t,et,xt;return b=new O({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),g=new w({props:{code:"dXYlMjBwaXAlMjBpbnN0YWxsJTIwLVUlMjB0b3JjaCUyMHRvcmNoYW8=",highlighted:"uv pip install -U torch torchao",wrap:!1}}),Z=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBJbnQ4V2VpZ2h0T25seUNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMFRvcmNoQW9Db25maWcoSW50OFdlaWdodE9ubHlDb25maWcoZ3JvdXBfc2l6ZSUzRDEyOCkpKSU3RCUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudHphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int8WeightOnlyConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(Int8WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)))}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),W=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEElMEFwaXBlbGluZV9xdWFudF9jb25maWclMjAlM0QlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBxdWFudF9tYXBwaW5nJTNEJTdCJTIydHJhbnNmb3JtZXIlMjIlM0ElMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklN0QlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtZGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnR6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)`,wrap:!1}}),_=new O({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),I=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUyQyUyMFRvcmNoQW9Db25maWclMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBJbnQ0V2VpZ2h0T25seUNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMFRvcmNoQW9Db25maWcoSW50NFdlaWdodE9ubHlDb25maWcoZ3JvdXBfc2l6ZSUzRDEyOCkpKSU3RCUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudHphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmN1ZGElMjIlMEEpJTBBJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuY29tcGlsZSh0cmFuc2Zvcm1lciUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, PipelineQuantizationConfig, TorchAoConfig
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int4WeightOnlyConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={<span class="hljs-string">&quot;transformer&quot;</span>: TorchAoConfig(Int4WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)))}
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantzation_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

pipeline.transformer.<span class="hljs-built_in">compile</span>(transformer, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new O({props:{title:"autoquant",local:"autoquant",headingTag:"h2"}}),X=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwdG9yY2hhby5xdWFudGl6YXRpb24lMjBpbXBvcnQlMjBhdXRvcXVhbnQlMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwcGlwZWxpbmUlMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1zY2huZWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTBBKSUwQSUwQXRyYW5zZm9ybWVyJTIwJTNEJTIwYXV0b3F1YW50KHBpcGVsaW5lLnRyYW5zZm9ybWVyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> autoquant

<span class="hljs-comment"># Load the pipeline</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;cuda&quot;</span>
)

transformer = autoquant(pipeline.transformer)`,wrap:!1}}),z=new O({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),V=new O({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),Y=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwVG9yY2hBb0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDh3byUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, TorchAoConfig

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int8wo&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),A=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmx1eFBpcGVsaW5lJTJDJTIwQXV0b01vZGVsJTBBJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfaW50OHdvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzREZhbHNlKSUwQXBpcGUlMjAlM0QlMjBGbHV4UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRmx1eC4xLURldiUyMiUyQyUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENy4wKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJvdXRwdXQucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel

transformer = AutoModel.from_pretrained(<span class="hljs-string">&quot;/path/to/flux_int8wo&quot;</span>, torch_dtype=torch.bfloat16, use_safetensors=<span class="hljs-literal">False</span>)
pipe = FluxPipeline.from_pretrained(<span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>, transformer=transformer, torch_dtype=torch.bfloat16)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(prompt, num_inference_steps=<span class="hljs-number">30</span>, guidance_scale=<span class="hljs-number">7.0</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),S=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMGluaXRfZW1wdHlfd2VpZ2h0cyUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4UGlwZWxpbmUlMkMlMjBBdXRvTW9kZWwlMkMlMjBUb3JjaEFvQ29uZmlnJTBBJTBBJTIzJTIwU2VyaWFsaXplJTIwdGhlJTIwbW9kZWwlMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGbHV4LjEtRGV2JTIyJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEVG9yY2hBb0NvbmZpZyglMjJ1aW50NHdvJTIyKSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMEEpJTBBdHJhbnNmb3JtZXIuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyMiUyQyUyMHNhZmVfc2VyaWFsaXphdGlvbiUzREZhbHNlJTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjI1MEdCJTIyKSUwQSUyMyUyMC4uLiUwQSUwQSUyMyUyMExvYWQlMjB0aGUlMjBtb2RlbCUwQXN0YXRlX2RpY3QlMjAlM0QlMjB0b3JjaC5sb2FkKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmRpZmZ1c2lvbl9weXRvcmNoX21vZGVsLmJpbiUyMiUyQyUyMHdlaWdodHNfb25seSUzREZhbHNlJTJDJTIwbWFwX2xvY2F0aW9uJTNEJTIyY3B1JTIyKSUwQXdpdGglMjBpbml0X2VtcHR5X3dlaWdodHMoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fY29uZmlnKCUyMiUyRnBhdGglMkZ0byUyRmZsdXhfdWludDR3byUyRmNvbmZpZy5qc29uJTIyKSUwQXRyYW5zZm9ybWVyLmxvYWRfc3RhdGVfZGljdChzdGF0ZV9kaWN0JTJDJTIwc3RyaWN0JTNEVHJ1ZSUyQyUyMGFzc2lnbiUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> init_empty_weights
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxPipeline, AutoModel, TorchAoConfig

<span class="hljs-comment"># Serialize the model</span>
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/Flux.1-Dev&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=TorchAoConfig(<span class="hljs-string">&quot;uint4wo&quot;</span>),
    torch_dtype=torch.bfloat16,
)
transformer.save_pretrained(<span class="hljs-string">&quot;/path/to/flux_uint4wo&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>, max_shard_size=<span class="hljs-string">&quot;50GB&quot;</span>)
<span class="hljs-comment"># ...</span>

<span class="hljs-comment"># Load the model</span>
state_dict = torch.load(<span class="hljs-string">&quot;/path/to/flux_uint4wo/diffusion_pytorch_model.bin&quot;</span>, weights_only=<span class="hljs-literal">False</span>, map_location=<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-keyword">with</span> init_empty_weights():
    transformer = AutoModel.from_config(<span class="hljs-string">&quot;/path/to/flux_uint4wo/config.json&quot;</span>)
transformer.load_state_dict(state_dict, strict=<span class="hljs-literal">True</span>, assign=<span class="hljs-literal">True</span>)`,wrap:!1}}),P=new O({props:{title:"Resources",local:"resources",headingTag:"h2"}}),K=new we({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){f=s("meta"),lt=n(),tt=s("p"),at=n(),p(b.$$.fragment),nt=n(),J=s("p"),J.innerHTML=Vt,ot=n(),T=s("p"),T.textContent=Ht,st=n(),p(g.$$.fragment),it=n(),U=s("p"),U.innerHTML=Yt,rt=n(),j=s("p"),j.innerHTML=Nt,pt=n(),p(Z.$$.fragment),mt=n(),v=s("p"),v.innerHTML=At,dt=n(),p(W.$$.fragment),ct=n(),p(_.$$.fragment),ut=n(),q=s("p"),q.innerHTML=Lt,ht=n(),p(I.$$.fragment),ft=n(),B=s("p"),B.innerHTML=St,yt=n(),y=s("blockquote"),y.innerHTML=Pt,Mt=n(),p(G.$$.fragment),wt=n(),C=s("p"),C.innerHTML=Dt,bt=n(),p(X.$$.fragment),Jt=n(),p(z.$$.fragment),Tt=n(),k=s("p"),k.textContent=Kt,gt=n(),F=s("p"),F.innerHTML=Ot,Ut=n(),R=s("p"),R.textContent=te,jt=n(),$=s("p"),$.textContent=ee,Zt=n(),x=s("table"),x.innerHTML=le,vt=n(),Q=s("p"),Q.innerHTML=ae,Wt=n(),E=s("p"),E.innerHTML=ne,_t=n(),p(V.$$.fragment),qt=n(),H=s("p"),H.innerHTML=oe,It=n(),p(Y.$$.fragment),Bt=n(),N=s("p"),N.innerHTML=se,Gt=n(),p(A.$$.fragment),Ct=n(),L=s("p"),L.innerHTML=ie,Xt=n(),p(S.$$.fragment),zt=n(),M=s("blockquote"),M.innerHTML=re,kt=n(),p(P.$$.fragment),Ft=n(),D=s("ul"),D.innerHTML=pe,Rt=n(),p(K.$$.fragment),$t=n(),et=s("p"),this.h()},l(t){const e=ye("svelte-u9bgzb",document.head);f=i(e,"META",{name:!0,content:!0}),e.forEach(l),lt=o(t),tt=i(t,"P",{}),me(tt).forEach(l),at=o(t),m(b.$$.fragment,t),nt=o(t),J=i(t,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1ucx4sz"&&(J.innerHTML=Vt),ot=o(t),T=i(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-fmrzpk"&&(T.textContent=Ht),st=o(t),m(g.$$.fragment,t),it=o(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1nzolae"&&(U.innerHTML=Yt),rt=o(t),j=i(t,"P",{"data-svelte-h":!0}),r(j)!=="svelte-tqekst"&&(j.innerHTML=Nt),pt=o(t),m(Z.$$.fragment,t),mt=o(t),v=i(t,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1i1n0wg"&&(v.innerHTML=At),dt=o(t),m(W.$$.fragment,t),ct=o(t),m(_.$$.fragment,t),ut=o(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1re1mrg"&&(q.innerHTML=Lt),ht=o(t),m(I.$$.fragment,t),ft=o(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-139k18a"&&(B.innerHTML=St),yt=o(t),y=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1xstrmi"&&(y.innerHTML=Pt),Mt=o(t),m(G.$$.fragment,t),wt=o(t),C=i(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1sxhdyw"&&(C.innerHTML=Dt),bt=o(t),m(X.$$.fragment,t),Jt=o(t),m(z.$$.fragment,t),Tt=o(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1dy3rwb"&&(k.textContent=Kt),gt=o(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-17x1tdo"&&(F.innerHTML=Ot),Ut=o(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1nbmql6"&&(R.textContent=te),jt=o(t),$=i(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-4xexxq"&&($.textContent=ee),Zt=o(t),x=i(t,"TABLE",{"data-svelte-h":!0}),r(x)!=="svelte-1y0n94l"&&(x.innerHTML=le),vt=o(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1r64eqr"&&(Q.innerHTML=ae),Wt=o(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-6zfuzk"&&(E.innerHTML=ne),_t=o(t),m(V.$$.fragment,t),qt=o(t),H=i(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-x34suv"&&(H.innerHTML=oe),It=o(t),m(Y.$$.fragment,t),Bt=o(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-1km1qu3"&&(N.innerHTML=se),Gt=o(t),m(A.$$.fragment,t),Ct=o(t),L=i(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1m61wn7"&&(L.innerHTML=ie),Xt=o(t),m(S.$$.fragment,t),zt=o(t),M=i(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-9pvxk5"&&(M.innerHTML=re),kt=o(t),m(P.$$.fragment,t),Ft=o(t),D=i(t,"UL",{"data-svelte-h":!0}),r(D)!=="svelte-ok3vq4"&&(D.innerHTML=pe),Rt=o(t),m(K.$$.fragment,t),$t=o(t),et=i(t,"P",{}),me(et).forEach(l),this.h()},h(){Qt(f,"name","hf:doc:metadata"),Qt(f,"content",Je),Qt(y,"class","tip"),Qt(M,"class","tip")},m(t,e){Me(document.head,f),a(t,lt,e),a(t,tt,e),a(t,at,e),d(b,t,e),a(t,nt,e),a(t,J,e),a(t,ot,e),a(t,T,e),a(t,st,e),d(g,t,e),a(t,it,e),a(t,U,e),a(t,rt,e),a(t,j,e),a(t,pt,e),d(Z,t,e),a(t,mt,e),a(t,v,e),a(t,dt,e),d(W,t,e),a(t,ct,e),d(_,t,e),a(t,ut,e),a(t,q,e),a(t,ht,e),d(I,t,e),a(t,ft,e),a(t,B,e),a(t,yt,e),a(t,y,e),a(t,Mt,e),d(G,t,e),a(t,wt,e),a(t,C,e),a(t,bt,e),d(X,t,e),a(t,Jt,e),d(z,t,e),a(t,Tt,e),a(t,k,e),a(t,gt,e),a(t,F,e),a(t,Ut,e),a(t,R,e),a(t,jt,e),a(t,$,e),a(t,Zt,e),a(t,x,e),a(t,vt,e),a(t,Q,e),a(t,Wt,e),a(t,E,e),a(t,_t,e),d(V,t,e),a(t,qt,e),a(t,H,e),a(t,It,e),d(Y,t,e),a(t,Bt,e),a(t,N,e),a(t,Gt,e),d(A,t,e),a(t,Ct,e),a(t,L,e),a(t,Xt,e),d(S,t,e),a(t,zt,e),a(t,M,e),a(t,kt,e),d(P,t,e),a(t,Ft,e),a(t,D,e),a(t,Rt,e),d(K,t,e),a(t,$t,e),a(t,et,e),xt=!0},p:ce,i(t){xt||(c(b.$$.fragment,t),c(g.$$.fragment,t),c(Z.$$.fragment,t),c(W.$$.fragment,t),c(_.$$.fragment,t),c(I.$$.fragment,t),c(G.$$.fragment,t),c(X.$$.fragment,t),c(z.$$.fragment,t),c(V.$$.fragment,t),c(Y.$$.fragment,t),c(A.$$.fragment,t),c(S.$$.fragment,t),c(P.$$.fragment,t),c(K.$$.fragment,t),xt=!0)},o(t){u(b.$$.fragment,t),u(g.$$.fragment,t),u(Z.$$.fragment,t),u(W.$$.fragment,t),u(_.$$.fragment,t),u(I.$$.fragment,t),u(G.$$.fragment,t),u(X.$$.fragment,t),u(z.$$.fragment,t),u(V.$$.fragment,t),u(Y.$$.fragment,t),u(A.$$.fragment,t),u(S.$$.fragment,t),u(P.$$.fragment,t),u(K.$$.fragment,t),xt=!1},d(t){t&&(l(lt),l(tt),l(at),l(nt),l(J),l(ot),l(T),l(st),l(it),l(U),l(rt),l(j),l(pt),l(mt),l(v),l(dt),l(ct),l(ut),l(q),l(ht),l(ft),l(B),l(yt),l(y),l(Mt),l(wt),l(C),l(bt),l(Jt),l(Tt),l(k),l(gt),l(F),l(Ut),l(R),l(jt),l($),l(Zt),l(x),l(vt),l(Q),l(Wt),l(E),l(_t),l(qt),l(H),l(It),l(Bt),l(N),l(Gt),l(Ct),l(L),l(Xt),l(zt),l(M),l(kt),l(Ft),l(D),l(Rt),l($t),l(et)),l(f),h(b,t),h(g,t),h(Z,t),h(W,t),h(_,t),h(I,t),h(G,t),h(X,t),h(z,t),h(V,t),h(Y,t),h(A,t),h(S,t),h(P,t),h(K,t)}}}const Je='{"title":"torchao","local":"torchao","sections":[{"title":"torch.compile","local":"torchcompile","sections":[],"depth":2},{"title":"autoquant","local":"autoquant","sections":[],"depth":2},{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Te(Et){return ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ve extends he{constructor(f){super(),fe(this,f,Te,be,de,{})}}export{ve as component};
