import{s as Pe,n as Ne,o as Se}from"../chunks/scheduler.8c3d61f6.js";import{S as De,i as Ke,g as l,s,r,A as Oe,h as o,f as n,c as a,j as Le,u as f,x as p,k as je,y as et,a as i,v as u,d as c,t as m,w as d}from"../chunks/index.da70eac4.js";import{C as L}from"../chunks/CodeBlock.a9c4becf.js";import{H as P,E as tt}from"../chunks/getInferenceSnippets.cb466318.js";function nt(Ze){let y,N,V,S,w,D,b,_e="Quantization focuses on representing data with fewer bits while also trying to preserve the precision of the original data. This often means converting a data type to represent the same information with fewer bits. For example, if your model weights are stored as 32-bit floating points and they’re quantized to 16-bit floating points, this halves the model size which makes it easier to store and reduces memory usage. Lower precision can also speedup inference because it takes less time to perform calculations with fewer bits.",K,g,Be='Diffusers supports multiple quantization backends to make large diffusion models like <a href="../api/pipelines/flux">Flux</a> more accessible. This guide shows how to use the <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> class to quantize a pipeline during its initialization from a pretrained or non-quantized checkpoint.',O,T,ee,J,ve='There are two ways to use <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> depending on how much customization you want to apply to the quantization configuration.',te,U,ke="<li>for basic use cases, define the <code>quant_backend</code>, <code>quant_kwargs</code>, and <code>components_to_quantize</code> arguments</li> <li>for granular quantization control, define a <code>quant_mapping</code> that provides the quantization configuration for individual model components</li>",ne,C,ie,z,Qe='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> with the following parameters.',se,q,$e="<li><code>quant_backend</code> specifies which quantization backend to use. Currently supported backends include: <code>bitsandbytes_4bit</code>, <code>bitsandbytes_8bit</code>, <code>gguf</code>, <code>quanto</code>, and <code>torchao</code>.</li> <li><code>quant_kwargs</code> specifies the quantization arguments to use.</li>",ae,M,Ge='<p>These <code>quant_kwargs</code> arguments are different for each backend. Refer to the <a href="../api/quantization">Quantization API</a> docs to view the arguments for each backend.</p>',le,j,Ie='<li><p><code>components_to_quantize</code> specifies which component(s) of the pipeline to quantize. Typically, you should quantize the most compute intensive components like the transformer. The text encoder is another component to consider quantizing if a pipeline has more than one such as <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a>. The example below quantizes the T5 text encoder in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> while keeping the CLIP model intact.</p> <p><code>components_to_quantize</code> accepts either a list for multiple models or a string for a single model.</p></li>',oe,Z,We='The example below loads the bitsandbytes backend with the following arguments from <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">BitsAndBytesConfig</a>, <code>load_in_4bit</code>, <code>bnb_4bit_quant_type</code>, and <code>bnb_4bit_compute_dtype</code>.',pe,_,re,B,Xe='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',fe,v,ue,k,ce,Q,Re="The <code>quant_mapping</code> argument provides more options for how to quantize each individual component in a pipeline, like combining different quantization backends.",me,$,Fe='Initialize <a href="/docs/diffusers/main/en/api/quantization#diffusers.PipelineQuantizationConfig">PipelineQuantizationConfig</a> and pass a <code>quant_mapping</code> to it. The <code>quant_mapping</code> allows you to specify the quantization options for each component in the pipeline such as the transformer and text encoder.',de,G,xe='The example below uses two quantization backends, <a href="/docs/diffusers/main/en/api/quantization#diffusers.QuantoConfig">QuantoConfig</a> and <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a>, for the transformer and text encoder.',ye,I,Me,W,Ae='There is a separate bitsandbytes backend in <a href="https://huggingface.co/docs/transformers/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">Transformers</a>. You need to import and use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> for components that come from Transformers. For example, <code>text_encoder_2</code> in <a href="/docs/diffusers/main/en/api/pipelines/flux#diffusers.FluxPipeline">FluxPipeline</a> is a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5EncoderModel</a> from Transformers so you need to use <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#transformers.BitsAndBytesConfig" rel="nofollow">transformers.BitsAndBytesConfig</a> instead of <a href="/docs/diffusers/main/en/api/quantization#diffusers.BitsAndBytesConfig">diffusers.BitsAndBytesConfig</a>.',he,h,Ee='<p>Use the <a href="#basic-quantization">basic quantization</a> method above if you don’t want to manage these distinct imports or aren’t sure where each pipeline component comes from.</p>',we,X,be,R,He='Pass the <code>pipeline_quant_config</code> to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> to quantize the pipeline.',ge,F,Te,x,Je,A,Ve="Check out the resources below to learn more about quantization.",Ue,E,Ye='<li><p>If you are new to quantization, we recommend checking out the following beginner-friendly courses in collaboration with DeepLearning.AI.</p> <ul><li><a href="https://www.deeplearning.ai/short-courses/quantization-fundamentals-with-hugging-face/" rel="nofollow">Quantization Fundamentals with Hugging Face</a></li> <li><a href="https://www.deeplearning.ai/short-courses/quantization-in-depth/" rel="nofollow">Quantization in Depth</a></li></ul></li> <li><p>Refer to the <a href="https://huggingface.co/docs/transformers/main/en/quantization/contribute" rel="nofollow">Contribute new quantization method guide</a> if you’re interested in adding a new quantization method.</p></li> <li><p>The Transformers quantization <a href="https://huggingface.co/docs/transformers/quantization/overview#when-to-use-what" rel="nofollow">Overview</a> provides an overview of the pros and cons of different quantization backends.</p></li> <li><p>Read the <a href="https://huggingface.co/blog/diffusers-quantization" rel="nofollow">Exploring Quantization Backends in Diffusers</a> blog post for a brief introduction to each quantization backend, how to choose a backend, and combining quantization with other memory optimizations.</p></li>',Ce,H,ze,Y,qe;return w=new P({props:{title:"Getting started",local:"getting-started",headingTag:"h1"}}),T=new P({props:{title:"Pipeline-level quantization",local:"pipeline-level-quantization",headingTag:"h2"}}),C=new P({props:{title:"Basic quantization",local:"basic-quantization",headingTag:"h3"}}),_=new L({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X2JhY2tlbmQlM0QlMjJiaXRzYW5kYnl0ZXNfNGJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50X2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fNGJpdCUyMiUzQSUyMFRydWUlMkMlMjAlMjJibmJfNGJpdF9xdWFudF90eXBlJTIyJTNBJTIwJTIybmY0JTIyJTJDJTIwJTIyYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUyMiUzQSUyMHRvcmNoLmJmbG9hdDE2JTdEJTJDJTBBJTIwJTIwJTIwJTIwY29tcG9uZW50c190b19xdWFudGl6ZSUzRCU1QiUyMnRyYW5zZm9ybWVyJTIyJTJDJTIwJTIydGV4dF9lbmNvZGVyXzIlMjIlNUQlMkMlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)`,wrap:!1}}),v=new L({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),k=new P({props:{title:"Advanced quantization",local:"advanced-quantization",headingTag:"h3"}}),I=new L({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMucXVhbnRpemF0aW9uX2NvbmZpZyUyMGltcG9ydCUyMFF1YW50b0NvbmZpZyUwQWZyb20lMjBkaWZmdXNlcnMucXVhbnRpemVycyUyMGltcG9ydCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUyMGFzJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfbWFwcGluZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwUXVhbnRvQ29uZmlnKHdlaWdodHNfZHR5cGUlM0QlMjJpbnQ4JTIyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers.quantization_config <span class="hljs-keyword">import</span> QuantoConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: QuantoConfig(weights_dtype=<span class="hljs-string">&quot;int8&quot;</span>),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),X=new L({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTIwYXMlMjBEaWZmdXNlcnNCaXRzQW5kQnl0ZXNDb25maWclMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMjBhcyUyMFRyYW5zZm9ybWVyc0JpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXBpcGVsaW5lX3F1YW50X2NvbmZpZyUyMCUzRCUyMFBpcGVsaW5lUXVhbnRpemF0aW9uQ29uZmlnKCUwQSUyMCUyMCUyMCUyMHF1YW50X21hcHBpbmclM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lciUyMiUzQSUyMERpZmZ1c2Vyc0JpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTNBJTIwVHJhbnNmb3JtZXJzQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBjb21wdXRlX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> DiffusersBitsAndBytesConfig
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig <span class="hljs-keyword">as</span> TransformersBitsAndBytesConfig

pipeline_quant_config = PipelineQuantizationConfig(
    quant_mapping={
        <span class="hljs-string">&quot;transformer&quot;</span>: DiffusersBitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16),
        <span class="hljs-string">&quot;text_encoder_2&quot;</span>: TransformersBitsAndBytesConfig(
            load_in_4bit=<span class="hljs-literal">True</span>, compute_dtype=torch.bfloat16
        ),
    }
)`,wrap:!1}}),F=new L({props:{code:"cGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIycGhvdG8lMjBvZiUyMGElMjBjdXRlJTIwZG9nJTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

image = pipe(<span class="hljs-string">&quot;photo of a cute dog&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),x=new P({props:{title:"Resources",local:"resources",headingTag:"h2"}}),H=new tt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/overview.md"}}),{c(){y=l("meta"),N=s(),V=l("p"),S=s(),r(w.$$.fragment),D=s(),b=l("p"),b.textContent=_e,K=s(),g=l("p"),g.innerHTML=Be,O=s(),r(T.$$.fragment),ee=s(),J=l("p"),J.innerHTML=ve,te=s(),U=l("ul"),U.innerHTML=ke,ne=s(),r(C.$$.fragment),ie=s(),z=l("p"),z.innerHTML=Qe,se=s(),q=l("ul"),q.innerHTML=$e,ae=s(),M=l("blockquote"),M.innerHTML=Ge,le=s(),j=l("ul"),j.innerHTML=Ie,oe=s(),Z=l("p"),Z.innerHTML=We,pe=s(),r(_.$$.fragment),re=s(),B=l("p"),B.innerHTML=Xe,fe=s(),r(v.$$.fragment),ue=s(),r(k.$$.fragment),ce=s(),Q=l("p"),Q.innerHTML=Re,me=s(),$=l("p"),$.innerHTML=Fe,de=s(),G=l("p"),G.innerHTML=xe,ye=s(),r(I.$$.fragment),Me=s(),W=l("p"),W.innerHTML=Ae,he=s(),h=l("blockquote"),h.innerHTML=Ee,we=s(),r(X.$$.fragment),be=s(),R=l("p"),R.innerHTML=He,ge=s(),r(F.$$.fragment),Te=s(),r(x.$$.fragment),Je=s(),A=l("p"),A.textContent=Ve,Ue=s(),E=l("ul"),E.innerHTML=Ye,Ce=s(),r(H.$$.fragment),ze=s(),Y=l("p"),this.h()},l(e){const t=Oe("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(n),N=a(e),V=o(e,"P",{}),Le(V).forEach(n),S=a(e),f(w.$$.fragment,e),D=a(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-16bsuce"&&(b.textContent=_e),K=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-6eg90x"&&(g.innerHTML=Be),O=a(e),f(T.$$.fragment,e),ee=a(e),J=o(e,"P",{"data-svelte-h":!0}),p(J)!=="svelte-2kbfj0"&&(J.innerHTML=ve),te=a(e),U=o(e,"UL",{"data-svelte-h":!0}),p(U)!=="svelte-1xtak7u"&&(U.innerHTML=ke),ne=a(e),f(C.$$.fragment,e),ie=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-11lseqg"&&(z.innerHTML=Qe),se=a(e),q=o(e,"UL",{"data-svelte-h":!0}),p(q)!=="svelte-10xkd3n"&&(q.innerHTML=$e),ae=a(e),M=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(M)!=="svelte-19z24wg"&&(M.innerHTML=Ge),le=a(e),j=o(e,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-qn9gg1"&&(j.innerHTML=Ie),oe=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1xwpu7e"&&(Z.innerHTML=We),pe=a(e),f(_.$$.fragment,e),re=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-3c78ko"&&(B.innerHTML=Xe),fe=a(e),f(v.$$.fragment,e),ue=a(e),f(k.$$.fragment,e),ce=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-s8jyg6"&&(Q.innerHTML=Re),me=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1bi47yb"&&($.innerHTML=Fe),de=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-g00viz"&&(G.innerHTML=xe),ye=a(e),f(I.$$.fragment,e),Me=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1072co4"&&(W.innerHTML=Ae),he=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-b04iji"&&(h.innerHTML=Ee),we=a(e),f(X.$$.fragment,e),be=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-3c78ko"&&(R.innerHTML=He),ge=a(e),f(F.$$.fragment,e),Te=a(e),f(x.$$.fragment,e),Je=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-kva6dz"&&(A.textContent=Ve),Ue=a(e),E=o(e,"UL",{"data-svelte-h":!0}),p(E)!=="svelte-yr6gzk"&&(E.innerHTML=Ye),Ce=a(e),f(H.$$.fragment,e),ze=a(e),Y=o(e,"P",{}),Le(Y).forEach(n),this.h()},h(){je(y,"name","hf:doc:metadata"),je(y,"content",it),je(M,"class","tip"),je(h,"class","tip")},m(e,t){et(document.head,y),i(e,N,t),i(e,V,t),i(e,S,t),u(w,e,t),i(e,D,t),i(e,b,t),i(e,K,t),i(e,g,t),i(e,O,t),u(T,e,t),i(e,ee,t),i(e,J,t),i(e,te,t),i(e,U,t),i(e,ne,t),u(C,e,t),i(e,ie,t),i(e,z,t),i(e,se,t),i(e,q,t),i(e,ae,t),i(e,M,t),i(e,le,t),i(e,j,t),i(e,oe,t),i(e,Z,t),i(e,pe,t),u(_,e,t),i(e,re,t),i(e,B,t),i(e,fe,t),u(v,e,t),i(e,ue,t),u(k,e,t),i(e,ce,t),i(e,Q,t),i(e,me,t),i(e,$,t),i(e,de,t),i(e,G,t),i(e,ye,t),u(I,e,t),i(e,Me,t),i(e,W,t),i(e,he,t),i(e,h,t),i(e,we,t),u(X,e,t),i(e,be,t),i(e,R,t),i(e,ge,t),u(F,e,t),i(e,Te,t),u(x,e,t),i(e,Je,t),i(e,A,t),i(e,Ue,t),i(e,E,t),i(e,Ce,t),u(H,e,t),i(e,ze,t),i(e,Y,t),qe=!0},p:Ne,i(e){qe||(c(w.$$.fragment,e),c(T.$$.fragment,e),c(C.$$.fragment,e),c(_.$$.fragment,e),c(v.$$.fragment,e),c(k.$$.fragment,e),c(I.$$.fragment,e),c(X.$$.fragment,e),c(F.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),qe=!0)},o(e){m(w.$$.fragment,e),m(T.$$.fragment,e),m(C.$$.fragment,e),m(_.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(I.$$.fragment,e),m(X.$$.fragment,e),m(F.$$.fragment,e),m(x.$$.fragment,e),m(H.$$.fragment,e),qe=!1},d(e){e&&(n(N),n(V),n(S),n(D),n(b),n(K),n(g),n(O),n(ee),n(J),n(te),n(U),n(ne),n(ie),n(z),n(se),n(q),n(ae),n(M),n(le),n(j),n(oe),n(Z),n(pe),n(re),n(B),n(fe),n(ue),n(ce),n(Q),n(me),n($),n(de),n(G),n(ye),n(Me),n(W),n(he),n(h),n(we),n(be),n(R),n(ge),n(Te),n(Je),n(A),n(Ue),n(E),n(Ce),n(ze),n(Y)),n(y),d(w,e),d(T,e),d(C,e),d(_,e),d(v,e),d(k,e),d(I,e),d(X,e),d(F,e),d(x,e),d(H,e)}}}const it='{"title":"Getting started","local":"getting-started","sections":[{"title":"Pipeline-level quantization","local":"pipeline-level-quantization","sections":[{"title":"Basic quantization","local":"basic-quantization","sections":[],"depth":3},{"title":"Advanced quantization","local":"advanced-quantization","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function st(Ze){return Se(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class rt extends De{constructor(y){super(),Ke(this,y,st,nt,Pe,{})}}export{rt as component};
