import{s as Ce,n as ke,o as Be}from"../chunks/scheduler.8c3d61f6.js";import{S as Ve,i as Ne,g as s,s as a,r,A as xe,h as i,f as n,c as o,j as ze,u as c,x as d,k as We,y as Re,a as l,v as m,d as u,t as f,w as h}from"../chunks/index.da70eac4.js";import{C as ue}from"../chunks/CodeBlock.a9c4becf.js";import{H as fe,E as Ee}from"../chunks/getInferenceSnippets.cb466318.js";function Fe(he){let p,Q,E,A,M,G,y,Me='<a href="https://github.com/NVIDIA/TensorRT-Model-Optimizer" rel="nofollow">NVIDIA-ModelOpt</a> is a unified library of state-of-the-art model optimization techniques like quantization, pruning, distillation, speculative decoding, etc. It compresses deep learning models for downstream deployment frameworks like TensorRT-LLM or TensorRT to optimize inference speed.',H,T,ye="Before you begin, make sure you have nvidia_modelopt installed.",$,w,X,J,Te='Quantize a model by passing <code>NVIDIAModelOptConfig</code> to <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> (you can also load pre-quantized models). This works for any model in any modality, as long as it supports loading with <a href="https://hf.co/docs/accelerate/index" rel="nofollow">Accelerate</a> and contains <code>torch.nn.Linear</code> layers.',Y,b,we="The example below only quantizes the weights to FP8.",D,g,L,_,Je='<p><strong>Note:</strong></p> <p>The quantization methods in NVIDIA-ModelOpt are designed to reduce the memory footprint of model weights using various QAT (Quantization-Aware Training) and PTQ (Post-Training Quantization) techniques while maintaining model performance. However, the actual performance gain during inference depends on the deployment framework (e.g., TRT-LLM, TensorRT) and the specific hardware configuration.</p> <p>More details can be found <a href="https://github.com/NVIDIA/TensorRT-Model-Optimizer/tree/main/examples" rel="nofollow">here</a>.</p>',S,q,P,Z,be="The <code>NVIDIAModelOptConfig</code> class accepts three parameters:",O,j,ge='<li><code>quant_type</code>: A string value mentioning one of the quantization types below.</li> <li><code>modules_to_not_convert</code>: A list of module full/partial module names for which quantization should not be performed. For example, to not perform any quantization of the <a href="/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>’s pos_embed projection blocks, one would specify: <code>modules_to_not_convert=[&quot;pos_embed.proj.weight&quot;]</code>.</li> <li><code>disable_conv_quantization</code>: A boolean value which when set to <code>True</code> disables quantization for all convolutional layers in the model. This is useful as channel and block quantization generally don’t work well with convolutional layers (used with INT4, NF4, NVFP4). If you want to disable quantization for specific convolutional layers, use <code>modules_to_not_convert</code> instead.</li> <li><code>algorithm</code>: The algorithm to use for determining scale, defaults to <code>&quot;max&quot;</code>. You can check modelopt documentation for more algorithms and details.</li> <li><code>forward_loop</code>: The forward loop function to use for calibrating activation during quantization. If not provided, it relies on static scale values computed using the weights only.</li> <li><code>kwargs</code>: A dict of keyword arguments to pass to the underlying quantization method which will be invoked based on <code>quant_type</code>.</li>',K,I,ee,U,_e="ModelOpt supports weight-only, channel and block quantization int8, fp8, int4, nf4, and nvfp4. The quantization methods are designed to reduce the memory footprint of the model weights while maintaining the performance of the model during inference.",te,v,qe="Weight-only quantization stores the model weights in a specific low-bit data type but performs computation with a higher-precision data type, like <code>bfloat16</code>. This lowers the memory requirements from model weights but retains the memory peaks for activation computation.",ne,z,Ze="The quantization methods supported are as follows:",le,W,je="<thead><tr><th><strong>Quantization Type</strong></th> <th><strong>Supported Schemes</strong></th> <th><strong>Required Kwargs</strong></th> <th><strong>Additional Notes</strong></th></tr></thead> <tbody><tr><td><strong>INT8</strong></td> <td><code>int8 weight only</code>, <code>int8 channel quantization</code>, <code>int8 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td></td></tr> <tr><td><strong>FP8</strong></td> <td><code>fp8 weight only</code>, <code>fp8 channel quantization</code>, <code>fp8 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td></td></tr> <tr><td><strong>INT4</strong></td> <td><code>int4 weight only</code>, <code>int4 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td><code>channel_quantize = -1 is only supported for now</code></td></tr> <tr><td><strong>NF4</strong></td> <td><code>nf4 weight only</code>, <code>nf4 double block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize + scale_channel_quantize</code> + <code>scale_block_quantize</code></td> <td><code>channel_quantize = -1 and scale_channel_quantize = -1 are only supported for now</code></td></tr> <tr><td><strong>NVFP4</strong></td> <td><code>nvfp4 weight only</code>, <code>nvfp4 block quantization</code></td> <td><code>quant_type</code>, <code>quant_type + channel_quantize + block_quantize</code></td> <td><code>channel_quantize = -1 is only supported for now</code></td></tr></tbody>",ae,C,Ie='Refer to the <a href="https://nvidia.github.io/TensorRT-Model-Optimizer/" rel="nofollow">official modelopt documentation</a> for a better understanding of the available quantization methods and the exhaustive list of configuration options available.',oe,k,se,B,Ue='To serialize a quantized model in a given dtype, first load the model with the desired quantization dtype and then save it using the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a> method.',ie,V,de,N,ve='To load a serialized quantized model, use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> method.',pe,x,re,R,ce,F,me;return M=new fe({props:{title:"NVIDIA ModelOpt",local:"nvidia-modelopt",headingTag:"h1"}}),w=new ue({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwJTIybnZpZGlhX21vZGVsb3B0JTVCaGYlNUQlMjI=",highlighted:'pip install -U <span class="hljs-string">&quot;nvidia_modelopt[hf]&quot;</span>',wrap:!1}}),g=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwU2FuYVBpcGVsaW5lJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMkVmZmljaWVudC1MYXJnZS1Nb2RlbCUyRlNhbmFfNjAwTV8xMDI0cHhfZGlmZnVzZXJzJTIyJTBBZHR5cGUlMjAlM0QlMjB0b3JjaC5iZmxvYXQxNiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBOVklESUFNb2RlbE9wdENvbmZpZyhxdWFudF90eXBlJTNEJTIyRlA4JTIyJTJDJTIwcXVhbnRfbWV0aG9kJTNEJTIybW9kZWxvcHQlMjIpJTBBdHJhbnNmb3JtZXIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwc3ViZm9sZGVyJTNEJTIydHJhbnNmb3JtZXIlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEZHR5cGUlMkMlMEEpJTBBcGlwZSUyMCUzRCUyMFNhbmFQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2Zvcm1lciUzRHRyYW5zZm9ybWVyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0RkdHlwZSUyQyUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJpbnQoZiUyMlBpcGVsaW5lJTIwbWVtb3J5JTIwdXNhZ2UlM0ElMjAlN0J0b3JjaC5jdWRhLm1heF9tZW1vcnlfcmVzZXJ2ZWQoKSUyMCUyRiUyMDEwMjQqKjMlM0EuM2YlN0QlMjBHQiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, SanaPipeline, NVIDIAModelOptConfig

model_id = <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>
dtype = torch.bfloat16

quantization_config = NVIDIAModelOptConfig(quant_type=<span class="hljs-string">&quot;FP8&quot;</span>, quant_method=<span class="hljs-string">&quot;modelopt&quot;</span>)
transformer = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=dtype,
)
pipe = SanaPipeline.from_pretrained(
    model_id,
    transformer=transformer,
    torch_dtype=dtype,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Pipeline memory usage: <span class="hljs-subst">{torch.cuda.max_memory_reserved() / <span class="hljs-number">1024</span>**<span class="hljs-number">3</span>:<span class="hljs-number">.3</span>f}</span> GB&quot;</span>)

prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),q=new fe({props:{title:"NVIDIAModelOptConfig",local:"nvidiamodeloptconfig",headingTag:"h2"}}),I=new fe({props:{title:"Supported quantization types",local:"supported-quantization-types",headingTag:"h2"}}),k=new fe({props:{title:"Serializing and Deserializing quantized models",local:"serializing-and-deserializing-quantized-models",headingTag:"h2"}}),V=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMEFmcm9tJTIwbW9kZWxvcHQudG9yY2gub3B0JTIwaW1wb3J0JTIwZW5hYmxlX2h1Z2dpbmdmYWNlX2NoZWNrcG9pbnRpbmclMEElMEFlbmFibGVfaHVnZ2luZ2ZhY2VfY2hlY2twb2ludGluZygpJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUwQXF1YW50X2NvbmZpZ19mcDglMjAlM0QlMjAlN0IlMjJxdWFudF90eXBlJTIyJTNBJTIwJTIyRlA4JTIyJTJDJTIwJTIycXVhbnRfbWV0aG9kJTIyJTNBJTIwJTIybW9kZWxvcHQlMjIlN0QlMEFxdWFudF9jb25maWdfZnA4JTIwJTNEJTIwTlZJRElBTW9kZWxPcHRDb25maWcoKipxdWFudF9jb25maWdfZnA4KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnRyYW5zZm9ybWVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50X2NvbmZpZ19mcDglMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCgncGF0aCUyRnRvJTJGc2FuYV9mcDgnJTJDJTIwc2FmZV9zZXJpYWxpemF0aW9uJTNERmFsc2Up",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, NVIDIAModelOptConfig
<span class="hljs-keyword">from</span> modelopt.torch.opt <span class="hljs-keyword">import</span> enable_huggingface_checkpointing

enable_huggingface_checkpointing()

model_id = <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>
quant_config_fp8 = {<span class="hljs-string">&quot;quant_type&quot;</span>: <span class="hljs-string">&quot;FP8&quot;</span>, <span class="hljs-string">&quot;quant_method&quot;</span>: <span class="hljs-string">&quot;modelopt&quot;</span>}
quant_config_fp8 = NVIDIAModelOptConfig(**quant_config_fp8)
model = AutoModel.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quant_config_fp8,
    torch_dtype=torch.bfloat16,
)
model.save_pretrained(<span class="hljs-string">&#x27;path/to/sana_fp8&#x27;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),x=new ue({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwTlZJRElBTW9kZWxPcHRDb25maWclMkMlMjBTYW5hUGlwZWxpbmUlMEFmcm9tJTIwbW9kZWxvcHQudG9yY2gub3B0JTIwaW1wb3J0JTIwZW5hYmxlX2h1Z2dpbmdmYWNlX2NoZWNrcG9pbnRpbmclMEElMEFlbmFibGVfaHVnZ2luZ2ZhY2VfY2hlY2twb2ludGluZygpJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyME5WSURJQU1vZGVsT3B0Q29uZmlnKHF1YW50X3R5cGUlM0QlMjJGUDglMjIlMkMlMjBxdWFudF9tZXRob2QlM0QlMjJtb2RlbG9wdCUyMiklMEF0cmFuc2Zvcm1lciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGc2FuYV9mcDglMjIlMkMlMEElMjAlMjAlMjAlMjBzdWJmb2xkZXIlM0QlMjJ0cmFuc2Zvcm1lciUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSklMEFwaXBlJTIwJTNEJTIwU2FuYVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJFZmZpY2llbnQtTGFyZ2UtTW9kZWwlMkZTYW5hXzYwME1fMTAyNHB4X2RpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybWVyJTNEdHJhbnNmb3JtZXIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKSUwQXBpcGUudG8oJTIyY3VkYSUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwY2F0JTIwaG9sZGluZyUyMGElMjBzaWduJTIwdGhhdCUyMHNheXMlMjBoZWxsbyUyMHdvcmxkJTIyJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENC41JTJDJTIwbWF4X3NlcXVlbmNlX2xlbmd0aCUzRDUxMiUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyb3V0cHV0LnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, NVIDIAModelOptConfig, SanaPipeline
<span class="hljs-keyword">from</span> modelopt.torch.opt <span class="hljs-keyword">import</span> enable_huggingface_checkpointing

enable_huggingface_checkpointing()

quantization_config = NVIDIAModelOptConfig(quant_type=<span class="hljs-string">&quot;FP8&quot;</span>, quant_method=<span class="hljs-string">&quot;modelopt&quot;</span>)
transformer = AutoModel.from_pretrained(
    <span class="hljs-string">&quot;path/to/sana_fp8&quot;</span>,
    subfolder=<span class="hljs-string">&quot;transformer&quot;</span>,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
)
pipe = SanaPipeline.from_pretrained(
    <span class="hljs-string">&quot;Efficient-Large-Model/Sana_600M_1024px_diffusers&quot;</span>,
    transformer=transformer,
    torch_dtype=torch.bfloat16,
)
pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;A cat holding a sign that says hello world&quot;</span>
image = pipe(
    prompt, num_inference_steps=<span class="hljs-number">50</span>, guidance_scale=<span class="hljs-number">4.5</span>, max_sequence_length=<span class="hljs-number">512</span>
).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;output.png&quot;</span>)`,wrap:!1}}),R=new Ee({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/quantization/modelopt.md"}}),{c(){p=s("meta"),Q=a(),E=s("p"),A=a(),r(M.$$.fragment),G=a(),y=s("p"),y.innerHTML=Me,H=a(),T=s("p"),T.textContent=ye,$=a(),r(w.$$.fragment),X=a(),J=s("p"),J.innerHTML=Te,Y=a(),b=s("p"),b.textContent=we,D=a(),r(g.$$.fragment),L=a(),_=s("blockquote"),_.innerHTML=Je,S=a(),r(q.$$.fragment),P=a(),Z=s("p"),Z.innerHTML=be,O=a(),j=s("ul"),j.innerHTML=ge,K=a(),r(I.$$.fragment),ee=a(),U=s("p"),U.textContent=_e,te=a(),v=s("p"),v.innerHTML=qe,ne=a(),z=s("p"),z.textContent=Ze,le=a(),W=s("table"),W.innerHTML=je,ae=a(),C=s("p"),C.innerHTML=Ie,oe=a(),r(k.$$.fragment),se=a(),B=s("p"),B.innerHTML=Ue,ie=a(),r(V.$$.fragment),de=a(),N=s("p"),N.innerHTML=ve,pe=a(),r(x.$$.fragment),re=a(),r(R.$$.fragment),ce=a(),F=s("p"),this.h()},l(e){const t=xe("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(n),Q=o(e),E=i(e,"P",{}),ze(E).forEach(n),A=o(e),c(M.$$.fragment,e),G=o(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-v41xgy"&&(y.innerHTML=Me),H=o(e),T=i(e,"P",{"data-svelte-h":!0}),d(T)!=="svelte-ieekzb"&&(T.textContent=ye),$=o(e),c(w.$$.fragment,e),X=o(e),J=i(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-1g5a9mh"&&(J.innerHTML=Te),Y=o(e),b=i(e,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1035mg9"&&(b.textContent=we),D=o(e),c(g.$$.fragment,e),L=o(e),_=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(_)!=="svelte-t3b69f"&&(_.innerHTML=Je),S=o(e),c(q.$$.fragment,e),P=o(e),Z=i(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-nf8ias"&&(Z.innerHTML=be),O=o(e),j=i(e,"UL",{"data-svelte-h":!0}),d(j)!=="svelte-14j8c0y"&&(j.innerHTML=ge),K=o(e),c(I.$$.fragment,e),ee=o(e),U=i(e,"P",{"data-svelte-h":!0}),d(U)!=="svelte-1qozamx"&&(U.textContent=_e),te=o(e),v=i(e,"P",{"data-svelte-h":!0}),d(v)!=="svelte-17x1tdo"&&(v.innerHTML=qe),ne=o(e),z=i(e,"P",{"data-svelte-h":!0}),d(z)!=="svelte-4xexxq"&&(z.textContent=Ze),le=o(e),W=i(e,"TABLE",{"data-svelte-h":!0}),d(W)!=="svelte-zlixfj"&&(W.innerHTML=je),ae=o(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-veoxfw"&&(C.innerHTML=Ie),oe=o(e),c(k.$$.fragment,e),se=o(e),B=i(e,"P",{"data-svelte-h":!0}),d(B)!=="svelte-x34suv"&&(B.innerHTML=Ue),ie=o(e),c(V.$$.fragment,e),de=o(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1km1qu3"&&(N.innerHTML=ve),pe=o(e),c(x.$$.fragment,e),re=o(e),c(R.$$.fragment,e),ce=o(e),F=i(e,"P",{}),ze(F).forEach(n),this.h()},h(){We(p,"name","hf:doc:metadata"),We(p,"content",Qe)},m(e,t){Re(document.head,p),l(e,Q,t),l(e,E,t),l(e,A,t),m(M,e,t),l(e,G,t),l(e,y,t),l(e,H,t),l(e,T,t),l(e,$,t),m(w,e,t),l(e,X,t),l(e,J,t),l(e,Y,t),l(e,b,t),l(e,D,t),m(g,e,t),l(e,L,t),l(e,_,t),l(e,S,t),m(q,e,t),l(e,P,t),l(e,Z,t),l(e,O,t),l(e,j,t),l(e,K,t),m(I,e,t),l(e,ee,t),l(e,U,t),l(e,te,t),l(e,v,t),l(e,ne,t),l(e,z,t),l(e,le,t),l(e,W,t),l(e,ae,t),l(e,C,t),l(e,oe,t),m(k,e,t),l(e,se,t),l(e,B,t),l(e,ie,t),m(V,e,t),l(e,de,t),l(e,N,t),l(e,pe,t),m(x,e,t),l(e,re,t),m(R,e,t),l(e,ce,t),l(e,F,t),me=!0},p:ke,i(e){me||(u(M.$$.fragment,e),u(w.$$.fragment,e),u(g.$$.fragment,e),u(q.$$.fragment,e),u(I.$$.fragment,e),u(k.$$.fragment,e),u(V.$$.fragment,e),u(x.$$.fragment,e),u(R.$$.fragment,e),me=!0)},o(e){f(M.$$.fragment,e),f(w.$$.fragment,e),f(g.$$.fragment,e),f(q.$$.fragment,e),f(I.$$.fragment,e),f(k.$$.fragment,e),f(V.$$.fragment,e),f(x.$$.fragment,e),f(R.$$.fragment,e),me=!1},d(e){e&&(n(Q),n(E),n(A),n(G),n(y),n(H),n(T),n($),n(X),n(J),n(Y),n(b),n(D),n(L),n(_),n(S),n(P),n(Z),n(O),n(j),n(K),n(ee),n(U),n(te),n(v),n(ne),n(z),n(le),n(W),n(ae),n(C),n(oe),n(se),n(B),n(ie),n(de),n(N),n(pe),n(re),n(ce),n(F)),n(p),h(M,e),h(w,e),h(g,e),h(q,e),h(I,e),h(k,e),h(V,e),h(x,e),h(R,e)}}}const Qe='{"title":"NVIDIA ModelOpt","local":"nvidia-modelopt","sections":[{"title":"NVIDIAModelOptConfig","local":"nvidiamodeloptconfig","sections":[],"depth":2},{"title":"Supported quantization types","local":"supported-quantization-types","sections":[],"depth":2},{"title":"Serializing and Deserializing quantized models","local":"serializing-and-deserializing-quantized-models","sections":[],"depth":2}],"depth":1}';function Ae(he){return Be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ye extends Ve{constructor(p){super(),Ne(this,p,Ae,Fe,Ce,{})}}export{Ye as component};
