import{s as Rl,o as Il,n as St}from"../chunks/scheduler.8c3d61f6.js";import{S as Xl,i as Cl,g as p,s as a,r as d,A as Ll,h as r,f as l,c as n,j as Bl,u as h,x as m,k as V,y as Vl,a as s,v as b,d as y,t as w,w as M}from"../chunks/index.da70eac4.js";import{T as Hl}from"../chunks/Tip.6f698f24.js";import{C as Z}from"../chunks/CodeBlock.a9c4becf.js";import{H as W,E as Ql}from"../chunks/getInferenceSnippets.cb466318.js";import{H as Yl,a as qt}from"../chunks/HfOption.6c3b4e77.js";function Fl(_){let o,g="bfloat16 is similar to float16 but it is more robust to numerical errors. Hardware support for bfloat16 varies, but most modern GPUs are capable of supporting bfloat16.",f,u,T;return u=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=p("p"),o.textContent=g,f=a(),d(u.$$.fragment)},l(c){o=r(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-kz0em0"&&(o.textContent=g),f=n(c),h(u.$$.fragment,c)},m(c,i){s(c,o,i),s(c,f,i),b(u,c,i),T=!0},p:St,i(c){T||(y(u.$$.fragment,c),T=!0)},o(c){w(u.$$.fragment,c),T=!1},d(c){c&&(l(o),l(f)),M(u,c)}}}function Nl(_){let o,g="float16 is similar to bfloat16 but may be more prone to numerical errors.",f,u,T;return u=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=p("p"),o.textContent=g,f=a(),d(u.$$.fragment)},l(c){o=r(c,"P",{"data-svelte-h":!0}),m(o)!=="svelte-nzm7ns"&&(o.textContent=g),f=n(c),h(u.$$.fragment,c)},m(c,i){s(c,o,i),s(c,f,i),b(u,c,i),T=!0},p:St,i(c){T||(y(u.$$.fragment,c),T=!0)},o(c){w(u.$$.fragment,c),T=!1},d(c){c&&(l(o),l(f)),M(u,c)}}}function zl(_){let o,g='<a href="https://blogs.nvidia.com/blog/2020/05/14/tensorfloat-32-precision-format/" rel="nofollow">TensorFloat-32 (tf32)</a> mode is supported on NVIDIA Ampere GPUs and it computes the convolution and matrix multiplication operations in tf32. Storage and other operations are kept in float32. This enables significantly faster computations when combined with bfloat16 or float16.',f,u,T="PyTorch only enables tf32 mode for convolutions by default and you’ll need to explicitly enable it for matrix multiplications.",c,i,j,$,G='Refer to the <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_one#mixed-precision" rel="nofollow">mixed precision training</a> docs for more details.',x;return i=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLmJhY2tlbmRzLmN1ZGEubWF0bXVsLmFsbG93X3RmMzIlMjAlM0QlMjBUcnVlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch.backends.cuda.matmul.allow_tf32 = <span class="hljs-literal">True</span>

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=p("p"),o.innerHTML=g,f=a(),u=p("p"),u.textContent=T,c=a(),d(i.$$.fragment),j=a(),$=p("p"),$.innerHTML=G},l(J){o=r(J,"P",{"data-svelte-h":!0}),m(o)!=="svelte-1sdg1x4"&&(o.innerHTML=g),f=n(J),u=r(J,"P",{"data-svelte-h":!0}),m(u)!=="svelte-13cgegp"&&(u.textContent=T),c=n(J),h(i.$$.fragment,J),j=n(J),$=r(J,"P",{"data-svelte-h":!0}),m($)!=="svelte-uy7wpj"&&($.innerHTML=G)},m(J,U){s(J,o,U),s(J,f,U),s(J,u,U),s(J,c,U),b(i,J,U),s(J,j,U),s(J,$,U),x=!0},p:St,i(J){x||(y(i.$$.fragment,J),x=!0)},o(J){w(i.$$.fragment,J),x=!1},d(J){J&&(l(o),l(f),l(u),l(c),l(j),l($)),M(i,J)}}}function El(_){let o,g,f,u,T,c;return o=new qt({props:{id:"dtypes",option:"bfloat16",$$slots:{default:[Fl]},$$scope:{ctx:_}}}),f=new qt({props:{id:"dtypes",option:"float16",$$slots:{default:[Nl]},$$scope:{ctx:_}}}),T=new qt({props:{id:"dtypes",option:"TensorFloat-32",$$slots:{default:[zl]},$$scope:{ctx:_}}}),{c(){d(o.$$.fragment),g=a(),d(f.$$.fragment),u=a(),d(T.$$.fragment)},l(i){h(o.$$.fragment,i),g=n(i),h(f.$$.fragment,i),u=n(i),h(T.$$.fragment,i)},m(i,j){b(o,i,j),s(i,g,j),b(f,i,j),s(i,u,j),b(T,i,j),c=!0},p(i,j){const $={};j&2&&($.$$scope={dirty:j,ctx:i}),o.$set($);const G={};j&2&&(G.$$scope={dirty:j,ctx:i}),f.$set(G);const x={};j&2&&(x.$$scope={dirty:j,ctx:i}),T.$set(x)},i(i){c||(y(o.$$.fragment,i),y(f.$$.fragment,i),y(T.$$.fragment,i),c=!0)},o(i){w(o.$$.fragment,i),w(f.$$.fragment,i),w(T.$$.fragment,i),c=!1},d(i){i&&(l(g),l(u)),M(o,i),M(f,i),M(T,i)}}}function Sl(_){let o,g='Refer to the <a href="https://pytorch.org/blog/torch-compile-and-diffusers-a-hands-on-guide-to-peak-performance/" rel="nofollow">torch.compile and Diffusers: A Hands-On Guide to Peak Performance</a> blog post for maximizing performance with <code>torch.compile</code> for diffusion models.';return{c(){o=p("p"),o.innerHTML=g},l(f){o=r(f,"P",{"data-svelte-h":!0}),m(o)!=="svelte-14nq31x"&&(o.innerHTML=g)},m(f,u){s(f,o,u)},p:St,d(f){f&&l(o)}}}function ql(_){let o,g,f,u,T,c,i,j='Diffusion models are slow at inference because generation is an iterative process where noise is gradually refined into an image or video over a certain number of “steps”. To speedup this process, you can try experimenting with different <a href="../api/schedulers/overview">schedulers</a>, reduce the precision of the model weights for faster computations, use more memory-efficient attention mechanisms, and more.',$,G,x="Combine and use these techniques together to make inference faster than using any single technique on its own.",J,U,At="This guide will go over how to accelerate inference.",Ve,H,He,Q,Pt="The precision and data type of the model weights affect inference speed because a higher precision requires more memory to load and more time to perform the computations. PyTorch loads model weights in float32 or full precision by default, so changing the data type is a simple way to quickly get faster inference.",Qe,k,Ye,Y,Fe,v,Dt='<p>Memory-efficient attention optimizes for inference speed <em>and</em> <a href="./memory#memory-efficient-attention">memory usage</a>!</p>',Ne,F,Kt='<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">Scaled dot product attention (SDPA)</a> implements several attention backends, <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">FlashAttention</a>, <a href="https://github.com/facebookresearch/xformers" rel="nofollow">xFormers</a>, and a native C++ implementation. It automatically selects the most optimal backend for your hardware.',ze,N,Ot='SDPA is enabled by default if you’re using PyTorch &gt;= 2.0 and no additional changes are required to your code. You could try experimenting with other attention backends though if you’d like to choose your own. The example below uses the <a href="https://pytorch.org/docs/stable/generated/torch.nn.attention.sdpa_kernel.html" rel="nofollow">torch.nn.attention.sdpa_kernel</a> context manager to enable efficient attention.',Ee,z,Se,E,qe,S,el='<a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> accelerates inference by compiling PyTorch code and operations into optimized kernels. Diffusers typically compiles the more compute-intensive models like the UNet, transformer, or VAE.',Ae,q,tl='Enable the following compiler settings for maximum speed (refer to the <a href="https://github.com/pytorch/pytorch/blob/main/torch/_inductor/config.py" rel="nofollow">full list</a> for more options).',Pe,A,De,P,ll="Load and compile the UNet and VAE. There are several different modes you can choose from, but <code>&quot;max-autotune&quot;</code> optimizes for the fastest speed by compiling to a CUDA graph. CUDA graphs effectively reduces the overhead by launching multiple GPU operations through a single CPU operation.",Ke,B,sl='<p>With PyTorch 2.3.1, you can control the caching behavior of torch.compile. This is particularly beneficial for compilation modes like <code>&quot;max-autotune&quot;</code> which performs a grid-search over several compilation flags to find the optimal configuration. Learn more in the <a href="https://pytorch.org/tutorials/recipes/torch_compile_caching_tutorial.html" rel="nofollow">Compile Time Caching in torch.compile</a> tutorial.</p>',Oe,D,al='Changing the memory layout to <a href="./memory#torchchannels_last">channels_last</a> also optimizes memory and inference speed.',et,K,tt,O,nl="Compilation is slow the first time, but once compiled, it is significantly faster. Try to only use the compiled pipeline on the same type of inference operations. Calling the compiled pipeline on a different image size retriggers compilation which is slow and inefficient.",lt,ee,st,R,il="<p>Make sure to always use the nightly version of PyTorch for better support.</p>",at,te,ol="<code>torch.compile</code> keeps track of input shapes and conditions, and if these are different, it recompiles the model. For example, if a model is compiled on a 1024x1024 resolution image and used on an image with a different resolution, it triggers recompilation.",nt,le,pl="To avoid recompilation, add <code>dynamic=True</code> to try and generate a more dynamic kernel to avoid recompilation when conditions change.",it,se,ot,ae,rl='Specifying <code>use_duck_shape=False</code> instructs the compiler if it should use the same symbolic variable to represent input sizes that are the same. For more details, check out this <a href="https://github.com/huggingface/diffusers/pull/11327#discussion_r2047659790" rel="nofollow">comment</a>.',pt,ne,cl='Not all models may benefit from dynamic compilation out of the box and may require changes. Refer to this <a href="https://github.com/huggingface/diffusers/pull/11297/" rel="nofollow">PR</a> that improved the <a href="/docs/diffusers/main/en/api/pipelines/aura_flow#diffusers.AuraFlowPipeline">AuraFlowPipeline</a> implementation to benefit from dynamic compilation.',rt,ie,ml="Feel free to open an issue if dynamic compilation doesn’t work as expected for a Diffusers model.",ct,oe,mt,pe,fl=`<a href="https://docs.pytorch.org/tutorials/recipes/regional_compilation.html" rel="nofollow">Regional compilation</a> trims cold-start latency by only compiling the <em>small and frequently-repeated block(s)</em> of a model - typically a transformer layer - and enables reusing compiled artifacts for every subsequent occurrence.
For many diffusion architectures, this delivers the same runtime speedups as full-graph compilation and reduces compile time by 8–10x.`,ft,re,ul='Use the <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.compile_repeated_blocks">compile_repeated_blocks()</a> method, a helper that wraps <code>torch.compile</code>, on any component such as the transformer model as shown below.',ut,ce,dt,me,dl="To enable regional compilation for a new model, add a <code>_repeated_blocks</code> attribute to a model class containing the class names (as strings) of the blocks you want to compile.",ht,fe,bt,I,hl='<p>For more regional compilation examples, see the reference <a href="https://github.com/huggingface/diffusers/pull/11705" rel="nofollow">PR</a>.</p>',yt,ue,bl='There is also a <a href="https://github.com/huggingface/accelerate/blob/273799c85d849a1954a4f2e65767216eb37fa089/src/accelerate/utils/other.py#L78" rel="nofollow">compile_regions</a> method in <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> that automatically selects candidate blocks in a model to compile. The remaining graph is compiled separately. This is useful for quick experiments because there aren’t as many options for you to set which blocks to compile or adjust compilation flags.',wt,de,Mt,he,yl='<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.compile_repeated_blocks">compile_repeated_blocks()</a> is intentionally explicit. List the blocks to repeat in <code>_repeated_blocks</code> and the helper only compiles those blocks. It offers predictable behavior and easy reasoning about cache reuse in one line of code.',Tt,be,Jt,ye,wl="It is important to specify <code>fullgraph=True</code> in torch.compile to ensure there are no graph breaks in the underlying model. This allows you to take advantage of torch.compile without any performance degradation. For the UNet and VAE, this changes how you access the return variables.",gt,we,jt,Me,$t,Te,Ml='The <code>step()</code> function is <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl.py#L1228" rel="nofollow">called</a> on the scheduler each time after the denoiser makes a prediction, and the <code>sigmas</code> variable is <a href="https://github.com/huggingface/diffusers/blob/1d686bac8146037e97f3fd8c56e4063230f71751/src/diffusers/schedulers/scheduling_euler_discrete.py#L476" rel="nofollow">indexed</a>. When placed on the GPU, it introduces latency because of the communication sync between the CPU and GPU. It becomes more evident when the denoiser has already been compiled.',Ut,Je,Tl='In general, the <code>sigmas</code> should <a href="https://github.com/huggingface/diffusers/blob/35a969d297cba69110d175ee79c59312b9f49e1e/src/diffusers/schedulers/scheduling_euler_discrete.py#L240" rel="nofollow">stay on the CPU</a> to avoid the communication sync and latency.',Zt,X,Gt,ge,_t,je,Jl='Refer to the <a href="https://huggingface.co/datasets/diffusers/benchmarks" rel="nofollow">diffusers/benchmarks</a> dataset to see inference latency and memory usage data for compiled pipelines.',Wt,$e,gl='The <a href="https://github.com/sayakpaul/diffusers-torchao#benchmarking-results" rel="nofollow">diffusers-torchao</a> repository also contains benchmarking results for compiled versions of Flux and CogVideoX.',xt,Ue,kt,Ze,jl='<a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">Dynamic quantization</a> improves inference speed by reducing precision to enable faster math operations. This particular type of quantization determines how to scale the activations based on the data at runtime rather than using a fixed scaling factor. As a result, the scaling factor is more accurately aligned with the data.',vt,Ge,$l='The example below applies <a href="https://pytorch.org/tutorials/recipes/recipes/dynamic_quantization.html" rel="nofollow">dynamic int8 quantization</a> to the UNet and VAE with the <a href="../quantization/torchao">torchao</a> library.',Bt,C,Ul='<p>Refer to our <a href="../quantization/torchao">torchao</a> docs to learn more about how to use the Diffusers torchao integration.</p>',Rt,_e,Zl="Configure the compiler tags for maximum speed.",It,We,Xt,xe,Gl='Filter out some linear layers in the UNet and VAE which don’t benefit from dynamic quantization with the <a href="https://github.com/huggingface/diffusion-fast/blob/0f169640b1db106fe6a479f78c1ed3bfaeba3386/utils/pipeline_utils.py#L16" rel="nofollow">dynamic_quant_filter_fn</a>.',Ct,ke,Lt,ve,Vt,L,_l='<p>The <a href="https://github.com/huggingface/diffusers/blob/58431f102cf39c3c8a569f32d71b2ea8caa461e1/src/diffusers/pipelines/pipeline_utils.py#L2034" rel="nofollow">fuse_qkv_projections</a> method is experimental and support is limited to mostly Stable Diffusion pipelines. Take a look at this <a href="https://github.com/huggingface/diffusers/pull/6179" rel="nofollow">PR</a> to learn more about how to enable it for other pipelines</p>',Ht,Be,Wl="An input is projected into three subspaces, represented by the projection matrices Q, K, and V, in an attention block. These projections are typically calculated separately, but you can horizontally combine these into a single matrix and perform the projection in a single step. It increases the size of the matrix multiplications of the input projections and also improves the impact of quantization.",Qt,Re,Yt,Ie,Ft,Xe,xl=`<li><p>Read the <a href="https://pytorch.org/blog/presenting-flux-fast-making-flux-go-brrr-on-h100s/" rel="nofollow">Presenting Flux Fast: Making Flux go brrr on H100s</a> blog post to learn more about how you can combine all of these optimizations with <a href="https://docs.pytorch.org/docs/stable/torch.compiler.html" rel="nofollow">TorchInductor</a> and <a href="https://docs.pytorch.org/docs/stable/torch.compiler_aot_inductor.html" rel="nofollow">AOTInductor</a> for a ~2.5x speedup using recipes from <a href="https://github.com/huggingface/flux-fast" rel="nofollow">flux-fast</a>.</p> <p>These recipes support AMD hardware and <a href="https://huggingface.co/black-forest-labs/FLUX.1-Kontext-dev" rel="nofollow">Flux.1 Kontext Dev</a>.</p></li> <li><p>Read the <a href="https://pytorch.org/blog/torch-compile-and-diffusers-a-hands-on-guide-to-peak-performance/" rel="nofollow">torch.compile and Diffusers: A Hands-On Guide to Peak Performance</a> blog post
to maximize performance when using <code>torch.compile</code>.</p></li>`,Nt,Ce,zt,Le,Et;return T=new W({props:{title:"Accelerate inference",local:"accelerate-inference",headingTag:"h1"}}),H=new W({props:{title:"Model data type",local:"model-data-type",headingTag:"h2"}}),k=new Yl({props:{id:"dtypes",options:["bfloat16","float16","TensorFloat-32"],$$slots:{default:[El]},$$scope:{ctx:_}}}),Y=new W({props:{title:"Scaled dot product attention",local:"scaled-dot-product-attention",headingTag:"h2"}}),z=new Z({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmF0dGVudGlvbiUyMGltcG9ydCUyMFNEUEJhY2tlbmQlMkMlMjBzZHBhX2tlcm5lbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQSUwQXdpdGglMjBzZHBhX2tlcm5lbChTRFBCYWNrZW5kLkVGRklDSUVOVF9BVFRFTlRJT04pJTNBJTBBJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.attention <span class="hljs-keyword">import</span> SDPBackend, sdpa_kernel
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>

<span class="hljs-keyword">with</span> sdpa_kernel(SDPBackend.EFFICIENT_ATTENTION):
  image = pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),E=new W({props:{title:"torch.compile",local:"torchcompile",headingTag:"h2"}}),A=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWU=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>`,wrap:!1}}),K=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBcGlwZWxpbmUudW5ldC50byhtZW1vcnlfZm9ybWF0JTNEdG9yY2guY2hhbm5lbHNfbGFzdCklMEFwaXBlbGluZS52YWUudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudW5ldCUyMCUzRCUyMHRvcmNoLmNvbXBpbGUoJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJtYXgtYXV0b3R1bmUlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlJTBBKSUwQXBpcGVsaW5lLnZhZS5kZWNvZGUlMjAlM0QlMjB0b3JjaC5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnZhZS5kZWNvZGUlMkMlMEElMjAlMjAlMjAlMjBtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTBBJTIwJTIwJTIwJTIwZnVsbGdyYXBoJTNEVHJ1ZSUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJBc3Ryb25hdXQlMjBpbiUyMGElMjBqdW5nbGUlMkMlMjBjb2xkJTIwY29sb3IlMjBwYWxldHRlJTJDJTIwbXV0ZWQlMjBjb2xvcnMlMkMlMjBkZXRhaWxlZCUyQyUyMDhrJTIyJTBBcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwKS5pbWFnZXMlNUIwJTVE",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet.to(memory_format=torch.channels_last)
pipeline.vae.to(memory_format=torch.channels_last)
pipeline.unet = torch.<span class="hljs-built_in">compile</span>(
    pipeline.unet, mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>
)
pipeline.vae.decode = torch.<span class="hljs-built_in">compile</span>(
    pipeline.vae.decode,
    mode=<span class="hljs-string">&quot;max-autotune&quot;</span>,
    fullgraph=<span class="hljs-literal">True</span>
)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ee=new W({props:{title:"Dynamic shape compilation",local:"dynamic-shape-compilation",headingTag:"h3"}}),se=new Z({props:{code:"JTJCJTIwdG9yY2guZnguZXhwZXJpbWVudGFsLl9jb25maWcudXNlX2R1Y2tfc2hhcGUlMjAlM0QlMjBGYWxzZSUwQSUyQiUyMHBpcGVsaW5lLnVuZXQlMjAlM0QlMjB0b3JjaC5jb21waWxlKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lLnVuZXQlMkMlMjBmdWxsZ3JhcGglM0RUcnVlJTJDJTIwZHluYW1pYyUzRFRydWUlMEEp",highlighted:`<span class="hljs-addition">+ torch.fx.experimental._config.use_duck_shape = False</span>
<span class="hljs-addition">+ pipeline.unet = torch.compile(</span>
    pipeline.unet, fullgraph=True, dynamic=True
)`,wrap:!1}}),oe=new W({props:{title:"Regional compilation",local:"regional-compilation",headingTag:"h3"}}),ce=new Z({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMC1VJTIwZGlmZnVzZXJzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNvbXBpbGUlMjBvbmx5JTIwdGhlJTIwcmVwZWF0ZWQlMjB0cmFuc2Zvcm1lciUyMGxheWVycyUyMGluc2lkZSUyMHRoZSUyMFVOZXQlMEFwaXBlbGluZS51bmV0LmNvbXBpbGVfcmVwZWF0ZWRfYmxvY2tzKGZ1bGxncmFwaCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install -U diffusers</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile only the repeated transformer layers inside the UNet</span>
pipeline.unet.compile_repeated_blocks(fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),fe=new Z({props:{code:"Y2xhc3MlMjBNeVVOZXQoTW9kZWxNaXhpbiklM0ElMEElMjAlMjAlMjAlMjBfcmVwZWF0ZWRfYmxvY2tzJTIwJTNEJTIwKCUyMlRyYW5zZm9ybWVyMkRNb2RlbCUyMiUyQyklMjAlMjAlMjMlMjAlRTIlODYlOTAlMjBjb21waWxlZCUyMGJ5JTIwZGVmYXVsdA==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyUNet</span>(<span class="hljs-title class_ inherited__">ModelMixin</span>):
    _repeated_blocks = (<span class="hljs-string">&quot;Transformer2DModel&quot;</span>,)  <span class="hljs-comment"># ← compiled by default</span>`,wrap:!1}}),de=new Z({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMC1VJTIwYWNjZWxlcmF0ZSUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXBpbGVfcmVnaW9ucyUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQXBpcGVsaW5lLnVuZXQlMjAlM0QlMjBjb21waWxlX3JlZ2lvbnMocGlwZWxpbmUudW5ldCUyQyUyMG1vZGUlM0QlMjJyZWR1Y2Utb3ZlcmhlYWQlMjIlMkMlMjBmdWxsZ3JhcGglM0RUcnVlKQ==",highlighted:`<span class="hljs-comment"># pip install -U accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compile_regions

pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.unet = compile_regions(pipeline.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)`,wrap:!1}}),be=new W({props:{title:"Graph breaks",local:"graph-breaks",headingTag:"h3"}}),we=new Z({props:{code:"LSUyMGxhdGVudHMlMjAlM0QlMjB1bmV0KCUwQS0lMjAlMjAlMjBsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMEEtKS5zYW1wbGUlMEElMEElMkIlMjBsYXRlbnRzJTIwJTNEJTIwdW5ldCglMEElMkIlMjAlMjAlMjBsYXRlbnRzJTJDJTIwdGltZXN0ZXAlM0R0aW1lc3RlcCUyQyUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUzRHByb21wdF9lbWJlZHMlMkMlMjByZXR1cm5fZGljdCUzREZhbHNlJTBBJTJCKSU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- latents = unet(</span>
<span class="hljs-deletion">-   latents, timestep=timestep, encoder_hidden_states=prompt_embeds</span>
<span class="hljs-deletion">-).sample</span>

<span class="hljs-addition">+ latents = unet(</span>
<span class="hljs-addition">+   latents, timestep=timestep, encoder_hidden_states=prompt_embeds, return_dict=False</span>
<span class="hljs-addition">+)[0]</span>`,wrap:!1}}),Me=new W({props:{title:"GPU sync",local:"gpu-sync",headingTag:"h3"}}),X=new Hl({props:{$$slots:{default:[Sl]},$$scope:{ctx:_}}}),ge=new W({props:{title:"Benchmarks",local:"benchmarks",headingTag:"h3"}}),Ue=new W({props:{title:"Dynamic quantization",local:"dynamic-quantization",headingTag:"h2"}}),We=new Z({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdG9yY2hhbyUyMGltcG9ydCUyMGFwcGx5X2R5bmFtaWNfcXVhbnQlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZSUwQSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuY29udl8xeDFfYXNfbW0lMjAlM0QlMjBUcnVlJTBBdG9yY2guX2luZHVjdG9yLmNvbmZpZy5jb29yZGluYXRlX2Rlc2NlbnRfdHVuaW5nJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcuZXBpbG9ndWVfZnVzaW9uJTIwJTNEJTIwRmFsc2UlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmNvb3JkaW5hdGVfZGVzY2VudF9jaGVja19hbGxfZGlyZWN0aW9ucyUyMCUzRCUyMFRydWUlMEF0b3JjaC5faW5kdWN0b3IuY29uZmlnLmZvcmNlX2Z1c2VfaW50X21tX3dpdGhfbXVsJTIwJTNEJTIwVHJ1ZSUwQXRvcmNoLl9pbmR1Y3Rvci5jb25maWcudXNlX21peGVkX21tJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> torchao <span class="hljs-keyword">import</span> apply_dynamic_quant
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline

torch._inductor.config.conv_1x1_as_mm = <span class="hljs-literal">True</span>
torch._inductor.config.coordinate_descent_tuning = <span class="hljs-literal">True</span>
torch._inductor.config.epilogue_fusion = <span class="hljs-literal">False</span>
torch._inductor.config.coordinate_descent_check_all_directions = <span class="hljs-literal">True</span>
torch._inductor.config.force_fuse_int_mm_with_mul = <span class="hljs-literal">True</span>
torch._inductor.config.use_mixed_mm = <span class="hljs-literal">True</span>`,wrap:!1}}),ke=new Z({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKS50byglMjJjdWRhJTIyKSUwQSUwQWFwcGx5X2R5bmFtaWNfcXVhbnQocGlwZWxpbmUudW5ldCUyQyUyMGR5bmFtaWNfcXVhbnRfZmlsdGVyX2ZuKSUwQWFwcGx5X2R5bmFtaWNfcXVhbnQocGlwZWxpbmUudmFlJTJDJTIwZHluYW1pY19xdWFudF9maWx0ZXJfZm4pJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQXN0cm9uYXV0JTIwaW4lMjBhJTIwanVuZ2xlJTJDJTIwY29sZCUyMGNvbG9yJTIwcGFsZXR0ZSUyQyUyMG11dGVkJTIwY29sb3JzJTJDJTIwZGV0YWlsZWQlMkMlMjA4ayUyMiUwQXBpcGVsaW5lKHByb21wdCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

apply_dynamic_quant(pipeline.unet, dynamic_quant_filter_fn)
apply_dynamic_quant(pipeline.vae, dynamic_quant_filter_fn)

prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
pipeline(prompt, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),ve=new W({props:{title:"Fused projection matrices",local:"fused-projection-matrices",headingTag:"h2"}}),Re=new Z({props:{code:"cGlwZWxpbmUuZnVzZV9xa3ZfcHJvamVjdGlvbnMoKQ==",highlighted:"pipeline.fuse_qkv_projections()",wrap:!1}}),Ie=new W({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ce=new Ql({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/fp16.md"}}),{c(){o=p("meta"),g=a(),f=p("p"),u=a(),d(T.$$.fragment),c=a(),i=p("p"),i.innerHTML=j,$=a(),G=p("p"),G.textContent=x,J=a(),U=p("p"),U.textContent=At,Ve=a(),d(H.$$.fragment),He=a(),Q=p("p"),Q.textContent=Pt,Qe=a(),d(k.$$.fragment),Ye=a(),d(Y.$$.fragment),Fe=a(),v=p("blockquote"),v.innerHTML=Dt,Ne=a(),F=p("p"),F.innerHTML=Kt,ze=a(),N=p("p"),N.innerHTML=Ot,Ee=a(),d(z.$$.fragment),Se=a(),d(E.$$.fragment),qe=a(),S=p("p"),S.innerHTML=el,Ae=a(),q=p("p"),q.innerHTML=tl,Pe=a(),d(A.$$.fragment),De=a(),P=p("p"),P.innerHTML=ll,Ke=a(),B=p("blockquote"),B.innerHTML=sl,Oe=a(),D=p("p"),D.innerHTML=al,et=a(),d(K.$$.fragment),tt=a(),O=p("p"),O.textContent=nl,lt=a(),d(ee.$$.fragment),st=a(),R=p("blockquote"),R.innerHTML=il,at=a(),te=p("p"),te.innerHTML=ol,nt=a(),le=p("p"),le.innerHTML=pl,it=a(),d(se.$$.fragment),ot=a(),ae=p("p"),ae.innerHTML=rl,pt=a(),ne=p("p"),ne.innerHTML=cl,rt=a(),ie=p("p"),ie.textContent=ml,ct=a(),d(oe.$$.fragment),mt=a(),pe=p("p"),pe.innerHTML=fl,ft=a(),re=p("p"),re.innerHTML=ul,ut=a(),d(ce.$$.fragment),dt=a(),me=p("p"),me.innerHTML=dl,ht=a(),d(fe.$$.fragment),bt=a(),I=p("blockquote"),I.innerHTML=hl,yt=a(),ue=p("p"),ue.innerHTML=bl,wt=a(),d(de.$$.fragment),Mt=a(),he=p("p"),he.innerHTML=yl,Tt=a(),d(be.$$.fragment),Jt=a(),ye=p("p"),ye.innerHTML=wl,gt=a(),d(we.$$.fragment),jt=a(),d(Me.$$.fragment),$t=a(),Te=p("p"),Te.innerHTML=Ml,Ut=a(),Je=p("p"),Je.innerHTML=Tl,Zt=a(),d(X.$$.fragment),Gt=a(),d(ge.$$.fragment),_t=a(),je=p("p"),je.innerHTML=Jl,Wt=a(),$e=p("p"),$e.innerHTML=gl,xt=a(),d(Ue.$$.fragment),kt=a(),Ze=p("p"),Ze.innerHTML=jl,vt=a(),Ge=p("p"),Ge.innerHTML=$l,Bt=a(),C=p("blockquote"),C.innerHTML=Ul,Rt=a(),_e=p("p"),_e.textContent=Zl,It=a(),d(We.$$.fragment),Xt=a(),xe=p("p"),xe.innerHTML=Gl,Ct=a(),d(ke.$$.fragment),Lt=a(),d(ve.$$.fragment),Vt=a(),L=p("blockquote"),L.innerHTML=_l,Ht=a(),Be=p("p"),Be.textContent=Wl,Qt=a(),d(Re.$$.fragment),Yt=a(),d(Ie.$$.fragment),Ft=a(),Xe=p("ul"),Xe.innerHTML=xl,Nt=a(),d(Ce.$$.fragment),zt=a(),Le=p("p"),this.h()},l(e){const t=Ll("svelte-u9bgzb",document.head);o=r(t,"META",{name:!0,content:!0}),t.forEach(l),g=n(e),f=r(e,"P",{}),Bl(f).forEach(l),u=n(e),h(T.$$.fragment,e),c=n(e),i=r(e,"P",{"data-svelte-h":!0}),m(i)!=="svelte-1m782be"&&(i.innerHTML=j),$=n(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-wa2eaw"&&(G.textContent=x),J=n(e),U=r(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1cgitz1"&&(U.textContent=At),Ve=n(e),h(H.$$.fragment,e),He=n(e),Q=r(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-18445ux"&&(Q.textContent=Pt),Qe=n(e),h(k.$$.fragment,e),Ye=n(e),h(Y.$$.fragment,e),Fe=n(e),v=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-geybdo"&&(v.innerHTML=Dt),Ne=n(e),F=r(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-zmbjuq"&&(F.innerHTML=Kt),ze=n(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-5i9w75"&&(N.innerHTML=Ot),Ee=n(e),h(z.$$.fragment,e),Se=n(e),h(E.$$.fragment,e),qe=n(e),S=r(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-nqxvwk"&&(S.innerHTML=el),Ae=n(e),q=r(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-17o6ivw"&&(q.innerHTML=tl),Pe=n(e),h(A.$$.fragment,e),De=n(e),P=r(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-dwk3fl"&&(P.innerHTML=ll),Ke=n(e),B=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(B)!=="svelte-qtk1m4"&&(B.innerHTML=sl),Oe=n(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-lm2asr"&&(D.innerHTML=al),et=n(e),h(K.$$.fragment,e),tt=n(e),O=r(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-1jdqgot"&&(O.textContent=nl),lt=n(e),h(ee.$$.fragment,e),st=n(e),R=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(R)!=="svelte-td9ph9"&&(R.innerHTML=il),at=n(e),te=r(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-qjj81o"&&(te.innerHTML=ol),nt=n(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-8dx0b8"&&(le.innerHTML=pl),it=n(e),h(se.$$.fragment,e),ot=n(e),ae=r(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1xsy0lm"&&(ae.innerHTML=rl),pt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-8qzwwy"&&(ne.innerHTML=cl),rt=n(e),ie=r(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-ebyy21"&&(ie.textContent=ml),ct=n(e),h(oe.$$.fragment,e),mt=n(e),pe=r(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-kgvk4x"&&(pe.innerHTML=fl),ft=n(e),re=r(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-8tagli"&&(re.innerHTML=ul),ut=n(e),h(ce.$$.fragment,e),dt=n(e),me=r(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-tp0nc4"&&(me.innerHTML=dl),ht=n(e),h(fe.$$.fragment,e),bt=n(e),I=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(I)!=="svelte-1um04qv"&&(I.innerHTML=hl),yt=n(e),ue=r(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-1fu8q94"&&(ue.innerHTML=bl),wt=n(e),h(de.$$.fragment,e),Mt=n(e),he=r(e,"P",{"data-svelte-h":!0}),m(he)!=="svelte-12g5e7u"&&(he.innerHTML=yl),Tt=n(e),h(be.$$.fragment,e),Jt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-12tqltr"&&(ye.innerHTML=wl),gt=n(e),h(we.$$.fragment,e),jt=n(e),h(Me.$$.fragment,e),$t=n(e),Te=r(e,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-1gyzgx0"&&(Te.innerHTML=Ml),Ut=n(e),Je=r(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-13ty8ou"&&(Je.innerHTML=Tl),Zt=n(e),h(X.$$.fragment,e),Gt=n(e),h(ge.$$.fragment,e),_t=n(e),je=r(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-10dnlua"&&(je.innerHTML=Jl),Wt=n(e),$e=r(e,"P",{"data-svelte-h":!0}),m($e)!=="svelte-1kb6ks2"&&($e.innerHTML=gl),xt=n(e),h(Ue.$$.fragment,e),kt=n(e),Ze=r(e,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-13773d2"&&(Ze.innerHTML=jl),vt=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1wm8cfw"&&(Ge.innerHTML=$l),Bt=n(e),C=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(C)!=="svelte-141sjm"&&(C.innerHTML=Ul),Rt=n(e),_e=r(e,"P",{"data-svelte-h":!0}),m(_e)!=="svelte-1rguzol"&&(_e.textContent=Zl),It=n(e),h(We.$$.fragment,e),Xt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-applj5"&&(xe.innerHTML=Gl),Ct=n(e),h(ke.$$.fragment,e),Lt=n(e),h(ve.$$.fragment,e),Vt=n(e),L=r(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),m(L)!=="svelte-dqcyt"&&(L.innerHTML=_l),Ht=n(e),Be=r(e,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-1h88cib"&&(Be.textContent=Wl),Qt=n(e),h(Re.$$.fragment,e),Yt=n(e),h(Ie.$$.fragment,e),Ft=n(e),Xe=r(e,"UL",{"data-svelte-h":!0}),m(Xe)!=="svelte-19g4t6g"&&(Xe.innerHTML=xl),Nt=n(e),h(Ce.$$.fragment,e),zt=n(e),Le=r(e,"P",{}),Bl(Le).forEach(l),this.h()},h(){V(o,"name","hf:doc:metadata"),V(o,"content",Al),V(v,"class","tip"),V(B,"class","tip"),V(R,"class","tip"),V(I,"class","tip"),V(C,"class","tip"),V(L,"class","warning")},m(e,t){Vl(document.head,o),s(e,g,t),s(e,f,t),s(e,u,t),b(T,e,t),s(e,c,t),s(e,i,t),s(e,$,t),s(e,G,t),s(e,J,t),s(e,U,t),s(e,Ve,t),b(H,e,t),s(e,He,t),s(e,Q,t),s(e,Qe,t),b(k,e,t),s(e,Ye,t),b(Y,e,t),s(e,Fe,t),s(e,v,t),s(e,Ne,t),s(e,F,t),s(e,ze,t),s(e,N,t),s(e,Ee,t),b(z,e,t),s(e,Se,t),b(E,e,t),s(e,qe,t),s(e,S,t),s(e,Ae,t),s(e,q,t),s(e,Pe,t),b(A,e,t),s(e,De,t),s(e,P,t),s(e,Ke,t),s(e,B,t),s(e,Oe,t),s(e,D,t),s(e,et,t),b(K,e,t),s(e,tt,t),s(e,O,t),s(e,lt,t),b(ee,e,t),s(e,st,t),s(e,R,t),s(e,at,t),s(e,te,t),s(e,nt,t),s(e,le,t),s(e,it,t),b(se,e,t),s(e,ot,t),s(e,ae,t),s(e,pt,t),s(e,ne,t),s(e,rt,t),s(e,ie,t),s(e,ct,t),b(oe,e,t),s(e,mt,t),s(e,pe,t),s(e,ft,t),s(e,re,t),s(e,ut,t),b(ce,e,t),s(e,dt,t),s(e,me,t),s(e,ht,t),b(fe,e,t),s(e,bt,t),s(e,I,t),s(e,yt,t),s(e,ue,t),s(e,wt,t),b(de,e,t),s(e,Mt,t),s(e,he,t),s(e,Tt,t),b(be,e,t),s(e,Jt,t),s(e,ye,t),s(e,gt,t),b(we,e,t),s(e,jt,t),b(Me,e,t),s(e,$t,t),s(e,Te,t),s(e,Ut,t),s(e,Je,t),s(e,Zt,t),b(X,e,t),s(e,Gt,t),b(ge,e,t),s(e,_t,t),s(e,je,t),s(e,Wt,t),s(e,$e,t),s(e,xt,t),b(Ue,e,t),s(e,kt,t),s(e,Ze,t),s(e,vt,t),s(e,Ge,t),s(e,Bt,t),s(e,C,t),s(e,Rt,t),s(e,_e,t),s(e,It,t),b(We,e,t),s(e,Xt,t),s(e,xe,t),s(e,Ct,t),b(ke,e,t),s(e,Lt,t),b(ve,e,t),s(e,Vt,t),s(e,L,t),s(e,Ht,t),s(e,Be,t),s(e,Qt,t),b(Re,e,t),s(e,Yt,t),b(Ie,e,t),s(e,Ft,t),s(e,Xe,t),s(e,Nt,t),b(Ce,e,t),s(e,zt,t),s(e,Le,t),Et=!0},p(e,[t]){const kl={};t&2&&(kl.$$scope={dirty:t,ctx:e}),k.$set(kl);const vl={};t&2&&(vl.$$scope={dirty:t,ctx:e}),X.$set(vl)},i(e){Et||(y(T.$$.fragment,e),y(H.$$.fragment,e),y(k.$$.fragment,e),y(Y.$$.fragment,e),y(z.$$.fragment,e),y(E.$$.fragment,e),y(A.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(fe.$$.fragment,e),y(de.$$.fragment,e),y(be.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(X.$$.fragment,e),y(ge.$$.fragment,e),y(Ue.$$.fragment,e),y(We.$$.fragment,e),y(ke.$$.fragment,e),y(ve.$$.fragment,e),y(Re.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),Et=!0)},o(e){w(T.$$.fragment,e),w(H.$$.fragment,e),w(k.$$.fragment,e),w(Y.$$.fragment,e),w(z.$$.fragment,e),w(E.$$.fragment,e),w(A.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(se.$$.fragment,e),w(oe.$$.fragment,e),w(ce.$$.fragment,e),w(fe.$$.fragment,e),w(de.$$.fragment,e),w(be.$$.fragment,e),w(we.$$.fragment,e),w(Me.$$.fragment,e),w(X.$$.fragment,e),w(ge.$$.fragment,e),w(Ue.$$.fragment,e),w(We.$$.fragment,e),w(ke.$$.fragment,e),w(ve.$$.fragment,e),w(Re.$$.fragment,e),w(Ie.$$.fragment,e),w(Ce.$$.fragment,e),Et=!1},d(e){e&&(l(g),l(f),l(u),l(c),l(i),l($),l(G),l(J),l(U),l(Ve),l(He),l(Q),l(Qe),l(Ye),l(Fe),l(v),l(Ne),l(F),l(ze),l(N),l(Ee),l(Se),l(qe),l(S),l(Ae),l(q),l(Pe),l(De),l(P),l(Ke),l(B),l(Oe),l(D),l(et),l(tt),l(O),l(lt),l(st),l(R),l(at),l(te),l(nt),l(le),l(it),l(ot),l(ae),l(pt),l(ne),l(rt),l(ie),l(ct),l(mt),l(pe),l(ft),l(re),l(ut),l(dt),l(me),l(ht),l(bt),l(I),l(yt),l(ue),l(wt),l(Mt),l(he),l(Tt),l(Jt),l(ye),l(gt),l(jt),l($t),l(Te),l(Ut),l(Je),l(Zt),l(Gt),l(_t),l(je),l(Wt),l($e),l(xt),l(kt),l(Ze),l(vt),l(Ge),l(Bt),l(C),l(Rt),l(_e),l(It),l(Xt),l(xe),l(Ct),l(Lt),l(Vt),l(L),l(Ht),l(Be),l(Qt),l(Yt),l(Ft),l(Xe),l(Nt),l(zt),l(Le)),l(o),M(T,e),M(H,e),M(k,e),M(Y,e),M(z,e),M(E,e),M(A,e),M(K,e),M(ee,e),M(se,e),M(oe,e),M(ce,e),M(fe,e),M(de,e),M(be,e),M(we,e),M(Me,e),M(X,e),M(ge,e),M(Ue,e),M(We,e),M(ke,e),M(ve,e),M(Re,e),M(Ie,e),M(Ce,e)}}}const Al='{"title":"Accelerate inference","local":"accelerate-inference","sections":[{"title":"Model data type","local":"model-data-type","sections":[],"depth":2},{"title":"Scaled dot product attention","local":"scaled-dot-product-attention","sections":[],"depth":2},{"title":"torch.compile","local":"torchcompile","sections":[{"title":"Dynamic shape compilation","local":"dynamic-shape-compilation","sections":[],"depth":3},{"title":"Regional compilation","local":"regional-compilation","sections":[],"depth":3},{"title":"Graph breaks","local":"graph-breaks","sections":[],"depth":3},{"title":"GPU sync","local":"gpu-sync","sections":[],"depth":3},{"title":"Benchmarks","local":"benchmarks","sections":[],"depth":3}],"depth":2},{"title":"Dynamic quantization","local":"dynamic-quantization","sections":[],"depth":2},{"title":"Fused projection matrices","local":"fused-projection-matrices","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Pl(_){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ss extends Xl{constructor(o){super(),Cl(this,o,Pl,ql,Rl,{})}}export{ss as component};
