import{s as js,o as Is,n as J}from"../chunks/scheduler.8c3d61f6.js";import{S as Js,i as Gs,g as a,s as i,r as m,A as Hs,h as r,f as l,c as s,j as T,u as h,x as p,k,y as t,a as u,v as g,d as b,t as _,w as v}from"../chunks/index.da70eac4.js";import{T as Cn}from"../chunks/Tip.6f698f24.js";import{D as P}from"../chunks/Docstring.367be9ed.js";import{C as Ze}from"../chunks/CodeBlock.a9c4becf.js";import{E as De}from"../chunks/ExampleCodeBlock.dd9ee828.js";import{H as eo,E as Ls}from"../chunks/getInferenceSnippets.cb466318.js";function Ws(C){let o,$='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',f,d,w,n,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=a("p"),o.innerHTML=$,f=i(),d=a("br"),w=i(),n=a("p"),n.innerHTML=M},l(Z){o=r(Z,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17t0bk9"&&(o.innerHTML=$),f=s(Z),d=r(Z,"BR",{}),w=s(Z),n=r(Z,"P",{"data-svelte-h":!0}),p(n)!=="svelte-1a94ctl"&&(n.innerHTML=M)},m(Z,O){u(Z,o,O),u(Z,f,O),u(Z,d,O),u(Z,w,O),u(Z,n,O)},p:J,d(Z){Z&&(l(o),l(f),l(d),l(w),l(n))}}}function Ss(C){let o,$=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=a("p"),o.textContent=$},l(f){o=r(f,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18gkv0g"&&(o.textContent=$)},m(f,d){u(f,o,d)},p:J,d(f){f&&l(o)}}}function Vs(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBaW1nMmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMpJTBBaW5wYWludCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Ns(C){let o,$='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with `hf\nauth login';return{c(){o=a("p"),o.innerHTML=$},l(f){o=r(f,"P",{"data-svelte-h":!0}),p(o)!=="svelte-167kq00"&&(o.innerHTML=$)},m(f,d){u(f,o,d)},p:J,d(f){f&&l(o)}}}function Fs(C){let o,$=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=$},l(f){o=r(f,"P",{"data-svelte-h":!0}),p(o)!=="svelte-ackzsn"&&(o.innerHTML=$)},m(f,d){u(f,o,d)},p:J,d(f){f&&l(o)}}}function Xs(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Bs(C){let o,$="Example:",f,d,w;return d=new Ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlF3ZW4lMkZRd2VuLUltYWdlJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEElMEFwaXBlLmVuYWJsZV9ncm91cF9vZmZsb2FkKCUwQSUyMCUyMCUyMCUyMG9ubG9hZF9kZXZpY2UlM0R0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMkMlMEElMjAlMjAlMjAlMjBvZmZsb2FkX2RldmljZSUzRHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTJDJTBBJTIwJTIwJTIwJTIwb2ZmbG9hZF90eXBlJTNEJTIybGVhZl9sZXZlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zdHJlYW0lM0RUcnVlJTJDJTBBKSUwQWltYWdlJTIwJTNEJTIwcGlwZSglMjJhJTIwYmVhdXRpZnVsJTIwc3Vuc2V0JTIyKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;Qwen/Qwen-Image&quot;</span>, torch_dtype=torch.bfloat16)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_group_offload(
<span class="hljs-meta">... </span>    onload_device=torch.device(<span class="hljs-string">&quot;cuda&quot;</span>),
<span class="hljs-meta">... </span>    offload_device=torch.device(<span class="hljs-string">&quot;cpu&quot;</span>),
<span class="hljs-meta">... </span>    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
<span class="hljs-meta">... </span>    use_stream=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(<span class="hljs-string">&quot;a beautiful sunset&quot;</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-11lpom8"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Rs(C){let o,$=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=$},l(f){o=r(f,"P",{"data-svelte-h":!0}),p(o)!=="svelte-17p1lpg"&&(o.textContent=$)},m(f,d){u(f,o,d)},p:J,d(f){f&&l(o)}}}function Es(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function zs(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFuZXdfcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblNBR1BpcGVsaW5lLmZyb21fcGlwZShwaXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function qs(C){let o,$="If you get the error message below, you need to finetune the weights for your downstream task:",f,d,w;return d=new Ze({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQSUwQS0lMjBjb252X2luLndlaWdodCUzQSUyMGZvdW5kJTIwc2hhcGUlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDQlMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDklMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMG1vZGVsJTIwaW5zdGFudGlhdGVkJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:
- conv_in.weight: found <span class="hljs-keyword">shape </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the checkpoint <span class="hljs-keyword">and </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the model <span class="hljs-keyword">instantiated
</span>You <span class="hljs-keyword">should </span>probably TRAIN this model on a down-stream task to <span class="hljs-keyword">be </span>able to use it for predictions <span class="hljs-keyword">and </span>inference.`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-xueb0m"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Ys(C){let o,$='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>hf auth login</code>.';return{c(){o=a("p"),o.innerHTML=$},l(f){o=r(f,"P",{"data-svelte-h":!0}),p(o)!=="svelte-1qg11oj"&&(o.innerHTML=$)},m(f,d){u(f,o,d)},p:J,d(f){f&&l(o)}}}function As(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUwQSUyMyUyMFVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTE1TRGlzY3JldGVTY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Qs(C){let o,$="Examples:",f,d,w;return d=new Ze({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,f=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),p(o)!=="svelte-kvfsh7"&&(o.textContent=$),f=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,f,M),g(d,n,M),w=!0},p:J,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){_(d.$$.fragment,n),w=!1},d(n){n&&(l(o),l(f)),v(d,n)}}}function Os(C){let o,$,f,d,w,n,M,Z="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",O,je,ji='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',Dn,se,Zn,Ie,Ii="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",jn,Je,Ji='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="amused">aMUSEd</a></td> <td>text2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="auraflow">AuraFlow</a></td> <td>text2image</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="bria_3_2">Bria 3.2</a></td> <td>text2image</td></tr> <tr><td><a href="cogvideox">CogVideoX</a></td> <td>text2video</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_flux">ControlNet with Flux.1</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_hunyuandit">ControlNet with Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sd3">ControlNet with Stable Diffusion 3</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="flux">Flux</a></td> <td>text2image</td></tr> <tr><td><a href="hunyuandit">Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="i2vgenxl">I2VGen-XL</a></td> <td>image2video</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="kolors">Kolors</a></td> <td>text2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="latte">Latte</a></td> <td>text2image</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="lumina">Lumina-T2X</a></td> <td>text2image</td></tr> <tr><td><a href="marigold">Marigold</a></td> <td>depth-estimation, normals-estimation, intrinsic-decomposition</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="pag">PAG</a></td> <td>text2image</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="pia">PIA</a></td> <td>image2video</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pixart_sigma">PixArt-Σ</a></td> <td>text2image</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="stable_audio">Stable Audio</a></td> <td>text2audio</td></tr> <tr><td><a href="stable_cascade">Stable Cascade</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr> <tr><td><a href="visualcloze">VisualCloze</a></td> <td>text2image, image2image, subject driven generation, inpainting, style transfer, image restoration, image editing, [depth,normal,edge,pose]2image, [depth,normal,edge,pose]-estimation, virtual try-on, image relighting</td></tr></tbody>',In,Ge,Jn,y,He,to,yt,Gi="Base class for all pipelines.",no,xt,Hi=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,oo,wt,Li="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",io,$t,Wi="Class attributes:",so,Mt,Si=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,ao,ae,Le,ro,Tt,Vi="Call self as a function.",lo,kt,We,fo,I,Se,co,Ct,Ni=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,po,re,uo,Pt,Fi="Here are the ways to call <code>to</code>:",mo,Ut,Xi=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,ho,L,Ve,go,Dt,Bi=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,bo,Zt,Ri=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,_o,le,vo,de,Ne,yo,jt,Ei=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,xo,fe,Fe,wo,It,zi='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',$o,K,Xe,Mo,Jt,qi="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",To,ce,ko,W,Be,Co,Gt,Yi=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Po,pe,Uo,ue,Do,U,Re,Zo,Ht,Ai=`Applies group offloading to the internal layers of a torch.nn.Module. To understand what group offloading is,
and where it is beneficial, we need to first provide some context on how other supported offloading methods
work.`,jo,Lt,Qi="Typically, offloading is done at two levels:",Io,Wt,Oi=`<li>Module-level: In Diffusers, this can be enabled using the <code>ModelMixin::enable_model_cpu_offload()</code> method. It
works by offloading each component of a pipeline to the CPU for storage, and onloading to the accelerator
device when needed for computation. This method is more memory-efficient than keeping all components on the
accelerator, but the memory requirements are still quite high. For this method to work, one needs memory
equivalent to size of the model in runtime dtype + size of largest intermediate activation tensors to be able
to complete the forward pass.</li> <li>Leaf-level: In Diffusers, this can be enabled using the <code>ModelMixin::enable_sequential_cpu_offload()</code> method.
It
works by offloading the lowest leaf-level parameters of the computation graph to the CPU for storage, and
onloading only the leafs to the accelerator device for computation. This uses the lowest amount of accelerator
memory, but can be slower due to the excessive number of device synchronizations.</li>`,Jo,St,Ki=`Group offloading is a middle ground between the two methods. It works by offloading groups of internal layers,
(either <code>torch.nn.ModuleList</code> or <code>torch.nn.Sequential</code>). This method uses lower memory than module-level
offloading. It is also faster than leaf-level/sequential offloading, as the number of device synchronizations
is reduced.`,Go,Vt,es=`Another supported feature (for CUDA devices with support for asynchronous data transfer streams) is the ability
to overlap data transfer and computation to reduce the overall execution time compared to sequential
offloading. This is enabled using layer prefetching with streams, i.e., the layer that is to be executed next
starts onloading to the accelerator device while the current layer is being executed - this increases the
memory requirements slightly. Note that this implementation also supports leaf-level offloading but can be made
much faster when using streams.`,Ho,me,Lo,he,Ee,Wo,Nt,ts=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the accelerator when its
<code>forward</code> method is called, and the model remains in accelerator until the next model runs. Memory savings are
lower than with <code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution
of the <code>unet</code>.`,So,ge,ze,Vo,Ft,ns=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to accelerator only when their specific submodule has its
<code>forward</code> method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,No,S,qe,Fo,Xt,os=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,Xo,be,Bo,_e,Ro,ee,Ye,Eo,Bt,is=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,zo,ve,qo,j,Ae,Yo,Rt,ss="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",Ao,Et,as="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",Qo,ye,Oo,xe,Ko,we,ei,V,Qe,ti,zt,rs="Method that performs the following:",ni,qt,ls=`<li>Offloads all components.</li> <li>Removes all model hooks that were added when using <code>enable_model_cpu_offload</code>, and then applies them again.
In case the model has not been offloaded, this function is a no-op.</li> <li>Resets stateful diffusers hooks of denoiser components if they were added with
<code>register_hook()</code>.</li>`,oi,Yt,ds=`Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it functions
correctly when applying <code>enable_model_cpu_offload</code>.`,ii,$e,Oe,si,At,fs="Convert a NumPy image or a batch of images to a PIL image.",ai,Me,Ke,ri,Qt,cs="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",li,Te,et,di,Ot,ps="Resets the device maps (if any) to None.",fi,ke,tt,ci,Kt,us=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,Gn,G,nt,pi,en,ms='Enables the FreeU mechanism as in <a href="https://huggingface.co/papers/2309.11497" rel="nofollow">https://huggingface.co/papers/2309.11497</a>.',ui,tn,hs="The suffixes after the scaling factors represent the stages where they are being applied.",mi,nn,gs=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,Hn,ne,ot,hi,on,bs="Disables the FreeU mechanism if enabled.",Ln,it,Wn,F,st,gi,sn,_s="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",bi,te,at,_i,an,vs="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",vi,Ce,Sn,rt,Vn,X,lt,yi,rn,ys=`Base class for all the official callbacks used in a pipeline. This class provides a structure for implementing
custom callbacks and ensures that all callbacks have a consistent interface.`,xi,ln,xs=`Please implement the following:
<code>tensor_inputs</code>: This should return a list of tensor inputs specific to your callback. You will only be able to
include
variables listed in the <code>._callback_tensor_inputs</code> attribute of your pipeline class.
<code>callback_fn</code>: This method defines the core functionality of your callback.`,Nn,B,dt,wi,dn,ws=`Callback function for Stable Diffusion Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,$i,fn,$s="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Fn,R,ft,Mi,cn,Ms=`Callback function for the base Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,Ti,pn,Ts="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Xn,E,ct,ki,un,ks=`Callback function for the Controlnet Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,Ci,mn,Cs="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",Bn,z,pt,Pi,hn,Ps=`Callback function for any pipeline that inherits <code>IPAdapterMixin</code>. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will set the IP Adapter scale to <code>0.0</code>.`,Ui,gn,Us="Note: This callback mutates the IP Adapter attention processors by setting the scale to 0.0 after the cutoff step.",Rn,q,ut,Di,bn,Ds=`Callback function for Stable Diffusion 3 Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,Zi,_n,Zs="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",En,mt,zn,Pn,qn;return w=new eo({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),se=new Cn({props:{warning:!0,$$slots:{default:[Ws]},$$scope:{ctx:C}}}),Ge=new eo({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),He=new P({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L181"}}),Le=new P({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),We=new P({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L566",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Se=new P({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L370",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),re=new Cn({props:{$$slots:{default:[Ss]},$$scope:{ctx:C}}}),Ve=new P({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1877"}}),le=new De({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[Vs]},$$scope:{ctx:C}}}),Ne=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2042"}}),Fe=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1976"}}),Xe=new P({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified DDUF file.`,name:"dduf_file(str,"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1485",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),ce=new Cn({props:{$$slots:{default:[Ns]},$$scope:{ctx:C}}}),Be=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2002"}}),pe=new Cn({props:{warning:!0,$$slots:{default:[Fs]},$$scope:{ctx:C}}}),ue=new De({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[Xs]},$$scope:{ctx:C}}}),Re=new P({props:{name:"enable_group_offload",anchor:"diffusers.DiffusionPipeline.enable_group_offload",parameters:[{name:"onload_device",val:": device"},{name:"offload_device",val:": device = device(type='cpu')"},{name:"offload_type",val:": str = 'block_level'"},{name:"num_blocks_per_group",val:": typing.Optional[int] = None"},{name:"non_blocking",val:": bool = False"},{name:"use_stream",val:": bool = False"},{name:"record_stream",val:": bool = False"},{name:"low_cpu_mem_usage",val:" = False"},{name:"offload_to_disk_path",val:": typing.Optional[str] = None"},{name:"exclude_modules",val:": typing.Union[str, typing.List[str], NoneType] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_group_offload.onload_device",description:`<strong>onload_device</strong> (<code>torch.device</code>) &#x2014;
The device to which the group of modules are onloaded.`,name:"onload_device"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_device",description:`<strong>offload_device</strong> (<code>torch.device</code>, defaults to <code>torch.device(&quot;cpu&quot;)</code>) &#x2014;
The device to which the group of modules are offloaded. This should typically be the CPU. Default is
CPU.`,name:"offload_device"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_type",description:`<strong>offload_type</strong> (<code>str</code> or <code>GroupOffloadingType</code>, defaults to &#x201C;block_level&#x201D;) &#x2014;
The type of offloading to be applied. Can be one of &#x201C;block_level&#x201D; or &#x201C;leaf_level&#x201D;. Default is
&#x201C;block_level&#x201D;.`,name:"offload_type"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.offload_to_disk_path",description:`<strong>offload_to_disk_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The path to the directory where parameters will be offloaded. Setting this option can be useful in
limited RAM environment settings where a reasonable speed-memory trade-off is desired.`,name:"offload_to_disk_path"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.num_blocks_per_group",description:`<strong>num_blocks_per_group</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of blocks per group when using offload_type=&#x201C;block_level&#x201D;. This is required when using
offload_type=&#x201C;block_level&#x201D;.`,name:"num_blocks_per_group"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.non_blocking",description:`<strong>non_blocking</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, offloading and onloading is done with non-blocking data transfer.`,name:"non_blocking"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.use_stream",description:`<strong>use_stream</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, offloading and onloading is done asynchronously using a CUDA stream. This can be useful for
overlapping computation and data transfer.`,name:"use_stream"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.record_stream",description:`<strong>record_stream</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014; When enabled with <code>use_stream</code>, it marks the current tensor
as having been used by this stream. It is faster at the expense of slightly more memory usage. Refer to
the <a href="https://pytorch.org/docs/stable/generated/torch.Tensor.record_stream.html" rel="nofollow">PyTorch official docs</a>
more details.`,name:"record_stream"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
If True, the CPU memory usage is minimized by pinning tensors on-the-fly instead of pre-pinning them.
This option only matters when using streamed CPU offloading (i.e. <code>use_stream=True</code>). This can be
useful when the CPU memory is a bottleneck but may counteract the benefits of using streams.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.enable_group_offload.exclude_modules",description:"<strong>exclude_modules</strong> (<code>Union[str, List[str]]</code>, defaults to <code>None</code>) &#x2014; List of modules to exclude from offloading.",name:"exclude_modules"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1345"}}),me=new De({props:{anchor:"diffusers.DiffusionPipeline.enable_group_offload.example",$$slots:{default:[Bs]},$$scope:{ctx:C}}}),Ee=new P({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1162"}}),ze=new P({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1278"}}),qe=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1941"}}),be=new Cn({props:{warning:!0,$$slots:{default:[Rs]},$$scope:{ctx:C}}}),_e=new De({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Es]},$$scope:{ctx:C}}}),Ye=new P({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2058",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),ve=new De({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[zs]},$$scope:{ctx:C}}}),Ae=new P({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing a dduf file</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code> or <code>dict[str, Union[str, torch.dtype]]</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. To load submodels with
different dtype pass a <code>dict</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;vae&apos;: torch.float16}</code>).
Set the default dtype for unspecified components with <code>default</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;default&apos;: torch.float16}</code>). If a component is not specified and no default is set,
<code>torch.float32</code> is used.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Strategy that dictates how the different components of a pipeline should be placed on available
devices. Currently, only &#x201C;balanced&#x201D; <code>device_map</code> is supported. Check out
<a href="https://huggingface.co/docs/diffusers/main/en/tutorials/inference_with_big_models#device-placement" rel="nofollow">this</a>
to know more.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified dduf file.`,name:"dduf_file(str,"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L596"}}),ye=new De({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[qs]},$$scope:{ctx:C}}}),xe=new Cn({props:{$$slots:{default:[Ys]},$$scope:{ctx:C}}}),we=new De({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[As]},$$scope:{ctx:C}}}),Qe=new P({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1255"}}),Oe=new P({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1915"}}),Ke=new P({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1153"}}),et=new P({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1472"}}),tt=new P({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>None</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L237"}}),nt=new P({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2260"}}),ot=new P({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2282"}}),it=new eo({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),st=new P({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L464"}}),at=new P({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"subfolder",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running <code>hf auth login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L499"}}),Ce=new De({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[Qs]},$$scope:{ctx:C}}}),rt=new eo({props:{title:"Callbacks",local:"diffusers.callbacks.PipelineCallback",headingTag:"h2"}}),lt=new P({props:{name:"class diffusers.callbacks.PipelineCallback",anchor:"diffusers.callbacks.PipelineCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L7"}}),dt=new P({props:{name:"class diffusers.callbacks.SDCFGCutoffCallback",anchor:"diffusers.callbacks.SDCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L69"}}),ft=new P({props:{name:"class diffusers.callbacks.SDXLCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L98"}}),ct=new P({props:{name:"class diffusers.callbacks.SDXLControlnetCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLControlnetCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L140"}}),pt=new P({props:{name:"class diffusers.callbacks.IPAdapterScaleCutoffCallback",anchor:"diffusers.callbacks.IPAdapterScaleCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L188"}}),ut=new P({props:{name:"class diffusers.callbacks.SD3CFGCutoffCallback",anchor:"diffusers.callbacks.SD3CFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L212"}}),mt=new Ls({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=a("meta"),$=i(),f=a("p"),d=i(),m(w.$$.fragment),n=i(),M=a("p"),M.textContent=Z,O=i(),je=a("p"),je.innerHTML=ji,Dn=i(),m(se.$$.fragment),Zn=i(),Ie=a("p"),Ie.textContent=Ii,jn=i(),Je=a("table"),Je.innerHTML=Ji,In=i(),m(Ge.$$.fragment),Jn=i(),y=a("div"),m(He.$$.fragment),to=i(),yt=a("p"),yt.textContent=Gi,no=i(),xt=a("p"),xt.innerHTML=Hi,oo=i(),wt=a("ul"),wt.innerHTML=Li,io=i(),$t=a("p"),$t.textContent=Wi,so=i(),Mt=a("ul"),Mt.innerHTML=Si,ao=i(),ae=a("div"),m(Le.$$.fragment),ro=i(),Tt=a("p"),Tt.textContent=Vi,lo=i(),kt=a("div"),m(We.$$.fragment),fo=i(),I=a("div"),m(Se.$$.fragment),co=i(),Ct=a("p"),Ct.innerHTML=Ni,po=i(),m(re.$$.fragment),uo=i(),Pt=a("p"),Pt.innerHTML=Fi,mo=i(),Ut=a("ul"),Ut.innerHTML=Xi,ho=i(),L=a("div"),m(Ve.$$.fragment),go=i(),Dt=a("p"),Dt.innerHTML=Bi,bo=i(),Zt=a("p"),Zt.innerHTML=Ri,_o=i(),m(le.$$.fragment),vo=i(),de=a("div"),m(Ne.$$.fragment),yo=i(),jt=a("p"),jt.innerHTML=Ei,xo=i(),fe=a("div"),m(Fe.$$.fragment),wo=i(),It=a("p"),It.innerHTML=zi,$o=i(),K=a("div"),m(Xe.$$.fragment),Mo=i(),Jt=a("p"),Jt.textContent=qi,To=i(),m(ce.$$.fragment),ko=i(),W=a("div"),m(Be.$$.fragment),Co=i(),Gt=a("p"),Gt.textContent=Yi,Po=i(),m(pe.$$.fragment),Uo=i(),m(ue.$$.fragment),Do=i(),U=a("div"),m(Re.$$.fragment),Zo=i(),Ht=a("p"),Ht.textContent=Ai,jo=i(),Lt=a("p"),Lt.textContent=Qi,Io=i(),Wt=a("ul"),Wt.innerHTML=Oi,Jo=i(),St=a("p"),St.innerHTML=Ki,Go=i(),Vt=a("p"),Vt.textContent=es,Ho=i(),m(me.$$.fragment),Lo=i(),he=a("div"),m(Ee.$$.fragment),Wo=i(),Nt=a("p"),Nt.innerHTML=ts,So=i(),ge=a("div"),m(ze.$$.fragment),Vo=i(),Ft=a("p"),Ft.innerHTML=ns,No=i(),S=a("div"),m(qe.$$.fragment),Fo=i(),Xt=a("p"),Xt.innerHTML=os,Xo=i(),m(be.$$.fragment),Bo=i(),m(_e.$$.fragment),Ro=i(),ee=a("div"),m(Ye.$$.fragment),Eo=i(),Bt=a("p"),Bt.textContent=is,zo=i(),m(ve.$$.fragment),qo=i(),j=a("div"),m(Ae.$$.fragment),Yo=i(),Rt=a("p"),Rt.textContent=ss,Ao=i(),Et=a("p"),Et.innerHTML=as,Qo=i(),m(ye.$$.fragment),Oo=i(),m(xe.$$.fragment),Ko=i(),m(we.$$.fragment),ei=i(),V=a("div"),m(Qe.$$.fragment),ti=i(),zt=a("p"),zt.textContent=rs,ni=i(),qt=a("ul"),qt.innerHTML=ls,oi=i(),Yt=a("p"),Yt.innerHTML=ds,ii=i(),$e=a("div"),m(Oe.$$.fragment),si=i(),At=a("p"),At.textContent=fs,ai=i(),Me=a("div"),m(Ke.$$.fragment),ri=i(),Qt=a("p"),Qt.innerHTML=cs,li=i(),Te=a("div"),m(et.$$.fragment),di=i(),Ot=a("p"),Ot.textContent=ps,fi=i(),ke=a("div"),m(tt.$$.fragment),ci=i(),Kt=a("p"),Kt.innerHTML=us,Gn=i(),G=a("div"),m(nt.$$.fragment),pi=i(),en=a("p"),en.innerHTML=ms,ui=i(),tn=a("p"),tn.textContent=hs,mi=i(),nn=a("p"),nn.innerHTML=gs,Hn=i(),ne=a("div"),m(ot.$$.fragment),hi=i(),on=a("p"),on.textContent=bs,Ln=i(),m(it.$$.fragment),Wn=i(),F=a("div"),m(st.$$.fragment),gi=i(),sn=a("p"),sn.textContent=_s,bi=i(),te=a("div"),m(at.$$.fragment),_i=i(),an=a("p"),an.textContent=vs,vi=i(),m(Ce.$$.fragment),Sn=i(),m(rt.$$.fragment),Vn=i(),X=a("div"),m(lt.$$.fragment),yi=i(),rn=a("p"),rn.textContent=ys,xi=i(),ln=a("p"),ln.innerHTML=xs,Nn=i(),B=a("div"),m(dt.$$.fragment),wi=i(),dn=a("p"),dn.innerHTML=ws,$i=i(),fn=a("p"),fn.innerHTML=$s,Fn=i(),R=a("div"),m(ft.$$.fragment),Mi=i(),cn=a("p"),cn.innerHTML=Ms,Ti=i(),pn=a("p"),pn.innerHTML=Ts,Xn=i(),E=a("div"),m(ct.$$.fragment),ki=i(),un=a("p"),un.innerHTML=ks,Ci=i(),mn=a("p"),mn.innerHTML=Cs,Bn=i(),z=a("div"),m(pt.$$.fragment),Pi=i(),hn=a("p"),hn.innerHTML=Ps,Ui=i(),gn=a("p"),gn.textContent=Us,Rn=i(),q=a("div"),m(ut.$$.fragment),Di=i(),bn=a("p"),bn.innerHTML=Ds,Zi=i(),_n=a("p"),_n.innerHTML=Zs,En=i(),m(mt.$$.fragment),zn=i(),Pn=a("p"),this.h()},l(e){const c=Hs("svelte-u9bgzb",document.head);o=r(c,"META",{name:!0,content:!0}),c.forEach(l),$=s(e),f=r(e,"P",{}),T(f).forEach(l),d=s(e),h(w.$$.fragment,e),n=s(e),M=r(e,"P",{"data-svelte-h":!0}),p(M)!=="svelte-eejdx6"&&(M.textContent=Z),O=s(e),je=r(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1d3b6kb"&&(je.innerHTML=ji),Dn=s(e),h(se.$$.fragment,e),Zn=s(e),Ie=r(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-2xd39c"&&(Ie.textContent=Ii),jn=s(e),Je=r(e,"TABLE",{"data-svelte-h":!0}),p(Je)!=="svelte-16ga3pv"&&(Je.innerHTML=Ji),In=s(e),h(Ge.$$.fragment,e),Jn=s(e),y=r(e,"DIV",{class:!0});var x=T(y);h(He.$$.fragment,x),to=s(x),yt=r(x,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-1neg3rw"&&(yt.textContent=Gi),no=s(x),xt=r(x,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1kbb8l4"&&(xt.innerHTML=Hi),oo=s(x),wt=r(x,"UL",{"data-svelte-h":!0}),p(wt)!=="svelte-2a5chx"&&(wt.innerHTML=Li),io=s(x),$t=r(x,"P",{"data-svelte-h":!0}),p($t)!=="svelte-wz8va1"&&($t.textContent=Wi),so=s(x),Mt=r(x,"UL",{"data-svelte-h":!0}),p(Mt)!=="svelte-1ilr6sx"&&(Mt.innerHTML=Si),ao=s(x),ae=r(x,"DIV",{class:!0});var ht=T(ae);h(Le.$$.fragment,ht),ro=s(ht),Tt=r(ht,"P",{"data-svelte-h":!0}),p(Tt)!=="svelte-1eed40t"&&(Tt.textContent=Vi),ht.forEach(l),lo=s(x),kt=r(x,"DIV",{class:!0});var Un=T(kt);h(We.$$.fragment,Un),Un.forEach(l),fo=s(x),I=r(x,"DIV",{class:!0});var H=T(I);h(Se.$$.fragment,H),co=s(H),Ct=r(H,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-1vbhnip"&&(Ct.innerHTML=Ni),po=s(H),h(re.$$.fragment,H),uo=s(H),Pt=r(H,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-5ul9n2"&&(Pt.innerHTML=Fi),mo=s(H),Ut=r(H,"UL",{"data-svelte-h":!0}),p(Ut)!=="svelte-1icy6l9"&&(Ut.innerHTML=Xi),H.forEach(l),ho=s(x),L=r(x,"DIV",{class:!0});var Y=T(L);h(Ve.$$.fragment,Y),go=s(Y),Dt=r(Y,"P",{"data-svelte-h":!0}),p(Dt)!=="svelte-had4mb"&&(Dt.innerHTML=Bi),bo=s(Y),Zt=r(Y,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-19k67ce"&&(Zt.innerHTML=Ri),_o=s(Y),h(le.$$.fragment,Y),Y.forEach(l),vo=s(x),de=r(x,"DIV",{class:!0});var gt=T(de);h(Ne.$$.fragment,gt),yo=s(gt),jt=r(gt,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1lh0nh5"&&(jt.innerHTML=Ei),gt.forEach(l),xo=s(x),fe=r(x,"DIV",{class:!0});var bt=T(fe);h(Fe.$$.fragment,bt),wo=s(bt),It=r(bt,"P",{"data-svelte-h":!0}),p(It)!=="svelte-1vfte1e"&&(It.innerHTML=zi),bt.forEach(l),$o=s(x),K=r(x,"DIV",{class:!0});var oe=T(K);h(Xe.$$.fragment,oe),Mo=s(oe),Jt=r(oe,"P",{"data-svelte-h":!0}),p(Jt)!=="svelte-1mfctah"&&(Jt.textContent=qi),To=s(oe),h(ce.$$.fragment,oe),oe.forEach(l),ko=s(x),W=r(x,"DIV",{class:!0});var A=T(W);h(Be.$$.fragment,A),Co=s(A),Gt=r(A,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-10jaql7"&&(Gt.textContent=Yi),Po=s(A),h(pe.$$.fragment,A),Uo=s(A),h(ue.$$.fragment,A),A.forEach(l),Do=s(x),U=r(x,"DIV",{class:!0});var D=T(U);h(Re.$$.fragment,D),Zo=s(D),Ht=r(D,"P",{"data-svelte-h":!0}),p(Ht)!=="svelte-1umao2b"&&(Ht.textContent=Ai),jo=s(D),Lt=r(D,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-1b92jfk"&&(Lt.textContent=Qi),Io=s(D),Wt=r(D,"UL",{"data-svelte-h":!0}),p(Wt)!=="svelte-1n0e5q1"&&(Wt.innerHTML=Oi),Jo=s(D),St=r(D,"P",{"data-svelte-h":!0}),p(St)!=="svelte-1yl7dpl"&&(St.innerHTML=Ki),Go=s(D),Vt=r(D,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-v0d0nn"&&(Vt.textContent=es),Ho=s(D),h(me.$$.fragment,D),D.forEach(l),Lo=s(x),he=r(x,"DIV",{class:!0});var _t=T(he);h(Ee.$$.fragment,_t),Wo=s(_t),Nt=r(_t,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-9hgqai"&&(Nt.innerHTML=ts),_t.forEach(l),So=s(x),ge=r(x,"DIV",{class:!0});var vt=T(ge);h(ze.$$.fragment,vt),Vo=s(vt),Ft=r(vt,"P",{"data-svelte-h":!0}),p(Ft)!=="svelte-1bs0ixe"&&(Ft.innerHTML=ns),vt.forEach(l),No=s(x),S=r(x,"DIV",{class:!0});var Q=T(S);h(qe.$$.fragment,Q),Fo=s(Q),Xt=r(Q,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-e03q3e"&&(Xt.innerHTML=os),Xo=s(Q),h(be.$$.fragment,Q),Bo=s(Q),h(_e.$$.fragment,Q),Q.forEach(l),Ro=s(x),ee=r(x,"DIV",{class:!0});var ie=T(ee);h(Ye.$$.fragment,ie),Eo=s(ie),Bt=r(ie,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-1jx3icn"&&(Bt.textContent=is),zo=s(ie),h(ve.$$.fragment,ie),ie.forEach(l),qo=s(x),j=r(x,"DIV",{class:!0});var N=T(j);h(Ae.$$.fragment,N),Yo=s(N),Rt=r(N,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-ccbjek"&&(Rt.textContent=ss),Ao=s(N),Et=r(N,"P",{"data-svelte-h":!0}),p(Et)!=="svelte-1p5vgmd"&&(Et.innerHTML=as),Qo=s(N),h(ye.$$.fragment,N),Oo=s(N),h(xe.$$.fragment,N),Ko=s(N),h(we.$$.fragment,N),N.forEach(l),ei=s(x),V=r(x,"DIV",{class:!0});var Pe=T(V);h(Qe.$$.fragment,Pe),ti=s(Pe),zt=r(Pe,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-z79kjq"&&(zt.textContent=rs),ni=s(Pe),qt=r(Pe,"UL",{"data-svelte-h":!0}),p(qt)!=="svelte-1ju7puc"&&(qt.innerHTML=ls),oi=s(Pe),Yt=r(Pe,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-1pqppti"&&(Yt.innerHTML=ds),Pe.forEach(l),ii=s(x),$e=r(x,"DIV",{class:!0});var Yn=T($e);h(Oe.$$.fragment,Yn),si=s(Yn),At=r(Yn,"P",{"data-svelte-h":!0}),p(At)!=="svelte-1gut907"&&(At.textContent=fs),Yn.forEach(l),ai=s(x),Me=r(x,"DIV",{class:!0});var An=T(Me);h(Ke.$$.fragment,An),ri=s(An),Qt=r(An,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-8kophh"&&(Qt.innerHTML=cs),An.forEach(l),li=s(x),Te=r(x,"DIV",{class:!0});var Qn=T(Te);h(et.$$.fragment,Qn),di=s(Qn),Ot=r(Qn,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-6tjysh"&&(Ot.textContent=ps),Qn.forEach(l),fi=s(x),ke=r(x,"DIV",{class:!0});var On=T(ke);h(tt.$$.fragment,On),ci=s(On),Kt=r(On,"P",{"data-svelte-h":!0}),p(Kt)!=="svelte-1jcmq84"&&(Kt.innerHTML=us),On.forEach(l),x.forEach(l),Gn=s(e),G=r(e,"DIV",{class:!0});var Ue=T(G);h(nt.$$.fragment,Ue),pi=s(Ue),en=r(Ue,"P",{"data-svelte-h":!0}),p(en)!=="svelte-192jnkh"&&(en.innerHTML=ms),ui=s(Ue),tn=r(Ue,"P",{"data-svelte-h":!0}),p(tn)!=="svelte-xjijlp"&&(tn.textContent=hs),mi=s(Ue),nn=r(Ue,"P",{"data-svelte-h":!0}),p(nn)!=="svelte-hy0nzs"&&(nn.innerHTML=gs),Ue.forEach(l),Hn=s(e),ne=r(e,"DIV",{class:!0});var Kn=T(ne);h(ot.$$.fragment,Kn),hi=s(Kn),on=r(Kn,"P",{"data-svelte-h":!0}),p(on)!=="svelte-psupw6"&&(on.textContent=bs),Kn.forEach(l),Ln=s(e),h(it.$$.fragment,e),Wn=s(e),F=r(e,"DIV",{class:!0});var vn=T(F);h(st.$$.fragment,vn),gi=s(vn),sn=r(vn,"P",{"data-svelte-h":!0}),p(sn)!=="svelte-7y8zei"&&(sn.textContent=_s),bi=s(vn),te=r(vn,"DIV",{class:!0});var yn=T(te);h(at.$$.fragment,yn),_i=s(yn),an=r(yn,"P",{"data-svelte-h":!0}),p(an)!=="svelte-5nfhmh"&&(an.textContent=vs),vi=s(yn),h(Ce.$$.fragment,yn),yn.forEach(l),vn.forEach(l),Sn=s(e),h(rt.$$.fragment,e),Vn=s(e),X=r(e,"DIV",{class:!0});var xn=T(X);h(lt.$$.fragment,xn),yi=s(xn),rn=r(xn,"P",{"data-svelte-h":!0}),p(rn)!=="svelte-2ua579"&&(rn.textContent=ys),xi=s(xn),ln=r(xn,"P",{"data-svelte-h":!0}),p(ln)!=="svelte-qrped9"&&(ln.innerHTML=xs),xn.forEach(l),Nn=s(e),B=r(e,"DIV",{class:!0});var wn=T(B);h(dt.$$.fragment,wn),wi=s(wn),dn=r(wn,"P",{"data-svelte-h":!0}),p(dn)!=="svelte-1lxhnsk"&&(dn.innerHTML=ws),$i=s(wn),fn=r(wn,"P",{"data-svelte-h":!0}),p(fn)!=="svelte-twxvjk"&&(fn.innerHTML=$s),wn.forEach(l),Fn=s(e),R=r(e,"DIV",{class:!0});var $n=T(R);h(ft.$$.fragment,$n),Mi=s($n),cn=r($n,"P",{"data-svelte-h":!0}),p(cn)!=="svelte-1pnjwf0"&&(cn.innerHTML=Ms),Ti=s($n),pn=r($n,"P",{"data-svelte-h":!0}),p(pn)!=="svelte-twxvjk"&&(pn.innerHTML=Ts),$n.forEach(l),Xn=s(e),E=r(e,"DIV",{class:!0});var Mn=T(E);h(ct.$$.fragment,Mn),ki=s(Mn),un=r(Mn,"P",{"data-svelte-h":!0}),p(un)!=="svelte-wsvz4z"&&(un.innerHTML=ks),Ci=s(Mn),mn=r(Mn,"P",{"data-svelte-h":!0}),p(mn)!=="svelte-twxvjk"&&(mn.innerHTML=Cs),Mn.forEach(l),Bn=s(e),z=r(e,"DIV",{class:!0});var Tn=T(z);h(pt.$$.fragment,Tn),Pi=s(Tn),hn=r(Tn,"P",{"data-svelte-h":!0}),p(hn)!=="svelte-1pf8icy"&&(hn.innerHTML=Ps),Ui=s(Tn),gn=r(Tn,"P",{"data-svelte-h":!0}),p(gn)!=="svelte-1kg1eq5"&&(gn.textContent=Us),Tn.forEach(l),Rn=s(e),q=r(e,"DIV",{class:!0});var kn=T(q);h(ut.$$.fragment,kn),Di=s(kn),bn=r(kn,"P",{"data-svelte-h":!0}),p(bn)!=="svelte-461fyb"&&(bn.innerHTML=Ds),Zi=s(kn),_n=r(kn,"P",{"data-svelte-h":!0}),p(_n)!=="svelte-twxvjk"&&(_n.innerHTML=Zs),kn.forEach(l),En=s(e),h(mt.$$.fragment,e),zn=s(e),Pn=r(e,"P",{}),T(Pn).forEach(l),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",Ks),k(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){t(document.head,o),u(e,$,c),u(e,f,c),u(e,d,c),g(w,e,c),u(e,n,c),u(e,M,c),u(e,O,c),u(e,je,c),u(e,Dn,c),g(se,e,c),u(e,Zn,c),u(e,Ie,c),u(e,jn,c),u(e,Je,c),u(e,In,c),g(Ge,e,c),u(e,Jn,c),u(e,y,c),g(He,y,null),t(y,to),t(y,yt),t(y,no),t(y,xt),t(y,oo),t(y,wt),t(y,io),t(y,$t),t(y,so),t(y,Mt),t(y,ao),t(y,ae),g(Le,ae,null),t(ae,ro),t(ae,Tt),t(y,lo),t(y,kt),g(We,kt,null),t(y,fo),t(y,I),g(Se,I,null),t(I,co),t(I,Ct),t(I,po),g(re,I,null),t(I,uo),t(I,Pt),t(I,mo),t(I,Ut),t(y,ho),t(y,L),g(Ve,L,null),t(L,go),t(L,Dt),t(L,bo),t(L,Zt),t(L,_o),g(le,L,null),t(y,vo),t(y,de),g(Ne,de,null),t(de,yo),t(de,jt),t(y,xo),t(y,fe),g(Fe,fe,null),t(fe,wo),t(fe,It),t(y,$o),t(y,K),g(Xe,K,null),t(K,Mo),t(K,Jt),t(K,To),g(ce,K,null),t(y,ko),t(y,W),g(Be,W,null),t(W,Co),t(W,Gt),t(W,Po),g(pe,W,null),t(W,Uo),g(ue,W,null),t(y,Do),t(y,U),g(Re,U,null),t(U,Zo),t(U,Ht),t(U,jo),t(U,Lt),t(U,Io),t(U,Wt),t(U,Jo),t(U,St),t(U,Go),t(U,Vt),t(U,Ho),g(me,U,null),t(y,Lo),t(y,he),g(Ee,he,null),t(he,Wo),t(he,Nt),t(y,So),t(y,ge),g(ze,ge,null),t(ge,Vo),t(ge,Ft),t(y,No),t(y,S),g(qe,S,null),t(S,Fo),t(S,Xt),t(S,Xo),g(be,S,null),t(S,Bo),g(_e,S,null),t(y,Ro),t(y,ee),g(Ye,ee,null),t(ee,Eo),t(ee,Bt),t(ee,zo),g(ve,ee,null),t(y,qo),t(y,j),g(Ae,j,null),t(j,Yo),t(j,Rt),t(j,Ao),t(j,Et),t(j,Qo),g(ye,j,null),t(j,Oo),g(xe,j,null),t(j,Ko),g(we,j,null),t(y,ei),t(y,V),g(Qe,V,null),t(V,ti),t(V,zt),t(V,ni),t(V,qt),t(V,oi),t(V,Yt),t(y,ii),t(y,$e),g(Oe,$e,null),t($e,si),t($e,At),t(y,ai),t(y,Me),g(Ke,Me,null),t(Me,ri),t(Me,Qt),t(y,li),t(y,Te),g(et,Te,null),t(Te,di),t(Te,Ot),t(y,fi),t(y,ke),g(tt,ke,null),t(ke,ci),t(ke,Kt),u(e,Gn,c),u(e,G,c),g(nt,G,null),t(G,pi),t(G,en),t(G,ui),t(G,tn),t(G,mi),t(G,nn),u(e,Hn,c),u(e,ne,c),g(ot,ne,null),t(ne,hi),t(ne,on),u(e,Ln,c),g(it,e,c),u(e,Wn,c),u(e,F,c),g(st,F,null),t(F,gi),t(F,sn),t(F,bi),t(F,te),g(at,te,null),t(te,_i),t(te,an),t(te,vi),g(Ce,te,null),u(e,Sn,c),g(rt,e,c),u(e,Vn,c),u(e,X,c),g(lt,X,null),t(X,yi),t(X,rn),t(X,xi),t(X,ln),u(e,Nn,c),u(e,B,c),g(dt,B,null),t(B,wi),t(B,dn),t(B,$i),t(B,fn),u(e,Fn,c),u(e,R,c),g(ft,R,null),t(R,Mi),t(R,cn),t(R,Ti),t(R,pn),u(e,Xn,c),u(e,E,c),g(ct,E,null),t(E,ki),t(E,un),t(E,Ci),t(E,mn),u(e,Bn,c),u(e,z,c),g(pt,z,null),t(z,Pi),t(z,hn),t(z,Ui),t(z,gn),u(e,Rn,c),u(e,q,c),g(ut,q,null),t(q,Di),t(q,bn),t(q,Zi),t(q,_n),u(e,En,c),g(mt,e,c),u(e,zn,c),u(e,Pn,c),qn=!0},p(e,[c]){const x={};c&2&&(x.$$scope={dirty:c,ctx:e}),se.$set(x);const ht={};c&2&&(ht.$$scope={dirty:c,ctx:e}),re.$set(ht);const Un={};c&2&&(Un.$$scope={dirty:c,ctx:e}),le.$set(Un);const H={};c&2&&(H.$$scope={dirty:c,ctx:e}),ce.$set(H);const Y={};c&2&&(Y.$$scope={dirty:c,ctx:e}),pe.$set(Y);const gt={};c&2&&(gt.$$scope={dirty:c,ctx:e}),ue.$set(gt);const bt={};c&2&&(bt.$$scope={dirty:c,ctx:e}),me.$set(bt);const oe={};c&2&&(oe.$$scope={dirty:c,ctx:e}),be.$set(oe);const A={};c&2&&(A.$$scope={dirty:c,ctx:e}),_e.$set(A);const D={};c&2&&(D.$$scope={dirty:c,ctx:e}),ve.$set(D);const _t={};c&2&&(_t.$$scope={dirty:c,ctx:e}),ye.$set(_t);const vt={};c&2&&(vt.$$scope={dirty:c,ctx:e}),xe.$set(vt);const Q={};c&2&&(Q.$$scope={dirty:c,ctx:e}),we.$set(Q);const ie={};c&2&&(ie.$$scope={dirty:c,ctx:e}),Ce.$set(ie)},i(e){qn||(b(w.$$.fragment,e),b(se.$$.fragment,e),b(Ge.$$.fragment,e),b(He.$$.fragment,e),b(Le.$$.fragment,e),b(We.$$.fragment,e),b(Se.$$.fragment,e),b(re.$$.fragment,e),b(Ve.$$.fragment,e),b(le.$$.fragment,e),b(Ne.$$.fragment,e),b(Fe.$$.fragment,e),b(Xe.$$.fragment,e),b(ce.$$.fragment,e),b(Be.$$.fragment,e),b(pe.$$.fragment,e),b(ue.$$.fragment,e),b(Re.$$.fragment,e),b(me.$$.fragment,e),b(Ee.$$.fragment,e),b(ze.$$.fragment,e),b(qe.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(Ye.$$.fragment,e),b(ve.$$.fragment,e),b(Ae.$$.fragment,e),b(ye.$$.fragment,e),b(xe.$$.fragment,e),b(we.$$.fragment,e),b(Qe.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(et.$$.fragment,e),b(tt.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(it.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(Ce.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(ft.$$.fragment,e),b(ct.$$.fragment,e),b(pt.$$.fragment,e),b(ut.$$.fragment,e),b(mt.$$.fragment,e),qn=!0)},o(e){_(w.$$.fragment,e),_(se.$$.fragment,e),_(Ge.$$.fragment,e),_(He.$$.fragment,e),_(Le.$$.fragment,e),_(We.$$.fragment,e),_(Se.$$.fragment,e),_(re.$$.fragment,e),_(Ve.$$.fragment,e),_(le.$$.fragment,e),_(Ne.$$.fragment,e),_(Fe.$$.fragment,e),_(Xe.$$.fragment,e),_(ce.$$.fragment,e),_(Be.$$.fragment,e),_(pe.$$.fragment,e),_(ue.$$.fragment,e),_(Re.$$.fragment,e),_(me.$$.fragment,e),_(Ee.$$.fragment,e),_(ze.$$.fragment,e),_(qe.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(Ye.$$.fragment,e),_(ve.$$.fragment,e),_(Ae.$$.fragment,e),_(ye.$$.fragment,e),_(xe.$$.fragment,e),_(we.$$.fragment,e),_(Qe.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(et.$$.fragment,e),_(tt.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(Ce.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(ft.$$.fragment,e),_(ct.$$.fragment,e),_(pt.$$.fragment,e),_(ut.$$.fragment,e),_(mt.$$.fragment,e),qn=!1},d(e){e&&(l($),l(f),l(d),l(n),l(M),l(O),l(je),l(Dn),l(Zn),l(Ie),l(jn),l(Je),l(In),l(Jn),l(y),l(Gn),l(G),l(Hn),l(ne),l(Ln),l(Wn),l(F),l(Sn),l(Vn),l(X),l(Nn),l(B),l(Fn),l(R),l(Xn),l(E),l(Bn),l(z),l(Rn),l(q),l(En),l(zn),l(Pn)),l(o),v(w,e),v(se,e),v(Ge,e),v(He),v(Le),v(We),v(Se),v(re),v(Ve),v(le),v(Ne),v(Fe),v(Xe),v(ce),v(Be),v(pe),v(ue),v(Re),v(me),v(Ee),v(ze),v(qe),v(be),v(_e),v(Ye),v(ve),v(Ae),v(ye),v(xe),v(we),v(Qe),v(Oe),v(Ke),v(et),v(tt),v(nt),v(ot),v(it,e),v(st),v(at),v(Ce),v(rt,e),v(lt),v(dt),v(ft),v(ct),v(pt),v(ut),v(mt,e)}}}const Ks='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2},{"title":"Callbacks","local":"diffusers.callbacks.PipelineCallback","sections":[],"depth":2}],"depth":1}';function ea(C){return Is(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class la extends Js{constructor(o){super(),Gs(this,o,ea,Os,js,{})}}export{la as component};
