import{s as co,o as po,n as rt}from"../chunks/scheduler.182ea377.js";import{S as fo,i as uo,g as s,s as n,r as g,A as mo,h as a,f as l,c as o,j as S,u as h,x as d,k as D,y as t,a as m,v as _,d as b,t as x,w as P}from"../chunks/index.abf12888.js";import{T as go}from"../chunks/Tip.230e2334.js";import{D as $}from"../chunks/Docstring.93f6f462.js";import{C as It}from"../chunks/CodeBlock.57fe6e13.js";import{E as yt}from"../chunks/ExampleCodeBlock.658f5cd6.js";import{H as In}from"../chunks/Heading.16916d63.js";function ho(j){let r,T='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){r=s("p"),r.innerHTML=T},l(f){r=a(f,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1wmc0l4"&&(r.innerHTML=T)},m(f,c){m(f,r,c)},p:rt,d(f){f&&l(r)}}}function _o(j){let r,T="Examples:",f,c,v;return c=new It({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uSW5zdHJ1Y3RQaXgyUGl4UGlwZWxpbmUlMEElMEElMEFkZWYlMjBkb3dubG9hZF9pbWFnZSh1cmwpJTNBJTBBJTIwJTIwJTIwJTIwcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5nZXQodXJsKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMFBJTC5JbWFnZS5vcGVuKEJ5dGVzSU8ocmVzcG9uc2UuY29udGVudCkpLmNvbnZlcnQoJTIyUkdCJTIyKSUwQSUwQSUwQWltZ191cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSUwQWltYWdlJTIwJTNEJTIwZG93bmxvYWRfaW1hZ2UoaW1nX3VybCkucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIydGltYnJvb2tzJTJGaW5zdHJ1Y3QtcGl4MnBpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMm1ha2UlMjB0aGUlMjBtb3VudGFpbnMlMjBzbm93eSUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> PIL
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">download_image</span>(<span class="hljs-params">url</span>):
<span class="hljs-meta">... </span>    response = requests.get(url)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> PIL.Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>img_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image = download_image(img_url).resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;timbrooks/instruct-pix2pix&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;make the mountains snowy&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt=prompt, image=image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=n(),g(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=T),f=o(i),h(c.$$.fragment,i)},m(i,M){m(i,r,M),m(i,f,M),_(c,i,M),v=!0},p:rt,i(i){v||(b(c.$$.fragment,i),v=!0)},o(i){x(c.$$.fragment,i),v=!1},d(i){i&&(l(r),l(f)),P(c,i)}}}function bo(j){let r,T="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",f,c,v;return c=new It({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMCUzQ2NhdC10b3klM0UlMjBiYWNrcGFjayUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNhdC1iYWNrcGFjay5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=n(),g(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-1gc783q"&&(r.textContent=T),f=o(i),h(c.$$.fragment,i)},m(i,M){m(i,r,M),m(i,f,M),_(c,i,M),v=!0},p:rt,i(i){v||(b(c.$$.fragment,i),v=!0)},o(i){x(c.$$.fragment,i),v=!1},d(i){i&&(l(r),l(f)),P(c,i)}}}function xo(j){let r,T="locally:",f,c,v;return c=new It({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNikudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyLiUyRmNoYXJ0dXJuZXJ2Mi5wdCUyMiUyQyUyMHRva2VuJTNEJTIyY2hhcnR1cm5lcnYyJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMG9mJTIwYSUyMHdvbWFuJTIwd2VhcmluZyUyMGElMjBibGFjayUyMGphY2tldCUyMGFuZCUyMHJlZCUyMHNoaXJ0JTJDJTIwYmVzdCUyMHF1YWxpdHklMkMlMjBpbnRyaWNhdGUlMjBkZXRhaWxzLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmNoYXJhY3Rlci5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=n(),g(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-4c75kq"&&(r.textContent=T),f=o(i),h(c.$$.fragment,i)},m(i,M){m(i,r,M),m(i,f,M),_(c,i,M),v=!0},p:rt,i(i){v||(b(c.$$.fragment,i),v=!0)},o(i){x(c.$$.fragment,i),v=!1},d(i){i&&(l(r),l(f)),P(c,i)}}}function Po(j){let r,T="Examples:",f,c,v;return c=new It({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uWExJbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcmVzb2x1dGlvbiUyMCUzRCUyMDc2OCUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmhmLmNvJTJGZGF0YXNldHMlMkZkaWZmdXNlcnMlMkZkaWZmdXNlcnMtaW1hZ2VzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRm1vdW50YWluLnBuZyUyMiUwQSkucmVzaXplKChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBZWRpdF9pbnN0cnVjdGlvbiUyMCUzRCUyMCUyMlR1cm4lMjBza3klMjBpbnRvJTIwYSUyMGNsb3VkeSUyMG9uZSUyMiUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTEluc3RydWN0UGl4MlBpeFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZzZHhsLWluc3RydWN0cGl4MnBpeC03NjglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBZWRpdGVkX2ltYWdlJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0RlZGl0X2luc3RydWN0aW9uJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGhlaWdodCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjB3aWR0aCUzRHJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBndWlkYW5jZV9zY2FsZSUzRDMuMCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlX2d1aWRhbmNlX3NjYWxlJTNEMS41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDMwJTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBZWRpdGVkX2ltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLInstructPix2PixPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>resolution = <span class="hljs-number">768</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://hf.co/datasets/diffusers/diffusers-images-docs/resolve/main/mountain.png&quot;</span>
<span class="hljs-meta">... </span>).resize((resolution, resolution))
<span class="hljs-meta">&gt;&gt;&gt; </span>edit_instruction = <span class="hljs-string">&quot;Turn sky into a cloudy one&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionXLInstructPix2PixPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;diffusers/sdxl-instructpix2pix-768&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image = pipe(
<span class="hljs-meta">... </span>    prompt=edit_instruction,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>    height=resolution,
<span class="hljs-meta">... </span>    width=resolution,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">3.0</span>,
<span class="hljs-meta">... </span>    image_guidance_scale=<span class="hljs-number">1.5</span>,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>edited_image`,wrap:!1}}),{c(){r=s("p"),r.textContent=T,f=n(),g(c.$$.fragment)},l(i){r=a(i,"P",{"data-svelte-h":!0}),d(r)!=="svelte-kvfsh7"&&(r.textContent=T),f=o(i),h(c.$$.fragment,i)},m(i,M){m(i,r,M),m(i,f,M),_(c,i,M),v=!0},p:rt,i(i){v||(b(c.$$.fragment,i),v=!0)},o(i){x(c.$$.fragment,i),v=!1},d(i){i&&(l(r),l(f)),P(c,i)}}}function vo(j){let r,T,f,c,v,i,M,Mn='<a href="https://huggingface.co/papers/2211.09800" rel="nofollow">InstructPix2Pix: Learning to Follow Image Editing Instructions</a> is by Tim Brooks, Aleksander Holynski and Alexei A. Efros.',lt,te,Tn="The abstract from the paper is:",dt,ne,Sn="<em>We propose a method for editing images from human instructions: given an input image and a written instruction that tells the model what to do, our model follows these instructions to edit the image. To obtain training data for this problem, we combine the knowledge of two large pretrained models — a language model (GPT-3) and a text-to-image model (Stable Diffusion) — to generate a large dataset of image editing examples. Our conditional diffusion model, InstructPix2Pix, is trained on our generated data, and generalizes to real images and user-written instructions at inference time. Since it performs edits in the forward pass and does not require per example fine-tuning or inversion, our model edits images quickly, in a matter of seconds. We show compelling editing results for a diverse collection of input images and written instructions.</em>",ct,oe,Dn='You can find additional information about InstructPix2Pix on the <a href="https://www.timothybrooks.com/instruct-pix2pix" rel="nofollow">project page</a>, <a href="https://github.com/timothybrooks/instruct-pix2pix" rel="nofollow">original codebase</a>, and try it out in a <a href="https://huggingface.co/spaces/timbrooks/instruct-pix2pix" rel="nofollow">demo</a>.',pt,B,ft,ie,ut,w,se,Mt,ye,Ln="Pipeline for pixel-level image editing by following text instructions (based on Stable Diffusion).",Tt,Ie,kn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,St,Me,$n="The pipeline also inherits the following loading methods:",Dt,Te,Cn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',Lt,N,ae,kt,Se,Un="The call function to the pipeline for generation.",$t,E,Ct,L,re,Ut,De,jn=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,jt,Le,Jn="Example:",Jt,F,Xt,ke,Xn=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Nt,H,Wt,k,le,Zt,$e,Nn=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,zt,Ce,Wn="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Gt,Ue,Zn='See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is loaded.',Bt,je,zn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is loaded into
<code>self.unet</code>.`,Et,Je,Gn=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state dict is loaded
into <code>self.text_encoder</code>.`,Ft,R,de,Ht,Xe,Bn="Save the LoRA parameters corresponding to the UNet and text encoder.",Rt,A,ce,At,Ne,En="Disables the FreeU mechanism if enabled.",qt,J,pe,Vt,We,Fn='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',Yt,Ze,Hn="The suffixes after the scaling factors represent the stages where they are being applied.",Qt,ze,Rn=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,mt,fe,gt,u,ue,Ot,Ge,An="Pipeline for pixel-level image editing by following text instructions. Based on Stable Diffusion XL.",Kt,Be,qn=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods the
library implements for all the pipelines (such as downloading or saving, running on a particular device, etc.)`,en,Ee,Vn="The pipeline also inherits the following loading methods:",tn,Fe,Yn='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionXLLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><code>save_lora_weights()</code> for saving LoRA weights</li>',nn,W,me,on,He,Qn="Function invoked when calling the pipeline for generation.",sn,q,an,V,ge,rn,Re,On="Disables the FreeU mechanism if enabled.",ln,Y,he,dn,Ae,Kn=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously invoked, this method will go back to
computing decoding in one step.`,cn,Q,_e,pn,qe,eo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously invoked, this method will go back to
computing decoding in one step.`,fn,X,be,un,Ve,to='Enables the FreeU mechanism as in <a href="https://arxiv.org/abs/2309.11497" rel="nofollow">https://arxiv.org/abs/2309.11497</a>.',mn,Ye,no="The suffixes after the scaling factors represent the stages where they are being applied.",gn,Qe,oo=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,hn,Z,xe,_n,Oe,io="Enable sliced VAE decoding.",bn,Ke,so=`When this option is enabled, the VAE will split the input tensor in slices to compute decoding in several
steps. This is useful to save some memory and allow larger batch sizes.`,xn,z,Pe,Pn,et,ao="Enable tiled VAE decoding.",vn,tt,ro=`When this option is enabled, the VAE will split the input tensor into tiles to compute decoding and encoding in
several steps. This is useful to save a large amount of memory and to allow the processing of larger images.`,wn,O,ve,yn,nt,lo="Encodes the prompt into text encoder hidden states.",ht,at,_t;return v=new In({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),B=new go({props:{$$slots:{default:[ho]},$$scope:{ctx:j}}}),ie=new In({props:{title:"StableDiffusionInstructPix2PixPipeline",local:"diffusers.StableDiffusionInstructPix2PixPipeline",headingTag:"h2"}}),se=new $({props:{name:"class diffusers.StableDiffusionInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": Optional = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">model card</a> for more details
about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L75"}}),ae=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"image",val:": Union = None"},{name:"num_inference_steps",val:": int = 100"},{name:"guidance_scale",val:": float = 7.5"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"ip_adapter_image",val:": Union = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback_on_step_end",val:": Optional = None"},{name:"callback_on_step_end_tensor_inputs",val:": List = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> <code>np.ndarray</code>, <code>PIL.Image.Image</code>, <code>List[torch.FloatTensor]</code>, <code>List[PIL.Image.Image]</code>, or <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code> or tensor representing an image batch to be repainted according to <code>prompt</code>. Can also accept
image latents as <code>image</code>, but if passing latents directly it is not encoded again.`,name:"image"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Push the generated image towards the inital <code>image</code>. Image guidance scale is enabled by setting
<code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages generated images that are closely
linked to the source <code>image</code>, usually at the expense of lower image quality. This pipeline requires a
value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.
ip_adapter_image &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>):
Optional image input to work with IP Adapters.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L159",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/upscale#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),E=new yt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.__call__.example",$$slots:{default:[_o]},$$scope:{ctx:j}}}),re=new $({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"token",val:": Union = None"},{name:"tokenizer",val:": Optional = None"},{name:"text_encoder",val:": Optional = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to resume downloading the model weights and configuration files. If set to <code>False</code>, any
incompletely downloaded files are deleted.`,name:"resume_download"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L265"}}),F=new yt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example",$$slots:{default:[bo]},$$scope:{ctx:j}}}),H=new yt({props:{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_textual_inversion.example-2",$$slots:{default:[xo]},$$scope:{ctx:j}}}),le=new $({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": Union"},{name:"adapter_name",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.kwargs",description:`<strong>kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.LoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"kwargs"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L80"}}),de=new $({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": Union"},{name:"unet_lora_layers",val:": Dict = None"},{name:"text_encoder_lora_layers",val:": Dict = None"},{name:"transformer_lora_layers",val:": Dict = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": Callable = None"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora.py#L703"}}),ce=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L834"}}),pe=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion_instruct_pix2pix.py#L811"}}),fe=new In({props:{title:"StableDiffusionXLInstructPix2PixPipeline",local:"diffusers.StableDiffusionXLInstructPix2PixPipeline",headingTag:"h2"}}),ue=new $({props:{name:"class diffusers.StableDiffusionXLInstructPix2PixPipeline",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion XL uses the text portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIP</a>, specifically
the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code> CLIPTextModelWithProjection</code>) &#x2014;
Second frozen text-encoder. Stable Diffusion XL uses the text and pool portion of
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.unet",description:'<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014; Conditional U-Net architecture to denoise the encoded image latents.',name:"unet"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.requires_aesthetics_score",description:`<strong>requires_aesthetics_score</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;False&quot;</code>) &#x2014;
Whether the <code>unet</code> requires a aesthetic_score condition to be passed during inference. Also see the config
of <code>stabilityai/stable-diffusion-xl-refiner-1-0</code>.`,name:"requires_aesthetics_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.force_zeros_for_empty_prompt",description:`<strong>force_zeros_for_empty_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>&quot;True&quot;</code>) &#x2014;
Whether the negative prompt embeddings shall be forced to always be set to 0. Also see the config of
<code>stabilityai/stable-diffusion-xl-base-1-0</code>.`,name:"force_zeros_for_empty_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.add_watermarker",description:`<strong>add_watermarker</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to use the <a href="https://github.com/ShieldMnt/invisible-watermark/" rel="nofollow">invisible_watermark library</a> to
watermark output images. If not defined, it will default to True if the package is installed, otherwise no
watermarker will be used.`,name:"add_watermarker"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L120"}}),me=new $({props:{name:"__call__",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"prompt_2",val:": Union = None"},{name:"image",val:": Union = None"},{name:"height",val:": Optional = None"},{name:"width",val:": Optional = None"},{name:"num_inference_steps",val:": int = 100"},{name:"denoising_end",val:": Optional = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"image_guidance_scale",val:": float = 1.5"},{name:"negative_prompt",val:": Union = None"},{name:"negative_prompt_2",val:": Union = None"},{name:"num_images_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"output_type",val:": Optional = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": int = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"original_size",val:": Tuple = None"},{name:"crops_coords_top_left",val:": Tuple = (0, 0)"},{name:"target_size",val:": Tuple = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image",description:`<strong>image</strong> (<code>torch.FloatTensor</code> or <code>PIL.Image.Image</code> or <code>np.ndarray</code> or <code>List[torch.FloatTensor]</code> or <code>List[PIL.Image.Image]</code> or <code>List[np.ndarray]</code>) &#x2014;
The image(s) to modify with the pipeline.`,name:"image"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float</code>, <em>optional</em>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://arxiv.org/abs/2207.12598" rel="nofollow">Classifier-Free Diffusion Guidance</a>.
<code>guidance_scale</code> is defined as <code>w</code> of equation 2. of <a href="https://arxiv.org/pdf/2205.11487.pdf" rel="nofollow">Imagen
Paper</a>. Guidance scale is enabled by setting <code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to the text <code>prompt</code>,
usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.image_guidance_scale",description:`<strong>image_guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.5) &#x2014;
Image guidance scale is to push the generated image towards the inital image <code>image</code>. Image guidance
scale is enabled by setting <code>image_guidance_scale &gt; 1</code>. Higher image guidance scale encourages to
generate images that are closely linked to the source image <code>image</code>, usually at the expense of lower
image quality. This pipeline requires a value of at least <code>1</code>.`,name:"image_guidance_scale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) in the DDIM paper: <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">https://arxiv.org/abs/2010.02502</a>. Only applies to
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">schedulers.DDIMScheduler</a>, will be ignored for others.`,name:"eta"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionXLPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that will be called every <code>callback_steps</code> steps during inference. The function will be
called with the following arguments: <code>callback(step: int, timestep: int, latents: torch.FloatTensor)</code>.`,name:"callback"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function will be called. If not specified, the callback will be
called at every step.`,name:"callback_steps"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor proposed by <a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a> <code>guidance_scale</code> is defined as <code>&#x3C6;</code> in equation 16. of
<a href="https://arxiv.org/pdf/2305.08891.pdf" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are Flawed</a>.
Guidance rescale factor should fix overexposure when using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code> the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to (1024, 1024)) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.aesthetic_score",description:`<strong>aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 6.0) &#x2014;
Used to simulate an aesthetic score of the generated image by influencing the positive text condition.
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"aesthetic_score"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.negative_aesthetic_score",description:`<strong>negative_aesthetic_score</strong> (<code>float</code>, <em>optional</em>, defaults to 2.5) &#x2014;
Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. Can be used to
simulate an aesthetic score of the generated image by influencing the negative text condition.`,name:"negative_aesthetic_score"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L652",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),q=new yt({props:{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.__call__.example",$$slots:{default:[Po]},$$scope:{ctx:j}}}),ge=new $({props:{name:"disable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L648"}}),he=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L217"}}),_e=new $({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L233"}}),be=new $({props:{name:"enable_freeu",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L625"}}),xe=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L208"}}),Pe=new $({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L224"}}),ve=new $({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt",parameters:[{name:"prompt",val:": str"},{name:"prompt_2",val:": Optional = None"},{name:"device",val:": Optional = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": Optional = None"},{name:"negative_prompt_2",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"pooled_prompt_embeds",val:": Optional = None"},{name:"negative_pooled_prompt_embeds",val:": Optional = None"},{name:"lora_scale",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders
device &#x2014; (<code>torch.device</code>):
torch device`,name:"prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusionXLInstructPix2PixPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_xl/pipeline_stable_diffusion_xl_instruct_pix2pix.py#L240"}}),{c(){r=s("meta"),T=n(),f=s("p"),c=n(),g(v.$$.fragment),i=n(),M=s("p"),M.innerHTML=Mn,lt=n(),te=s("p"),te.textContent=Tn,dt=n(),ne=s("p"),ne.innerHTML=Sn,ct=n(),oe=s("p"),oe.innerHTML=Dn,pt=n(),g(B.$$.fragment),ft=n(),g(ie.$$.fragment),ut=n(),w=s("div"),g(se.$$.fragment),Mt=n(),ye=s("p"),ye.textContent=Ln,Tt=n(),Ie=s("p"),Ie.innerHTML=kn,St=n(),Me=s("p"),Me.textContent=$n,Dt=n(),Te=s("ul"),Te.innerHTML=Cn,Lt=n(),N=s("div"),g(ae.$$.fragment),kt=n(),Se=s("p"),Se.textContent=Un,$t=n(),g(E.$$.fragment),Ct=n(),L=s("div"),g(re.$$.fragment),Ut=n(),De=s("p"),De.innerHTML=jn,jt=n(),Le=s("p"),Le.textContent=Jn,Jt=n(),g(F.$$.fragment),Xt=n(),ke=s("p"),ke.innerHTML=Xn,Nt=n(),g(H.$$.fragment),Wt=n(),k=s("div"),g(le.$$.fragment),Zt=n(),$e=s("p"),$e.innerHTML=Nn,zt=n(),Ce=s("p"),Ce.innerHTML=Wn,Gt=n(),Ue=s("p"),Ue.innerHTML=Zn,Bt=n(),je=s("p"),je.innerHTML=zn,Et=n(),Je=s("p"),Je.innerHTML=Gn,Ft=n(),R=s("div"),g(de.$$.fragment),Ht=n(),Xe=s("p"),Xe.textContent=Bn,Rt=n(),A=s("div"),g(ce.$$.fragment),At=n(),Ne=s("p"),Ne.textContent=En,qt=n(),J=s("div"),g(pe.$$.fragment),Vt=n(),We=s("p"),We.innerHTML=Fn,Yt=n(),Ze=s("p"),Ze.textContent=Hn,Qt=n(),ze=s("p"),ze.innerHTML=Rn,mt=n(),g(fe.$$.fragment),gt=n(),u=s("div"),g(ue.$$.fragment),Ot=n(),Ge=s("p"),Ge.textContent=An,Kt=n(),Be=s("p"),Be.innerHTML=qn,en=n(),Ee=s("p"),Ee.textContent=Vn,tn=n(),Fe=s("ul"),Fe.innerHTML=Yn,nn=n(),W=s("div"),g(me.$$.fragment),on=n(),He=s("p"),He.textContent=Qn,sn=n(),g(q.$$.fragment),an=n(),V=s("div"),g(ge.$$.fragment),rn=n(),Re=s("p"),Re.textContent=On,ln=n(),Y=s("div"),g(he.$$.fragment),dn=n(),Ae=s("p"),Ae.innerHTML=Kn,cn=n(),Q=s("div"),g(_e.$$.fragment),pn=n(),qe=s("p"),qe.innerHTML=eo,fn=n(),X=s("div"),g(be.$$.fragment),un=n(),Ve=s("p"),Ve.innerHTML=to,mn=n(),Ye=s("p"),Ye.textContent=no,gn=n(),Qe=s("p"),Qe.innerHTML=oo,hn=n(),Z=s("div"),g(xe.$$.fragment),_n=n(),Oe=s("p"),Oe.textContent=io,bn=n(),Ke=s("p"),Ke.textContent=so,xn=n(),z=s("div"),g(Pe.$$.fragment),Pn=n(),et=s("p"),et.textContent=ao,vn=n(),tt=s("p"),tt.textContent=ro,wn=n(),O=s("div"),g(ve.$$.fragment),yn=n(),nt=s("p"),nt.textContent=lo,ht=n(),at=s("p"),this.h()},l(e){const p=mo("svelte-u9bgzb",document.head);r=a(p,"META",{name:!0,content:!0}),p.forEach(l),T=o(e),f=a(e,"P",{}),S(f).forEach(l),c=o(e),h(v.$$.fragment,e),i=o(e),M=a(e,"P",{"data-svelte-h":!0}),d(M)!=="svelte-1tl4gnd"&&(M.innerHTML=Mn),lt=o(e),te=a(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-1cwsb16"&&(te.textContent=Tn),dt=o(e),ne=a(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1gbgk0u"&&(ne.innerHTML=Sn),ct=o(e),oe=a(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-18wh1q7"&&(oe.innerHTML=Dn),pt=o(e),h(B.$$.fragment,e),ft=o(e),h(ie.$$.fragment,e),ut=o(e),w=a(e,"DIV",{class:!0});var I=S(w);h(se.$$.fragment,I),Mt=o(I),ye=a(I,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1gz00nq"&&(ye.textContent=Ln),Tt=o(I),Ie=a(I,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-496sm0"&&(Ie.innerHTML=kn),St=o(I),Me=a(I,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-14s6m4u"&&(Me.textContent=$n),Dt=o(I),Te=a(I,"UL",{"data-svelte-h":!0}),d(Te)!=="svelte-jjuyoc"&&(Te.innerHTML=Cn),Lt=o(I),N=a(I,"DIV",{class:!0});var G=S(N);h(ae.$$.fragment,G),kt=o(G),Se=a(G,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-50j04k"&&(Se.textContent=Un),$t=o(G),h(E.$$.fragment,G),G.forEach(l),Ct=o(I),L=a(I,"DIV",{class:!0});var C=S(L);h(re.$$.fragment,C),Ut=o(C),De=a(C,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1lv88wo"&&(De.innerHTML=jn),jt=o(C),Le=a(C,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-11lpom8"&&(Le.textContent=Jn),Jt=o(C),h(F.$$.fragment,C),Xt=o(C),ke=a(C,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-15d7mv5"&&(ke.innerHTML=Xn),Nt=o(C),h(H.$$.fragment,C),C.forEach(l),Wt=o(I),k=a(I,"DIV",{class:!0});var U=S(k);h(le.$$.fragment,U),Zt=o(U),$e=a(U,"P",{"data-svelte-h":!0}),d($e)!=="svelte-vs7s0z"&&($e.innerHTML=Nn),zt=o(U),Ce=a(U,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-15b960v"&&(Ce.innerHTML=Wn),Gt=o(U),Ue=a(U,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-12uyc98"&&(Ue.innerHTML=Zn),Bt=o(U),je=a(U,"P",{"data-svelte-h":!0}),d(je)!=="svelte-1q3yzk7"&&(je.innerHTML=zn),Et=o(U),Je=a(U,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-10xxjud"&&(Je.innerHTML=Gn),U.forEach(l),Ft=o(I),R=a(I,"DIV",{class:!0});var we=S(R);h(de.$$.fragment,we),Ht=o(we),Xe=a(we,"P",{"data-svelte-h":!0}),d(Xe)!=="svelte-1ufq5ot"&&(Xe.textContent=Bn),we.forEach(l),Rt=o(I),A=a(I,"DIV",{class:!0});var bt=S(A);h(ce.$$.fragment,bt),At=o(bt),Ne=a(bt,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-psupw6"&&(Ne.textContent=En),bt.forEach(l),qt=o(I),J=a(I,"DIV",{class:!0});var K=S(J);h(pe.$$.fragment,K),Vt=o(K),We=a(K,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1f3tmq1"&&(We.innerHTML=Fn),Yt=o(K),Ze=a(K,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-xjijlp"&&(Ze.textContent=Hn),Qt=o(K),ze=a(K,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-hy0nzs"&&(ze.innerHTML=Rn),K.forEach(l),I.forEach(l),mt=o(e),h(fe.$$.fragment,e),gt=o(e),u=a(e,"DIV",{class:!0});var y=S(u);h(ue.$$.fragment,y),Ot=o(y),Ge=a(y,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1n3req3"&&(Ge.textContent=An),Kt=o(y),Be=a(y,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-wu1jmh"&&(Be.innerHTML=qn),en=o(y),Ee=a(y,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-14s6m4u"&&(Ee.textContent=Vn),tn=o(y),Fe=a(y,"UL",{"data-svelte-h":!0}),d(Fe)!=="svelte-14stkna"&&(Fe.innerHTML=Yn),nn=o(y),W=a(y,"DIV",{class:!0});var ot=S(W);h(me.$$.fragment,ot),on=o(ot),He=a(ot,"P",{"data-svelte-h":!0}),d(He)!=="svelte-v78lg8"&&(He.textContent=Qn),sn=o(ot),h(q.$$.fragment,ot),ot.forEach(l),an=o(y),V=a(y,"DIV",{class:!0});var xt=S(V);h(ge.$$.fragment,xt),rn=o(xt),Re=a(xt,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-psupw6"&&(Re.textContent=On),xt.forEach(l),ln=o(y),Y=a(y,"DIV",{class:!0});var Pt=S(Y);h(he.$$.fragment,Pt),dn=o(Pt),Ae=a(Pt,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-1lk12qh"&&(Ae.innerHTML=Kn),Pt.forEach(l),cn=o(y),Q=a(y,"DIV",{class:!0});var vt=S(Q);h(_e.$$.fragment,vt),pn=o(vt),qe=a(vt,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-elsxjh"&&(qe.innerHTML=eo),vt.forEach(l),fn=o(y),X=a(y,"DIV",{class:!0});var ee=S(X);h(be.$$.fragment,ee),un=o(ee),Ve=a(ee,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-1f3tmq1"&&(Ve.innerHTML=to),mn=o(ee),Ye=a(ee,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-xjijlp"&&(Ye.textContent=no),gn=o(ee),Qe=a(ee,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-hy0nzs"&&(Qe.innerHTML=oo),ee.forEach(l),hn=o(y),Z=a(y,"DIV",{class:!0});var it=S(Z);h(xe.$$.fragment,it),_n=o(it),Oe=a(it,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-ssd5ny"&&(Oe.textContent=io),bn=o(it),Ke=a(it,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-62zig4"&&(Ke.textContent=so),it.forEach(l),xn=o(y),z=a(y,"DIV",{class:!0});var st=S(z);h(Pe.$$.fragment,st),Pn=o(st),et=a(st,"P",{"data-svelte-h":!0}),d(et)!=="svelte-4j2l7q"&&(et.textContent=ao),vn=o(st),tt=a(st,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-1biw85q"&&(tt.textContent=ro),st.forEach(l),wn=o(y),O=a(y,"DIV",{class:!0});var wt=S(O);h(ve.$$.fragment,wt),yn=o(wt),nt=a(wt,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-16q0ax1"&&(nt.textContent=lo),wt.forEach(l),y.forEach(l),ht=o(e),at=a(e,"P",{}),S(at).forEach(l),this.h()},h(){D(r,"name","hf:doc:metadata"),D(r,"content",wo),D(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){t(document.head,r),m(e,T,p),m(e,f,p),m(e,c,p),_(v,e,p),m(e,i,p),m(e,M,p),m(e,lt,p),m(e,te,p),m(e,dt,p),m(e,ne,p),m(e,ct,p),m(e,oe,p),m(e,pt,p),_(B,e,p),m(e,ft,p),_(ie,e,p),m(e,ut,p),m(e,w,p),_(se,w,null),t(w,Mt),t(w,ye),t(w,Tt),t(w,Ie),t(w,St),t(w,Me),t(w,Dt),t(w,Te),t(w,Lt),t(w,N),_(ae,N,null),t(N,kt),t(N,Se),t(N,$t),_(E,N,null),t(w,Ct),t(w,L),_(re,L,null),t(L,Ut),t(L,De),t(L,jt),t(L,Le),t(L,Jt),_(F,L,null),t(L,Xt),t(L,ke),t(L,Nt),_(H,L,null),t(w,Wt),t(w,k),_(le,k,null),t(k,Zt),t(k,$e),t(k,zt),t(k,Ce),t(k,Gt),t(k,Ue),t(k,Bt),t(k,je),t(k,Et),t(k,Je),t(w,Ft),t(w,R),_(de,R,null),t(R,Ht),t(R,Xe),t(w,Rt),t(w,A),_(ce,A,null),t(A,At),t(A,Ne),t(w,qt),t(w,J),_(pe,J,null),t(J,Vt),t(J,We),t(J,Yt),t(J,Ze),t(J,Qt),t(J,ze),m(e,mt,p),_(fe,e,p),m(e,gt,p),m(e,u,p),_(ue,u,null),t(u,Ot),t(u,Ge),t(u,Kt),t(u,Be),t(u,en),t(u,Ee),t(u,tn),t(u,Fe),t(u,nn),t(u,W),_(me,W,null),t(W,on),t(W,He),t(W,sn),_(q,W,null),t(u,an),t(u,V),_(ge,V,null),t(V,rn),t(V,Re),t(u,ln),t(u,Y),_(he,Y,null),t(Y,dn),t(Y,Ae),t(u,cn),t(u,Q),_(_e,Q,null),t(Q,pn),t(Q,qe),t(u,fn),t(u,X),_(be,X,null),t(X,un),t(X,Ve),t(X,mn),t(X,Ye),t(X,gn),t(X,Qe),t(u,hn),t(u,Z),_(xe,Z,null),t(Z,_n),t(Z,Oe),t(Z,bn),t(Z,Ke),t(u,xn),t(u,z),_(Pe,z,null),t(z,Pn),t(z,et),t(z,vn),t(z,tt),t(u,wn),t(u,O),_(ve,O,null),t(O,yn),t(O,nt),m(e,ht,p),m(e,at,p),_t=!0},p(e,[p]){const I={};p&2&&(I.$$scope={dirty:p,ctx:e}),B.$set(I);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),E.$set(G);const C={};p&2&&(C.$$scope={dirty:p,ctx:e}),F.$set(C);const U={};p&2&&(U.$$scope={dirty:p,ctx:e}),H.$set(U);const we={};p&2&&(we.$$scope={dirty:p,ctx:e}),q.$set(we)},i(e){_t||(b(v.$$.fragment,e),b(B.$$.fragment,e),b(ie.$$.fragment,e),b(se.$$.fragment,e),b(ae.$$.fragment,e),b(E.$$.fragment,e),b(re.$$.fragment,e),b(F.$$.fragment,e),b(H.$$.fragment,e),b(le.$$.fragment,e),b(de.$$.fragment,e),b(ce.$$.fragment,e),b(pe.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(me.$$.fragment,e),b(q.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(_e.$$.fragment,e),b(be.$$.fragment,e),b(xe.$$.fragment,e),b(Pe.$$.fragment,e),b(ve.$$.fragment,e),_t=!0)},o(e){x(v.$$.fragment,e),x(B.$$.fragment,e),x(ie.$$.fragment,e),x(se.$$.fragment,e),x(ae.$$.fragment,e),x(E.$$.fragment,e),x(re.$$.fragment,e),x(F.$$.fragment,e),x(H.$$.fragment,e),x(le.$$.fragment,e),x(de.$$.fragment,e),x(ce.$$.fragment,e),x(pe.$$.fragment,e),x(fe.$$.fragment,e),x(ue.$$.fragment,e),x(me.$$.fragment,e),x(q.$$.fragment,e),x(ge.$$.fragment,e),x(he.$$.fragment,e),x(_e.$$.fragment,e),x(be.$$.fragment,e),x(xe.$$.fragment,e),x(Pe.$$.fragment,e),x(ve.$$.fragment,e),_t=!1},d(e){e&&(l(T),l(f),l(c),l(i),l(M),l(lt),l(te),l(dt),l(ne),l(ct),l(oe),l(pt),l(ft),l(ut),l(w),l(mt),l(gt),l(u),l(ht),l(at)),l(r),P(v,e),P(B,e),P(ie,e),P(se),P(ae),P(E),P(re),P(F),P(H),P(le),P(de),P(ce),P(pe),P(fe,e),P(ue),P(me),P(q),P(ge),P(he),P(_e),P(be),P(xe),P(Pe),P(ve)}}}const wo='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"StableDiffusionInstructPix2PixPipeline","local":"diffusers.StableDiffusionInstructPix2PixPipeline","sections":[],"depth":2},{"title":"StableDiffusionXLInstructPix2PixPipeline","local":"diffusers.StableDiffusionXLInstructPix2PixPipeline","sections":[],"depth":2}],"depth":1}';function yo(j){return po(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $o extends fo{constructor(r){super(),uo(this,r,yo,vo,co,{})}}export{$o as component};
