import{s as Re,n as Ee,o as He}from"../chunks/scheduler.f6319a2a.js";import{S as Ye,i as Se,g as p,s as n,r as i,A as xe,h as o,f as t,c as a,j as Ne,u as M,x as m,k as ze,y as Fe,a as l,v as c,d as y,t as r,w as b}from"../chunks/index.85aa684c.js";import{C as H}from"../chunks/CodeBlock.97b48fd2.js";import{D as Le}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as Ue,E as De}from"../chunks/EditOnGithub.006048dd.js";function Pe(ge){let w,x,Y,F,J,L,u,D,j,fe=`In the end, an agent can be defined by simple components: it has tools, prompts.
And most importantly, it has a memory of past steps, drawing a history of planning, execution, and errors.`,P,h,q,d,Be="We propose several features to inspect a past agent run.",K,T,Ie='You can instrument the agent’s run to display it in a great UI that lets you zoom in/out on specific steps, as highlighted in the <a href="./inspect_runs">instrumentation guide</a>.',O,U,Ze="You can also use <code>agent.replay()</code>, as follows:",ee,g,Ce="After the agent has run:",se,f,te,B,ve="If you want to replay this last run, just use:",le,I,ne,Z,ae,C,We="Many advanced use cases require dynamic modification of the agent’s memory.",pe,v,_e="You can access the agent’s memory using:",oe,W,me,_,ke="Use <code>agent.memory.get_full_steps()</code> to get full steps as dictionaries.",ie,k,Xe="You can also use step callbacks to dynamically change the agent’s memory.",Me,X,Ve="Step callbacks can access the <code>agent</code> itself in their arguments, so they can access any memory step as highlighted above, and change it if needed. For instance, let’s say you are observing screenshots of each step performed by a web browser agent. You want to log the newest screenshot, and remove the images from ancient steps to save on token costs.",ce,V,Qe=`You culd run something like the following.
<em>Note: this code is incomplete, some imports and object definitions have been removed for the sake of concision, visit <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">the original script</a> to get the full working code.</em>`,ye,Q,re,A,Ae="Then you should pass this function in the <code>step_callbacks</code> argument upon initialization of your agent:",be,G,we,$,Ge='Head to our <a href="https://github.com/huggingface/smolagents/blob/main/src/smolagents/vision_web_browser.py" rel="nofollow">vision web browser code</a> to see the full working example.',Je,N,ue,z,$e=`This can be useful in case you have tool calls that take days: you can just run your agents step by step.
This will also let you update the memory on each step.`,je,R,he,E,de,S,Te;return J=new Ue({props:{title:"📚 Manage your agent’s memory",local:"-manage-your-agents-memory",headingTag:"h1"}}),u=new Le({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/memory.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/memory.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/memory.ipynb"}]}}),h=new Ue({props:{title:"Replay your agent’s memory",local:"replay-your-agents-memory",headingTag:"h3"}}),f=new H({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDApJTBBJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUyMldoYXQncyUyMHRoZSUyMDIwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(tools=[], model=HfApiModel(), verbosity_level=<span class="hljs-number">0</span>)

result = agent.run(<span class="hljs-string">&quot;What&#x27;s the 20th Fibonacci number?&quot;</span>)`,wrap:!1}}),I=new H({props:{code:"YWdlbnQucmVwbGF5KCk=",highlighted:"agent.replay()",wrap:!1}}),Z=new Ue({props:{title:"Dynamically change the agent’s memory",local:"dynamically-change-the-agents-memory",headingTag:"h3"}}),W=new H({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBBY3Rpb25TdGVwJTBBJTBBc3lzdGVtX3Byb21wdF9zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN5c3RlbV9wcm9tcHQlMEFwcmludCglMjJUaGUlMjBzeXN0ZW0lMjBwcm9tcHQlMjBnaXZlbiUyMHRvJTIwdGhlJTIwYWdlbnQlMjB3YXMlM0ElMjIpJTBBcHJpbnQoc3lzdGVtX3Byb21wdF9zdGVwLnN5c3RlbV9wcm9tcHQpJTBBJTBBdGFza19zdGVwJTIwJTNEJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTVCMCU1RCUwQXByaW50KCUyMiU1Q24lNUNuVGhlJTIwZmlyc3QlMjB0YXNrJTIwc3RlcCUyMHdhcyUzQSUyMiklMEFwcmludCh0YXNrX3N0ZXAudGFzayklMEElMEFmb3IlMjBzdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMEElMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2Uoc3RlcCUyQyUyMEFjdGlvblN0ZXApJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzdGVwLmVycm9yJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoaXMlMjBlcnJvciUzQSU1Q24lN0JzdGVwLmVycm9yJTdEJTVDbiUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbHNlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU1Q25TdGVwJTIwJTdCc3RlcC5zdGVwX251bWJlciU3RCUyMGdvdCUyMHRoZXNlJTIwb2JzZXJ2YXRpb25zJTNBJTVDbiU3QnN0ZXAub2JzZXJ2YXRpb25zJTdEJTVDbiUyMik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> ActionStep

system_prompt_step = agent.memory.system_prompt
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The system prompt given to the agent was:&quot;</span>)
<span class="hljs-built_in">print</span>(system_prompt_step.system_prompt)

task_step = agent.memory.steps[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\n\\nThe first task step was:&quot;</span>)
<span class="hljs-built_in">print</span>(task_step.task)

<span class="hljs-keyword">for</span> step <span class="hljs-keyword">in</span> agent.memory.steps:
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(step, ActionStep):
        <span class="hljs-keyword">if</span> step.error <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got this error:\\n<span class="hljs-subst">{step.error}</span>\\n&quot;</span>)
        <span class="hljs-keyword">else</span>:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;\\nStep <span class="hljs-subst">{step.step_number}</span> got these observations:\\n<span class="hljs-subst">{step.observations}</span>\\n&quot;</span>)`,wrap:!1}}),Q=new H({props:{code:"aW1wb3J0JTIwaGVsaXVtJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGlvJTIwaW1wb3J0JTIwQnl0ZXNJTyUwQWZyb20lMjB0aW1lJTIwaW1wb3J0JTIwc2xlZXAlMEElMEFkZWYlMjB1cGRhdGVfc2NyZWVuc2hvdChtZW1vcnlfc3RlcCUzQSUyMEFjdGlvblN0ZXAlMkMlMjBhZ2VudCUzQSUyMENvZGVBZ2VudCklMjAtJTNFJTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMHNsZWVwKDEuMCklMjAlMjAlMjMlMjBMZXQlMjBKYXZhU2NyaXB0JTIwYW5pbWF0aW9ucyUyMGhhcHBlbiUyMGJlZm9yZSUyMHRha2luZyUyMHRoZSUyMHNjcmVlbnNob3QlMEElMjAlMjAlMjAlMjBkcml2ZXIlMjAlM0QlMjBoZWxpdW0uZ2V0X2RyaXZlcigpJTBBJTIwJTIwJTIwJTIwbGF0ZXN0X3N0ZXAlMjAlM0QlMjBtZW1vcnlfc3RlcC5zdGVwX251bWJlciUwQSUyMCUyMCUyMCUyMGZvciUyMHByZXZpb3VzX21lbW9yeV9zdGVwJTIwaW4lMjBhZ2VudC5tZW1vcnkuc3RlcHMlM0ElMjAlMjAlMjMlMjBSZW1vdmUlMjBwcmV2aW91cyUyMHNjcmVlbnNob3RzJTIwZnJvbSUyMGxvZ3MlMjBmb3IlMjBsZWFuJTIwcHJvY2Vzc2luZyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZShwcmV2aW91c19tZW1vcnlfc3RlcCUyQyUyMEFjdGlvblN0ZXApJTIwYW5kJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAuc3RlcF9udW1iZXIlMjAlM0MlM0QlMjBsYXRlc3Rfc3RlcCUyMC0lMjAyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJldmlvdXNfbWVtb3J5X3N0ZXAub2JzZXJ2YXRpb25zX2ltYWdlcyUyMCUzRCUyME5vbmUlMEElMjAlMjAlMjAlMjBwbmdfYnl0ZXMlMjAlM0QlMjBkcml2ZXIuZ2V0X3NjcmVlbnNob3RfYXNfcG5nKCklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4oQnl0ZXNJTyhwbmdfYnl0ZXMpKSUwQSUyMCUyMCUyMCUyMG1lbW9yeV9zdGVwLm9ic2VydmF0aW9uc19pbWFnZXMlMjAlM0QlMjAlNUJpbWFnZS5jb3B5KCklNUQ=",highlighted:`<span class="hljs-keyword">import</span> helium
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> time <span class="hljs-keyword">import</span> sleep

<span class="hljs-keyword">def</span> <span class="hljs-title function_">update_screenshot</span>(<span class="hljs-params">memory_step: ActionStep, agent: CodeAgent</span>) -&gt; <span class="hljs-literal">None</span>:
    sleep(<span class="hljs-number">1.0</span>)  <span class="hljs-comment"># Let JavaScript animations happen before taking the screenshot</span>
    driver = helium.get_driver()
    latest_step = memory_step.step_number
    <span class="hljs-keyword">for</span> previous_memory_step <span class="hljs-keyword">in</span> agent.memory.steps:  <span class="hljs-comment"># Remove previous screenshots from logs for lean processing</span>
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(previous_memory_step, ActionStep) <span class="hljs-keyword">and</span> previous_memory_step.step_number &lt;= latest_step - <span class="hljs-number">2</span>:
            previous_memory_step.observations_images = <span class="hljs-literal">None</span>
    png_bytes = driver.get_screenshot_as_png()
    image = Image.<span class="hljs-built_in">open</span>(BytesIO(png_bytes))
    memory_step.observations_images = [image.copy()]`,wrap:!1}}),G=new H({props:{code:"Q29kZUFnZW50KCUwQSUyMCUyMCUyMCUyMHRvb2xzJTNEJTVCRHVja0R1Y2tHb1NlYXJjaFRvb2woKSUyQyUyMGdvX2JhY2slMkMlMjBjbG9zZV9wb3B1cHMlMkMlMjBzZWFyY2hfaXRlbV9jdHJsX2YlNUQlMkMlMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlM0QlNUIlMjJoZWxpdW0lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzdGVwX2NhbGxiYWNrcyUzRCU1QnVwZGF0ZV9zY3JlZW5zaG90JTVEJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3N0ZXBzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjB2ZXJib3NpdHlfbGV2ZWwlM0QyJTJDJTBBKQ==",highlighted:`CodeAgent(
    tools=[DuckDuckGoSearchTool(), go_back, close_popups, search_item_ctrl_f],
    model=model,
    additional_authorized_imports=[<span class="hljs-string">&quot;helium&quot;</span>],
    step_callbacks=[update_screenshot],
    max_steps=<span class="hljs-number">20</span>,
    verbosity_level=<span class="hljs-number">2</span>,
)`,wrap:!1}}),N=new Ue({props:{title:"Run agents one step at a time",local:"run-agents-one-step-at-a-time",headingTag:"h3"}}),R=new H({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTJDJTIwQWN0aW9uU3RlcCUyQyUyMFRhc2tTdGVwJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQodG9vbHMlM0QlNUIlNUQlMkMlMjBtb2RlbCUzREhmQXBpTW9kZWwoKSUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDEpJTBBcHJpbnQoYWdlbnQubWVtb3J5LnN5c3RlbV9wcm9tcHQpJTBBJTBBdGFzayUyMCUzRCUyMCUyMldoYXQlMjBpcyUyMHRoZSUyMDIwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIlMEElMEElMjMlMjBZb3UlMjBjb3VsZCUyMG1vZGlmeSUyMHRoZSUyMG1lbW9yeSUyMGFzJTIwbmVlZGVkJTIwaGVyZSUyMGJ5JTIwaW5wdXR0aW5nJTIwdGhlJTIwbWVtb3J5JTIwb2YlMjBhbm90aGVyJTIwYWdlbnQuJTBBJTIzJTIwYWdlbnQubWVtb3J5LnN0ZXBzJTIwJTNEJTIwcHJldmlvdXNfYWdlbnQubWVtb3J5LnN0ZXBzJTBBJTBBJTIzJTIwTGV0J3MlMjBzdGFydCUyMGElMjBuZXclMjB0YXNrISUwQWFnZW50Lm1lbW9yeS5zdGVwcy5hcHBlbmQoVGFza1N0ZXAodGFzayUzRHRhc2slMkMlMjB0YXNrX2ltYWdlcyUzRCU1QiU1RCkpJTBBJTBBZmluYWxfYW5zd2VyJTIwJTNEJTIwTm9uZSUwQXN0ZXBfbnVtYmVyJTIwJTNEJTIwMSUwQXdoaWxlJTIwZmluYWxfYW5zd2VyJTIwaXMlMjBOb25lJTIwYW5kJTIwc3RlcF9udW1iZXIlMjAlM0MlM0QlMjAxMCUzQSUwQSUyMCUyMCUyMCUyMG1lbW9yeV9zdGVwJTIwJTNEJTIwQWN0aW9uU3RlcCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVwX251bWJlciUzRHN0ZXBfbnVtYmVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzZXJ2YXRpb25zX2ltYWdlcyUzRCU1QiU1RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjBvbmUlMjBzdGVwLiUwQSUyMCUyMCUyMCUyMGZpbmFsX2Fuc3dlciUyMCUzRCUyMGFnZW50LnN0ZXAobWVtb3J5X3N0ZXApJTBBJTIwJTIwJTIwJTIwYWdlbnQubWVtb3J5LnN0ZXBzLmFwcGVuZChtZW1vcnlfc3RlcCklMEElMjAlMjAlMjAlMjBzdGVwX251bWJlciUyMCUyQiUzRCUyMDElMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDaGFuZ2UlMjB0aGUlMjBtZW1vcnklMjBhcyUyMHlvdSUyMHBsZWFzZSElMEElMjAlMjAlMjAlMjAlMjMlMjBGb3IlMjBpbnN0YW5jZSUyMHRvJTIwdXBkYXRlJTIwdGhlJTIwbGF0ZXN0JTIwc3RlcCUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGFnZW50Lm1lbW9yeS5zdGVwcyU1Qi0xJTVEJTIwJTNEJTIwLi4uJTBBJTBBcHJpbnQoJTIyVGhlJTIwZmluYWwlMjBhbnN3ZXIlMjBpcyUzQSUyMiUyQyUyMGZpbmFsX2Fuc3dlcik=",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent, ActionStep, TaskStep

agent = CodeAgent(tools=[], model=HfApiModel(), verbosity_level=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(agent.memory.system_prompt)

task = <span class="hljs-string">&quot;What is the 20th Fibonacci number?&quot;</span>

<span class="hljs-comment"># You could modify the memory as needed here by inputting the memory of another agent.</span>
<span class="hljs-comment"># agent.memory.steps = previous_agent.memory.steps</span>

<span class="hljs-comment"># Let&#x27;s start a new task!</span>
agent.memory.steps.append(TaskStep(task=task, task_images=[]))

final_answer = <span class="hljs-literal">None</span>
step_number = <span class="hljs-number">1</span>
<span class="hljs-keyword">while</span> final_answer <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> step_number &lt;= <span class="hljs-number">10</span>:
    memory_step = ActionStep(
        step_number=step_number,
        observations_images=[],
    )
    <span class="hljs-comment"># Run one step.</span>
    final_answer = agent.step(memory_step)
    agent.memory.steps.append(memory_step)
    step_number += <span class="hljs-number">1</span>

    <span class="hljs-comment"># Change the memory as you please!</span>
    <span class="hljs-comment"># For instance to update the latest step:</span>
    <span class="hljs-comment"># agent.memory.steps[-1] = ...</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;The final answer is:&quot;</span>, final_answer)`,wrap:!1}}),E=new De({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/memory.mdx"}}),{c(){w=p("meta"),x=n(),Y=p("p"),F=n(),i(J.$$.fragment),L=n(),i(u.$$.fragment),D=n(),j=p("p"),j.textContent=fe,P=n(),i(h.$$.fragment),q=n(),d=p("p"),d.textContent=Be,K=n(),T=p("p"),T.innerHTML=Ie,O=n(),U=p("p"),U.innerHTML=Ze,ee=n(),g=p("p"),g.textContent=Ce,se=n(),i(f.$$.fragment),te=n(),B=p("p"),B.textContent=ve,le=n(),i(I.$$.fragment),ne=n(),i(Z.$$.fragment),ae=n(),C=p("p"),C.textContent=We,pe=n(),v=p("p"),v.textContent=_e,oe=n(),i(W.$$.fragment),me=n(),_=p("p"),_.innerHTML=ke,ie=n(),k=p("p"),k.textContent=Xe,Me=n(),X=p("p"),X.innerHTML=Ve,ce=n(),V=p("p"),V.innerHTML=Qe,ye=n(),i(Q.$$.fragment),re=n(),A=p("p"),A.innerHTML=Ae,be=n(),i(G.$$.fragment),we=n(),$=p("p"),$.innerHTML=Ge,Je=n(),i(N.$$.fragment),ue=n(),z=p("p"),z.textContent=$e,je=n(),i(R.$$.fragment),he=n(),i(E.$$.fragment),de=n(),S=p("p"),this.h()},l(e){const s=xe("svelte-u9bgzb",document.head);w=o(s,"META",{name:!0,content:!0}),s.forEach(t),x=a(e),Y=o(e,"P",{}),Ne(Y).forEach(t),F=a(e),M(J.$$.fragment,e),L=a(e),M(u.$$.fragment,e),D=a(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-102p4os"&&(j.textContent=fe),P=a(e),M(h.$$.fragment,e),q=a(e),d=o(e,"P",{"data-svelte-h":!0}),m(d)!=="svelte-p9bsvd"&&(d.textContent=Be),K=a(e),T=o(e,"P",{"data-svelte-h":!0}),m(T)!=="svelte-cyladv"&&(T.innerHTML=Ie),O=a(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-1j5hyq7"&&(U.innerHTML=Ze),ee=a(e),g=o(e,"P",{"data-svelte-h":!0}),m(g)!=="svelte-kdqcx3"&&(g.textContent=Ce),se=a(e),M(f.$$.fragment,e),te=a(e),B=o(e,"P",{"data-svelte-h":!0}),m(B)!=="svelte-16cln5c"&&(B.textContent=ve),le=a(e),M(I.$$.fragment,e),ne=a(e),M(Z.$$.fragment,e),ae=a(e),C=o(e,"P",{"data-svelte-h":!0}),m(C)!=="svelte-8gbd4j"&&(C.textContent=We),pe=a(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-dw95g"&&(v.textContent=_e),oe=a(e),M(W.$$.fragment,e),me=a(e),_=o(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-oqerv4"&&(_.innerHTML=ke),ie=a(e),k=o(e,"P",{"data-svelte-h":!0}),m(k)!=="svelte-2c0lec"&&(k.textContent=Xe),Me=a(e),X=o(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1g68dq6"&&(X.innerHTML=Ve),ce=a(e),V=o(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-3i8ah2"&&(V.innerHTML=Qe),ye=a(e),M(Q.$$.fragment,e),re=a(e),A=o(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1s6pldm"&&(A.innerHTML=Ae),be=a(e),M(G.$$.fragment,e),we=a(e),$=o(e,"P",{"data-svelte-h":!0}),m($)!=="svelte-1c9b7q3"&&($.innerHTML=Ge),Je=a(e),M(N.$$.fragment,e),ue=a(e),z=o(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-1jw480t"&&(z.textContent=$e),je=a(e),M(R.$$.fragment,e),he=a(e),M(E.$$.fragment,e),de=a(e),S=o(e,"P",{}),Ne(S).forEach(t),this.h()},h(){ze(w,"name","hf:doc:metadata"),ze(w,"content",qe)},m(e,s){Fe(document.head,w),l(e,x,s),l(e,Y,s),l(e,F,s),c(J,e,s),l(e,L,s),c(u,e,s),l(e,D,s),l(e,j,s),l(e,P,s),c(h,e,s),l(e,q,s),l(e,d,s),l(e,K,s),l(e,T,s),l(e,O,s),l(e,U,s),l(e,ee,s),l(e,g,s),l(e,se,s),c(f,e,s),l(e,te,s),l(e,B,s),l(e,le,s),c(I,e,s),l(e,ne,s),c(Z,e,s),l(e,ae,s),l(e,C,s),l(e,pe,s),l(e,v,s),l(e,oe,s),c(W,e,s),l(e,me,s),l(e,_,s),l(e,ie,s),l(e,k,s),l(e,Me,s),l(e,X,s),l(e,ce,s),l(e,V,s),l(e,ye,s),c(Q,e,s),l(e,re,s),l(e,A,s),l(e,be,s),c(G,e,s),l(e,we,s),l(e,$,s),l(e,Je,s),c(N,e,s),l(e,ue,s),l(e,z,s),l(e,je,s),c(R,e,s),l(e,he,s),c(E,e,s),l(e,de,s),l(e,S,s),Te=!0},p:Ee,i(e){Te||(y(J.$$.fragment,e),y(u.$$.fragment,e),y(h.$$.fragment,e),y(f.$$.fragment,e),y(I.$$.fragment,e),y(Z.$$.fragment,e),y(W.$$.fragment,e),y(Q.$$.fragment,e),y(G.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(E.$$.fragment,e),Te=!0)},o(e){r(J.$$.fragment,e),r(u.$$.fragment,e),r(h.$$.fragment,e),r(f.$$.fragment,e),r(I.$$.fragment,e),r(Z.$$.fragment,e),r(W.$$.fragment,e),r(Q.$$.fragment,e),r(G.$$.fragment,e),r(N.$$.fragment,e),r(R.$$.fragment,e),r(E.$$.fragment,e),Te=!1},d(e){e&&(t(x),t(Y),t(F),t(L),t(D),t(j),t(P),t(q),t(d),t(K),t(T),t(O),t(U),t(ee),t(g),t(se),t(te),t(B),t(le),t(ne),t(ae),t(C),t(pe),t(v),t(oe),t(me),t(_),t(ie),t(k),t(Me),t(X),t(ce),t(V),t(ye),t(re),t(A),t(be),t(we),t($),t(Je),t(ue),t(z),t(je),t(he),t(de),t(S)),t(w),b(J,e),b(u,e),b(h,e),b(f,e),b(I,e),b(Z,e),b(W,e),b(Q,e),b(G,e),b(N,e),b(R,e),b(E,e)}}}const qe='{"title":"📚 Manage your agent’s memory","local":"-manage-your-agents-memory","sections":[{"title":"Replay your agent’s memory","local":"replay-your-agents-memory","sections":[],"depth":3},{"title":"Dynamically change the agent’s memory","local":"dynamically-change-the-agents-memory","sections":[],"depth":3},{"title":"Run agents one step at a time","local":"run-agents-one-step-at-a-time","sections":[],"depth":3}],"depth":1}';function Ke(ge){return He(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ns extends Ye{constructor(w){super(),Se(this,w,Ke,Pe,Re,{})}}export{ns as component};
