import{s as Qs,o as Ps,n as R}from"../chunks/scheduler.8c3d61f6.js";import{S as Ls,i as qs,g as i,s as a,r as f,m as Ys,H as As,A as Os,h as l,f as d,c as r,j as U,u,n as Ds,E as Ks,x as _,k as J,y as o,a as x,v as h,d as g,t as b,w as M}from"../chunks/index.da70eac4.js";import{T as Es}from"../chunks/Tip.1d9b8c37.js";import{D as k}from"../chunks/Docstring.6b390b9a.js";import{C as D}from"../chunks/CodeBlock.00a903b3.js";import{E as Y}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as Kt,E as en}from"../chunks/EditOnGithub.1e64e623.js";function tn(T){let s,w=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){s=i("p"),s.textContent=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),_(s)!=="svelte-17p1lpg"&&(s.textContent=w)},m(m,n){x(m,s,n)},p:R,d(m){m&&d(s)}}}function on(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQW1vZGVsJTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0yLTElMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTBBKSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5lbmFibGVfeGZvcm1lcnNfbWVtb3J5X2VmZmljaWVudF9hdHRlbnRpb24oYXR0ZW50aW9uX29wJTNETWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>model = UNet2DConditionModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function sn(T){let s,w=`To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with
<code>huggingface-cli login</code>. You can also activate the special
<a href="https://huggingface.co/diffusers/installation.html#offline-mode" rel="nofollow">“offline-mode”</a> to use this method in a
firewalled environment.`;return{c(){s=i("p"),s.innerHTML=w},l(m){s=l(m,"P",{"data-svelte-h":!0}),_(s)!=="svelte-19a77yg"&&(s.innerHTML=w)},m(m,n){x(m,s,n)},p:R,d(m){m&&d(s)}}}function nn(T){let s,w="Example:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-11lpom8"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function an(T){let s,w="If you get the error message below, you need to finetune the weights for your downstream task:",m,n,c;return n=new D({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-xueb0m"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function rn(T){let s,w="Example:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyKSUwQXVuZXQubnVtX3BhcmFtZXRlcnMob25seV90cmFpbmFibGUlM0RUcnVlKSUwQTg1OTUyMDk2NA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
unet = UNet2DConditionModel.from_pretrained(model_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)
unet.num_parameters(only_trainable=<span class="hljs-literal">True</span>)
<span class="hljs-number">859520964</span>`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-11lpom8"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function ln(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTIwYW5kJTIwY2FjaGUuJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyME1vZGVsJTIwd2FzJTIwc2F2ZWQlMjB1c2luZyUyMCpzYXZlX3ByZXRyYWluZWQoJy4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYnKSolMjAoZm9yJTIwZXhhbXBsZSUyMHB1cnBvc2VzJTJDJTIwbm90JTIwcnVubmFibGUpLiUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)* (for example purposes, not runnable).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function dn(T){let s,w="If you get the error message below, you need to finetune the weights for your downstream task:",m,n,c;return n=new D({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwcnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTIwYmVjYXVzZSUyMHRoZSUyMHNoYXBlcyUyMGRpZCUyMG5vdCUyMG1hdGNoJTNBJTBBLSUyMGNvbnZfaW4ud2VpZ2h0JTNBJTIwZm91bmQlMjBzaGFwZSUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwNCUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwY2hlY2twb2ludCUyMGFuZCUyMHRvcmNoLlNpemUoJTVCMzIwJTJDJTIwOSUyQyUyMDMlMkMlMjAzJTVEKSUyMGluJTIwdGhlJTIwbW9kZWwlMjBpbnN0YW50aWF0ZWQlMEFZb3UlMjBzaG91bGQlMjBwcm9iYWJseSUyMFRSQUlOJTIwdGhpcyUyMG1vZGVsJTIwb24lMjBhJTIwZG93bi1zdHJlYW0lMjB0YXNrJTIwdG8lMjBiZSUyMGFibGUlMjB0byUyMHVzZSUyMGl0JTIwZm9yJTIwcHJlZGljdGlvbnMlMjBhbmQlMjBpbmZlcmVuY2Uu",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint at runwayml/stable-diffusion-v1-5 and are newly initialized because the shapes did not match:
- conv_in.weight: found shape torch.Size([320, 4, 3, 3]) <span class="hljs-keyword">in</span> the checkpoint and torch.Size([320, 9, 3, 3]) <span class="hljs-keyword">in</span> the model instantiated
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-xueb0m"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function mn(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtZXRlcnMlMjB3aWxsJTIwYmUlMjBpbiUyMGZwMzIlMjBwcmVjaXNpb24lMkMlMjB0byUyMGNhc3QlMjB0aGVzZSUyMHRvJTIwYmZsb2F0MTYlMjBwcmVjaXNpb24lMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19iZjE2KHBhcmFtcyklMEElMjMlMjBJZiUyMHlvdSUyMGRvbid0JTIwd2FudCUyMHRvJTIwY2FzdCUyMGNlcnRhaW4lMjBwYXJhbWV0ZXJzJTIwKGZvciUyMGV4YW1wbGUlMjBsYXllciUyMG5vcm0lMjBiaWFzJTIwYW5kJTIwc2NhbGUpJTBBJTIzJTIwdGhlbiUyMHBhc3MlMjB0aGUlMjBtYXNrJTIwYXMlMjBmb2xsb3dzJTBBZnJvbSUyMGZsYXglMjBpbXBvcnQlMjB0cmF2ZXJzZV91dGlsJTBBJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQWZsYXRfcGFyYW1zJTIwJTNEJTIwdHJhdmVyc2VfdXRpbC5mbGF0dGVuX2RpY3QocGFyYW1zKSUwQW1hc2slMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjBwYXRoJTNBJTIwKHBhdGglNUItMiU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyYmlhcyUyMiklMjBhbmQlMjBwYXRoJTVCLTIlM0ElNUQlMjAhJTNEJTIwKCUyMkxheWVyTm9ybSUyMiUyQyUyMCUyMnNjYWxlJTIyKSklMEElMjAlMjAlMjAlMjBmb3IlMjBwYXRoJTIwaW4lMjBmbGF0X3BhcmFtcyUwQSU3RCUwQW1hc2slMjAlM0QlMjB0cmF2ZXJzZV91dGlsLnVuZmxhdHRlbl9kaWN0KG1hc2spJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fYmYxNihwYXJhbXMlMkMlMjBtYXNrKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model parameters will be in fp32 precision, to cast these to bfloat16 precision</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_bf16(params, mask)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function cn(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMGxvYWQlMjBtb2RlbCUwQW1vZGVsJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjB0aGUlMjBtb2RlbCUyMHBhcmFtcyUyMHdpbGwlMjBiZSUyMGluJTIwZnAzMiUyQyUyMHRvJTIwY2FzdCUyMHRoZXNlJTIwdG8lMjBmbG9hdDE2JTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZnAxNihwYXJhbXMpJTBBJTIzJTIwSWYlMjB5b3UlMjB3YW50JTIwZG9uJ3QlMjB3YW50JTIwdG8lMjBjYXN0JTIwY2VydGFpbiUyMHBhcmFtZXRlcnMlMjAoZm9yJTIwZXhhbXBsZSUyMGxheWVyJTIwbm9ybSUyMGJpYXMlMjBhbmQlMjBzY2FsZSklMEElMjMlMjB0aGVuJTIwcGFzcyUyMHRoZSUyMG1hc2slMjBhcyUyMGZvbGxvd3MlMEFmcm9tJTIwZmxheCUyMGltcG9ydCUyMHRyYXZlcnNlX3V0aWwlMEElMEFtb2RlbCUyQyUyMHBhcmFtcyUyMCUzRCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBZmxhdF9wYXJhbXMlMjAlM0QlMjB0cmF2ZXJzZV91dGlsLmZsYXR0ZW5fZGljdChwYXJhbXMpJTBBbWFzayUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMHBhdGglM0ElMjAocGF0aCU1Qi0yJTVEJTIwISUzRCUyMCglMjJMYXllck5vcm0lMjIlMkMlMjAlMjJiaWFzJTIyKSUyMGFuZCUyMHBhdGglNUItMiUzQSU1RCUyMCElM0QlMjAoJTIyTGF5ZXJOb3JtJTIyJTJDJTIwJTIyc2NhbGUlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhdGglMjBpbiUyMGZsYXRfcGFyYW1zJTBBJTdEJTBBbWFzayUyMCUzRCUyMHRyYXZlcnNlX3V0aWwudW5mbGF0dGVuX2RpY3QobWFzayklMEFwYXJhbXMlMjAlM0QlMjBtb2RlbC50b19mcDE2KHBhcmFtcyUyQyUyMG1hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to cast these to float16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you want don&#x27;t want to cast certain parameters (for example layer norm bias and scale)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># then pass the mask as follows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax <span class="hljs-keyword">import</span> traverse_util

<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_params = traverse_util.flatten_dict(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = {
<span class="hljs-meta">... </span>    path: (path[-<span class="hljs-number">2</span>] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;bias&quot;</span>) <span class="hljs-keyword">and</span> path[-<span class="hljs-number">2</span>:] != (<span class="hljs-string">&quot;LayerNorm&quot;</span>, <span class="hljs-string">&quot;scale&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> flat_params
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = traverse_util.unflatten_dict(mask)
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp16(params, mask)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function pn(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUwQSUwQSUyMyUyMERvd25sb2FkJTIwbW9kZWwlMjBhbmQlMjBjb25maWd1cmF0aW9uJTIwZnJvbSUyMGh1Z2dpbmdmYWNlLmNvJTBBbW9kZWwlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4VU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMG1vZGVsJTIwcGFyYW1zJTIwd2lsbCUyMGJlJTIwaW4lMjBmcDMyJTJDJTIwdG8lMjBpbGx1c3RyYXRlJTIwdGhlJTIwdXNlJTIwb2YlMjB0aGlzJTIwbWV0aG9kJTJDJTBBJTIzJTIwd2UnbGwlMjBmaXJzdCUyMGNhc3QlMjB0byUyMGZwMTYlMjBhbmQlMjBiYWNrJTIwdG8lMjBmcDMyJTBBcGFyYW1zJTIwJTNEJTIwbW9kZWwudG9fZjE2KHBhcmFtcyklMEElMjMlMjBub3clMjBjYXN0JTIwYmFjayUyMHRvJTIwZnAzMiUwQXBhcmFtcyUyMCUzRCUyMG1vZGVsLnRvX2ZwMzIocGFyYW1zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxUNet2DConditionModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download model and configuration from huggingface.co</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, params = FlaxUNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the model params will be in fp32, to illustrate the use of this method,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># we&#x27;ll first cast to fp16 and back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_f16(params)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># now cast back to fp32</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>params = model.to_fp32(params)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function fn(T){let s,w="Examples:",m,n,c;return n=new D({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){s=i("p"),s.textContent=w,m=a(),f(n.$$.fragment)},l(e){s=l(e,"P",{"data-svelte-h":!0}),_(s)!=="svelte-kvfsh7"&&(s.textContent=w),m=r(e),u(n.$$.fragment,e)},m(e,y){x(e,s,y),x(e,m,y),h(n,e,y),c=!0},p:R,i(e){c||(g(n.$$.fragment,e),c=!0)},o(e){b(n.$$.fragment,e),c=!1},d(e){e&&(d(s),d(m)),M(n,e)}}}function un(T){let s,w,m,n,c,e,y,eo,Vt,Ss='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mrow><mi>t</mi><mo>−</mo><mn>1</mn></mrow></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_{\\theta}(x_{t-1}|x_{t})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span><span class="mbin mtight">−</span><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2083em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Rt,zt,Me,cs='All models are built from the base <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> class which is a <a href="https://pytorch.org/docs/stable/generated/torch.nn.Module.html" rel="nofollow"><code>torch.nn.Module</code></a> providing basic functionality for saving and loading models, locally and from the Hugging Face Hub.',Nt,ye,Ht,v,_e,to,tt,ps="Base class for all models.",oo,ot,fs=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,so,st,us='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>',no,E,ve,ao,nt,hs=`Potentially dequantize the model in case it has been quantized by a quantization method that support
dequantization.`,ro,S,xe,io,at,gs=`Deactivates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,lo,Q,we,mo,rt,bs="disable npu flash attention from torch_npu",co,P,$e,po,it,Ms='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',fo,L,Te,uo,lt,ys="Disable the flash attention pallals kernel for torch_xla.",ho,q,Ue,go,dt,_s=`Activates gradient checkpointing for the current model (may be referred to as <em>activation checkpointing</em> or
<em>checkpoint activations</em> in other frameworks).`,bo,A,Je,Mo,mt,vs="Enable npu flash attention from torch_npu",yo,I,je,_o,ct,xs='Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',vo,pt,ws=`When this option is enabled, you should observe lower GPU memory usage and a potential speed up during
inference. Speed up during training is not guaranteed.`,xo,O,wo,K,$o,ee,ke,To,ft,$s="Enable the flash attention pallals kernel for torch_xla.",Uo,C,Ze,Jo,ut,Ts="Instantiate a pretrained PyTorch model from a pretrained model configuration.",jo,ht,Us=`The model is set in evaluation mode - <code>model.eval()</code> - by default, and dropout modules are deactivated. To
train the model, set it back in training mode with <code>model.train()</code>.`,ko,te,Zo,oe,Co,se,Go,ne,Ce,Io,gt,Js=`Get the memory footprint of a model. This will return the memory footprint of the current model in bytes.
Useful to benchmark the memory footprint of the current model and design some tests. Solution inspired from the
PyTorch discussions: <a href="https://discuss.pytorch.org/t/gpu-memory-that-model-uses/56822/2" rel="nofollow">https://discuss.pytorch.org/t/gpu-memory-that-model-uses/56822/2</a>`,Fo,N,Ge,Wo,bt,js="Get number of (trainable or non-embedding) parameters in the module.",Bo,ae,Vo,re,Ie,Ro,Mt,ks=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> class method.`,zo,ie,Fe,No,yt,Zs="Set the switch for the npu flash attention.",Xt,We,Yt,j,Be,Ho,_t,Cs="Base class for all Flax models.",Xo,vt,Gs=`<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin">FlaxModelMixin</a> takes care of storing the model configuration and provides methods for loading, downloading and
saving models.`,Yo,xt,Is='<li><strong>config_name</strong> (<code>str</code>) — Filename to save a model to when calling <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>',Do,W,Ve,Eo,wt,Fs="Instantiate a pretrained Flax model from a pretrained model configuration.",So,le,Qo,de,Po,me,Re,Lo,$t,Ws=`Save a model and its configuration file to a directory so that it can be reloaded using the
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.from_pretrained">from_pretrained()</a> class method.`,qo,B,ze,Ao,Tt,Bs=`Cast the floating-point <code>params</code> to <code>jax.numpy.bfloat16</code>. This returns a new <code>params</code> tree and does not cast
the <code>params</code> in place.`,Oo,Ut,Vs=`This method can be used on a TPU to explicitly convert the model parameters to bfloat16 precision to do full
half-precision training or to save weights in bfloat16 for inference in order to save memory and improve speed.`,Ko,ce,es,V,Ne,ts,Jt,Rs=`Cast the floating-point <code>params</code> to <code>jax.numpy.float16</code>. This returns a new <code>params</code> tree and does not cast the
<code>params</code> in place.`,os,jt,zs=`This method can be used on a GPU to explicitly convert the model parameters to float16 precision to do full
half-precision training or to save weights in float16 for inference in order to save memory and improve speed.`,ss,pe,ns,H,He,as,kt,Ns=`Cast the floating-point <code>params</code> to <code>jax.numpy.float32</code>. This method can be used to explicitly convert the
model parameters to fp32 precision. This returns a new <code>params</code> tree and does not cast the <code>params</code> in place.`,rs,fe,Dt,Xe,Et,z,Ye,is,Zt,Hs="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",ls,X,De,ds,Ct,Xs="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",ms,ue,St,Ee,Qt,Bt,Pt;return c=new Kt({props:{title:"Models",local:"models",headingTag:"h1"}}),ye=new Kt({props:{title:"ModelMixin",local:"diffusers.ModelMixin",headingTag:"h2"}}),_e=new k({props:{name:"class diffusers.ModelMixin",anchor:"diffusers.ModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L137"}}),ve=new k({props:{name:"dequantize",anchor:"diffusers.ModelMixin.dequantize",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L472"}}),xe=new k({props:{name:"disable_gradient_checkpointing",anchor:"diffusers.ModelMixin.disable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L191"}}),we=new k({props:{name:"disable_npu_flash_attention",anchor:"diffusers.ModelMixin.disable_npu_flash_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L222"}}),$e=new k({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L311"}}),Te=new k({props:{name:"disable_xla_flash_attention",anchor:"diffusers.ModelMixin.disable_xla_flash_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L252"}}),Ue=new k({props:{name:"enable_gradient_checkpointing",anchor:"diffusers.ModelMixin.enable_gradient_checkpointing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L182"}}),Je=new k({props:{name:"enable_npu_flash_attention",anchor:"diffusers.ModelMixin.enable_npu_flash_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L215"}}),je=new k({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L275"}}),O=new Es({props:{warning:!0,$$slots:{default:[tn]},$$scope:{ctx:T}}}),K=new Y({props:{anchor:"diffusers.ModelMixin.enable_xformers_memory_efficient_attention.example",$$slots:{default:[on]},$$scope:{ctx:T}}}),ke=new k({props:{name:"enable_xla_flash_attention",anchor:"diffusers.ModelMixin.enable_xla_flash_attention",parameters:[{name:"partition_spec",val:": typing.Optional[typing.Callable] = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L246"}}),Ze=new k({props:{name:"from_pretrained",anchor:"diffusers.ModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>google/ddpm-celebahq-256</code>) of a pretrained model hosted on
the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
with <a href="/docs/diffusers/main/en/api/models/overview#diffusers.ModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.ModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.ModelMixin.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. If <code>&quot;auto&quot;</code> is passed, the
dtype is automatically derived from the model&#x2019;s weights.`,name:"torch_dtype"},{anchor:"diffusers.ModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.ModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.ModelMixin.from_pretrained.output_loading_info",description:`<strong>output_loading_info</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info"},{anchor:"diffusers.ModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.ModelMixin.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.ModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.ModelMixin.from_pretrained.from_flax",description:`<strong>from_flax</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a Flax checkpoint save file.`,name:"from_flax"},{anchor:"diffusers.ModelMixin.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.ModelMixin.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.ModelMixin.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>Dict[str, Union[int, str, torch.device]]</code>, <em>optional</em>) &#x2014;
A map that specifies where each submodule should go. It doesn&#x2019;t need to be defined for each
parameter/buffer name; once a given module name is inside, every submodule of it will be sent to the
same device. Defaults to <code>None</code>, meaning that the model will be loaded on CPU.</p>
<p>Set <code>device_map=&quot;auto&quot;</code> to have &#x1F917; Accelerate automatically compute the most optimized <code>device_map</code>. For
more information about each option see <a href="https://hf.co/docs/accelerate/main/en/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">designing a device
map</a>.`,name:"device_map"},{anchor:"diffusers.ModelMixin.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if <code>device_map</code> contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.ModelMixin.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.ModelMixin.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.ModelMixin.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified <code>variant</code> filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the <code>safetensors</code> weights are downloaded if they&#x2019;re available <strong>and</strong> if the
<code>safetensors</code> library is installed. If set to <code>True</code>, the model is forcibly loaded from <code>safetensors</code>
weights. If set to <code>False</code>, <code>safetensors</code> weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.ModelMixin.from_pretrained.disable_mmap",description:`<strong>disable_mmap</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to &#x2018;False&#x2019;) &#x2014;
Whether to disable mmap when loading a Safetensors model. This option can perform better when the model
is on a network mount or hard drive, which may not handle the seeky-ness of mmap very well.`,name:"disable_mmap"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L484"}}),te=new Es({props:{$$slots:{default:[sn]},$$scope:{ctx:T}}}),oe=new Y({props:{anchor:"diffusers.ModelMixin.from_pretrained.example",$$slots:{default:[nn]},$$scope:{ctx:T}}}),se=new Y({props:{anchor:"diffusers.ModelMixin.from_pretrained.example-2",$$slots:{default:[an]},$$scope:{ctx:T}}}),Ce=new k({props:{name:"get_memory_footprint",anchor:"diffusers.ModelMixin.get_memory_footprint",parameters:[{name:"return_buffers",val:" = True"}],parametersDescription:[{anchor:"diffusers.ModelMixin.get_memory_footprint.return_buffers",description:`<strong>return_buffers</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return the size of the buffer tensors in the computation of the memory footprint. Buffers
are tensors that do not require gradients and not registered as parameters. E.g. mean and std in batch
norm layers. Please see: <a href="https://discuss.pytorch.org/t/what-pytorch-means-by-buffers/120266/2" rel="nofollow">https://discuss.pytorch.org/t/what-pytorch-means-by-buffers/120266/2</a>`,name:"return_buffers"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L1336"}}),Ge=new k({props:{name:"num_parameters",anchor:"diffusers.ModelMixin.num_parameters",parameters:[{name:"only_trainable",val:": bool = False"},{name:"exclude_embeddings",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.ModelMixin.num_parameters.only_trainable",description:`<strong>only_trainable</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of trainable parameters.`,name:"only_trainable"},{anchor:"diffusers.ModelMixin.num_parameters.exclude_embeddings",description:`<strong>exclude_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return only the number of non-embedding parameters.`,name:"exclude_embeddings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L1272",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The number of parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>int</code></p>
`}}),ae=new Y({props:{anchor:"diffusers.ModelMixin.num_parameters.example",$$slots:{default:[rn]},$$scope:{ctx:T}}}),Ie=new k({props:{name:"save_pretrained",anchor:"diffusers.ModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"is_main_process",val:": bool = True"},{name:"save_function",val:": typing.Optional[typing.Callable] = None"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str] = '10GB'"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.ModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.ModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.ModelMixin.save_pretrained.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.ModelMixin.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.ModelMixin.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.ModelMixin.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>&quot;10GB&quot;</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.ModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face Hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.ModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L317"}}),Fe=new k({props:{name:"set_use_npu_flash_attention",anchor:"diffusers.ModelMixin.set_use_npu_flash_attention",parameters:[{name:"valid",val:": bool"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_utils.py#L199"}}),We=new Kt({props:{title:"FlaxModelMixin",local:"diffusers.FlaxModelMixin",headingTag:"h2"}}),Be=new k({props:{name:"class diffusers.FlaxModelMixin",anchor:"diffusers.FlaxModelMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L50"}}),Ve=new k({props:{name:"from_pretrained",anchor:"diffusers.FlaxModelMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike]"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"*model_args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>runwayml/stable-diffusion-v1-5</code>) of a pretrained model
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified, all the computation will be performed with the given <code>dtype</code>.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>This only specifies the dtype of the <em>computation</em> and does not influence the dtype of model
parameters.</p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_fp16">to_fp16()</a> and
<a href="/docs/diffusers/main/en/api/models/overview#diffusers.FlaxModelMixin.to_bf16">to_bf16()</a>.</p>

					</div>`,name:"dtype"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.model_args",description:`<strong>model_args</strong> (sequence of positional arguments, <em>optional</em>) &#x2014;
All remaining positional arguments are passed to the underlying model&#x2019;s <code>__init__</code> method.`,name:"model_args"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.local_files_only(bool,",description:`<strong>local_files_only(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only(bool,"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.from_pt",description:`<strong>from_pt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Load the model weights from a PyTorch checkpoint save file.`,name:"from_pt"},{anchor:"diffusers.FlaxModelMixin.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to update the configuration object (after it is loaded) and initiate the model (for
example, <code>output_attentions=True</code>). Behaves differently depending on whether a <code>config</code> is provided or
automatically loaded:</p>
<ul>
<li>If a configuration is provided with <code>config</code>, <code>kwargs</code> are directly passed to the underlying
model&#x2019;s <code>__init__</code> method (we assume all relevant updates to the configuration have already been
done).</li>
<li>If a configuration is not provided, <code>kwargs</code> are first passed to the configuration class
initialization function <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a>. Each key of the <code>kwargs</code> that corresponds
to a configuration attribute is used to override said attribute with the supplied <code>kwargs</code> value.
Remaining keys that do not correspond to any configuration attribute are passed to the underlying
model&#x2019;s <code>__init__</code> function.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L203"}}),le=new Y({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example",$$slots:{default:[ln]},$$scope:{ctx:T}}}),de=new Y({props:{anchor:"diffusers.FlaxModelMixin.from_pretrained.example-2",$$slots:{default:[dn]},$$scope:{ctx:T}}}),Re=new k({props:{name:"save_pretrained",anchor:"diffusers.FlaxModelMixin.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"is_main_process",val:": bool = True"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a model and its configuration file to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxModelMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L497"}}),ze=new k({props:{name:"to_bf16",anchor:"diffusers.FlaxModelMixin.to_bf16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_bf16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_bf16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L95"}}),ce=new Y({props:{anchor:"diffusers.FlaxModelMixin.to_bf16.example",$$slots:{default:[mn]},$$scope:{ctx:T}}}),Ne=new k({props:{name:"to_fp16",anchor:"diffusers.FlaxModelMixin.to_fp16",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp16.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp16.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L161"}}),pe=new Y({props:{anchor:"diffusers.FlaxModelMixin.to_fp16.example",$$slots:{default:[cn]},$$scope:{ctx:T}}}),He=new k({props:{name:"to_fp32",anchor:"diffusers.FlaxModelMixin.to_fp32",parameters:[{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"mask",val:": typing.Any = None"}],parametersDescription:[{anchor:"diffusers.FlaxModelMixin.to_fp32.params",description:`<strong>params</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> of model parameters.`,name:"params"},{anchor:"diffusers.FlaxModelMixin.to_fp32.mask",description:`<strong>mask</strong> (<code>Union[Dict, FrozenDict]</code>) &#x2014;
A <code>PyTree</code> with same structure as the <code>params</code> tree. The leaves should be booleans. It should be <code>True</code>
for params you want to cast, and <code>False</code> for those you want to skip.`,name:"mask"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/modeling_flax_utils.py#L134"}}),fe=new Y({props:{anchor:"diffusers.FlaxModelMixin.to_fp32.example",$$slots:{default:[pn]},$$scope:{ctx:T}}}),Xe=new Kt({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),Ye=new k({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L536"}}),De=new k({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L565"}}),ue=new Y({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[fn]},$$scope:{ctx:T}}}),Ee=new en({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/models/overview.md"}}),{c(){s=i("meta"),w=a(),m=i("p"),n=a(),f(c.$$.fragment),e=a(),y=i("p"),eo=Ys("🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),Vt=new As(!1),Rt=Ys("."),zt=a(),Me=i("p"),Me.innerHTML=cs,Nt=a(),f(ye.$$.fragment),Ht=a(),v=i("div"),f(_e.$$.fragment),to=a(),tt=i("p"),tt.textContent=ps,oo=a(),ot=i("p"),ot.innerHTML=fs,so=a(),st=i("ul"),st.innerHTML=us,no=a(),E=i("div"),f(ve.$$.fragment),ao=a(),nt=i("p"),nt.textContent=hs,ro=a(),S=i("div"),f(xe.$$.fragment),io=a(),at=i("p"),at.innerHTML=gs,lo=a(),Q=i("div"),f(we.$$.fragment),mo=a(),rt=i("p"),rt.textContent=bs,co=a(),P=i("div"),f($e.$$.fragment),po=a(),it=i("p"),it.innerHTML=Ms,fo=a(),L=i("div"),f(Te.$$.fragment),uo=a(),lt=i("p"),lt.textContent=ys,ho=a(),q=i("div"),f(Ue.$$.fragment),go=a(),dt=i("p"),dt.innerHTML=_s,bo=a(),A=i("div"),f(Je.$$.fragment),Mo=a(),mt=i("p"),mt.textContent=vs,yo=a(),I=i("div"),f(je.$$.fragment),_o=a(),ct=i("p"),ct.innerHTML=xs,vo=a(),pt=i("p"),pt.textContent=ws,xo=a(),f(O.$$.fragment),wo=a(),f(K.$$.fragment),$o=a(),ee=i("div"),f(ke.$$.fragment),To=a(),ft=i("p"),ft.textContent=$s,Uo=a(),C=i("div"),f(Ze.$$.fragment),Jo=a(),ut=i("p"),ut.textContent=Ts,jo=a(),ht=i("p"),ht.innerHTML=Us,ko=a(),f(te.$$.fragment),Zo=a(),f(oe.$$.fragment),Co=a(),f(se.$$.fragment),Go=a(),ne=i("div"),f(Ce.$$.fragment),Io=a(),gt=i("p"),gt.innerHTML=Js,Fo=a(),N=i("div"),f(Ge.$$.fragment),Wo=a(),bt=i("p"),bt.textContent=js,Bo=a(),f(ae.$$.fragment),Vo=a(),re=i("div"),f(Ie.$$.fragment),Ro=a(),Mt=i("p"),Mt.innerHTML=ks,zo=a(),ie=i("div"),f(Fe.$$.fragment),No=a(),yt=i("p"),yt.textContent=Zs,Xt=a(),f(We.$$.fragment),Yt=a(),j=i("div"),f(Be.$$.fragment),Ho=a(),_t=i("p"),_t.textContent=Cs,Xo=a(),vt=i("p"),vt.innerHTML=Gs,Yo=a(),xt=i("ul"),xt.innerHTML=Is,Do=a(),W=i("div"),f(Ve.$$.fragment),Eo=a(),wt=i("p"),wt.textContent=Fs,So=a(),f(le.$$.fragment),Qo=a(),f(de.$$.fragment),Po=a(),me=i("div"),f(Re.$$.fragment),Lo=a(),$t=i("p"),$t.innerHTML=Ws,qo=a(),B=i("div"),f(ze.$$.fragment),Ao=a(),Tt=i("p"),Tt.innerHTML=Bs,Oo=a(),Ut=i("p"),Ut.textContent=Vs,Ko=a(),f(ce.$$.fragment),es=a(),V=i("div"),f(Ne.$$.fragment),ts=a(),Jt=i("p"),Jt.innerHTML=Rs,os=a(),jt=i("p"),jt.textContent=zs,ss=a(),f(pe.$$.fragment),ns=a(),H=i("div"),f(He.$$.fragment),as=a(),kt=i("p"),kt.innerHTML=Ns,rs=a(),f(fe.$$.fragment),Dt=a(),f(Xe.$$.fragment),Et=a(),z=i("div"),f(Ye.$$.fragment),is=a(),Zt=i("p"),Zt.textContent=Hs,ls=a(),X=i("div"),f(De.$$.fragment),ds=a(),Ct=i("p"),Ct.textContent=Xs,ms=a(),f(ue.$$.fragment),St=a(),f(Ee.$$.fragment),Qt=a(),Bt=i("p"),this.h()},l(t){const p=Os("svelte-u9bgzb",document.head);s=l(p,"META",{name:!0,content:!0}),p.forEach(d),w=r(t),m=l(t,"P",{}),U(m).forEach(d),n=r(t),u(c.$$.fragment,t),e=r(t),y=l(t,"P",{});var Se=U(y);eo=Ds(Se,"🤗 Diffusers provides pretrained models for popular algorithms and modules to create custom diffusion systems. The primary function of models is to denoise an input sample as modeled by the distribution "),Vt=Ks(Se,!1),Rt=Ds(Se,"."),Se.forEach(d),zt=r(t),Me=l(t,"P",{"data-svelte-h":!0}),_(Me)!=="svelte-1elbdrk"&&(Me.innerHTML=cs),Nt=r(t),u(ye.$$.fragment,t),Ht=r(t),v=l(t,"DIV",{class:!0});var $=U(v);u(_e.$$.fragment,$),to=r($),tt=l($,"P",{"data-svelte-h":!0}),_(tt)!=="svelte-12nk4t7"&&(tt.textContent=ps),oo=r($),ot=l($,"P",{"data-svelte-h":!0}),_(ot)!=="svelte-ku6myw"&&(ot.innerHTML=fs),so=r($),st=l($,"UL",{"data-svelte-h":!0}),_(st)!=="svelte-kvpw1l"&&(st.innerHTML=us),no=r($),E=l($,"DIV",{class:!0});var Qe=U(E);u(ve.$$.fragment,Qe),ao=r(Qe),nt=l(Qe,"P",{"data-svelte-h":!0}),_(nt)!=="svelte-on69a4"&&(nt.textContent=hs),Qe.forEach(d),ro=r($),S=l($,"DIV",{class:!0});var Pe=U(S);u(xe.$$.fragment,Pe),io=r(Pe),at=l(Pe,"P",{"data-svelte-h":!0}),_(at)!=="svelte-jedy0o"&&(at.innerHTML=gs),Pe.forEach(d),lo=r($),Q=l($,"DIV",{class:!0});var Le=U(Q);u(we.$$.fragment,Le),mo=r(Le),rt=l(Le,"P",{"data-svelte-h":!0}),_(rt)!=="svelte-advgdt"&&(rt.textContent=bs),Le.forEach(d),co=r($),P=l($,"DIV",{class:!0});var qe=U(P);u($e.$$.fragment,qe),po=r(qe),it=l(qe,"P",{"data-svelte-h":!0}),_(it)!=="svelte-1vfte1e"&&(it.innerHTML=Ms),qe.forEach(d),fo=r($),L=l($,"DIV",{class:!0});var Ae=U(L);u(Te.$$.fragment,Ae),uo=r(Ae),lt=l(Ae,"P",{"data-svelte-h":!0}),_(lt)!=="svelte-l9u3py"&&(lt.textContent=ys),Ae.forEach(d),ho=r($),q=l($,"DIV",{class:!0});var Oe=U(q);u(Ue.$$.fragment,Oe),go=r(Oe),dt=l(Oe,"P",{"data-svelte-h":!0}),_(dt)!=="svelte-1rv66k9"&&(dt.innerHTML=_s),Oe.forEach(d),bo=r($),A=l($,"DIV",{class:!0});var Ke=U(A);u(Je.$$.fragment,Ke),Mo=r(Ke),mt=l(Ke,"P",{"data-svelte-h":!0}),_(mt)!=="svelte-10xtjge"&&(mt.textContent=vs),Ke.forEach(d),yo=r($),I=l($,"DIV",{class:!0});var F=U(I);u(je.$$.fragment,F),_o=r(F),ct=l(F,"P",{"data-svelte-h":!0}),_(ct)!=="svelte-yfpdyb"&&(ct.innerHTML=xs),vo=r(F),pt=l(F,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-z1uct7"&&(pt.textContent=ws),xo=r(F),u(O.$$.fragment,F),wo=r(F),u(K.$$.fragment,F),F.forEach(d),$o=r($),ee=l($,"DIV",{class:!0});var et=U(ee);u(ke.$$.fragment,et),To=r(et),ft=l(et,"P",{"data-svelte-h":!0}),_(ft)!=="svelte-17oym6v"&&(ft.textContent=$s),et.forEach(d),Uo=r($),C=l($,"DIV",{class:!0});var G=U(C);u(Ze.$$.fragment,G),Jo=r(G),ut=l(G,"P",{"data-svelte-h":!0}),_(ut)!=="svelte-1lisopl"&&(ut.textContent=Ts),jo=r(G),ht=l(G,"P",{"data-svelte-h":!0}),_(ht)!=="svelte-1fnd9e6"&&(ht.innerHTML=Us),ko=r(G),u(te.$$.fragment,G),Zo=r(G),u(oe.$$.fragment,G),Co=r(G),u(se.$$.fragment,G),G.forEach(d),Go=r($),ne=l($,"DIV",{class:!0});var Lt=U(ne);u(Ce.$$.fragment,Lt),Io=r(Lt),gt=l(Lt,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-1o6lvix"&&(gt.innerHTML=Js),Lt.forEach(d),Fo=r($),N=l($,"DIV",{class:!0});var Gt=U(N);u(Ge.$$.fragment,Gt),Wo=r(Gt),bt=l(Gt,"P",{"data-svelte-h":!0}),_(bt)!=="svelte-1jxmzhx"&&(bt.textContent=js),Bo=r(Gt),u(ae.$$.fragment,Gt),Gt.forEach(d),Vo=r($),re=l($,"DIV",{class:!0});var qt=U(re);u(Ie.$$.fragment,qt),Ro=r(qt),Mt=l(qt,"P",{"data-svelte-h":!0}),_(Mt)!=="svelte-1y16a8m"&&(Mt.innerHTML=ks),qt.forEach(d),zo=r($),ie=l($,"DIV",{class:!0});var At=U(ie);u(Fe.$$.fragment,At),No=r(At),yt=l(At,"P",{"data-svelte-h":!0}),_(yt)!=="svelte-qmktby"&&(yt.textContent=Zs),At.forEach(d),$.forEach(d),Xt=r(t),u(We.$$.fragment,t),Yt=r(t),j=l(t,"DIV",{class:!0});var Z=U(j);u(Be.$$.fragment,Z),Ho=r(Z),_t=l(Z,"P",{"data-svelte-h":!0}),_(_t)!=="svelte-1kw8rks"&&(_t.textContent=Cs),Xo=r(Z),vt=l(Z,"P",{"data-svelte-h":!0}),_(vt)!=="svelte-ltxz86"&&(vt.innerHTML=Gs),Yo=r(Z),xt=l(Z,"UL",{"data-svelte-h":!0}),_(xt)!=="svelte-5tww1s"&&(xt.innerHTML=Is),Do=r(Z),W=l(Z,"DIV",{class:!0});var he=U(W);u(Ve.$$.fragment,he),Eo=r(he),wt=l(he,"P",{"data-svelte-h":!0}),_(wt)!=="svelte-72pb05"&&(wt.textContent=Fs),So=r(he),u(le.$$.fragment,he),Qo=r(he),u(de.$$.fragment,he),he.forEach(d),Po=r(Z),me=l(Z,"DIV",{class:!0});var Ot=U(me);u(Re.$$.fragment,Ot),Lo=r(Ot),$t=l(Ot,"P",{"data-svelte-h":!0}),_($t)!=="svelte-9z80ed"&&($t.innerHTML=Ws),Ot.forEach(d),qo=r(Z),B=l(Z,"DIV",{class:!0});var ge=U(B);u(ze.$$.fragment,ge),Ao=r(ge),Tt=l(ge,"P",{"data-svelte-h":!0}),_(Tt)!=="svelte-16uni9u"&&(Tt.innerHTML=Bs),Oo=r(ge),Ut=l(ge,"P",{"data-svelte-h":!0}),_(Ut)!=="svelte-1y9zqww"&&(Ut.textContent=Vs),Ko=r(ge),u(ce.$$.fragment,ge),ge.forEach(d),es=r(Z),V=l(Z,"DIV",{class:!0});var be=U(V);u(Ne.$$.fragment,be),ts=r(be),Jt=l(be,"P",{"data-svelte-h":!0}),_(Jt)!=="svelte-ifz6ak"&&(Jt.innerHTML=Rs),os=r(be),jt=l(be,"P",{"data-svelte-h":!0}),_(jt)!=="svelte-yfkr09"&&(jt.textContent=zs),ss=r(be),u(pe.$$.fragment,be),be.forEach(d),ns=r(Z),H=l(Z,"DIV",{class:!0});var It=U(H);u(He.$$.fragment,It),as=r(It),kt=l(It,"P",{"data-svelte-h":!0}),_(kt)!=="svelte-j66hh4"&&(kt.innerHTML=Ns),rs=r(It),u(fe.$$.fragment,It),It.forEach(d),Z.forEach(d),Dt=r(t),u(Xe.$$.fragment,t),Et=r(t),z=l(t,"DIV",{class:!0});var Ft=U(z);u(Ye.$$.fragment,Ft),is=r(Ft),Zt=l(Ft,"P",{"data-svelte-h":!0}),_(Zt)!=="svelte-7y8zei"&&(Zt.textContent=Hs),ls=r(Ft),X=l(Ft,"DIV",{class:!0});var Wt=U(X);u(De.$$.fragment,Wt),ds=r(Wt),Ct=l(Wt,"P",{"data-svelte-h":!0}),_(Ct)!=="svelte-5nfhmh"&&(Ct.textContent=Xs),ms=r(Wt),u(ue.$$.fragment,Wt),Wt.forEach(d),Ft.forEach(d),St=r(t),u(Ee.$$.fragment,t),Qt=r(t),Bt=l(t,"P",{}),U(Bt).forEach(d),this.h()},h(){J(s,"name","hf:doc:metadata"),J(s,"content",hn),Vt.a=Rt,J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,p){o(document.head,s),x(t,w,p),x(t,m,p),x(t,n,p),h(c,t,p),x(t,e,p),x(t,y,p),o(y,eo),Vt.m(Ss,y),o(y,Rt),x(t,zt,p),x(t,Me,p),x(t,Nt,p),h(ye,t,p),x(t,Ht,p),x(t,v,p),h(_e,v,null),o(v,to),o(v,tt),o(v,oo),o(v,ot),o(v,so),o(v,st),o(v,no),o(v,E),h(ve,E,null),o(E,ao),o(E,nt),o(v,ro),o(v,S),h(xe,S,null),o(S,io),o(S,at),o(v,lo),o(v,Q),h(we,Q,null),o(Q,mo),o(Q,rt),o(v,co),o(v,P),h($e,P,null),o(P,po),o(P,it),o(v,fo),o(v,L),h(Te,L,null),o(L,uo),o(L,lt),o(v,ho),o(v,q),h(Ue,q,null),o(q,go),o(q,dt),o(v,bo),o(v,A),h(Je,A,null),o(A,Mo),o(A,mt),o(v,yo),o(v,I),h(je,I,null),o(I,_o),o(I,ct),o(I,vo),o(I,pt),o(I,xo),h(O,I,null),o(I,wo),h(K,I,null),o(v,$o),o(v,ee),h(ke,ee,null),o(ee,To),o(ee,ft),o(v,Uo),o(v,C),h(Ze,C,null),o(C,Jo),o(C,ut),o(C,jo),o(C,ht),o(C,ko),h(te,C,null),o(C,Zo),h(oe,C,null),o(C,Co),h(se,C,null),o(v,Go),o(v,ne),h(Ce,ne,null),o(ne,Io),o(ne,gt),o(v,Fo),o(v,N),h(Ge,N,null),o(N,Wo),o(N,bt),o(N,Bo),h(ae,N,null),o(v,Vo),o(v,re),h(Ie,re,null),o(re,Ro),o(re,Mt),o(v,zo),o(v,ie),h(Fe,ie,null),o(ie,No),o(ie,yt),x(t,Xt,p),h(We,t,p),x(t,Yt,p),x(t,j,p),h(Be,j,null),o(j,Ho),o(j,_t),o(j,Xo),o(j,vt),o(j,Yo),o(j,xt),o(j,Do),o(j,W),h(Ve,W,null),o(W,Eo),o(W,wt),o(W,So),h(le,W,null),o(W,Qo),h(de,W,null),o(j,Po),o(j,me),h(Re,me,null),o(me,Lo),o(me,$t),o(j,qo),o(j,B),h(ze,B,null),o(B,Ao),o(B,Tt),o(B,Oo),o(B,Ut),o(B,Ko),h(ce,B,null),o(j,es),o(j,V),h(Ne,V,null),o(V,ts),o(V,Jt),o(V,os),o(V,jt),o(V,ss),h(pe,V,null),o(j,ns),o(j,H),h(He,H,null),o(H,as),o(H,kt),o(H,rs),h(fe,H,null),x(t,Dt,p),h(Xe,t,p),x(t,Et,p),x(t,z,p),h(Ye,z,null),o(z,is),o(z,Zt),o(z,ls),o(z,X),h(De,X,null),o(X,ds),o(X,Ct),o(X,ms),h(ue,X,null),x(t,St,p),h(Ee,t,p),x(t,Qt,p),x(t,Bt,p),Pt=!0},p(t,[p]){const Se={};p&2&&(Se.$$scope={dirty:p,ctx:t}),O.$set(Se);const $={};p&2&&($.$$scope={dirty:p,ctx:t}),K.$set($);const Qe={};p&2&&(Qe.$$scope={dirty:p,ctx:t}),te.$set(Qe);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:t}),oe.$set(Pe);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:t}),se.$set(Le);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:t}),ae.$set(qe);const Ae={};p&2&&(Ae.$$scope={dirty:p,ctx:t}),le.$set(Ae);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:t}),de.$set(Oe);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:t}),ce.$set(Ke);const F={};p&2&&(F.$$scope={dirty:p,ctx:t}),pe.$set(F);const et={};p&2&&(et.$$scope={dirty:p,ctx:t}),fe.$set(et);const G={};p&2&&(G.$$scope={dirty:p,ctx:t}),ue.$set(G)},i(t){Pt||(g(c.$$.fragment,t),g(ye.$$.fragment,t),g(_e.$$.fragment,t),g(ve.$$.fragment,t),g(xe.$$.fragment,t),g(we.$$.fragment,t),g($e.$$.fragment,t),g(Te.$$.fragment,t),g(Ue.$$.fragment,t),g(Je.$$.fragment,t),g(je.$$.fragment,t),g(O.$$.fragment,t),g(K.$$.fragment,t),g(ke.$$.fragment,t),g(Ze.$$.fragment,t),g(te.$$.fragment,t),g(oe.$$.fragment,t),g(se.$$.fragment,t),g(Ce.$$.fragment,t),g(Ge.$$.fragment,t),g(ae.$$.fragment,t),g(Ie.$$.fragment,t),g(Fe.$$.fragment,t),g(We.$$.fragment,t),g(Be.$$.fragment,t),g(Ve.$$.fragment,t),g(le.$$.fragment,t),g(de.$$.fragment,t),g(Re.$$.fragment,t),g(ze.$$.fragment,t),g(ce.$$.fragment,t),g(Ne.$$.fragment,t),g(pe.$$.fragment,t),g(He.$$.fragment,t),g(fe.$$.fragment,t),g(Xe.$$.fragment,t),g(Ye.$$.fragment,t),g(De.$$.fragment,t),g(ue.$$.fragment,t),g(Ee.$$.fragment,t),Pt=!0)},o(t){b(c.$$.fragment,t),b(ye.$$.fragment,t),b(_e.$$.fragment,t),b(ve.$$.fragment,t),b(xe.$$.fragment,t),b(we.$$.fragment,t),b($e.$$.fragment,t),b(Te.$$.fragment,t),b(Ue.$$.fragment,t),b(Je.$$.fragment,t),b(je.$$.fragment,t),b(O.$$.fragment,t),b(K.$$.fragment,t),b(ke.$$.fragment,t),b(Ze.$$.fragment,t),b(te.$$.fragment,t),b(oe.$$.fragment,t),b(se.$$.fragment,t),b(Ce.$$.fragment,t),b(Ge.$$.fragment,t),b(ae.$$.fragment,t),b(Ie.$$.fragment,t),b(Fe.$$.fragment,t),b(We.$$.fragment,t),b(Be.$$.fragment,t),b(Ve.$$.fragment,t),b(le.$$.fragment,t),b(de.$$.fragment,t),b(Re.$$.fragment,t),b(ze.$$.fragment,t),b(ce.$$.fragment,t),b(Ne.$$.fragment,t),b(pe.$$.fragment,t),b(He.$$.fragment,t),b(fe.$$.fragment,t),b(Xe.$$.fragment,t),b(Ye.$$.fragment,t),b(De.$$.fragment,t),b(ue.$$.fragment,t),b(Ee.$$.fragment,t),Pt=!1},d(t){t&&(d(w),d(m),d(n),d(e),d(y),d(zt),d(Me),d(Nt),d(Ht),d(v),d(Xt),d(Yt),d(j),d(Dt),d(Et),d(z),d(St),d(Qt),d(Bt)),d(s),M(c,t),M(ye,t),M(_e),M(ve),M(xe),M(we),M($e),M(Te),M(Ue),M(Je),M(je),M(O),M(K),M(ke),M(Ze),M(te),M(oe),M(se),M(Ce),M(Ge),M(ae),M(Ie),M(Fe),M(We,t),M(Be),M(Ve),M(le),M(de),M(Re),M(ze),M(ce),M(Ne),M(pe),M(He),M(fe),M(Xe,t),M(Ye),M(De),M(ue),M(Ee,t)}}}const hn='{"title":"Models","local":"models","sections":[{"title":"ModelMixin","local":"diffusers.ModelMixin","sections":[],"depth":2},{"title":"FlaxModelMixin","local":"diffusers.FlaxModelMixin","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2}],"depth":1}';function gn(T){return Ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $n extends Ls{constructor(s){super(),qs(this,s,gn,un,Qs,{})}}export{$n as component};
