import{s as wl,n as fl,o as kl}from"../chunks/scheduler.5c93273d.js";import{S as hl,i as bl,g as p,s as a,r as c,A as Al,h as M,f as e,c as n,j as yl,u as j,x as o,k as ul,y as _l,a as t,v as U,d as m,t as T,w as r}from"../chunks/index.e43dd92b.js";import{C as nl}from"../chunks/CodeBlock.6896320e.js";import{H as pl,E as Cl}from"../chunks/getInferenceSnippets.22672bbf.js";function Bl(Ml){let i,v,S,N,J,x,d,ol="<code>LoopSequentialPipelineBlocks</code> 是一种多块类型，它将其他 <code>ModularPipelineBlocks</code> 以循环方式组合在一起。数据循环流动，使用 <code>intermediate_inputs</code> 和 <code>intermediate_outputs</code>，并且每个块都是迭代运行的。这通常用于创建一个默认是迭代的去噪循环。",V,y,il="本指南向您展示如何创建 <code>LoopSequentialPipelineBlocks</code>。",X,u,Z,w,cl="<code>LoopSequentialPipelineBlocks</code>，也被称为 <em>循环包装器</em>，因为它定义了循环结构、迭代变量和配置。在循环包装器内，您需要以下变量。",H,f,jl="<li><code>loop_inputs</code> 是用户提供的值，等同于 <code>inputs</code>。</li> <li><code>loop_intermediate_inputs</code> 是来自 <code>PipelineState</code> 的中间变量，等同于 <code>~modular_pipelines.ModularPipelineBlocks.intermediate_inputs</code>。</li> <li><code>loop_intermediate_outputs</code> 是由块创建并添加到 <code>PipelineState</code> 的新中间变量。它等同于 <code>intermediate_outputs</code>。</li> <li><code>__call__</code> 方法定义了循环结构和迭代逻辑。</li>",L,k,g,h,Ul="循环包装器可以传递额外的参数，如当前迭代索引，到循环块。",q,b,O,A,ml="循环块是一个 <code>ModularPipelineBlocks</code>，但 <code>__call__</code> 方法的行为不同。",P,_,Tl="<li>它从循环包装器。</li> <li>它直接与<code>BlockState</code>一起工作，而不是<code>PipelineState</code>。</li> <li>它不需要检索或更新<code>BlockState</code>。</li>",F,C,rl="循环块共享相同的<code>BlockState</code>，以允许值在循环的每次迭代中累积和变化。",z,B,W,I,D,Q,Jl="使用<code>from_blocks_dict()</code>方法将循环块添加到循环包装器中，以创建<code>LoopSequentialPipelineBlocks</code>。",K,$,ll,E,dl="添加更多的循环块以在每次迭代中运行，使用<code>from_blocks_dict()</code>。这允许您在不改变循环逻辑本身的情况下修改块。",sl,R,el,G,tl,Y,al;return J=new pl({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h1"}}),u=new pl({props:{title:"循环包装器",local:"循环包装器",headingTag:"h2"}}),k=new nl({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyUyQyUyME1vZHVsYXJQaXBlbGluZUJsb2NrcyUyQyUyMElucHV0UGFyYW0lMkMlMjBPdXRwdXRQYXJhbSUwQSUwQWNsYXNzJTIwTG9vcFdyYXBwZXIoTG9vcFNlcXVlbnRpYWxQaXBlbGluZUJsb2NrcyklM0ElMEElMjAlMjAlMjAlMjBtb2RlbF9uYW1lJTIwJTNEJTIwJTIydGVzdCUyMiUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwZGVzY3JpcHRpb24oc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlMjJJJ20lMjBhJTIwbG9vcCEhJTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBsb29wX2lucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMCU1QklucHV0UGFyYW0obmFtZSUzRCUyMm51bV9zdGVwcyUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDB0b3JjaC5ub19ncmFkKCklMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMHN0YXRlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX3N0YXRlJTIwJTNEJTIwc2VsZi5nZXRfYmxvY2tfc3RhdGUoc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJUU1JUJFJUFBJUU3JThFJUFGJUU3JUJCJTkzJUU2JTlFJTg0JTIwLSUyMCVFNSU4RiVBRiVFNCVCQiVBNSVFNiVBMCVCOSVFNiU4RCVBRSVFNiU4MiVBOCVFNyU5QSU4NCVFOSU5QyU4MCVFNiVCMSU4MiVFNSVBRSU5QSVFNSU4OCVCNiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKGJsb2NrX3N0YXRlLm51bV9zdGVwcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb29wX3N0ZXAlMjAlRTYlOEMlODklRTklQTElQkElRTUlQkElOEYlRTYlODklQTclRTglQTElOEMlRTYlODklODAlRTYlOUMlODklRTYlQjMlQTglRTUlODYlOEMlRTclOUElODQlRTUlOUQlOTclMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmxvb3Bfc3RlcChjb21wb25lbnRzJTJDJTIwYmxvY2tfc3RhdGUlMkMlMjBpJTNEaSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLnNldF9ibG9ja19zdGF0ZShzdGF0ZSUyQyUyMGJsb2NrX3N0YXRlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> LoopSequentialPipelineBlocks, ModularPipelineBlocks, InputParam, OutputParam

<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopWrapper</span>(<span class="hljs-title class_ inherited__">LoopSequentialPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;I&#x27;m a loop!!&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">loop_inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;num_steps&quot;</span>)]
<span class="hljs-meta">    @torch.no_grad()</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
        block_state = self.get_block_state(state)
        <span class="hljs-comment"># 循环结构 - 可以根据您的需求定制</span>
        <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(block_state.num_steps):
            <span class="hljs-comment"># loop_step 按顺序执行所有注册的块</span>
            components, block_state = self.loop_step(components, block_state, i=i)
        self.set_block_state(state, block_state)
        <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),b=new pl({props:{title:"循环块",local:"循环块",headingTag:"h2"}}),B=new nl({props:{code:"Y2xhc3MlMjBMb29wQmxvY2soTW9kdWxhclBpcGVsaW5lQmxvY2tzKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsX25hbWUlMjAlM0QlMjAlMjJ0ZXN0JTIyJTBBJTIwJTIwJTIwJTIwJTQwcHJvcGVydHklMEElMjAlMjAlMjAlMjBkZWYlMjBpbnB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJJbnB1dFBhcmFtKG5hbWUlM0QlMjJ4JTIyKSU1RCUwQSUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwZGVmJTIwaW50ZXJtZWRpYXRlX291dHB1dHMoc2VsZiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAlRTglQkYlOTklRTQlQjglQUElRTUlOUQlOTclRTQlQkElQTclRTclOTQlOUYlRTclOUElODQlRTglQkUlOTMlRTUlODclQkElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlNUJPdXRwdXRQYXJhbShuYW1lJTNEJTIyeCUyMiklNUQlMEElMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMGRlZiUyMGRlc2NyaXB0aW9uKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTIyJUU2JTg4JTkxJUU2JTk4JUFGJUU0JUI4JTgwJUU0JUI4JUFBJUU1JTlDJUE4JTYwTG9vcFdyYXBwZXIlNjAlRTclQjElQkIlRTUlODYlODUlRTklODMlQTglRTQlQkQlQkYlRTclOTQlQTglRTclOUElODQlRTUlOUQlOTclMjIlMEElMjAlMjAlMjAlMjBkZWYlMjBfX2NhbGxfXyhzZWxmJTJDJTIwY29tcG9uZW50cyUyQyUyMGJsb2NrX3N0YXRlJTJDJTIwaSUzQSUyMGludCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19zdGF0ZS54JTIwJTJCJTNEJTIwMSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGNvbXBvbmVudHMlMkMlMjBibG9ja19zdGF0ZQ==",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">LoopBlock</span>(<span class="hljs-title class_ inherited__">ModularPipelineBlocks</span>):
    model_name = <span class="hljs-string">&quot;test&quot;</span>
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> [InputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
        <span class="hljs-comment"># 这个块产生的输出</span>
        <span class="hljs-keyword">return</span> [OutputParam(name=<span class="hljs-string">&quot;x&quot;</span>)]
<span class="hljs-meta">    @property</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;我是一个在\`LoopWrapper\`类内部使用的块&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, block_state, i: <span class="hljs-built_in">int</span></span>):
        block_state.x += <span class="hljs-number">1</span>
        <span class="hljs-keyword">return</span> components, block_state`,wrap:!1}}),I=new pl({props:{title:"LoopSequentialPipelineBlocks",local:"loopsequentialpipelineblocks",headingTag:"h2"}}),$=new nl({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrJTdEKQ==",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock})',wrap:!1}}),R=new nl({props:{code:"bG9vcCUyMCUzRCUyMExvb3BXcmFwcGVyLmZyb21fYmxvY2tzX2RpY3QoJTdCJTIyYmxvY2sxJTIyJTNBJTIwTG9vcEJsb2NrKCklMkMlMjAlMjJibG9jazIlMjIlM0ElMjBMb29wQmxvY2slN0Qp",highlighted:'loop = LoopWrapper.from_blocks_dict({<span class="hljs-string">&quot;block1&quot;</span>: LoopBlock(), <span class="hljs-string">&quot;block2&quot;</span>: LoopBlock})',wrap:!1}}),G=new Cl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/zh/modular_diffusers/loop_sequential_pipeline_blocks.md"}}),{c(){i=p("meta"),v=a(),S=p("p"),N=a(),c(J.$$.fragment),x=a(),d=p("p"),d.innerHTML=ol,V=a(),y=p("p"),y.innerHTML=il,X=a(),c(u.$$.fragment),Z=a(),w=p("p"),w.innerHTML=cl,H=a(),f=p("ul"),f.innerHTML=jl,L=a(),c(k.$$.fragment),g=a(),h=p("p"),h.textContent=Ul,q=a(),c(b.$$.fragment),O=a(),A=p("p"),A.innerHTML=ml,P=a(),_=p("ul"),_.innerHTML=Tl,F=a(),C=p("p"),C.innerHTML=rl,z=a(),c(B.$$.fragment),W=a(),c(I.$$.fragment),D=a(),Q=p("p"),Q.innerHTML=Jl,K=a(),c($.$$.fragment),ll=a(),E=p("p"),E.innerHTML=dl,sl=a(),c(R.$$.fragment),el=a(),c(G.$$.fragment),tl=a(),Y=p("p"),this.h()},l(l){const s=Al("svelte-u9bgzb",document.head);i=M(s,"META",{name:!0,content:!0}),s.forEach(e),v=n(l),S=M(l,"P",{}),yl(S).forEach(e),N=n(l),j(J.$$.fragment,l),x=n(l),d=M(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-1nq98f"&&(d.innerHTML=ol),V=n(l),y=M(l,"P",{"data-svelte-h":!0}),o(y)!=="svelte-w57vj0"&&(y.innerHTML=il),X=n(l),j(u.$$.fragment,l),Z=n(l),w=M(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-dkpdu7"&&(w.innerHTML=cl),H=n(l),f=M(l,"UL",{"data-svelte-h":!0}),o(f)!=="svelte-b3mxxd"&&(f.innerHTML=jl),L=n(l),j(k.$$.fragment,l),g=n(l),h=M(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-ei0hxj"&&(h.textContent=Ul),q=n(l),j(b.$$.fragment,l),O=n(l),A=M(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1xvtemk"&&(A.innerHTML=ml),P=n(l),_=M(l,"UL",{"data-svelte-h":!0}),o(_)!=="svelte-ncxq9e"&&(_.innerHTML=Tl),F=n(l),C=M(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1mh9h4f"&&(C.innerHTML=rl),z=n(l),j(B.$$.fragment,l),W=n(l),j(I.$$.fragment,l),D=n(l),Q=M(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-otwhdq"&&(Q.innerHTML=Jl),K=n(l),j($.$$.fragment,l),ll=n(l),E=M(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-arh6gb"&&(E.innerHTML=dl),sl=n(l),j(R.$$.fragment,l),el=n(l),j(G.$$.fragment,l),tl=n(l),Y=M(l,"P",{}),yl(Y).forEach(e),this.h()},h(){ul(i,"name","hf:doc:metadata"),ul(i,"content",Il)},m(l,s){_l(document.head,i),t(l,v,s),t(l,S,s),t(l,N,s),U(J,l,s),t(l,x,s),t(l,d,s),t(l,V,s),t(l,y,s),t(l,X,s),U(u,l,s),t(l,Z,s),t(l,w,s),t(l,H,s),t(l,f,s),t(l,L,s),U(k,l,s),t(l,g,s),t(l,h,s),t(l,q,s),U(b,l,s),t(l,O,s),t(l,A,s),t(l,P,s),t(l,_,s),t(l,F,s),t(l,C,s),t(l,z,s),U(B,l,s),t(l,W,s),U(I,l,s),t(l,D,s),t(l,Q,s),t(l,K,s),U($,l,s),t(l,ll,s),t(l,E,s),t(l,sl,s),U(R,l,s),t(l,el,s),U(G,l,s),t(l,tl,s),t(l,Y,s),al=!0},p:fl,i(l){al||(m(J.$$.fragment,l),m(u.$$.fragment,l),m(k.$$.fragment,l),m(b.$$.fragment,l),m(B.$$.fragment,l),m(I.$$.fragment,l),m($.$$.fragment,l),m(R.$$.fragment,l),m(G.$$.fragment,l),al=!0)},o(l){T(J.$$.fragment,l),T(u.$$.fragment,l),T(k.$$.fragment,l),T(b.$$.fragment,l),T(B.$$.fragment,l),T(I.$$.fragment,l),T($.$$.fragment,l),T(R.$$.fragment,l),T(G.$$.fragment,l),al=!1},d(l){l&&(e(v),e(S),e(N),e(x),e(d),e(V),e(y),e(X),e(Z),e(w),e(H),e(f),e(L),e(g),e(h),e(q),e(O),e(A),e(P),e(_),e(F),e(C),e(z),e(W),e(D),e(Q),e(K),e(ll),e(E),e(sl),e(el),e(tl),e(Y)),e(i),r(J,l),r(u,l),r(k,l),r(b,l),r(B,l),r(I,l),r($,l),r(R,l),r(G,l)}}}const Il='{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[{"title":"循环包装器","local":"循环包装器","sections":[],"depth":2},{"title":"循环块","local":"循环块","sections":[],"depth":2},{"title":"LoopSequentialPipelineBlocks","local":"loopsequentialpipelineblocks","sections":[],"depth":2}],"depth":1}';function Ql(Ml){return kl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends hl{constructor(i){super(),bl(this,i,Ql,Bl,wl,{})}}export{Sl as component};
