import{s as Gl,o as gl,n as ml}from"../chunks/scheduler.8c3d61f6.js";import{S as Bl,i as Il,g as d,s as m,r as b,A as Wl,h as u,f as t,c,j as Ul,u as h,x as f,k as jl,y as _l,a as n,v as T,d as w,t as U,w as j}from"../chunks/index.da70eac4.js";import{T as vl}from"../chunks/Tip.1d9b8c37.js";import{C as il}from"../chunks/CodeBlock.a9c4becf.js";import{H as pl,E as Xl}from"../chunks/getInferenceSnippets.725ed3d4.js";import{H as Vl,a as Zl}from"../chunks/HfOption.6c3b4e77.js";function Cl(Z){let a,y='Check the <a href="./fp16#torchcompile">torch.compile</a> guide to learn more about compilation and how they can be applied here. For example, regional compilation can significantly reduce compilation time without giving up any speedups.';return{c(){a=d("p"),a.innerHTML=y},l(i){a=u(i,"P",{"data-svelte-h":!0}),f(a)!=="svelte-l8cm9r"&&(a.innerHTML=y)},m(i,p){n(i,a,p)},p:ml,d(i){i&&t(a)}}}function Yl(Z){let a,y='<a href="./memory#model-offloading">Model CPU offloading</a> moves an individual pipeline component, like the transformer model, to the GPU when it is needed for computation. Otherwise, it is offloaded to the CPU.',i,p,s;return p=new il({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhY2hlX3NpemVfbGltaXQlMjAlM0QlMjAxMDAwJTBBdG9yY2guX2R5bmFtby5jb25maWcuY2FwdHVyZV9keW5hbWljX291dHB1dF9zaGFwZV9vcHMlMjAlM0QlMjBUcnVlJTBBJTBBJTIzJTIwcXVhbnRpemUlMEFwaXBlbGluZV9xdWFudF9jb25maWclMjAlM0QlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyglMEElMjAlMjAlMjAlMjBxdWFudF9iYWNrZW5kJTNEJTIyYml0c2FuZGJ5dGVzXzRiaXQlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudF9rd2FyZ3MlM0QlN0IlMjJsb2FkX2luXzRiaXQlMjIlM0ElMjBUcnVlJTJDJTIwJTIyYm5iXzRiaXRfcXVhbnRfdHlwZSUyMiUzQSUyMCUyMm5mNCUyMiUyQyUyMCUyMmJuYl80Yml0X2NvbXB1dGVfZHR5cGUlMjIlM0ElMjB0b3JjaC5iZmxvYXQxNiU3RCUyQyUwQSUyMCUyMCUyMCUyMGNvbXBvbmVudHNfdG9fcXVhbnRpemUlM0QlNUIlMjJ0cmFuc2Zvcm1lciUyMiUyQyUyMCUyMnRleHRfZW5jb2Rlcl8yJTIyJTVEJTJDJTBBKSUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmJsYWNrLWZvcmVzdC1sYWJzJTJGRkxVWC4xLWRldiUyMiUyQyUwQSUyMCUyMCUyMCUyMHF1YW50aXphdGlvbl9jb25maWclM0RwaXBlbGluZV9xdWFudF9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMG1vZGVsJTIwQ1BVJTIwb2ZmbG9hZGluZyUwQXBpcGVsaW5lLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgpJTBBJTBBJTIzJTIwY29tcGlsZSUwQXBpcGVsaW5lLnRyYW5zZm9ybWVyLmNvbXBpbGUoKSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMmNpbmVtYXRpYyUyMGZpbG0lMjBzdGlsbCUyMG9mJTIwYSUyMGNhdCUyMHNpcHBpbmclMjBhJTIwbWFyZ2FyaXRhJTIwaW4lMjBhJTIwcG9vbCUyMGluJTIwUGFsbSUyMFNwcmluZ3MlMkMlMjBDYWxpZm9ybmlhJTJDJTIwaGlnaGx5JTIwZGV0YWlsZWQlMkMlMjBoaWdoJTIwYnVkZ2V0JTIwaG9sbHl3b29kJTIwbW92aWUlMkMlMjBjaW5lbWFzY29wZSUyQyUyMG1vb2R5JTJDJTIwZXBpYyUyQyUyMGdvcmdlb3VzJTJDJTIwZmlsbSUyMGdyYWluJTIyJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># model CPU offloading</span>
pipeline.enable_model_cpu_offload()

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()
pipeline(
    <span class="hljs-string">&quot;cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California, highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){a=d("p"),a.innerHTML=y,i=m(),b(p.$$.fragment)},l(o){a=u(o,"P",{"data-svelte-h":!0}),f(a)!=="svelte-2htktv"&&(a.innerHTML=y),i=c(o),h(p.$$.fragment,o)},m(o,M){n(o,a,M),n(o,i,M),T(p,o,M),s=!0},p:ml,i(o){s||(w(p.$$.fragment,o),s=!0)},o(o){U(p.$$.fragment,o),s=!1},d(o){o&&(t(a),t(i)),j(p,o)}}}function Rl(Z){let a,y='<a href="./memory#group-offloading">Group offloading</a> moves the internal layers of an individual pipeline component, like the transformer model, to the GPU for computation and offloads it when it’s not required. At the same time, it uses the <a href="./memory#cuda-stream">CUDA stream</a> feature to prefetch the next layer for execution.',i,p,s="By overlapping computation and data transfer, it is faster than model CPU offloading while also saving memory.",o,M,G;return M=new il({props:{code:"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",highlighted:`<span class="hljs-comment"># pip install ftfy</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel, DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.hooks <span class="hljs-keyword">import</span> apply_group_offloading
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_video
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> UMT5EncoderModel

torch._dynamo.config.cache_size_limit = <span class="hljs-number">1000</span>
torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder&quot;</span>],
)

text_encoder = UMT5EncoderModel.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;Wan-AI/Wan2.1-T2V-14B-Diffusers&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># group offloading</span>
onload_device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>)
offload_device = torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)

pipeline.transformer.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
pipeline.vae.enable_group_offload(
    onload_device=onload_device,
    offload_device=offload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)
apply_group_offloading(
    pipeline.text_encoder,
    onload_device=onload_device,
    offload_type=<span class="hljs-string">&quot;leaf_level&quot;</span>,
    use_stream=<span class="hljs-literal">True</span>,
    non_blocking=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># compile</span>
pipeline.transformer.<span class="hljs-built_in">compile</span>()

prompt = <span class="hljs-string">&quot;&quot;&quot;
The camera rushes from far to near in a low-angle shot, 
revealing a white ferret on a log. It plays, leaps into the water, and emerges, as the camera zooms in 
for a close-up. Water splashes berry bushes nearby, while moss, snow, and leaves blanket the ground. 
Birch trees and a light blue sky frame the scene, with ferns in the foreground. Side lighting casts dynamic 
shadows and warm highlights. Medium composition, front view, low angle, with depth of field.
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;&quot;&quot;
Bright tones, overexposed, static, blurred details, subtitles, style, works, paintings, images, static, overall gray, worst quality, 
low quality, JPEG compression residue, ugly, incomplete, extra fingers, poorly drawn hands, poorly drawn faces, deformed, disfigured, 
misshapen limbs, fused fingers, still picture, messy background, three legs, many people in the background, walking backwards
&quot;&quot;&quot;</span>

output = pipeline(
    prompt=prompt,
    negative_prompt=negative_prompt,
    num_frames=<span class="hljs-number">81</span>,
    guidance_scale=<span class="hljs-number">5.0</span>,
).frames[<span class="hljs-number">0</span>]
export_to_video(output, <span class="hljs-string">&quot;output.mp4&quot;</span>, fps=<span class="hljs-number">16</span>)`,wrap:!1}}),{c(){a=d("p"),a.innerHTML=y,i=m(),p=d("p"),p.textContent=s,o=m(),b(M.$$.fragment)},l(r){a=u(r,"P",{"data-svelte-h":!0}),f(a)!=="svelte-h38yli"&&(a.innerHTML=y),i=c(r),p=u(r,"P",{"data-svelte-h":!0}),f(p)!=="svelte-1f0mtjr"&&(p.textContent=s),o=c(r),h(M.$$.fragment,r)},m(r,J){n(r,a,J),n(r,i,J),n(r,p,J),n(r,o,J),T(M,r,J),G=!0},p:ml,i(r){G||(w(M.$$.fragment,r),G=!0)},o(r){U(M.$$.fragment,r),G=!1},d(r){r&&(t(a),t(i),t(p),t(o)),j(M,r)}}}function kl(Z){let a,y,i,p;return a=new Zl({props:{id:"offloading",option:"model CPU offloading",$$slots:{default:[Yl]},$$scope:{ctx:Z}}}),i=new Zl({props:{id:"offloading",option:"group offloading",$$slots:{default:[Rl]},$$scope:{ctx:Z}}}),{c(){b(a.$$.fragment),y=m(),b(i.$$.fragment)},l(s){h(a.$$.fragment,s),y=c(s),h(i.$$.fragment,s)},m(s,o){T(a,s,o),n(s,y,o),T(i,s,o),p=!0},p(s,o){const M={};o&2&&(M.$$scope={dirty:o,ctx:s}),a.$set(M);const G={};o&2&&(G.$$scope={dirty:o,ctx:s}),i.$set(G)},i(s){p||(w(a.$$.fragment,s),w(i.$$.fragment,s),p=!0)},o(s){U(a.$$.fragment,s),U(i.$$.fragment,s),p=!1},d(s){s&&t(y),j(a,s),j(i,s)}}}function ql(Z){let a,y,i,p,s,o,M,G='Optimizing models often involves trade-offs between <a href="./fp16">inference speed</a> and <a href="./memory">memory-usage</a>. For instance, while <a href="./cache">caching</a> can boost inference speed, it also increases memory consumption since it needs to store the outputs of intermediate attention layers. A more balanced optimization strategy combines quantizing a model, <a href="./fp16#torchcompile">torch.compile</a> and various <a href="./memory#offloading">offloading methods</a>.',r,J,E,B,cl='For image generation, combining quantization and <a href="./memory#model-offloading">model offloading</a> can often give the best trade-off between quality, speed, and memory. Group offloading is not as effective for image generation because it is usually not possible to <em>fully</em> overlap data transfer if the compute kernel finishes faster. This results in some communication overhead between the CPU and GPU.',x,I,rl='For video generation, combining quantization and <a href="./memory#group-offloading">group-offloading</a> tends to be better because video models are more compute-bound.',N,W,Ml="The table below provides a comparison of optimization strategy combinations and their impact on latency and memory-usage for Flux.",H,_,yl="<thead><tr><th>combination</th> <th>latency (s)</th> <th>memory-usage (GB)</th></tr></thead> <tbody><tr><td>quantization</td> <td>32.602</td> <td>14.9453</td></tr> <tr><td>quantization, torch.compile</td> <td>25.847</td> <td>14.9448</td></tr> <tr><td>quantization, torch.compile, model CPU offloading</td> <td>32.312</td> <td>12.2369</td></tr></tbody>",S,v,dl="These results are benchmarked on Flux with a RTX 4090. The transformer and text_encoder components are quantized. Refer to the [benchmarking script](https://gist.github.com/sayakpaul/0db9d8eeeb3d2a0e5ed7cf0d9ca19b7d) if you're interested in evaluating your own model.",A,X,ul='This guide will show you how to compile and offload a quantized model with <a href="../quantization/bitsandbytes#torchcompile">bitsandbytes</a>. Make sure you are using <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch nightly</a> and the latest version of bitsandbytes.',L,V,D,C,P,Y,fl='Start by <a href="../quantization/overview">quantizing</a> a model to reduce the memory required for storage and <a href="./fp16#torchcompile">compiling</a> it to accelerate inference.',K,R,Jl='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',O,k,ll,q,el,Q,bl="In addition to quantization and torch.compile, try offloading if you need to reduce memory-usage further. Offloading moves various layers or model components from the CPU to the GPU as needed for computations.",tl,F,hl='Configure the <a href="https://docs.pytorch.org/docs/stable/torch.compiler_dynamo_overview.html" rel="nofollow">Dynamo</a> <code>cache_size_limit</code> during offloading to avoid excessive recompilation and set <code>capture_dynamic_output_shape_ops = True</code> to handle dynamic outputs when compiling bitsandbytes models.',al,g,nl,z,sl,$,ol;return s=new pl({props:{title:"Compile and offloading quantized models",local:"compile-and-offloading-quantized-models",headingTag:"h1"}}),J=new vl({props:{warning:!1,$$slots:{default:[Cl]},$$scope:{ctx:Z}}}),V=new il({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwYml0c2FuZGJ5dGVz",highlighted:"pip install -U bitsandbytes",wrap:!1}}),C=new pl({props:{title:"Quantization and torch.compile",local:"quantization-and-torchcompile",headingTag:"h2"}}),k=new il({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnF1YW50aXplcnMlMjBpbXBvcnQlMjBQaXBlbGluZVF1YW50aXphdGlvbkNvbmZpZyUwQSUwQXRvcmNoLl9keW5hbW8uY29uZmlnLmNhcHR1cmVfZHluYW1pY19vdXRwdXRfc2hhcGVfb3BzJTIwJTNEJTIwVHJ1ZSUwQSUwQSUyMyUyMHF1YW50aXplJTBBcGlwZWxpbmVfcXVhbnRfY29uZmlnJTIwJTNEJTIwUGlwZWxpbmVRdWFudGl6YXRpb25Db25maWcoJTBBJTIwJTIwJTIwJTIwcXVhbnRfYmFja2VuZCUzRCUyMmJpdHNhbmRieXRlc180Yml0JTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRfa3dhcmdzJTNEJTdCJTIybG9hZF9pbl80Yml0JTIyJTNBJTIwVHJ1ZSUyQyUyMCUyMmJuYl80Yml0X3F1YW50X3R5cGUlMjIlM0ElMjAlMjJuZjQlMjIlMkMlMjAlMjJibmJfNGJpdF9jb21wdXRlX2R0eXBlJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlN0QlMkMlMEElMjAlMjAlMjAlMjBjb21wb25lbnRzX3RvX3F1YW50aXplJTNEJTVCJTIydHJhbnNmb3JtZXIlMjIlMkMlMjAlMjJ0ZXh0X2VuY29kZXJfMiUyMiU1RCUyQyUwQSklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcGlwZWxpbmVfcXVhbnRfY29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEElMjMlMjBjb21waWxlJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTBBcGlwZWxpbmUudHJhbnNmb3JtZXIuY29tcGlsZShtb2RlJTNEJTIybWF4LWF1dG90dW5lJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSklMEFwaXBlbGluZSglMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBjaW5lbWF0aWMlMjBmaWxtJTIwc3RpbGwlMjBvZiUyMGElMjBjYXQlMjBzaXBwaW5nJTIwYSUyMG1hcmdhcml0YSUyMGluJTIwYSUyMHBvb2wlMjBpbiUyMFBhbG0lMjBTcHJpbmdzJTJDJTIwQ2FsaWZvcm5pYSUwQSUyMCUyMCUyMCUyMGhpZ2hseSUyMGRldGFpbGVkJTJDJTIwaGlnaCUyMGJ1ZGdldCUyMGhvbGx5d29vZCUyMG1vdmllJTJDJTIwY2luZW1hc2NvcGUlMkMlMjBtb29keSUyQyUyMGVwaWMlMkMlMjBnb3JnZW91cyUyQyUyMGZpbG0lMjBncmFpbiUwQSUyMiUyMiUyMiUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">from</span> diffusers.quantizers <span class="hljs-keyword">import</span> PipelineQuantizationConfig

torch._dynamo.config.capture_dynamic_output_shape_ops = <span class="hljs-literal">True</span>

<span class="hljs-comment"># quantize</span>
pipeline_quant_config = PipelineQuantizationConfig(
    quant_backend=<span class="hljs-string">&quot;bitsandbytes_4bit&quot;</span>,
    quant_kwargs={<span class="hljs-string">&quot;load_in_4bit&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;bnb_4bit_quant_type&quot;</span>: <span class="hljs-string">&quot;nf4&quot;</span>, <span class="hljs-string">&quot;bnb_4bit_compute_dtype&quot;</span>: torch.bfloat16},
    components_to_quantize=[<span class="hljs-string">&quot;transformer&quot;</span>, <span class="hljs-string">&quot;text_encoder_2&quot;</span>],
)
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>,
    quantization_config=pipeline_quant_config,
    torch_dtype=torch.bfloat16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># compile</span>
pipeline.transformer.to(memory_format=torch.channels_last)
pipeline.transformer.<span class="hljs-built_in">compile</span>(mode=<span class="hljs-string">&quot;max-autotune&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)
pipeline(<span class="hljs-string">&quot;&quot;&quot;
    cinematic film still of a cat sipping a margarita in a pool in Palm Springs, California
    highly detailed, high budget hollywood movie, cinemascope, moody, epic, gorgeous, film grain
&quot;&quot;&quot;</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),q=new pl({props:{title:"Quantization, torch.compile, and offloading",local:"quantization-torchcompile-and-offloading",headingTag:"h2"}}),g=new Vl({props:{id:"offloading",options:["model CPU offloading","group offloading"],$$slots:{default:[kl]},$$scope:{ctx:Z}}}),z=new Xl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/optimization/speed-memory-optims.md"}}),{c(){a=d("meta"),y=m(),i=d("p"),p=m(),b(s.$$.fragment),o=m(),M=d("p"),M.innerHTML=G,r=m(),b(J.$$.fragment),E=m(),B=d("p"),B.innerHTML=cl,x=m(),I=d("p"),I.innerHTML=rl,N=m(),W=d("p"),W.textContent=Ml,H=m(),_=d("table"),_.innerHTML=yl,S=m(),v=d("small"),v.textContent=dl,A=m(),X=d("p"),X.innerHTML=ul,L=m(),b(V.$$.fragment),D=m(),b(C.$$.fragment),P=m(),Y=d("p"),Y.innerHTML=fl,K=m(),R=d("p"),R.innerHTML=Jl,O=m(),b(k.$$.fragment),ll=m(),b(q.$$.fragment),el=m(),Q=d("p"),Q.textContent=bl,tl=m(),F=d("p"),F.innerHTML=hl,al=m(),b(g.$$.fragment),nl=m(),b(z.$$.fragment),sl=m(),$=d("p"),this.h()},l(l){const e=Wl("svelte-u9bgzb",document.head);a=u(e,"META",{name:!0,content:!0}),e.forEach(t),y=c(l),i=u(l,"P",{}),Ul(i).forEach(t),p=c(l),h(s.$$.fragment,l),o=c(l),M=u(l,"P",{"data-svelte-h":!0}),f(M)!=="svelte-xssjno"&&(M.innerHTML=G),r=c(l),h(J.$$.fragment,l),E=c(l),B=u(l,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1k9tg08"&&(B.innerHTML=cl),x=c(l),I=u(l,"P",{"data-svelte-h":!0}),f(I)!=="svelte-1gtsmte"&&(I.innerHTML=rl),N=c(l),W=u(l,"P",{"data-svelte-h":!0}),f(W)!=="svelte-1hx16oz"&&(W.textContent=Ml),H=c(l),_=u(l,"TABLE",{"data-svelte-h":!0}),f(_)!=="svelte-4braeo"&&(_.innerHTML=yl),S=c(l),v=u(l,"SMALL",{"data-svelte-h":!0}),f(v)!=="svelte-1epjjm"&&(v.textContent=dl),A=c(l),X=u(l,"P",{"data-svelte-h":!0}),f(X)!=="svelte-97u2df"&&(X.innerHTML=ul),L=c(l),h(V.$$.fragment,l),D=c(l),h(C.$$.fragment,l),P=c(l),Y=u(l,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-1blxhao"&&(Y.innerHTML=fl),K=c(l),R=u(l,"P",{"data-svelte-h":!0}),f(R)!=="svelte-xwvm0e"&&(R.innerHTML=Jl),O=c(l),h(k.$$.fragment,l),ll=c(l),h(q.$$.fragment,l),el=c(l),Q=u(l,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-2st498"&&(Q.textContent=bl),tl=c(l),F=u(l,"P",{"data-svelte-h":!0}),f(F)!=="svelte-136cwt1"&&(F.innerHTML=hl),al=c(l),h(g.$$.fragment,l),nl=c(l),h(z.$$.fragment,l),sl=c(l),$=u(l,"P",{}),Ul($).forEach(t),this.h()},h(){jl(a,"name","hf:doc:metadata"),jl(a,"content",Ql)},m(l,e){_l(document.head,a),n(l,y,e),n(l,i,e),n(l,p,e),T(s,l,e),n(l,o,e),n(l,M,e),n(l,r,e),T(J,l,e),n(l,E,e),n(l,B,e),n(l,x,e),n(l,I,e),n(l,N,e),n(l,W,e),n(l,H,e),n(l,_,e),n(l,S,e),n(l,v,e),n(l,A,e),n(l,X,e),n(l,L,e),T(V,l,e),n(l,D,e),T(C,l,e),n(l,P,e),n(l,Y,e),n(l,K,e),n(l,R,e),n(l,O,e),T(k,l,e),n(l,ll,e),T(q,l,e),n(l,el,e),n(l,Q,e),n(l,tl,e),n(l,F,e),n(l,al,e),T(g,l,e),n(l,nl,e),T(z,l,e),n(l,sl,e),n(l,$,e),ol=!0},p(l,[e]){const Tl={};e&2&&(Tl.$$scope={dirty:e,ctx:l}),J.$set(Tl);const wl={};e&2&&(wl.$$scope={dirty:e,ctx:l}),g.$set(wl)},i(l){ol||(w(s.$$.fragment,l),w(J.$$.fragment,l),w(V.$$.fragment,l),w(C.$$.fragment,l),w(k.$$.fragment,l),w(q.$$.fragment,l),w(g.$$.fragment,l),w(z.$$.fragment,l),ol=!0)},o(l){U(s.$$.fragment,l),U(J.$$.fragment,l),U(V.$$.fragment,l),U(C.$$.fragment,l),U(k.$$.fragment,l),U(q.$$.fragment,l),U(g.$$.fragment,l),U(z.$$.fragment,l),ol=!1},d(l){l&&(t(y),t(i),t(p),t(o),t(M),t(r),t(E),t(B),t(x),t(I),t(N),t(W),t(H),t(_),t(S),t(v),t(A),t(X),t(L),t(D),t(P),t(Y),t(K),t(R),t(O),t(ll),t(el),t(Q),t(tl),t(F),t(al),t(nl),t(sl),t($)),t(a),j(s,l),j(J,l),j(V,l),j(C,l),j(k,l),j(q,l),j(g,l),j(z,l)}}}const Ql='{"title":"Compile and offloading quantized models","local":"compile-and-offloading-quantized-models","sections":[{"title":"Quantization and torch.compile","local":"quantization-and-torchcompile","sections":[],"depth":2},{"title":"Quantization, torch.compile, and offloading","local":"quantization-torchcompile-and-offloading","sections":[],"depth":2}],"depth":1}';function Fl(Z){return gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sl extends Bl{constructor(a){super(),Il(this,a,Fl,ql,Gl,{})}}export{Sl as component};
