import{s as Go,o as Fo,n as V}from"../chunks/scheduler.8c3d61f6.js";import{S as Bo,i as No,g as l,s as i,r as h,A as Vo,h as d,f as r,c as s,j as S,u as _,x as f,k as T,y as n,a as m,v as b,d as y,t as v,w}from"../chunks/index.da70eac4.js";import{T as to}from"../chunks/Tip.1d9b8c37.js";import{D as P}from"../chunks/Docstring.c021b19a.js";import{C as Ye}from"../chunks/CodeBlock.a9c4becf.js";import{E as He}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as Ut,E as zo}from"../chunks/getInferenceSnippets.725ed3d4.js";function Eo(D){let o,M='Make sure to check out the Stable Diffusion <a href="overview#tips">Tips</a> section to learn how to explore the tradeoff between scheduler speed and quality, and how to reuse pipeline components efficiently!',c,a,u='If you’re interested in using one of the official checkpoints for a task, explore the <a href="https://huggingface.co/CompVis" rel="nofollow">CompVis</a>, <a href="https://huggingface.co/runwayml" rel="nofollow">Runway</a>, and <a href="https://huggingface.co/stabilityai" rel="nofollow">Stability AI</a> Hub organizations!';return{c(){o=l("p"),o.innerHTML=M,c=i(),a=l("p"),a.innerHTML=u},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1j961ct"&&(o.innerHTML=M),c=s(t),a=d(t,"P",{"data-svelte-h":!0}),f(a)!=="svelte-z4pn9c"&&(a.innerHTML=u)},m(t,$){m(t,o,$),m(t,c,$),m(t,a,$)},p:V,d(t){t&&(r(o),r(c),r(a))}}}function Ro(D){let o,M="Examples:",c,a,u;return a=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function Xo(D){let o,M=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=l("p"),o.innerHTML=M},l(c){o=d(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-ackzsn"&&(o.innerHTML=M)},m(c,a){m(c,o,a)},p:V,d(c){c&&r(o)}}}function Ho(D){let o,M="Examples:",c,a,u;return a=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function Yo(D){let o,M=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=l("p"),o.textContent=M},l(c){o=d(c,"P",{"data-svelte-h":!0}),f(o)!=="svelte-17p1lpg"&&(o.textContent=M)},m(c,a){m(c,o,a)},p:V,d(c){c&&r(o)}}}function Ao(D){let o,M="Examples:",c,a,u;return a=new Ye({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function qo(D){let o,M="To load a Textual Inversion embedding vector in 🤗 Diffusers format:",c,a,u;return a=new Ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMnNkLWNvbmNlcHRzLWxpYnJhcnklMkZjYXQtdG95JTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjAlM0NjYXQtdG95JTNFJTIwYmFja3BhY2slMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjYXQtYmFja3BhY2sucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>)

prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; backpack&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;cat-backpack.png&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-1gc783q"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function Qo(D){let o,M="locally:",c,a,u;return a=new Ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcGlwZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIlMkMlMjB0b2tlbiUzRCUyMmNoYXJ0dXJuZXJ2MiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJjaGFydHVybmVydjIlMkMlMjBtdWx0aXBsZSUyMHZpZXdzJTIwb2YlMjB0aGUlMjBzYW1lJTIwY2hhcmFjdGVyJTIwaW4lMjB0aGUlMjBzYW1lJTIwb3V0Zml0JTJDJTIwYSUyMGNoYXJhY3RlciUyMHR1cm5hcm91bmQlMjBvZiUyMGElMjB3b21hbiUyMHdlYXJpbmclMjBhJTIwYmxhY2slMjBqYWNrZXQlMjBhbmQlMjByZWQlMjBzaGlydCUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJjaGFyYWN0ZXIucG5nJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch

model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, token=<span class="hljs-string">&quot;charturnerv2&quot;</span>)

prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround of a woman wearing a black jacket and red shirt, best quality, intricate details.&quot;</span>

image = pipe(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;character.png&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-4c75kq"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function Oo(D){let o,M="Examples:",c,a,u;return a=new Ye({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGV2Fycmlvck1hbWE3NzclMkZPcmFuZ2VNaXhzJTJGYmxvYiUyRm1haW4lMkZNb2RlbHMlMkZBYnlzc09yYW5nZU1peCUyRkFieXNzT3JhbmdlTWl4LnNhZmV0ZW5zb3JzJTIyJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwbG9jYWwlMjBmaWxlJTBBJTIzJTIwZmlsZSUyMGlzJTIwZG93bmxvYWRlZCUyMHVuZGVyJTIwLiUyRnYxLTUtcHJ1bmVkLWVtYW9ubHkuY2twdCUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMjIuJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyKSUwQSUwQSUyMyUyMEVuYWJsZSUyMGZsb2F0MTYlMjBhbmQlMjBtb3ZlJTIwdG8lMjBHUFUlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fc2luZ2xlX2ZpbGUoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRmJsb2IlMkZtYWluJTJGdjEtNS1wcnVuZWQtZW1hb25seS5ja3B0JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQXBpcGVsaW5lLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/WarriorMama777/OrangeMixs/blob/main/Models/AbyssOrangeMix/AbyssOrangeMix.safetensors&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from local file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># file is downloaded under ./v1-5-pruned-emaonly.ckpt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(<span class="hljs-string">&quot;./v1-5-pruned-emaonly.ckpt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Enable float16 and move to GPU</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = StableDiffusionPipeline.from_single_file(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/v1-5-pruned-emaonly.ckpt&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function Ko(D){let o,M="Examples:",c,a,u;return a=new Ye({props:{code:"aW1wb3J0JTIwamF4JTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGZsYXguamF4X3V0aWxzJTIwaW1wb3J0JTIwcmVwbGljYXRlJTBBZnJvbSUyMGZsYXgudHJhaW5pbmcuY29tbW9uX3V0aWxzJTIwaW1wb3J0JTIwc2hhcmQlMEElMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRmxheFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMkMlMjBwYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJiZjE2JTIyJTJDJTIwZHR5cGUlM0RqYXgubnVtcHkuYmZsb2F0MTYlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uUFJOR0tleSgwKSUwQW51bV9pbmZlcmVuY2Vfc3RlcHMlMjAlM0QlMjA1MCUwQSUwQW51bV9zYW1wbGVzJTIwJTNEJTIwamF4LmRldmljZV9jb3VudCgpJTBBcHJvbXB0JTIwJTNEJTIwbnVtX3NhbXBsZXMlMjAqJTIwJTVCcHJvbXB0JTVEJTBBcHJvbXB0X2lkcyUyMCUzRCUyMHBpcGVsaW5lLnByZXBhcmVfaW5wdXRzKHByb21wdCklMEElMEFwYXJhbXMlMjAlM0QlMjByZXBsaWNhdGUocGFyYW1zKSUwQXBybmdfc2VlZCUyMCUzRCUyMGpheC5yYW5kb20uc3BsaXQocHJuZ19zZWVkJTJDJTIwamF4LmRldmljZV9jb3VudCgpKSUwQXByb21wdF9pZHMlMjAlM0QlMjBzaGFyZChwcm9tcHRfaWRzKSUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGVsaW5lKHByb21wdF9pZHMlMkMlMjBwYXJhbXMlMkMlMjBwcm5nX3NlZWQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTJDJTIwaml0JTNEVHJ1ZSkuaW1hZ2VzJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUubnVtcHlfdG9fcGlsKG5wLmFzYXJyYXkoaW1hZ2VzLnJlc2hhcGUoKG51bV9zYW1wbGVzJTJDKSUyMCUyQiUyMGltYWdlcy5zaGFwZSU1Qi0zJTNBJTVEKSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> jax
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jax.numpy.bfloat16
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>num_inference_steps = <span class="hljs-number">50</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>num_samples = jax.device_count()
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = num_samples * [prompt]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = pipeline.prepare_inputs(prompt)
<span class="hljs-comment"># shard inputs and rng</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>params = replicate(params)
<span class="hljs-meta">&gt;&gt;&gt; </span>prng_seed = jax.random.split(prng_seed, jax.device_count())
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_ids = shard(prompt_ids)

<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
<span class="hljs-meta">&gt;&gt;&gt; </span>images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),{c(){o=l("p"),o.textContent=M,c=i(),h(a.$$.fragment)},l(t){o=d(t,"P",{"data-svelte-h":!0}),f(o)!=="svelte-kvfsh7"&&(o.textContent=M),c=s(t),_(a.$$.fragment,t)},m(t,$){m(t,o,$),m(t,c,$),b(a,t,$),u=!0},p:V,i(t){u||(y(a.$$.fragment,t),u=!0)},o(t){v(a.$$.fragment,t),u=!1},d(t){t&&(r(o),r(c)),w(a,t)}}}function ei(D){let o,M,c,a,u,t,$,no='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',jt,fe,oo='The Stable Diffusion model was created by researchers and engineers from <a href="https://github.com/CompVis" rel="nofollow">CompVis</a>, <a href="https://stability.ai/" rel="nofollow">Stability AI</a>, <a href="https://github.com/runwayml" rel="nofollow">Runway</a>, and <a href="https://laion.ai/" rel="nofollow">LAION</a>. The <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> is capable of generating photorealistic images given any text input. It’s trained on 512x512 images from a subset of the LAION-5B dataset. This model uses a frozen CLIP ViT-L/14 text encoder to condition the model on text prompts. With its 860M UNet and 123M text encoder, the model is relatively lightweight and can run on consumer GPUs. Latent diffusion is the research on top of which Stable Diffusion was built. It was proposed in <a href="https://huggingface.co/papers/2112.10752" rel="nofollow">High-Resolution Image Synthesis with Latent Diffusion Models</a> by Robin Rombach, Andreas Blattmann, Dominik Lorenz, Patrick Esser, Björn Ommer.',Jt,me,io="The abstract from the paper is:",Ct,ue,so='<em>By decomposing the image formation process into a sequential application of denoising autoencoders, diffusion models (DMs) achieve state-of-the-art synthesis results on image data and beyond. Additionally, their formulation allows for a guiding mechanism to control the image generation process without retraining. However, since these models typically operate directly in pixel space, optimization of powerful DMs often consumes hundreds of GPU days and inference is expensive due to sequential evaluations. To enable DM training on limited computational resources while retaining their quality and flexibility, we apply them in the latent space of powerful pretrained autoencoders. In contrast to previous work, training diffusion models on such a representation allows for the first time to reach a near-optimal point between complexity reduction and detail preservation, greatly boosting visual fidelity. By introducing cross-attention layers into the model architecture, we turn diffusion models into powerful and flexible generators for general conditioning inputs such as text or bounding boxes and high-resolution synthesis becomes possible in a convolutional manner. Our latent diffusion models (LDMs) achieve a new state of the art for image inpainting and highly competitive performance on various tasks, including unconditional image generation, semantic scene synthesis, and super-resolution, while significantly reducing computational requirements compared to pixel-based DMs. Code is available at <a href="https://github.com/CompVis/latent-diffusion" rel="nofollow">https://github.com/CompVis/latent-diffusion</a>.</em>',It,R,Zt,ge,Wt,g,he,Qt,Ae,ao="Pipeline for text-to-image generation using Stable Diffusion.",Ot,qe,ro=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,Kt,Qe,lo="The pipeline also inherits the following loading methods:",en,Oe,po='<li><a href="/docs/diffusers/main/en/api/loaders/textual_inversion#diffusers.loaders.TextualInversionLoaderMixin.load_textual_inversion">load_textual_inversion()</a> for loading textual inversion embeddings</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_weights">load_lora_weights()</a> for loading LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.save_lora_weights">save_lora_weights()</a> for saving LoRA weights</li> <li><a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> for loading <code>.ckpt</code> files</li> <li><a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.load_ip_adapter">load_ip_adapter()</a> for loading IP Adapters</li>',tn,F,_e,nn,Ke,co="The call function to the pipeline for generation.",on,X,sn,J,be,an,et,fo=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,rn,H,ln,Y,dn,A,ye,pn,tt,mo=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,cn,q,ve,fn,nt,uo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,mn,Q,we,un,ot,go=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,gn,C,xe,hn,it,ho=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,_n,O,bn,K,yn,ee,$e,vn,st,_o='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',wn,te,Me,xn,at,bo=`Enable tiled VAE decoding. When this option is enabled, the VAE will split the input tensor into tiles to
compute decoding and encoding in several steps. This is useful for saving a large amount of memory and to allow
processing larger images.`,$n,ne,Te,Mn,rt,yo=`Disable tiled VAE decoding. If <code>enable_vae_tiling</code> was previously enabled, this method will go back to
computing decoding in one step.`,Tn,k,Se,Sn,lt,vo=`Load Textual Inversion embeddings into the text encoder of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> (both 🤗 Diffusers and
Automatic1111 formats are supported).`,Dn,dt,wo="Example:",Pn,oe,kn,pt,xo=`To load a Textual Inversion embedding vector in Automatic1111 format, make sure to download the vector first
(for example from <a href="https://civitai.com/models/3036?modelVersionId=9857" rel="nofollow">civitAI</a>) and then load the vector`,Un,ie,jn,B,De,Jn,ct,$o=`Instantiate a <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> from pretrained pipeline weights saved in the <code>.ckpt</code> or <code>.safetensors</code>
format. The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.`,Cn,se,In,U,Pe,Zn,ft,Mo=`Load LoRA weights specified in <code>pretrained_model_name_or_path_or_dict</code> into <code>self.unet</code> and
<code>self.text_encoder</code>.`,Wn,mt,To="All kwargs are forwarded to <code>self.lora_state_dict</code>.",Ln,ut,So=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a> for more details on how the state dict is
loaded.`,Gn,gt,Do=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_unet">load_lora_into_unet()</a> for more details on how the state dict is
loaded into <code>self.unet</code>.`,Fn,ht,Po=`See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.load_lora_into_text_encoder">load_lora_into_text_encoder()</a> for more details on how the state
dict is loaded into <code>self.text_encoder</code>.`,Bn,ae,ke,Nn,_t,ko="Save the LoRA parameters corresponding to the UNet and text encoder.",Vn,re,Ue,zn,bt,Uo="Encodes the prompt into text encoder hidden states.",En,le,je,Rn,yt,jo='See <a href="https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298" rel="nofollow">https://github.com/google-research/vdm/blob/dc27b98a554f65cdc654b800da5aa1846545d41b/model_vdm.py#L298</a>',Lt,Je,Gt,z,Ce,Xn,vt,Jo="Output class for Stable Diffusion pipelines.",Ft,Ie,Bt,j,Ze,Hn,wt,Co="Flax-based pipeline for text-to-image generation using Stable Diffusion.",Yn,xt,Io=`This model inherits from <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,An,N,We,qn,$t,Zo="The call function to the pipeline for generation.",Qn,de,Nt,Le,Vt,W,Ge,On,Mt,Wo="Output class for Flax-based Stable Diffusion pipelines.",Kn,pe,Fe,eo,Tt,Lo="Returns a new object replacing the specified fields with new values.",zt,Be,Et,kt,Rt;return u=new Ut({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h1"}}),R=new to({props:{$$slots:{default:[Eo]},$$scope:{ctx:D}}}),ge=new Ut({props:{title:"StableDiffusionPipeline",local:"diffusers.StableDiffusionPipeline",headingTag:"h2"}}),he=new P({props:{name:"class diffusers.StableDiffusionPipeline",anchor:"diffusers.StableDiffusionPipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"safety_checker",val:": StableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"image_encoder",val:": CLIPVisionModelWithProjection = None"},{name:"requires_safety_checker",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.StableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/main/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.StableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>StableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">model card</a> for
more details about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.StableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L154"}}),_e=new P({props:{name:"__call__",anchor:"diffusers.StableDiffusionPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": typing.List[int] = None"},{name:"sigmas",val:": typing.List[float] = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.Tensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"guidance_rescale",val:": float = 0.0"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, typing.Dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.StableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"diffusers.StableDiffusionPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://huggingface.co/papers/2010.02502" rel="nofollow">DDIM</a> paper. Only
applies to the <a href="/docs/diffusers/main/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.StableDiffusionPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusionPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput</code>, <em>optional</em>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusionPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusionPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusionPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.StableDiffusionPipeline.__call__.guidance_rescale",description:`<strong>guidance_rescale</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Guidance rescale factor from <a href="https://huggingface.co/papers/2305.08891" rel="nofollow">Common Diffusion Noise Schedules and Sample Steps are
Flawed</a>. Guidance rescale factor should fix overexposure when
using zero terminal SNR.`,name:"guidance_rescale"},{anchor:"diffusers.StableDiffusionPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <code>PipelineCallback</code>, <code>MultiPipelineCallbacks</code>, <em>optional</em>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusionPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L778",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),X=new He({props:{anchor:"diffusers.StableDiffusionPipeline.__call__.example",$$slots:{default:[Ro]},$$scope:{ctx:D}}}),be=new P({props:{name:"enable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1837"}}),H=new to({props:{warning:!0,$$slots:{default:[Xo]},$$scope:{ctx:D}}}),Y=new He({props:{anchor:"diffusers.StableDiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[Ho]},$$scope:{ctx:D}}}),ye=new P({props:{name:"disable_attention_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1877"}}),ve=new P({props:{name:"enable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2042"}}),we=new P({props:{name:"disable_vae_slicing",anchor:"diffusers.StableDiffusionPipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2049"}}),xe=new P({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1776"}}),O=new to({props:{warning:!0,$$slots:{default:[Yo]},$$scope:{ctx:D}}}),K=new He({props:{anchor:"diffusers.StableDiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[Ao]},$$scope:{ctx:D}}}),$e=new P({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.StableDiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1811"}}),Me=new P({props:{name:"enable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.enable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2056"}}),Te=new P({props:{name:"disable_vae_tiling",anchor:"diffusers.StableDiffusionPipeline.disable_vae_tiling",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2064"}}),Se=new P({props:{name:"load_textual_inversion",anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, typing.List[str], typing.Dict[str, torch.Tensor], typing.List[typing.Dict[str, torch.Tensor]]]"},{name:"token",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"tokenizer",val:": typing.Optional[ForwardRef('PreTrainedTokenizer')] = None"},{name:"text_encoder",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code> or <code>List[str or os.PathLike]</code> or <code>Dict</code> or <code>List[Dict]</code>) &#x2014;
Can be either one of the following or a list of them:</p>
<ul>
<li>A string, the <em>model id</em> (for example <code>sd-concepts-library/low-poly-hd-logos-icons</code>) of a
pretrained model hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_text_inversion_directory/</code>) containing the textual
inversion weights.</li>
<li>A path to a <em>file</em> (for example <code>./my_text_inversions.pt</code>) containing textual inversion weights.</li>
<li>A <a href="https://pytorch.org/tutorials/beginner/saving_loading_models.html#what-is-a-state-dict" rel="nofollow">torch state
dict</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.token",description:`<strong>token</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
Override the token to use for the textual inversion weights. If <code>pretrained_model_name_or_path</code> is a
list, then <code>token</code> must also be a list of equal length.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a>, <em>optional</em>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).
If not specified, function will take self.tokenizer.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>, <em>optional</em>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text. If not specified, function will take self.tokenizer.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.weight_name",description:`<strong>weight_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of a custom weight file. This should be used when:</p>
<ul>
<li>The saved textual inversion file is in &#x1F917; Diffusers format, but was saved under a specific weight
name such as <code>text_inv.bin</code>.</li>
<li>The saved textual inversion file is in the Automatic1111 format.</li>
</ul>`,name:"weight_name"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.hf_token",description:`<strong>hf_token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"hf_token"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
The subfolder location of a model file within a larger model repository on the Hub or locally.`,name:"subfolder"},{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/textual_inversion.py#L263"}}),oe=new He({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example",$$slots:{default:[qo]},$$scope:{ctx:D}}}),ie=new He({props:{anchor:"diffusers.StableDiffusionPipeline.load_textual_inversion.example-2",$$slots:{default:[Qo]},$$scope:{ctx:D}}}),De=new P({props:{name:"from_single_file",anchor:"diffusers.StableDiffusionPipeline.from_single_file",parameters:[{name:"pretrained_model_link_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.from_single_file.pretrained_model_link_or_path",description:`<strong>pretrained_model_link_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A link to the <code>.ckpt</code> file (for example
<code>&quot;https://huggingface.co/&lt;repo_id&gt;/blob/main/&lt;path_to_file&gt;.ckpt&quot;</code>) on the Hub.</li>
<li>A path to a <em>file</em> containing all pipeline weights.</li>
</ul>`,name:"pretrained_model_link_or_path"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.torch_dtype",description:`<strong>torch_dtype</strong> (<code>str</code> or <code>torch.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype.`,name:"torch_dtype"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.original_config_file",description:`<strong>original_config_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The path to the original config file that was used to train the model. If not provided, the config file
will be inferred from the checkpoint file.`,name:"original_config_file"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.config",description:`<strong>config</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing the pipeline
component configs in Diffusers format.</li>
</ul>`,name:"config"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.disable_mmap",description:`<strong>disable_mmap</strong> (&#x2018;bool&#x2019;, <em>optional</em>, defaults to &#x2018;False&#x2019;) &#x2014;
Whether to disable mmap when loading a Safetensors model. This option can perform better when the model
is on a network mount or hard drive.`,name:"disable_mmap"},{anchor:"diffusers.StableDiffusionPipeline.from_single_file.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/single_file.py#L271"}}),se=new He({props:{anchor:"diffusers.StableDiffusionPipeline.from_single_file.example",$$slots:{default:[Oo]},$$scope:{ctx:D}}}),Pe=new P({props:{name:"load_lora_weights",anchor:"diffusers.StableDiffusionPipeline.load_lora_weights",parameters:[{name:"pretrained_model_name_or_path_or_dict",val:": typing.Union[str, typing.Dict[str, torch.Tensor]]"},{name:"adapter_name",val:": typing.Optional[str] = None"},{name:"hotswap",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.pretrained_model_name_or_path_or_dict",description:`<strong>pretrained_model_name_or_path_or_dict</strong> (<code>str</code> or <code>os.PathLike</code> or <code>dict</code>) &#x2014;
See <a href="/docs/diffusers/main/en/api/loaders/lora#diffusers.loaders.StableDiffusionLoraLoaderMixin.lora_state_dict">lora_state_dict()</a>.`,name:"pretrained_model_name_or_path_or_dict"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.adapter_name",description:`<strong>adapter_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Adapter name to be used for referencing the loaded adapter model. If not specified, it will use
<code>default_{i}</code> where i is the total number of adapters being loaded.`,name:"adapter_name"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Speed up model loading by only loading the pretrained LoRA weights and not initializing the random
weights.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.StableDiffusionPipeline.load_lora_weights.hotswap",description:`<strong>hotswap</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Defaults to <code>False</code>. Whether to substitute an existing (LoRA) adapter with the newly loaded adapter
in-place. This means that, instead of loading an additional adapter, this will take the existing
adapter weights and replace them with the weights of the new adapter. This can be faster and more
memory efficient. However, the main advantage of hotswapping is that when the model is compiled with
torch.compile, loading the new adapter does not require recompilation of the model. When using
hotswapping, the passed <code>adapter_name</code> should be the name of an already loaded adapter.</p>
<p>If the new adapter and the old adapter have different ranks and/or LoRA alphas (i.e. scaling), you need
to call an additional method before loading the adapter:`,name:"hotswap"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora_pipeline.py#L138"}}),ke=new P({props:{name:"save_lora_weights",anchor:"diffusers.StableDiffusionPipeline.save_lora_weights",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"unet_lora_layers",val:": typing.Dict[str, typing.Union[torch.nn.modules.module.Module, torch.Tensor]] = None"},{name:"text_encoder_lora_layers",val:": typing.Dict[str, torch.nn.modules.module.Module] = None"},{name:"is_main_process",val:": bool = True"},{name:"weight_name",val:": str = None"},{name:"save_function",val:": typing.Callable = None"},{name:"safe_serialization",val:": bool = True"},{name:"unet_lora_adapter_metadata",val:" = None"},{name:"text_encoder_lora_adapter_metadata",val:" = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save LoRA parameters to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_layers",description:`<strong>unet_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>unet</code>.`,name:"unet_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_layers",description:`<strong>text_encoder_lora_layers</strong> (<code>Dict[str, torch.nn.Module]</code> or <code>Dict[str, torch.Tensor]</code>) &#x2014;
State dict of the LoRA layers corresponding to the <code>text_encoder</code>. Must explicitly pass the text
encoder LoRA state dict because it comes from &#x1F917; Transformers.`,name:"text_encoder_lora_layers"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.is_main_process",description:`<strong>is_main_process</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the process calling this is the main process or not. Useful during distributed training and you
need to call this function on all processes. In this case, set <code>is_main_process=True</code> only on the main
process to avoid race conditions.`,name:"is_main_process"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.save_function",description:`<strong>save_function</strong> (<code>Callable</code>) &#x2014;
The function to use to save the state dictionary. Useful during distributed training when you need to
replace <code>torch.save</code> with another method. Can be configured with the environment variable
<code>DIFFUSERS_SAVE_MODE</code>.`,name:"save_function"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.unet_lora_adapter_metadata",description:`<strong>unet_lora_adapter_metadata</strong> &#x2014;
LoRA adapter metadata associated with the unet to be serialized with the state dict.`,name:"unet_lora_adapter_metadata"},{anchor:"diffusers.StableDiffusionPipeline.save_lora_weights.text_encoder_lora_adapter_metadata",description:`<strong>text_encoder_lora_adapter_metadata</strong> &#x2014;
LoRA adapter metadata associated with the text encoder to be serialized with the state dict.`,name:"text_encoder_lora_adapter_metadata"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/loaders/lora_pipeline.py#L474"}}),Ue=new P({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusionPipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_images_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"lora_scale",val:": typing.Optional[float] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A LoRA scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"},{anchor:"diffusers.StableDiffusionPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L332"}}),je=new P({props:{name:"get_guidance_scale_embedding",anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding",parameters:[{name:"w",val:": Tensor"},{name:"embedding_dim",val:": int = 512"},{name:"dtype",val:": dtype = torch.float32"}],parametersDescription:[{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.w",description:`<strong>w</strong> (<code>torch.Tensor</code>) &#x2014;
Generate embedding vectors with a specified guidance scale to subsequently enrich timestep embeddings.`,name:"w"},{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.embedding_dim",description:`<strong>embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Dimension of the embeddings to generate.`,name:"embedding_dim"},{anchor:"diffusers.StableDiffusionPipeline.get_guidance_scale_embedding.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
Data type of the generated embeddings.`,name:"dtype"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_stable_diffusion.py#L717",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Embedding vectors with shape <code>(len(w), embedding_dim)</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),Je=new Ut({props:{title:"StableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",headingTag:"h2"}}),Ce=new P({props:{name:"class diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"},{name:"nsfw_content_detected",val:": typing.Optional[typing.List[bool]]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or NumPy array of shape <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content or
<code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L11"}}),Ie=new Ut({props:{title:"FlaxStableDiffusionPipeline",local:"diffusers.FlaxStableDiffusionPipeline",headingTag:"h2"}}),Ze=new P({props:{name:"class diffusers.FlaxStableDiffusionPipeline",anchor:"diffusers.FlaxStableDiffusionPipeline",parameters:[{name:"vae",val:": FlaxAutoencoderKL"},{name:"text_encoder",val:": FlaxCLIPTextModel"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"unet",val:": FlaxUNet2DConditionModel"},{name:"scheduler",val:": typing.Union[diffusers.schedulers.scheduling_ddim_flax.FlaxDDIMScheduler, diffusers.schedulers.scheduling_pndm_flax.FlaxPNDMScheduler, diffusers.schedulers.scheduling_lms_discrete_flax.FlaxLMSDiscreteScheduler, diffusers.schedulers.scheduling_dpmsolver_multistep_flax.FlaxDPMSolverMultistepScheduler]"},{name:"safety_checker",val:": FlaxStableDiffusionSafetyChecker"},{name:"feature_extractor",val:": CLIPImageProcessor"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.FlaxAutoencoderKL">FlaxAutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.FlaxStableDiffusionPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>FlaxCLIPTextModel</code>) &#x2014;
Frozen text-encoder (<a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a>).`,name:"text_encoder"},{anchor:"diffusers.FlaxStableDiffusionPipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>) &#x2014;
A <code>CLIPTokenizer</code> to tokenize text.`,name:"tokenizer"},{anchor:"diffusers.FlaxStableDiffusionPipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.FlaxUNet2DConditionModel">FlaxUNet2DConditionModel</a>) &#x2014;
A <code>FlaxUNet2DConditionModel</code> to denoise the encoded image latents.`,name:"unet"},{anchor:"diffusers.FlaxStableDiffusionPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded image latents. Can be one of
<code>FlaxDDIMScheduler</code>, <code>FlaxLMSDiscreteScheduler</code>, <code>FlaxPNDMScheduler</code>, or
<code>FlaxDPMSolverMultistepScheduler</code>.`,name:"scheduler"},{anchor:"diffusers.FlaxStableDiffusionPipeline.safety_checker",description:`<strong>safety_checker</strong> (<code>FlaxStableDiffusionSafetyChecker</code>) &#x2014;
Classification module that estimates whether generated images could be considered offensive or harmful.
Please refer to the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow">model card</a> for
more details about a model&#x2019;s potential harms.`,name:"safety_checker"},{anchor:"diffusers.FlaxStableDiffusionPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a>) &#x2014;
A <code>CLIPImageProcessor</code> to extract features from generated images; used as inputs to the <code>safety_checker</code>.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L81"}}),We=new P({props:{name:"__call__",anchor:"diffusers.FlaxStableDiffusionPipeline.__call__",parameters:[{name:"prompt_ids",val:": <function array at 0x7f278d7e5510>"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"prng_seed",val:": Array"},{name:"num_inference_steps",val:": int = 50"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"guidance_scale",val:": typing.Union[float, jax.Array] = 7.5"},{name:"latents",val:": Array = None"},{name:"neg_prompt_ids",val:": Array = None"},{name:"return_dict",val:": bool = True"},{name:"jit",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide image generation.`,name:"prompt"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The height in pixels of the generated image.`,name:"height"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.unet.config.sample_size * self.vae_scale_factor</code>) &#x2014;
The width in pixels of the generated image.`,name:"width"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.latents",description:`<strong>latents</strong> (<code>jnp.ndarray</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
array is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.jit",description:`<strong>jit</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to run <code>pmap</code> versions of the generation and safety scoring functions.</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>This argument exists because <code>__call__</code> is not yet end-to-end pmap-able. It will be removed in a
future release.</p>

					</div>`,name:"jit"},{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput">FlaxStableDiffusionPipelineOutput</a> instead of
a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_flax_stable_diffusion.py#L314",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> is
returned, otherwise a <code>tuple</code> is returned where the first element is a list with the generated images
and the second element is a list of <code>bool</code>s indicating whether the corresponding generated image
contains “not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput"
>FlaxStableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),de=new He({props:{anchor:"diffusers.FlaxStableDiffusionPipeline.__call__.example",$$slots:{default:[Ko]},$$scope:{ctx:D}}}),Le=new Ut({props:{title:"FlaxStableDiffusionPipelineOutput",local:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",headingTag:"h2"}}),Ge=new P({props:{name:"class diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput",parameters:[{name:"images",val:": ndarray"},{name:"nsfw_content_detected",val:": typing.List[bool]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.images",description:`<strong>images</strong> (<code>np.ndarray</code>) &#x2014;
Denoised images of array shape of <code>(batch_size, height, width, num_channels)</code>.`,name:"images"},{anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.nsfw_content_detected",description:`<strong>nsfw_content_detected</strong> (<code>List[bool]</code>) &#x2014;
List indicating whether the corresponding generated image contains &#x201C;not-safe-for-work&#x201D; (nsfw) content
or <code>None</code> if safety checking could not be performed.`,name:"nsfw_content_detected"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/pipeline_output.py#L31"}}),Fe=new P({props:{name:"replace",anchor:"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/flax/struct.py#L144"}}),Be=new zo({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/stable_diffusion/text2img.md"}}),{c(){o=l("meta"),M=i(),c=l("p"),a=i(),h(u.$$.fragment),t=i(),$=l("div"),$.innerHTML=no,jt=i(),fe=l("p"),fe.innerHTML=oo,Jt=i(),me=l("p"),me.textContent=io,Ct=i(),ue=l("p"),ue.innerHTML=so,It=i(),h(R.$$.fragment),Zt=i(),h(ge.$$.fragment),Wt=i(),g=l("div"),h(he.$$.fragment),Qt=i(),Ae=l("p"),Ae.textContent=ao,Ot=i(),qe=l("p"),qe.innerHTML=ro,Kt=i(),Qe=l("p"),Qe.textContent=lo,en=i(),Oe=l("ul"),Oe.innerHTML=po,tn=i(),F=l("div"),h(_e.$$.fragment),nn=i(),Ke=l("p"),Ke.textContent=co,on=i(),h(X.$$.fragment),sn=i(),J=l("div"),h(be.$$.fragment),an=i(),et=l("p"),et.textContent=fo,rn=i(),h(H.$$.fragment),ln=i(),h(Y.$$.fragment),dn=i(),A=l("div"),h(ye.$$.fragment),pn=i(),tt=l("p"),tt.innerHTML=mo,cn=i(),q=l("div"),h(ve.$$.fragment),fn=i(),nt=l("p"),nt.textContent=uo,mn=i(),Q=l("div"),h(we.$$.fragment),un=i(),ot=l("p"),ot.innerHTML=go,gn=i(),C=l("div"),h(xe.$$.fragment),hn=i(),it=l("p"),it.innerHTML=ho,_n=i(),h(O.$$.fragment),bn=i(),h(K.$$.fragment),yn=i(),ee=l("div"),h($e.$$.fragment),vn=i(),st=l("p"),st.innerHTML=_o,wn=i(),te=l("div"),h(Me.$$.fragment),xn=i(),at=l("p"),at.textContent=bo,$n=i(),ne=l("div"),h(Te.$$.fragment),Mn=i(),rt=l("p"),rt.innerHTML=yo,Tn=i(),k=l("div"),h(Se.$$.fragment),Sn=i(),lt=l("p"),lt.innerHTML=vo,Dn=i(),dt=l("p"),dt.textContent=wo,Pn=i(),h(oe.$$.fragment),kn=i(),pt=l("p"),pt.innerHTML=xo,Un=i(),h(ie.$$.fragment),jn=i(),B=l("div"),h(De.$$.fragment),Jn=i(),ct=l("p"),ct.innerHTML=$o,Cn=i(),h(se.$$.fragment),In=i(),U=l("div"),h(Pe.$$.fragment),Zn=i(),ft=l("p"),ft.innerHTML=Mo,Wn=i(),mt=l("p"),mt.innerHTML=To,Ln=i(),ut=l("p"),ut.innerHTML=So,Gn=i(),gt=l("p"),gt.innerHTML=Do,Fn=i(),ht=l("p"),ht.innerHTML=Po,Bn=i(),ae=l("div"),h(ke.$$.fragment),Nn=i(),_t=l("p"),_t.textContent=ko,Vn=i(),re=l("div"),h(Ue.$$.fragment),zn=i(),bt=l("p"),bt.textContent=Uo,En=i(),le=l("div"),h(je.$$.fragment),Rn=i(),yt=l("p"),yt.innerHTML=jo,Lt=i(),h(Je.$$.fragment),Gt=i(),z=l("div"),h(Ce.$$.fragment),Xn=i(),vt=l("p"),vt.textContent=Jo,Ft=i(),h(Ie.$$.fragment),Bt=i(),j=l("div"),h(Ze.$$.fragment),Hn=i(),wt=l("p"),wt.textContent=Co,Yn=i(),xt=l("p"),xt.innerHTML=Io,An=i(),N=l("div"),h(We.$$.fragment),qn=i(),$t=l("p"),$t.textContent=Zo,Qn=i(),h(de.$$.fragment),Nt=i(),h(Le.$$.fragment),Vt=i(),W=l("div"),h(Ge.$$.fragment),On=i(),Mt=l("p"),Mt.textContent=Wo,Kn=i(),pe=l("div"),h(Fe.$$.fragment),eo=i(),Tt=l("p"),Tt.textContent=Lo,zt=i(),h(Be.$$.fragment),Et=i(),kt=l("p"),this.h()},l(e){const p=Vo("svelte-u9bgzb",document.head);o=d(p,"META",{name:!0,content:!0}),p.forEach(r),M=s(e),c=d(e,"P",{}),S(c).forEach(r),a=s(e),_(u.$$.fragment,e),t=s(e),$=d(e,"DIV",{class:!0,"data-svelte-h":!0}),f($)!=="svelte-si9ct8"&&($.innerHTML=no),jt=s(e),fe=d(e,"P",{"data-svelte-h":!0}),f(fe)!=="svelte-1p4bu1q"&&(fe.innerHTML=oo),Jt=s(e),me=d(e,"P",{"data-svelte-h":!0}),f(me)!=="svelte-1cwsb16"&&(me.textContent=io),Ct=s(e),ue=d(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1xoozhu"&&(ue.innerHTML=so),It=s(e),_(R.$$.fragment,e),Zt=s(e),_(ge.$$.fragment,e),Wt=s(e),g=d(e,"DIV",{class:!0});var x=S(g);_(he.$$.fragment,x),Qt=s(x),Ae=d(x,"P",{"data-svelte-h":!0}),f(Ae)!=="svelte-35p306"&&(Ae.textContent=ao),Ot=s(x),qe=d(x,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-496sm0"&&(qe.innerHTML=ro),Kt=s(x),Qe=d(x,"P",{"data-svelte-h":!0}),f(Qe)!=="svelte-14s6m4u"&&(Qe.textContent=lo),en=s(x),Oe=d(x,"UL",{"data-svelte-h":!0}),f(Oe)!=="svelte-5sz5nb"&&(Oe.innerHTML=po),tn=s(x),F=d(x,"DIV",{class:!0});var E=S(F);_(_e.$$.fragment,E),nn=s(E),Ke=d(E,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-50j04k"&&(Ke.textContent=co),on=s(E),_(X.$$.fragment,E),E.forEach(r),sn=s(x),J=d(x,"DIV",{class:!0});var L=S(J);_(be.$$.fragment,L),an=s(L),et=d(L,"P",{"data-svelte-h":!0}),f(et)!=="svelte-10jaql7"&&(et.textContent=fo),rn=s(L),_(H.$$.fragment,L),ln=s(L),_(Y.$$.fragment,L),L.forEach(r),dn=s(x),A=d(x,"DIV",{class:!0});var Ne=S(A);_(ye.$$.fragment,Ne),pn=s(Ne),tt=d(Ne,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-1lh0nh5"&&(tt.innerHTML=mo),Ne.forEach(r),cn=s(x),q=d(x,"DIV",{class:!0});var Ve=S(q);_(ve.$$.fragment,Ve),fn=s(Ve),nt=d(Ve,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-14bnrb6"&&(nt.textContent=uo),Ve.forEach(r),mn=s(x),Q=d(x,"DIV",{class:!0});var ze=S(Q);_(we.$$.fragment,ze),un=s(ze),ot=d(ze,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1s3c06i"&&(ot.innerHTML=go),ze.forEach(r),gn=s(x),C=d(x,"DIV",{class:!0});var G=S(C);_(xe.$$.fragment,G),hn=s(G),it=d(G,"P",{"data-svelte-h":!0}),f(it)!=="svelte-e03q3e"&&(it.innerHTML=ho),_n=s(G),_(O.$$.fragment,G),bn=s(G),_(K.$$.fragment,G),G.forEach(r),yn=s(x),ee=d(x,"DIV",{class:!0});var Ee=S(ee);_($e.$$.fragment,Ee),vn=s(Ee),st=d(Ee,"P",{"data-svelte-h":!0}),f(st)!=="svelte-1vfte1e"&&(st.innerHTML=_o),Ee.forEach(r),wn=s(x),te=d(x,"DIV",{class:!0});var Re=S(te);_(Me.$$.fragment,Re),xn=s(Re),at=d(Re,"P",{"data-svelte-h":!0}),f(at)!=="svelte-1xwrf7t"&&(at.textContent=bo),Re.forEach(r),$n=s(x),ne=d(x,"DIV",{class:!0});var Xe=S(ne);_(Te.$$.fragment,Xe),Mn=s(Xe),rt=d(Xe,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-pkn4ui"&&(rt.innerHTML=yo),Xe.forEach(r),Tn=s(x),k=d(x,"DIV",{class:!0});var I=S(k);_(Se.$$.fragment,I),Sn=s(I),lt=d(I,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1lv88wo"&&(lt.innerHTML=vo),Dn=s(I),dt=d(I,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-11lpom8"&&(dt.textContent=wo),Pn=s(I),_(oe.$$.fragment,I),kn=s(I),pt=d(I,"P",{"data-svelte-h":!0}),f(pt)!=="svelte-15d7mv5"&&(pt.innerHTML=xo),Un=s(I),_(ie.$$.fragment,I),I.forEach(r),jn=s(x),B=d(x,"DIV",{class:!0});var St=S(B);_(De.$$.fragment,St),Jn=s(St),ct=d(St,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-pmqrln"&&(ct.innerHTML=$o),Cn=s(St),_(se.$$.fragment,St),St.forEach(r),In=s(x),U=d(x,"DIV",{class:!0});var Z=S(U);_(Pe.$$.fragment,Z),Zn=s(Z),ft=d(Z,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-vs7s0z"&&(ft.innerHTML=Mo),Wn=s(Z),mt=d(Z,"P",{"data-svelte-h":!0}),f(mt)!=="svelte-15b960v"&&(mt.innerHTML=To),Ln=s(Z),ut=d(Z,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-15mw932"&&(ut.innerHTML=So),Gn=s(Z),gt=d(Z,"P",{"data-svelte-h":!0}),f(gt)!=="svelte-qyr8zl"&&(gt.innerHTML=Do),Fn=s(Z),ht=d(Z,"P",{"data-svelte-h":!0}),f(ht)!=="svelte-9uqd0r"&&(ht.innerHTML=Po),Z.forEach(r),Bn=s(x),ae=d(x,"DIV",{class:!0});var Xt=S(ae);_(ke.$$.fragment,Xt),Nn=s(Xt),_t=d(Xt,"P",{"data-svelte-h":!0}),f(_t)!=="svelte-1ufq5ot"&&(_t.textContent=ko),Xt.forEach(r),Vn=s(x),re=d(x,"DIV",{class:!0});var Ht=S(re);_(Ue.$$.fragment,Ht),zn=s(Ht),bt=d(Ht,"P",{"data-svelte-h":!0}),f(bt)!=="svelte-16q0ax1"&&(bt.textContent=Uo),Ht.forEach(r),En=s(x),le=d(x,"DIV",{class:!0});var Yt=S(le);_(je.$$.fragment,Yt),Rn=s(Yt),yt=d(Yt,"P",{"data-svelte-h":!0}),f(yt)!=="svelte-vo59ec"&&(yt.innerHTML=jo),Yt.forEach(r),x.forEach(r),Lt=s(e),_(Je.$$.fragment,e),Gt=s(e),z=d(e,"DIV",{class:!0});var At=S(z);_(Ce.$$.fragment,At),Xn=s(At),vt=d(At,"P",{"data-svelte-h":!0}),f(vt)!=="svelte-1qpjiuf"&&(vt.textContent=Jo),At.forEach(r),Ft=s(e),_(Ie.$$.fragment,e),Bt=s(e),j=d(e,"DIV",{class:!0});var ce=S(j);_(Ze.$$.fragment,ce),Hn=s(ce),wt=d(ce,"P",{"data-svelte-h":!0}),f(wt)!=="svelte-d05p75"&&(wt.textContent=Co),Yn=s(ce),xt=d(ce,"P",{"data-svelte-h":!0}),f(xt)!=="svelte-knddhk"&&(xt.innerHTML=Io),An=s(ce),N=d(ce,"DIV",{class:!0});var Dt=S(N);_(We.$$.fragment,Dt),qn=s(Dt),$t=d(Dt,"P",{"data-svelte-h":!0}),f($t)!=="svelte-50j04k"&&($t.textContent=Zo),Qn=s(Dt),_(de.$$.fragment,Dt),Dt.forEach(r),ce.forEach(r),Nt=s(e),_(Le.$$.fragment,e),Vt=s(e),W=d(e,"DIV",{class:!0});var Pt=S(W);_(Ge.$$.fragment,Pt),On=s(Pt),Mt=d(Pt,"P",{"data-svelte-h":!0}),f(Mt)!=="svelte-wzv2jc"&&(Mt.textContent=Wo),Kn=s(Pt),pe=d(Pt,"DIV",{class:!0});var qt=S(pe);_(Fe.$$.fragment,qt),eo=s(qt),Tt=d(qt,"P",{"data-svelte-h":!0}),f(Tt)!=="svelte-brjshm"&&(Tt.textContent=Lo),qt.forEach(r),Pt.forEach(r),zt=s(e),_(Be.$$.fragment,e),Et=s(e),kt=d(e,"P",{}),S(kt).forEach(r),this.h()},h(){T(o,"name","hf:doc:metadata"),T(o,"content",ti),T($,"class","flex flex-wrap space-x-1"),T(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(g,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,p){n(document.head,o),m(e,M,p),m(e,c,p),m(e,a,p),b(u,e,p),m(e,t,p),m(e,$,p),m(e,jt,p),m(e,fe,p),m(e,Jt,p),m(e,me,p),m(e,Ct,p),m(e,ue,p),m(e,It,p),b(R,e,p),m(e,Zt,p),b(ge,e,p),m(e,Wt,p),m(e,g,p),b(he,g,null),n(g,Qt),n(g,Ae),n(g,Ot),n(g,qe),n(g,Kt),n(g,Qe),n(g,en),n(g,Oe),n(g,tn),n(g,F),b(_e,F,null),n(F,nn),n(F,Ke),n(F,on),b(X,F,null),n(g,sn),n(g,J),b(be,J,null),n(J,an),n(J,et),n(J,rn),b(H,J,null),n(J,ln),b(Y,J,null),n(g,dn),n(g,A),b(ye,A,null),n(A,pn),n(A,tt),n(g,cn),n(g,q),b(ve,q,null),n(q,fn),n(q,nt),n(g,mn),n(g,Q),b(we,Q,null),n(Q,un),n(Q,ot),n(g,gn),n(g,C),b(xe,C,null),n(C,hn),n(C,it),n(C,_n),b(O,C,null),n(C,bn),b(K,C,null),n(g,yn),n(g,ee),b($e,ee,null),n(ee,vn),n(ee,st),n(g,wn),n(g,te),b(Me,te,null),n(te,xn),n(te,at),n(g,$n),n(g,ne),b(Te,ne,null),n(ne,Mn),n(ne,rt),n(g,Tn),n(g,k),b(Se,k,null),n(k,Sn),n(k,lt),n(k,Dn),n(k,dt),n(k,Pn),b(oe,k,null),n(k,kn),n(k,pt),n(k,Un),b(ie,k,null),n(g,jn),n(g,B),b(De,B,null),n(B,Jn),n(B,ct),n(B,Cn),b(se,B,null),n(g,In),n(g,U),b(Pe,U,null),n(U,Zn),n(U,ft),n(U,Wn),n(U,mt),n(U,Ln),n(U,ut),n(U,Gn),n(U,gt),n(U,Fn),n(U,ht),n(g,Bn),n(g,ae),b(ke,ae,null),n(ae,Nn),n(ae,_t),n(g,Vn),n(g,re),b(Ue,re,null),n(re,zn),n(re,bt),n(g,En),n(g,le),b(je,le,null),n(le,Rn),n(le,yt),m(e,Lt,p),b(Je,e,p),m(e,Gt,p),m(e,z,p),b(Ce,z,null),n(z,Xn),n(z,vt),m(e,Ft,p),b(Ie,e,p),m(e,Bt,p),m(e,j,p),b(Ze,j,null),n(j,Hn),n(j,wt),n(j,Yn),n(j,xt),n(j,An),n(j,N),b(We,N,null),n(N,qn),n(N,$t),n(N,Qn),b(de,N,null),m(e,Nt,p),b(Le,e,p),m(e,Vt,p),m(e,W,p),b(Ge,W,null),n(W,On),n(W,Mt),n(W,Kn),n(W,pe),b(Fe,pe,null),n(pe,eo),n(pe,Tt),m(e,zt,p),b(Be,e,p),m(e,Et,p),m(e,kt,p),Rt=!0},p(e,[p]){const x={};p&2&&(x.$$scope={dirty:p,ctx:e}),R.$set(x);const E={};p&2&&(E.$$scope={dirty:p,ctx:e}),X.$set(E);const L={};p&2&&(L.$$scope={dirty:p,ctx:e}),H.$set(L);const Ne={};p&2&&(Ne.$$scope={dirty:p,ctx:e}),Y.$set(Ne);const Ve={};p&2&&(Ve.$$scope={dirty:p,ctx:e}),O.$set(Ve);const ze={};p&2&&(ze.$$scope={dirty:p,ctx:e}),K.$set(ze);const G={};p&2&&(G.$$scope={dirty:p,ctx:e}),oe.$set(G);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:e}),ie.$set(Ee);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:e}),se.$set(Re);const Xe={};p&2&&(Xe.$$scope={dirty:p,ctx:e}),de.$set(Xe)},i(e){Rt||(y(u.$$.fragment,e),y(R.$$.fragment,e),y(ge.$$.fragment,e),y(he.$$.fragment,e),y(_e.$$.fragment,e),y(X.$$.fragment,e),y(be.$$.fragment,e),y(H.$$.fragment,e),y(Y.$$.fragment,e),y(ye.$$.fragment,e),y(ve.$$.fragment,e),y(we.$$.fragment,e),y(xe.$$.fragment,e),y(O.$$.fragment,e),y(K.$$.fragment,e),y($e.$$.fragment,e),y(Me.$$.fragment,e),y(Te.$$.fragment,e),y(Se.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(De.$$.fragment,e),y(se.$$.fragment,e),y(Pe.$$.fragment,e),y(ke.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Je.$$.fragment,e),y(Ce.$$.fragment,e),y(Ie.$$.fragment,e),y(Ze.$$.fragment,e),y(We.$$.fragment,e),y(de.$$.fragment,e),y(Le.$$.fragment,e),y(Ge.$$.fragment,e),y(Fe.$$.fragment,e),y(Be.$$.fragment,e),Rt=!0)},o(e){v(u.$$.fragment,e),v(R.$$.fragment,e),v(ge.$$.fragment,e),v(he.$$.fragment,e),v(_e.$$.fragment,e),v(X.$$.fragment,e),v(be.$$.fragment,e),v(H.$$.fragment,e),v(Y.$$.fragment,e),v(ye.$$.fragment,e),v(ve.$$.fragment,e),v(we.$$.fragment,e),v(xe.$$.fragment,e),v(O.$$.fragment,e),v(K.$$.fragment,e),v($e.$$.fragment,e),v(Me.$$.fragment,e),v(Te.$$.fragment,e),v(Se.$$.fragment,e),v(oe.$$.fragment,e),v(ie.$$.fragment,e),v(De.$$.fragment,e),v(se.$$.fragment,e),v(Pe.$$.fragment,e),v(ke.$$.fragment,e),v(Ue.$$.fragment,e),v(je.$$.fragment,e),v(Je.$$.fragment,e),v(Ce.$$.fragment,e),v(Ie.$$.fragment,e),v(Ze.$$.fragment,e),v(We.$$.fragment,e),v(de.$$.fragment,e),v(Le.$$.fragment,e),v(Ge.$$.fragment,e),v(Fe.$$.fragment,e),v(Be.$$.fragment,e),Rt=!1},d(e){e&&(r(M),r(c),r(a),r(t),r($),r(jt),r(fe),r(Jt),r(me),r(Ct),r(ue),r(It),r(Zt),r(Wt),r(g),r(Lt),r(Gt),r(z),r(Ft),r(Bt),r(j),r(Nt),r(Vt),r(W),r(zt),r(Et),r(kt)),r(o),w(u,e),w(R,e),w(ge,e),w(he),w(_e),w(X),w(be),w(H),w(Y),w(ye),w(ve),w(we),w(xe),w(O),w(K),w($e),w(Me),w(Te),w(Se),w(oe),w(ie),w(De),w(se),w(Pe),w(ke),w(Ue),w(je),w(Je,e),w(Ce),w(Ie,e),w(Ze),w(We),w(de),w(Le,e),w(Ge),w(Fe),w(Be,e)}}}const ti='{"title":"Text-to-image","local":"text-to-image","sections":[{"title":"StableDiffusionPipeline","local":"diffusers.StableDiffusionPipeline","sections":[],"depth":2},{"title":"StableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipeline","local":"diffusers.FlaxStableDiffusionPipeline","sections":[],"depth":2},{"title":"FlaxStableDiffusionPipelineOutput","local":"diffusers.pipelines.stable_diffusion.FlaxStableDiffusionPipelineOutput","sections":[],"depth":2}],"depth":1}';function ni(D){return Fo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pi extends Bo{constructor(o){super(),No(this,o,ni,ei,Go,{})}}export{pi as component};
