import{s as la,o as da,n as J}from"../chunks/scheduler.8c3d61f6.js";import{S as pa,i as fa,g as a,s as i,r as m,A as ca,h as r,f as l,c as s,j as T,u as h,x as c,k,y as t,a as u,v as g,d as b,t as _,w as y}from"../chunks/index.da70eac4.js";import{T as jt}from"../chunks/Tip.1d9b8c37.js";import{D as U}from"../chunks/Docstring.c021b19a.js";import{C as de}from"../chunks/CodeBlock.a9c4becf.js";import{E as le}from"../chunks/ExampleCodeBlock.56b4589c.js";import{H as Rn,E as ua}from"../chunks/getInferenceSnippets.725ed3d4.js";function ma(C){let o,$='You shouldn’t use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class for training. Individual components (for example, <a href="/docs/diffusers/main/en/api/models/unet2d#diffusers.UNet2DModel">UNet2DModel</a> and <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) of diffusion pipelines are usually trained individually, so we suggest directly working with them instead.',p,d,v,n,M='Pipelines do not offer any training functionality. You’ll notice PyTorch’s autograd is disabled by decorating the <code>__call__()</code> method with a <a href="https://pytorch.org/docs/stable/generated/torch.no_grad.html" rel="nofollow"><code>torch.no_grad</code></a> decorator because pipelines should not be used for training. If you’re interested in training, please take a look at the <a href="../../training/overview">Training</a> guides instead!';return{c(){o=a("p"),o.innerHTML=$,p=i(),d=a("br"),v=i(),n=a("p"),n.innerHTML=M},l(j){o=r(j,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17t0bk9"&&(o.innerHTML=$),p=s(j),d=r(j,"BR",{}),v=s(j),n=r(j,"P",{"data-svelte-h":!0}),c(n)!=="svelte-1a94ctl"&&(n.innerHTML=M)},m(j,te){u(j,o,te),u(j,p,te),u(j,d,te),u(j,v,te),u(j,n,te)},p:J,d(j){j&&(l(o),l(p),l(d),l(v),l(n))}}}function ha(C){let o,$=`If the pipeline already has the correct torch.dtype and torch.device, then it is returned as is. Otherwise,
the returned pipeline is a copy of self with the desired torch.dtype and torch.device.`;return{c(){o=a("p"),o.textContent=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-18gkv0g"&&(o.textContent=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function ga(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUyQyUwQSUyMCUyMCUyMCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSUyQyUwQSklMEElMEF0ZXh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIpJTBBaW1nMmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMpJTBBaW5wYWludCUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbklucGFpbnRQaXBlbGluZSgqKnRleHQyaW1nLmNvbXBvbmVudHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    StableDiffusionPipeline,
<span class="hljs-meta">... </span>    StableDiffusionImg2ImgPipeline,
<span class="hljs-meta">... </span>    StableDiffusionInpaintPipeline,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text2img = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>img2img = StableDiffusionImg2ImgPipeline(**text2img.components)
<span class="hljs-meta">&gt;&gt;&gt; </span>inpaint = StableDiffusionInpaintPipeline(**text2img.components)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function ba(C){let o,$='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with `hf\nauth login';return{c(){o=a("p"),o.innerHTML=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-167kq00"&&(o.innerHTML=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function _a(C){let o,$=`⚠️ Don’t enable attention slicing if you’re already using <code>scaled_dot_product_attention</code> (SDPA) from PyTorch
2.0 or xFormers. These attention computations are already very memory efficient so you won’t need to enable
this function. If you enable attention slicing with SDPA or xFormers, it can lead to serious slow downs!`;return{c(){o=a("p"),o.innerHTML=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-ackzsn"&&(o.innerHTML=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function ya(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMHBob3RvJTIwb2YlMjBhbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwbWFycyUyMiUwQXBpcGUuZW5hYmxlX2F0dGVudGlvbl9zbGljaW5nKCklMEFpbWFnZSUyMCUzRCUyMHBpcGUocHJvbXB0KS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>    use_safetensors=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_attention_slicing()
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function va(C){let o,$=`⚠️ When memory efficient attention and sliced attention are both enabled, memory efficient attention takes
precedent.`;return{c(){o=a("p"),o.textContent=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-17p1lpg"&&(o.textContent=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function xa(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRGlmZnVzaW9uUGlwZWxpbmUlMEFmcm9tJTIweGZvcm1lcnMub3BzJTIwaW1wb3J0JTIwTWVtb3J5RWZmaWNpZW50QXR0ZW50aW9uRmxhc2hBdHRlbnRpb25PcCUwQSUwQXBpcGUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLTItMSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQXBpcGUuZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uKGF0dGVudGlvbl9vcCUzRE1lbW9yeUVmZmljaWVudEF0dGVudGlvbkZsYXNoQXR0ZW50aW9uT3ApJTBBJTIzJTIwV29ya2Fyb3VuZCUyMGZvciUyMG5vdCUyMGFjY2VwdGluZyUyMGF0dGVudGlvbiUyMHNoYXBlJTIwdXNpbmclMjBWQUUlMjBmb3IlMjBGbGFzaCUyMEF0dGVudGlvbiUwQXBpcGUudmFlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbihhdHRlbnRpb25fb3AlM0ROb25lKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> xformers.ops <span class="hljs-keyword">import</span> MemoryEfficientAttentionFlashAttentionOp

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2-1&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.enable_xformers_memory_efficient_attention(attention_op=MemoryEfficientAttentionFlashAttentionOp)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Workaround for not accepting attention shape using VAE for Flash Attention</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.vae.enable_xformers_memory_efficient_attention(attention_op=<span class="hljs-literal">None</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function $a(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiklMEFuZXdfcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblNBR1BpcGVsaW5lLmZyb21fcGlwZShwaXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionSAGPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>new_pipe = StableDiffusionSAGPipeline.from_pipe(pipe)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function wa(C){let o,$="If you get the error message below, you need to finetune the weights for your downstream task:",p,d,v;return d=new de({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIwYW5kJTIwYXJlJTIwbmV3bHklMjBpbml0aWFsaXplZCUyMGJlY2F1c2UlMjB0aGUlMjBzaGFwZXMlMjBkaWQlMjBub3QlMjBtYXRjaCUzQSUwQS0lMjBjb252X2luLndlaWdodCUzQSUyMGZvdW5kJTIwc2hhcGUlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDQlMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMGNoZWNrcG9pbnQlMjBhbmQlMjB0b3JjaC5TaXplKCU1QjMyMCUyQyUyMDklMkMlMjAzJTJDJTIwMyU1RCklMjBpbiUyMHRoZSUyMG1vZGVsJTIwaW5zdGFudGlhdGVkJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of UNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:
- conv_in.weight: found <span class="hljs-keyword">shape </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the checkpoint <span class="hljs-keyword">and </span>torch.Size([<span class="hljs-number">320</span>, <span class="hljs-number">9</span>, <span class="hljs-number">3</span>, <span class="hljs-number">3</span>]) in the model <span class="hljs-keyword">instantiated
</span>You <span class="hljs-keyword">should </span>probably TRAIN this model on a down-stream task to <span class="hljs-keyword">be </span>able to use it for predictions <span class="hljs-keyword">and </span>inference.`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function Ma(C){let o,$='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated</a> models, log-in with <code>hf auth login</code>.';return{c(){o=a("p"),o.innerHTML=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-1qg11oj"&&(o.innerHTML=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function Ta(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMGZyb20lMjBodWdnaW5nZmFjZS5jbyUyMGFuZCUyMGNhY2hlLiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMkNvbXBWaXMlMkZsZG0tdGV4dDJpbS1sYXJnZS0yNTYlMjIpJTBBJTBBJTIzJTIwRG93bmxvYWQlMjBwaXBlbGluZSUyMHRoYXQlMjByZXF1aXJlcyUyMGFuJTIwYXV0aG9yaXphdGlvbiUyMHRva2VuJTBBJTIzJTIwRm9yJTIwbW9yZSUyMGluZm9ybWF0aW9uJTIwb24lMjBhY2Nlc3MlMjB0b2tlbnMlMkMlMjBwbGVhc2UlMjByZWZlciUyMHRvJTIwdGhpcyUyMHNlY3Rpb24lMEElMjMlMjBvZiUyMHRoZSUyMGRvY3VtZW50YXRpb24lNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRvY3MlMkZodWIlMkZzZWN1cml0eS10b2tlbnMpJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyKSUwQSUwQSUyMyUyMFVzZSUyMGElMjBkaWZmZXJlbnQlMjBzY2hlZHVsZXIlMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwTE1TRGlzY3JldGVTY2hlZHVsZXIlMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;CompVis/ldm-text2im-large-256&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline that requires an authorization token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For more information on access tokens, please refer to this section</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># of the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline.scheduler = scheduler`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function ka(C){let o,$="If you get the error message below, you need to finetune the weights for your downstream task:",p,d,v;return d=new de({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMEZsYXhVTmV0MkRDb25kaXRpb25Nb2RlbCUyMHdlcmUlMjBub3QlMjBpbml0aWFsaXplZCUyMGZyb20lMjB0aGUlMjBtb2RlbCUyMGNoZWNrcG9pbnQlMjBhdCUyMHN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMGFuZCUyMGFyZSUyMG5ld2x5JTIwaW5pdGlhbGl6ZWQlMjBiZWNhdXNlJTIwdGhlJTIwc2hhcGVzJTIwZGlkJTIwbm90JTIwbWF0Y2glM0E=",highlighted:'Some weights of FlaxUNet2DConditionModel were not initialized from the model checkpoint <span class="hljs-built_in">at</span> stable-<span class="hljs-keyword">diffusion-v1-5/stable-diffusion-v1-5 </span><span class="hljs-keyword">and </span>are newly initialized <span class="hljs-keyword">because </span>the <span class="hljs-keyword">shapes </span><span class="hljs-keyword">did </span>not match:',wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-xueb0m"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function Ca(C){let o,$='To use private or <a href="https://huggingface.co/docs/hub/models-gated#gated-models" rel="nofollow">gated models</a>, log-in with <code>hf auth login</code>.';return{c(){o=a("p"),o.innerHTML=$},l(p){o=r(p,"P",{"data-svelte-h":!0}),c(o)!=="svelte-h3jqn3"&&(o.innerHTML=$)},m(p,d){u(p,o,d)},p:J,d(p){p&&l(o)}}}function Ua(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEaWZmdXNpb25QaXBlbGluZSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEElMjMlMjBSZXF1aXJlcyUyMHRvJTIwYmUlMjBsb2dnZWQlMjBpbiUyMHRvJTIwSHVnZ2luZyUyMEZhY2UlMjBodWIlMkMlMEElMjMlMjBzZWUlMjBtb3JlJTIwaW4lMjAlNUJ0aGUlMjBkb2N1bWVudGF0aW9uJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkb2NzJTJGaHViJTJGc2VjdXJpdHktdG9rZW5zKSUwQXBpcGVsaW5lJTJDJTIwcGFyYW1zJTIwJTNEJTIwRmxheERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB2YXJpYW50JTNEJTIyYmYxNiUyMiUyQyUwQSUyMCUyMCUyMCUyMGR0eXBlJTNEam5wLmJmbG9hdDE2JTJDJTBBKSUwQSUwQSUyMyUyMERvd25sb2FkJTIwcGlwZWxpbmUlMkMlMjBidXQlMjB1c2UlMjBhJTIwZGlmZmVyZW50JTIwc2NoZWR1bGVyJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEZsYXhEUE1Tb2x2ZXJNdWx0aXN0ZXBTY2hlZHVsZXIlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQWRwbXBwJTJDJTIwZHBtcHBfc3RhdGUlMjAlM0QlMjBGbGF4RFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiUyQyUwQSklMEElMEFkcG1fcGlwZSUyQyUyMGRwbV9wYXJhbXMlMjAlM0QlMjBGbGF4U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTIwdmFyaWFudCUzRCUyMmJmMTYlMjIlMkMlMjBkdHlwZSUzRGpucC5iZmxvYXQxNiUyQyUyMHNjaGVkdWxlciUzRGRwbXBwJTBBKSUwQWRwbV9wYXJhbXMlNUIlMjJzY2hlZHVsZXIlMjIlNUQlMjAlM0QlMjBkcG1wcF9zdGF0ZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDiffusionPipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Requires to be logged in to Hugging Face hub,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># see more in [the documentation](https://huggingface.co/docs/hub/security-tokens)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipeline, params = FlaxDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>,
<span class="hljs-meta">... </span>    variant=<span class="hljs-string">&quot;bf16&quot;</span>,
<span class="hljs-meta">... </span>    dtype=jnp.bfloat16,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download pipeline, but use a different scheduler</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxDPMSolverMultistepScheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dpmpp, dpmpp_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
<span class="hljs-meta">... </span>    model_id,
<span class="hljs-meta">... </span>    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_pipe, dpm_params = FlaxStableDiffusionPipeline.from_pretrained(
<span class="hljs-meta">... </span>    model_id, variant=<span class="hljs-string">&quot;bf16&quot;</span>, dtype=jnp.bfloat16, scheduler=dpmpp
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dpm_params[<span class="hljs-string">&quot;scheduler&quot;</span>] = dpmpp_state`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function Pa(C){let o,$="Examples:",p,d,v;return d=new de({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBdW5ldCUyMCUzRCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24tMiUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMHlvdXIlMjBuYW1lc3BhY2UlMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC11bmV0JTIyLiUwQXVuZXQucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLXVuZXQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMCU2MHVuZXQlNjAlMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtdW5ldCUyMi4lMEF1bmV0LnB1c2hfdG9faHViKCUyMnlvdXItb3JnJTJGbXktZmluZXR1bmVkLXVuZXQlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-2&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to your namespace with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;my-finetuned-unet&quot;</span>)

<span class="hljs-comment"># Push the \`unet\` to an organization with the name &quot;my-finetuned-unet&quot;.</span>
unet.push_to_hub(<span class="hljs-string">&quot;your-org/my-finetuned-unet&quot;</span>)`,wrap:!1}}),{c(){o=a("p"),o.textContent=$,p=i(),m(d.$$.fragment)},l(n){o=r(n,"P",{"data-svelte-h":!0}),c(o)!=="svelte-kvfsh7"&&(o.textContent=$),p=s(n),h(d.$$.fragment,n)},m(n,M){u(n,o,M),u(n,p,M),g(d,n,M),v=!0},p:J,i(n){v||(b(d.$$.fragment,n),v=!0)},o(n){_(d.$$.fragment,n),v=!1},d(n){n&&(l(o),l(p)),y(d,n)}}}function Da(C){let o,$,p,d,v,n,M,j="Pipelines provide a simple way to run state-of-the-art diffusion models in inference by bundling all of the necessary components (multiple independently-trained models, schedulers, and processors) into a single end-to-end class. Pipelines are flexible and they can be adapted to use different schedulers or even model components.",te,Le,is='All pipelines are built from the base <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class which provides basic functionality for loading, downloading, and saving all the components. Specific pipeline types (for example <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>) loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> are automatically detected and the pipeline components are loaded and passed to the <code>__init__</code> function of the pipeline.',En,pe,zn,Fe,ss="The table below lists all the pipelines currently available in 🤗 Diffusers and the tasks they support. Click on a pipeline to view its abstract and published paper.",Yn,Se,as='<thead><tr><th>Pipeline</th> <th>Tasks</th></tr></thead> <tbody><tr><td><a href="amused">aMUSEd</a></td> <td>text2image</td></tr> <tr><td><a href="animatediff">AnimateDiff</a></td> <td>text2video</td></tr> <tr><td><a href="attend_and_excite">Attend-and-Excite</a></td> <td>text2image</td></tr> <tr><td><a href="audioldm">AudioLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="audioldm2">AudioLDM2</a></td> <td>text2audio</td></tr> <tr><td><a href="auraflow">AuraFlow</a></td> <td>text2image</td></tr> <tr><td><a href="blip_diffusion">BLIP Diffusion</a></td> <td>text2image</td></tr> <tr><td><a href="bria_3_2">Bria 3.2</a></td> <td>text2image</td></tr> <tr><td><a href="cogvideox">CogVideoX</a></td> <td>text2video</td></tr> <tr><td><a href="consistency_models">Consistency Models</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="controlnet">ControlNet</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="controlnet_flux">ControlNet with Flux.1</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_hunyuandit">ControlNet with Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sd3">ControlNet with Stable Diffusion 3</a></td> <td>text2image</td></tr> <tr><td><a href="controlnet_sdxl">ControlNet with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs">ControlNet-XS</a></td> <td>text2image</td></tr> <tr><td><a href="controlnetxs_sdxl">ControlNet-XS with Stable Diffusion XL</a></td> <td>text2image</td></tr> <tr><td><a href="dance_diffusion">Dance Diffusion</a></td> <td>unconditional audio generation</td></tr> <tr><td><a href="ddim">DDIM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="ddpm">DDPM</a></td> <td>unconditional image generation</td></tr> <tr><td><a href="deepfloyd_if">DeepFloyd IF</a></td> <td>text2image, image2image, inpainting, super-resolution</td></tr> <tr><td><a href="diffedit">DiffEdit</a></td> <td>inpainting</td></tr> <tr><td><a href="dit">DiT</a></td> <td>text2image</td></tr> <tr><td><a href="flux">Flux</a></td> <td>text2image</td></tr> <tr><td><a href="hunyuandit">Hunyuan-DiT</a></td> <td>text2image</td></tr> <tr><td><a href="i2vgenxl">I2VGen-XL</a></td> <td>image2video</td></tr> <tr><td><a href="pix2pix">InstructPix2Pix</a></td> <td>image editing</td></tr> <tr><td><a href="kandinsky">Kandinsky 2.1</a></td> <td>text2image, image2image, inpainting, interpolation</td></tr> <tr><td><a href="kandinsky_v22">Kandinsky 2.2</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="kandinsky3">Kandinsky 3</a></td> <td>text2image, image2image</td></tr> <tr><td><a href="kolors">Kolors</a></td> <td>text2image</td></tr> <tr><td><a href="latent_consistency_models">Latent Consistency Models</a></td> <td>text2image</td></tr> <tr><td><a href="latent_diffusion">Latent Diffusion</a></td> <td>text2image, super-resolution</td></tr> <tr><td><a href="latte">Latte</a></td> <td>text2image</td></tr> <tr><td><a href="ledits_pp">LEDITS++</a></td> <td>image editing</td></tr> <tr><td><a href="lumina">Lumina-T2X</a></td> <td>text2image</td></tr> <tr><td><a href="marigold">Marigold</a></td> <td>depth-estimation, normals-estimation, intrinsic-decomposition</td></tr> <tr><td><a href="panorama">MultiDiffusion</a></td> <td>text2image</td></tr> <tr><td><a href="musicldm">MusicLDM</a></td> <td>text2audio</td></tr> <tr><td><a href="pag">PAG</a></td> <td>text2image</td></tr> <tr><td><a href="paint_by_example">Paint by Example</a></td> <td>inpainting</td></tr> <tr><td><a href="pia">PIA</a></td> <td>image2video</td></tr> <tr><td><a href="pixart">PixArt-α</a></td> <td>text2image</td></tr> <tr><td><a href="pixart_sigma">PixArt-Σ</a></td> <td>text2image</td></tr> <tr><td><a href="self_attention_guidance">Self-Attention Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="semantic_stable_diffusion">Semantic Guidance</a></td> <td>text2image</td></tr> <tr><td><a href="shap_e">Shap-E</a></td> <td>text-to-3D, image-to-3D</td></tr> <tr><td><a href="stable_audio">Stable Audio</a></td> <td>text2audio</td></tr> <tr><td><a href="stable_cascade">Stable Cascade</a></td> <td>text2image</td></tr> <tr><td><a href="stable_diffusion/overview">Stable Diffusion</a></td> <td>text2image, image2image, depth2image, inpainting, image variation, latent upscaler, super-resolution</td></tr> <tr><td><a href="stable_diffusion/stable_diffusion_xl">Stable Diffusion XL</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_diffusion/sdxl_turbo">Stable Diffusion XL Turbo</a></td> <td>text2image, image2image, inpainting</td></tr> <tr><td><a href="stable_unclip">Stable unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="stable_diffusion/adapter">T2I-Adapter</a></td> <td>text2image</td></tr> <tr><td><a href="text_to_video">Text2Video</a></td> <td>text2video, video2video</td></tr> <tr><td><a href="text_to_video_zero">Text2Video-Zero</a></td> <td>text2video</td></tr> <tr><td><a href="unclip">unCLIP</a></td> <td>text2image, image variation</td></tr> <tr><td><a href="unidiffuser">UniDiffuser</a></td> <td>text2image, image2text, image variation, text variation, unconditional image generation, unconditional audio generation</td></tr> <tr><td><a href="value_guided_sampling">Value-guided planning</a></td> <td>value guided sampling</td></tr> <tr><td><a href="wuerstchen">Wuerstchen</a></td> <td>text2image</td></tr> <tr><td><a href="visualcloze">VisualCloze</a></td> <td>text2image, image2image, subject driven generation, inpainting, style transfer, image restoration, image editing, [depth,normal,edge,pose]2image, [depth,normal,edge,pose]-estimation, virtual try-on, image relighting</td></tr></tbody>',Qn,Ne,qn,x,Ve,vo,Zt,rs="Base class for all pipelines.",xo,Gt,ls=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,$o,Jt,ds="<li>move all PyTorch modules to the device of your choice</li> <li>enable/disable the progress bar for the denoising iteration</li>",wo,It,ps="Class attributes:",Mo,Ht,fs=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li> <li><strong>_optional_components</strong> (<code>List[str]</code>) — List of all optional components that don’t have to be passed to the
pipeline to function (should be overridden by subclasses).</li>`,To,fe,Be,ko,Wt,cs="Call self as a function.",Co,Lt,Xe,Uo,H,Re,Po,Ft,us=`Performs Pipeline dtype and/or device conversion. A torch.dtype and torch.device are inferred from the
arguments of <code>self.to(*args, **kwargs).</code>`,Do,ce,jo,St,ms="Here are the ways to call <code>to</code>:",Zo,Nt,hs=`<li><code>to(dtype, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li> <li><code>to(device, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a></li> <li><code>to(device=None, dtype=None, silence_dtype_warnings=False) → DiffusionPipeline</code> to return a pipeline with the
specified <a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a> and
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a></li>`,Go,F,Ee,Jo,Vt,gs=`The <code>self.components</code> property can be useful to run different pipelines with the same weights and
configurations without reallocating additional memory.`,Io,Bt,bs=`Returns (<code>dict</code>):
A dictionary containing all the modules needed to initialize the pipeline.`,Ho,ue,Wo,me,ze,Lo,Xt,_s=`Disable sliced attention computation. If <code>enable_attention_slicing</code> was previously called, attention is
computed in one step.`,Fo,he,Ye,So,Rt,ys='Disable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>.',No,ne,Qe,Vo,Et,vs="Download and cache a PyTorch diffusion pipeline from pretrained pipeline weights.",Bo,ge,Xo,S,qe,Ro,zt,xs=`Enable sliced attention computation. When this option is enabled, the attention module splits the input tensor
in slices to compute attention in several steps. For more than one attention head, the computation is performed
sequentially over each head. This is useful to save some memory in exchange for a small speed decrease.`,Eo,be,zo,_e,Yo,ye,Ae,Qo,Yt,$s=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the accelerator when its
<code>forward</code> method is called, and the model remains in accelerator until the next model runs. Memory savings are
lower than with <code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution
of the <code>unet</code>.`,qo,ve,Oe,Ao,Qt,ws=`Offloads all models to CPU using 🤗 Accelerate, significantly reducing memory usage. When called, the state
dicts of all <code>torch.nn.Module</code> components (except those in <code>self._exclude_from_cpu_offload</code>) are saved to CPU
and then moved to <code>torch.device(&#39;meta&#39;)</code> and loaded to accelerator only when their specific submodule has its
<code>forward</code> method called. Offloading happens on a submodule basis. Memory savings are higher than with
<code>enable_model_cpu_offload</code>, but performance is lower.`,Oo,N,Ke,Ko,qt,Ms=`Enable memory efficient attention from <a href="https://facebookresearch.github.io/xformers/" rel="nofollow">xFormers</a>. When this
option is enabled, you should observe lower GPU memory usage and a potential speed up during inference. Speed
up during training is not guaranteed.`,ei,xe,ti,$e,ni,oe,et,oi,At,Ts=`Create a new pipeline from a given pipeline. This method is useful to create a new pipeline from the existing
pipeline components without reallocating additional memory.`,ii,we,si,Z,tt,ai,Ot,ks="Instantiate a PyTorch diffusion pipeline from pretrained pipeline weights.",ri,Kt,Cs="The pipeline is set in evaluation mode (<code>model.eval()</code>) by default.",li,Me,di,Te,pi,ke,fi,V,nt,ci,en,Us="Method that performs the following:",ui,tn,Ps=`<li>Offloads all components.</li> <li>Removes all model hooks that were added when using <code>enable_model_cpu_offload</code>, and then applies them again.
In case the model has not been offloaded, this function is a no-op.</li> <li>Resets stateful diffusers hooks of denoiser components if they were added with
<code>register_hook()</code>.</li>`,mi,nn,Ds=`Make sure to add this function to the end of the <code>__call__</code> function of your pipeline so that it functions
correctly when applying <code>enable_model_cpu_offload</code>.`,hi,Ce,ot,gi,on,js="Convert a NumPy image or a batch of images to a PIL image.",bi,Ue,it,_i,sn,Zs="Removes all hooks that were added when using <code>enable_sequential_cpu_offload</code> or <code>enable_model_cpu_offload</code>.",yi,Pe,st,vi,an,Gs="Resets the device maps (if any) to None.",xi,De,at,$i,rn,Js=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,An,W,rt,wi,ln,Is='Enables the FreeU mechanism as in <a href="https://huggingface.co/papers/2309.11497" rel="nofollow">https://huggingface.co/papers/2309.11497</a>.',Mi,dn,Hs="The suffixes after the scaling factors represent the stages where they are being applied.",Ti,pn,Ws=`Please refer to the <a href="https://github.com/ChenyangSi/FreeU" rel="nofollow">official repository</a> for combinations of the values
that are known to work well for different pipelines such as Stable Diffusion v1, v2, and Stable Diffusion XL.`,On,se,lt,ki,fn,Ls="Disables the FreeU mechanism if enabled.",Kn,dt,eo,P,pt,Ci,cn,Fs="Base class for Flax-based pipelines.",Ui,un,Ss=`<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline">FlaxDiffusionPipeline</a> stores all components (models, schedulers, and processors) for diffusion pipelines and
provides methods for loading, downloading and saving models. It also includes methods to:`,Pi,mn,Ns="<li>enable/disable the progress bar for the denoising iteration</li>",Di,hn,Vs="Class attributes:",ji,gn,Bs=`<li><strong>config_name</strong> (<code>str</code>) — The configuration filename that stores the class and module names of all the
diffusion pipeline’s components.</li>`,Zi,G,ft,Gi,bn,Xs="Instantiate a Flax-based diffusion pipeline from pretrained pipeline weights.",Ji,_n,Rs="The pipeline is set in evaluation mode (`model.eval()) by default and dropout modules are deactivated.",Ii,je,Hi,Ze,Wi,Ge,Li,Je,ct,Fi,yn,Es="Convert a NumPy image or a batch of images to a PIL image.",Si,Ie,ut,Ni,vn,zs=`Save all saveable variables of the pipeline to a directory. A pipeline variable can be saved and loaded if its
class implements both a save and loading method. The pipeline is easily reloaded using the
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.from_pretrained">from_pretrained()</a> class method.`,to,mt,no,X,ht,Vi,xn,Ys="A Mixin to push a model, scheduler, or pipeline to the Hugging Face Hub.",Bi,ie,gt,Xi,$n,Qs="Upload model, scheduler, or pipeline files to the 🤗 Hugging Face Hub.",Ri,He,oo,bt,io,R,_t,Ei,wn,qs=`Base class for all the official callbacks used in a pipeline. This class provides a structure for implementing
custom callbacks and ensures that all callbacks have a consistent interface.`,zi,Mn,As=`Please implement the following:
<code>tensor_inputs</code>: This should return a list of tensor inputs specific to your callback. You will only be able to
include
variables listed in the <code>._callback_tensor_inputs</code> attribute of your pipeline class.
<code>callback_fn</code>: This method defines the core functionality of your callback.`,so,E,yt,Yi,Tn,Os=`Callback function for Stable Diffusion Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,Qi,kn,Ks="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",ao,z,vt,qi,Cn,ea=`Callback function for the base Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,Ai,Un,ta="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",ro,Y,xt,Oi,Pn,na=`Callback function for the Controlnet Stable Diffusion XL Pipelines. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will disable the CFG.`,Ki,Dn,oa="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",lo,Q,$t,es,jn,ia=`Callback function for any pipeline that inherits <code>IPAdapterMixin</code>. After certain number of steps (set by
<code>cutoff_step_ratio</code> or <code>cutoff_step_index</code>), this callback will set the IP Adapter scale to <code>0.0</code>.`,ts,Zn,sa="Note: This callback mutates the IP Adapter attention processors by setting the scale to 0.0 after the cutoff step.",po,q,wt,ns,Gn,aa=`Callback function for Stable Diffusion 3 Pipelines. After certain number of steps (set by <code>cutoff_step_ratio</code> or
<code>cutoff_step_index</code>), this callback will disable the CFG.`,os,Jn,ra="Note: This callback mutates the pipeline by changing the <code>_guidance_scale</code> attribute to 0.0 after the cutoff step.",fo,Mt,co,Bn,uo;return v=new Rn({props:{title:"Pipelines",local:"pipelines",headingTag:"h1"}}),pe=new jt({props:{warning:!0,$$slots:{default:[ma]},$$scope:{ctx:C}}}),Ne=new Rn({props:{title:"DiffusionPipeline",local:"diffusers.DiffusionPipeline",headingTag:"h2"}}),Ve=new U({props:{name:"class diffusers.DiffusionPipeline",anchor:"diffusers.DiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L180"}}),Be=new U({props:{name:"__call__",anchor:"diffusers.DiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Xe=new U({props:{name:"device",anchor:"diffusers.DiffusionPipeline.device",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The torch device on which the pipeline is located.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.device</code></p>
`}}),Re=new U({props:{name:"to",anchor:"diffusers.DiffusionPipeline.to",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.to.dtype",description:`<strong>dtype</strong> (<code>torch.dtype</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.dtype" rel="nofollow"><code>dtype</code></a>`,name:"dtype"},{anchor:"diffusers.DiffusionPipeline.to.device",description:`<strong>device</strong> (<code>torch.Device</code>, <em>optional</em>) &#x2014;
Returns a pipeline with the specified
<a href="https://pytorch.org/docs/stable/tensor_attributes.html#torch.device" rel="nofollow"><code>device</code></a>`,name:"device"},{anchor:"diffusers.DiffusionPipeline.to.silence_dtype_warnings",description:`<strong>silence_dtype_warnings</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to omit warnings if the target <code>dtype</code> is not compatible with the target <code>device</code>.`,name:"silence_dtype_warnings"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L369",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The pipeline converted to specified <code>dtype</code> and/or <code>dtype</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline"
>DiffusionPipeline</a></p>
`}}),ce=new jt({props:{$$slots:{default:[ha]},$$scope:{ctx:C}}}),Ee=new U({props:{name:"components",anchor:"diffusers.DiffusionPipeline.components",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1712"}}),ue=new le({props:{anchor:"diffusers.DiffusionPipeline.components.example",$$slots:{default:[ga]},$$scope:{ctx:C}}}),ze=new U({props:{name:"disable_attention_slicing",anchor:"diffusers.DiffusionPipeline.disable_attention_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1877"}}),Ye=new U({props:{name:"disable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.disable_xformers_memory_efficient_attention",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1811"}}),Qe=new U({props:{name:"download",anchor:"diffusers.DiffusionPipeline.download",parameters:[{name:"pretrained_model_name",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.download.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.`,name:"pretrained_model_name"},{anchor:"diffusers.DiffusionPipeline.download.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>
<p>A string, the <em>repository id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained
pipeline hosted on the Hub. The repository must contain a file called <code>pipeline.py</code> that defines
the custom pipeline.</p>
</li>
<li>
<p>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current <code>main</code> branch of GitHub.</p>
</li>
<li>
<p>A path to a <em>directory</em> (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</p>
</li>
</ul>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>For more information on how to load and create custom pipelines, take a look at <a href="https://huggingface.co/docs/diffusers/main/en/using-diffusers/contribute_pipeline" rel="nofollow">How to contribute a
community pipeline</a>.`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.download.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.download.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.download.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.download.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.download.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.download.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.download.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. It can be a &#x1F917; Diffusers version when loading a
custom pipeline from GitHub, otherwise it defaults to <code>&quot;main&quot;</code> when loading from the Hub.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.download.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.download.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.download.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified DDUF file.`,name:"dduf_file(str,"},{anchor:"diffusers.DiffusionPipeline.download.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.download.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.download.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom pipelines and components defined on the Hub in their own files. This
option should only be set to <code>True</code> for repositories you trust and in which you have read the code, as
it will execute code present on the Hub on your local machine.`,name:"trust_remote_code"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1350",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A path to the downloaded pipeline.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>os.PathLike</code></p>
`}}),ge=new jt({props:{$$slots:{default:[ba]},$$scope:{ctx:C}}}),qe=new U({props:{name:"enable_attention_slicing",anchor:"diffusers.DiffusionPipeline.enable_attention_slicing",parameters:[{name:"slice_size",val:": typing.Union[int, str, NoneType] = 'auto'"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.slice_size",description:`<strong>slice_size</strong> (<code>str</code> or <code>int</code>, <em>optional</em>, defaults to <code>&quot;auto&quot;</code>) &#x2014;
When <code>&quot;auto&quot;</code>, halves the input to the attention heads, so attention will be computed in two steps. If
<code>&quot;max&quot;</code>, maximum amount of memory will be saved by running only one slice at a time. If a number is
provided, uses as many slices as <code>attention_head_dim // slice_size</code>. In this case, <code>attention_head_dim</code>
must be a multiple of <code>slice_size</code>.`,name:"slice_size"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1837"}}),be=new jt({props:{warning:!0,$$slots:{default:[_a]},$$scope:{ctx:C}}}),_e=new le({props:{anchor:"diffusers.DiffusionPipeline.enable_attention_slicing.example",$$slots:{default:[ya]},$$scope:{ctx:C}}}),Ae=new U({props:{name:"enable_model_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_model_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1154"}}),Oe=new U({props:{name:"enable_sequential_cpu_offload",anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload",parameters:[{name:"gpu_id",val:": typing.Optional[int] = None"},{name:"device",val:": typing.Union[torch.device, str] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.gpu_id",description:`<strong>gpu_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The ID of the accelerator that shall be used in inference. If not specified, it will default to 0.`,name:"gpu_id"},{anchor:"diffusers.DiffusionPipeline.enable_sequential_cpu_offload.device",description:`<strong>device</strong> (<code>torch.Device</code> or <code>str</code>, <em>optional</em>, defaults to None) &#x2014;
The PyTorch device type of the accelerator that shall be used in inference. If not specified, it will
automatically detect the available accelerator and use.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1270"}}),Ke=new U({props:{name:"enable_xformers_memory_efficient_attention",anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention",parameters:[{name:"attention_op",val:": typing.Optional[typing.Callable] = None"}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.attention_op",description:`<strong>attention_op</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
Override the default <code>None</code> operator for use as <code>op</code> argument to the
<a href="https://facebookresearch.github.io/xformers/components/ops.html#xformers.ops.memory_efficient_attention" rel="nofollow"><code>memory_efficient_attention()</code></a>
function of xFormers.`,name:"attention_op"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1776"}}),xe=new jt({props:{warning:!0,$$slots:{default:[va]},$$scope:{ctx:C}}}),$e=new le({props:{anchor:"diffusers.DiffusionPipeline.enable_xformers_memory_efficient_attention.example",$$slots:{default:[xa]},$$scope:{ctx:C}}}),et=new U({props:{name:"from_pipe",anchor:"diffusers.DiffusionPipeline.from_pipe",parameters:[{name:"pipeline",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pipe.pipeline",description:`<strong>pipeline</strong> (<code>DiffusionPipeline</code>) &#x2014;
The pipeline from which to create a new pipeline.`,name:"pipeline"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1893",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A new pipeline with the same weights and configurations as <code>pipeline</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>DiffusionPipeline</code></p>
`}}),we=new le({props:{anchor:"diffusers.DiffusionPipeline.from_pipe.example",$$slots:{default:[$a]},$$scope:{ctx:C}}}),tt=new U({props:{name:"from_pretrained",anchor:"diffusers.DiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>CompVis/ldm-text2im-large-256</code>) of a pretrained pipeline
hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing pipeline weights
saved using
<a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
<li>A path to a <em>directory</em> (for example <code>./my_pipeline_directory/</code>) containing a dduf file</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.torch_dtype",description:`<strong>torch_dtype</strong> (<code>torch.dtype</code> or <code>dict[str, Union[str, torch.dtype]]</code>, <em>optional</em>) &#x2014;
Override the default <code>torch.dtype</code> and load the model with another dtype. To load submodels with
different dtype pass a <code>dict</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;vae&apos;: torch.float16}</code>).
Set the default dtype for unspecified components with <code>default</code> (for example <code>{&apos;transformer&apos;: torch.bfloat16, &apos;default&apos;: torch.float16}</code>). If a component is not specified and no default is set,
<code>torch.float32</code> is used.`,name:"torch_dtype"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_pipeline",description:`<strong>custom_pipeline</strong> (<code>str</code>, <em>optional</em>) &#x2014;</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>&#x1F9EA; This is an experimental feature and may change in the future.</p>

					</div>
<p>Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>hf-internal-testing/diffusers-dummy-pipeline</code>) of a custom
pipeline hosted on the Hub. The repository must contain a file called pipeline.py that defines
the custom pipeline.</li>
<li>A string, the <em>file name</em> of a community pipeline hosted on GitHub under
<a href="https://github.com/huggingface/diffusers/tree/main/examples/community" rel="nofollow">Community</a>. Valid file
names must match the file name and not the pipeline script (<code>clip_guided_stable_diffusion</code>
instead of <code>clip_guided_stable_diffusion.py</code>). Community pipelines are always loaded from the
current main branch of GitHub.</li>
<li>A path to a directory (<code>./my_pipeline_directory/</code>) containing a custom pipeline. The directory
must contain a file called <code>pipeline.py</code> that defines the custom pipeline.</li>
</ul>
<p>For more information on how to load and create custom pipelines, please have a look at <a href="https://huggingface.co/docs/diffusers/using-diffusers/custom_pipeline_overview" rel="nofollow">Loading and
Adding Custom
Pipelines</a>`,name:"custom_pipeline"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Union[str, os.PathLike]</code>, <em>optional</em>) &#x2014;
Path to a directory where a downloaded pretrained model configuration is cached if the standard cache
is not used.`,name:"cache_dir"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.custom_revision",description:`<strong>custom_revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id similar to
<code>revision</code> when loading a custom pipeline from the Hub. Defaults to the latest stable &#x1F917; Diffusers
version.`,name:"custom_revision"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.device_map",description:`<strong>device_map</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Strategy that dictates how the different components of a pipeline should be placed on available
devices. Currently, only &#x201C;balanced&#x201D; <code>device_map</code> is supported. Check out
<a href="https://huggingface.co/docs/diffusers/main/en/tutorials/inference_with_big_models#device-placement" rel="nofollow">this</a>
to know more.`,name:"device_map"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.max_memory",description:`<strong>max_memory</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
A dictionary device identifier for the maximum memory. Will default to the maximum memory available for
each GPU and the available CPU RAM if unset.`,name:"max_memory"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_folder",description:`<strong>offload_folder</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
The path to offload weights if device_map contains the value <code>&quot;disk&quot;</code>.`,name:"offload_folder"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.offload_state_dict",description:`<strong>offload_state_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If <code>True</code>, temporarily offloads the CPU state dict to the hard drive to avoid running out of CPU RAM if
the weight of the CPU state dict + the biggest shard of the checkpoint does not fit. Defaults to <code>True</code>
when there is some disk offload.`,name:"offload_state_dict"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.low_cpu_mem_usage",description:`<strong>low_cpu_mem_usage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code> if torch version &gt;= 1.9.0 else <code>False</code>) &#x2014;
Speed up model loading only loading the pretrained weights and not initializing the weights. This also
tries to not use more than 1x model size in CPU memory (including peak memory) while loading the model.
Only supported for PyTorch &gt;= 1.9.0. If you are using an older version of PyTorch, setting this
argument to <code>True</code> will raise an error.`,name:"low_cpu_mem_usage"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_safetensors",description:`<strong>use_safetensors</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>None</code>, the safetensors weights are downloaded if they&#x2019;re available <strong>and</strong> if the
safetensors library is installed. If set to <code>True</code>, the model is forcibly loaded from safetensors
weights. If set to <code>False</code>, safetensors weights are not loaded.`,name:"use_safetensors"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.use_onnx",description:`<strong>use_onnx</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
If set to <code>True</code>, ONNX weights will always be downloaded if present. If set to <code>False</code>, ONNX weights
will never be downloaded. By default <code>use_onnx</code> defaults to the <code>_is_onnx</code> class attribute which is
<code>False</code> for non-ONNX pipelines and <code>True</code> for ONNX pipelines. ONNX weights include both files ending
with <code>.onnx</code> and <code>.pb</code>.`,name:"use_onnx"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components of the specific pipeline
class). The overwritten components are passed directly to the pipelines <code>__init__</code> method. See example
below for more information.`,name:"kwargs"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Load weights from a specified variant filename such as <code>&quot;fp16&quot;</code> or <code>&quot;ema&quot;</code>. This is ignored when
loading <code>from_flax</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.from_pretrained.dduf_file(str,",description:`<strong>dduf_file(<code>str</code>,</strong> <em>optional</em>) &#x2014;
Load weights from the specified dduf file.`,name:"dduf_file(str,"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L588"}}),Me=new le({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example",$$slots:{default:[wa]},$$scope:{ctx:C}}}),Te=new jt({props:{$$slots:{default:[Ma]},$$scope:{ctx:C}}}),ke=new le({props:{anchor:"diffusers.DiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ta]},$$scope:{ctx:C}}}),nt=new U({props:{name:"maybe_free_model_hooks",anchor:"diffusers.DiffusionPipeline.maybe_free_model_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1247"}}),ot=new U({props:{name:"numpy_to_pil",anchor:"diffusers.DiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1750"}}),it=new U({props:{name:"remove_all_hooks",anchor:"diffusers.DiffusionPipeline.remove_all_hooks",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1145"}}),st=new U({props:{name:"reset_device_map",anchor:"diffusers.DiffusionPipeline.reset_device_map",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L1337"}}),at=new U({props:{name:"save_pretrained",anchor:"diffusers.DiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"max_shard_size",val:": typing.Union[int, str, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.DiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to save a pipeline to. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way with <code>pickle</code>.`,name:"safe_serialization"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, defaults to <code>None</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5GB&quot;</code>).
If expressed as an integer, the unit is bytes. Note that this limit will be decreased after a certain
period of time (starting from Oct 2024) to allow users to upgrade to the latest version of <code>diffusers</code>.
This is to establish a common default size for this argument across different libraries in the Hugging
Face ecosystem (<code>transformers</code>, and <code>accelerate</code>, for example).`,name:"max_shard_size"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.DiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L236"}}),rt=new U({props:{name:"diffusers.StableDiffusionMixin.enable_freeu",anchor:"diffusers.StableDiffusionMixin.enable_freeu",parameters:[{name:"s1",val:": float"},{name:"s2",val:": float"},{name:"b1",val:": float"},{name:"b2",val:": float"}],parametersDescription:[{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s1",description:`<strong>s1</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 1 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.s2",description:`<strong>s2</strong> (<code>float</code>) &#x2014;
Scaling factor for stage 2 to attenuate the contributions of the skip features. This is done to
mitigate &#x201C;oversmoothing effect&#x201D; in the enhanced denoising process.`,name:"s2"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b1",description:"<strong>b1</strong> (<code>float</code>) &#x2014; Scaling factor for stage 1 to amplify the contributions of backbone features.",name:"b1"},{anchor:"diffusers.StableDiffusionMixin.enable_freeu.b2",description:"<strong>b2</strong> (<code>float</code>) &#x2014; Scaling factor for stage 2 to amplify the contributions of backbone features.",name:"b2"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2071"}}),lt=new U({props:{name:"diffusers.StableDiffusionMixin.disable_freeu",anchor:"diffusers.StableDiffusionMixin.disable_freeu",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_utils.py#L2093"}}),dt=new Rn({props:{title:"FlaxDiffusionPipeline",local:"diffusers.FlaxDiffusionPipeline",headingTag:"h2"}}),pt=new U({props:{name:"class diffusers.FlaxDiffusionPipeline",anchor:"diffusers.FlaxDiffusionPipeline",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L101"}}),ft=new U({props:{name:"from_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": typing.Union[str, os.PathLike, NoneType]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>repo id</em> (for example <code>stable-diffusion-v1-5/stable-diffusion-v1-5</code>) of a
pretrained pipeline hosted on the Hub.</li>
<li>A path to a <em>directory</em> (for example <code>./my_model_directory</code>) containing the model weights saved
using <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.FlaxDiffusionPipeline.save_pretrained">save_pretrained()</a>.</li>
</ul>`,name:"pretrained_model_name_or_path"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.dtype",description:`<strong>dtype</strong> (<code>jnp.dtype</code>, <em>optional</em>) &#x2014;
Override the default <code>jnp.dtype</code> and load the model under this dtype.`,name:"dtype"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, for example, <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}</code>. The proxies are used on each request.`,name:"proxies"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.output_loading_info(bool,",description:`<strong>output_loading_info(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to also return a dictionary containing missing keys, unexpected keys and error messages.`,name:"output_loading_info(bool,"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only load local model weights and configuration files or not. If set to <code>True</code>, the model
won&#x2019;t be downloaded from the Hub.`,name:"local_files_only"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <em>bool</em>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, the token generated from
<code>diffusers-cli login</code> (stored in <code>~/.huggingface</code>) is used.`,name:"token"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, a commit id, or any identifier
allowed by Git.`,name:"revision"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.mirror",description:`<strong>mirror</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Mirror source to resolve accessibility issues if you&#x2019;re downloading a model in China. We do not
guarantee the timeliness or safety of the source, and you should refer to the mirror site for more
information.`,name:"mirror"},{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.kwargs",description:`<strong>kwargs</strong> (remaining dictionary of keyword arguments, <em>optional</em>) &#x2014;
Can be used to overwrite load and saveable variables (the pipeline components) of the specific pipeline
class. The overwritten components are passed directly to the pipelines <code>__init__</code> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L229"}}),je=new le({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example",$$slots:{default:[ka]},$$scope:{ctx:C}}}),Ze=new jt({props:{$$slots:{default:[Ca]},$$scope:{ctx:C}}}),Ge=new le({props:{anchor:"diffusers.FlaxDiffusionPipeline.from_pretrained.example-2",$$slots:{default:[Ua]},$$scope:{ctx:C}}}),ct=new U({props:{name:"numpy_to_pil",anchor:"diffusers.FlaxDiffusionPipeline.numpy_to_pil",parameters:[{name:"images",val:""}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L582"}}),ut=new U({props:{name:"save_pretrained",anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"params",val:": typing.Union[typing.Dict, flax.core.frozen_dict.FrozenDict]"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"diffusers.FlaxDiffusionPipeline.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional keyword arguments passed along to the <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/pipeline_flax_utils.py#L151"}}),mt=new Rn({props:{title:"PushToHubMixin",local:"diffusers.utils.PushToHubMixin",headingTag:"h2"}}),ht=new U({props:{name:"class diffusers.utils.PushToHubMixin",anchor:"diffusers.utils.PushToHubMixin",parameters:[],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L464"}}),gt=new U({props:{name:"push_to_hub",anchor:"diffusers.utils.PushToHubMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": typing.Optional[str] = None"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"variant",val:": typing.Optional[str] = None"},{name:"subfolder",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your model, scheduler, or pipeline files to. It should
contain your organization name when pushing to an organization. <code>repo_id</code> can also be a path to a local
directory.`,name:"repo_id"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Default to <code>&quot;Upload {object}&quot;</code>.`,name:"commit_message"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to make the repo private. If <code>None</code> (default), the repo will be public unless the
organization&#x2019;s default is private. This value is ignored if the repo already exists.`,name:"private"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. The token generated when running <code>hf auth login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights to the <code>safetensors</code> format.`,name:"safe_serialization"},{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.variant",description:`<strong>variant</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If specified, weights are saved in the format <code>pytorch_model.&lt;variant&gt;.bin</code>.`,name:"variant"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/utils/hub_utils.py#L499"}}),He=new le({props:{anchor:"diffusers.utils.PushToHubMixin.push_to_hub.example",$$slots:{default:[Pa]},$$scope:{ctx:C}}}),bt=new Rn({props:{title:"Callbacks",local:"diffusers.callbacks.PipelineCallback",headingTag:"h2"}}),_t=new U({props:{name:"class diffusers.callbacks.PipelineCallback",anchor:"diffusers.callbacks.PipelineCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L7"}}),yt=new U({props:{name:"class diffusers.callbacks.SDCFGCutoffCallback",anchor:"diffusers.callbacks.SDCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L69"}}),vt=new U({props:{name:"class diffusers.callbacks.SDXLCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L98"}}),xt=new U({props:{name:"class diffusers.callbacks.SDXLControlnetCFGCutoffCallback",anchor:"diffusers.callbacks.SDXLControlnetCFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L140"}}),$t=new U({props:{name:"class diffusers.callbacks.IPAdapterScaleCutoffCallback",anchor:"diffusers.callbacks.IPAdapterScaleCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L188"}}),wt=new U({props:{name:"class diffusers.callbacks.SD3CFGCutoffCallback",anchor:"diffusers.callbacks.SD3CFGCutoffCallback",parameters:[{name:"cutoff_step_ratio",val:" = 1.0"},{name:"cutoff_step_index",val:" = None"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/callbacks.py#L212"}}),Mt=new ua({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/overview.md"}}),{c(){o=a("meta"),$=i(),p=a("p"),d=i(),m(v.$$.fragment),n=i(),M=a("p"),M.textContent=j,te=i(),Le=a("p"),Le.innerHTML=is,En=i(),m(pe.$$.fragment),zn=i(),Fe=a("p"),Fe.textContent=ss,Yn=i(),Se=a("table"),Se.innerHTML=as,Qn=i(),m(Ne.$$.fragment),qn=i(),x=a("div"),m(Ve.$$.fragment),vo=i(),Zt=a("p"),Zt.textContent=rs,xo=i(),Gt=a("p"),Gt.innerHTML=ls,$o=i(),Jt=a("ul"),Jt.innerHTML=ds,wo=i(),It=a("p"),It.textContent=ps,Mo=i(),Ht=a("ul"),Ht.innerHTML=fs,To=i(),fe=a("div"),m(Be.$$.fragment),ko=i(),Wt=a("p"),Wt.textContent=cs,Co=i(),Lt=a("div"),m(Xe.$$.fragment),Uo=i(),H=a("div"),m(Re.$$.fragment),Po=i(),Ft=a("p"),Ft.innerHTML=us,Do=i(),m(ce.$$.fragment),jo=i(),St=a("p"),St.innerHTML=ms,Zo=i(),Nt=a("ul"),Nt.innerHTML=hs,Go=i(),F=a("div"),m(Ee.$$.fragment),Jo=i(),Vt=a("p"),Vt.innerHTML=gs,Io=i(),Bt=a("p"),Bt.innerHTML=bs,Ho=i(),m(ue.$$.fragment),Wo=i(),me=a("div"),m(ze.$$.fragment),Lo=i(),Xt=a("p"),Xt.innerHTML=_s,Fo=i(),he=a("div"),m(Ye.$$.fragment),So=i(),Rt=a("p"),Rt.innerHTML=ys,No=i(),ne=a("div"),m(Qe.$$.fragment),Vo=i(),Et=a("p"),Et.textContent=vs,Bo=i(),m(ge.$$.fragment),Xo=i(),S=a("div"),m(qe.$$.fragment),Ro=i(),zt=a("p"),zt.textContent=xs,Eo=i(),m(be.$$.fragment),zo=i(),m(_e.$$.fragment),Yo=i(),ye=a("div"),m(Ae.$$.fragment),Qo=i(),Yt=a("p"),Yt.innerHTML=$s,qo=i(),ve=a("div"),m(Oe.$$.fragment),Ao=i(),Qt=a("p"),Qt.innerHTML=ws,Oo=i(),N=a("div"),m(Ke.$$.fragment),Ko=i(),qt=a("p"),qt.innerHTML=Ms,ei=i(),m(xe.$$.fragment),ti=i(),m($e.$$.fragment),ni=i(),oe=a("div"),m(et.$$.fragment),oi=i(),At=a("p"),At.textContent=Ts,ii=i(),m(we.$$.fragment),si=i(),Z=a("div"),m(tt.$$.fragment),ai=i(),Ot=a("p"),Ot.textContent=ks,ri=i(),Kt=a("p"),Kt.innerHTML=Cs,li=i(),m(Me.$$.fragment),di=i(),m(Te.$$.fragment),pi=i(),m(ke.$$.fragment),fi=i(),V=a("div"),m(nt.$$.fragment),ci=i(),en=a("p"),en.textContent=Us,ui=i(),tn=a("ul"),tn.innerHTML=Ps,mi=i(),nn=a("p"),nn.innerHTML=Ds,hi=i(),Ce=a("div"),m(ot.$$.fragment),gi=i(),on=a("p"),on.textContent=js,bi=i(),Ue=a("div"),m(it.$$.fragment),_i=i(),sn=a("p"),sn.innerHTML=Zs,yi=i(),Pe=a("div"),m(st.$$.fragment),vi=i(),an=a("p"),an.textContent=Gs,xi=i(),De=a("div"),m(at.$$.fragment),$i=i(),rn=a("p"),rn.innerHTML=Js,An=i(),W=a("div"),m(rt.$$.fragment),wi=i(),ln=a("p"),ln.innerHTML=Is,Mi=i(),dn=a("p"),dn.textContent=Hs,Ti=i(),pn=a("p"),pn.innerHTML=Ws,On=i(),se=a("div"),m(lt.$$.fragment),ki=i(),fn=a("p"),fn.textContent=Ls,Kn=i(),m(dt.$$.fragment),eo=i(),P=a("div"),m(pt.$$.fragment),Ci=i(),cn=a("p"),cn.textContent=Fs,Ui=i(),un=a("p"),un.innerHTML=Ss,Pi=i(),mn=a("ul"),mn.innerHTML=Ns,Di=i(),hn=a("p"),hn.textContent=Vs,ji=i(),gn=a("ul"),gn.innerHTML=Bs,Zi=i(),G=a("div"),m(ft.$$.fragment),Gi=i(),bn=a("p"),bn.textContent=Xs,Ji=i(),_n=a("p"),_n.textContent=Rs,Ii=i(),m(je.$$.fragment),Hi=i(),m(Ze.$$.fragment),Wi=i(),m(Ge.$$.fragment),Li=i(),Je=a("div"),m(ct.$$.fragment),Fi=i(),yn=a("p"),yn.textContent=Es,Si=i(),Ie=a("div"),m(ut.$$.fragment),Ni=i(),vn=a("p"),vn.innerHTML=zs,to=i(),m(mt.$$.fragment),no=i(),X=a("div"),m(ht.$$.fragment),Vi=i(),xn=a("p"),xn.textContent=Ys,Bi=i(),ie=a("div"),m(gt.$$.fragment),Xi=i(),$n=a("p"),$n.textContent=Qs,Ri=i(),m(He.$$.fragment),oo=i(),m(bt.$$.fragment),io=i(),R=a("div"),m(_t.$$.fragment),Ei=i(),wn=a("p"),wn.textContent=qs,zi=i(),Mn=a("p"),Mn.innerHTML=As,so=i(),E=a("div"),m(yt.$$.fragment),Yi=i(),Tn=a("p"),Tn.innerHTML=Os,Qi=i(),kn=a("p"),kn.innerHTML=Ks,ao=i(),z=a("div"),m(vt.$$.fragment),qi=i(),Cn=a("p"),Cn.innerHTML=ea,Ai=i(),Un=a("p"),Un.innerHTML=ta,ro=i(),Y=a("div"),m(xt.$$.fragment),Oi=i(),Pn=a("p"),Pn.innerHTML=na,Ki=i(),Dn=a("p"),Dn.innerHTML=oa,lo=i(),Q=a("div"),m($t.$$.fragment),es=i(),jn=a("p"),jn.innerHTML=ia,ts=i(),Zn=a("p"),Zn.textContent=sa,po=i(),q=a("div"),m(wt.$$.fragment),ns=i(),Gn=a("p"),Gn.innerHTML=aa,os=i(),Jn=a("p"),Jn.innerHTML=ra,fo=i(),m(Mt.$$.fragment),co=i(),Bn=a("p"),this.h()},l(e){const f=ca("svelte-u9bgzb",document.head);o=r(f,"META",{name:!0,content:!0}),f.forEach(l),$=s(e),p=r(e,"P",{}),T(p).forEach(l),d=s(e),h(v.$$.fragment,e),n=s(e),M=r(e,"P",{"data-svelte-h":!0}),c(M)!=="svelte-eejdx6"&&(M.textContent=j),te=s(e),Le=r(e,"P",{"data-svelte-h":!0}),c(Le)!=="svelte-1d3b6kb"&&(Le.innerHTML=is),En=s(e),h(pe.$$.fragment,e),zn=s(e),Fe=r(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-2xd39c"&&(Fe.textContent=ss),Yn=s(e),Se=r(e,"TABLE",{"data-svelte-h":!0}),c(Se)!=="svelte-16ga3pv"&&(Se.innerHTML=as),Qn=s(e),h(Ne.$$.fragment,e),qn=s(e),x=r(e,"DIV",{class:!0});var w=T(x);h(Ve.$$.fragment,w),vo=s(w),Zt=r(w,"P",{"data-svelte-h":!0}),c(Zt)!=="svelte-1neg3rw"&&(Zt.textContent=rs),xo=s(w),Gt=r(w,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-1kbb8l4"&&(Gt.innerHTML=ls),$o=s(w),Jt=r(w,"UL",{"data-svelte-h":!0}),c(Jt)!=="svelte-2a5chx"&&(Jt.innerHTML=ds),wo=s(w),It=r(w,"P",{"data-svelte-h":!0}),c(It)!=="svelte-wz8va1"&&(It.textContent=ps),Mo=s(w),Ht=r(w,"UL",{"data-svelte-h":!0}),c(Ht)!=="svelte-1ilr6sx"&&(Ht.innerHTML=fs),To=s(w),fe=r(w,"DIV",{class:!0});var Tt=T(fe);h(Be.$$.fragment,Tt),ko=s(Tt),Wt=r(Tt,"P",{"data-svelte-h":!0}),c(Wt)!=="svelte-1eed40t"&&(Wt.textContent=cs),Tt.forEach(l),Co=s(w),Lt=r(w,"DIV",{class:!0});var Xn=T(Lt);h(Xe.$$.fragment,Xn),Xn.forEach(l),Uo=s(w),H=r(w,"DIV",{class:!0});var L=T(H);h(Re.$$.fragment,L),Po=s(L),Ft=r(L,"P",{"data-svelte-h":!0}),c(Ft)!=="svelte-1vbhnip"&&(Ft.innerHTML=us),Do=s(L),h(ce.$$.fragment,L),jo=s(L),St=r(L,"P",{"data-svelte-h":!0}),c(St)!=="svelte-5ul9n2"&&(St.innerHTML=ms),Zo=s(L),Nt=r(L,"UL",{"data-svelte-h":!0}),c(Nt)!=="svelte-1icy6l9"&&(Nt.innerHTML=hs),L.forEach(l),Go=s(w),F=r(w,"DIV",{class:!0});var A=T(F);h(Ee.$$.fragment,A),Jo=s(A),Vt=r(A,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-had4mb"&&(Vt.innerHTML=gs),Io=s(A),Bt=r(A,"P",{"data-svelte-h":!0}),c(Bt)!=="svelte-19k67ce"&&(Bt.innerHTML=bs),Ho=s(A),h(ue.$$.fragment,A),A.forEach(l),Wo=s(w),me=r(w,"DIV",{class:!0});var kt=T(me);h(ze.$$.fragment,kt),Lo=s(kt),Xt=r(kt,"P",{"data-svelte-h":!0}),c(Xt)!=="svelte-1lh0nh5"&&(Xt.innerHTML=_s),kt.forEach(l),Fo=s(w),he=r(w,"DIV",{class:!0});var Ct=T(he);h(Ye.$$.fragment,Ct),So=s(Ct),Rt=r(Ct,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-1vfte1e"&&(Rt.innerHTML=ys),Ct.forEach(l),No=s(w),ne=r(w,"DIV",{class:!0});var ae=T(ne);h(Qe.$$.fragment,ae),Vo=s(ae),Et=r(ae,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-1mfctah"&&(Et.textContent=vs),Bo=s(ae),h(ge.$$.fragment,ae),ae.forEach(l),Xo=s(w),S=r(w,"DIV",{class:!0});var O=T(S);h(qe.$$.fragment,O),Ro=s(O),zt=r(O,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-10jaql7"&&(zt.textContent=xs),Eo=s(O),h(be.$$.fragment,O),zo=s(O),h(_e.$$.fragment,O),O.forEach(l),Yo=s(w),ye=r(w,"DIV",{class:!0});var Ut=T(ye);h(Ae.$$.fragment,Ut),Qo=s(Ut),Yt=r(Ut,"P",{"data-svelte-h":!0}),c(Yt)!=="svelte-9hgqai"&&(Yt.innerHTML=$s),Ut.forEach(l),qo=s(w),ve=r(w,"DIV",{class:!0});var Pt=T(ve);h(Oe.$$.fragment,Pt),Ao=s(Pt),Qt=r(Pt,"P",{"data-svelte-h":!0}),c(Qt)!=="svelte-1bs0ixe"&&(Qt.innerHTML=ws),Pt.forEach(l),Oo=s(w),N=r(w,"DIV",{class:!0});var K=T(N);h(Ke.$$.fragment,K),Ko=s(K),qt=r(K,"P",{"data-svelte-h":!0}),c(qt)!=="svelte-e03q3e"&&(qt.innerHTML=Ms),ei=s(K),h(xe.$$.fragment,K),ti=s(K),h($e.$$.fragment,K),K.forEach(l),ni=s(w),oe=r(w,"DIV",{class:!0});var re=T(oe);h(et.$$.fragment,re),oi=s(re),At=r(re,"P",{"data-svelte-h":!0}),c(At)!=="svelte-1jx3icn"&&(At.textContent=Ts),ii=s(re),h(we.$$.fragment,re),re.forEach(l),si=s(w),Z=r(w,"DIV",{class:!0});var I=T(Z);h(tt.$$.fragment,I),ai=s(I),Ot=r(I,"P",{"data-svelte-h":!0}),c(Ot)!=="svelte-ccbjek"&&(Ot.textContent=ks),ri=s(I),Kt=r(I,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-1p5vgmd"&&(Kt.innerHTML=Cs),li=s(I),h(Me.$$.fragment,I),di=s(I),h(Te.$$.fragment,I),pi=s(I),h(ke.$$.fragment,I),I.forEach(l),fi=s(w),V=r(w,"DIV",{class:!0});var ee=T(V);h(nt.$$.fragment,ee),ci=s(ee),en=r(ee,"P",{"data-svelte-h":!0}),c(en)!=="svelte-z79kjq"&&(en.textContent=Us),ui=s(ee),tn=r(ee,"UL",{"data-svelte-h":!0}),c(tn)!=="svelte-1ju7puc"&&(tn.innerHTML=Ps),mi=s(ee),nn=r(ee,"P",{"data-svelte-h":!0}),c(nn)!=="svelte-1pqppti"&&(nn.innerHTML=Ds),ee.forEach(l),hi=s(w),Ce=r(w,"DIV",{class:!0});var Dt=T(Ce);h(ot.$$.fragment,Dt),gi=s(Dt),on=r(Dt,"P",{"data-svelte-h":!0}),c(on)!=="svelte-1gut907"&&(on.textContent=js),Dt.forEach(l),bi=s(w),Ue=r(w,"DIV",{class:!0});var mo=T(Ue);h(it.$$.fragment,mo),_i=s(mo),sn=r(mo,"P",{"data-svelte-h":!0}),c(sn)!=="svelte-8kophh"&&(sn.innerHTML=Zs),mo.forEach(l),yi=s(w),Pe=r(w,"DIV",{class:!0});var ho=T(Pe);h(st.$$.fragment,ho),vi=s(ho),an=r(ho,"P",{"data-svelte-h":!0}),c(an)!=="svelte-6tjysh"&&(an.textContent=Gs),ho.forEach(l),xi=s(w),De=r(w,"DIV",{class:!0});var go=T(De);h(at.$$.fragment,go),$i=s(go),rn=r(go,"P",{"data-svelte-h":!0}),c(rn)!=="svelte-1jcmq84"&&(rn.innerHTML=Js),go.forEach(l),w.forEach(l),An=s(e),W=r(e,"DIV",{class:!0});var We=T(W);h(rt.$$.fragment,We),wi=s(We),ln=r(We,"P",{"data-svelte-h":!0}),c(ln)!=="svelte-192jnkh"&&(ln.innerHTML=Is),Mi=s(We),dn=r(We,"P",{"data-svelte-h":!0}),c(dn)!=="svelte-xjijlp"&&(dn.textContent=Hs),Ti=s(We),pn=r(We,"P",{"data-svelte-h":!0}),c(pn)!=="svelte-hy0nzs"&&(pn.innerHTML=Ws),We.forEach(l),On=s(e),se=r(e,"DIV",{class:!0});var bo=T(se);h(lt.$$.fragment,bo),ki=s(bo),fn=r(bo,"P",{"data-svelte-h":!0}),c(fn)!=="svelte-psupw6"&&(fn.textContent=Ls),bo.forEach(l),Kn=s(e),h(dt.$$.fragment,e),eo=s(e),P=r(e,"DIV",{class:!0});var D=T(P);h(pt.$$.fragment,D),Ci=s(D),cn=r(D,"P",{"data-svelte-h":!0}),c(cn)!=="svelte-1o1wti6"&&(cn.textContent=Fs),Ui=s(D),un=r(D,"P",{"data-svelte-h":!0}),c(un)!=="svelte-1h33ucg"&&(un.innerHTML=Ss),Pi=s(D),mn=r(D,"UL",{"data-svelte-h":!0}),c(mn)!=="svelte-1kk3msp"&&(mn.innerHTML=Ns),Di=s(D),hn=r(D,"P",{"data-svelte-h":!0}),c(hn)!=="svelte-wz8va1"&&(hn.textContent=Vs),ji=s(D),gn=r(D,"UL",{"data-svelte-h":!0}),c(gn)!=="svelte-56flce"&&(gn.innerHTML=Bs),Zi=s(D),G=r(D,"DIV",{class:!0});var B=T(G);h(ft.$$.fragment,B),Gi=s(B),bn=r(B,"P",{"data-svelte-h":!0}),c(bn)!=="svelte-7z61o"&&(bn.textContent=Xs),Ji=s(B),_n=r(B,"P",{"data-svelte-h":!0}),c(_n)!=="svelte-wyh2cr"&&(_n.textContent=Rs),Ii=s(B),h(je.$$.fragment,B),Hi=s(B),h(Ze.$$.fragment,B),Wi=s(B),h(Ge.$$.fragment,B),B.forEach(l),Li=s(D),Je=r(D,"DIV",{class:!0});var _o=T(Je);h(ct.$$.fragment,_o),Fi=s(_o),yn=r(_o,"P",{"data-svelte-h":!0}),c(yn)!=="svelte-1gut907"&&(yn.textContent=Es),_o.forEach(l),Si=s(D),Ie=r(D,"DIV",{class:!0});var yo=T(Ie);h(ut.$$.fragment,yo),Ni=s(yo),vn=r(yo,"P",{"data-svelte-h":!0}),c(vn)!=="svelte-spoull"&&(vn.innerHTML=zs),yo.forEach(l),D.forEach(l),to=s(e),h(mt.$$.fragment,e),no=s(e),X=r(e,"DIV",{class:!0});var In=T(X);h(ht.$$.fragment,In),Vi=s(In),xn=r(In,"P",{"data-svelte-h":!0}),c(xn)!=="svelte-7y8zei"&&(xn.textContent=Ys),Bi=s(In),ie=r(In,"DIV",{class:!0});var Hn=T(ie);h(gt.$$.fragment,Hn),Xi=s(Hn),$n=r(Hn,"P",{"data-svelte-h":!0}),c($n)!=="svelte-5nfhmh"&&($n.textContent=Qs),Ri=s(Hn),h(He.$$.fragment,Hn),Hn.forEach(l),In.forEach(l),oo=s(e),h(bt.$$.fragment,e),io=s(e),R=r(e,"DIV",{class:!0});var Wn=T(R);h(_t.$$.fragment,Wn),Ei=s(Wn),wn=r(Wn,"P",{"data-svelte-h":!0}),c(wn)!=="svelte-2ua579"&&(wn.textContent=qs),zi=s(Wn),Mn=r(Wn,"P",{"data-svelte-h":!0}),c(Mn)!=="svelte-qrped9"&&(Mn.innerHTML=As),Wn.forEach(l),so=s(e),E=r(e,"DIV",{class:!0});var Ln=T(E);h(yt.$$.fragment,Ln),Yi=s(Ln),Tn=r(Ln,"P",{"data-svelte-h":!0}),c(Tn)!=="svelte-1lxhnsk"&&(Tn.innerHTML=Os),Qi=s(Ln),kn=r(Ln,"P",{"data-svelte-h":!0}),c(kn)!=="svelte-twxvjk"&&(kn.innerHTML=Ks),Ln.forEach(l),ao=s(e),z=r(e,"DIV",{class:!0});var Fn=T(z);h(vt.$$.fragment,Fn),qi=s(Fn),Cn=r(Fn,"P",{"data-svelte-h":!0}),c(Cn)!=="svelte-1pnjwf0"&&(Cn.innerHTML=ea),Ai=s(Fn),Un=r(Fn,"P",{"data-svelte-h":!0}),c(Un)!=="svelte-twxvjk"&&(Un.innerHTML=ta),Fn.forEach(l),ro=s(e),Y=r(e,"DIV",{class:!0});var Sn=T(Y);h(xt.$$.fragment,Sn),Oi=s(Sn),Pn=r(Sn,"P",{"data-svelte-h":!0}),c(Pn)!=="svelte-wsvz4z"&&(Pn.innerHTML=na),Ki=s(Sn),Dn=r(Sn,"P",{"data-svelte-h":!0}),c(Dn)!=="svelte-twxvjk"&&(Dn.innerHTML=oa),Sn.forEach(l),lo=s(e),Q=r(e,"DIV",{class:!0});var Nn=T(Q);h($t.$$.fragment,Nn),es=s(Nn),jn=r(Nn,"P",{"data-svelte-h":!0}),c(jn)!=="svelte-1pf8icy"&&(jn.innerHTML=ia),ts=s(Nn),Zn=r(Nn,"P",{"data-svelte-h":!0}),c(Zn)!=="svelte-1kg1eq5"&&(Zn.textContent=sa),Nn.forEach(l),po=s(e),q=r(e,"DIV",{class:!0});var Vn=T(q);h(wt.$$.fragment,Vn),ns=s(Vn),Gn=r(Vn,"P",{"data-svelte-h":!0}),c(Gn)!=="svelte-461fyb"&&(Gn.innerHTML=aa),os=s(Vn),Jn=r(Vn,"P",{"data-svelte-h":!0}),c(Jn)!=="svelte-twxvjk"&&(Jn.innerHTML=ra),Vn.forEach(l),fo=s(e),h(Mt.$$.fragment,e),co=s(e),Bn=r(e,"P",{}),T(Bn).forEach(l),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",ja),k(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),k(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,f){t(document.head,o),u(e,$,f),u(e,p,f),u(e,d,f),g(v,e,f),u(e,n,f),u(e,M,f),u(e,te,f),u(e,Le,f),u(e,En,f),g(pe,e,f),u(e,zn,f),u(e,Fe,f),u(e,Yn,f),u(e,Se,f),u(e,Qn,f),g(Ne,e,f),u(e,qn,f),u(e,x,f),g(Ve,x,null),t(x,vo),t(x,Zt),t(x,xo),t(x,Gt),t(x,$o),t(x,Jt),t(x,wo),t(x,It),t(x,Mo),t(x,Ht),t(x,To),t(x,fe),g(Be,fe,null),t(fe,ko),t(fe,Wt),t(x,Co),t(x,Lt),g(Xe,Lt,null),t(x,Uo),t(x,H),g(Re,H,null),t(H,Po),t(H,Ft),t(H,Do),g(ce,H,null),t(H,jo),t(H,St),t(H,Zo),t(H,Nt),t(x,Go),t(x,F),g(Ee,F,null),t(F,Jo),t(F,Vt),t(F,Io),t(F,Bt),t(F,Ho),g(ue,F,null),t(x,Wo),t(x,me),g(ze,me,null),t(me,Lo),t(me,Xt),t(x,Fo),t(x,he),g(Ye,he,null),t(he,So),t(he,Rt),t(x,No),t(x,ne),g(Qe,ne,null),t(ne,Vo),t(ne,Et),t(ne,Bo),g(ge,ne,null),t(x,Xo),t(x,S),g(qe,S,null),t(S,Ro),t(S,zt),t(S,Eo),g(be,S,null),t(S,zo),g(_e,S,null),t(x,Yo),t(x,ye),g(Ae,ye,null),t(ye,Qo),t(ye,Yt),t(x,qo),t(x,ve),g(Oe,ve,null),t(ve,Ao),t(ve,Qt),t(x,Oo),t(x,N),g(Ke,N,null),t(N,Ko),t(N,qt),t(N,ei),g(xe,N,null),t(N,ti),g($e,N,null),t(x,ni),t(x,oe),g(et,oe,null),t(oe,oi),t(oe,At),t(oe,ii),g(we,oe,null),t(x,si),t(x,Z),g(tt,Z,null),t(Z,ai),t(Z,Ot),t(Z,ri),t(Z,Kt),t(Z,li),g(Me,Z,null),t(Z,di),g(Te,Z,null),t(Z,pi),g(ke,Z,null),t(x,fi),t(x,V),g(nt,V,null),t(V,ci),t(V,en),t(V,ui),t(V,tn),t(V,mi),t(V,nn),t(x,hi),t(x,Ce),g(ot,Ce,null),t(Ce,gi),t(Ce,on),t(x,bi),t(x,Ue),g(it,Ue,null),t(Ue,_i),t(Ue,sn),t(x,yi),t(x,Pe),g(st,Pe,null),t(Pe,vi),t(Pe,an),t(x,xi),t(x,De),g(at,De,null),t(De,$i),t(De,rn),u(e,An,f),u(e,W,f),g(rt,W,null),t(W,wi),t(W,ln),t(W,Mi),t(W,dn),t(W,Ti),t(W,pn),u(e,On,f),u(e,se,f),g(lt,se,null),t(se,ki),t(se,fn),u(e,Kn,f),g(dt,e,f),u(e,eo,f),u(e,P,f),g(pt,P,null),t(P,Ci),t(P,cn),t(P,Ui),t(P,un),t(P,Pi),t(P,mn),t(P,Di),t(P,hn),t(P,ji),t(P,gn),t(P,Zi),t(P,G),g(ft,G,null),t(G,Gi),t(G,bn),t(G,Ji),t(G,_n),t(G,Ii),g(je,G,null),t(G,Hi),g(Ze,G,null),t(G,Wi),g(Ge,G,null),t(P,Li),t(P,Je),g(ct,Je,null),t(Je,Fi),t(Je,yn),t(P,Si),t(P,Ie),g(ut,Ie,null),t(Ie,Ni),t(Ie,vn),u(e,to,f),g(mt,e,f),u(e,no,f),u(e,X,f),g(ht,X,null),t(X,Vi),t(X,xn),t(X,Bi),t(X,ie),g(gt,ie,null),t(ie,Xi),t(ie,$n),t(ie,Ri),g(He,ie,null),u(e,oo,f),g(bt,e,f),u(e,io,f),u(e,R,f),g(_t,R,null),t(R,Ei),t(R,wn),t(R,zi),t(R,Mn),u(e,so,f),u(e,E,f),g(yt,E,null),t(E,Yi),t(E,Tn),t(E,Qi),t(E,kn),u(e,ao,f),u(e,z,f),g(vt,z,null),t(z,qi),t(z,Cn),t(z,Ai),t(z,Un),u(e,ro,f),u(e,Y,f),g(xt,Y,null),t(Y,Oi),t(Y,Pn),t(Y,Ki),t(Y,Dn),u(e,lo,f),u(e,Q,f),g($t,Q,null),t(Q,es),t(Q,jn),t(Q,ts),t(Q,Zn),u(e,po,f),u(e,q,f),g(wt,q,null),t(q,ns),t(q,Gn),t(q,os),t(q,Jn),u(e,fo,f),g(Mt,e,f),u(e,co,f),u(e,Bn,f),uo=!0},p(e,[f]){const w={};f&2&&(w.$$scope={dirty:f,ctx:e}),pe.$set(w);const Tt={};f&2&&(Tt.$$scope={dirty:f,ctx:e}),ce.$set(Tt);const Xn={};f&2&&(Xn.$$scope={dirty:f,ctx:e}),ue.$set(Xn);const L={};f&2&&(L.$$scope={dirty:f,ctx:e}),ge.$set(L);const A={};f&2&&(A.$$scope={dirty:f,ctx:e}),be.$set(A);const kt={};f&2&&(kt.$$scope={dirty:f,ctx:e}),_e.$set(kt);const Ct={};f&2&&(Ct.$$scope={dirty:f,ctx:e}),xe.$set(Ct);const ae={};f&2&&(ae.$$scope={dirty:f,ctx:e}),$e.$set(ae);const O={};f&2&&(O.$$scope={dirty:f,ctx:e}),we.$set(O);const Ut={};f&2&&(Ut.$$scope={dirty:f,ctx:e}),Me.$set(Ut);const Pt={};f&2&&(Pt.$$scope={dirty:f,ctx:e}),Te.$set(Pt);const K={};f&2&&(K.$$scope={dirty:f,ctx:e}),ke.$set(K);const re={};f&2&&(re.$$scope={dirty:f,ctx:e}),je.$set(re);const I={};f&2&&(I.$$scope={dirty:f,ctx:e}),Ze.$set(I);const ee={};f&2&&(ee.$$scope={dirty:f,ctx:e}),Ge.$set(ee);const Dt={};f&2&&(Dt.$$scope={dirty:f,ctx:e}),He.$set(Dt)},i(e){uo||(b(v.$$.fragment,e),b(pe.$$.fragment,e),b(Ne.$$.fragment,e),b(Ve.$$.fragment,e),b(Be.$$.fragment,e),b(Xe.$$.fragment,e),b(Re.$$.fragment,e),b(ce.$$.fragment,e),b(Ee.$$.fragment,e),b(ue.$$.fragment,e),b(ze.$$.fragment,e),b(Ye.$$.fragment,e),b(Qe.$$.fragment,e),b(ge.$$.fragment,e),b(qe.$$.fragment,e),b(be.$$.fragment,e),b(_e.$$.fragment,e),b(Ae.$$.fragment,e),b(Oe.$$.fragment,e),b(Ke.$$.fragment,e),b(xe.$$.fragment,e),b($e.$$.fragment,e),b(et.$$.fragment,e),b(we.$$.fragment,e),b(tt.$$.fragment,e),b(Me.$$.fragment,e),b(Te.$$.fragment,e),b(ke.$$.fragment,e),b(nt.$$.fragment,e),b(ot.$$.fragment,e),b(it.$$.fragment,e),b(st.$$.fragment,e),b(at.$$.fragment,e),b(rt.$$.fragment,e),b(lt.$$.fragment,e),b(dt.$$.fragment,e),b(pt.$$.fragment,e),b(ft.$$.fragment,e),b(je.$$.fragment,e),b(Ze.$$.fragment,e),b(Ge.$$.fragment,e),b(ct.$$.fragment,e),b(ut.$$.fragment,e),b(mt.$$.fragment,e),b(ht.$$.fragment,e),b(gt.$$.fragment,e),b(He.$$.fragment,e),b(bt.$$.fragment,e),b(_t.$$.fragment,e),b(yt.$$.fragment,e),b(vt.$$.fragment,e),b(xt.$$.fragment,e),b($t.$$.fragment,e),b(wt.$$.fragment,e),b(Mt.$$.fragment,e),uo=!0)},o(e){_(v.$$.fragment,e),_(pe.$$.fragment,e),_(Ne.$$.fragment,e),_(Ve.$$.fragment,e),_(Be.$$.fragment,e),_(Xe.$$.fragment,e),_(Re.$$.fragment,e),_(ce.$$.fragment,e),_(Ee.$$.fragment,e),_(ue.$$.fragment,e),_(ze.$$.fragment,e),_(Ye.$$.fragment,e),_(Qe.$$.fragment,e),_(ge.$$.fragment,e),_(qe.$$.fragment,e),_(be.$$.fragment,e),_(_e.$$.fragment,e),_(Ae.$$.fragment,e),_(Oe.$$.fragment,e),_(Ke.$$.fragment,e),_(xe.$$.fragment,e),_($e.$$.fragment,e),_(et.$$.fragment,e),_(we.$$.fragment,e),_(tt.$$.fragment,e),_(Me.$$.fragment,e),_(Te.$$.fragment,e),_(ke.$$.fragment,e),_(nt.$$.fragment,e),_(ot.$$.fragment,e),_(it.$$.fragment,e),_(st.$$.fragment,e),_(at.$$.fragment,e),_(rt.$$.fragment,e),_(lt.$$.fragment,e),_(dt.$$.fragment,e),_(pt.$$.fragment,e),_(ft.$$.fragment,e),_(je.$$.fragment,e),_(Ze.$$.fragment,e),_(Ge.$$.fragment,e),_(ct.$$.fragment,e),_(ut.$$.fragment,e),_(mt.$$.fragment,e),_(ht.$$.fragment,e),_(gt.$$.fragment,e),_(He.$$.fragment,e),_(bt.$$.fragment,e),_(_t.$$.fragment,e),_(yt.$$.fragment,e),_(vt.$$.fragment,e),_(xt.$$.fragment,e),_($t.$$.fragment,e),_(wt.$$.fragment,e),_(Mt.$$.fragment,e),uo=!1},d(e){e&&(l($),l(p),l(d),l(n),l(M),l(te),l(Le),l(En),l(zn),l(Fe),l(Yn),l(Se),l(Qn),l(qn),l(x),l(An),l(W),l(On),l(se),l(Kn),l(eo),l(P),l(to),l(no),l(X),l(oo),l(io),l(R),l(so),l(E),l(ao),l(z),l(ro),l(Y),l(lo),l(Q),l(po),l(q),l(fo),l(co),l(Bn)),l(o),y(v,e),y(pe,e),y(Ne,e),y(Ve),y(Be),y(Xe),y(Re),y(ce),y(Ee),y(ue),y(ze),y(Ye),y(Qe),y(ge),y(qe),y(be),y(_e),y(Ae),y(Oe),y(Ke),y(xe),y($e),y(et),y(we),y(tt),y(Me),y(Te),y(ke),y(nt),y(ot),y(it),y(st),y(at),y(rt),y(lt),y(dt,e),y(pt),y(ft),y(je),y(Ze),y(Ge),y(ct),y(ut),y(mt,e),y(ht),y(gt),y(He),y(bt,e),y(_t),y(yt),y(vt),y(xt),y($t),y(wt),y(Mt,e)}}}const ja='{"title":"Pipelines","local":"pipelines","sections":[{"title":"DiffusionPipeline","local":"diffusers.DiffusionPipeline","sections":[],"depth":2},{"title":"FlaxDiffusionPipeline","local":"diffusers.FlaxDiffusionPipeline","sections":[],"depth":2},{"title":"PushToHubMixin","local":"diffusers.utils.PushToHubMixin","sections":[],"depth":2},{"title":"Callbacks","local":"diffusers.callbacks.PipelineCallback","sections":[],"depth":2}],"depth":1}';function Za(C){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Sa extends pa{constructor(o){super(),fa(this,o,Za,Da,la,{})}}export{Sa as component};
