import{s as Ht,n as zt,o as Ft}from"../chunks/scheduler.d586627e.js";import{S as Pt,i as Lt,g as o,s,u as d,A as Kt,h as r,f as t,c as n,j as p,v as h,y as m,k as i,o as c,a as l,w as M,d as u,t as w,x as y}from"../chunks/index.b757c891.js";import{I as se}from"../chunks/IconCopyLink.c074b82b.js";import{C as Z}from"../chunks/CodeBlock.36019a2e.js";function qt(dt){let f,be,Me,Ue,v,C,ue,W,rt,ne,ht="Treinamento distribuído com o 🤗 Accelerate",ge,G,Mt=`O paralelismo surgiu como uma estratégia para treinar modelos grandes em hardware limitado e aumentar a velocidade
de treinamento em várias órdens de magnitude. Na Hugging Face criamos a biblioteca <a href="https://huggingface.co/docs/accelerate" rel="nofollow">🤗 Accelerate</a>
para ajudar os usuários a treinar modelos 🤗 Transformers com qualquer configuração distribuída, seja em uma máquina
com múltiplos GPUs ou em múltiplos GPUs distribuidos entre muitas máquinas. Neste tutorial, você irá aprender como
personalizar seu laço de treinamento de PyTorch para poder treinar em ambientes distribuídos.`,Ce,J,$,we,X,st,ie,ut="Configuração",$e,x,wt="De início, instale o 🤗 Accelerate:",Ie,Y,Ae,N,yt=`Logo, devemos importar e criar um objeto <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator" rel="nofollow"><code>Accelerator</code></a>.
O <code>Accelerator</code> detectará automáticamente a configuração distribuída disponível e inicializará todos os
componentes necessários para o treinamento. Não há necessidade portanto de especificar o dispositivo onde deve colocar seu modelo.`,Be,E,ke,j,I,ye,S,nt,ce,ft="Preparando a aceleração",_e,V,vt=`Passe todos os objetos relevantes ao treinamento para o método <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.prepare" rel="nofollow"><code>prepare</code></a>.
Isto inclui os DataLoaders de treino e evaluação, um modelo e um otimizador:`,Ze,R,We,T,A,fe,Q,it,pe,Jt="Backward",Ge,H,jt='Por último, substitua o <code>loss.backward()</code> padrão em seu laço de treinamento com o método <a href="https://huggingface.co/docs/accelerate/package_reference/accelerator#accelerate.Accelerator.backward" rel="nofollow"><code>backward</code></a> do 🤗 Accelerate:',Xe,z,xe,F,Tt=`Como se poder ver no seguinte código, só precisará adicionar quatro linhas de código ao seu laço de treinamento
para habilitar o treinamento distribuído!`,Ye,P,Ne,b,B,ve,L,ct,me,bt="Treinamento",Ee,K,Ut="Quando tiver adicionado as linhas de código relevantes, inicie o treinamento por um script ou notebook como o Colab.",Se,U,k,Je,q,pt,de,gt="Treinamento em um Script",Ve,D,Ct="Se estiver rodando seu treinamento em um Script, execute o seguinte comando para criar e guardar um arquivo de configuração:",Re,O,Qe,ee,$t="Comece o treinamento com:",He,te,ze,g,_,je,ae,mt,he,It="Treinamento em um Notebook",Fe,le,At=`O 🤗 Accelerate pode rodar em um notebook, por exemplo, se estiver planejando usar as TPUs do Google Colab.
Encapsule o código responsável pelo treinamento de uma função e passe-o ao <code>notebook_launcher</code>:`,Pe,oe,Le,re,Bt='Para obter mais informações sobre o 🤗 Accelerate e suas numerosas funções, consulte a <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">documentación</a>.',Ke,Te,qe;return W=new se({}),X=new se({}),Y=new Z({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate"}}),E=new Z({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()`}}),S=new se({}),R=new Z({props:{code:"dHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(
<span class="hljs-meta">... </span>    train_dataloader, eval_dataloader, model, optimizer
<span class="hljs-meta">... </span>)`}}),Q=new se({}),z=new Z({props:{code:"Zm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        accelerator.backward(loss)

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`}}),P=new Z({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`}}),L=new se({}),q=new se({}),O=new Z({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config"}}),te=new Z({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:"accelerate launch train.py"}}),ae=new se({}),oe=new Z({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_launcher(training_function)`}}),{c(){f=o("meta"),be=s(),Me=o("p"),Ue=s(),v=o("h1"),C=o("a"),ue=o("span"),d(W.$$.fragment),rt=s(),ne=o("span"),ne.textContent=ht,ge=s(),G=o("p"),G.innerHTML=Mt,Ce=s(),J=o("h2"),$=o("a"),we=o("span"),d(X.$$.fragment),st=s(),ie=o("span"),ie.textContent=ut,$e=s(),x=o("p"),x.textContent=wt,Ie=s(),d(Y.$$.fragment),Ae=s(),N=o("p"),N.innerHTML=yt,Be=s(),d(E.$$.fragment),ke=s(),j=o("h2"),I=o("a"),ye=o("span"),d(S.$$.fragment),nt=s(),ce=o("span"),ce.textContent=ft,_e=s(),V=o("p"),V.innerHTML=vt,Ze=s(),d(R.$$.fragment),We=s(),T=o("h2"),A=o("a"),fe=o("span"),d(Q.$$.fragment),it=s(),pe=o("span"),pe.textContent=Jt,Ge=s(),H=o("p"),H.innerHTML=jt,Xe=s(),d(z.$$.fragment),xe=s(),F=o("p"),F.textContent=Tt,Ye=s(),d(P.$$.fragment),Ne=s(),b=o("h2"),B=o("a"),ve=o("span"),d(L.$$.fragment),ct=s(),me=o("span"),me.textContent=bt,Ee=s(),K=o("p"),K.textContent=Ut,Se=s(),U=o("h3"),k=o("a"),Je=o("span"),d(q.$$.fragment),pt=s(),de=o("span"),de.textContent=gt,Ve=s(),D=o("p"),D.textContent=Ct,Re=s(),d(O.$$.fragment),Qe=s(),ee=o("p"),ee.textContent=$t,He=s(),d(te.$$.fragment),ze=s(),g=o("h3"),_=o("a"),je=o("span"),d(ae.$$.fragment),mt=s(),he=o("span"),he.textContent=It,Fe=s(),le=o("p"),le.innerHTML=At,Pe=s(),d(oe.$$.fragment),Le=s(),re=o("p"),re.innerHTML=Bt,Ke=s(),Te=o("p"),this.h()},l(e){const a=Kt("svelte-1phssyn",document.head);f=r(a,"META",{name:!0,content:!0}),a.forEach(t),be=n(e),Me=r(e,"P",{}),p(Me).forEach(t),Ue=n(e),v=r(e,"H1",{class:!0});var De=p(v);C=r(De,"A",{id:!0,class:!0,href:!0});var kt=p(C);ue=r(kt,"SPAN",{});var _t=p(ue);h(W.$$.fragment,_t),_t.forEach(t),kt.forEach(t),rt=n(De),ne=r(De,"SPAN",{"data-svelte-h":!0}),m(ne)!=="svelte-zzyz8v"&&(ne.textContent=ht),De.forEach(t),ge=n(e),G=r(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1wiu3fb"&&(G.innerHTML=Mt),Ce=n(e),J=r(e,"H2",{class:!0});var Oe=p(J);$=r(Oe,"A",{id:!0,class:!0,href:!0});var Zt=p($);we=r(Zt,"SPAN",{});var Wt=p(we);h(X.$$.fragment,Wt),Wt.forEach(t),Zt.forEach(t),st=n(Oe),ie=r(Oe,"SPAN",{"data-svelte-h":!0}),m(ie)!=="svelte-bv5dcg"&&(ie.textContent=ut),Oe.forEach(t),$e=n(e),x=r(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-t6m1zf"&&(x.textContent=wt),Ie=n(e),h(Y.$$.fragment,e),Ae=n(e),N=r(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-1rphp5p"&&(N.innerHTML=yt),Be=n(e),h(E.$$.fragment,e),ke=n(e),j=r(e,"H2",{class:!0});var et=p(j);I=r(et,"A",{id:!0,class:!0,href:!0});var Gt=p(I);ye=r(Gt,"SPAN",{});var Xt=p(ye);h(S.$$.fragment,Xt),Xt.forEach(t),Gt.forEach(t),nt=n(et),ce=r(et,"SPAN",{"data-svelte-h":!0}),m(ce)!=="svelte-1wjvves"&&(ce.textContent=ft),et.forEach(t),_e=n(e),V=r(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-iagz26"&&(V.innerHTML=vt),Ze=n(e),h(R.$$.fragment,e),We=n(e),T=r(e,"H2",{class:!0});var tt=p(T);A=r(tt,"A",{id:!0,class:!0,href:!0});var xt=p(A);fe=r(xt,"SPAN",{});var Yt=p(fe);h(Q.$$.fragment,Yt),Yt.forEach(t),xt.forEach(t),it=n(tt),pe=r(tt,"SPAN",{"data-svelte-h":!0}),m(pe)!=="svelte-1hbv3ea"&&(pe.textContent=Jt),tt.forEach(t),Ge=n(e),H=r(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-1a4hz8x"&&(H.innerHTML=jt),Xe=n(e),h(z.$$.fragment,e),xe=n(e),F=r(e,"P",{"data-svelte-h":!0}),m(F)!=="svelte-1eeg6uf"&&(F.textContent=Tt),Ye=n(e),h(P.$$.fragment,e),Ne=n(e),b=r(e,"H2",{class:!0});var at=p(b);B=r(at,"A",{id:!0,class:!0,href:!0});var Nt=p(B);ve=r(Nt,"SPAN",{});var Et=p(ve);h(L.$$.fragment,Et),Et.forEach(t),Nt.forEach(t),ct=n(at),me=r(at,"SPAN",{"data-svelte-h":!0}),m(me)!=="svelte-1rp0x95"&&(me.textContent=bt),at.forEach(t),Ee=n(e),K=r(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1ugx3dc"&&(K.textContent=Ut),Se=n(e),U=r(e,"H3",{class:!0});var lt=p(U);k=r(lt,"A",{id:!0,class:!0,href:!0});var St=p(k);Je=r(St,"SPAN",{});var Vt=p(Je);h(q.$$.fragment,Vt),Vt.forEach(t),St.forEach(t),pt=n(lt),de=r(lt,"SPAN",{"data-svelte-h":!0}),m(de)!=="svelte-w7f3t6"&&(de.textContent=gt),lt.forEach(t),Ve=n(e),D=r(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-o59jjd"&&(D.textContent=Ct),Re=n(e),h(O.$$.fragment,e),Qe=n(e),ee=r(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-257ccc"&&(ee.textContent=$t),He=n(e),h(te.$$.fragment,e),ze=n(e),g=r(e,"H3",{class:!0});var ot=p(g);_=r(ot,"A",{id:!0,class:!0,href:!0});var Rt=p(_);je=r(Rt,"SPAN",{});var Qt=p(je);h(ae.$$.fragment,Qt),Qt.forEach(t),Rt.forEach(t),mt=n(ot),he=r(ot,"SPAN",{"data-svelte-h":!0}),m(he)!=="svelte-uc0rz8"&&(he.textContent=It),ot.forEach(t),Fe=n(e),le=r(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-12l65dl"&&(le.innerHTML=At),Pe=n(e),h(oe.$$.fragment,e),Le=n(e),re=r(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-8c3jdl"&&(re.innerHTML=Bt),Ke=n(e),Te=r(e,"P",{}),p(Te).forEach(t),this.h()},h(){i(f,"name","hf:doc:metadata"),i(f,"content",JSON.stringify(Dt)),i(C,"id","treinamento-distribudo-com-o-accelerate"),i(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(C,"href","#treinamento-distribudo-com-o-accelerate"),i(v,"class","relative group"),i($,"id","configurao"),i($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i($,"href","#configurao"),i(J,"class","relative group"),i(I,"id","preparando-a-acelerao"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#preparando-a-acelerao"),i(j,"class","relative group"),i(A,"id","backward"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#backward"),i(T,"class","relative group"),i(B,"id","treinamento"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#treinamento"),i(b,"class","relative group"),i(k,"id","treinamento-em-um-script"),i(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(k,"href","#treinamento-em-um-script"),i(U,"class","relative group"),i(_,"id","treinamento-em-um-notebook"),i(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(_,"href","#treinamento-em-um-notebook"),i(g,"class","relative group")},m(e,a){c(document.head,f),l(e,be,a),l(e,Me,a),l(e,Ue,a),l(e,v,a),c(v,C),c(C,ue),M(W,ue,null),c(v,rt),c(v,ne),l(e,ge,a),l(e,G,a),l(e,Ce,a),l(e,J,a),c(J,$),c($,we),M(X,we,null),c(J,st),c(J,ie),l(e,$e,a),l(e,x,a),l(e,Ie,a),M(Y,e,a),l(e,Ae,a),l(e,N,a),l(e,Be,a),M(E,e,a),l(e,ke,a),l(e,j,a),c(j,I),c(I,ye),M(S,ye,null),c(j,nt),c(j,ce),l(e,_e,a),l(e,V,a),l(e,Ze,a),M(R,e,a),l(e,We,a),l(e,T,a),c(T,A),c(A,fe),M(Q,fe,null),c(T,it),c(T,pe),l(e,Ge,a),l(e,H,a),l(e,Xe,a),M(z,e,a),l(e,xe,a),l(e,F,a),l(e,Ye,a),M(P,e,a),l(e,Ne,a),l(e,b,a),c(b,B),c(B,ve),M(L,ve,null),c(b,ct),c(b,me),l(e,Ee,a),l(e,K,a),l(e,Se,a),l(e,U,a),c(U,k),c(k,Je),M(q,Je,null),c(U,pt),c(U,de),l(e,Ve,a),l(e,D,a),l(e,Re,a),M(O,e,a),l(e,Qe,a),l(e,ee,a),l(e,He,a),M(te,e,a),l(e,ze,a),l(e,g,a),c(g,_),c(_,je),M(ae,je,null),c(g,mt),c(g,he),l(e,Fe,a),l(e,le,a),l(e,Pe,a),M(oe,e,a),l(e,Le,a),l(e,re,a),l(e,Ke,a),l(e,Te,a),qe=!0},p:zt,i(e){qe||(u(W.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(R.$$.fragment,e),u(Q.$$.fragment,e),u(z.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(oe.$$.fragment,e),qe=!0)},o(e){w(W.$$.fragment,e),w(X.$$.fragment,e),w(Y.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(R.$$.fragment,e),w(Q.$$.fragment,e),w(z.$$.fragment,e),w(P.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(O.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(oe.$$.fragment,e),qe=!1},d(e){e&&(t(be),t(Me),t(Ue),t(v),t(ge),t(G),t(Ce),t(J),t($e),t(x),t(Ie),t(Ae),t(N),t(Be),t(ke),t(j),t(_e),t(V),t(Ze),t(We),t(T),t(Ge),t(H),t(Xe),t(xe),t(F),t(Ye),t(Ne),t(b),t(Ee),t(K),t(Se),t(U),t(Ve),t(D),t(Re),t(Qe),t(ee),t(He),t(ze),t(g),t(Fe),t(le),t(Pe),t(Le),t(re),t(Ke),t(Te)),t(f),y(W),y(X),y(Y,e),y(E,e),y(S),y(R,e),y(Q),y(z,e),y(P,e),y(L),y(q),y(O,e),y(te,e),y(ae),y(oe,e)}}}const Dt={local:"treinamento-distribudo-com-o-accelerate",sections:[{local:"configurao",title:"Configuração"},{local:"preparando-a-acelerao",title:"Preparando a aceleração"},{local:"backward",title:"Backward"},{local:"treinamento",sections:[{local:"treinamento-em-um-script",title:"Treinamento em um Script"},{local:"treinamento-em-um-notebook",title:"Treinamento em um Notebook"}],title:"Treinamento"}],title:"Treinamento distribuído com o 🤗 Accelerate"};function Ot(dt){return Ft(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class oa extends Pt{constructor(f){super(),Lt(this,f,Ot,qt,Ht,{})}}export{oa as component};
