import{s as os,n as cs,o as Ms}from"../chunks/scheduler.b108d059.js";import{S as ys,i as hs,g as i,s as n,r as o,A as ms,h as c,f as a,c as t,j as ps,u as M,x as R,k as is,y as Js,a as e,v as y,d as h,t as m,w as J}from"../chunks/index.008de539.js";import{C as K}from"../chunks/CodeBlock.3968c746.js";import{H as $}from"../chunks/Heading.88bfeb84.js";function rs(O){let p,W,G,Y,r,S,U,ss="Official utilities to use the Hugging Face hub API, still very experimental.",N,d,F,w,v,T,E,j,V,u,_,f,ls='For some of the calls, you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',H,g,A,b,q,I,as="When uploading large files, you may want to run the <code>commit</code> calls inside a worker, to offload the sha256 computations.",X,C,es="Remote resources and local files should be passed as <code>URL</code> whenever it’s possible so they can be lazy loaded in chunks to reduce RAM usage. Passing a <code>File</code> inside the browser’s context is fine, because it natively behaves as a <code>Blob</code>.",z,Z,ns="Under the hood, <code>@huggingface/hub</code> uses a lazy blob implementation to load the file.",x,B,L,k,ts="<li><code>hash-wasm</code> : Only used in the browser, when committing files over 10 MB. Browsers do not natively support streaming sha256 computations.</li> <li><code>type-fest</code> : Typings only</li>",D,Q,P;return r=new $({props:{title:"🤗 Hugging Face Hub API",local:"-hugging-face-hub-api",headingTag:"h1"}}),d=new $({props:{title:"Install",local:"install",headingTag:"h2"}}),w=new K({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGaHViJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZodWI=",highlighted:`pnpm add @huggingface/hub

npm add @huggingface/hub

yarn add @huggingface/hub`,wrap:!1}}),T=new $({props:{title:"Deno",local:"deno",headingTag:"h3"}}),j=new K({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIyaHR0cHMlM0ElMkYlMkZlc20uc2glMkYlNDBodWdnaW5nZmFjZSUyRmh1YiUyMiUwQSUyRiUyRiUyMG9yJTIwbnBtJTNBJTBBaW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2UlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZodWIlMjI=",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/hub&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInference</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/hub&quot;</span>`,wrap:!1}}),u=new $({props:{title:"Usage",local:"usage",headingTag:"h2"}}),g=new K({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { createRepo, uploadFiles, deleteFile, deleteRepo, listFiles, whoAmI } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">RepoDesignation</span>, <span class="hljs-title class_">Credentials</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/hub&quot;</span>;

<span class="hljs-keyword">const</span> <span class="hljs-attr">repo</span>: <span class="hljs-title class_">RepoDesignation</span> = { <span class="hljs-attr">type</span>: <span class="hljs-string">&quot;model&quot;</span>, <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;myname/some-model&quot;</span> };
<span class="hljs-keyword">const</span> <span class="hljs-attr">credentials</span>: <span class="hljs-title class_">Credentials</span> = { <span class="hljs-attr">accessToken</span>: <span class="hljs-string">&quot;hf_...&quot;</span> };

<span class="hljs-keyword">const</span> {<span class="hljs-attr">name</span>: username} = <span class="hljs-keyword">await</span> <span class="hljs-title function_">whoAmI</span>({credentials});

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> model <span class="hljs-keyword">of</span> <span class="hljs-title function_">listModels</span>({<span class="hljs-attr">search</span>: {<span class="hljs-attr">owner</span>: username}, credentials})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(<span class="hljs-string">&quot;My model:&quot;</span>, model);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">createRepo</span>({ repo, credentials, <span class="hljs-attr">license</span>: <span class="hljs-string">&quot;mit&quot;</span> });

<span class="hljs-keyword">await</span> <span class="hljs-title function_">uploadFiles</span>({
  repo,
  credentials,
  <span class="hljs-attr">files</span>: [
    <span class="hljs-comment">// path + blob content</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;file.txt&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title class_">Blob</span>([<span class="hljs-string">&quot;Hello World&quot;</span>]),
    },
    <span class="hljs-comment">// Local file URL</span>
    <span class="hljs-title function_">pathToFileURL</span>(<span class="hljs-string">&quot;./pytorch-model.bin&quot;</span>),
    <span class="hljs-comment">// Web URL</span>
    <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/xlm-roberta-base/resolve/main/tokenizer.json&quot;</span>),
    <span class="hljs-comment">// Path + Web URL</span>
    {
      <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>,
      <span class="hljs-attr">content</span>: <span class="hljs-keyword">new</span> <span class="hljs-title function_">URL</span>(<span class="hljs-string">&quot;https://huggingface.co/bert-base-uncased/resolve/main/pytorch_model.bin&quot;</span>)
    }
    <span class="hljs-comment">// Can also work with native File in browsers</span>
  ],
});

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteFile</span>({repo, credentials, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;myfile.bin&quot;</span>});

<span class="hljs-keyword">await</span> (<span class="hljs-keyword">await</span> <span class="hljs-title function_">downloadFile</span>({ repo, <span class="hljs-attr">path</span>: <span class="hljs-string">&quot;README.md&quot;</span> })).<span class="hljs-title function_">text</span>();

<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> fileInfo <span class="hljs-keyword">of</span> <span class="hljs-title function_">listFiles</span>({repo})) {
  <span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(fileInfo);
}

<span class="hljs-keyword">await</span> <span class="hljs-title function_">deleteRepo</span>({ repo, credentials });`,wrap:!1}}),b=new $({props:{title:"Performance considerations",local:"performance-considerations",headingTag:"h2"}}),B=new $({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),{c(){p=i("meta"),W=n(),G=i("p"),Y=n(),o(r.$$.fragment),S=n(),U=i("p"),U.textContent=ss,N=n(),o(d.$$.fragment),F=n(),o(w.$$.fragment),v=n(),o(T.$$.fragment),E=n(),o(j.$$.fragment),V=n(),o(u.$$.fragment),_=n(),f=i("p"),f.innerHTML=ls,H=n(),o(g.$$.fragment),A=n(),o(b.$$.fragment),q=n(),I=i("p"),I.innerHTML=as,X=n(),C=i("p"),C.innerHTML=es,z=n(),Z=i("p"),Z.innerHTML=ns,x=n(),o(B.$$.fragment),L=n(),k=i("ul"),k.innerHTML=ts,D=n(),Q=i("p"),this.h()},l(s){const l=ms("svelte-u9bgzb",document.head);p=c(l,"META",{name:!0,content:!0}),l.forEach(a),W=t(s),G=c(s,"P",{}),ps(G).forEach(a),Y=t(s),M(r.$$.fragment,s),S=t(s),U=c(s,"P",{"data-svelte-h":!0}),R(U)!=="svelte-1rd1r5p"&&(U.textContent=ss),N=t(s),M(d.$$.fragment,s),F=t(s),M(w.$$.fragment,s),v=t(s),M(T.$$.fragment,s),E=t(s),M(j.$$.fragment,s),V=t(s),M(u.$$.fragment,s),_=t(s),f=c(s,"P",{"data-svelte-h":!0}),R(f)!=="svelte-1nqczoz"&&(f.innerHTML=ls),H=t(s),M(g.$$.fragment,s),A=t(s),M(b.$$.fragment,s),q=t(s),I=c(s,"P",{"data-svelte-h":!0}),R(I)!=="svelte-1gspubq"&&(I.innerHTML=as),X=t(s),C=c(s,"P",{"data-svelte-h":!0}),R(C)!=="svelte-em0etc"&&(C.innerHTML=es),z=t(s),Z=c(s,"P",{"data-svelte-h":!0}),R(Z)!=="svelte-lja874"&&(Z.innerHTML=ns),x=t(s),M(B.$$.fragment,s),L=t(s),k=c(s,"UL",{"data-svelte-h":!0}),R(k)!=="svelte-cfwqb4"&&(k.innerHTML=ts),D=t(s),Q=c(s,"P",{}),ps(Q).forEach(a),this.h()},h(){is(p,"name","hf:doc:metadata"),is(p,"content",Us)},m(s,l){Js(document.head,p),e(s,W,l),e(s,G,l),e(s,Y,l),y(r,s,l),e(s,S,l),e(s,U,l),e(s,N,l),y(d,s,l),e(s,F,l),y(w,s,l),e(s,v,l),y(T,s,l),e(s,E,l),y(j,s,l),e(s,V,l),y(u,s,l),e(s,_,l),e(s,f,l),e(s,H,l),y(g,s,l),e(s,A,l),y(b,s,l),e(s,q,l),e(s,I,l),e(s,X,l),e(s,C,l),e(s,z,l),e(s,Z,l),e(s,x,l),y(B,s,l),e(s,L,l),e(s,k,l),e(s,D,l),e(s,Q,l),P=!0},p:cs,i(s){P||(h(r.$$.fragment,s),h(d.$$.fragment,s),h(w.$$.fragment,s),h(T.$$.fragment,s),h(j.$$.fragment,s),h(u.$$.fragment,s),h(g.$$.fragment,s),h(b.$$.fragment,s),h(B.$$.fragment,s),P=!0)},o(s){m(r.$$.fragment,s),m(d.$$.fragment,s),m(w.$$.fragment,s),m(T.$$.fragment,s),m(j.$$.fragment,s),m(u.$$.fragment,s),m(g.$$.fragment,s),m(b.$$.fragment,s),m(B.$$.fragment,s),P=!1},d(s){s&&(a(W),a(G),a(Y),a(S),a(U),a(N),a(F),a(v),a(E),a(V),a(_),a(f),a(H),a(A),a(q),a(I),a(X),a(C),a(z),a(Z),a(x),a(L),a(k),a(D),a(Q)),a(p),J(r,s),J(d,s),J(w,s),J(T,s),J(j,s),J(u,s),J(g,s),J(b,s),J(B,s)}}}const Us='{"title":"🤗 Hugging Face Hub API","local":"-hugging-face-hub-api","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Performance considerations","local":"performance-considerations","sections":[],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function ds(O){return Ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends ys{constructor(p){super(),hs(this,p,ds,rs,os,{})}}export{fs as component};
