import{s as Ja,n as La,o as Ua}from"../chunks/scheduler.85c25b89.js";import{S as Fa,i as Za,g as l,s as n,r as c,A as Ia,h as i,f as t,c as o,j as b,u as g,x as m,k as v,y as r,a as s,v as _,d as u,t as f,w as h}from"../chunks/index.c142fe32.js";import{D as y}from"../chunks/Docstring.e6639b56.js";import{C as Ot}from"../chunks/CodeBlock.a5e95a57.js";import{H as F,E as za}from"../chunks/EditOnGithub.a592e7aa.js";function Da(ta){let x,Ee,je,Ve,Z,We,I,aa='<a href="https://huggingface.co/models?other=bco,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-BCO-blue"/></a>',Ge,z,na=`TRL supports the Binary Classifier Optimization (BCO).
The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
For a full example have a look at  <code>examples/scripts/bco.py</code>.`,Xe,D,Re,H,oa=`The <a href="/docs/trl/v0.12.2/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> requires an <a href="dataset_formats#unpaired-preference">unpaired preference dataset</a>.
The <a href="/docs/trl/v0.12.2/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.`,Ae,j,Se,P,ra="The BCO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",qe,E,Qe,V,la="For a detailed example have a look at the <code>examples/scripts/bco.py</code> script. At a high level we need to initialize the <code>BCOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",Ye,W,ia="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ke,G,et,X,sa="After this one can then call:",tt,R,at,A,nt,S,da=`In practical scenarios, the thumbs-up and thumbs-down datasets are likely to have divergent underlying distributions of prompts.
Consider an LLM deployed for user feedback: if the model excels in writing tasks but underperforms in coding, the thumbs-up dataset will be dominated by writing-related prompts, while the thumbs-down dataset will contain mostly coding-related prompts.<br/>
If the prompts in your desired and undesired datasets differ a lot, it is useful to enable UDM.`,ot,q,ma="Choose an embedding model and tokenizer:",rt,Q,lt,Y,pa="Set <code>prompt_sample_size</code> to defined how many prompts are selected to train the UDM classifier and start the training with the provided embedding function:",it,K,st,ee,dt,te,ca=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,mt,ae,ga=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,pt,ne,ct,d,oe,Mt,ve,_a='Initialize BCOTrainer from <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.',Bt,O,re,Nt,ye,ua="Compute the BCO loss for a batch of policy and reference model log probabilities.",kt,M,le,Jt,Te,fa="Computes log probabilities of the reference model for a single padded batch of a BCO specific dataset.",Lt,B,ie,Ut,Ce,ha="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Ft,C,se,Zt,$e,ba=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,It,we,va="Works both with or without labels.",zt,N,de,Dt,xe,ya="Generate samples from the model and reference model for the given batch of inputs.",Ht,k,me,jt,Oe,Ta="Compute the log probabilities of the given labels under the given logits.",Pt,J,pe,Et,Me,Ca="Compute the BCO loss and other metrics for the given batch of inputs for train or test.",Vt,$,ce,Wt,Be,$a="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Gt,Ne,wa="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Xt,w,ge,Rt,ke,xa="Returns the training <code>~torch.utils.data.DataLoader</code>.",At,Je,Oa="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",St,L,_e,qt,Le,Ma="Log <code>logs</code> on the various objects watching training, including stored metrics.",Qt,U,ue,Yt,Ue,Ba="Context manager for handling null reference model (that is, peft adapter manipulation).",gt,fe,_t,T,he,Kt,Fe,Na='Configuration class for the <a href="/docs/trl/v0.12.2/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a>.',ea,Ze,ka=`Using <a href="https://huggingface.co/docs/transformers/v4.47.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ut,be,ft,Pe,ht;return Z=new F({props:{title:"BCO Trainer",local:"bco-trainer",headingTag:"h1"}}),D=new F({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),j=new F({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),E=new F({props:{title:"Using the BCOTrainer",local:"using-the-bcotrainer",headingTag:"h2"}}),G=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
)`,wrap:!1}}),R=new Ot({props:{code:"YmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"bco_trainer.train()",wrap:!1}}),A=new F({props:{title:"Underlying Distribution matching (UDM)",local:"underlying-distribution-matching-udm",headingTag:"h2"}}),Q=new Ot({props:{code:"ZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQWVtYmVkZGluZ190b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQSUwQSUyMyUyMGN1c3RvbWl6ZSUyMHRoaXMlMjBmdW5jdGlvbiUyMGRlcGVuZGluZyUyMG9uJTIweW91ciUyMGVtYmVkZGluZyUyMG1vZGVsJTBBZGVmJTIwZW1iZWRfcHJvbXB0KGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTNEYXR0ZW50aW9uX21hc2spJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZS5tZWFuKGRpbSUzRDEpJTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQWNjZWxlcmF0b3IoKS5wcmVwYXJlX21vZGVsKHNlbGYuZW1iZWRkaW5nX21vZGVsKSUwQWVtYmVkZGluZ19mdW5jJTIwJTNEJTIwcGFydGlhbChlbWJlZF9wcm9tcHQlMkMlMjBtb2RlbCUzRGVtYmVkZGluZ19tb2RlbCk=",highlighted:`embedding_model = AutoModel.from_pretrained(your_model_id)
embedding_tokenizer = AutoTokenizer.from_pretrained(your_model_id)

<span class="hljs-comment"># customize this function depending on your embedding model</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompt</span>(<span class="hljs-params">input_ids, attention_mask, model</span>):
    outputs = model(input_ids=input_ids, attention_mask=attention_mask)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)

embedding_model = Accelerator().prepare_model(self.embedding_model)
embedding_func = partial(embed_prompt, model=embedding_model)`,wrap:!1}}),K=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3NhbXBsZV9zaXplJTNENTEyJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX2Z1bmMlM0RlbWJlZGRpbmdfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ190b2tlbml6ZXIlM0RzZWxmLmVtYmVkZGluZ190b2tlbml6ZXIlMkMlMEEpJTBBJTBBYmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
    prompt_sample_size=<span class="hljs-number">512</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
    embedding_func=embedding_func,
    embedding_tokenizer=self.embedding_tokenizer,
)

bco_trainer.train()`,wrap:!1}}),ee=new F({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),ne=new F({props:{title:"BCOTrainer",local:"trl.BCOTrainer",headingTag:"h2"}}),oe=new y({props:{name:"class trl.BCOTrainer",anchor:"trl.BCOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": BCOConfig = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, typing.Dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"callbacks",val:": typing.Optional[typing.List[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": typing.Tuple[torch.optim.optimizer.Optimizer, torch.optim.lr_scheduler.LambdaLR] = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[typing.Dict] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], typing.Dict]] = None"},{name:"model_adapter_name",val:": typing.Optional[str] = None"},{name:"ref_adapter_name",val:": typing.Optional[str] = None"},{name:"embedding_func",val:": typing.Optional[typing.Callable] = None"},{name:"embedding_tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.BCOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.BCOTrainer.args",description:`<strong>args</strong> (<code>BCOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.BCOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.BCOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.BCOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.BCOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.BCOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.BCOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>List[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.BCOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>Tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.BCOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.BCOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>Dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.BCOTrainer.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to disable dropouts in <code>model</code> and <code>ref_model</code>.`,name:"disable_dropout"},{anchor:"trl.BCOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], Dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.BCOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.BCOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L275"}}),re=new y({props:{name:"bco_loss",anchor:"trl.BCOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": typing.Optional[torch.FloatTensor]"},{name:"rejected_embeddings",val:": typing.Optional[torch.FloatTensor]"}],parametersDescription:[{anchor:"trl.BCOTrainer.bco_loss.policy_chosen_logps",description:"<strong>policy_chosen_logps</strong> &#x2014; Log probabilities of the policy model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"policy_chosen_logps"},{anchor:"trl.BCOTrainer.bco_loss.policy_rejected_logps",description:"<strong>policy_rejected_logps</strong> &#x2014; Log probabilities of the policy model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"policy_rejected_logps"},{anchor:"trl.BCOTrainer.bco_loss.reference_chosen_logps",description:"<strong>reference_chosen_logps</strong> &#x2014; Log probabilities of the reference model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"reference_chosen_logps"},{anchor:"trl.BCOTrainer.bco_loss.reference_rejected_logps",description:"<strong>reference_rejected_logps</strong> &#x2014; Log probabilities of the reference model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"reference_rejected_logps"},{anchor:"trl.BCOTrainer.bco_loss.chosen_embeddings",description:"<strong>chosen_embeddings</strong> &#x2014; embeddings of desirable prompts",name:"chosen_embeddings"},{anchor:"trl.BCOTrainer.bco_loss.rejected_embeddings",description:"<strong>rejected_embeddings</strong> &#x2014; embeddings of undesirable prompts",name:"rejected_embeddings"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1121",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, delta).
The losses tensor contains the BCO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),le=new y({props:{name:"compute_reference_log_probs",anchor:"trl.BCOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": typing.Dict"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L980"}}),ie=new y({props:{name:"create_model_card",anchor:"trl.BCOTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, typing.List[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the model.`,name:"model_name"},{anchor:"trl.BCOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.BCOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>List[str]</code> or None, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1473"}}),se=new y({props:{name:"evaluation_loop",anchor:"trl.BCOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[typing.List[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1384"}}),de=new y({props:{name:"generate_from_model_and_ref",anchor:"trl.BCOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, torch.LongTensor]"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1299"}}),me=new y({props:{name:"get_batch_logps",anchor:"trl.BCOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_batch_logps.logits",description:"<strong>logits</strong> &#x2014; Logits of the model (unnormalized). Shape: (batch_size, sequence_length, vocab_size)",name:"logits"},{anchor:"trl.BCOTrainer.get_batch_logps.labels",description:"<strong>labels</strong> &#x2014; Labels for which to compute the log probabilities. Label tokens with a value of label_pad_token_id are ignored. Shape: (batch_size, sequence_length)",name:"labels"},{anchor:"trl.BCOTrainer.get_batch_logps.average_log_prob",description:"<strong>average_log_prob</strong> &#x2014; If True, return the average log probability per (non-masked) token. Otherwise, return the sum of the log probabilities of the (non-masked) tokens.",name:"average_log_prob"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1023",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),pe=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.BCOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": typing.Dict[str, typing.Union[typing.List, torch.LongTensor]]"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1183"}}),ce=new y({props:{name:"get_eval_dataloader",anchor:"trl.BCOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v3.2.0/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L934"}}),ge=new y({props:{name:"get_train_dataloader",anchor:"trl.BCOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L900"}}),_e=new y({props:{name:"log",anchor:"trl.BCOTrainer.log",parameters:[{name:"logs",val:": typing.Dict[str, float]"}],parametersDescription:[{anchor:"trl.BCOTrainer.log.logs",description:`<strong>logs</strong> (<code>Dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L1440"}}),ue=new y({props:{name:"null_ref_context",anchor:"trl.BCOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_trainer.py#L888"}}),fe=new F({props:{title:"BCOConfig",local:"trl.BCOConfig",headingTag:"h2"}}),he=new y({props:{name:"class trl.BCOConfig",anchor:"trl.BCOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": bool = False"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"max_prompt_length",val:": typing.Optional[int] = None"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"beta",val:": float = 0.1"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.BCOConfig.max_length",description:`<strong>max_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.BCOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.BCOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.BCOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model.`,name:"beta"},{anchor:"trl.BCOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>,  <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.BCOConfig.padding_value",description:`<strong>padding_value</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.BCOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.BCOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from both the model and the reference model to W&amp;B during
evaluation.`,name:"generate_during_eval"},{anchor:"trl.BCOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>Optional[bool]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.BCOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.BCOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.BCOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>Optional[Dict[str, Any]]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.BCOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>Optional[int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.BCOConfig.prompt_sample_size",description:`<strong>prompt_sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of prompts that are fed to density ratio classifier.`,name:"prompt_sample_size"},{anchor:"trl.BCOConfig.min_density_ratio",description:`<strong>min_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Minimum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"min_density_ratio"},{anchor:"trl.BCOConfig.max_density_ratio",description:`<strong>max_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10.0</code>) &#x2014;
Maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"max_density_ratio"}],source:"https://github.com/huggingface/trl/blob/v0.12.2/trl/trainer/bco_config.py#L20"}}),be=new za({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/bco_trainer.mdx"}}),{c(){x=l("meta"),Ee=n(),je=l("p"),Ve=n(),c(Z.$$.fragment),We=n(),I=l("p"),I.innerHTML=aa,Ge=n(),z=l("p"),z.innerHTML=na,Xe=n(),c(D.$$.fragment),Re=n(),H=l("p"),H.innerHTML=oa,Ae=n(),c(j.$$.fragment),Se=n(),P=l("p"),P.innerHTML=ra,qe=n(),c(E.$$.fragment),Qe=n(),V=l("p"),V.innerHTML=la,Ye=n(),W=l("p"),W.innerHTML=ia,Ke=n(),c(G.$$.fragment),et=n(),X=l("p"),X.textContent=sa,tt=n(),c(R.$$.fragment),at=n(),c(A.$$.fragment),nt=n(),S=l("p"),S.innerHTML=da,ot=n(),q=l("p"),q.textContent=ma,rt=n(),c(Q.$$.fragment),lt=n(),Y=l("p"),Y.innerHTML=pa,it=n(),c(K.$$.fragment),st=n(),c(ee.$$.fragment),dt=n(),te=l("p"),te.innerHTML=ca,mt=n(),ae=l("p"),ae.innerHTML=ga,pt=n(),c(ne.$$.fragment),ct=n(),d=l("div"),c(oe.$$.fragment),Mt=n(),ve=l("p"),ve.innerHTML=_a,Bt=n(),O=l("div"),c(re.$$.fragment),Nt=n(),ye=l("p"),ye.textContent=ua,kt=n(),M=l("div"),c(le.$$.fragment),Jt=n(),Te=l("p"),Te.textContent=fa,Lt=n(),B=l("div"),c(ie.$$.fragment),Ut=n(),Ce=l("p"),Ce.innerHTML=ha,Ft=n(),C=l("div"),c(se.$$.fragment),Zt=n(),$e=l("p"),$e.innerHTML=ba,It=n(),we=l("p"),we.textContent=va,zt=n(),N=l("div"),c(de.$$.fragment),Dt=n(),xe=l("p"),xe.textContent=ya,Ht=n(),k=l("div"),c(me.$$.fragment),jt=n(),Oe=l("p"),Oe.textContent=Ta,Pt=n(),J=l("div"),c(pe.$$.fragment),Et=n(),Me=l("p"),Me.textContent=Ca,Vt=n(),$=l("div"),c(ce.$$.fragment),Wt=n(),Be=l("p"),Be.innerHTML=$a,Gt=n(),Ne=l("p"),Ne.innerHTML=wa,Xt=n(),w=l("div"),c(ge.$$.fragment),Rt=n(),ke=l("p"),ke.innerHTML=xa,At=n(),Je=l("p"),Je.innerHTML=Oa,St=n(),L=l("div"),c(_e.$$.fragment),qt=n(),Le=l("p"),Le.innerHTML=Ma,Qt=n(),U=l("div"),c(ue.$$.fragment),Yt=n(),Ue=l("p"),Ue.textContent=Ba,gt=n(),c(fe.$$.fragment),_t=n(),T=l("div"),c(he.$$.fragment),Kt=n(),Fe=l("p"),Fe.innerHTML=Na,ea=n(),Ze=l("p"),Ze.innerHTML=ka,ut=n(),c(be.$$.fragment),ft=n(),Pe=l("p"),this.h()},l(e){const a=Ia("svelte-u9bgzb",document.head);x=i(a,"META",{name:!0,content:!0}),a.forEach(t),Ee=o(e),je=i(e,"P",{}),b(je).forEach(t),Ve=o(e),g(Z.$$.fragment,e),We=o(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-n86tfs"&&(I.innerHTML=aa),Ge=o(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-r130jr"&&(z.innerHTML=na),Xe=o(e),g(D.$$.fragment,e),Re=o(e),H=i(e,"P",{"data-svelte-h":!0}),m(H)!=="svelte-w2e7eq"&&(H.innerHTML=oa),Ae=o(e),g(j.$$.fragment,e),Se=o(e),P=i(e,"P",{"data-svelte-h":!0}),m(P)!=="svelte-a13xh1"&&(P.innerHTML=ra),qe=o(e),g(E.$$.fragment,e),Qe=o(e),V=i(e,"P",{"data-svelte-h":!0}),m(V)!=="svelte-1xv0q10"&&(V.innerHTML=la),Ye=o(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1eil2tw"&&(W.innerHTML=ia),Ke=o(e),g(G.$$.fragment,e),et=o(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1lg6q1l"&&(X.textContent=sa),tt=o(e),g(R.$$.fragment,e),at=o(e),g(A.$$.fragment,e),nt=o(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-16kpfu0"&&(S.innerHTML=da),ot=o(e),q=i(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-1hlwkqm"&&(q.textContent=ma),rt=o(e),g(Q.$$.fragment,e),lt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-ef1qid"&&(Y.innerHTML=pa),it=o(e),g(K.$$.fragment,e),st=o(e),g(ee.$$.fragment,e),dt=o(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-3kfva2"&&(te.innerHTML=ca),mt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1c01yo3"&&(ae.innerHTML=ga),pt=o(e),g(ne.$$.fragment,e),ct=o(e),d=i(e,"DIV",{class:!0});var p=b(d);g(oe.$$.fragment,p),Mt=o(p),ve=i(p,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-13v1u5r"&&(ve.innerHTML=_a),Bt=o(p),O=i(p,"DIV",{class:!0});var bt=b(O);g(re.$$.fragment,bt),Nt=o(bt),ye=i(bt,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-2814fy"&&(ye.textContent=ua),bt.forEach(t),kt=o(p),M=i(p,"DIV",{class:!0});var vt=b(M);g(le.$$.fragment,vt),Jt=o(vt),Te=i(vt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-2l3xud"&&(Te.textContent=fa),vt.forEach(t),Lt=o(p),B=i(p,"DIV",{class:!0});var yt=b(B);g(ie.$$.fragment,yt),Ut=o(yt),Ce=i(yt,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1mh859w"&&(Ce.innerHTML=ha),yt.forEach(t),Ft=o(p),C=i(p,"DIV",{class:!0});var Ie=b(C);g(se.$$.fragment,Ie),Zt=o(Ie),$e=i(Ie,"P",{"data-svelte-h":!0}),m($e)!=="svelte-8qlty5"&&($e.innerHTML=ba),It=o(Ie),we=i(Ie,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1tyo99t"&&(we.textContent=va),Ie.forEach(t),zt=o(p),N=i(p,"DIV",{class:!0});var Tt=b(N);g(de.$$.fragment,Tt),Dt=o(Tt),xe=i(Tt,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-18uwvbi"&&(xe.textContent=ya),Tt.forEach(t),Ht=o(p),k=i(p,"DIV",{class:!0});var Ct=b(k);g(me.$$.fragment,Ct),jt=o(Ct),Oe=i(Ct,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-4nmimv"&&(Oe.textContent=Ta),Ct.forEach(t),Pt=o(p),J=i(p,"DIV",{class:!0});var $t=b(J);g(pe.$$.fragment,$t),Et=o($t),Me=i($t,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1syv8mg"&&(Me.textContent=Ca),$t.forEach(t),Vt=o(p),$=i(p,"DIV",{class:!0});var ze=b($);g(ce.$$.fragment,ze),Wt=o(ze),Be=i(ze,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-xesobz"&&(Be.innerHTML=$a),Gt=o(ze),Ne=i(ze,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-qg43tm"&&(Ne.innerHTML=wa),ze.forEach(t),Xt=o(p),w=i(p,"DIV",{class:!0});var De=b(w);g(ge.$$.fragment,De),Rt=o(De),ke=i(De,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-dkae9b"&&(ke.innerHTML=xa),At=o(De),Je=i(De,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-hmd5cw"&&(Je.innerHTML=Oa),De.forEach(t),St=o(p),L=i(p,"DIV",{class:!0});var wt=b(L);g(_e.$$.fragment,wt),qt=o(wt),Le=i(wt,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-nqksfz"&&(Le.innerHTML=Ma),wt.forEach(t),Qt=o(p),U=i(p,"DIV",{class:!0});var xt=b(U);g(ue.$$.fragment,xt),Yt=o(xt),Ue=i(xt,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-17kjsy4"&&(Ue.textContent=Ba),xt.forEach(t),p.forEach(t),gt=o(e),g(fe.$$.fragment,e),_t=o(e),T=i(e,"DIV",{class:!0});var He=b(T);g(he.$$.fragment,He),Kt=o(He),Fe=i(He,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-12kqvz2"&&(Fe.innerHTML=Na),ea=o(He),Ze=i(He,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-k1oonp"&&(Ze.innerHTML=ka),He.forEach(t),ut=o(e),g(be.$$.fragment,e),ft=o(e),Pe=i(e,"P",{}),b(Pe).forEach(t),this.h()},h(){v(x,"name","hf:doc:metadata"),v(x,"content",Ha),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){r(document.head,x),s(e,Ee,a),s(e,je,a),s(e,Ve,a),_(Z,e,a),s(e,We,a),s(e,I,a),s(e,Ge,a),s(e,z,a),s(e,Xe,a),_(D,e,a),s(e,Re,a),s(e,H,a),s(e,Ae,a),_(j,e,a),s(e,Se,a),s(e,P,a),s(e,qe,a),_(E,e,a),s(e,Qe,a),s(e,V,a),s(e,Ye,a),s(e,W,a),s(e,Ke,a),_(G,e,a),s(e,et,a),s(e,X,a),s(e,tt,a),_(R,e,a),s(e,at,a),_(A,e,a),s(e,nt,a),s(e,S,a),s(e,ot,a),s(e,q,a),s(e,rt,a),_(Q,e,a),s(e,lt,a),s(e,Y,a),s(e,it,a),_(K,e,a),s(e,st,a),_(ee,e,a),s(e,dt,a),s(e,te,a),s(e,mt,a),s(e,ae,a),s(e,pt,a),_(ne,e,a),s(e,ct,a),s(e,d,a),_(oe,d,null),r(d,Mt),r(d,ve),r(d,Bt),r(d,O),_(re,O,null),r(O,Nt),r(O,ye),r(d,kt),r(d,M),_(le,M,null),r(M,Jt),r(M,Te),r(d,Lt),r(d,B),_(ie,B,null),r(B,Ut),r(B,Ce),r(d,Ft),r(d,C),_(se,C,null),r(C,Zt),r(C,$e),r(C,It),r(C,we),r(d,zt),r(d,N),_(de,N,null),r(N,Dt),r(N,xe),r(d,Ht),r(d,k),_(me,k,null),r(k,jt),r(k,Oe),r(d,Pt),r(d,J),_(pe,J,null),r(J,Et),r(J,Me),r(d,Vt),r(d,$),_(ce,$,null),r($,Wt),r($,Be),r($,Gt),r($,Ne),r(d,Xt),r(d,w),_(ge,w,null),r(w,Rt),r(w,ke),r(w,At),r(w,Je),r(d,St),r(d,L),_(_e,L,null),r(L,qt),r(L,Le),r(d,Qt),r(d,U),_(ue,U,null),r(U,Yt),r(U,Ue),s(e,gt,a),_(fe,e,a),s(e,_t,a),s(e,T,a),_(he,T,null),r(T,Kt),r(T,Fe),r(T,ea),r(T,Ze),s(e,ut,a),_(be,e,a),s(e,ft,a),s(e,Pe,a),ht=!0},p:La,i(e){ht||(u(Z.$$.fragment,e),u(D.$$.fragment,e),u(j.$$.fragment,e),u(E.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(Q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(pe.$$.fragment,e),u(ce.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),ht=!0)},o(e){f(Z.$$.fragment,e),f(D.$$.fragment,e),f(j.$$.fragment,e),f(E.$$.fragment,e),f(G.$$.fragment,e),f(R.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(pe.$$.fragment,e),f(ce.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),ht=!1},d(e){e&&(t(Ee),t(je),t(Ve),t(We),t(I),t(Ge),t(z),t(Xe),t(Re),t(H),t(Ae),t(Se),t(P),t(qe),t(Qe),t(V),t(Ye),t(W),t(Ke),t(et),t(X),t(tt),t(at),t(nt),t(S),t(ot),t(q),t(rt),t(lt),t(Y),t(it),t(st),t(dt),t(te),t(mt),t(ae),t(pt),t(ct),t(d),t(gt),t(_t),t(T),t(ut),t(ft),t(Pe)),t(x),h(Z,e),h(D,e),h(j,e),h(E,e),h(G,e),h(R,e),h(A,e),h(Q,e),h(K,e),h(ee,e),h(ne,e),h(oe),h(re),h(le),h(ie),h(se),h(de),h(me),h(pe),h(ce),h(ge),h(_e),h(ue),h(fe,e),h(he),h(be,e)}}}const Ha='{"title":"BCO Trainer","local":"bco-trainer","sections":[{"title":"Expected dataset type","local":"expected-dataset-type","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the BCOTrainer","local":"using-the-bcotrainer","sections":[],"depth":2},{"title":"Underlying Distribution matching (UDM)","local":"underlying-distribution-matching-udm","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"BCOTrainer","local":"trl.BCOTrainer","sections":[],"depth":2},{"title":"BCOConfig","local":"trl.BCOConfig","sections":[],"depth":2}],"depth":1}';function ja(ta){return Ua(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends Fa{constructor(x){super(),Za(this,x,ja,Da,Ja,{})}}export{Xa as component};
