import{s as EA,f as qA,n as YA,o as _A}from"../chunks/scheduler.048ce5c2.js";import{S as $A,i as Aa,g as e,s as l,r as j,A as aa,h as f,f as s,c as n,j as OA,u as o,x as w,k as XA,y as sa,a as t,v as P,d as r,t as p,w as M}from"../chunks/index.2633050f.js";import{C as B}from"../chunks/CodeBlock.b34ffc90.js";import{D as ta}from"../chunks/DocNotebookDropdown.2a84b269.js";import{H as DA}from"../chunks/Heading.bb054f8c.js";function la(xA){let i,E,L,q,c,Y,J,_,y,uA='In this notebook we’re going to illustrate one way to add conditioning information to a diffusion model. Specifically, we’ll train a class-conditioned diffusion model on MNIST following on from the <a href="https://github.com/huggingface/diffusion-models-class/blob/unit2/unit1/02_diffusion_models_from_scratch.ipynb" rel="nofollow">‘from-scratch’ example in Unit 1</a>, where we can specify which digit we’d like the model to generate at inference time.',$,U,TA="As mentioned in the introduction to this unit, this is just one of many ways we could add additional conditioning information to a diffusion model, and has been chosen for its relative simplicity. Just like the ‘from-scratch’ notebook in Unit 1, this notebook is mostly for illustrative purposes and you can safely skip it if you’d like.",AA,H,aA,h,sA,g,IA=`\x1B[K     |████████████████████████████████| 503 kB 7.2 MB/s 
\x1B[K     |████████████████████████████████| 182 kB 51.3 MB/s 
\x1B[?25h
`,tA,v,lA,C,mA=`Using device: cuda
`,nA,d,eA,b,FA=`Downloading http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz
Downloading http://yann.lecun.com/exdb/mnist/train-images-idx3-ubyte.gz to mnist/MNIST/raw/train-images-idx3-ubyte.gz
`,fA,D,wA,X,GA="The way we’ll feed in the class conditioning is as follows:",jA,x,RA="<li>Create a standard <code>UNet2DModel</code> with some additional input channels</li> <li>Map the class label to a learned vector of shape <code>(class_emb_size)</code>via an embedding layer</li> <li>Concatenate this information as extra channels for the internal UNet input with <code>net_input = torch.cat((x, class_cond), 1)</code></li> <li>Feed this <code>net_input</code> (which has (<code>class_emb_size+1</code>) channels in total) into the UNet to get the final prediction</li>",oA,u,NA="In this example I’ve set the class_emb_size to 4, but this is completely arbitrary and you could explore having it size 1 (to see if it still works), size 10 (to match the number of classes), or replacing the learned nn.Embedding with a simple one-hot encoding of the class label directly.",PA,T,zA="This is what the implementation looks like:",rA,I,pA,m,QA="If any of the shapes or transforms are confusing, add in print statements to show the relevant shapes and check that they match your expectations. I’ve also annotated the shapes of some intermediate variables in the hopes of making things clearer.",MA,F,iA,G,VA="Where previously we’d do something like <code>prediction = unet(x, t)</code> we’ll now add the correct labels as a third argument (<code>prediction = unet(x, t, y)</code>) during training, and at inference we can pass whatever labels we want and if all goes well the model should generate images that match. <code>y</code> in this case is the labels of the MNIST digits, with values from 0 to 9.",BA,R,KA='The training loop is very similar to the <a href="https://github.com/huggingface/diffusion-models-class/blob/unit2/unit1/02_diffusion_models_from_scratch.ipynb" rel="nofollow">example from Unit 1</a>. We’re now predicting the noise (rather than the denoised image as in Unit 1) to match the objective expected by the default DDPMScheduler which we’re using to add noise during training and to generate samples at inference time. Training takes a while - speeding this up could be a fun mini-project, but most of you can probably just skim the code (and indeed this whole notebook) without running it since we’re just illustrating an idea.',cA,N,JA,z,yA,Q,kA=`Finished epoch 0. Average of the last 100 loss values: 0.052451
`,UA,V,WA="Once training finishes, we can sample some images feeding in different labels as our conditioning:",HA,K,hA,S,ZA,gA,k,SA="There we go! We can now have some control over what images are produced.",vA,W,LA="I hope you’ve enjoyed this example. As always, feel free to ask questions in the Discord.",CA,Z,dA,O,bA;return c=new ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/diffusion-models-class/blob/main/unit2/02_class_conditioned_diffusion_model_example.ipynb"}]}}),J=new DA({props:{title:"Making a Class-Conditioned Diffusion Model",local:"making-a-class-conditioned-diffusion-model",headingTag:"h1"}}),H=new DA({props:{title:"Setup and Data Prep",local:"setup-and-data-prep",headingTag:"h2"}}),h=new B({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMC1xJTIwZGlmZnVzZXJz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>%pip install -q diffusers',wrap:!1}}),v=new B({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaHZpc2lvbiUwQWZyb20lMjB0b3JjaCUyMGltcG9ydCUyMG5uJTBBZnJvbSUyMHRvcmNoLm5uJTIwaW1wb3J0JTIwZnVuY3Rpb25hbCUyMGFzJTIwRiUwQWZyb20lMjB0b3JjaC51dGlscy5kYXRhJTIwaW1wb3J0JTIwRGF0YUxvYWRlciUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBERFBNU2NoZWR1bGVyJTJDJTIwVU5ldDJETW9kZWwlMEFmcm9tJTIwbWF0cGxvdGxpYiUyMGltcG9ydCUyMHB5cGxvdCUyMGFzJTIwcGx0JTBBZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFkZXZpY2UlMjAlM0QlMjAlMjJtcHMlMjIlMjBpZiUyMHRvcmNoLmJhY2tlbmRzLm1wcy5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQXByaW50KGYlMjJVc2luZyUyMGRldmljZSUzQSUyMCU3QmRldmljZSU3RCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torchvision
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.nn <span class="hljs-keyword">import</span> functional <span class="hljs-keyword">as</span> F
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDPMScheduler, UNet2DModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> matplotlib <span class="hljs-keyword">import</span> pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;mps&quot;</span> <span class="hljs-keyword">if</span> torch.backends.mps.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Using device: <span class="hljs-subst">{device}</span>&quot;</span>)`,wrap:!1}}),d=new B({props:{code:"JTIzJTIwTG9hZCUyMHRoZSUyMGRhdGFzZXQlMEFkYXRhc2V0JTIwJTNEJTIwdG9yY2h2aXNpb24uZGF0YXNldHMuTU5JU1QoJTBBJTIwJTIwJTIwJTIwcm9vdCUzRCUyMm1uaXN0JTJGJTIyJTJDJTIwdHJhaW4lM0RUcnVlJTJDJTIwZG93bmxvYWQlM0RUcnVlJTJDJTIwdHJhbnNmb3JtJTNEdG9yY2h2aXNpb24udHJhbnNmb3Jtcy5Ub1RlbnNvcigpJTBBKSUwQSUwQSUyMyUyMEZlZWQlMjBpdCUyMGludG8lMjBhJTIwZGF0YWxvYWRlciUyMChiYXRjaCUyMHNpemUlMjA4JTIwaGVyZSUyMGp1c3QlMjBmb3IlMjBkZW1vKSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBEYXRhTG9hZGVyKGRhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCUyQyUyMHNodWZmbGUlM0RUcnVlKSUwQSUwQSUyMyUyMFZpZXclMjBzb21lJTIwZXhhbXBsZXMlMEF4JTJDJTIweSUyMCUzRCUyMG5leHQoaXRlcih0cmFpbl9kYXRhbG9hZGVyKSklMEFwcmludCglMjJJbnB1dCUyMHNoYXBlJTNBJTIyJTJDJTIweC5zaGFwZSklMEFwcmludCglMjJMYWJlbHMlM0ElMjIlMkMlMjB5KSUwQXBsdC5pbXNob3codG9yY2h2aXNpb24udXRpbHMubWFrZV9ncmlkKHgpJTVCMCU1RCUyQyUyMGNtYXAlM0QlMjJHcmV5cyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = torchvision.datasets.MNIST(
<span class="hljs-meta">... </span>    root=<span class="hljs-string">&quot;mnist/&quot;</span>, train=<span class="hljs-literal">True</span>, download=<span class="hljs-literal">True</span>, transform=torchvision.transforms.ToTensor()
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Feed it into a dataloader (batch size 8 here just for demo)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(dataset, batch_size=<span class="hljs-number">8</span>, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View some examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x, y = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input shape:&quot;</span>, x.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Labels:&quot;</span>, y)
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.imshow(torchvision.utils.make_grid(x)[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),D=new DA({props:{title:"Creating a Class-Conditioned UNet",local:"creating-a-class-conditioned-unet",headingTag:"h2"}}),I=new B({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">ClassConditionedUnet</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, num_classes=<span class="hljs-number">10</span>, class_emb_size=<span class="hljs-number">4</span></span>):
        <span class="hljs-built_in">super</span>().__init__()

        <span class="hljs-comment"># The embedding layer will map the class label to a vector of size class_emb_size</span>
        self.class_emb = nn.Embedding(num_classes, class_emb_size)

        <span class="hljs-comment"># Self.model is an unconditional UNet with extra input channels to accept the conditioning information (the class embedding)</span>
        self.model = UNet2DModel(
            sample_size=<span class="hljs-number">28</span>,  <span class="hljs-comment"># the target image resolution</span>
            in_channels=<span class="hljs-number">1</span> + class_emb_size,  <span class="hljs-comment"># Additional input channels for class cond.</span>
            out_channels=<span class="hljs-number">1</span>,  <span class="hljs-comment"># the number of output channels</span>
            layers_per_block=<span class="hljs-number">2</span>,  <span class="hljs-comment"># how many ResNet layers to use per UNet block</span>
            block_out_channels=(<span class="hljs-number">32</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>),
            down_block_types=(
                <span class="hljs-string">&quot;DownBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet downsampling block</span>
                <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet downsampling block with spatial self-attention</span>
                <span class="hljs-string">&quot;AttnDownBlock2D&quot;</span>,
            ),
            up_block_types=(
                <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,
                <span class="hljs-string">&quot;AttnUpBlock2D&quot;</span>,  <span class="hljs-comment"># a ResNet upsampling block with spatial self-attention</span>
                <span class="hljs-string">&quot;UpBlock2D&quot;</span>,  <span class="hljs-comment"># a regular ResNet upsampling block</span>
            ),
        )

    <span class="hljs-comment"># Our forward method now takes the class labels as an additional argument</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, x, t, class_labels</span>):
        <span class="hljs-comment"># Shape of x:</span>
        bs, ch, w, h = x.shape

        <span class="hljs-comment"># class conditioning in right shape to add as additional input channels</span>
        class_cond = self.class_emb(class_labels)  <span class="hljs-comment"># Map to embedding dimension</span>
        class_cond = class_cond.view(bs, class_cond.shape[<span class="hljs-number">1</span>], <span class="hljs-number">1</span>, <span class="hljs-number">1</span>).expand(bs, class_cond.shape[<span class="hljs-number">1</span>], w, h)
        <span class="hljs-comment"># x is shape (bs, 1, 28, 28) and class_cond is now (bs, 4, 28, 28)</span>

        <span class="hljs-comment"># Net input is now x and class cond concatenated together along dimension 1</span>
        net_input = torch.cat((x, class_cond), <span class="hljs-number">1</span>)  <span class="hljs-comment"># (bs, 5, 28, 28)</span>

        <span class="hljs-comment"># Feed this to the UNet alongside the timestep and return the prediction</span>
        <span class="hljs-keyword">return</span> self.model(net_input, t).sample  <span class="hljs-comment"># (bs, 1, 28, 28)</span>`,wrap:!1}}),F=new DA({props:{title:"Training and Sampling",local:"training-and-sampling",headingTag:"h2"}}),N=new B({props:{code:"JTIzJTIwQ3JlYXRlJTIwYSUyMHNjaGVkdWxlciUwQW5vaXNlX3NjaGVkdWxlciUyMCUzRCUyMEREUE1TY2hlZHVsZXIobnVtX3RyYWluX3RpbWVzdGVwcyUzRDEwMDAlMkMlMjBiZXRhX3NjaGVkdWxlJTNEJTIyc3F1YXJlZGNvc19jYXBfdjIlMjIp",highlighted:`<span class="hljs-comment"># Create a scheduler</span>
noise_scheduler = DDPMScheduler(num_train_timesteps=<span class="hljs-number">1000</span>, beta_schedule=<span class="hljs-string">&quot;squaredcos_cap_v2&quot;</span>)`,wrap:!1}}),z=new B({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Training loop (10 Epochs):</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Redefining the dataloader to set the batch size higher than the demo of 8</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(dataset, batch_size=<span class="hljs-number">128</span>, shuffle=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># How many runs through the data should we do?</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>n_epochs = <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Our network</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>net = ClassConditionedUnet().to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Our loss function</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>loss_fn = nn.MSELoss()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The optimizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>opt = torch.optim.Adam(net.parameters(), lr=<span class="hljs-number">1e-3</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Keeping a record of the losses for later viewing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>losses = []

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The training loop</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> x, y <span class="hljs-keyword">in</span> tqdm(train_dataloader):

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get some data and prepare the corrupted version</span>
<span class="hljs-meta">... </span>        x = x.to(device) * <span class="hljs-number">2</span> - <span class="hljs-number">1</span>  <span class="hljs-comment"># Data on the GPU (mapped to (-1, 1))</span>
<span class="hljs-meta">... </span>        y = y.to(device)
<span class="hljs-meta">... </span>        noise = torch.randn_like(x)
<span class="hljs-meta">... </span>        timesteps = torch.randint(<span class="hljs-number">0</span>, <span class="hljs-number">999</span>, (x.shape[<span class="hljs-number">0</span>],)).long().to(device)
<span class="hljs-meta">... </span>        noisy_x = noise_scheduler.add_noise(x, noise, timesteps)

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Get the model prediction</span>
<span class="hljs-meta">... </span>        pred = net(noisy_x, timesteps, y)  <span class="hljs-comment"># Note that we pass in the labels y</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Calculate the loss</span>
<span class="hljs-meta">... </span>        loss = loss_fn(pred, noise)  <span class="hljs-comment"># How close is the output to the noise</span>

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Backprop and update the params:</span>
<span class="hljs-meta">... </span>        opt.zero_grad()
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        opt.step()

<span class="hljs-meta">... </span>        <span class="hljs-comment"># Store the loss for later</span>
<span class="hljs-meta">... </span>        losses.append(loss.item())

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Print out the average of the last 100 loss values to get an idea of progress:</span>
<span class="hljs-meta">... </span>    avg_loss = <span class="hljs-built_in">sum</span>(losses[-<span class="hljs-number">100</span>:]) / <span class="hljs-number">100</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Finished epoch <span class="hljs-subst">{epoch}</span>. Average of the last 100 loss values: <span class="hljs-subst">{avg_loss:05f}</span>&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># View the loss curve</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>plt.plot(losses)`,wrap:!1}}),K=new B({props:{code:"JTIzJTIwJTQwbWFya2Rvd24lMjBTYW1wbGluZyUyMHNvbWUlMjBkaWZmZXJlbnQlMjBkaWdpdHMlM0ElMEElMEElMjMlMjBQcmVwYXJlJTIwcmFuZG9tJTIweCUyMHRvJTIwc3RhcnQlMjBmcm9tJTJDJTIwcGx1cyUyMHNvbWUlMjBkZXNpcmVkJTIwbGFiZWxzJTIweSUwQXglMjAlM0QlMjB0b3JjaC5yYW5kbig4MCUyQyUyMDElMkMlMjAyOCUyQyUyMDI4KS50byhkZXZpY2UpJTBBeSUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIlNUJpJTVEJTIwKiUyMDglMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgxMCklNUQpLmZsYXR0ZW4oKS50byhkZXZpY2UpJTBBJTBBJTIzJTIwU2FtcGxpbmclMjBsb29wJTBBZm9yJTIwaSUyQyUyMHQlMjBpbiUyMHRxZG0oZW51bWVyYXRlKG5vaXNlX3NjaGVkdWxlci50aW1lc3RlcHMpKSUzQSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEdldCUyMG1vZGVsJTIwcHJlZCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXNpZHVhbCUyMCUzRCUyMG5ldCh4JTJDJTIwdCUyQyUyMHkpJTIwJTIwJTIzJTIwQWdhaW4lMkMlMjBub3RlJTIwdGhhdCUyMHdlJTIwcGFzcyUyMGluJTIwb3VyJTIwbGFiZWxzJTIweSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFVwZGF0ZSUyMHNhbXBsZSUyMHdpdGglMjBzdGVwJTBBJTIwJTIwJTIwJTIweCUyMCUzRCUyMG5vaXNlX3NjaGVkdWxlci5zdGVwKHJlc2lkdWFsJTJDJTIwdCUyQyUyMHgpLnByZXZfc2FtcGxlJTBBJTBBJTIzJTIwU2hvdyUyMHRoZSUyMHJlc3VsdHMlMEFmaWclMkMlMjBheCUyMCUzRCUyMHBsdC5zdWJwbG90cygxJTJDJTIwMSUyQyUyMGZpZ3NpemUlM0QoMTIlMkMlMjAxMikpJTBBYXguaW1zaG93KHRvcmNodmlzaW9uLnV0aWxzLm1ha2VfZ3JpZCh4LmRldGFjaCgpLmNwdSgpLmNsaXAoLTElMkMlMjAxKSUyQyUyMG5yb3clM0Q4KSU1QjAlNUQlMkMlMjBjbWFwJTNEJTIyR3JleXMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># @markdown Sampling some different digits:</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Prepare random x to start from, plus some desired labels y</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>x = torch.randn(<span class="hljs-number">80</span>, <span class="hljs-number">1</span>, <span class="hljs-number">28</span>, <span class="hljs-number">28</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span>y = torch.tensor([[i] * <span class="hljs-number">8</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">10</span>)]).flatten().to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Sampling loop</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i, t <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">enumerate</span>(noise_scheduler.timesteps)):

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Get model pred</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        residual = net(x, t, y)  <span class="hljs-comment"># Again, note that we pass in our labels y</span>

<span class="hljs-meta">... </span>    <span class="hljs-comment"># Update sample with step</span>
<span class="hljs-meta">... </span>    x = noise_scheduler.step(residual, t, x).prev_sample

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Show the results</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fig, ax = plt.subplots(<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, figsize=(<span class="hljs-number">12</span>, <span class="hljs-number">12</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>ax.imshow(torchvision.utils.make_grid(x.detach().cpu().clip(-<span class="hljs-number">1</span>, <span class="hljs-number">1</span>), nrow=<span class="hljs-number">8</span>)[<span class="hljs-number">0</span>], cmap=<span class="hljs-string">&quot;Greys&quot;</span>)`,wrap:!1}}),Z=new B({props:{code:"JTIzJTIwRXhlcmNpc2UlMjAob3B0aW9uYWwpJTNBJTIwVHJ5JTIwdGhpcyUyMHdpdGglMjBGYXNoaW9uTU5JU1QuJTIwVHdlYWslMjB0aGUlMjBsZWFybmluZyUyMHJhdGUlMkMlMjBiYXRjaCUyMHNpemUlMjBhbmQlMjBudW1iZXIlMjBvZiUyMGVwb2Nocy4lMEElMjMlMjBDYW4lMjB5b3UlMjBnZXQlMjBzb21lJTIwZGVjZW50LWxvb2tpbmclMjBmYXNoaW9uJTIwaW1hZ2VzJTIwd2l0aCUyMGxlc3MlMjB0cmFpbmluZyUyMHRpbWUlMjB0aGFuJTIwdGhlJTIwZXhhbXBsZSUyMGFib3ZlJTNG",highlighted:`<span class="hljs-comment"># Exercise (optional): Try this with FashionMNIST. Tweak the learning rate, batch size and number of epochs.</span>
<span class="hljs-comment"># Can you get some decent-looking fashion images with less training time than the example above?</span>`,wrap:!1}}),{c(){i=e("meta"),E=l(),L=e("p"),q=l(),j(c.$$.fragment),Y=l(),j(J.$$.fragment),_=l(),y=e("p"),y.innerHTML=uA,$=l(),U=e("p"),U.textContent=TA,AA=l(),j(H.$$.fragment),aA=l(),j(h.$$.fragment),sA=l(),g=e("pre"),g.textContent=IA,tA=l(),j(v.$$.fragment),lA=l(),C=e("pre"),C.textContent=mA,nA=l(),j(d.$$.fragment),eA=l(),b=e("pre"),b.textContent=FA,fA=l(),j(D.$$.fragment),wA=l(),X=e("p"),X.textContent=GA,jA=l(),x=e("ul"),x.innerHTML=RA,oA=l(),u=e("p"),u.textContent=NA,PA=l(),T=e("p"),T.textContent=zA,rA=l(),j(I.$$.fragment),pA=l(),m=e("p"),m.textContent=QA,MA=l(),j(F.$$.fragment),iA=l(),G=e("p"),G.innerHTML=VA,BA=l(),R=e("p"),R.innerHTML=KA,cA=l(),j(N.$$.fragment),JA=l(),j(z.$$.fragment),yA=l(),Q=e("pre"),Q.textContent=kA,UA=l(),V=e("p"),V.textContent=WA,HA=l(),j(K.$$.fragment),hA=l(),S=e("img"),gA=l(),k=e("p"),k.textContent=SA,vA=l(),W=e("p"),W.textContent=LA,CA=l(),j(Z.$$.fragment),dA=l(),O=e("p"),this.h()},l(A){const a=aa("svelte-u9bgzb",document.head);i=f(a,"META",{name:!0,content:!0}),a.forEach(s),E=n(A),L=f(A,"P",{}),OA(L).forEach(s),q=n(A),o(c.$$.fragment,A),Y=n(A),o(J.$$.fragment,A),_=n(A),y=f(A,"P",{"data-svelte-h":!0}),w(y)!=="svelte-1oxmzdx"&&(y.innerHTML=uA),$=n(A),U=f(A,"P",{"data-svelte-h":!0}),w(U)!=="svelte-y45ykf"&&(U.textContent=TA),AA=n(A),o(H.$$.fragment,A),aA=n(A),o(h.$$.fragment,A),sA=n(A),g=f(A,"PRE",{"data-svelte-h":!0}),w(g)!=="svelte-mfpdit"&&(g.textContent=IA),tA=n(A),o(v.$$.fragment,A),lA=n(A),C=f(A,"PRE",{"data-svelte-h":!0}),w(C)!=="svelte-r4w2rl"&&(C.textContent=mA),nA=n(A),o(d.$$.fragment,A),eA=n(A),b=f(A,"PRE",{"data-svelte-h":!0}),w(b)!=="svelte-10x3oeh"&&(b.textContent=FA),fA=n(A),o(D.$$.fragment,A),wA=n(A),X=f(A,"P",{"data-svelte-h":!0}),w(X)!=="svelte-1llz19q"&&(X.textContent=GA),jA=n(A),x=f(A,"UL",{"data-svelte-h":!0}),w(x)!=="svelte-rdgvyl"&&(x.innerHTML=RA),oA=n(A),u=f(A,"P",{"data-svelte-h":!0}),w(u)!=="svelte-154ryau"&&(u.textContent=NA),PA=n(A),T=f(A,"P",{"data-svelte-h":!0}),w(T)!=="svelte-uf8dru"&&(T.textContent=zA),rA=n(A),o(I.$$.fragment,A),pA=n(A),m=f(A,"P",{"data-svelte-h":!0}),w(m)!=="svelte-s8m0mp"&&(m.textContent=QA),MA=n(A),o(F.$$.fragment,A),iA=n(A),G=f(A,"P",{"data-svelte-h":!0}),w(G)!=="svelte-brcbyo"&&(G.innerHTML=VA),BA=n(A),R=f(A,"P",{"data-svelte-h":!0}),w(R)!=="svelte-1u6e2l2"&&(R.innerHTML=KA),cA=n(A),o(N.$$.fragment,A),JA=n(A),o(z.$$.fragment,A),yA=n(A),Q=f(A,"PRE",{"data-svelte-h":!0}),w(Q)!=="svelte-hv6dmb"&&(Q.textContent=kA),UA=n(A),V=f(A,"P",{"data-svelte-h":!0}),w(V)!=="svelte-ih66ks"&&(V.textContent=WA),HA=n(A),o(K.$$.fragment,A),hA=n(A),S=f(A,"IMG",{src:!0}),gA=n(A),k=f(A,"P",{"data-svelte-h":!0}),w(k)!=="svelte-73lmki"&&(k.textContent=SA),vA=n(A),W=f(A,"P",{"data-svelte-h":!0}),w(W)!=="svelte-1miyw30"&&(W.textContent=LA),CA=n(A),o(Z.$$.fragment,A),dA=n(A),O=f(A,"P",{}),OA(O).forEach(s),this.h()},h(){XA(i,"name","hf:doc:metadata"),XA(i,"content",na),qA(S.src,ZA="data:image/jpeg;base64,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")||XA(S,"src",ZA)},m(A,a){sa(document.head,i),t(A,E,a),t(A,L,a),t(A,q,a),P(c,A,a),t(A,Y,a),P(J,A,a),t(A,_,a),t(A,y,a),t(A,$,a),t(A,U,a),t(A,AA,a),P(H,A,a),t(A,aA,a),P(h,A,a),t(A,sA,a),t(A,g,a),t(A,tA,a),P(v,A,a),t(A,lA,a),t(A,C,a),t(A,nA,a),P(d,A,a),t(A,eA,a),t(A,b,a),t(A,fA,a),P(D,A,a),t(A,wA,a),t(A,X,a),t(A,jA,a),t(A,x,a),t(A,oA,a),t(A,u,a),t(A,PA,a),t(A,T,a),t(A,rA,a),P(I,A,a),t(A,pA,a),t(A,m,a),t(A,MA,a),P(F,A,a),t(A,iA,a),t(A,G,a),t(A,BA,a),t(A,R,a),t(A,cA,a),P(N,A,a),t(A,JA,a),P(z,A,a),t(A,yA,a),t(A,Q,a),t(A,UA,a),t(A,V,a),t(A,HA,a),P(K,A,a),t(A,hA,a),t(A,S,a),t(A,gA,a),t(A,k,a),t(A,vA,a),t(A,W,a),t(A,CA,a),P(Z,A,a),t(A,dA,a),t(A,O,a),bA=!0},p:YA,i(A){bA||(r(c.$$.fragment,A),r(J.$$.fragment,A),r(H.$$.fragment,A),r(h.$$.fragment,A),r(v.$$.fragment,A),r(d.$$.fragment,A),r(D.$$.fragment,A),r(I.$$.fragment,A),r(F.$$.fragment,A),r(N.$$.fragment,A),r(z.$$.fragment,A),r(K.$$.fragment,A),r(Z.$$.fragment,A),bA=!0)},o(A){p(c.$$.fragment,A),p(J.$$.fragment,A),p(H.$$.fragment,A),p(h.$$.fragment,A),p(v.$$.fragment,A),p(d.$$.fragment,A),p(D.$$.fragment,A),p(I.$$.fragment,A),p(F.$$.fragment,A),p(N.$$.fragment,A),p(z.$$.fragment,A),p(K.$$.fragment,A),p(Z.$$.fragment,A),bA=!1},d(A){A&&(s(E),s(L),s(q),s(Y),s(_),s(y),s($),s(U),s(AA),s(aA),s(sA),s(g),s(tA),s(lA),s(C),s(nA),s(eA),s(b),s(fA),s(wA),s(X),s(jA),s(x),s(oA),s(u),s(PA),s(T),s(rA),s(pA),s(m),s(MA),s(iA),s(G),s(BA),s(R),s(cA),s(JA),s(yA),s(Q),s(UA),s(V),s(HA),s(hA),s(S),s(gA),s(k),s(vA),s(W),s(CA),s(dA),s(O)),s(i),M(c,A),M(J,A),M(H,A),M(h,A),M(v,A),M(d,A),M(D,A),M(I,A),M(F,A),M(N,A),M(z,A),M(K,A),M(Z,A)}}}const na='{"title":"Making a Class-Conditioned Diffusion Model","local":"making-a-class-conditioned-diffusion-model","sections":[{"title":"Setup and Data Prep","local":"setup-and-data-prep","sections":[],"depth":2},{"title":"Creating a Class-Conditioned UNet","local":"creating-a-class-conditioned-unet","sections":[],"depth":2},{"title":"Training and Sampling","local":"training-and-sampling","sections":[],"depth":2}],"depth":1}';function ea(xA){return _A(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ra extends $A{constructor(i){super(),Aa(this,i,ea,la,EA,{})}}export{ra as component};
