import{s as $t,n as Zt,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as kt,i as Gt,g as p,s as l,r as m,A as Bt,h as i,f as e,c as n,j as Ut,u as o,x as d,k as It,y as Nt,a,v as r,d as c,t as h,w as M}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Wt}from"../chunks/getInferenceSnippets.b020ba4f.js";function xt(Mt){let g,X,V,z,J,H,y,dt='A <strong>TResNet</strong> is a variant on a <a href="https://paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that aim to boost accuracy while maintaining GPU training and inference efficiency.  They contain several design tricks including a SpaceToDepth stem, <a href="https://paperswithcode.com/method/anti-alias-downsampling" rel="nofollow">Anti-Alias downsampling</a>, In-Place Activated BatchNorm, Blocks selection and <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation layers</a>.',S,w,A,j,gt="To load a pretrained model:",F,T,L,u,Jt="To load and preprocess the image:",P,f,D,b,yt="To get the model predictions:",q,U,K,I,wt="To get the top-5 predictions class names:",O,$,tt,Z,jt="Replace the model name with the variant you want to use, e.g. <code>tresnet_l</code>. You can find the IDs in the model summaries at the top of this page.",st,C,Tt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',et,k,at,G,ut="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,B,nt,N,ft=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,pt,W,it,x,bt='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',mt,E,ot,R,rt,v,ct,_,ht;return J=new Y({props:{title:"TResNet",local:"tresnet",headingTag:"h1"}}),w=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),T=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3RyZXNuZXRfbCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgndHJlc25ldF9sJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;tresnet_l&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),W=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),R=new Q({props:{code:"JTQwbWlzYyU3QnJpZG5pazIwMjB0cmVzbmV0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JUUmVzTmV0JTNBJTIwSGlnaCUyMFBlcmZvcm1hbmNlJTIwR1BVLURlZGljYXRlZCUyMEFyY2hpdGVjdHVyZSU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF1dGhvciUzRCU3QlRhbCUyMFJpZG5payUyMGFuZCUyMEh1c3NhbSUyMExhd2VuJTIwYW5kJTIwQXNhZiUyME5veSUyMGFuZCUyMEVtYW51ZWwlMjBCZW4lMjBCYXJ1Y2glMjBhbmQlMjBHaWxhZCUyMFNoYXJpciUyMGFuZCUyMEl0YW1hciUyMEZyaWVkbWFuJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IyMDAzLjEzNjMwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`@misc{ridnik2020tresnet,
      title={TResNet: High Performance GPU-Dedicated Architecture}, 
      author={Tal Ridnik <span class="hljs-keyword">and </span>Hussam Lawen <span class="hljs-keyword">and </span>Asaf Noy <span class="hljs-keyword">and </span>Emanuel <span class="hljs-keyword">Ben </span><span class="hljs-keyword">Baruch </span><span class="hljs-keyword">and </span>Gilad <span class="hljs-keyword">Sharir </span><span class="hljs-keyword">and </span>Itamar Friedman},
      year={<span class="hljs-number">2020</span>},
      eprint={<span class="hljs-number">2003</span>.<span class="hljs-number">13630</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),v=new Wt({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/tresnet.mdx"}}),{c(){g=p("meta"),X=l(),V=p("p"),z=l(),m(J.$$.fragment),H=l(),y=p("p"),y.innerHTML=dt,S=l(),m(w.$$.fragment),A=l(),j=p("p"),j.textContent=gt,F=l(),m(T.$$.fragment),L=l(),u=p("p"),u.textContent=Jt,P=l(),m(f.$$.fragment),D=l(),b=p("p"),b.textContent=yt,q=l(),m(U.$$.fragment),K=l(),I=p("p"),I.textContent=wt,O=l(),m($.$$.fragment),tt=l(),Z=p("p"),Z.innerHTML=jt,st=l(),C=p("p"),C.innerHTML=Tt,et=l(),m(k.$$.fragment),at=l(),G=p("p"),G.textContent=ut,lt=l(),m(B.$$.fragment),nt=l(),N=p("p"),N.innerHTML=ft,pt=l(),m(W.$$.fragment),it=l(),x=p("p"),x.innerHTML=bt,mt=l(),m(E.$$.fragment),ot=l(),m(R.$$.fragment),rt=l(),m(v.$$.fragment),ct=l(),_=p("p"),this.h()},l(t){const s=Bt("svelte-u9bgzb",document.head);g=i(s,"META",{name:!0,content:!0}),s.forEach(e),X=n(t),V=i(t,"P",{}),Ut(V).forEach(e),z=n(t),o(J.$$.fragment,t),H=n(t),y=i(t,"P",{"data-svelte-h":!0}),d(y)!=="svelte-15ptpxo"&&(y.innerHTML=dt),S=n(t),o(w.$$.fragment,t),A=n(t),j=i(t,"P",{"data-svelte-h":!0}),d(j)!=="svelte-18ywhxh"&&(j.textContent=gt),F=n(t),o(T.$$.fragment,t),L=n(t),u=i(t,"P",{"data-svelte-h":!0}),d(u)!=="svelte-1c2ipa8"&&(u.textContent=Jt),P=n(t),o(f.$$.fragment,t),D=n(t),b=i(t,"P",{"data-svelte-h":!0}),d(b)!=="svelte-1n9qsq1"&&(b.textContent=yt),q=n(t),o(U.$$.fragment,t),K=n(t),I=i(t,"P",{"data-svelte-h":!0}),d(I)!=="svelte-19cnvx1"&&(I.textContent=wt),O=n(t),o($.$$.fragment,t),tt=n(t),Z=i(t,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-rdmov8"&&(Z.innerHTML=jt),st=n(t),C=i(t,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1wmi3ea"&&(C.innerHTML=Tt),et=n(t),o(k.$$.fragment,t),at=n(t),G=i(t,"P",{"data-svelte-h":!0}),d(G)!=="svelte-9sr7nh"&&(G.textContent=ut),lt=n(t),o(B.$$.fragment,t),nt=n(t),N=i(t,"P",{"data-svelte-h":!0}),d(N)!=="svelte-1kguc51"&&(N.innerHTML=ft),pt=n(t),o(W.$$.fragment,t),it=n(t),x=i(t,"P",{"data-svelte-h":!0}),d(x)!=="svelte-xtxxu6"&&(x.innerHTML=bt),mt=n(t),o(E.$$.fragment,t),ot=n(t),o(R.$$.fragment,t),rt=n(t),o(v.$$.fragment,t),ct=n(t),_=i(t,"P",{}),Ut(_).forEach(e),this.h()},h(){It(g,"name","hf:doc:metadata"),It(g,"content",Et)},m(t,s){Nt(document.head,g),a(t,X,s),a(t,V,s),a(t,z,s),r(J,t,s),a(t,H,s),a(t,y,s),a(t,S,s),r(w,t,s),a(t,A,s),a(t,j,s),a(t,F,s),r(T,t,s),a(t,L,s),a(t,u,s),a(t,P,s),r(f,t,s),a(t,D,s),a(t,b,s),a(t,q,s),r(U,t,s),a(t,K,s),a(t,I,s),a(t,O,s),r($,t,s),a(t,tt,s),a(t,Z,s),a(t,st,s),a(t,C,s),a(t,et,s),r(k,t,s),a(t,at,s),a(t,G,s),a(t,lt,s),r(B,t,s),a(t,nt,s),a(t,N,s),a(t,pt,s),r(W,t,s),a(t,it,s),a(t,x,s),a(t,mt,s),r(E,t,s),a(t,ot,s),r(R,t,s),a(t,rt,s),r(v,t,s),a(t,ct,s),a(t,_,s),ht=!0},p:Zt,i(t){ht||(c(J.$$.fragment,t),c(w.$$.fragment,t),c(T.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(k.$$.fragment,t),c(B.$$.fragment,t),c(W.$$.fragment,t),c(E.$$.fragment,t),c(R.$$.fragment,t),c(v.$$.fragment,t),ht=!0)},o(t){h(J.$$.fragment,t),h(w.$$.fragment,t),h(T.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(k.$$.fragment,t),h(B.$$.fragment,t),h(W.$$.fragment,t),h(E.$$.fragment,t),h(R.$$.fragment,t),h(v.$$.fragment,t),ht=!1},d(t){t&&(e(X),e(V),e(z),e(H),e(y),e(S),e(A),e(j),e(F),e(L),e(u),e(P),e(D),e(b),e(q),e(K),e(I),e(O),e(tt),e(Z),e(st),e(C),e(et),e(at),e(G),e(lt),e(nt),e(N),e(pt),e(it),e(x),e(mt),e(ot),e(rt),e(ct),e(_)),e(g),M(J,t),M(w,t),M(T,t),M(f,t),M(U,t),M($,t),M(k,t),M(B,t),M(W,t),M(E,t),M(R,t),M(v,t)}}}const Et='{"title":"TResNet","local":"tresnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Rt(Mt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Yt extends kt{constructor(g){super(),Gt(this,g,Rt,xt,$t,{})}}export{Yt as component};
