import{s as Is,n as Zs,o as $s}from"../chunks/scheduler.85c25b89.js";import{S as ks,i as Ws,g as p,s as a,r as i,A as Bs,h as m,f as l,c as n,j as fs,u as M,x as h,k as Cs,y as Ns,a as e,v as o,d as r,t as c,w as y}from"../chunks/index.c9837788.js";import{C as A}from"../chunks/CodeBlock.e573519b.js";import{H as Y,E as Gs}from"../chunks/getInferenceSnippets.b020ba4f.js";function xs(ys){let J,V,R,X,j,_,w,hs='<strong>MobileNetV2</strong> is a convolutional neural network architecture that seeks to perform well on mobile devices. It is based on an <a href="https://paperswithcode.com/method/inverted-residual-block" rel="nofollow">inverted residual structure</a> where the residual connections are between the bottleneck layers.  The intermediate expansion layer uses lightweight depthwise convolutions to filter features as a source of non-linearity. As a whole, the architecture of MobileNetV2 contains the initial fully convolution layer with 32 filters, followed by 19 residual bottleneck layers.',z,d,H,T,Js="To load a pretrained model:",F,g,D,U,js="To load and preprocess the image:",L,b,q,u,ws="To get the model predictions:",P,f,K,C,ds="To get the top-5 predictions class names:",O,I,ss,Z,Ts="Replace the model name with the variant you want to use, e.g. <code>mobilenetv2_100</code>. You can find the IDs in the model summaries at the top of this page.",ts,$,gs='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',ls,k,es,W,Us="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",as,B,ns,N,bs=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,ps,G,ms,x,us='You can follow the <a href="../training_script">timm recipe scripts</a> for training a new model afresh.',is,E,Ms,Q,os,v,rs,S,cs;return j=new Y({props:{title:"MobileNet v2",local:"mobilenet-v2",headingTag:"h1"}}),d=new Y({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),g=new A({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ21vYmlsZW5ldHYyXzEwMCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),b=new A({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),f=new A({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2guaW5mZXJlbmNlX21vZGUoKSUzQSUwQSUyMCUyMCUyMCUyMG91dCUyMCUzRCUyMG1vZGVsKHRlbnNvciklMEFwcm9iYWJpbGl0aWVzJTIwJTNEJTIwdG9yY2gubm4uZnVuY3Rpb25hbC5zb2Z0bWF4KG91dCU1QjAlNUQlMkMlMjBkaW0lM0QwKSUwQXByaW50KHByb2JhYmlsaXRpZXMuc2hhcGUpJTBBJTIzJTIwcHJpbnRzJTNBJTIwdG9yY2guU2l6ZSglNUIxMDAwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.inference_mode():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),I=new A({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),k=new Y({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),B=new A({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbW9iaWxlbmV0djJfMTAwJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;mobilenetv2_100&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),G=new Y({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new Y({props:{title:"Citation",local:"citation",headingTag:"h2"}}),Q=new A({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTgwMS0wNDM4MSUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3Qk1hcmslMjBTYW5kbGVyJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQW5kcmV3JTIwRy4lMjBIb3dhcmQlMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNZW5nbG9uZyUyMFpodSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFuZHJleSUyMFpobW9naW5vdiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExpYW5nJTdCLSU3RENoaWVoJTIwQ2hlbiU3RCUyQyUwQSUyMCUyMHRpdGxlJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCSW52ZXJ0ZWQlMjBSZXNpZHVhbHMlMjBhbmQlMjBMaW5lYXIlMjBCb3R0bGVuZWNrcyUzQSUyME1vYmlsZSUyME5ldHdvcmtzJTIwZm9yJTIwQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXRlY3Rpb24lMjBhbmQlMjBTZWdtZW50YXRpb24lN0QlMkMlMEElMjAlMjBqb3VybmFsJTIwJTIwJTIwJTNEJTIwJTdCQ29SUiU3RCUyQyUwQSUyMCUyMHZvbHVtZSUyMCUyMCUyMCUyMCUzRCUyMCU3QmFicyUyRjE4MDEuMDQzODElN0QlMkMlMEElMjAlMjB5ZWFyJTIwJTIwJTIwJTIwJTIwJTIwJTNEJTIwJTdCMjAxOCU3RCUyQyUwQSUyMCUyMHVybCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3Qmh0dHAlM0ElMkYlMkZhcnhpdi5vcmclMkZhYnMlMkYxODAxLjA0MzgxJTdEJTJDJTBBJTIwJTIwYXJjaGl2ZVByZWZpeCUyMCUzRCUyMCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwZXByaW50JTIwJTIwJTIwJTIwJTNEJTIwJTdCMTgwMS4wNDM4MSU3RCUyQyUwQSUyMCUyMHRpbWVzdGFtcCUyMCUzRCUyMCU3QlR1ZSUyQyUyMDEyJTIwSmFuJTIwMjAyMSUyMDE1JTNBMzAlM0EwNiUyMCUyQjAxMDAlN0QlMkMlMEElMjAlMjBiaWJ1cmwlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwcyUzQSUyRiUyRmRibHAub3JnJTJGcmVjJTJGam91cm5hbHMlMkZjb3JyJTJGYWJzLTE4MDEtMDQzODEuYmliJTdEJTJDJTBBJTIwJTIwYmlic291cmNlJTIwJTNEJTIwJTdCZGJscCUyMGNvbXB1dGVyJTIwc2NpZW5jZSUyMGJpYmxpb2dyYXBoeSUyQyUyMGh0dHBzJTNBJTJGJTJGZGJscC5vcmclN0QlMEElN0Q=",highlighted:`@article{DBLP:journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>,
  author    = {Mark Sandler and
               Andrew G. Howard and
               Menglong Zhu and
               Andrey Zhmoginov and
               Liang{-}Chieh Chen},
  title     = {Inverted Residuals and Linear Bottlenecks: Mobile Networks <span class="hljs-keyword">for</span> Classification,
               Detection and Segmentation},
  journal   = {CoRR},
  volume    = {abs/<span class="hljs-number">1801.04381</span>},
  year      = {<span class="hljs-number">2018</span>},
  url       = {http:<span class="hljs-regexp">//</span>arxiv.org<span class="hljs-regexp">/abs/</span><span class="hljs-number">1801.04381</span>},
  archivePrefix = {arXiv},
  eprint    = {<span class="hljs-number">1801.04381</span>},
  timestamp = {Tue, <span class="hljs-number">12</span> Jan <span class="hljs-number">2021</span> <span class="hljs-number">15</span>:<span class="hljs-number">30</span>:<span class="hljs-number">06</span> +<span class="hljs-number">0100</span>},
  biburl    = {https:<span class="hljs-regexp">//</span>dblp.org<span class="hljs-regexp">/rec/</span>journals<span class="hljs-regexp">/corr/</span>abs-<span class="hljs-number">1801</span>-<span class="hljs-number">04381</span>.bib},
  bibsource = {dblp computer science bibliography, https:<span class="hljs-regexp">//</span>dblp.org}
}`,wrap:!1}}),v=new Gs({props:{source:"https://github.com/huggingface/pytorch-image-models/blob/main/hfdocs/source/models/mobilenet-v2.mdx"}}),{c(){J=p("meta"),V=a(),R=p("p"),X=a(),i(j.$$.fragment),_=a(),w=p("p"),w.innerHTML=hs,z=a(),i(d.$$.fragment),H=a(),T=p("p"),T.textContent=Js,F=a(),i(g.$$.fragment),D=a(),U=p("p"),U.textContent=js,L=a(),i(b.$$.fragment),q=a(),u=p("p"),u.textContent=ws,P=a(),i(f.$$.fragment),K=a(),C=p("p"),C.textContent=ds,O=a(),i(I.$$.fragment),ss=a(),Z=p("p"),Z.innerHTML=Ts,ts=a(),$=p("p"),$.innerHTML=gs,ls=a(),i(k.$$.fragment),es=a(),W=p("p"),W.textContent=Us,as=a(),i(B.$$.fragment),ns=a(),N=p("p"),N.innerHTML=bs,ps=a(),i(G.$$.fragment),ms=a(),x=p("p"),x.innerHTML=us,is=a(),i(E.$$.fragment),Ms=a(),i(Q.$$.fragment),os=a(),i(v.$$.fragment),rs=a(),S=p("p"),this.h()},l(s){const t=Bs("svelte-u9bgzb",document.head);J=m(t,"META",{name:!0,content:!0}),t.forEach(l),V=n(s),R=m(s,"P",{}),fs(R).forEach(l),X=n(s),M(j.$$.fragment,s),_=n(s),w=m(s,"P",{"data-svelte-h":!0}),h(w)!=="svelte-fgcsw6"&&(w.innerHTML=hs),z=n(s),M(d.$$.fragment,s),H=n(s),T=m(s,"P",{"data-svelte-h":!0}),h(T)!=="svelte-18ywhxh"&&(T.textContent=Js),F=n(s),M(g.$$.fragment,s),D=n(s),U=m(s,"P",{"data-svelte-h":!0}),h(U)!=="svelte-1c2ipa8"&&(U.textContent=js),L=n(s),M(b.$$.fragment,s),q=n(s),u=m(s,"P",{"data-svelte-h":!0}),h(u)!=="svelte-1n9qsq1"&&(u.textContent=ws),P=n(s),M(f.$$.fragment,s),K=n(s),C=m(s,"P",{"data-svelte-h":!0}),h(C)!=="svelte-19cnvx1"&&(C.textContent=ds),O=n(s),M(I.$$.fragment,s),ss=n(s),Z=m(s,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-11s0yt3"&&(Z.innerHTML=Ts),ts=n(s),$=m(s,"P",{"data-svelte-h":!0}),h($)!=="svelte-1wmi3ea"&&($.innerHTML=gs),ls=n(s),M(k.$$.fragment,s),es=n(s),W=m(s,"P",{"data-svelte-h":!0}),h(W)!=="svelte-9sr7nh"&&(W.textContent=Us),as=n(s),M(B.$$.fragment,s),ns=n(s),N=m(s,"P",{"data-svelte-h":!0}),h(N)!=="svelte-1kguc51"&&(N.innerHTML=bs),ps=n(s),M(G.$$.fragment,s),ms=n(s),x=m(s,"P",{"data-svelte-h":!0}),h(x)!=="svelte-xtxxu6"&&(x.innerHTML=us),is=n(s),M(E.$$.fragment,s),Ms=n(s),M(Q.$$.fragment,s),os=n(s),M(v.$$.fragment,s),rs=n(s),S=m(s,"P",{}),fs(S).forEach(l),this.h()},h(){Cs(J,"name","hf:doc:metadata"),Cs(J,"content",Es)},m(s,t){Ns(document.head,J),e(s,V,t),e(s,R,t),e(s,X,t),o(j,s,t),e(s,_,t),e(s,w,t),e(s,z,t),o(d,s,t),e(s,H,t),e(s,T,t),e(s,F,t),o(g,s,t),e(s,D,t),e(s,U,t),e(s,L,t),o(b,s,t),e(s,q,t),e(s,u,t),e(s,P,t),o(f,s,t),e(s,K,t),e(s,C,t),e(s,O,t),o(I,s,t),e(s,ss,t),e(s,Z,t),e(s,ts,t),e(s,$,t),e(s,ls,t),o(k,s,t),e(s,es,t),e(s,W,t),e(s,as,t),o(B,s,t),e(s,ns,t),e(s,N,t),e(s,ps,t),o(G,s,t),e(s,ms,t),e(s,x,t),e(s,is,t),o(E,s,t),e(s,Ms,t),o(Q,s,t),e(s,os,t),o(v,s,t),e(s,rs,t),e(s,S,t),cs=!0},p:Zs,i(s){cs||(r(j.$$.fragment,s),r(d.$$.fragment,s),r(g.$$.fragment,s),r(b.$$.fragment,s),r(f.$$.fragment,s),r(I.$$.fragment,s),r(k.$$.fragment,s),r(B.$$.fragment,s),r(G.$$.fragment,s),r(E.$$.fragment,s),r(Q.$$.fragment,s),r(v.$$.fragment,s),cs=!0)},o(s){c(j.$$.fragment,s),c(d.$$.fragment,s),c(g.$$.fragment,s),c(b.$$.fragment,s),c(f.$$.fragment,s),c(I.$$.fragment,s),c(k.$$.fragment,s),c(B.$$.fragment,s),c(G.$$.fragment,s),c(E.$$.fragment,s),c(Q.$$.fragment,s),c(v.$$.fragment,s),cs=!1},d(s){s&&(l(V),l(R),l(X),l(_),l(w),l(z),l(H),l(T),l(F),l(D),l(U),l(L),l(q),l(u),l(P),l(K),l(C),l(O),l(ss),l(Z),l(ts),l($),l(ls),l(es),l(W),l(as),l(ns),l(N),l(ps),l(ms),l(x),l(is),l(Ms),l(os),l(rs),l(S)),l(J),y(j,s),y(d,s),y(g,s),y(b,s),y(f,s),y(I,s),y(k,s),y(B,s),y(G,s),y(E,s),y(Q,s),y(v,s)}}}const Es='{"title":"MobileNet v2","local":"mobilenet-v2","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Qs(ys){return $s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends ks{constructor(J){super(),Ws(this,J,Qs,xs,Is,{})}}export{Ys as component};
