import{s as ws,o as Us,n as us}from"../chunks/scheduler.37c15a92.js";import{S as Ts,i as hs,g as m,s as a,r as p,A as fs,h as o,f as s,c as n,j as ds,u as M,x as d,k as js,y as Cs,a as t,v as i,d as c,t as r,w as y,m as Zs,n as Bs}from"../chunks/index.2bf4358c.js";import{T as Js}from"../chunks/Tip.363c041f.js";import{Y as bs}from"../chunks/Youtube.1e50a667.js";import{C as j}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as Is}from"../chunks/CourseFloatingBanner.06521e8b.js";import{H as $l}from"../chunks/Heading.8ada512a.js";function Gs(Bl){let J,b="✏️ <strong>Попробуйте!</strong> Измените обучающий цикл так, чтобы дообучить модель на датасете SST-2.";return{c(){J=m("p"),J.innerHTML=b},l(w){J=o(w,"P",{"data-svelte-h":!0}),d(J)!=="svelte-d7z733"&&(J.innerHTML=b)},m(w,Il){t(w,J,Il)},p:us,d(w){w&&s(J)}}}function $s(Bl){let J;return{c(){J=Zs('⚠️ Чтобы воспользоваться ускорением, предлагаемым облачными TPU, мы рекомендуем дополнять данные до фиксированной длины с помощью аргументов `padding="max_length"` и `max_length` токенизатора.')},l(b){J=Bs(b,'⚠️ Чтобы воспользоваться ускорением, предлагаемым облачными TPU, мы рекомендуем дополнять данные до фиксированной длины с помощью аргументов `padding="max_length"` и `max_length` токенизатора.')},m(b,w){t(b,J,w)},d(b){b&&s(J)}}}function Xs(Bl){let J,b,w,Il,T,Xl,h,kl,f,Wl,C,Ve="Теперь мы посмотрим, как достичь результатов из предыдущей главы без использования класса <code>Trainer</code>. В этой главе мы предполагаем, что вы выполнили этапы препроцессинга раздела 2. Ниже короткая выжимка того, что вам понадобится:",Rl,Z,_l,B,gl,I,Ae="Перед реализацией цикла обучения необходимо задать несколько объектов. Первый: загрузчики данных (далее - dataloaders), которые мы будем использовать для итерирования по батчам данных. Перед этим нам необходимо применить несколько операций постпроцессинга к нашему <code>tokenized_datasets</code>. Это нужно сделать: в прошлый раз за нас это автоматически делал <code>Trainer</code>. Необходимо сделать следующее:",vl,G,Ne="<li>Удалить колонки, соответствующие значениям, которые модель не принимает на вход (например, <code>sentence1</code> и <code>sentence2</code>).</li> <li>Переименовать колонку <code>label</code> в <code>labels</code> (потому что модель ожидает аргумент, названный <code>labels</code>).</li> <li>Задать тип данных в датасете pytorch tensors вместо списков.</li>",Yl,$,ze="Наш <code>tokenized_datasets</code> предоставляет возможность использовать встроенные методы для каждого из приведенных выше шагов:",Vl,X,Al,k,Ee="Мы можем проверить, что в результате у нас присутствуют только те поля, которые ожидает наша модель:",Nl,W,zl,R,Qe="Теперь, когда датасет готов, мы может задать dataloader:",El,_,Ql,g,Fe="Для того, чтобы убедиться в отсутствии ошибок в сделанном нами препроцессинге, мы можем проверить один батч данных:",Fl,v,xl,Y,Hl,V,xe="Обратите внимание, что фактические размеры, вероятно, будут немного отличаться для в вашем случае, так как мы установили <code>shuffle=True</code> для обучающего загрузчика данных, также мы дополняем (padding) до максимальной длины внутри батча.",Sl,A,He="Теперь мы полностью завершили этап препроцессинга (приятный, но неуловимый момент для любого специалиста по машинному обучению), перейдем к модели. Мы инициализируем ее точно так, как делали в предыдущем примере:",ql,N,Kl,z,Se="Чтобы убедиться, что обучение пойдет гладко, вы подадим на вход модели один батч:",Ll,E,Dl,Q,Pl,F,qe="Все модели 🤗 трансформеров возвращают значение функции потерь, если в данных были <code>labels</code>, а также логиты (в результате получается тензор 8 х 2).",Ol,x,Ke='Мы почти готовы к написанию обучающего цикла! Мы пропустили только две вещи: оптимизатор и планировщик скорости обучения (learning rate scheduler). Ввиду того, что мы пытаемся повторить вручную то, что делал за нас <code>Trainer</code>, мы будем использовать такие же значения по умолчанию. Оптимизатор, используемый в <code>Trainer</code> - <code>AdamW</code>, который является почти полной копией Adam, за исключением трюка с сокращением весов (далее - weight decay) (см. <a href="https://arxiv.org/abs/1711.05101" rel="nofollow">“Decoupled Weight Decay Regularization”</a> за авторством Ilya Loshchilov и Frank Hutter).',le,H,ee,S,Le="Наконец, планировщик скорости обучения по умолчанию - просто линейное уменьшение весов с максимального значения (5e-5) до 0. Чтобы корректно задать его, нам нужно знать число шагов в обучении, которое задается как произведение числа эпох и числа батчей (длины нашего загрузчика данных). Число эпох по умолчанию в <code>Trainer</code> равно 3, так же мы зададим его и сейчас:",se,q,te,K,ae,L,ne,D,De="Последний момент: мы хотим использовать GPU в случае, если у нас будет такая возможность (на CPU процесс может занять несколько часов вместо пары минут). Чтобы добиться этого, мы определим переменную <code>device</code> и «прикрепим» к видеокарте нашу модель и данные:",pe,P,Me,O,ie,ll,Pe="Теперь мы готовы к обучению модели! Чтобы иметь представление о том, сколько времени это может занять, мы добавим прогресс-бар, который будет иллюстрировать, сколько шагов обучения уже выполнено. Это можно сделать с использованием бибилиотеки tqdm:",ce,el,re,sl,Oe="Вы можете заметить, что процесс обучения выглядит очень похожим на то, как он выглядел в наших первых примерах. Мы не указывали модели, чтобы она нам что-то возвращала в процессе обучения. Для этого мы добавим цикл валидации.",ye,tl,me,al,ls="Ранее мы использовали метрику, которую нам предоставляла библиотека 🤗 Evaluate. Мы уже знаем, что есть метод <code>metric.compute()</code>, однако метрики могут накапливать значения в процессе итерирования по батчу, для этого есть метод <code>add_batch()</code>. После того, как мы пройдемся по всем батчам, мы сможем вычислить финальный результат с помощью <code>metric.compute()</code>. Вот пример того, как это можно сделать в цикле валидации:",oe,nl,de,pl,je,Ml,es="Повторим: результаты, которые получите вы, могут немного отличаться из-за наличия случайностей при инициализации параметров слоя модели и из-за случайного перемешивания датасета, однако их порядок должен совпадать.",Je,U,be,il,we,cl,Ue,rl,ss='Обучающий цикл, заданный выше, отлично работает на одном GPU или CPU. Однако использование библиотеки <a href="https://github.com/huggingface/accelerate" rel="nofollow">🤗 Accelerate</a> позволяет с небольшими изменениями сделать эту процедуру распределенной на несколько GPU или TPU. Начииная с момента создания обучающих и валидационных загрузчиков данных, наш «ручной» обучающий цикл выглядит так:',ue,yl,Te,ml,ts="А вот изменения, которые нужно внести, чтобы ускорить процесс:",he,ol,fe,dl,as=`Первая строка – это строка импорта библиотеки. Вторая строка инициализирует объект <code>Accelerator</code>, который проанализирует окружение и определит необходимые настройки. 🤗 Accelerate автоматически использует доступное оборудование, поэтому вы можете удалить строки, которые «прикрепляют»
модель и данные к видеокарте (или, если вам так удобнее, можете изменить их на <code>accelerator.device</code> вместо просто <code>device</code>).`,Ce,jl,ns="Далее главная часть работы выполняется в строке, которая отправляет данные, модель и оптимизатор на <code>accelerator.prepare()</code>. Этот метод «обернет» ваши объекты в контейнер и убедится, что распределенное обучение выполняется корректно. Оставшиеся изменения – удаление строки, которая отправляет батч на <code>device</code> (повторим: если вы хотите оставить эту строку, замените <code>device</code> на <code>accelerator.device</code>) и замените <code>loss.backward()</code> на <code>accelerator.backward(loss)</code>.",Ze,u,Be,Jl,ps="Если вы хотите скопировать и запустить этот код, это полная версия с использованием 🤗 Accelerate:",Ie,bl,Ge,wl,Ms="Добавление этого в скрипт <code>train.py</code> сделает процесс обучения универсальным для любой распределенной системы. Попробуйте запустить его на вашей распределенной системе:",$e,Ul,Xe,ul,is="эта строка предложит вам ответить на несколько вопросов и сохранит ваши ответы в конфигурационный файл, который будет использоваться при вызове команды:",ke,Tl,We,hl,cs="запускающей распределенное обучение.",Re,fl,rs="Если вы хотите попробовать запустить этот код в Jupyter Notebook (например, протестировать его с TPU на Google Colab), просто вставьте код в <code>training_function()</code> и запустите последнюю ячейку:",_e,Cl,ge,Zl,ys='Вы можете найти больше примеров в репозитории <a href="https://github.com/huggingface/accelerate/tree/main/examples" rel="nofollow">🤗 Accelerate repo</a>.',ve,Gl,Ye;return T=new $l({props:{title:"Полное обучение",local:"полное-обучение",headingTag:"h1"}}),h=new Is({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/ru/chapter3/section4.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/ru/chapter3/section4.ipynb"}]}}),f=new bs({props:{id:"Dh9CL8fyG80"}}),Z=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),B=new $l({props:{title:"Подготовка к обучению",local:"подготовка-к-обучению",headingTag:"h3"}}),X=new j({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnNlbnRlbmNlMSUyMiUyQyUyMCUyMnNlbnRlbmNlMiUyMiUyQyUyMCUyMmlkeCUyMiU1RCklMEF0b2tlbml6ZWRfZGF0YXNldHMlMjAlM0QlMjB0b2tlbml6ZWRfZGF0YXNldHMucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMuc2V0X2Zvcm1hdCglMjJ0b3JjaCUyMiklMEF0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ0cmFpbiUyMiU1RC5jb2x1bW5fbmFtZXM=",highlighted:`tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;sentence1&quot;</span>, <span class="hljs-string">&quot;sentence2&quot;</span>, <span class="hljs-string">&quot;idx&quot;</span>])
tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)
tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].column_names`,wrap:!1}}),W=new j({props:{code:"JTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJsYWJlbHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RA==",highlighted:'[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>]',wrap:!1}}),_=new j({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUyMGJhdGNoX3NpemUlM0Q4JTJDJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMEEpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlciglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUwQSk=",highlighted:`<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

train_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>], shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)
eval_dataloader = DataLoader(
    tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>], batch_size=<span class="hljs-number">8</span>, collate_fn=data_collator
)`,wrap:!1}}),v=new j({props:{code:"Zm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBicmVhayUwQSU3QmslM0ElMjB2LnNoYXBlJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-keyword">break</span>
{k: v.shape <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}`,wrap:!1}}),Y=new j({props:{code:"JTdCJ2F0dGVudGlvbl9tYXNrJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSUyQyUwQSUyMCdpbnB1dF9pZHMnJTNBJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwNjUlNUQpJTJDJTBBJTIwJ2xhYmVscyclM0ElMjB0b3JjaC5TaXplKCU1QjglNUQpJTJDJTBBJTIwJ3Rva2VuX3R5cGVfaWRzJyUzQSUyMHRvcmNoLlNpemUoJTVCOCUyQyUyMDY1JTVEKSU3RA==",highlighted:`{<span class="hljs-string">&#x27;attention_mask&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;input_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>]),
 <span class="hljs-string">&#x27;labels&#x27;</span>: torch.Size([<span class="hljs-number">8</span>]),
 <span class="hljs-string">&#x27;token_type_ids&#x27;</span>: torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">65</span>])}`,wrap:!1}}),N=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),E=new j({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBcHJpbnQob3V0cHV0cy5sb3NzJTJDJTIwb3V0cHV0cy5sb2dpdHMuc2hhcGUp",highlighted:`outputs = model(**batch)
<span class="hljs-built_in">print</span>(outputs.loss, outputs.logits.shape)`,wrap:!1}}),Q=new j({props:{code:"dGVuc29yKDAuNTQ0MSUyQyUyMGdyYWRfZm4lM0QlM0NObGxMb3NzQmFja3dhcmQlM0UpJTIwdG9yY2guU2l6ZSglNUI4JTJDJTIwMiU1RCk=",highlighted:'tensor(<span class="hljs-number">0.5441</span>, grad_fn=&lt;NllLossBackward&gt;) torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">2</span>])',wrap:!1}}),H=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTBBJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0Q1ZS01KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW

optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),q=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjJsaW5lYXIlMjIlMkMlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMEElMjAlMjAlMjAlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRG51bV90cmFpbmluZ19zdGVwcyUyQyUwQSklMEFwcmludChudW1fdHJhaW5pbmdfc3RlcHMp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)
<span class="hljs-built_in">print</span>(num_training_steps)`,wrap:!1}}),K=new j({props:{code:"MTM3Nw==",highlighted:'<span class="hljs-number">1377</span>',wrap:!1}}),L=new $l({props:{title:"Обучающий цикл",local:"обучающий-цикл",headingTag:"h3"}}),P=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2UpJTBBZGV2aWNl",highlighted:`<span class="hljs-keyword">import</span> torch

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)
device`,wrap:!1}}),O=new j({props:{code:"ZGV2aWNlKHR5cGUlM0QnY3VkYScp",highlighted:'device(<span class="hljs-built_in">type</span>=<span class="hljs-string">&#x27;cuda&#x27;</span>)',wrap:!1}}),el=new j({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),tl=new $l({props:{title:"Валидационный цикл",local:"валидационный-цикл",headingTag:"h3"}}),nl=new j({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1vZGVsLmV2YWwoKSUwQWZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwdG9yY2guYXJnbWF4KGxvZ2l0cyUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMCUyMCUyMG1ldHJpYy5hZGRfYmF0Y2gocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RiYXRjaCU1QiUyMmxhYmVscyUyMiU1RCklMEElMEFtZXRyaWMuY29tcHV0ZSgp",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(**batch)

    logits = outputs.logits
    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

metric.compute()`,wrap:!1}}),pl=new j({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODQzMTM3MjU0OTAxOTYwOCUyQyUyMCdmMSclM0ElMjAwLjg5MDc4NDk4MjkzNTE1MzUlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8431372549019608</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8907849829351535</span>}',wrap:!1}}),U=new Js({props:{$$slots:{default:[Gs]},$$scope:{ctx:Bl}}}),il=new $l({props:{title:"Ускорение обучающего цикла с помощью 🤗 Accelerate",local:"ускорение-обучающего-цикла-с-помощью--accelerate",headingTag:"h3"}}),cl=new bs({props:{id:"s7dy8QRgjJ0"}}),yl=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEFkYW1XJTJDJTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMGdldF9zY2hlZHVsZXIlMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTUpJTBBJTBBZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIpJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMHRvcmNoLmRldmljZSglMjJjcHUlMjIpJTBBbW9kZWwudG8oZGV2aWNlKSUwQSUwQW51bV9lcG9jaHMlMjAlM0QlMjAzJTBBbnVtX3RyYWluaW5nX3N0ZXBzJTIwJTNEJTIwbnVtX2Vwb2NocyUyMColMjBsZW4odHJhaW5fZGF0YWxvYWRlciklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwYmF0Y2guaXRlbXMoKSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzLmJhY2t3YXJkKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByb2dyZXNzX2Jhci51cGRhdGUoMSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
model.to(device)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
        outputs = model(**batch)
        loss = outputs.loss
        loss.backward()

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),ol=new j({props:{code:"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",highlighted:`<span class="hljs-addition">+ from accelerate import Accelerator</span>
  from transformers import AdamW, AutoModelForSequenceClassification, get_scheduler

<span class="hljs-addition">+ accelerator = Accelerator()</span>

  model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=2)
  optimizer = AdamW(model.parameters(), lr=3e-5)

<span class="hljs-deletion">- device = torch.device(&quot;cuda&quot;) if torch.cuda.is_available() else torch.device(&quot;cpu&quot;)</span>
<span class="hljs-deletion">- model.to(device)</span>

<span class="hljs-addition">+ train_dataloader, eval_dataloader, model, optimizer = accelerator.prepare(</span>
<span class="hljs-addition">+     train_dataloader, eval_dataloader, model, optimizer</span>
<span class="hljs-addition">+ )</span>

  num_epochs = 3
  num_training_steps = num_epochs * len(train_dataloader)
  lr_scheduler = get_scheduler(
      &quot;linear&quot;,
      optimizer=optimizer,
      num_warmup_steps=0,
      num_training_steps=num_training_steps
  )

  progress_bar = tqdm(range(num_training_steps))

  model.train()
  for epoch in range(num_epochs):
      for batch in train_dataloader:
<span class="hljs-deletion">-         batch = {k: v.to(device) for k, v in batch.items()}</span>
          outputs = model(**batch)
          loss = outputs.loss
<span class="hljs-deletion">-         loss.backward()</span>
<span class="hljs-addition">+         accelerator.backward(loss)</span>

          optimizer.step()
          lr_scheduler.step()
          optimizer.zero_grad()
          progress_bar.update(1)`,wrap:!1}}),u=new Js({props:{$$slots:{default:[$s]},$$scope:{ctx:Bl}}}),bl=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBZGFtVyUyQyUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBnZXRfc2NoZWR1bGVyJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRDIpJTBBb3B0aW1pemVyJTIwJTNEJTIwQWRhbVcobW9kZWwucGFyYW1ldGVycygpJTJDJTIwbHIlM0QzZS01KSUwQSUwQXRyYWluX2RsJTJDJTIwZXZhbF9kbCUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMEEpJTBBJTBBbnVtX2Vwb2NocyUyMCUzRCUyMDMlMEFudW1fdHJhaW5pbmdfc3RlcHMlMjAlM0QlMjBudW1fZXBvY2hzJTIwKiUyMGxlbih0cmFpbl9kbCklMEFscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMmxpbmVhciUyMiUyQyUwQSUyMCUyMCUyMCUyMG9wdGltaXplciUzRG9wdGltaXplciUyQyUwQSUyMCUyMCUyMCUyMG51bV93YXJtdXBfc3RlcHMlM0QwJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluaW5nX3N0ZXBzJTNEbnVtX3RyYWluaW5nX3N0ZXBzJTJDJTBBKSUwQSUwQXByb2dyZXNzX2JhciUyMCUzRCUyMHRxZG0ocmFuZ2UobnVtX3RyYWluaW5nX3N0ZXBzKSklMEElMEFtb2RlbC50cmFpbigpJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RsJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AdamW, AutoModelForSequenceClassification, get_scheduler

accelerator = Accelerator()

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)
optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">3e-5</span>)

train_dl, eval_dl, model, optimizer = accelerator.prepare(
    train_dataloader, eval_dataloader, model, optimizer
)

num_epochs = <span class="hljs-number">3</span>
num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dl)
lr_scheduler = get_scheduler(
    <span class="hljs-string">&quot;linear&quot;</span>,
    optimizer=optimizer,
    num_warmup_steps=<span class="hljs-number">0</span>,
    num_training_steps=num_training_steps,
)

progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

model.train()
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dl:
        outputs = model(**batch)
        loss = outputs.loss
        accelerator.backward(loss)

        optimizer.step()
        lr_scheduler.step()
        optimizer.zero_grad()
        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ul=new j({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),Tl=new j({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluLnB5",highlighted:'accelerate <span class="hljs-built_in">launch</span> train.py',wrap:!1}}),Cl=new j({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlciUwQSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2Z1bmN0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher

notebook_launcher(training_function)`,wrap:!1}}),{c(){J=m("meta"),b=a(),w=m("p"),Il=a(),p(T.$$.fragment),Xl=a(),p(h.$$.fragment),kl=a(),p(f.$$.fragment),Wl=a(),C=m("p"),C.innerHTML=Ve,Rl=a(),p(Z.$$.fragment),_l=a(),p(B.$$.fragment),gl=a(),I=m("p"),I.innerHTML=Ae,vl=a(),G=m("ul"),G.innerHTML=Ne,Yl=a(),$=m("p"),$.innerHTML=ze,Vl=a(),p(X.$$.fragment),Al=a(),k=m("p"),k.textContent=Ee,Nl=a(),p(W.$$.fragment),zl=a(),R=m("p"),R.textContent=Qe,El=a(),p(_.$$.fragment),Ql=a(),g=m("p"),g.textContent=Fe,Fl=a(),p(v.$$.fragment),xl=a(),p(Y.$$.fragment),Hl=a(),V=m("p"),V.innerHTML=xe,Sl=a(),A=m("p"),A.textContent=He,ql=a(),p(N.$$.fragment),Kl=a(),z=m("p"),z.textContent=Se,Ll=a(),p(E.$$.fragment),Dl=a(),p(Q.$$.fragment),Pl=a(),F=m("p"),F.innerHTML=qe,Ol=a(),x=m("p"),x.innerHTML=Ke,le=a(),p(H.$$.fragment),ee=a(),S=m("p"),S.innerHTML=Le,se=a(),p(q.$$.fragment),te=a(),p(K.$$.fragment),ae=a(),p(L.$$.fragment),ne=a(),D=m("p"),D.innerHTML=De,pe=a(),p(P.$$.fragment),Me=a(),p(O.$$.fragment),ie=a(),ll=m("p"),ll.textContent=Pe,ce=a(),p(el.$$.fragment),re=a(),sl=m("p"),sl.textContent=Oe,ye=a(),p(tl.$$.fragment),me=a(),al=m("p"),al.innerHTML=ls,oe=a(),p(nl.$$.fragment),de=a(),p(pl.$$.fragment),je=a(),Ml=m("p"),Ml.textContent=es,Je=a(),p(U.$$.fragment),be=a(),p(il.$$.fragment),we=a(),p(cl.$$.fragment),Ue=a(),rl=m("p"),rl.innerHTML=ss,ue=a(),p(yl.$$.fragment),Te=a(),ml=m("p"),ml.textContent=ts,he=a(),p(ol.$$.fragment),fe=a(),dl=m("p"),dl.innerHTML=as,Ce=a(),jl=m("p"),jl.innerHTML=ns,Ze=a(),p(u.$$.fragment),Be=a(),Jl=m("p"),Jl.textContent=ps,Ie=a(),p(bl.$$.fragment),Ge=a(),wl=m("p"),wl.innerHTML=Ms,$e=a(),p(Ul.$$.fragment),Xe=a(),ul=m("p"),ul.textContent=is,ke=a(),p(Tl.$$.fragment),We=a(),hl=m("p"),hl.textContent=cs,Re=a(),fl=m("p"),fl.innerHTML=rs,_e=a(),p(Cl.$$.fragment),ge=a(),Zl=m("p"),Zl.innerHTML=ys,ve=a(),Gl=m("p"),this.h()},l(l){const e=fs("svelte-u9bgzb",document.head);J=o(e,"META",{name:!0,content:!0}),e.forEach(s),b=n(l),w=o(l,"P",{}),ds(w).forEach(s),Il=n(l),M(T.$$.fragment,l),Xl=n(l),M(h.$$.fragment,l),kl=n(l),M(f.$$.fragment,l),Wl=n(l),C=o(l,"P",{"data-svelte-h":!0}),d(C)!=="svelte-1gqkgs3"&&(C.innerHTML=Ve),Rl=n(l),M(Z.$$.fragment,l),_l=n(l),M(B.$$.fragment,l),gl=n(l),I=o(l,"P",{"data-svelte-h":!0}),d(I)!=="svelte-1lnwdm2"&&(I.innerHTML=Ae),vl=n(l),G=o(l,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-14inct8"&&(G.innerHTML=Ne),Yl=n(l),$=o(l,"P",{"data-svelte-h":!0}),d($)!=="svelte-y39maw"&&($.innerHTML=ze),Vl=n(l),M(X.$$.fragment,l),Al=n(l),k=o(l,"P",{"data-svelte-h":!0}),d(k)!=="svelte-hls58n"&&(k.textContent=Ee),Nl=n(l),M(W.$$.fragment,l),zl=n(l),R=o(l,"P",{"data-svelte-h":!0}),d(R)!=="svelte-uu69p5"&&(R.textContent=Qe),El=n(l),M(_.$$.fragment,l),Ql=n(l),g=o(l,"P",{"data-svelte-h":!0}),d(g)!=="svelte-n94e97"&&(g.textContent=Fe),Fl=n(l),M(v.$$.fragment,l),xl=n(l),M(Y.$$.fragment,l),Hl=n(l),V=o(l,"P",{"data-svelte-h":!0}),d(V)!=="svelte-150flrw"&&(V.innerHTML=xe),Sl=n(l),A=o(l,"P",{"data-svelte-h":!0}),d(A)!=="svelte-ifw55c"&&(A.textContent=He),ql=n(l),M(N.$$.fragment,l),Kl=n(l),z=o(l,"P",{"data-svelte-h":!0}),d(z)!=="svelte-qqb2jh"&&(z.textContent=Se),Ll=n(l),M(E.$$.fragment,l),Dl=n(l),M(Q.$$.fragment,l),Pl=n(l),F=o(l,"P",{"data-svelte-h":!0}),d(F)!=="svelte-t1wazz"&&(F.innerHTML=qe),Ol=n(l),x=o(l,"P",{"data-svelte-h":!0}),d(x)!=="svelte-1e2owli"&&(x.innerHTML=Ke),le=n(l),M(H.$$.fragment,l),ee=n(l),S=o(l,"P",{"data-svelte-h":!0}),d(S)!=="svelte-ld980v"&&(S.innerHTML=Le),se=n(l),M(q.$$.fragment,l),te=n(l),M(K.$$.fragment,l),ae=n(l),M(L.$$.fragment,l),ne=n(l),D=o(l,"P",{"data-svelte-h":!0}),d(D)!=="svelte-ix7lr0"&&(D.innerHTML=De),pe=n(l),M(P.$$.fragment,l),Me=n(l),M(O.$$.fragment,l),ie=n(l),ll=o(l,"P",{"data-svelte-h":!0}),d(ll)!=="svelte-1tuyhjz"&&(ll.textContent=Pe),ce=n(l),M(el.$$.fragment,l),re=n(l),sl=o(l,"P",{"data-svelte-h":!0}),d(sl)!=="svelte-1qxv8sc"&&(sl.textContent=Oe),ye=n(l),M(tl.$$.fragment,l),me=n(l),al=o(l,"P",{"data-svelte-h":!0}),d(al)!=="svelte-d4v9zb"&&(al.innerHTML=ls),oe=n(l),M(nl.$$.fragment,l),de=n(l),M(pl.$$.fragment,l),je=n(l),Ml=o(l,"P",{"data-svelte-h":!0}),d(Ml)!=="svelte-1qo2vh4"&&(Ml.textContent=es),Je=n(l),M(U.$$.fragment,l),be=n(l),M(il.$$.fragment,l),we=n(l),M(cl.$$.fragment,l),Ue=n(l),rl=o(l,"P",{"data-svelte-h":!0}),d(rl)!=="svelte-1j8jc63"&&(rl.innerHTML=ss),ue=n(l),M(yl.$$.fragment,l),Te=n(l),ml=o(l,"P",{"data-svelte-h":!0}),d(ml)!=="svelte-1y3rvvh"&&(ml.textContent=ts),he=n(l),M(ol.$$.fragment,l),fe=n(l),dl=o(l,"P",{"data-svelte-h":!0}),d(dl)!=="svelte-1k0j8ce"&&(dl.innerHTML=as),Ce=n(l),jl=o(l,"P",{"data-svelte-h":!0}),d(jl)!=="svelte-zyjzzn"&&(jl.innerHTML=ns),Ze=n(l),M(u.$$.fragment,l),Be=n(l),Jl=o(l,"P",{"data-svelte-h":!0}),d(Jl)!=="svelte-1kvq74c"&&(Jl.textContent=ps),Ie=n(l),M(bl.$$.fragment,l),Ge=n(l),wl=o(l,"P",{"data-svelte-h":!0}),d(wl)!=="svelte-1gamoio"&&(wl.innerHTML=Ms),$e=n(l),M(Ul.$$.fragment,l),Xe=n(l),ul=o(l,"P",{"data-svelte-h":!0}),d(ul)!=="svelte-180xe86"&&(ul.textContent=is),ke=n(l),M(Tl.$$.fragment,l),We=n(l),hl=o(l,"P",{"data-svelte-h":!0}),d(hl)!=="svelte-1hjs7v4"&&(hl.textContent=cs),Re=n(l),fl=o(l,"P",{"data-svelte-h":!0}),d(fl)!=="svelte-167w75a"&&(fl.innerHTML=rs),_e=n(l),M(Cl.$$.fragment,l),ge=n(l),Zl=o(l,"P",{"data-svelte-h":!0}),d(Zl)!=="svelte-1wlody3"&&(Zl.innerHTML=ys),ve=n(l),Gl=o(l,"P",{}),ds(Gl).forEach(s),this.h()},h(){js(J,"name","hf:doc:metadata"),js(J,"content",ks)},m(l,e){Cs(document.head,J),t(l,b,e),t(l,w,e),t(l,Il,e),i(T,l,e),t(l,Xl,e),i(h,l,e),t(l,kl,e),i(f,l,e),t(l,Wl,e),t(l,C,e),t(l,Rl,e),i(Z,l,e),t(l,_l,e),i(B,l,e),t(l,gl,e),t(l,I,e),t(l,vl,e),t(l,G,e),t(l,Yl,e),t(l,$,e),t(l,Vl,e),i(X,l,e),t(l,Al,e),t(l,k,e),t(l,Nl,e),i(W,l,e),t(l,zl,e),t(l,R,e),t(l,El,e),i(_,l,e),t(l,Ql,e),t(l,g,e),t(l,Fl,e),i(v,l,e),t(l,xl,e),i(Y,l,e),t(l,Hl,e),t(l,V,e),t(l,Sl,e),t(l,A,e),t(l,ql,e),i(N,l,e),t(l,Kl,e),t(l,z,e),t(l,Ll,e),i(E,l,e),t(l,Dl,e),i(Q,l,e),t(l,Pl,e),t(l,F,e),t(l,Ol,e),t(l,x,e),t(l,le,e),i(H,l,e),t(l,ee,e),t(l,S,e),t(l,se,e),i(q,l,e),t(l,te,e),i(K,l,e),t(l,ae,e),i(L,l,e),t(l,ne,e),t(l,D,e),t(l,pe,e),i(P,l,e),t(l,Me,e),i(O,l,e),t(l,ie,e),t(l,ll,e),t(l,ce,e),i(el,l,e),t(l,re,e),t(l,sl,e),t(l,ye,e),i(tl,l,e),t(l,me,e),t(l,al,e),t(l,oe,e),i(nl,l,e),t(l,de,e),i(pl,l,e),t(l,je,e),t(l,Ml,e),t(l,Je,e),i(U,l,e),t(l,be,e),i(il,l,e),t(l,we,e),i(cl,l,e),t(l,Ue,e),t(l,rl,e),t(l,ue,e),i(yl,l,e),t(l,Te,e),t(l,ml,e),t(l,he,e),i(ol,l,e),t(l,fe,e),t(l,dl,e),t(l,Ce,e),t(l,jl,e),t(l,Ze,e),i(u,l,e),t(l,Be,e),t(l,Jl,e),t(l,Ie,e),i(bl,l,e),t(l,Ge,e),t(l,wl,e),t(l,$e,e),i(Ul,l,e),t(l,Xe,e),t(l,ul,e),t(l,ke,e),i(Tl,l,e),t(l,We,e),t(l,hl,e),t(l,Re,e),t(l,fl,e),t(l,_e,e),i(Cl,l,e),t(l,ge,e),t(l,Zl,e),t(l,ve,e),t(l,Gl,e),Ye=!0},p(l,[e]){const ms={};e&2&&(ms.$$scope={dirty:e,ctx:l}),U.$set(ms);const os={};e&2&&(os.$$scope={dirty:e,ctx:l}),u.$set(os)},i(l){Ye||(c(T.$$.fragment,l),c(h.$$.fragment,l),c(f.$$.fragment,l),c(Z.$$.fragment,l),c(B.$$.fragment,l),c(X.$$.fragment,l),c(W.$$.fragment,l),c(_.$$.fragment,l),c(v.$$.fragment,l),c(Y.$$.fragment,l),c(N.$$.fragment,l),c(E.$$.fragment,l),c(Q.$$.fragment,l),c(H.$$.fragment,l),c(q.$$.fragment,l),c(K.$$.fragment,l),c(L.$$.fragment,l),c(P.$$.fragment,l),c(O.$$.fragment,l),c(el.$$.fragment,l),c(tl.$$.fragment,l),c(nl.$$.fragment,l),c(pl.$$.fragment,l),c(U.$$.fragment,l),c(il.$$.fragment,l),c(cl.$$.fragment,l),c(yl.$$.fragment,l),c(ol.$$.fragment,l),c(u.$$.fragment,l),c(bl.$$.fragment,l),c(Ul.$$.fragment,l),c(Tl.$$.fragment,l),c(Cl.$$.fragment,l),Ye=!0)},o(l){r(T.$$.fragment,l),r(h.$$.fragment,l),r(f.$$.fragment,l),r(Z.$$.fragment,l),r(B.$$.fragment,l),r(X.$$.fragment,l),r(W.$$.fragment,l),r(_.$$.fragment,l),r(v.$$.fragment,l),r(Y.$$.fragment,l),r(N.$$.fragment,l),r(E.$$.fragment,l),r(Q.$$.fragment,l),r(H.$$.fragment,l),r(q.$$.fragment,l),r(K.$$.fragment,l),r(L.$$.fragment,l),r(P.$$.fragment,l),r(O.$$.fragment,l),r(el.$$.fragment,l),r(tl.$$.fragment,l),r(nl.$$.fragment,l),r(pl.$$.fragment,l),r(U.$$.fragment,l),r(il.$$.fragment,l),r(cl.$$.fragment,l),r(yl.$$.fragment,l),r(ol.$$.fragment,l),r(u.$$.fragment,l),r(bl.$$.fragment,l),r(Ul.$$.fragment,l),r(Tl.$$.fragment,l),r(Cl.$$.fragment,l),Ye=!1},d(l){l&&(s(b),s(w),s(Il),s(Xl),s(kl),s(Wl),s(C),s(Rl),s(_l),s(gl),s(I),s(vl),s(G),s(Yl),s($),s(Vl),s(Al),s(k),s(Nl),s(zl),s(R),s(El),s(Ql),s(g),s(Fl),s(xl),s(Hl),s(V),s(Sl),s(A),s(ql),s(Kl),s(z),s(Ll),s(Dl),s(Pl),s(F),s(Ol),s(x),s(le),s(ee),s(S),s(se),s(te),s(ae),s(ne),s(D),s(pe),s(Me),s(ie),s(ll),s(ce),s(re),s(sl),s(ye),s(me),s(al),s(oe),s(de),s(je),s(Ml),s(Je),s(be),s(we),s(Ue),s(rl),s(ue),s(Te),s(ml),s(he),s(fe),s(dl),s(Ce),s(jl),s(Ze),s(Be),s(Jl),s(Ie),s(Ge),s(wl),s($e),s(Xe),s(ul),s(ke),s(We),s(hl),s(Re),s(fl),s(_e),s(ge),s(Zl),s(ve),s(Gl)),s(J),y(T,l),y(h,l),y(f,l),y(Z,l),y(B,l),y(X,l),y(W,l),y(_,l),y(v,l),y(Y,l),y(N,l),y(E,l),y(Q,l),y(H,l),y(q,l),y(K,l),y(L,l),y(P,l),y(O,l),y(el,l),y(tl,l),y(nl,l),y(pl,l),y(U,l),y(il,l),y(cl,l),y(yl,l),y(ol,l),y(u,l),y(bl,l),y(Ul,l),y(Tl,l),y(Cl,l)}}}const ks='{"title":"Полное обучение","local":"полное-обучение","sections":[{"title":"Подготовка к обучению","local":"подготовка-к-обучению","sections":[],"depth":3},{"title":"Обучающий цикл","local":"обучающий-цикл","sections":[],"depth":3},{"title":"Валидационный цикл","local":"валидационный-цикл","sections":[],"depth":3},{"title":"Ускорение обучающего цикла с помощью 🤗 Accelerate","local":"ускорение-обучающего-цикла-с-помощью--accelerate","sections":[],"depth":3}],"depth":1}';function Ws(Bl){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ns extends Ts{constructor(J){super(),hs(this,J,Ws,Xs,ws,{})}}export{Ns as component};
