import{s as _t,o as Gt,n as Ut}from"../chunks/scheduler.37c15a92.js";import{S as Wt,i as Zt,g as i,s as n,r as d,A as Rt,h as o,f as l,c as s,j as Jt,u as c,x as p,k as vt,y as Ct,a,v as h,d as m,t as u,w as f}from"../chunks/index.2bf4358c.js";import{T as kt}from"../chunks/Tip.363c041f.js";import{Y as Ht}from"../chunks/Youtube.1e50a667.js";import{C as w}from"../chunks/CodeBlock.4f5fc1ad.js";import{C as It}from"../chunks/CourseFloatingBanner.15ba07e6.js";import{F as Ft}from"../chunks/FrameworkSwitchCourse.8d4d4ab6.js";import{H as Oe}from"../chunks/Heading.8ada512a.js";function zt(j){let r,y='💡 If you want to automatically upload your model to the Hub during training, pass along <code>push_to_hub=True</code> in the <code>TrainingArguments</code>. We will learn more about this in <a href="/course/chapter4/3">Chapter 4</a>';return{c(){r=i("p"),r.innerHTML=y},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-zad74h"&&(r.innerHTML=y)},m(M,b){a(M,r,b)},p:Ut,d(M){M&&l(r)}}}function Et(j){let r,y="✏️ <strong>Try it out!</strong> Fine-tune a model on the GLUE SST-2 dataset, using the data processing you did in section 2.";return{c(){r=i("p"),r.innerHTML=y},l(M){r=o(M,"P",{"data-svelte-h":!0}),p(r)!=="svelte-l3p571"&&(r.innerHTML=y)},m(M,b){a(M,r,b)},p:Ut,d(M){M&&l(r)}}}function xt(j){let r,y,M,b,T,de,J,ce,v,he,k,me,U,et='🤗 Transformers provides a <code>Trainer</code> class to help you fine-tune any of the pretrained models it provides on your dataset. Once you’ve done all the data preprocessing work in the last section, you have just a few steps left to define the <code>Trainer</code>. The hardest part is likely to be preparing the environment to run <code>Trainer.train()</code>, as it will run very slowly on a CPU. If you don’t have a GPU set up, you can get access to free GPUs or TPUs on <a href="https://colab.research.google.com/" rel="nofollow">Google Colab</a>.',ue,_,tt="The code examples below assume you have already executed the examples in the previous section. Here is a short summary recapping what you need:",fe,G,Me,W,we,Z,lt="The first step before we can define our <code>Trainer</code> is to define a <code>TrainingArguments</code> class that will contain all the hyperparameters the <code>Trainer</code> will use for training and evaluation. The only argument you have to provide is a directory where the trained model will be saved, as well as the checkpoints along the way. For all the rest, you can leave the defaults, which should work pretty well for a basic fine-tuning.",ye,R,be,g,Te,C,at='The second step is to define our model. As in the <a href="/course/chapter2">previous chapter</a>, we will use the <code>AutoModelForSequenceClassification</code> class, with two labels:',ge,H,$e,I,nt='You will notice that unlike in <a href="/course/chapter2">Chapter 2</a>, you get a warning after instantiating this pretrained model. This is because BERT has not been pretrained on classifying pairs of sentences, so the head of the pretrained model has been discarded and a new head suitable for sequence classification has been added instead. The warnings indicate that some weights were not used (the ones corresponding to the dropped pretraining head) and that some others were randomly initialized (the ones for the new head). It concludes by encouraging you to train the model, which is exactly what we are going to do now.',je,F,st="Once we have our model, we can define a <code>Trainer</code> by passing it all the objects constructed up to now — the <code>model</code>, the <code>training_args</code>, the training and validation datasets, our <code>data_collator</code>, and our <code>tokenizer</code>:",Je,z,ve,E,it="Note that when you pass the <code>tokenizer</code> as we did here, the default <code>data_collator</code> used by the <code>Trainer</code> will be a <code>DataCollatorWithPadding</code> as defined previously, so you can skip the line <code>data_collator=data_collator</code> in this call. It was still important to show you this part of the processing in section 2!",ke,x,ot="To fine-tune the model on our dataset, we just have to call the <code>train()</code> method of our <code>Trainer</code>:",Ue,X,_e,V,rt="This will start the fine-tuning (which should take a couple of minutes on a GPU) and report the training loss every 500 steps. It won’t, however, tell you how well (or badly) your model is performing. This is because:",Ge,B,pt="<li>We didn’t tell the <code>Trainer</code> to evaluate during training by setting <code>evaluation_strategy</code> to either <code>&quot;steps&quot;</code> (evaluate every <code>eval_steps</code>) or <code>&quot;epoch&quot;</code> (evaluate at the end of each epoch).</li> <li>We didn’t provide the <code>Trainer</code> with a <code>compute_metrics()</code> function to calculate a metric during said evaluation (otherwise the evaluation would just have printed the loss, which is not a very intuitive number).</li>",We,Y,Ze,A,dt="Let’s see how we can build a useful <code>compute_metrics()</code> function and use it the next time we train. The function must take an <code>EvalPrediction</code> object (which is a named tuple with a <code>predictions</code> field and a <code>label_ids</code> field) and will return a dictionary mapping strings to floats (the strings being the names of the metrics returned, and the floats their values). To get some predictions from our model, we can use the <code>Trainer.predict()</code> command:",Re,N,Ce,L,He,Q,ct="The output of the <code>predict()</code> method is another named tuple with three fields: <code>predictions</code>, <code>label_ids</code>, and <code>metrics</code>. The <code>metrics</code> field will just contain the loss on the dataset passed, as well as some time metrics (how long it took to predict, in total and on average). Once we complete our <code>compute_metrics()</code> function and pass it to the <code>Trainer</code>, that field will also contain the metrics returned by <code>compute_metrics()</code>.",Ie,q,ht='As you can see, <code>predictions</code> is a two-dimensional array with shape 408 x 2 (408 being the number of elements in the dataset we used). Those are the logits for each element of the dataset we passed to <code>predict()</code> (as you saw in the <a href="/course/chapter2">previous chapter</a>, all Transformer models return logits). To transform them into predictions that we can compare to our labels, we need to take the index with the maximum value on the second axis:',Fe,P,ze,S,mt='We can now compare those <code>preds</code> to the labels. To build our <code>compute_metric()</code> function, we will rely on the metrics from the 🤗 <a href="https://github.com/huggingface/evaluate/" rel="nofollow">Evaluate</a> library. We can load the metrics associated with the MRPC dataset as easily as we loaded the dataset, this time with the <code>evaluate.load()</code> function. The object returned has a <code>compute()</code> method we can use to do the metric calculation:',Ee,K,xe,D,Xe,O,ut='The exact results you get may vary, as the random initialization of the model head might change the metrics it achieved. Here, we can see our model has an accuracy of 85.78% on the validation set and an F1 score of 89.97. Those are the two metrics used to evaluate results on the MRPC dataset for the GLUE benchmark. The table in the <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT paper</a> reported an F1 score of 88.9 for the base model. That was the <code>uncased</code> model while we are currently using the <code>cased</code> model, which explains the better result.',Ve,ee,ft="Wrapping everything together, we get our <code>compute_metrics()</code> function:",Be,te,Ye,le,Mt="And to see it used in action to report metrics at the end of each epoch, here is how we define a new <code>Trainer</code> with this <code>compute_metrics()</code> function:",Ae,ae,Ne,ne,wt="Note that we create a new <code>TrainingArguments</code> with its <code>evaluation_strategy</code> set to <code>&quot;epoch&quot;</code> and a new model — otherwise, we would just be continuing the training of the model we have already trained. To launch a new training run, we execute:",Le,se,Qe,ie,yt="This time, it will report the validation loss and metrics at the end of each epoch on top of the training loss. Again, the exact accuracy/F1 score you reach might be a bit different from what we found, because of the random head initialization of the model, but it should be in the same ballpark.",qe,oe,bt="The <code>Trainer</code> will work out of the box on multiple GPUs or TPUs and provides lots of options, like mixed-precision training (use <code>fp16 = True</code> in your training arguments). We will go over everything it supports in Chapter 10.",Pe,re,Tt='This concludes the introduction to fine-tuning using the <code>Trainer</code> API. An example of doing this for most common NLP tasks will be given in <a href="/course/chapter7">Chapter 7</a>, but for now let’s look at how to do the same thing in pure PyTorch.',Se,$,Ke,pe,De;return T=new Ft({props:{fw:j[0]}}),J=new Oe({props:{title:"Fine-tuning a model with the Trainer API",local:"fine-tuning-a-model-with-the-trainer-api",headingTag:"h1"}}),v=new It({props:{chapter:3,classNames:"absolute z-10 right-0 top-0",notebooks:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"},{label:"Aws Studio",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/master/course/en/chapter3/section3.ipynb"}]}}),k=new Ht({props:{id:"nvBXf7s7vTI"}}),G=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyUwQSUwQXJhd19kYXRhc2V0cyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEFjaGVja3BvaW50JTIwJTNEJTIwJTIyYmVydC1iYXNlLXVuY2FzZWQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQSUwQWRlZiUyMHRva2VuaXplX2Z1bmN0aW9uKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGUlNUIlMjJzZW50ZW5jZTElMjIlNUQlMkMlMjBleGFtcGxlJTVCJTIyc2VudGVuY2UyJTIyJTVEJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwcmF3X2RhdGFzZXRzLm1hcCh0b2tlbml6ZV9mdW5jdGlvbiUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQWRhdGFfY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JXaXRoUGFkZGluZyh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, DataCollatorWithPadding

raw_datasets = load_dataset(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
checkpoint = <span class="hljs-string">&quot;bert-base-uncased&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">example</span>):
    <span class="hljs-keyword">return</span> tokenizer(example[<span class="hljs-string">&quot;sentence1&quot;</span>], example[<span class="hljs-string">&quot;sentence2&quot;</span>], truncation=<span class="hljs-literal">True</span>)


tokenized_datasets = raw_datasets.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)
data_collator = DataCollatorWithPadding(tokenizer=tokenizer)`,wrap:!1}}),W=new Oe({props:{title:"Training",local:"training",headingTag:"h3"}}),R=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>)`,wrap:!1}}),g=new kt({props:{$$slots:{default:[zt]},$$scope:{ctx:j}}}),H=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)`,wrap:!1}}),z=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
)`,wrap:!1}}),X=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),Y=new Oe({props:{title:"Evaluation",local:"evaluation",headingTag:"h3"}}),N=new w({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjB0cmFpbmVyLnByZWRpY3QodG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydmFsaWRhdGlvbiUyMiU1RCklMEFwcmludChwcmVkaWN0aW9ucy5wcmVkaWN0aW9ucy5zaGFwZSUyQyUyMHByZWRpY3Rpb25zLmxhYmVsX2lkcy5zaGFwZSk=",highlighted:`predictions = trainer.predict(tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>])
<span class="hljs-built_in">print</span>(predictions.predictions.shape, predictions.label_ids.shape)`,wrap:!1}}),L=new w({props:{code:"KDQwOCUyQyUyMDIpJTIwKDQwOCUyQyk=",highlighted:'(<span class="hljs-number">408</span>, <span class="hljs-number">2</span>) (<span class="hljs-number">408</span>,)',wrap:!1}}),P=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBcHJlZHMlMjAlM0QlMjBucC5hcmdtYXgocHJlZGljdGlvbnMucHJlZGljdGlvbnMlMkMlMjBheGlzJTNELTEp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

preds = np.argmax(predictions.predictions, axis=-<span class="hljs-number">1</span>)`,wrap:!1}}),K=new w({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmdsdWUlMjIlMkMlMjAlMjJtcnBjJTIyKSUwQW1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZHMlMkMlMjByZWZlcmVuY2VzJTNEcHJlZGljdGlvbnMubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
metric.compute(predictions=preds, references=predictions.label_ids)`,wrap:!1}}),D=new w({props:{code:"JTdCJ2FjY3VyYWN5JyUzQSUyMDAuODU3ODQzMTM3MjU0OTAxOSUyQyUyMCdmMSclM0ElMjAwLjg5OTY1Mzk3OTIzODc1NDIlN0Q=",highlighted:'{<span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.8578431372549019</span>, <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.8996539792387542</span>}',wrap:!1}}),te=new w({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZHMpJTNBJTBBJTIwJTIwJTIwJTIwbWV0cmljJTIwJTNEJTIwZXZhbHVhdGUubG9hZCglMjJnbHVlJTIyJTJDJTIwJTIybXJwYyUyMiklMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgobG9naXRzJTJDJTIwYXhpcyUzRC0xKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG1ldHJpYy5jb21wdXRlKHByZWRpY3Rpb25zJTNEcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEbGFiZWxzKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_preds</span>):
    metric = evaluate.load(<span class="hljs-string">&quot;glue&quot;</span>, <span class="hljs-string">&quot;mrpc&quot;</span>)
    logits, labels = eval_preds
    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),ae=new w({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUyMnRlc3QtdHJhaW5lciUyMiUyQyUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQlMkMlMjBudW1fbGFiZWxzJTNEMiklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjB0cmFpbl9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydHJhaW4lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R0b2tlbml6ZWRfZGF0YXNldHMlNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZGF0YV9jb2xsYXRvciUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`training_args = TrainingArguments(<span class="hljs-string">&quot;test-trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)
model = AutoModelForSequenceClassification.from_pretrained(checkpoint, num_labels=<span class="hljs-number">2</span>)

trainer = Trainer(
    model,
    training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;validation&quot;</span>],
    data_collator=data_collator,
    tokenizer=tokenizer,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),se=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),$=new kt({props:{$$slots:{default:[Et]},$$scope:{ctx:j}}}),{c(){r=i("meta"),y=n(),M=i("p"),b=n(),d(T.$$.fragment),de=n(),d(J.$$.fragment),ce=n(),d(v.$$.fragment),he=n(),d(k.$$.fragment),me=n(),U=i("p"),U.innerHTML=et,ue=n(),_=i("p"),_.textContent=tt,fe=n(),d(G.$$.fragment),Me=n(),d(W.$$.fragment),we=n(),Z=i("p"),Z.innerHTML=lt,ye=n(),d(R.$$.fragment),be=n(),d(g.$$.fragment),Te=n(),C=i("p"),C.innerHTML=at,ge=n(),d(H.$$.fragment),$e=n(),I=i("p"),I.innerHTML=nt,je=n(),F=i("p"),F.innerHTML=st,Je=n(),d(z.$$.fragment),ve=n(),E=i("p"),E.innerHTML=it,ke=n(),x=i("p"),x.innerHTML=ot,Ue=n(),d(X.$$.fragment),_e=n(),V=i("p"),V.textContent=rt,Ge=n(),B=i("ol"),B.innerHTML=pt,We=n(),d(Y.$$.fragment),Ze=n(),A=i("p"),A.innerHTML=dt,Re=n(),d(N.$$.fragment),Ce=n(),d(L.$$.fragment),He=n(),Q=i("p"),Q.innerHTML=ct,Ie=n(),q=i("p"),q.innerHTML=ht,Fe=n(),d(P.$$.fragment),ze=n(),S=i("p"),S.innerHTML=mt,Ee=n(),d(K.$$.fragment),xe=n(),d(D.$$.fragment),Xe=n(),O=i("p"),O.innerHTML=ut,Ve=n(),ee=i("p"),ee.innerHTML=ft,Be=n(),d(te.$$.fragment),Ye=n(),le=i("p"),le.innerHTML=Mt,Ae=n(),d(ae.$$.fragment),Ne=n(),ne=i("p"),ne.innerHTML=wt,Le=n(),d(se.$$.fragment),Qe=n(),ie=i("p"),ie.textContent=yt,qe=n(),oe=i("p"),oe.innerHTML=bt,Pe=n(),re=i("p"),re.innerHTML=Tt,Se=n(),d($.$$.fragment),Ke=n(),pe=i("p"),this.h()},l(e){const t=Rt("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=s(e),M=o(e,"P",{}),Jt(M).forEach(l),b=s(e),c(T.$$.fragment,e),de=s(e),c(J.$$.fragment,e),ce=s(e),c(v.$$.fragment,e),he=s(e),c(k.$$.fragment,e),me=s(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-fvu6dq"&&(U.innerHTML=et),ue=s(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1r8y7hl"&&(_.textContent=tt),fe=s(e),c(G.$$.fragment,e),Me=s(e),c(W.$$.fragment,e),we=s(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-bcd3tt"&&(Z.innerHTML=lt),ye=s(e),c(R.$$.fragment,e),be=s(e),c(g.$$.fragment,e),Te=s(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-14s2mi5"&&(C.innerHTML=at),ge=s(e),c(H.$$.fragment,e),$e=s(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1q6lkxd"&&(I.innerHTML=nt),je=s(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-t218v5"&&(F.innerHTML=st),Je=s(e),c(z.$$.fragment,e),ve=s(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1jzvhpj"&&(E.innerHTML=it),ke=s(e),x=o(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-2dkplj"&&(x.innerHTML=ot),Ue=s(e),c(X.$$.fragment,e),_e=s(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1u04gyz"&&(V.textContent=rt),Ge=s(e),B=o(e,"OL",{"data-svelte-h":!0}),p(B)!=="svelte-p9qxvg"&&(B.innerHTML=pt),We=s(e),c(Y.$$.fragment,e),Ze=s(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-h6pdaj"&&(A.innerHTML=dt),Re=s(e),c(N.$$.fragment,e),Ce=s(e),c(L.$$.fragment,e),He=s(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1jbqb9m"&&(Q.innerHTML=ct),Ie=s(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-w5buv0"&&(q.innerHTML=ht),Fe=s(e),c(P.$$.fragment,e),ze=s(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1xta58a"&&(S.innerHTML=mt),Ee=s(e),c(K.$$.fragment,e),xe=s(e),c(D.$$.fragment,e),Xe=s(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-59ywn7"&&(O.innerHTML=ut),Ve=s(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1ti0nhg"&&(ee.innerHTML=ft),Be=s(e),c(te.$$.fragment,e),Ye=s(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-yza6x"&&(le.innerHTML=Mt),Ae=s(e),c(ae.$$.fragment,e),Ne=s(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-yel3jk"&&(ne.innerHTML=wt),Le=s(e),c(se.$$.fragment,e),Qe=s(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-18ebo35"&&(ie.textContent=yt),qe=s(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-ws0acz"&&(oe.innerHTML=bt),Pe=s(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-10go40k"&&(re.innerHTML=Tt),Se=s(e),c($.$$.fragment,e),Ke=s(e),pe=o(e,"P",{}),Jt(pe).forEach(l),this.h()},h(){vt(r,"name","hf:doc:metadata"),vt(r,"content",Xt)},m(e,t){Ct(document.head,r),a(e,y,t),a(e,M,t),a(e,b,t),h(T,e,t),a(e,de,t),h(J,e,t),a(e,ce,t),h(v,e,t),a(e,he,t),h(k,e,t),a(e,me,t),a(e,U,t),a(e,ue,t),a(e,_,t),a(e,fe,t),h(G,e,t),a(e,Me,t),h(W,e,t),a(e,we,t),a(e,Z,t),a(e,ye,t),h(R,e,t),a(e,be,t),h(g,e,t),a(e,Te,t),a(e,C,t),a(e,ge,t),h(H,e,t),a(e,$e,t),a(e,I,t),a(e,je,t),a(e,F,t),a(e,Je,t),h(z,e,t),a(e,ve,t),a(e,E,t),a(e,ke,t),a(e,x,t),a(e,Ue,t),h(X,e,t),a(e,_e,t),a(e,V,t),a(e,Ge,t),a(e,B,t),a(e,We,t),h(Y,e,t),a(e,Ze,t),a(e,A,t),a(e,Re,t),h(N,e,t),a(e,Ce,t),h(L,e,t),a(e,He,t),a(e,Q,t),a(e,Ie,t),a(e,q,t),a(e,Fe,t),h(P,e,t),a(e,ze,t),a(e,S,t),a(e,Ee,t),h(K,e,t),a(e,xe,t),h(D,e,t),a(e,Xe,t),a(e,O,t),a(e,Ve,t),a(e,ee,t),a(e,Be,t),h(te,e,t),a(e,Ye,t),a(e,le,t),a(e,Ae,t),h(ae,e,t),a(e,Ne,t),a(e,ne,t),a(e,Le,t),h(se,e,t),a(e,Qe,t),a(e,ie,t),a(e,qe,t),a(e,oe,t),a(e,Pe,t),a(e,re,t),a(e,Se,t),h($,e,t),a(e,Ke,t),a(e,pe,t),De=!0},p(e,[t]){const gt={};t&1&&(gt.fw=e[0]),T.$set(gt);const $t={};t&2&&($t.$$scope={dirty:t,ctx:e}),g.$set($t);const jt={};t&2&&(jt.$$scope={dirty:t,ctx:e}),$.$set(jt)},i(e){De||(m(T.$$.fragment,e),m(J.$$.fragment,e),m(v.$$.fragment,e),m(k.$$.fragment,e),m(G.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(g.$$.fragment,e),m(H.$$.fragment,e),m(z.$$.fragment,e),m(X.$$.fragment,e),m(Y.$$.fragment,e),m(N.$$.fragment,e),m(L.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(D.$$.fragment,e),m(te.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),m($.$$.fragment,e),De=!0)},o(e){u(T.$$.fragment,e),u(J.$$.fragment,e),u(v.$$.fragment,e),u(k.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u(R.$$.fragment,e),u(g.$$.fragment,e),u(H.$$.fragment,e),u(z.$$.fragment,e),u(X.$$.fragment,e),u(Y.$$.fragment,e),u(N.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(D.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u($.$$.fragment,e),De=!1},d(e){e&&(l(y),l(M),l(b),l(de),l(ce),l(he),l(me),l(U),l(ue),l(_),l(fe),l(Me),l(we),l(Z),l(ye),l(be),l(Te),l(C),l(ge),l($e),l(I),l(je),l(F),l(Je),l(ve),l(E),l(ke),l(x),l(Ue),l(_e),l(V),l(Ge),l(B),l(We),l(Ze),l(A),l(Re),l(Ce),l(He),l(Q),l(Ie),l(q),l(Fe),l(ze),l(S),l(Ee),l(xe),l(Xe),l(O),l(Ve),l(ee),l(Be),l(Ye),l(le),l(Ae),l(Ne),l(ne),l(Le),l(Qe),l(ie),l(qe),l(oe),l(Pe),l(re),l(Se),l(Ke),l(pe)),l(r),f(T,e),f(J,e),f(v,e),f(k,e),f(G,e),f(W,e),f(R,e),f(g,e),f(H,e),f(z,e),f(X,e),f(Y,e),f(N,e),f(L,e),f(P,e),f(K,e),f(D,e),f(te,e),f(ae,e),f(se,e),f($,e)}}}const Xt='{"title":"Fine-tuning a model with the Trainer API","local":"fine-tuning-a-model-with-the-trainer-api","sections":[{"title":"Training","local":"training","sections":[],"depth":3},{"title":"Evaluation","local":"evaluation","sections":[],"depth":3}],"depth":1}';function Vt(j,r,y){let M="pt";return Gt(()=>{const b=new URLSearchParams(window.location.search);y(0,M=b.get("fw")||"pt")}),[M]}class St extends Wt{constructor(r){super(),Zt(this,r,Vt,xt,_t,{})}}export{St as component};
