import{s as Ce,n as We,o as ve}from"../chunks/scheduler.3d32dc09.js";import{S as Ae,i as xe,e as c,s as a,c as i,h as Ge,a as u,d as n,b as s,f as Ie,g as p,j as N,k as Be,l as Ve,m as l,n as o,t as r,o as m,p as d}from"../chunks/index.f9718211.js";import{C as Ze,H as h,E as Ee}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51ba2db0.js";import{C as q}from"../chunks/CodeBlock.4d1ab73b.js";function _e(we){let g,Q,S,X,f,z,y,F,$,Me=`This guide demonstrates how to integrate a synchronous agent from the <code>smolagents</code> library into an asynchronous Python web application using Starlette.
The example is designed to help users new to async Python and agent integration understand best practices for combining synchronous agent logic with async web servers.`,L,w,Y,M,Te="<li><strong>Starlette</strong>: A lightweight ASGI framework for building asynchronous web applications in Python.</li> <li><strong>anyio.to_thread.run_sync</strong>: Utility to run blocking (synchronous) code in a background thread, preventing it from blocking the async event loop.</li> <li><strong>CodeAgent</strong>: An agent from the <code>smolagents</code> library capable of programmatically solving tasks.</li>",P,T,O,J,Je="<code>CodeAgent.run()</code> executes Python code synchronously. If called directly in an async endpoint, it would block Starlette’s event loop, reducing performance and scalability. By offloading this operation to a background thread with <code>anyio.to_thread.run_sync</code>, you keep the app responsive and efficient, even under high concurrency.",D,b,K,j,be="<li>The Starlette app exposes a <code>/run-agent</code> endpoint that accepts a JSON payload with a <code>task</code> string.</li> <li>When a request is received, the agent is run in a background thread using <code>anyio.to_thread.run_sync</code>.</li> <li>The result is returned as a JSON response.</li>",ee,k,te,U,ne,I,le,B,ae,C,se,W,ie,v,pe,A,oe,x,re,G,je="<strong>Expected Response:</strong>",me,V,de,Z,ce,E,ke='<li><a href="https://www.starlette.io/" rel="nofollow">Starlette Documentation</a></li> <li><a href="https://anyio.readthedocs.io/" rel="nofollow">anyio Documentation</a></li>',ue,he,ge,_,Ue='For the full code, see <a href="https://github.com/huggingface/smolagents/tree/main/examples/async_agent" rel="nofollow"><code>examples/async_agent</code></a>.',fe,R,ye,H,$e;return f=new Ze({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),y=new h({props:{title:"Async Applications with Agents",local:"async-applications-with-agents",headingTag:"h1"}}),w=new h({props:{title:"Overview",local:"overview",headingTag:"h2"}}),T=new h({props:{title:"Why Use a Background Thread?",local:"why-use-a-background-thread",headingTag:"h2"}}),b=new h({props:{title:"Example Workflow",local:"example-workflow",headingTag:"h2"}}),k=new h({props:{title:"Building a Starlette App with a CodeAgent",local:"building-a-starlette-app-with-a-codeagent",headingTag:"h2"}}),U=new h({props:{title:"1. Install Dependencies",local:"1-install-dependencies",headingTag:"h3"}}),I=new q({props:{code:"cGlwJTIwaW5zdGFsbCUyMHNtb2xhZ2VudHMlMjBzdGFybGV0dGUlMjBhbnlpbyUyMHV2aWNvcm4=",highlighted:"pip install smolagents starlette anyio uvicorn",wrap:!1}}),B=new h({props:{title:"2. Application Code ( main.py )",local:"2-application-code--mainpy-",headingTag:"h3"}}),C=new q({props:{code:"aW1wb3J0JTIwYW55aW8udG9fdGhyZWFkJTBBZnJvbSUyMHN0YXJsZXR0ZS5hcHBsaWNhdGlvbnMlMjBpbXBvcnQlMjBTdGFybGV0dGUlMEFmcm9tJTIwc3RhcmxldHRlLnJlcXVlc3RzJTIwaW1wb3J0JTIwUmVxdWVzdCUwQWZyb20lMjBzdGFybGV0dGUucmVzcG9uc2VzJTIwaW1wb3J0JTIwSlNPTlJlc3BvbnNlJTBBZnJvbSUyMHN0YXJsZXR0ZS5yb3V0aW5nJTIwaW1wb3J0JTIwUm91dGUlMEElMEFmcm9tJTIwc21vbGFnZW50cyUyMGltcG9ydCUyMENvZGVBZ2VudCUyQyUyMEluZmVyZW5jZUNsaWVudE1vZGVsJTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbChtb2RlbF9pZCUzRCUyMlF3ZW4lMkZRd2VuMy1OZXh0LTgwQi1BM0ItVGhpbmtpbmclMjIpJTJDJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUIlNUQlMkMlMEEpJTBBJTBBYXN5bmMlMjBkZWYlMjBydW5fYWdlbnQocmVxdWVzdCUzQSUyMFJlcXVlc3QpJTNBJTBBJTIwJTIwJTIwJTIwZGF0YSUyMCUzRCUyMGF3YWl0JTIwcmVxdWVzdC5qc29uKCklMEElMjAlMjAlMjAlMjB0YXNrJTIwJTNEJTIwZGF0YS5nZXQoJTIydGFzayUyMiUyQyUyMCUyMiUyMiklMEElMjAlMjAlMjAlMjAlMjMlMjBSdW4lMjB0aGUlMjBhZ2VudCUyMHN5bmNocm9ub3VzbHklMjBpbiUyMGElMjBiYWNrZ3JvdW5kJTIwdGhyZWFkJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBhbnlpby50b190aHJlYWQucnVuX3N5bmMoYWdlbnQucnVuJTJDJTIwdGFzayklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBKU09OUmVzcG9uc2UoJTdCJTIycmVzdWx0JTIyJTNBJTIwcmVzdWx0JTdEKSUwQSUwQWFwcCUyMCUzRCUyMFN0YXJsZXR0ZShyb3V0ZXMlM0QlNUIlMEElMjAlMjAlMjAlMjBSb3V0ZSglMjIlMkZydW4tYWdlbnQlMjIlMkMlMjBydW5fYWdlbnQlMkMlMjBtZXRob2RzJTNEJTVCJTIyUE9TVCUyMiU1RCklMkMlMEElNUQp",highlighted:`<span class="hljs-keyword">import</span> anyio.to_thread
<span class="hljs-keyword">from</span> starlette.applications <span class="hljs-keyword">import</span> Starlette
<span class="hljs-keyword">from</span> starlette.requests <span class="hljs-keyword">import</span> Request
<span class="hljs-keyword">from</span> starlette.responses <span class="hljs-keyword">import</span> JSONResponse
<span class="hljs-keyword">from</span> starlette.routing <span class="hljs-keyword">import</span> Route

<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> CodeAgent, InferenceClientModel

agent = CodeAgent(
    model=InferenceClientModel(model_id=<span class="hljs-string">&quot;Qwen/Qwen3-Next-80B-A3B-Thinking&quot;</span>),
    tools=[],
)

<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_agent</span>(<span class="hljs-params">request: Request</span>):
    data = <span class="hljs-keyword">await</span> request.json()
    task = data.get(<span class="hljs-string">&quot;task&quot;</span>, <span class="hljs-string">&quot;&quot;</span>)
    <span class="hljs-comment"># Run the agent synchronously in a background thread</span>
    result = <span class="hljs-keyword">await</span> anyio.to_thread.run_sync(agent.run, task)
    <span class="hljs-keyword">return</span> JSONResponse({<span class="hljs-string">&quot;result&quot;</span>: result})

app = Starlette(routes=[
    Route(<span class="hljs-string">&quot;/run-agent&quot;</span>, run_agent, methods=[<span class="hljs-string">&quot;POST&quot;</span>]),
])`,wrap:!1}}),W=new h({props:{title:"3. Run the App",local:"3-run-the-app",headingTag:"h3"}}),v=new q({props:{code:"dXZpY29ybiUyMGFzeW5jX2FnZW50Lm1haW4lM0FhcHAlMjAtLXJlbG9hZA==",highlighted:"uvicorn async_agent.main:app --reload",wrap:!1}}),A=new h({props:{title:"4. Test the Endpoint",local:"4-test-the-endpoint",headingTag:"h3"}}),x=new q({props:{code:"Y3VybCUyMC1YJTIwUE9TVCUyMGh0dHAlM0ElMkYlMkZsb2NhbGhvc3QlM0E4MDAwJTJGcnVuLWFnZW50JTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUyMC1kJTIwJyU3QiUyMnRhc2slMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjAyJTJCMiUzRiUyMiU3RCc=",highlighted:'curl -X POST http://localhost:8000/run-agent -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> -d <span class="hljs-string">&#x27;{&quot;task&quot;: &quot;What is 2+2?&quot;}&#x27;</span>',wrap:!1}}),V=new q({props:{code:"JTdCJTIycmVzdWx0JTIyJTNBJTIwJTIyNCUyMiU3RA==",highlighted:'<span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;result&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;4&quot;</span><span class="hljs-punctuation">}</span>',wrap:!1}}),Z=new h({props:{title:"Further Reading",local:"further-reading",headingTag:"h2"}}),R=new Ee({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/async_agent.md"}}),{c(){g=c("meta"),Q=a(),S=c("p"),X=a(),i(f.$$.fragment),z=a(),i(y.$$.fragment),F=a(),$=c("p"),$.innerHTML=Me,L=a(),i(w.$$.fragment),Y=a(),M=c("ul"),M.innerHTML=Te,P=a(),i(T.$$.fragment),O=a(),J=c("p"),J.innerHTML=Je,D=a(),i(b.$$.fragment),K=a(),j=c("ul"),j.innerHTML=be,ee=a(),i(k.$$.fragment),te=a(),i(U.$$.fragment),ne=a(),i(I.$$.fragment),le=a(),i(B.$$.fragment),ae=a(),i(C.$$.fragment),se=a(),i(W.$$.fragment),ie=a(),i(v.$$.fragment),pe=a(),i(A.$$.fragment),oe=a(),i(x.$$.fragment),re=a(),G=c("p"),G.innerHTML=je,me=a(),i(V.$$.fragment),de=a(),i(Z.$$.fragment),ce=a(),E=c("ul"),E.innerHTML=ke,ue=a(),he=c("hr"),ge=a(),_=c("p"),_.innerHTML=Ue,fe=a(),i(R.$$.fragment),ye=a(),H=c("p"),this.h()},l(e){const t=Ge("svelte-u9bgzb",document.head);g=u(t,"META",{name:!0,content:!0}),t.forEach(n),Q=s(e),S=u(e,"P",{}),Ie(S).forEach(n),X=s(e),p(f.$$.fragment,e),z=s(e),p(y.$$.fragment,e),F=s(e),$=u(e,"P",{"data-svelte-h":!0}),N($)!=="svelte-1sp3xbb"&&($.innerHTML=Me),L=s(e),p(w.$$.fragment,e),Y=s(e),M=u(e,"UL",{"data-svelte-h":!0}),N(M)!=="svelte-jb7c4l"&&(M.innerHTML=Te),P=s(e),p(T.$$.fragment,e),O=s(e),J=u(e,"P",{"data-svelte-h":!0}),N(J)!=="svelte-nzal2x"&&(J.innerHTML=Je),D=s(e),p(b.$$.fragment,e),K=s(e),j=u(e,"UL",{"data-svelte-h":!0}),N(j)!=="svelte-14mqlu7"&&(j.innerHTML=be),ee=s(e),p(k.$$.fragment,e),te=s(e),p(U.$$.fragment,e),ne=s(e),p(I.$$.fragment,e),le=s(e),p(B.$$.fragment,e),ae=s(e),p(C.$$.fragment,e),se=s(e),p(W.$$.fragment,e),ie=s(e),p(v.$$.fragment,e),pe=s(e),p(A.$$.fragment,e),oe=s(e),p(x.$$.fragment,e),re=s(e),G=u(e,"P",{"data-svelte-h":!0}),N(G)!=="svelte-txxf38"&&(G.innerHTML=je),me=s(e),p(V.$$.fragment,e),de=s(e),p(Z.$$.fragment,e),ce=s(e),E=u(e,"UL",{"data-svelte-h":!0}),N(E)!=="svelte-1ned3mp"&&(E.innerHTML=ke),ue=s(e),he=u(e,"HR",{}),ge=s(e),_=u(e,"P",{"data-svelte-h":!0}),N(_)!=="svelte-bfduaj"&&(_.innerHTML=Ue),fe=s(e),p(R.$$.fragment,e),ye=s(e),H=u(e,"P",{}),Ie(H).forEach(n),this.h()},h(){Be(g,"name","hf:doc:metadata"),Be(g,"content",Re)},m(e,t){Ve(document.head,g),l(e,Q,t),l(e,S,t),l(e,X,t),o(f,e,t),l(e,z,t),o(y,e,t),l(e,F,t),l(e,$,t),l(e,L,t),o(w,e,t),l(e,Y,t),l(e,M,t),l(e,P,t),o(T,e,t),l(e,O,t),l(e,J,t),l(e,D,t),o(b,e,t),l(e,K,t),l(e,j,t),l(e,ee,t),o(k,e,t),l(e,te,t),o(U,e,t),l(e,ne,t),o(I,e,t),l(e,le,t),o(B,e,t),l(e,ae,t),o(C,e,t),l(e,se,t),o(W,e,t),l(e,ie,t),o(v,e,t),l(e,pe,t),o(A,e,t),l(e,oe,t),o(x,e,t),l(e,re,t),l(e,G,t),l(e,me,t),o(V,e,t),l(e,de,t),o(Z,e,t),l(e,ce,t),l(e,E,t),l(e,ue,t),l(e,he,t),l(e,ge,t),l(e,_,t),l(e,fe,t),o(R,e,t),l(e,ye,t),l(e,H,t),$e=!0},p:We,i(e){$e||(r(f.$$.fragment,e),r(y.$$.fragment,e),r(w.$$.fragment,e),r(T.$$.fragment,e),r(b.$$.fragment,e),r(k.$$.fragment,e),r(U.$$.fragment,e),r(I.$$.fragment,e),r(B.$$.fragment,e),r(C.$$.fragment,e),r(W.$$.fragment,e),r(v.$$.fragment,e),r(A.$$.fragment,e),r(x.$$.fragment,e),r(V.$$.fragment,e),r(Z.$$.fragment,e),r(R.$$.fragment,e),$e=!0)},o(e){m(f.$$.fragment,e),m(y.$$.fragment,e),m(w.$$.fragment,e),m(T.$$.fragment,e),m(b.$$.fragment,e),m(k.$$.fragment,e),m(U.$$.fragment,e),m(I.$$.fragment,e),m(B.$$.fragment,e),m(C.$$.fragment,e),m(W.$$.fragment,e),m(v.$$.fragment,e),m(A.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(Z.$$.fragment,e),m(R.$$.fragment,e),$e=!1},d(e){e&&(n(Q),n(S),n(X),n(z),n(F),n($),n(L),n(Y),n(M),n(P),n(O),n(J),n(D),n(K),n(j),n(ee),n(te),n(ne),n(le),n(ae),n(se),n(ie),n(pe),n(oe),n(re),n(G),n(me),n(de),n(ce),n(E),n(ue),n(he),n(ge),n(_),n(fe),n(ye),n(H)),n(g),d(f,e),d(y,e),d(w,e),d(T,e),d(b,e),d(k,e),d(U,e),d(I,e),d(B,e),d(C,e),d(W,e),d(v,e),d(A,e),d(x,e),d(V,e),d(Z,e),d(R,e)}}}const Re='{"title":"Async Applications with Agents","local":"async-applications-with-agents","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Why Use a Background Thread?","local":"why-use-a-background-thread","sections":[],"depth":2},{"title":"Example Workflow","local":"example-workflow","sections":[],"depth":2},{"title":"Building a Starlette App with a CodeAgent","local":"building-a-starlette-app-with-a-codeagent","sections":[{"title":"1. Install Dependencies","local":"1-install-dependencies","sections":[],"depth":3},{"title":"2. Application Code ( main.py )","local":"2-application-code--mainpy-","sections":[],"depth":3},{"title":"3. Run the App","local":"3-run-the-app","sections":[],"depth":3},{"title":"4. Test the Endpoint","local":"4-test-the-endpoint","sections":[],"depth":3}],"depth":2},{"title":"Further Reading","local":"further-reading","sections":[],"depth":2}],"depth":1}';function Ne(we){return ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends Ae{constructor(g){super(),xe(this,g,Ne,_e,Ce,{})}}export{Xe as component};
