import{s as is,a as ss,n as os,o as ps}from"../chunks/scheduler.3d32dc09.js";import{S as Ms,i as rs,e as i,s,c as M,h as us,a as o,d as l,b as a,f as as,g as r,j as p,k as T,l as cs,m as n,n as u,t as c,o as y,p as d}from"../chunks/index.f9718211.js";import{C as ys,H as J,E as ds}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.51ba2db0.js";import{C as w}from"../chunks/CodeBlock.4d1ab73b.js";import{D as Js}from"../chunks/DocNotebookDropdown.6e97ed3d.js";function ws(Kl){let m,pt,it,Mt,C,rt,f,ut,x,ct,h,Ol='<p>If you’re new to building agents, make sure to first read the <a href="../conceptual_guides/intro_agents">intro to agents</a> and the <a href="../guided_tour">guided tour of smolagents</a>.</p>',yt,B,dt,v,en='<a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Multiple</a> <a href="https://huggingface.co/papers/2411.01747" rel="nofollow">research</a> <a href="https://huggingface.co/papers/2401.00812" rel="nofollow">papers</a> have shown that having the LLM write its actions (the tool calls) in code is much better than the current standard format for tool calling, which is across the industry different shades of “writing actions as a JSON of tools names and arguments to use”.',Jt,k,tn="Why is code better? Well, because we crafted our code languages specifically to be great at expressing actions performed by a computer. If JSON snippets were a better way, this package would have been written in JSON snippets and the devil would be laughing at us.",wt,Z,ln="Code is just a better way to express actions on a computer. It has better:",Tt,W,nn="<li><strong>Composability:</strong> could you nest JSON actions within each other, or define a set of JSON actions to re-use later, the same way you could just define a python function?</li> <li><strong>Object management:</strong> how do you store the output of an action like <code>generate_image</code> in JSON?</li> <li><strong>Generality:</strong> code is built to express simply anything you can have a computer do.</li> <li><strong>Representation in LLM training corpus:</strong> why not leverage this benediction of the sky that plenty of quality actions have already been included in LLM training corpus?</li>",mt,G,sn='This is illustrated on the figure below, taken from <a href="https://huggingface.co/papers/2402.01030" rel="nofollow">Executable Code Actions Elicit Better LLM Agents</a>.',ht,st,an,bt,$,on="This is why we put emphasis on proposing code agents, in this case python agents, which meant putting higher effort on building secure python interpreters.",Ut,A,It,V,pn="By default, the <code>CodeAgent</code> runs LLM-generated code in your environment.",jt,E,Mn="This is inherently risky, LLM-generated code could be harmful to your environment.",gt,R,rn="Malicious code execution can occur in several ways:",Ct,N,un=`<li><strong>Plain LLM error:</strong> LLMs are still far from perfect and may unintentionally generate harmful commands while attempting to be helpful. While this risk is low, instances have been observed where an LLM attempted to execute potentially dangerous code.</li> <li><strong>Supply chain attack:</strong> Running an untrusted or compromised LLM could expose a system to harmful code generation. While this risk is extremely low when using well-known models on secure inference infrastructure, it remains a theoretical possibility.</li> <li><strong>Prompt injection:</strong> an agent browsing the web could arrive on a malicious website that contains harmful instructions, thus injecting an attack into the agent’s memory</li> <li><strong>Exploitation of publicly accessible agents:</strong> Agents exposed to the public can be misused by malicious actors to execute harmful code. Attackers may craft adversarial inputs to exploit the agent’s execution capabilities, leading to unintended consequences.
Once malicious code is executed, whether accidentally or intentionally, it can damage the file system, exploit local or cloud-based resources, abuse API services, and even compromise network security.</li>`,ft,S,cn='One could argue that on the <a href="../conceptual_guides/intro_agents">spectrum of agency</a>, code agents give much higher agency to the LLM on your system than other less agentic setups: this goes hand-in-hand with higher risk.',xt,_,yn="So you need to be very mindful of security.",Bt,Q,dn="To improve safety, we propose a range of measures that propose elevated levels of security, at a higher setup cost.",vt,H,Jn="We advise you to keep in mind that no solution will be 100% safe.",kt,at,wn,Zt,Y,Wt,q,Tn=`To add a first layer of security, code execution in <code>smolagents</code> is not performed by the vanilla Python interpreter.
We have re-built a more secure <code>LocalPythonExecutor</code> from the ground up.`,Gt,X,mn="To be precise, this interpreter works by loading the Abstract Syntax Tree (AST) from your Code and executes it operation by operation, making sure to always follow certain rules:",$t,z,hn=`<li>By default, imports are disallowed unless they have been explicitly added to an authorization list by the user.</li> <li>Furthermore, access to submodules is disabled by default, and each must be explicitly authorized in the import list as well, or you can pass for instance <code>numpy.*</code> to allow both <code>numpy</code> and all its subpackags, like <code>numpy.random</code> or <code>numpy.a.b</code>.
<ul><li>Note that some seemingly innocuous packages like <code>random</code> can give access to potentially harmful submodules, as in <code>random._os</code>.</li></ul></li> <li>The total count of elementary operations processed is capped to prevent infinite loops and resource bloating.</li> <li>Any operation that has not been explicitly defined in our custom interpreter will raise an error.</li>`,At,L,bn="You could try these safeguards as follows:",Vt,F,Et,D,Un=`These safeguards make out interpreter is safer.
We have used it on a diversity of use cases, without ever observing any damage to the environment.`,Rt,b,In="<p>It’s important to understand that no local python sandbox can ever be completely secure. While our interpreter provides significant safety improvements over the standard Python interpreter, it is still possible for a determined attacker or a fine-tuned malicious LLM to find vulnerabilities and potentially harm your environment.</p> <p>For example, if you’ve allowed packages like <code>Pillow</code> to process images, the LLM could generate code that creates thousands of large image files to fill your hard drive. Other advanced escape techniques might exploit deeper vulnerabilities in authorized packages.</p> <p>Running LLM-generated code in your local environment always carries some inherent risk. The only way to run LLM-generated code with truly robust security isolation is to use remote execution options like E2B or Docker, as detailed below.</p>",Nt,P,jn=`The risk of a malicious attack is low when using well-known LLMs from trusted inference providers, but it is not zero.
For high-security applications or when using less trusted models, you should consider using a remote execution sandbox.`,St,K,_t,O,gn="When working with AI agents that execute code, security is paramount. There are two main approaches to sandboxing code execution in smolagents, each with different security properties and capabilities:",Qt,ee,Cn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="Sandbox approaches comparison"/>',Ht,te,fn=`<li><p><strong>Running individual code snippets in a sandbox</strong>: This approach (left side of diagram) only executes the agent-generated Python code snippets in a sandbox while keeping the rest of the agentic system in your local environment. It’s simpler to set up using <code>executor_type=&quot;e2b&quot;</code>, <code>executor_type=&quot;modal&quot;</code>, or
<code>executor_type=&quot;docker&quot;</code>, but it doesn’t support multi-agents and still requires passing state data between your environment and the sandbox.</p></li> <li><p><strong>Running the entire agentic system in a sandbox</strong>: This approach (right side of diagram) runs the entire agentic system, including the agent, model, and tools, within a sandbox environment. This provides better isolation but requires more manual setup and may require passing sensitive credentials (like API keys) to the sandbox environment.</p></li>`,Yt,le,xn="This guide describes how to set up and use both types of sandbox approaches for your agent applications.",qt,ne,Xt,se,zt,ae,Bn='<li>Create an E2B account at <a href="https://e2b.dev" rel="nofollow">e2b.dev</a></li> <li>Install the required packages:</li>',Lt,ie,Ft,oe,Dt,pe,vn="We provide a simple way to use an E2B Sandbox: simply add <code>executor_type=&quot;e2b&quot;</code> to the agent initialization, as follows:",Pt,Me,Kt,U,kn=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the E2B sandbox is cleaned up immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Ot,re,Zn=`This solution send the agent state to the server at the start of each <code>agent.run()</code>.
Then the models are called from the local environment, but the generated code will be sent to the sandbox for execution, and only the output will be returned.`,el,ue,Wn="This is illustrated in the figure below.",tl,I,Gn='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/sandboxed_execution.png" alt="sandboxed code execution" width="60%" max-width="500px"/>',ll,ce,$n=`However, since any call to a <a href="../examples/multiagents">managed agent</a> would require model calls, since we do not transfer secrets to the remote sandbox, the model call would lack credentials.
Hence this solution does not work (yet) with more complicated multi-agent setups.`,nl,ye,sl,de,An="To use multi-agents in an E2B sandbox, you need to run your agents completely from within E2B.",al,Je,Vn="Here is how to do it:",il,we,ol,Te,pl,me,Ml,he,En='<li>Create a Modal account at <a href="https://modal.com/signup" rel="nofollow">modal.com</a></li> <li>Install the required packages:</li>',rl,be,ul,Ue,cl,Ie,Rn="We provide a simple way to use a Modal Sandbox: simply add <code>executor_type=&quot;modal&quot;</code> to the agent initialization, as follows:",yl,je,dl,j,Nn=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Modal sandbox is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,Jl,ge,Sn="The agent state and generated code from the <code>InferenceClientModel</code> are sent to a Modal sandbox, which can securely execute code inside them.",wl,Ce,Tl,fe,ml,xe,_n='<li><a href="https://docs.docker.com/get-started/get-docker/" rel="nofollow">Install Docker on your system</a></li> <li>Install the required packages:</li>',hl,Be,bl,ve,Ul,ke,Qn="Similar to the E2B Sandbox above, to quickly get started with Docker, simply add <code>executor_type=&quot;docker&quot;</code> to the agent initialization, like:",Il,Ze,jl,g,Hn=`<p>Using the agent as a context manager (with the <code>with</code> statement) ensures that the Docker container is cleaned immediately after the agent completes its task.
Alternatively, you can manually call the agent’s <code>cleanup()</code> method.</p>`,gl,We,Cl,Ge,Yn="If you want to run multi-agent systems in Docker, you’ll need to setup a custom interpreter in a sandbox.",fl,$e,qn="Here is how to setup the a Dockerfile:",xl,Ae,Bl,Ve,Xn="Create a sandbox manager to run code:",vl,Ee,kl,Re,Zl,Ne,zn=`WebAssembly (Wasm) is a binary instruction format that allows code to be run in a safe, sandboxed environment.
It is designed to be fast, efficient, and secure, making it an excellent choice for executing potentially untrusted code.`,Wl,Se,Ln='The <code>WasmExecutor</code> uses <a href="https://pyodide.org/" rel="nofollow">Pyodide</a> and <a href="https://docs.deno.com/" rel="nofollow">Deno</a>.',Gl,_e,$l,Qe,Fn='<li><a href="https://docs.deno.com/runtime/getting_started/installation/" rel="nofollow">Install Deno on your system</a></li>',Al,He,Vl,Ye,Dn="Simply pass <code>executor_type=&quot;wasm&quot;</code> to the agent initialization, like:",El,qe,Rl,Xe,Nl,ze,Pn="These key practices apply to both E2B and Docker sandboxes:",Sl,Le,Kn="<li><p>Resource management</p> <ul><li>Set memory and CPU limits</li> <li>Implement execution timeouts</li> <li>Monitor resource usage</li></ul></li> <li><p>Security</p> <ul><li>Run with minimal privileges</li> <li>Disable unnecessary network access</li> <li>Use environment variables for secrets</li></ul></li> <li><p>Environment</p> <ul><li>Keep dependencies minimal</li> <li>Use fixed package versions</li> <li>If you use base images, update them regularly</li></ul></li> <li><p>Cleanup</p> <ul><li>Always ensure proper cleanup of resources, especially for Docker containers, to avoid having dangling containers eating up resources.</li></ul></li>",_l,Fe,On="✨ By following these practices and implementing proper cleanup procedures, you can ensure your agent runs safely and efficiently in a sandboxed environment.",Ql,De,Hl,Pe,es="As illustrated in the diagram earlier, both sandboxing approaches have different security implications:",Yl,Ke,ql,Oe,ts=`<li><strong>Pros</strong>: 
<ul><li>Easier to set up with a simple parameter (<code>executor_type=&quot;e2b&quot;</code> or <code>executor_type=&quot;docker&quot;</code>)</li> <li>No need to transfer API keys to the sandbox</li> <li>Better protection for your local environment</li></ul></li> <li><strong>Cons</strong>:
<ul><li>Doesn’t support multi-agents (managed agents)</li> <li>Still requires transferring state between your environment and the sandbox</li> <li>Limited to specific code execution</li></ul></li>`,Xl,et,zl,tt,ls=`<li><strong>Pros</strong>:
<ul><li>Supports multi-agents</li> <li>Complete isolation of the entire agent system</li> <li>More flexible for complex agent architectures</li></ul></li> <li><strong>Cons</strong>:
<ul><li>Requires more manual setup</li> <li>May require transferring sensitive API keys to the sandbox</li> <li>Potentially higher latency due to more complex operations</li></ul></li>`,Ll,lt,ns="Choose the approach that best balances your security needs with your application’s requirements. For most applications with simpler agent architectures, Approach 1 provides a good balance of security and ease of use. For more complex multi-agent systems where you need full isolation, Approach 2, while more involved to set up, offers better security guarantees.",Fl,nt,Dl,ot,Pl;return C=new ys({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),f=new Js({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/secure_code_execution.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/secure_code_execution.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/secure_code_execution.ipynb"}]}}),x=new J({props:{title:"Secure code execution",local:"secure-code-execution",headingTag:"h1"}}),B=new J({props:{title:"Code agents",local:"code-agents",headingTag:"h3"}}),A=new J({props:{title:"Local code execution??",local:"local-code-execution",headingTag:"h3"}}),Y=new J({props:{title:"Our local Python executor",local:"our-local-python-executor",headingTag:"h3"}}),F=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMubG9jYWxfcHl0aG9uX2V4ZWN1dG9yJTIwaW1wb3J0JTIwTG9jYWxQeXRob25FeGVjdXRvciUwQSUwQSUyMyUyMFNldCUyMHVwJTIwY3VzdG9tJTIwZXhlY3V0b3IlMkMlMjBhdXRob3JpemUlMjBwYWNrYWdlJTIwJTIybnVtcHklMjIlMEFjdXN0b21fZXhlY3V0b3IlMjAlM0QlMjBMb2NhbFB5dGhvbkV4ZWN1dG9yKCU1QiUyMm51bXB5JTIyJTVEKSUwQSUwQSUyMyUyMFV0aWxpc3R5JTIwZm9yJTIwcHJldHR5JTIwcHJpbnRpbmclMjBlcnJvcnMlMEFkZWYlMjBydW5fY2FwdHVyZV9leGNlcHRpb24oY29tbWFuZCUzQSUyMHN0ciklM0ElMEElMjAlMjAlMjAlMjB0cnklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXN0b21fZXhlY3V0b3IoaGFybWZ1bF9jb21tYW5kKSUwQSUyMCUyMCUyMCUyMGV4Y2VwdCUyMEV4Y2VwdGlvbiUyMGFzJTIwZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCUyMkVSUk9SJTNBJTVDbiUyMiUyQyUyMGUpJTBBJTBBJTIzJTIwVW5kZWZpbmVkJTIwY29tbWFuZCUyMGp1c3QlMjBkbyUyMG5vdCUyMHdvcmslMEFoYXJtZnVsX2NvbW1hbmQlM0QlMjIhZWNobyUyMEJhZCUyMGNvbW1hbmQlMjIlMEFydW5fY2FwdHVyZV9leGNlcHRpb24oaGFybWZ1bF9jb21tYW5kKSUwQSUyMyUyMCUzRSUzRSUzRSUyMEVSUk9SJTNBJTIwaW52YWxpZCUyMHN5bnRheCUyMCglM0N1bmtub3duJTNFJTJDJTIwbGluZSUyMDEpJTBBJTBBJTBBJTIzJTIwSW1wb3J0cyUyMGxpa2UlMjBvcyUyMHdpbGwlMjBub3QlMjBiZSUyMHBlcmZvcm1lZCUyMHVubGVzcyUyMGV4cGxpY2l0bHklMjBhZGRlZCUyMHRvJTIwJTYwYWRkaXRpb25hbF9hdXRob3JpemVkX2ltcG9ydHMlNjAlMEFoYXJtZnVsX2NvbW1hbmQlM0QlMjJpbXBvcnQlMjBvcyUzQiUyMGV4aXRfY29kZSUyMCUzRCUyMG9zLnN5c3RlbSgnZWNobyUyMEJhZCUyMGNvbW1hbmQnKSUyMiUwQXJ1bl9jYXB0dXJlX2V4Y2VwdGlvbihoYXJtZnVsX2NvbW1hbmQpJTBBJTIzJTIwJTNFJTNFJTNFJTIwRVJST1IlM0ElMjBDb2RlJTIwZXhlY3V0aW9uJTIwZmFpbGVkJTIwYXQlMjBsaW5lJTIwJ2ltcG9ydCUyMG9zJyUyMGR1ZSUyMHRvJTNBJTIwSW50ZXJwcmV0ZXJFcnJvciUzQSUyMEltcG9ydCUyMG9mJTIwb3MlMjBpcyUyMG5vdCUyMGFsbG93ZWQuJTIwQXV0aG9yaXplZCUyMGltcG9ydHMlMjBhcmUlM0ElMjAlNUInc3RhdGlzdGljcyclMkMlMjAnbnVtcHknJTJDJTIwJ2l0ZXJ0b29scyclMkMlMjAndGltZSclMkMlMjAncXVldWUnJTJDJTIwJ2NvbGxlY3Rpb25zJyUyQyUyMCdtYXRoJyUyQyUyMCdyYW5kb20nJTJDJTIwJ3JlJyUyQyUyMCdkYXRldGltZSclMkMlMjAnc3RhdCclMkMlMjAndW5pY29kZWRhdGEnJTVEJTBBJTBBJTIzJTIwRXZlbiUyMGluJTIwYXV0aG9yaXplZCUyMGltcG9ydHMlMkMlMjBwb3RlbnRpYWxseSUyMGhhcm1mdWwlMjBwYWNrYWdlcyUyMHdpbGwlMjBub3QlMjBiZSUyMGltcG9ydGVkJTBBaGFybWZ1bF9jb21tYW5kJTNEJTIyaW1wb3J0JTIwcmFuZG9tJTNCJTIwcmFuZG9tLl9vcy5zeXN0ZW0oJ2VjaG8lMjBCYWQlMjBjb21tYW5kJyklMjIlMEFydW5fY2FwdHVyZV9leGNlcHRpb24oaGFybWZ1bF9jb21tYW5kKSUwQSUyMyUyMCUzRSUzRSUzRSUyMEVSUk9SJTNBJTIwQ29kZSUyMGV4ZWN1dGlvbiUyMGZhaWxlZCUyMGF0JTIwbGluZSUyMCdyYW5kb20uX29zLnN5c3RlbSgnZWNobyUyMEJhZCUyMGNvbW1hbmQnKSclMjBkdWUlMjB0byUzQSUyMEludGVycHJldGVyRXJyb3IlM0ElMjBGb3JiaWRkZW4lMjBhY2Nlc3MlMjB0byUyMG1vZHVsZSUzQSUyMG9zJTBBJTBBJTIzJTIwSW5maW5pdGUlMjBsb29wJTIwYXJlJTIwaW50ZXJydXB0ZWQlMjBhZnRlciUyME4lMjBvcGVyYXRpb25zJTBBaGFybWZ1bF9jb21tYW5kJTNEJTIyJTIyJTIyJTBBd2hpbGUlMjBUcnVlJTNBJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUyMiUyMiUyMiUwQXJ1bl9jYXB0dXJlX2V4Y2VwdGlvbihoYXJtZnVsX2NvbW1hbmQpJTBBJTIzJTIwJTNFJTNFJTNFJTIwRVJST1IlM0ElMjBDb2RlJTIwZXhlY3V0aW9uJTIwZmFpbGVkJTIwYXQlMjBsaW5lJTIwJ3doaWxlJTIwVHJ1ZSUzQSUyMHBhc3MnJTIwZHVlJTIwdG8lM0ElMjBJbnRlcnByZXRlckVycm9yJTNBJTIwTWF4aW11bSUyMG51bWJlciUyMG9mJTIwMTAwMDAwMCUyMGl0ZXJhdGlvbnMlMjBpbiUyMFdoaWxlJTIwbG9vcCUyMGV4Y2VlZGVk",highlighted:`<span class="hljs-keyword">from</span> smolagents.local_python_executor <span class="hljs-keyword">import</span> LocalPythonExecutor

<span class="hljs-comment"># Set up custom executor, authorize package &quot;numpy&quot;</span>
custom_executor = LocalPythonExecutor([<span class="hljs-string">&quot;numpy&quot;</span>])

<span class="hljs-comment"># Utilisty for pretty printing errors</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_capture_exception</span>(<span class="hljs-params">command: <span class="hljs-built_in">str</span></span>):
    <span class="hljs-keyword">try</span>:
        custom_executor(harmful_command)
    <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;ERROR:\\n&quot;</span>, e)

<span class="hljs-comment"># Undefined command just do not work</span>
harmful_command=<span class="hljs-string">&quot;!echo Bad command&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: invalid syntax (&lt;unknown&gt;, line 1)</span>


<span class="hljs-comment"># Imports like os will not be performed unless explicitly added to \`additional_authorized_imports\`</span>
harmful_command=<span class="hljs-string">&quot;import os; exit_code = os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;import os&#x27; due to: InterpreterError: Import of os is not allowed. Authorized imports are: [&#x27;statistics&#x27;, &#x27;numpy&#x27;, &#x27;itertools&#x27;, &#x27;time&#x27;, &#x27;queue&#x27;, &#x27;collections&#x27;, &#x27;math&#x27;, &#x27;random&#x27;, &#x27;re&#x27;, &#x27;datetime&#x27;, &#x27;stat&#x27;, &#x27;unicodedata&#x27;]</span>

<span class="hljs-comment"># Even in authorized imports, potentially harmful packages will not be imported</span>
harmful_command=<span class="hljs-string">&quot;import random; random._os.system(&#x27;echo Bad command&#x27;)&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;random._os.system(&#x27;echo Bad command&#x27;)&#x27; due to: InterpreterError: Forbidden access to module: os</span>

<span class="hljs-comment"># Infinite loop are interrupted after N operations</span>
harmful_command=<span class="hljs-string">&quot;&quot;&quot;
while True:
    pass
&quot;&quot;&quot;</span>
run_capture_exception(harmful_command)
<span class="hljs-comment"># &gt;&gt;&gt; ERROR: Code execution failed at line &#x27;while True: pass&#x27; due to: InterpreterError: Maximum number of 1000000 iterations in While loop exceeded</span>`,wrap:!1}}),K=new J({props:{title:"Sandbox approaches for secure code execution",local:"sandbox-approaches-for-secure-code-execution",headingTag:"h2"}}),ne=new J({props:{title:"E2B setup",local:"e2b-setup",headingTag:"h3"}}),se=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),ie=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZTJiJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[e2b]&#x27;</span>',wrap:!1}}),oe=new J({props:{title:"Running your agent in E2B: quick start",local:"running-your-agent-in-e2b-quick-start",headingTag:"h4"}}),Me=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZTJiJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;e2b&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),ye=new J({props:{title:"Running your agent in E2B: multi-agents",local:"running-your-agent-in-e2b-multi-agents",headingTag:"h4"}}),we=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> e2b_code_interpreter <span class="hljs-keyword">import</span> Sandbox
<span class="hljs-keyword">import</span> os

<span class="hljs-comment"># Create the sandbox</span>
sandbox = Sandbox()

<span class="hljs-comment"># Install required packages</span>
sandbox.commands.run(<span class="hljs-string">&quot;pip install smolagents&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code_raise_errors</span>(<span class="hljs-params">sandbox, code: <span class="hljs-built_in">str</span>, verbose: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span></span>) -&gt; <span class="hljs-built_in">str</span>:
    execution = sandbox.run_code(
        code,
        envs={<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>: os.getenv(<span class="hljs-string">&#x27;HF_TOKEN&#x27;</span>)}
    )
    <span class="hljs-keyword">if</span> execution.error:
        execution_logs = <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])
        logs = execution_logs
        logs += execution.error.traceback
        <span class="hljs-keyword">raise</span> ValueError(logs)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-built_in">str</span>(log) <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> execution.logs.stdout])

<span class="hljs-comment"># Define your agent application</span>
agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agents
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    name=&quot;coder_agent&quot;,
    description=&quot;This agent takes care of your difficult algorithmic problems using code.&quot;
)

manager_agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[],
    managed_agents=[agent],
)

# Run the agent
response = manager_agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

<span class="hljs-comment"># Run the agent code in the sandbox</span>
execution_logs = run_code_raise_errors(sandbox, agent_code)
<span class="hljs-built_in">print</span>(execution_logs)`,wrap:!1}}),Te=new J({props:{title:"Modal setup",local:"modal-setup",headingTag:"h3"}}),me=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),be=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCbW9kYWwlNUQn",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[modal]&#x27;</span>',wrap:!1}}),Ue=new J({props:{title:"Running your agent in Modal: quick start",local:"running-your-agent-in-modal-quick-start",headingTag:"h4"}}),je=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIybW9kYWwlMjIpJTIwYXMlMjBhZ2VudCUzQSUwQSUyMCUyMCUyMCUyMGFnZW50LnJ1biglMjJXaGF0JTIwaXMlMjB0aGUlMjA0MnRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;modal&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;What is the 42th Fibonacci number?&quot;</span>)`,wrap:!1}}),Ce=new J({props:{title:"Docker setup",local:"docker-setup",headingTag:"h3"}}),fe=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),Be=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMCdzbW9sYWdlbnRzJTVCZG9ja2VyJTVEJw==",highlighted:'pip install <span class="hljs-string">&#x27;smolagents[docker]&#x27;</span>',wrap:!1}}),ve=new J({props:{title:"Running your agent in Docker: quick start",local:"running-your-agent-in-docker-quick-start",headingTag:"h4"}}),Ze=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQXdpdGglMjBDb2RlQWdlbnQobW9kZWwlM0RJbmZlcmVuY2VDbGllbnRNb2RlbCgpJTJDJTIwdG9vbHMlM0QlNUIlNUQlMkMlMjBleGVjdXRvcl90eXBlJTNEJTIyZG9ja2VyJTIyKSUyMGFzJTIwYWdlbnQlM0ElMEElMjAlMjAlMjAlMjBhZ2VudC5ydW4oJTIyQ2FuJTIweW91JTIwZ2l2ZSUyMG1lJTIwdGhlJTIwMTAwdGglMjBGaWJvbmFjY2klMjBudW1iZXIlM0YlMjIp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

<span class="hljs-keyword">with</span> CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;docker&quot;</span>) <span class="hljs-keyword">as</span> agent:
    agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),We=new J({props:{title:"Advanced docker usage",local:"advanced-docker-usage",headingTag:"h4"}}),Ae=new w({props:{code:"RlJPTSUyMHB5dGhvbiUzQTMuMTAtYnVsbHNleWUlMEElMEElMjMlMjBJbnN0YWxsJTIwYnVpbGQlMjBkZXBlbmRlbmNpZXMlMEFSVU4lMjBhcHQtZ2V0JTIwdXBkYXRlJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGluc3RhbGwlMjAteSUyMC0tbm8taW5zdGFsbC1yZWNvbW1lbmRzJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnVpbGQtZXNzZW50aWFsJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHl0aG9uMy1kZXYlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjAtLXVwZ3JhZGUlMjBwaXAlMjAlMjYlMjYlMjAlNUMlMEElMjAlMjAlMjAlMjBwaXAlMjBpbnN0YWxsJTIwLS1uby1jYWNoZS1kaXIlMjBzbW9sYWdlbnRzJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwYXB0LWdldCUyMGNsZWFuJTIwJTI2JTI2JTIwJTVDJTBBJTIwJTIwJTIwJTIwcm0lMjAtcmYlMjAlMkZ2YXIlMkZsaWIlMkZhcHQlMkZsaXN0cyUyRiolMEElMEElMjMlMjBTZXQlMjB3b3JraW5nJTIwZGlyZWN0b3J5JTBBV09SS0RJUiUyMCUyRmFwcCUwQSUwQSUyMyUyMFJ1biUyMHdpdGglMjBsaW1pdGVkJTIwcHJpdmlsZWdlcyUwQVVTRVIlMjBub2JvZHklMEElMEElMjMlMjBEZWZhdWx0JTIwY29tbWFuZCUwQUNNRCUyMCU1QiUyMnB5dGhvbiUyMiUyQyUyMCUyMi1jJTIyJTJDJTIwJTIycHJpbnQoJ0NvbnRhaW5lciUyMHJlYWR5JyklMjIlNUQ=",highlighted:`<span class="hljs-keyword">FROM</span> python:<span class="hljs-number">3.10</span>-bullseye

<span class="hljs-comment"># Install build dependencies</span>
<span class="hljs-keyword">RUN</span><span class="language-bash"> apt-get update &amp;&amp; \\
    apt-get install -y --no-install-recommends \\
        build-essential \\
        python3-dev &amp;&amp; \\
    pip install --no-cache-dir --upgrade pip &amp;&amp; \\
    pip install --no-cache-dir smolagents &amp;&amp; \\
    apt-get clean &amp;&amp; \\
    <span class="hljs-built_in">rm</span> -rf /var/lib/apt/lists/*</span>

<span class="hljs-comment"># Set working directory</span>
<span class="hljs-keyword">WORKDIR</span><span class="language-bash"> /app</span>

<span class="hljs-comment"># Run with limited privileges</span>
<span class="hljs-keyword">USER</span> nobody

<span class="hljs-comment"># Default command</span>
<span class="hljs-keyword">CMD</span><span class="language-bash"> [<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, <span class="hljs-string">&quot;print(&#x27;Container ready&#x27;)&quot;</span>]</span>`,wrap:!1}}),Ee=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> docker
<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">DockerSandbox</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.client = docker.from_env()
        self.container = <span class="hljs-literal">None</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">create_container</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">try</span>:
            image, build_logs = self.client.images.build(
                path=<span class="hljs-string">&quot;.&quot;</span>,
                tag=<span class="hljs-string">&quot;agent-sandbox&quot;</span>,
                rm=<span class="hljs-literal">True</span>,
                forcerm=<span class="hljs-literal">True</span>,
                buildargs={},
                <span class="hljs-comment"># decode=True</span>
            )
        <span class="hljs-keyword">except</span> docker.errors.BuildError <span class="hljs-keyword">as</span> e:
            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Build error logs:&quot;</span>)
            <span class="hljs-keyword">for</span> log <span class="hljs-keyword">in</span> e.build_log:
                <span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;stream&#x27;</span> <span class="hljs-keyword">in</span> log:
                    <span class="hljs-built_in">print</span>(log[<span class="hljs-string">&#x27;stream&#x27;</span>].strip())
            <span class="hljs-keyword">raise</span>

        <span class="hljs-comment"># Create container with security constraints and proper logging</span>
        self.container = self.client.containers.run(
            <span class="hljs-string">&quot;agent-sandbox&quot;</span>,
            command=<span class="hljs-string">&quot;tail -f /dev/null&quot;</span>,  <span class="hljs-comment"># Keep container running</span>
            detach=<span class="hljs-literal">True</span>,
            tty=<span class="hljs-literal">True</span>,
            mem_limit=<span class="hljs-string">&quot;512m&quot;</span>,
            cpu_quota=<span class="hljs-number">50000</span>,
            pids_limit=<span class="hljs-number">100</span>,
            security_opt=[<span class="hljs-string">&quot;no-new-privileges&quot;</span>],
            cap_drop=[<span class="hljs-string">&quot;ALL&quot;</span>],
            environment={
                <span class="hljs-string">&quot;HF_TOKEN&quot;</span>: os.getenv(<span class="hljs-string">&quot;HF_TOKEN&quot;</span>)
            },
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">run_code</span>(<span class="hljs-params">self, code: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-type">Optional</span>[<span class="hljs-built_in">str</span>]:
        <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.container:
            self.create_container()

        <span class="hljs-comment"># Execute code in container</span>
        exec_result = self.container.exec_run(
            cmd=[<span class="hljs-string">&quot;python&quot;</span>, <span class="hljs-string">&quot;-c&quot;</span>, code],
            user=<span class="hljs-string">&quot;nobody&quot;</span>
        )

        <span class="hljs-comment"># Collect all output</span>
        <span class="hljs-keyword">return</span> exec_result.output.decode() <span class="hljs-keyword">if</span> exec_result.output <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>


    <span class="hljs-keyword">def</span> <span class="hljs-title function_">cleanup</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">if</span> self.container:
            <span class="hljs-keyword">try</span>:
                self.container.stop()
            <span class="hljs-keyword">except</span> docker.errors.NotFound:
                <span class="hljs-comment"># Container already removed, this is expected</span>
                <span class="hljs-keyword">pass</span>
            <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Error during cleanup: <span class="hljs-subst">{e}</span>&quot;</span>)
            <span class="hljs-keyword">finally</span>:
                self.container = <span class="hljs-literal">None</span>  <span class="hljs-comment"># Clear the reference</span>

<span class="hljs-comment"># Example usage:</span>
sandbox = DockerSandbox()

<span class="hljs-keyword">try</span>:
    <span class="hljs-comment"># Define your agent code</span>
    agent_code = <span class="hljs-string">&quot;&quot;&quot;
import os
from smolagents import CodeAgent, InferenceClientModel

# Initialize the agent
agent = CodeAgent(
    model=InferenceClientModel(token=os.getenv(&quot;HF_TOKEN&quot;), provider=&quot;together&quot;),
    tools=[]
)

# Run the agent
response = agent.run(&quot;What&#x27;s the 20th Fibonacci number?&quot;)
print(response)
&quot;&quot;&quot;</span>

    <span class="hljs-comment"># Run the code in the sandbox</span>
    output = sandbox.run_code(agent_code)
    <span class="hljs-built_in">print</span>(output)

<span class="hljs-keyword">finally</span>:
    sandbox.cleanup()`,wrap:!1}}),Re=new J({props:{title:"WebAssembly setup",local:"webassembly-setup",headingTag:"h3"}}),_e=new J({props:{title:"Installation",local:"installation",headingTag:"h4"}}),He=new J({props:{title:"Running your agent in WebAssembly: quick start",local:"running-your-agent-in-webassembly-quick-start",headingTag:"h4"}}),qe=new w({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBJbmZlcmVuY2VDbGllbnRNb2RlbCUyQyUyMENvZGVBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwQ29kZUFnZW50KG1vZGVsJTNESW5mZXJlbmNlQ2xpZW50TW9kZWwoKSUyQyUyMHRvb2xzJTNEJTVCJTVEJTJDJTIwZXhlY3V0b3JfdHlwZSUzRCUyMndhc20lMjIpJTBBJTBBYWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMDEwMHRoJTIwRmlib25hY2NpJTIwbnVtYmVyJTNGJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> InferenceClientModel, CodeAgent

agent = CodeAgent(model=InferenceClientModel(), tools=[], executor_type=<span class="hljs-string">&quot;wasm&quot;</span>)

agent.run(<span class="hljs-string">&quot;Can you give me the 100th Fibonacci number?&quot;</span>)`,wrap:!1}}),Xe=new J({props:{title:"Best practices for sandboxes",local:"best-practices-for-sandboxes",headingTag:"h3"}}),De=new J({props:{title:"Comparing security approaches",local:"comparing-security-approaches",headingTag:"h2"}}),Ke=new J({props:{title:"Approach 1: Running just the code snippets in a sandbox",local:"approach-1-running-just-the-code-snippets-in-a-sandbox",headingTag:"h3"}}),et=new J({props:{title:"Approach 2: Running the entire agentic system in a sandbox",local:"approach-2-running-the-entire-agentic-system-in-a-sandbox",headingTag:"h3"}}),nt=new ds({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/tutorials/secure_code_execution.md"}}),{c(){m=i("meta"),pt=s(),it=i("p"),Mt=s(),M(C.$$.fragment),rt=s(),M(f.$$.fragment),ut=s(),M(x.$$.fragment),ct=s(),h=i("blockquote"),h.innerHTML=Ol,yt=s(),M(B.$$.fragment),dt=s(),v=i("p"),v.innerHTML=en,Jt=s(),k=i("p"),k.textContent=tn,wt=s(),Z=i("p"),Z.textContent=ln,Tt=s(),W=i("ul"),W.innerHTML=nn,mt=s(),G=i("p"),G.innerHTML=sn,ht=s(),st=i("img"),bt=s(),$=i("p"),$.textContent=on,Ut=s(),M(A.$$.fragment),It=s(),V=i("p"),V.innerHTML=pn,jt=s(),E=i("p"),E.textContent=Mn,gt=s(),R=i("p"),R.textContent=rn,Ct=s(),N=i("ul"),N.innerHTML=un,ft=s(),S=i("p"),S.innerHTML=cn,xt=s(),_=i("p"),_.textContent=yn,Bt=s(),Q=i("p"),Q.textContent=dn,vt=s(),H=i("p"),H.textContent=Jn,kt=s(),at=i("img"),Zt=s(),M(Y.$$.fragment),Wt=s(),q=i("p"),q.innerHTML=Tn,Gt=s(),X=i("p"),X.textContent=mn,$t=s(),z=i("ul"),z.innerHTML=hn,At=s(),L=i("p"),L.textContent=bn,Vt=s(),M(F.$$.fragment),Et=s(),D=i("p"),D.textContent=Un,Rt=s(),b=i("blockquote"),b.innerHTML=In,Nt=s(),P=i("p"),P.textContent=jn,St=s(),M(K.$$.fragment),_t=s(),O=i("p"),O.textContent=gn,Qt=s(),ee=i("p"),ee.innerHTML=Cn,Ht=s(),te=i("ol"),te.innerHTML=fn,Yt=s(),le=i("p"),le.textContent=xn,qt=s(),M(ne.$$.fragment),Xt=s(),M(se.$$.fragment),zt=s(),ae=i("ol"),ae.innerHTML=Bn,Lt=s(),M(ie.$$.fragment),Ft=s(),M(oe.$$.fragment),Dt=s(),pe=i("p"),pe.innerHTML=vn,Pt=s(),M(Me.$$.fragment),Kt=s(),U=i("blockquote"),U.innerHTML=kn,Ot=s(),re=i("p"),re.innerHTML=Zn,el=s(),ue=i("p"),ue.textContent=Wn,tl=s(),I=i("p"),I.innerHTML=Gn,ll=s(),ce=i("p"),ce.innerHTML=$n,nl=s(),M(ye.$$.fragment),sl=s(),de=i("p"),de.textContent=An,al=s(),Je=i("p"),Je.textContent=Vn,il=s(),M(we.$$.fragment),ol=s(),M(Te.$$.fragment),pl=s(),M(me.$$.fragment),Ml=s(),he=i("ol"),he.innerHTML=En,rl=s(),M(be.$$.fragment),ul=s(),M(Ue.$$.fragment),cl=s(),Ie=i("p"),Ie.innerHTML=Rn,yl=s(),M(je.$$.fragment),dl=s(),j=i("blockquote"),j.innerHTML=Nn,Jl=s(),ge=i("p"),ge.innerHTML=Sn,wl=s(),M(Ce.$$.fragment),Tl=s(),M(fe.$$.fragment),ml=s(),xe=i("ol"),xe.innerHTML=_n,hl=s(),M(Be.$$.fragment),bl=s(),M(ve.$$.fragment),Ul=s(),ke=i("p"),ke.innerHTML=Qn,Il=s(),M(Ze.$$.fragment),jl=s(),g=i("blockquote"),g.innerHTML=Hn,gl=s(),M(We.$$.fragment),Cl=s(),Ge=i("p"),Ge.textContent=Yn,fl=s(),$e=i("p"),$e.textContent=qn,xl=s(),M(Ae.$$.fragment),Bl=s(),Ve=i("p"),Ve.textContent=Xn,vl=s(),M(Ee.$$.fragment),kl=s(),M(Re.$$.fragment),Zl=s(),Ne=i("p"),Ne.textContent=zn,Wl=s(),Se=i("p"),Se.innerHTML=Ln,Gl=s(),M(_e.$$.fragment),$l=s(),Qe=i("ol"),Qe.innerHTML=Fn,Al=s(),M(He.$$.fragment),Vl=s(),Ye=i("p"),Ye.innerHTML=Dn,El=s(),M(qe.$$.fragment),Rl=s(),M(Xe.$$.fragment),Nl=s(),ze=i("p"),ze.textContent=Pn,Sl=s(),Le=i("ul"),Le.innerHTML=Kn,_l=s(),Fe=i("p"),Fe.textContent=On,Ql=s(),M(De.$$.fragment),Hl=s(),Pe=i("p"),Pe.textContent=es,Yl=s(),M(Ke.$$.fragment),ql=s(),Oe=i("ul"),Oe.innerHTML=ts,Xl=s(),M(et.$$.fragment),zl=s(),tt=i("ul"),tt.innerHTML=ls,Ll=s(),lt=i("p"),lt.textContent=ns,Fl=s(),M(nt.$$.fragment),Dl=s(),ot=i("p"),this.h()},l(e){const t=us("svelte-u9bgzb",document.head);m=o(t,"META",{name:!0,content:!0}),t.forEach(l),pt=a(e),it=o(e,"P",{}),as(it).forEach(l),Mt=a(e),r(C.$$.fragment,e),rt=a(e),r(f.$$.fragment,e),ut=a(e),r(x.$$.fragment,e),ct=a(e),h=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-1eo9frz"&&(h.innerHTML=Ol),yt=a(e),r(B.$$.fragment,e),dt=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1nor5c0"&&(v.innerHTML=en),Jt=a(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-1b2f48c"&&(k.textContent=tn),wt=a(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-1jp5kiv"&&(Z.textContent=ln),Tt=a(e),W=o(e,"UL",{"data-svelte-h":!0}),p(W)!=="svelte-a7ou7n"&&(W.innerHTML=nn),mt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1ugtxvn"&&(G.innerHTML=sn),ht=a(e),st=o(e,"IMG",{src:!0}),bt=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1lbgv3o"&&($.textContent=on),Ut=a(e),r(A.$$.fragment,e),It=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-19p3p3d"&&(V.innerHTML=pn),jt=a(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-y55i8i"&&(E.textContent=Mn),gt=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-y4kupg"&&(R.textContent=rn),Ct=a(e),N=o(e,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-1b6z7ic"&&(N.innerHTML=un),ft=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-uopq3c"&&(S.innerHTML=cn),xt=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-gfolx1"&&(_.textContent=yn),Bt=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1j1i1cv"&&(Q.textContent=dn),vt=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1ghwkh9"&&(H.textContent=Jn),kt=a(e),at=o(e,"IMG",{src:!0}),Zt=a(e),r(Y.$$.fragment,e),Wt=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-845rka"&&(q.innerHTML=Tn),Gt=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-180snho"&&(X.textContent=mn),$t=a(e),z=o(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-1ukc2t6"&&(z.innerHTML=hn),At=a(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1wz8jbt"&&(L.textContent=bn),Vt=a(e),r(F.$$.fragment,e),Et=a(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1gk7uki"&&(D.textContent=Un),Rt=a(e),b=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-620wn8"&&(b.innerHTML=In),Nt=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-whkli4"&&(P.textContent=jn),St=a(e),r(K.$$.fragment,e),_t=a(e),O=o(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-grnb59"&&(O.textContent=gn),Qt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1r04sc2"&&(ee.innerHTML=Cn),Ht=a(e),te=o(e,"OL",{"data-svelte-h":!0}),p(te)!=="svelte-15n47tm"&&(te.innerHTML=fn),Yt=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1h3g1zs"&&(le.textContent=xn),qt=a(e),r(ne.$$.fragment,e),Xt=a(e),r(se.$$.fragment,e),zt=a(e),ae=o(e,"OL",{"data-svelte-h":!0}),p(ae)!=="svelte-uvtwg2"&&(ae.innerHTML=Bn),Lt=a(e),r(ie.$$.fragment,e),Ft=a(e),r(oe.$$.fragment,e),Dt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-r3242t"&&(pe.innerHTML=vn),Pt=a(e),r(Me.$$.fragment,e),Kt=a(e),U=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(U)!=="svelte-1mfz8t0"&&(U.innerHTML=kn),Ot=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-jrgx8f"&&(re.innerHTML=Zn),el=a(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-8sir7q"&&(ue.textContent=Wn),tl=a(e),I=o(e,"P",{align:!0,"data-svelte-h":!0}),p(I)!=="svelte-11rtdvt"&&(I.innerHTML=Gn),ll=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-ofpo9r"&&(ce.innerHTML=$n),nl=a(e),r(ye.$$.fragment,e),sl=a(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-geglm0"&&(de.textContent=An),al=a(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-1iycphr"&&(Je.textContent=Vn),il=a(e),r(we.$$.fragment,e),ol=a(e),r(Te.$$.fragment,e),pl=a(e),r(me.$$.fragment,e),Ml=a(e),he=o(e,"OL",{"data-svelte-h":!0}),p(he)!=="svelte-18yk2df"&&(he.innerHTML=En),rl=a(e),r(be.$$.fragment,e),ul=a(e),r(Ue.$$.fragment,e),cl=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-fv88x1"&&(Ie.innerHTML=Rn),yl=a(e),r(je.$$.fragment,e),dl=a(e),j=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(j)!=="svelte-tfrjt3"&&(j.innerHTML=Nn),Jl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1tt8eoy"&&(ge.innerHTML=Sn),wl=a(e),r(Ce.$$.fragment,e),Tl=a(e),r(fe.$$.fragment,e),ml=a(e),xe=o(e,"OL",{"data-svelte-h":!0}),p(xe)!=="svelte-19h0avy"&&(xe.innerHTML=_n),hl=a(e),r(Be.$$.fragment,e),bl=a(e),r(ve.$$.fragment,e),Ul=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1j9zoi1"&&(ke.innerHTML=Qn),Il=a(e),r(Ze.$$.fragment,e),jl=a(e),g=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(g)!=="svelte-1y2mdhk"&&(g.innerHTML=Hn),gl=a(e),r(We.$$.fragment,e),Cl=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-t1it0d"&&(Ge.textContent=Yn),fl=a(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-1lygj8"&&($e.textContent=qn),xl=a(e),r(Ae.$$.fragment,e),Bl=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-8mtm8c"&&(Ve.textContent=Xn),vl=a(e),r(Ee.$$.fragment,e),kl=a(e),r(Re.$$.fragment,e),Zl=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-ozg6k5"&&(Ne.textContent=zn),Wl=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1f0518g"&&(Se.innerHTML=Ln),Gl=a(e),r(_e.$$.fragment,e),$l=a(e),Qe=o(e,"OL",{"data-svelte-h":!0}),p(Qe)!=="svelte-18eum27"&&(Qe.innerHTML=Fn),Al=a(e),r(He.$$.fragment,e),Vl=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-zmyq9d"&&(Ye.innerHTML=Dn),El=a(e),r(qe.$$.fragment,e),Rl=a(e),r(Xe.$$.fragment,e),Nl=a(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-5fyo5r"&&(ze.textContent=Pn),Sl=a(e),Le=o(e,"UL",{"data-svelte-h":!0}),p(Le)!=="svelte-162p62u"&&(Le.innerHTML=Kn),_l=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-1hbg2e4"&&(Fe.textContent=On),Ql=a(e),r(De.$$.fragment,e),Hl=a(e),Pe=o(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-i4top7"&&(Pe.textContent=es),Yl=a(e),r(Ke.$$.fragment,e),ql=a(e),Oe=o(e,"UL",{"data-svelte-h":!0}),p(Oe)!=="svelte-94dicq"&&(Oe.innerHTML=ts),Xl=a(e),r(et.$$.fragment,e),zl=a(e),tt=o(e,"UL",{"data-svelte-h":!0}),p(tt)!=="svelte-rn5tr"&&(tt.innerHTML=ls),Ll=a(e),lt=o(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-l1ns7z"&&(lt.textContent=ns),Fl=a(e),r(nt.$$.fragment,e),Dl=a(e),ot=o(e,"P",{}),as(ot).forEach(l),this.h()},h(){T(m,"name","hf:doc:metadata"),T(m,"content",Ts),T(h,"class","tip"),ss(st.src,an="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/code_vs_json_actions.png")||T(st,"src",an),ss(at.src,wn="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/smolagents/code_execution_safety_diagram.png")||T(at,"src",wn),T(b,"class","warning"),T(U,"class","tip"),T(I,"align","center"),T(j,"class","tip"),T(g,"class","tip")},m(e,t){cs(document.head,m),n(e,pt,t),n(e,it,t),n(e,Mt,t),u(C,e,t),n(e,rt,t),u(f,e,t),n(e,ut,t),u(x,e,t),n(e,ct,t),n(e,h,t),n(e,yt,t),u(B,e,t),n(e,dt,t),n(e,v,t),n(e,Jt,t),n(e,k,t),n(e,wt,t),n(e,Z,t),n(e,Tt,t),n(e,W,t),n(e,mt,t),n(e,G,t),n(e,ht,t),n(e,st,t),n(e,bt,t),n(e,$,t),n(e,Ut,t),u(A,e,t),n(e,It,t),n(e,V,t),n(e,jt,t),n(e,E,t),n(e,gt,t),n(e,R,t),n(e,Ct,t),n(e,N,t),n(e,ft,t),n(e,S,t),n(e,xt,t),n(e,_,t),n(e,Bt,t),n(e,Q,t),n(e,vt,t),n(e,H,t),n(e,kt,t),n(e,at,t),n(e,Zt,t),u(Y,e,t),n(e,Wt,t),n(e,q,t),n(e,Gt,t),n(e,X,t),n(e,$t,t),n(e,z,t),n(e,At,t),n(e,L,t),n(e,Vt,t),u(F,e,t),n(e,Et,t),n(e,D,t),n(e,Rt,t),n(e,b,t),n(e,Nt,t),n(e,P,t),n(e,St,t),u(K,e,t),n(e,_t,t),n(e,O,t),n(e,Qt,t),n(e,ee,t),n(e,Ht,t),n(e,te,t),n(e,Yt,t),n(e,le,t),n(e,qt,t),u(ne,e,t),n(e,Xt,t),u(se,e,t),n(e,zt,t),n(e,ae,t),n(e,Lt,t),u(ie,e,t),n(e,Ft,t),u(oe,e,t),n(e,Dt,t),n(e,pe,t),n(e,Pt,t),u(Me,e,t),n(e,Kt,t),n(e,U,t),n(e,Ot,t),n(e,re,t),n(e,el,t),n(e,ue,t),n(e,tl,t),n(e,I,t),n(e,ll,t),n(e,ce,t),n(e,nl,t),u(ye,e,t),n(e,sl,t),n(e,de,t),n(e,al,t),n(e,Je,t),n(e,il,t),u(we,e,t),n(e,ol,t),u(Te,e,t),n(e,pl,t),u(me,e,t),n(e,Ml,t),n(e,he,t),n(e,rl,t),u(be,e,t),n(e,ul,t),u(Ue,e,t),n(e,cl,t),n(e,Ie,t),n(e,yl,t),u(je,e,t),n(e,dl,t),n(e,j,t),n(e,Jl,t),n(e,ge,t),n(e,wl,t),u(Ce,e,t),n(e,Tl,t),u(fe,e,t),n(e,ml,t),n(e,xe,t),n(e,hl,t),u(Be,e,t),n(e,bl,t),u(ve,e,t),n(e,Ul,t),n(e,ke,t),n(e,Il,t),u(Ze,e,t),n(e,jl,t),n(e,g,t),n(e,gl,t),u(We,e,t),n(e,Cl,t),n(e,Ge,t),n(e,fl,t),n(e,$e,t),n(e,xl,t),u(Ae,e,t),n(e,Bl,t),n(e,Ve,t),n(e,vl,t),u(Ee,e,t),n(e,kl,t),u(Re,e,t),n(e,Zl,t),n(e,Ne,t),n(e,Wl,t),n(e,Se,t),n(e,Gl,t),u(_e,e,t),n(e,$l,t),n(e,Qe,t),n(e,Al,t),u(He,e,t),n(e,Vl,t),n(e,Ye,t),n(e,El,t),u(qe,e,t),n(e,Rl,t),u(Xe,e,t),n(e,Nl,t),n(e,ze,t),n(e,Sl,t),n(e,Le,t),n(e,_l,t),n(e,Fe,t),n(e,Ql,t),u(De,e,t),n(e,Hl,t),n(e,Pe,t),n(e,Yl,t),u(Ke,e,t),n(e,ql,t),n(e,Oe,t),n(e,Xl,t),u(et,e,t),n(e,zl,t),n(e,tt,t),n(e,Ll,t),n(e,lt,t),n(e,Fl,t),u(nt,e,t),n(e,Dl,t),n(e,ot,t),Pl=!0},p:os,i(e){Pl||(c(C.$$.fragment,e),c(f.$$.fragment,e),c(x.$$.fragment,e),c(B.$$.fragment,e),c(A.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(ne.$$.fragment,e),c(se.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(Me.$$.fragment,e),c(ye.$$.fragment,e),c(we.$$.fragment,e),c(Te.$$.fragment,e),c(me.$$.fragment,e),c(be.$$.fragment,e),c(Ue.$$.fragment,e),c(je.$$.fragment,e),c(Ce.$$.fragment,e),c(fe.$$.fragment,e),c(Be.$$.fragment,e),c(ve.$$.fragment,e),c(Ze.$$.fragment,e),c(We.$$.fragment,e),c(Ae.$$.fragment,e),c(Ee.$$.fragment,e),c(Re.$$.fragment,e),c(_e.$$.fragment,e),c(He.$$.fragment,e),c(qe.$$.fragment,e),c(Xe.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(et.$$.fragment,e),c(nt.$$.fragment,e),Pl=!0)},o(e){y(C.$$.fragment,e),y(f.$$.fragment,e),y(x.$$.fragment,e),y(B.$$.fragment,e),y(A.$$.fragment,e),y(Y.$$.fragment,e),y(F.$$.fragment,e),y(K.$$.fragment,e),y(ne.$$.fragment,e),y(se.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(ye.$$.fragment,e),y(we.$$.fragment,e),y(Te.$$.fragment,e),y(me.$$.fragment,e),y(be.$$.fragment,e),y(Ue.$$.fragment,e),y(je.$$.fragment,e),y(Ce.$$.fragment,e),y(fe.$$.fragment,e),y(Be.$$.fragment,e),y(ve.$$.fragment,e),y(Ze.$$.fragment,e),y(We.$$.fragment,e),y(Ae.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(_e.$$.fragment,e),y(He.$$.fragment,e),y(qe.$$.fragment,e),y(Xe.$$.fragment,e),y(De.$$.fragment,e),y(Ke.$$.fragment,e),y(et.$$.fragment,e),y(nt.$$.fragment,e),Pl=!1},d(e){e&&(l(pt),l(it),l(Mt),l(rt),l(ut),l(ct),l(h),l(yt),l(dt),l(v),l(Jt),l(k),l(wt),l(Z),l(Tt),l(W),l(mt),l(G),l(ht),l(st),l(bt),l($),l(Ut),l(It),l(V),l(jt),l(E),l(gt),l(R),l(Ct),l(N),l(ft),l(S),l(xt),l(_),l(Bt),l(Q),l(vt),l(H),l(kt),l(at),l(Zt),l(Wt),l(q),l(Gt),l(X),l($t),l(z),l(At),l(L),l(Vt),l(Et),l(D),l(Rt),l(b),l(Nt),l(P),l(St),l(_t),l(O),l(Qt),l(ee),l(Ht),l(te),l(Yt),l(le),l(qt),l(Xt),l(zt),l(ae),l(Lt),l(Ft),l(Dt),l(pe),l(Pt),l(Kt),l(U),l(Ot),l(re),l(el),l(ue),l(tl),l(I),l(ll),l(ce),l(nl),l(sl),l(de),l(al),l(Je),l(il),l(ol),l(pl),l(Ml),l(he),l(rl),l(ul),l(cl),l(Ie),l(yl),l(dl),l(j),l(Jl),l(ge),l(wl),l(Tl),l(ml),l(xe),l(hl),l(bl),l(Ul),l(ke),l(Il),l(jl),l(g),l(gl),l(Cl),l(Ge),l(fl),l($e),l(xl),l(Bl),l(Ve),l(vl),l(kl),l(Zl),l(Ne),l(Wl),l(Se),l(Gl),l($l),l(Qe),l(Al),l(Vl),l(Ye),l(El),l(Rl),l(Nl),l(ze),l(Sl),l(Le),l(_l),l(Fe),l(Ql),l(Hl),l(Pe),l(Yl),l(ql),l(Oe),l(Xl),l(zl),l(tt),l(Ll),l(lt),l(Fl),l(Dl),l(ot)),l(m),d(C,e),d(f,e),d(x,e),d(B,e),d(A,e),d(Y,e),d(F,e),d(K,e),d(ne,e),d(se,e),d(ie,e),d(oe,e),d(Me,e),d(ye,e),d(we,e),d(Te,e),d(me,e),d(be,e),d(Ue,e),d(je,e),d(Ce,e),d(fe,e),d(Be,e),d(ve,e),d(Ze,e),d(We,e),d(Ae,e),d(Ee,e),d(Re,e),d(_e,e),d(He,e),d(qe,e),d(Xe,e),d(De,e),d(Ke,e),d(et,e),d(nt,e)}}}const Ts='{"title":"Secure code execution","local":"secure-code-execution","sections":[{"title":"Code agents","local":"code-agents","sections":[],"depth":3},{"title":"Local code execution??","local":"local-code-execution","sections":[],"depth":3},{"title":"Our local Python executor","local":"our-local-python-executor","sections":[],"depth":3},{"title":"Sandbox approaches for secure code execution","local":"sandbox-approaches-for-secure-code-execution","sections":[{"title":"E2B setup","local":"e2b-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in E2B: quick start","local":"running-your-agent-in-e2b-quick-start","sections":[],"depth":4},{"title":"Running your agent in E2B: multi-agents","local":"running-your-agent-in-e2b-multi-agents","sections":[],"depth":4}],"depth":3},{"title":"Modal setup","local":"modal-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Modal: quick start","local":"running-your-agent-in-modal-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Docker setup","local":"docker-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in Docker: quick start","local":"running-your-agent-in-docker-quick-start","sections":[],"depth":4},{"title":"Advanced docker usage","local":"advanced-docker-usage","sections":[],"depth":4}],"depth":3},{"title":"WebAssembly setup","local":"webassembly-setup","sections":[{"title":"Installation","local":"installation","sections":[],"depth":4},{"title":"Running your agent in WebAssembly: quick start","local":"running-your-agent-in-webassembly-quick-start","sections":[],"depth":4}],"depth":3},{"title":"Best practices for sandboxes","local":"best-practices-for-sandboxes","sections":[],"depth":3}],"depth":2},{"title":"Comparing security approaches","local":"comparing-security-approaches","sections":[{"title":"Approach 1: Running just the code snippets in a sandbox","local":"approach-1-running-just-the-code-snippets-in-a-sandbox","sections":[],"depth":3},{"title":"Approach 2: Running the entire agentic system in a sandbox","local":"approach-2-running-the-entire-agentic-system-in-a-sandbox","sections":[],"depth":3}],"depth":2}],"depth":1}';function ms(Kl){return ps(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gs extends Ms{constructor(m){super(),rs(this,m,ms,ws,is,{})}}export{gs as component};
