import{s as Ul,n as fl,o as wl}from"../chunks/scheduler.7da89386.js";import{S as bl,i as Jl,g as i,s,r as p,A as gl,h as o,f as l,c as n,j as yl,u,x as c,k as ve,y as Tl,a,v as r,d,t as h,w as m}from"../chunks/index.20910acc.js";import{C as U}from"../chunks/CodeBlock.143bd81e.js";import{H as M,E as vl}from"../chunks/getInferenceSnippets.375cdad5.js";function jl(qt){let y,je,ge,Ce,J,xe,g,Wt='The <code>Evaluator</code> classes allow to evaluate a  triplet of model, dataset, and metric. The models wrapped in a pipeline, responsible for handling all preprocessing and post-processing and out-of-the-box, <code>Evaluator</code>s support transformers pipelines for the supported tasks, but custom pipelines can be passed, as showcased in the section <a href="custom_evaluator">Using the <code>evaluator</code> with custom pipelines</a>.',Ie,T,Gt="Currently supported tasks are:",ke,v,Bt='<li><code>&quot;text-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TextClassificationEvaluator">TextClassificationEvaluator</a>.</li> <li><code>&quot;token-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TokenClassificationEvaluator">TokenClassificationEvaluator</a>.</li> <li><code>&quot;question-answering&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.QuestionAnsweringEvaluator">QuestionAnsweringEvaluator</a>.</li> <li><code>&quot;image-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.ImageClassificationEvaluator">ImageClassificationEvaluator</a>.</li> <li><code>&quot;text-generation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TextGenerationEvaluator">TextGenerationEvaluator</a>.</li> <li><code>&quot;text2text-generation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.Text2TextGenerationEvaluator">Text2TextGenerationEvaluator</a>.</li> <li><code>&quot;summarization&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.SummarizationEvaluator">SummarizationEvaluator</a>.</li> <li><code>&quot;translation&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.TranslationEvaluator">TranslationEvaluator</a>.</li> <li><code>&quot;automatic-speech-recognition&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.AutomaticSpeechRecognitionEvaluator">AutomaticSpeechRecognitionEvaluator</a>.</li> <li><code>&quot;audio-classification&quot;</code>: will use the <a href="/docs/evaluate/main/en/package_reference/evaluator_classes#evaluate.AudioClassificationEvaluator">AudioClassificationEvaluator</a>.</li>',_e,j,$t='To run an <code>Evaluator</code> with several tasks in a single call, use the <a href="evaluation_suite">EvaluationSuite</a>, which runs evaluations on a collection of <code>SubTask</code>s.',Ze,C,Et="Each task has its own set of requirements for the dataset format and pipeline output, make sure to check them out for your custom use case. Let’s have a look at some of them and see how you can use the evaluator to evalute a single or multiple of models, datasets, and metrics at the same time.",qe,x,We,I,Qt="The text classification evaluator can be used to evaluate text models on classification datasets such as IMDb. Beside the model, data, and metric inputs it takes the following optional inputs:",Ge,k,Rt="<li><code>input_column=&quot;text&quot;</code>: with this argument the column with the data for the pipeline can be specified.</li> <li><code>label_column=&quot;label&quot;</code>: with this argument the column with the labels for the evaluation can be specified.</li> <li><code>label_mapping=None</code>: the label mapping aligns the labels in the pipeline output with the labels need for evaluation. E.g. the labels in <code>label_column</code> can be integers (<code>0</code>/<code>1</code>) whereas the pipeline can produce label names such as <code>&quot;positive&quot;</code>/<code>&quot;negative&quot;</code>. With that dictionary the pipeline outputs are mapped to the labels.</li>",Be,_,Xt="By default the <code>&quot;accuracy&quot;</code> metric is computed.",$e,Z,Ee,q,Yt="There are several ways to pass a model to the evaluator: you can pass the name of a model on the Hub, you can load a <code>transformers</code> model and pass it to the evaluator or you can pass an initialized <code>transformers.Pipeline</code>. Alternatively you can pass any callable function that behaves like a <code>pipeline</code> call for the task in any framework.",Qe,W,St="So any of the following works:",Re,G,Xe,f,Vt="<p>Without specifying a device, the default for model inference will be the first GPU on the machine if one is available, and else CPU. If you want to use a specific device you can pass <code>device</code> to <code>compute</code> where -1 will use the GPU and a positive integer (starting with 0) will use the associated CUDA device.</p>",Ye,B,Nt="The results will look as follows:",Se,$,Ve,E,zt="Note that evaluation results include both the requested metric, and information about the time it took to obtain predictions through the pipeline.",Ne,w,Ft="<p>The time performances can give useful indication on model speed for inference but should be taken with a grain of salt: they include all the processing that goes on in the pipeline. This may include tokenizing, post-processing, that may be different depending on the model. Furthermore, it depends a lot on the hardware you are running the evaluation on and you may be able to improve the performance by optimizing things like the batch size.</p>",ze,Q,Fe,R,At='With the <a href="/docs/evaluate/main/en/package_reference/main_classes#evaluate.combine">combine()</a> function one can bundle several metrics into an object that behaves like a single metric. We can use this to evaluate several metrics at once with the evaluator:',Ae,X,He,Y,Ht="The results will look as follows:",Le,S,De,V,Lt="Next let’s have a look at token classification.",Pe,N,Ke,z,Dt="With the token classification evaluator one can evaluate models for tasks such as NER or POS tagging. It has the following specific arguments:",Oe,F,Pt="<li><code>input_column=&quot;text&quot;</code>: with this argument the column with the data for the pipeline can be specified.</li> <li><code>label_column=&quot;label&quot;</code>: with this argument the column with the labels for the evaluation can be specified.</li> <li><code>label_mapping=None</code>: the label mapping aligns the labels in the pipeline output with the labels need for evaluation. E.g. the labels in <code>label_column</code> can be integers (<code>0</code>/<code>1</code>) whereas the pipeline can produce label names such as <code>&quot;positive&quot;</code>/<code>&quot;negative&quot;</code>. With that dictionary the pipeline outputs are mapped to the labels.</li> <li><code>join_by=&quot; &quot;</code>: While most datasets are already tokenized the pipeline expects a string. Thus the tokens need to be joined before passing to the pipeline. By default they are joined with a whitespace.</li>",et,A,Kt="Let’s have a look how we can use the evaluator to benchmark several models.",tt,H,lt,L,Ot="Here is an example where several models can be compared thanks to the <code>evaluator</code> in only a few lines of code, abstracting away the preprocessing, inference, postprocessing, metric computation:",at,D,st,P,el="The result is a table that looks like this:",nt,K,tl='<thead><tr><th align="left">model</th> <th align="right">overall_f1</th> <th align="right">overall_accuracy</th> <th align="right">total_time_in_seconds</th> <th align="right">samples_per_second</th> <th align="right">latency_in_seconds</th></tr></thead> <tbody><tr><td align="left">Jorgeutd/albert-base-v2-finetuned-ner</td> <td align="right">0.941</td> <td align="right">0.989</td> <td align="right">4.515</td> <td align="right">221.468</td> <td align="right">0.005</td></tr> <tr><td align="left">dbmdz/bert-large-cased-finetuned-conll03-english</td> <td align="right">0.962</td> <td align="right">0.881</td> <td align="right">11.648</td> <td align="right">85.850</td> <td align="right">0.012</td></tr> <tr><td align="left">dbmdz/electra-large-discriminator-finetuned-conll03-english</td> <td align="right">0.965</td> <td align="right">0.881</td> <td align="right">11.456</td> <td align="right">87.292</td> <td align="right">0.011</td></tr> <tr><td align="left">elastic/distilbert-base-uncased-finetuned-conll03-english</td> <td align="right">0.940</td> <td align="right">0.989</td> <td align="right">2.318</td> <td align="right">431.378</td> <td align="right">0.002</td></tr> <tr><td align="left">gunghio/distilbert-base-multilingual-cased-finetuned-conll2003-ner</td> <td align="right">0.947</td> <td align="right">0.991</td> <td align="right">2.376</td> <td align="right">420.873</td> <td align="right">0.002</td></tr> <tr><td align="left">philschmid/distilroberta-base-ner-conll2003</td> <td align="right">0.961</td> <td align="right">0.994</td> <td align="right">2.436</td> <td align="right">410.579</td> <td align="right">0.002</td></tr> <tr><td align="left">xlm-roberta-large-finetuned-conll03-english</td> <td align="right">0.969</td> <td align="right">0.882</td> <td align="right">11.996</td> <td align="right">83.359</td> <td align="right">0.012</td></tr></tbody>',it,O,ot,ee,ll="You can feed in the <code>results</code> list above into the <code>plot_radar()</code> function to visualize different aspects of their performance and choose the model that is the best fit, depending on the metric(s) that are relevant to your use case:",ct,te,pt,b,al='<img src="https://huggingface.co/datasets/evaluate/media/resolve/main/viz.png" width="400"/>',ut,le,sl="Don’t forget to specify <code>invert_range</code> for metrics for which smaller is better (such as the case for latency in seconds).",rt,ae,nl="If you want to save the plot locally, you can use the <code>plot.savefig()</code> function with the option <code>bbox_inches=&#39;tight&#39;</code>, to make sure no part of the image gets cut off.",dt,se,ht,ne,il="With the question-answering evaluator one can evaluate models for QA without needing to worry about the complicated pre- and post-processing that’s required for these models. It has the following specific arguments:",mt,ie,ol="<li><code>question_column=&quot;question&quot;</code>: the name of the column containing the question in the dataset</li> <li><code>context_column=&quot;context&quot;</code>: the name of the column containing the context</li> <li><code>id_column=&quot;id&quot;</code>: the name of the column cointaing the identification field of the question and answer pair</li> <li><code>label_column=&quot;answers&quot;</code>: the name of the column containing the answers</li> <li><code>squad_v2_format=None</code>: whether the dataset follows the format of squad_v2 dataset where a question may have no answer in the context. If this parameter is not provided, the format will be automatically inferred.</li>",Mt,oe,cl="Let’s have a look how we can evaluate QA models and compute confidence intervals at the same time.",yt,ce,Ut,pe,pl='Every evaluator comes with the options to compute confidence intervals using <a href="https://docs.scipy.org/doc/scipy/reference/generated/scipy.stats.bootstrap.html" rel="nofollow">bootstrapping</a>. Simply pass <code>strategy=&quot;bootstrap&quot;</code> and set the number of resanmples with <code>n_resamples</code>.',ft,ue,wt,re,ul="Results include confidence intervals as well as error estimates as follows:",bt,de,Jt,he,gt,me,rl="With the image classification evaluator we can evaluate any image classifier. It uses the same keyword arguments at the text classifier:",Tt,Me,dl="<li><code>input_column=&quot;image&quot;</code>: the name of the column containing the images as PIL ImageFile</li> <li><code>label_column=&quot;label&quot;</code>: the name of the column containing the labels</li> <li><code>label_mapping=None</code>: We want to map class labels defined by the model in the pipeline to values consistent with those defined in the <code>label_column</code></li>",vt,ye,hl="Let’s have a look at how can evaluate image classification models on large datasets.",jt,Ue,Ct,fe,ml="The evaluator can be used on large datasets! Below, an example shows how to use it on ImageNet-1k for image classification. Beware that this example will require to download ~150 GB.",xt,we,It,be,Ml="Since we are using <code>datasets</code> to store data we make use of a technique called memory mappings. This means that the dataset is never fully loaded into memory which saves a lot of RAM. Running the above code only uses roughly 1.5 GB of RAM while the validation split is more than 30 GB big.",kt,Je,_t,Te,Zt;return J=new M({props:{title:"Using the evaluator",local:"using-the-evaluator",headingTag:"h1"}}),x=new M({props:{title:"Text classification",local:"text-classification",headingTag:"h2"}}),Z=new M({props:{title:"Evaluate models on the Hub",local:"evaluate-models-on-the-hub",headingTag:"h3"}}),G=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwZXZhbHVhdG9yJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMjBwaXBlbGluZSUwQSUwQWRhdGElMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTIydGVzdCUyMikuc2h1ZmZsZShzZWVkJTNENDIpLnNlbGVjdChyYW5nZSgxMDAwKSklMEF0YXNrX2V2YWx1YXRvciUyMCUzRCUyMGV2YWx1YXRvciglMjJ0ZXh0LWNsYXNzaWZpY2F0aW9uJTIyKSUwQSUwQSUyMyUyMDEuJTIwUGFzcyUyMGElMjBtb2RlbCUyMG5hbWUlMjBvciUyMHBhdGglMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbWFwcGluZyUzRCU3QiUyMk5FR0FUSVZFJTIyJTNBJTIwMCUyQyUyMCUyMlBPU0lUSVZFJTIyJTNBJTIwMSU3RCUwQSklMEElMEElMjMlMjAyLiUyMFBhc3MlMjBhbiUyMGluc3RhbnRpYXRlZCUyMG1vZGVsJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsdndlcnJhJTJGZGlzdGlsYmVydC1pbWRiJTIyKSUwQSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbWFwcGluZyUzRCU3QiUyMk5FR0FUSVZFJTIyJTNBJTIwMCUyQyUyMCUyMlBPU0lUSVZFJTIyJTNBJTIwMSU3RCUwQSklMEElMEElMjMlMjAzLiUyMFBhc3MlMjBhbiUyMGluc3RhbnRpYXRlZCUyMHBpcGVsaW5lJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMmx2d2VycmElMkZkaXN0aWxiZXJ0LWltZGIlMjIpJTBBJTBBZXZhbF9yZXN1bHRzJTIwJTNEJTIwdGFza19ldmFsdWF0b3IuY29tcHV0ZSglMEElMjAlMjAlMjAlMjBtb2RlbF9vcl9waXBlbGluZSUzRHBpcGUlMkMlMEElMjAlMjAlMjAlMjBkYXRhJTNEZGF0YSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMEEpJTBBcHJpbnQoZXZhbF9yZXN1bHRzKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, pipeline

data = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>).shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
task_evaluator = evaluator(<span class="hljs-string">&quot;text-classification&quot;</span>)

<span class="hljs-comment"># 1. Pass a model name or path</span>
eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)

<span class="hljs-comment"># 2. Pass an instantiated model</span>
model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)

eval_results = task_evaluator.compute(
    model_or_pipeline=model,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)

<span class="hljs-comment"># 3. Pass an instantiated pipeline</span>
pipe = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>)

eval_results = task_evaluator.compute(
    model_or_pipeline=pipe,
    data=data,
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)
<span class="hljs-built_in">print</span>(eval_results)`,wrap:!1}}),$=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2FjY3VyYWN5JyUzQSUyMDAuOTE4JTJDJTBBJTIwJTIwJTIwJTIwJ2xhdGVuY3lfaW5fc2Vjb25kcyclM0ElMjAwLjAxMyUyQyUwQSUyMCUyMCUyMCUyMCdzYW1wbGVzX3Blcl9zZWNvbmQnJTNBJTIwNzguODg3JTJDJTBBJTIwJTIwJTIwJTIwJ3RvdGFsX3RpbWVfaW5fc2Vjb25kcyclM0ElMjAxMi42NzYlMEElN0Q=",highlighted:`{
    <span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.918</span>,
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.013</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">78.887</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">12.676</span>
}`,wrap:!1}}),Q=new M({props:{title:"Evaluate multiple metrics",local:"evaluate-multiple-metrics",headingTag:"h3"}}),X=new U({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFldmFsX3Jlc3VsdHMlMjAlM0QlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEJTIybHZ3ZXJyYSUyRmRpc3RpbGJlcnQtaW1kYiUyMiUyQyUwQSUyMCUyMCUyMCUyMGRhdGElM0RkYXRhJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljJTNEZXZhbHVhdGUuY29tYmluZSglNUIlMjJhY2N1cmFjeSUyMiUyQyUyMCUyMnJlY2FsbCUyMiUyQyUyMCUyMnByZWNpc2lvbiUyMiUyQyUyMCUyMmYxJTIyJTVEKSUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0QlN0IlMjJORUdBVElWRSUyMiUzQSUyMDAlMkMlMjAlMjJQT1NJVElWRSUyMiUzQSUyMDElN0QlMEEpJTBBcHJpbnQoZXZhbF9yZXN1bHRzKSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;lvwerra/distilbert-imdb&quot;</span>,
    data=data,
    metric=evaluate.combine([<span class="hljs-string">&quot;accuracy&quot;</span>, <span class="hljs-string">&quot;recall&quot;</span>, <span class="hljs-string">&quot;precision&quot;</span>, <span class="hljs-string">&quot;f1&quot;</span>]),
    label_mapping={<span class="hljs-string">&quot;NEGATIVE&quot;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&quot;POSITIVE&quot;</span>: <span class="hljs-number">1</span>}
)
<span class="hljs-built_in">print</span>(eval_results)
`,wrap:!1}}),S=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2FjY3VyYWN5JyUzQSUyMDAuOTE4JTJDJTBBJTIwJTIwJTIwJTIwJ2YxJyUzQSUyMDAuOTE2JTJDJTBBJTIwJTIwJTIwJTIwJ3ByZWNpc2lvbiclM0ElMjAwLjkxNDclMkMlMEElMjAlMjAlMjAlMjAncmVjYWxsJyUzQSUyMDAuOTE4NyUyQyUwQSUyMCUyMCUyMCUyMCdsYXRlbmN5X2luX3NlY29uZHMnJTNBJTIwMC4wMTMlMkMlMEElMjAlMjAlMjAlMjAnc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDc4Ljg4NyUyQyUwQSUyMCUyMCUyMCUyMCd0b3RhbF90aW1lX2luX3NlY29uZHMnJTNBJTIwMTIuNjc2JTBBJTdE",highlighted:`{
    <span class="hljs-string">&#x27;accuracy&#x27;</span>: <span class="hljs-number">0.918</span>,
    <span class="hljs-string">&#x27;f1&#x27;</span>: <span class="hljs-number">0.916</span>,
    <span class="hljs-string">&#x27;precision&#x27;</span>: <span class="hljs-number">0.9147</span>,
    <span class="hljs-string">&#x27;recall&#x27;</span>: <span class="hljs-number">0.9187</span>,
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.013</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">78.887</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">12.676</span>
}`,wrap:!1}}),N=new M({props:{title:"Token Classification",local:"token-classification",headingTag:"h2"}}),H=new M({props:{title:"Benchmarking several models",local:"benchmarking-several-models",headingTag:"h3"}}),D=new U({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWZyb20lMjBldmFsdWF0ZSUyMGltcG9ydCUyMGV2YWx1YXRvciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQW1vZGVscyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnhsbS1yb2JlcnRhLWxhcmdlLWZpbmV0dW5lZC1jb25sbDAzLWVuZ2xpc2glMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJkYm1keiUyRmJlcnQtbGFyZ2UtY2FzZWQtZmluZXR1bmVkLWNvbmxsMDMtZW5nbGlzaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmVsYXN0aWMlMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1maW5ldHVuZWQtY29ubGwwMy1lbmdsaXNoJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyZGJtZHolMkZlbGVjdHJhLWxhcmdlLWRpc2NyaW1pbmF0b3ItZmluZXR1bmVkLWNvbmxsMDMtZW5nbGlzaCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmd1bmdoaW8lMkZkaXN0aWxiZXJ0LWJhc2UtbXVsdGlsaW5ndWFsLWNhc2VkLWZpbmV0dW5lZC1jb25sbDIwMDMtbmVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIycGhpbHNjaG1pZCUyRmRpc3RpbHJvYmVydGEtYmFzZS1uZXItY29ubGwyMDAzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIySm9yZ2V1dGQlMkZhbGJlcnQtYmFzZS12Mi1maW5ldHVuZWQtbmVyJTIyJTJDJTBBJTVEJTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjb25sbDIwMDMlMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpLnNodWZmbGUoKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBdGFza19ldmFsdWF0b3IlMjAlM0QlMjBldmFsdWF0b3IoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBcmVzdWx0cyUyMCUzRCUyMCU1QiU1RCUwQWZvciUyMG1vZGVsJTIwaW4lMjBtb2RlbHMlM0ElMEElMjAlMjAlMjAlMjByZXN1bHRzLmFwcGVuZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXNrX2V2YWx1YXRvci5jb21wdXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsX29yX3BpcGVsaW5lJTNEbW9kZWwlMkMlMjBkYXRhJTNEZGF0YSUyQyUyMG1ldHJpYyUzRCUyMnNlcWV2YWwlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQWRmJTIwJTNEJTIwcGQuRGF0YUZyYW1lKHJlc3VsdHMlMkMlMjBpbmRleCUzRG1vZGVscyklMEFkZiU1QiU1QiUyMm92ZXJhbGxfZjElMjIlMkMlMjAlMjJvdmVyYWxsX2FjY3VyYWN5JTIyJTJDJTIwJTIydG90YWxfdGltZV9pbl9zZWNvbmRzJTIyJTJDJTIwJTIyc2FtcGxlc19wZXJfc2Vjb25kJTIyJTJDJTIwJTIybGF0ZW5jeV9pbl9zZWNvbmRzJTIyJTVEJTVE",highlighted:`<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

models = [
    <span class="hljs-string">&quot;xlm-roberta-large-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;dbmdz/bert-large-cased-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;elastic/distilbert-base-uncased-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;dbmdz/electra-large-discriminator-finetuned-conll03-english&quot;</span>,
    <span class="hljs-string">&quot;gunghio/distilbert-base-multilingual-cased-finetuned-conll2003-ner&quot;</span>,
    <span class="hljs-string">&quot;philschmid/distilroberta-base-ner-conll2003&quot;</span>,
    <span class="hljs-string">&quot;Jorgeutd/albert-base-v2-finetuned-ner&quot;</span>,
]

data = load_dataset(<span class="hljs-string">&quot;conll2003&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>).shuffle().select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
task_evaluator = evaluator(<span class="hljs-string">&quot;token-classification&quot;</span>)

results = []
<span class="hljs-keyword">for</span> model <span class="hljs-keyword">in</span> models:
    results.append(
        task_evaluator.compute(
            model_or_pipeline=model, data=data, metric=<span class="hljs-string">&quot;seqeval&quot;</span>
            )
        )

df = pd.DataFrame(results, index=models)
df[[<span class="hljs-string">&quot;overall_f1&quot;</span>, <span class="hljs-string">&quot;overall_accuracy&quot;</span>, <span class="hljs-string">&quot;total_time_in_seconds&quot;</span>, <span class="hljs-string">&quot;samples_per_second&quot;</span>, <span class="hljs-string">&quot;latency_in_seconds&quot;</span>]]`,wrap:!1}}),O=new M({props:{title:"Visualizing results",local:"visualizing-results",headingTag:"h3"}}),te=new U({props:{code:"JTBBcGxvdCUyMCUzRCUyMHJhZGFyX3Bsb3QoZGF0YSUzRHJlc3VsdHMlMkMlMjBtb2RlbF9uYW1lcyUzRG1vZGVscyUyQyUyMGludmVydF9yYW5nZSUzRCU1QiUyMmxhdGVuY3lfaW5fc2Vjb25kcyUyMiU1RCklMEFwbG90LnNob3coKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate
<span class="hljs-keyword">from</span> evaluate.visualization <span class="hljs-keyword">import</span> radar_plot

<span class="hljs-meta">&gt;&gt;&gt; </span>plot = radar_plot(data=results, model_names=models, invert_range=[<span class="hljs-string">&quot;latency_in_seconds&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>plot.show()`,wrap:!1}}),se=new M({props:{title:"Question Answering",local:"question-answering",headingTag:"h2"}}),ce=new M({props:{title:"Confidence intervals",local:"confidence-intervals",headingTag:"h3"}}),ue=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwZXZhbHVhdG9yJTBBJTBBdGFza19ldmFsdWF0b3IlMjAlM0QlMjBldmFsdWF0b3IoJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQSUwQWRhdGElMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyc3F1YWQlMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0ExMDAwJTVEJTIyKSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0QlMjJkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1kaXN0aWxsZWQtc3F1YWQlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRhJTNEZGF0YSUyQyUwQSUyMCUyMCUyMCUyMG1ldHJpYyUzRCUyMnNxdWFkJTIyJTJDJTBBJTIwJTIwJTIwJTIwc3RyYXRlZ3klM0QlMjJib290c3RyYXAlMjIlMkMlMEElMjAlMjAlMjAlMjBuX3Jlc2FtcGxlcyUzRDMwJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> evaluator

task_evaluator = evaluator(<span class="hljs-string">&quot;question-answering&quot;</span>)

data = load_dataset(<span class="hljs-string">&quot;squad&quot;</span>, split=<span class="hljs-string">&quot;validation[:1000]&quot;</span>)
eval_results = task_evaluator.compute(
    model_or_pipeline=<span class="hljs-string">&quot;distilbert-base-uncased-distilled-squad&quot;</span>,
    data=data,
    metric=<span class="hljs-string">&quot;squad&quot;</span>,
    strategy=<span class="hljs-string">&quot;bootstrap&quot;</span>,
    n_resamples=<span class="hljs-number">30</span>
)`,wrap:!1}}),de=new U({props:{code:"JTdCJTBBJTIwJTIwJTIwJTIwJ2V4YWN0X21hdGNoJyUzQSUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdjb25maWRlbmNlX2ludGVydmFsJyUzQSUyMCg3OS42NyUyQyUyMDg0LjU0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzY29yZSclM0ElMjA4Mi4zMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzdGFuZGFyZF9lcnJvciclM0ElMjAxLjI4JTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJ2YxJyUzQSUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdjb25maWRlbmNlX2ludGVydmFsJyUzQSUyMCg4NS4zMCUyQyUyMDg4Ljg4KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzY29yZSclM0ElMjA4Ny4yMyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCdzdGFuZGFyZF9lcnJvciclM0ElMjAwLjk3JTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJ2xhdGVuY3lfaW5fc2Vjb25kcyclM0ElMjAwLjAwODUlMkMlMEElMjAlMjAlMjAlMjAnc2FtcGxlc19wZXJfc2Vjb25kJyUzQSUyMDExNy4zMSUyQyUwQSUyMCUyMCUyMCUyMCd0b3RhbF90aW1lX2luX3NlY29uZHMnJTNBJTIwOC41MiUwQSUyMCU3RA==",highlighted:`{
    <span class="hljs-string">&#x27;exact_match&#x27;</span>:
    {
        <span class="hljs-string">&#x27;confidence_interval&#x27;</span>: (<span class="hljs-number">79.67</span>, <span class="hljs-number">84.54</span>),
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">82.30</span>,
        <span class="hljs-string">&#x27;standard_error&#x27;</span>: <span class="hljs-number">1.28</span>
    },
    <span class="hljs-string">&#x27;f1&#x27;</span>:
    {
        <span class="hljs-string">&#x27;confidence_interval&#x27;</span>: (<span class="hljs-number">85.30</span>, <span class="hljs-number">88.88</span>),
        <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">87.23</span>,
        <span class="hljs-string">&#x27;standard_error&#x27;</span>: <span class="hljs-number">0.97</span>
    },
    <span class="hljs-string">&#x27;latency_in_seconds&#x27;</span>: <span class="hljs-number">0.0085</span>,
    <span class="hljs-string">&#x27;samples_per_second&#x27;</span>: <span class="hljs-number">117.31</span>,
    <span class="hljs-string">&#x27;total_time_in_seconds&#x27;</span>: <span class="hljs-number">8.52</span>
 }`,wrap:!1}}),he=new M({props:{title:"Image classification",local:"image-classification",headingTag:"h2"}}),Ue=new M({props:{title:"Handling large datasets",local:"handling-large-datasets",headingTag:"h3"}}),we=new U({props:{code:"ZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJpbWFnZW5ldC0xayUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiUyQyUyMHRva2VuJTNEVHJ1ZSklMEElMEFwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwdGFzayUzRCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0QlMjJmYWNlYm9vayUyRmRlaXQtc21hbGwtZGlzdGlsbGVkLXBhdGNoMTYtMjI0JTIyJTBBKSUwQSUwQXRhc2tfZXZhbHVhdG9yJTIwJTNEJTIwZXZhbHVhdG9yKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyKSUwQWV2YWxfcmVzdWx0cyUyMCUzRCUyMHRhc2tfZXZhbHVhdG9yLmNvbXB1dGUoJTBBJTIwJTIwJTIwJTIwbW9kZWxfb3JfcGlwZWxpbmUlM0RwaXBlJTJDJTBBJTIwJTIwJTIwJTIwZGF0YSUzRGRhdGElMkMlMEElMjAlMjAlMjAlMjBtZXRyaWMlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX21hcHBpbmclM0RwaXBlLm1vZGVsLmNvbmZpZy5sYWJlbDJpZCUwQSk=",highlighted:`data = load_dataset(<span class="hljs-string">&quot;imagenet-1k&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>, token=<span class="hljs-literal">True</span>)

pipe = pipeline(
    task=<span class="hljs-string">&quot;image-classification&quot;</span>,
    model=<span class="hljs-string">&quot;facebook/deit-small-distilled-patch16-224&quot;</span>
)

task_evaluator = evaluator(<span class="hljs-string">&quot;image-classification&quot;</span>)
eval_results = task_evaluator.compute(
    model_or_pipeline=pipe,
    data=data,
    metric=<span class="hljs-string">&quot;accuracy&quot;</span>,
    label_mapping=pipe.model.config.label2id
)`,wrap:!1}}),Je=new vl({props:{source:"https://github.com/huggingface/evaluate/blob/main/docs/source/base_evaluator.mdx"}}),{c(){y=i("meta"),je=s(),ge=i("p"),Ce=s(),p(J.$$.fragment),xe=s(),g=i("p"),g.innerHTML=Wt,Ie=s(),T=i("p"),T.textContent=Gt,ke=s(),v=i("ul"),v.innerHTML=Bt,_e=s(),j=i("p"),j.innerHTML=$t,Ze=s(),C=i("p"),C.textContent=Et,qe=s(),p(x.$$.fragment),We=s(),I=i("p"),I.textContent=Qt,Ge=s(),k=i("ul"),k.innerHTML=Rt,Be=s(),_=i("p"),_.innerHTML=Xt,$e=s(),p(Z.$$.fragment),Ee=s(),q=i("p"),q.innerHTML=Yt,Qe=s(),W=i("p"),W.textContent=St,Re=s(),p(G.$$.fragment),Xe=s(),f=i("blockquote"),f.innerHTML=Vt,Ye=s(),B=i("p"),B.textContent=Nt,Se=s(),p($.$$.fragment),Ve=s(),E=i("p"),E.textContent=zt,Ne=s(),w=i("blockquote"),w.innerHTML=Ft,ze=s(),p(Q.$$.fragment),Fe=s(),R=i("p"),R.innerHTML=At,Ae=s(),p(X.$$.fragment),He=s(),Y=i("p"),Y.textContent=Ht,Le=s(),p(S.$$.fragment),De=s(),V=i("p"),V.textContent=Lt,Pe=s(),p(N.$$.fragment),Ke=s(),z=i("p"),z.textContent=Dt,Oe=s(),F=i("ul"),F.innerHTML=Pt,et=s(),A=i("p"),A.textContent=Kt,tt=s(),p(H.$$.fragment),lt=s(),L=i("p"),L.innerHTML=Ot,at=s(),p(D.$$.fragment),st=s(),P=i("p"),P.textContent=el,nt=s(),K=i("table"),K.innerHTML=tl,it=s(),p(O.$$.fragment),ot=s(),ee=i("p"),ee.innerHTML=ll,ct=s(),p(te.$$.fragment),pt=s(),b=i("div"),b.innerHTML=al,ut=s(),le=i("p"),le.innerHTML=sl,rt=s(),ae=i("p"),ae.innerHTML=nl,dt=s(),p(se.$$.fragment),ht=s(),ne=i("p"),ne.textContent=il,mt=s(),ie=i("ul"),ie.innerHTML=ol,Mt=s(),oe=i("p"),oe.textContent=cl,yt=s(),p(ce.$$.fragment),Ut=s(),pe=i("p"),pe.innerHTML=pl,ft=s(),p(ue.$$.fragment),wt=s(),re=i("p"),re.textContent=ul,bt=s(),p(de.$$.fragment),Jt=s(),p(he.$$.fragment),gt=s(),me=i("p"),me.textContent=rl,Tt=s(),Me=i("ul"),Me.innerHTML=dl,vt=s(),ye=i("p"),ye.textContent=hl,jt=s(),p(Ue.$$.fragment),Ct=s(),fe=i("p"),fe.textContent=ml,xt=s(),p(we.$$.fragment),It=s(),be=i("p"),be.innerHTML=Ml,kt=s(),p(Je.$$.fragment),_t=s(),Te=i("p"),this.h()},l(e){const t=gl("svelte-u9bgzb",document.head);y=o(t,"META",{name:!0,content:!0}),t.forEach(l),je=n(e),ge=o(e,"P",{}),yl(ge).forEach(l),Ce=n(e),u(J.$$.fragment,e),xe=n(e),g=o(e,"P",{"data-svelte-h":!0}),c(g)!=="svelte-qprdpr"&&(g.innerHTML=Wt),Ie=n(e),T=o(e,"P",{"data-svelte-h":!0}),c(T)!=="svelte-15teb2a"&&(T.textContent=Gt),ke=n(e),v=o(e,"UL",{"data-svelte-h":!0}),c(v)!=="svelte-1srkakb"&&(v.innerHTML=Bt),_e=n(e),j=o(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-7bnn4r"&&(j.innerHTML=$t),Ze=n(e),C=o(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-4inrih"&&(C.textContent=Et),qe=n(e),u(x.$$.fragment,e),We=n(e),I=o(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1gxq28j"&&(I.textContent=Qt),Ge=n(e),k=o(e,"UL",{"data-svelte-h":!0}),c(k)!=="svelte-1qzzvz5"&&(k.innerHTML=Rt),Be=n(e),_=o(e,"P",{"data-svelte-h":!0}),c(_)!=="svelte-15gevtk"&&(_.innerHTML=Xt),$e=n(e),u(Z.$$.fragment,e),Ee=n(e),q=o(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-154vxj0"&&(q.innerHTML=Yt),Qe=n(e),W=o(e,"P",{"data-svelte-h":!0}),c(W)!=="svelte-1b2vk7d"&&(W.textContent=St),Re=n(e),u(G.$$.fragment,e),Xe=n(e),f=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(f)!=="svelte-725r0a"&&(f.innerHTML=Vt),Ye=n(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-15lc2ym"&&(B.textContent=Nt),Se=n(e),u($.$$.fragment,e),Ve=n(e),E=o(e,"P",{"data-svelte-h":!0}),c(E)!=="svelte-15s0v89"&&(E.textContent=zt),Ne=n(e),w=o(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),c(w)!=="svelte-1baxlti"&&(w.innerHTML=Ft),ze=n(e),u(Q.$$.fragment,e),Fe=n(e),R=o(e,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1sfvd91"&&(R.innerHTML=At),Ae=n(e),u(X.$$.fragment,e),He=n(e),Y=o(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-15lc2ym"&&(Y.textContent=Ht),Le=n(e),u(S.$$.fragment,e),De=n(e),V=o(e,"P",{"data-svelte-h":!0}),c(V)!=="svelte-dtvqwy"&&(V.textContent=Lt),Pe=n(e),u(N.$$.fragment,e),Ke=n(e),z=o(e,"P",{"data-svelte-h":!0}),c(z)!=="svelte-geubj8"&&(z.textContent=Dt),Oe=n(e),F=o(e,"UL",{"data-svelte-h":!0}),c(F)!=="svelte-1el9bak"&&(F.innerHTML=Pt),et=n(e),A=o(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-1ufl7ls"&&(A.textContent=Kt),tt=n(e),u(H.$$.fragment,e),lt=n(e),L=o(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-yjocce"&&(L.innerHTML=Ot),at=n(e),u(D.$$.fragment,e),st=n(e),P=o(e,"P",{"data-svelte-h":!0}),c(P)!=="svelte-xdkq6d"&&(P.textContent=el),nt=n(e),K=o(e,"TABLE",{"data-svelte-h":!0}),c(K)!=="svelte-w5xmg2"&&(K.innerHTML=tl),it=n(e),u(O.$$.fragment,e),ot=n(e),ee=o(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-105xi6e"&&(ee.innerHTML=ll),ct=n(e),u(te.$$.fragment,e),pt=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),c(b)!=="svelte-gubqhj"&&(b.innerHTML=al),ut=n(e),le=o(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-6fiehk"&&(le.innerHTML=sl),rt=n(e),ae=o(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-13ag5wi"&&(ae.innerHTML=nl),dt=n(e),u(se.$$.fragment,e),ht=n(e),ne=o(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1b3dqfk"&&(ne.textContent=il),mt=n(e),ie=o(e,"UL",{"data-svelte-h":!0}),c(ie)!=="svelte-tbjiyo"&&(ie.innerHTML=ol),Mt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-vay9sj"&&(oe.textContent=cl),yt=n(e),u(ce.$$.fragment,e),Ut=n(e),pe=o(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-mw7fge"&&(pe.innerHTML=pl),ft=n(e),u(ue.$$.fragment,e),wt=n(e),re=o(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-x62g11"&&(re.textContent=ul),bt=n(e),u(de.$$.fragment,e),Jt=n(e),u(he.$$.fragment,e),gt=n(e),me=o(e,"P",{"data-svelte-h":!0}),c(me)!=="svelte-ksrm73"&&(me.textContent=rl),Tt=n(e),Me=o(e,"UL",{"data-svelte-h":!0}),c(Me)!=="svelte-y0u0z3"&&(Me.innerHTML=dl),vt=n(e),ye=o(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-wu4hrz"&&(ye.textContent=hl),jt=n(e),u(Ue.$$.fragment,e),Ct=n(e),fe=o(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1ewtkuj"&&(fe.textContent=ml),xt=n(e),u(we.$$.fragment,e),It=n(e),be=o(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1lgn5m5"&&(be.innerHTML=Ml),kt=n(e),u(Je.$$.fragment,e),_t=n(e),Te=o(e,"P",{}),yl(Te).forEach(l),this.h()},h(){ve(y,"name","hf:doc:metadata"),ve(y,"content",Cl),ve(f,"class","tip"),ve(w,"class","tip"),ve(b,"class","flex justify-center")},m(e,t){Tl(document.head,y),a(e,je,t),a(e,ge,t),a(e,Ce,t),r(J,e,t),a(e,xe,t),a(e,g,t),a(e,Ie,t),a(e,T,t),a(e,ke,t),a(e,v,t),a(e,_e,t),a(e,j,t),a(e,Ze,t),a(e,C,t),a(e,qe,t),r(x,e,t),a(e,We,t),a(e,I,t),a(e,Ge,t),a(e,k,t),a(e,Be,t),a(e,_,t),a(e,$e,t),r(Z,e,t),a(e,Ee,t),a(e,q,t),a(e,Qe,t),a(e,W,t),a(e,Re,t),r(G,e,t),a(e,Xe,t),a(e,f,t),a(e,Ye,t),a(e,B,t),a(e,Se,t),r($,e,t),a(e,Ve,t),a(e,E,t),a(e,Ne,t),a(e,w,t),a(e,ze,t),r(Q,e,t),a(e,Fe,t),a(e,R,t),a(e,Ae,t),r(X,e,t),a(e,He,t),a(e,Y,t),a(e,Le,t),r(S,e,t),a(e,De,t),a(e,V,t),a(e,Pe,t),r(N,e,t),a(e,Ke,t),a(e,z,t),a(e,Oe,t),a(e,F,t),a(e,et,t),a(e,A,t),a(e,tt,t),r(H,e,t),a(e,lt,t),a(e,L,t),a(e,at,t),r(D,e,t),a(e,st,t),a(e,P,t),a(e,nt,t),a(e,K,t),a(e,it,t),r(O,e,t),a(e,ot,t),a(e,ee,t),a(e,ct,t),r(te,e,t),a(e,pt,t),a(e,b,t),a(e,ut,t),a(e,le,t),a(e,rt,t),a(e,ae,t),a(e,dt,t),r(se,e,t),a(e,ht,t),a(e,ne,t),a(e,mt,t),a(e,ie,t),a(e,Mt,t),a(e,oe,t),a(e,yt,t),r(ce,e,t),a(e,Ut,t),a(e,pe,t),a(e,ft,t),r(ue,e,t),a(e,wt,t),a(e,re,t),a(e,bt,t),r(de,e,t),a(e,Jt,t),r(he,e,t),a(e,gt,t),a(e,me,t),a(e,Tt,t),a(e,Me,t),a(e,vt,t),a(e,ye,t),a(e,jt,t),r(Ue,e,t),a(e,Ct,t),a(e,fe,t),a(e,xt,t),r(we,e,t),a(e,It,t),a(e,be,t),a(e,kt,t),r(Je,e,t),a(e,_t,t),a(e,Te,t),Zt=!0},p:fl,i(e){Zt||(d(J.$$.fragment,e),d(x.$$.fragment,e),d(Z.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(X.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ce.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Ue.$$.fragment,e),d(we.$$.fragment,e),d(Je.$$.fragment,e),Zt=!0)},o(e){h(J.$$.fragment,e),h(x.$$.fragment,e),h(Z.$$.fragment,e),h(G.$$.fragment,e),h($.$$.fragment,e),h(Q.$$.fragment,e),h(X.$$.fragment,e),h(S.$$.fragment,e),h(N.$$.fragment,e),h(H.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(se.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(de.$$.fragment,e),h(he.$$.fragment,e),h(Ue.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),Zt=!1},d(e){e&&(l(je),l(ge),l(Ce),l(xe),l(g),l(Ie),l(T),l(ke),l(v),l(_e),l(j),l(Ze),l(C),l(qe),l(We),l(I),l(Ge),l(k),l(Be),l(_),l($e),l(Ee),l(q),l(Qe),l(W),l(Re),l(Xe),l(f),l(Ye),l(B),l(Se),l(Ve),l(E),l(Ne),l(w),l(ze),l(Fe),l(R),l(Ae),l(He),l(Y),l(Le),l(De),l(V),l(Pe),l(Ke),l(z),l(Oe),l(F),l(et),l(A),l(tt),l(lt),l(L),l(at),l(st),l(P),l(nt),l(K),l(it),l(ot),l(ee),l(ct),l(pt),l(b),l(ut),l(le),l(rt),l(ae),l(dt),l(ht),l(ne),l(mt),l(ie),l(Mt),l(oe),l(yt),l(Ut),l(pe),l(ft),l(wt),l(re),l(bt),l(Jt),l(gt),l(me),l(Tt),l(Me),l(vt),l(ye),l(jt),l(Ct),l(fe),l(xt),l(It),l(be),l(kt),l(_t),l(Te)),l(y),m(J,e),m(x,e),m(Z,e),m(G,e),m($,e),m(Q,e),m(X,e),m(S,e),m(N,e),m(H,e),m(D,e),m(O,e),m(te,e),m(se,e),m(ce,e),m(ue,e),m(de,e),m(he,e),m(Ue,e),m(we,e),m(Je,e)}}}const Cl='{"title":"Using the evaluator","local":"using-the-evaluator","sections":[{"title":"Text classification","local":"text-classification","sections":[{"title":"Evaluate models on the Hub","local":"evaluate-models-on-the-hub","sections":[],"depth":3},{"title":"Evaluate multiple metrics","local":"evaluate-multiple-metrics","sections":[],"depth":3}],"depth":2},{"title":"Token Classification","local":"token-classification","sections":[{"title":"Benchmarking several models","local":"benchmarking-several-models","sections":[],"depth":3},{"title":"Visualizing results","local":"visualizing-results","sections":[],"depth":3}],"depth":2},{"title":"Question Answering","local":"question-answering","sections":[{"title":"Confidence intervals","local":"confidence-intervals","sections":[],"depth":3}],"depth":2},{"title":"Image classification","local":"image-classification","sections":[{"title":"Handling large datasets","local":"handling-large-datasets","sections":[],"depth":3}],"depth":2}],"depth":1}';function xl(qt){return wl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ql extends bl{constructor(y){super(),Jl(this,y,xl,jl,Ul,{})}}export{ql as component};
