import{s as We,n as ve,o as Fe}from"../chunks/scheduler.c59d9fbb.js";import{S as Ze,i as $e,g as i,s,r as d,A as Re,h as r,f as a,c as n,j as _e,u as p,x as o,k as Ie,y as Ge,a as l,v as m,d as M,t as f,w as b}from"../chunks/index.a47918e3.js";import{C as me}from"../chunks/CodeBlock.936db8cd.js";import{H as S}from"../chunks/Heading.604bc707.js";function Qe(Me){let c,X,x,H,h,A,y,fe="SetFit models can be influenced by callbacks, for example for logging or early stopping.",E,u,be="This guide will show you what they are and how they can be used.",N,T,q,g,he='Callbacks are objects that customize the behaviour of the training loop in the SetFit <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.Trainer">Trainer</a> that can inspect the training loop state (for progress reporting, logging, inspecting embeddings during training) and take decisions (e.g. early stopping).',z,w,ye='In particular, the <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.Trainer">Trainer</a> uses a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerControl" rel="nofollow"><code>TrainerControl</code></a> that can be influenced by callbacks to stop training, save models, evaluate, or log, and a <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerState" rel="nofollow"><code>TrainerState</code></a> which tracks some training loop metrics during training, such as the number of training steps so far.',L,J,ue='SetFit relies on the Callbacks implemented in <code>transformers</code>, as described in the <code>transformers</code> documentation <a href="https://huggingface.co/docs/transformers/main_classes/callback" rel="nofollow">here</a>.',V,U,P,C,Te='SetFit uses the <code>TrainingArguments.report_to</code> argument to specify which of the built-in callbacks should be enabled. This argument defaults to <code>&quot;all&quot;</code>, meaning that all third-party callbacks from <code>transformers</code> that are also installed will be enabled. For example the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.TensorBoardCallback" rel="nofollow"><code>TensorBoardCallback</code></a> or the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.integrations.WandbCallback" rel="nofollow"><code>WandbCallback</code></a>.',D,j,ge='Beyond that, the <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.PrinterCallback" rel="nofollow"><code>PrinterCallback</code></a> or <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.ProgressCallback" rel="nofollow"><code>ProgressCallback</code></a> is always enabled to show the training progress, and <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.DefaultFlowCallback" rel="nofollow"><code>DefaultFlowCallback</code></a> is also always enabled to properly update the <code>TrainerControl</code>.',K,k,O,_,we="As mentioned, you can use <code>TrainingArguments.report_to</code> to specify exactly which callbacks you would like to enable. For example:",ee,I,te,W,Je='You can also use <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.DistillationTrainer.add_callback">Trainer.add_callback()</a>, <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.DistillationTrainer.pop_callback">Trainer.pop_callback()</a> and <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.DistillationTrainer.remove_callback">Trainer.remove_callback()</a> to influence the trainer callbacks, and you can specify callbacks via the <a href="/docs/setfit/v1.0.0/en/reference/trainer#setfit.Trainer">Trainer</a> init, e.g.:',ae,v,le,F,se,Z,Ue='SetFit supports custom callbacks in the same way that <code>transformers</code> does: by subclassing <a href="https://huggingface.co/docs/transformers/main_classes/callback#transformers.TrainerCallback" rel="nofollow"><code>TrainerCallback</code></a>. This class implements a lot of <code>on_...</code> methods that can be overridden. For example, the following script shows a custom callback that saves plots of the tSNE of the training and evaluation embeddings during training.',ne,$,ie,R,Ce="with",re,G,oe,Q,je="The <code>on_evaluate</code> from <code>EmbeddingPlotCallback</code> will be triggered on every single evaluation call. In the case of this example, it resulted in the following figures being plotted:",ce,Y,ke='<thead><tr><th>Step 20</th> <th>Step 40</th></tr></thead> <tbody><tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/7200d00a-fd48-4038-bcbe-f2d5f1280162" alt="step_20"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/be12e3c4-867c-452d-89a0-0677f035516d" alt="step_40"/></td></tr> <tr><td><strong>Step 60</strong></td> <td><strong>Step 80</strong></td></tr> <tr><td><img src="https://github.com/huggingface/setfit/assets/37621491/3a384aa2-51ce-40d7-b02c-a2c986f3aeb4" alt="step_60"/></td> <td><img src="https://github.com/huggingface/setfit/assets/37621491/b5aa9835-40cb-4327-9f31-b3ababeca769" alt="step_80"/></td></tr></tbody>',de,B,pe;return h=new S({props:{title:"Callbacks",local:"callbacks",headingTag:"h1"}}),T=new S({props:{title:"Callbacks in SetFit",local:"callbacks-in-setfit",headingTag:"h2"}}),U=new S({props:{title:"Default Callbacks",local:"default-callbacks",headingTag:"h2"}}),k=new S({props:{title:"Using Callbacks",local:"using-callbacks",headingTag:"h2"}}),I=new me({props:{code:"ZnJvbSUyMHNldGZpdCUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCUyMndhbmRiJTIyJTJDJTBBJTIwJTIwJTIwJTIwLi4uJTJDJTBBKSUwQSUyMyUyMG9yJTIwJTBBYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHJlcG9ydF90byUzRCU1QiUyMndhbmRiJTIyJTJDJTIwJTIydGVuc29yYm9hcmQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAuLi4lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> TrainingArguments

args = TrainingArguments(
    ...,
    report_to=<span class="hljs-string">&quot;wandb&quot;</span>,
    ...,
)
<span class="hljs-comment"># or </span>
args = TrainingArguments(
    ...,
    report_to=[<span class="hljs-string">&quot;wandb&quot;</span>, <span class="hljs-string">&quot;tensorboard&quot;</span>],
    ...,
)`,wrap:!1}}),v=new me({props:{code:"JTBB",highlighted:`<span class="hljs-keyword">from</span> setfit <span class="hljs-keyword">import</span> Trainer

...

trainer = Trainer(
    model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EarlyStoppingCallback(early_stopping_patience=<span class="hljs-number">5</span>)],
)
trainer.train()`,wrap:!1}}),F=new S({props:{title:"Custom Callbacks",local:"custom-callbacks",headingTag:"h2"}}),$=new me({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">from</span> sklearn.manifold <span class="hljs-keyword">import</span> TSNE

<span class="hljs-keyword">class</span> <span class="hljs-title class_">EmbeddingPlotCallback</span>(<span class="hljs-title class_ inherited__">TrainerCallback</span>):
    <span class="hljs-string">&quot;&quot;&quot;Simple embedding plotting callback that plots the tSNE of the training and evaluation datasets throughout training.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">on_evaluate</span>(<span class="hljs-params">self, args: TrainingArguments, state: TrainerState, control: TrainerControl, model: SetFitModel, **kwargs</span>):
        train_embeddings = model.encode(train_dataset[<span class="hljs-string">&quot;text&quot;</span>])
        eval_embeddings = model.encode(eval_dataset[<span class="hljs-string">&quot;text&quot;</span>])

        fig, (train_ax, eval_ax) = plt.subplots(ncols=<span class="hljs-number">2</span>)

        train_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(train_embeddings)
        train_ax.scatter(*train_X.T, c=train_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=train_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        train_ax.set_title(<span class="hljs-string">&quot;Training embeddings&quot;</span>)

        eval_X = TSNE(n_components=<span class="hljs-number">2</span>).fit_transform(eval_embeddings)
        eval_ax.scatter(*eval_X.T, c=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>], label=eval_dataset[<span class="hljs-string">&quot;label&quot;</span>])
        eval_ax.set_title(<span class="hljs-string">&quot;Evaluation embeddings&quot;</span>)

        fig.suptitle(<span class="hljs-string">f&quot;tSNE of training and evaluation embeddings at step <span class="hljs-subst">{state.global_step}</span> of <span class="hljs-subst">{state.max_steps}</span>.&quot;</span>)
        fig.savefig(<span class="hljs-string">f&quot;logs/step_<span class="hljs-subst">{state.global_step}</span>.png&quot;</span>)`,wrap:!1}}),G=new me({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0RhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjYWxsYmFja3MlM0QlNUJFbWJlZGRpbmdQbG90Q2FsbGJhY2soKSU1RCUwQSklMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`trainer = Trainer(
    model=model,
    args=args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
    callbacks=[EmbeddingPlotCallback()]
)
trainer.train()`,wrap:!1}}),{c(){c=i("meta"),X=s(),x=i("p"),H=s(),d(h.$$.fragment),A=s(),y=i("p"),y.textContent=fe,E=s(),u=i("p"),u.textContent=be,N=s(),d(T.$$.fragment),q=s(),g=i("p"),g.innerHTML=he,z=s(),w=i("p"),w.innerHTML=ye,L=s(),J=i("p"),J.innerHTML=ue,V=s(),d(U.$$.fragment),P=s(),C=i("p"),C.innerHTML=Te,D=s(),j=i("p"),j.innerHTML=ge,K=s(),d(k.$$.fragment),O=s(),_=i("p"),_.innerHTML=we,ee=s(),d(I.$$.fragment),te=s(),W=i("p"),W.innerHTML=Je,ae=s(),d(v.$$.fragment),le=s(),d(F.$$.fragment),se=s(),Z=i("p"),Z.innerHTML=Ue,ne=s(),d($.$$.fragment),ie=s(),R=i("p"),R.textContent=Ce,re=s(),d(G.$$.fragment),oe=s(),Q=i("p"),Q.innerHTML=je,ce=s(),Y=i("table"),Y.innerHTML=ke,de=s(),B=i("p"),this.h()},l(e){const t=Re("svelte-u9bgzb",document.head);c=r(t,"META",{name:!0,content:!0}),t.forEach(a),X=n(e),x=r(e,"P",{}),_e(x).forEach(a),H=n(e),p(h.$$.fragment,e),A=n(e),y=r(e,"P",{"data-svelte-h":!0}),o(y)!=="svelte-1qsyej"&&(y.textContent=fe),E=n(e),u=r(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-1neobwt"&&(u.textContent=be),N=n(e),p(T.$$.fragment,e),q=n(e),g=r(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-mskx5l"&&(g.innerHTML=he),z=n(e),w=r(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-r93xik"&&(w.innerHTML=ye),L=n(e),J=r(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-m6jr23"&&(J.innerHTML=ue),V=n(e),p(U.$$.fragment,e),P=n(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1d5its4"&&(C.innerHTML=Te),D=n(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-195z5eh"&&(j.innerHTML=ge),K=n(e),p(k.$$.fragment,e),O=n(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-9jofl1"&&(_.innerHTML=we),ee=n(e),p(I.$$.fragment,e),te=n(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1ej4pjd"&&(W.innerHTML=Je),ae=n(e),p(v.$$.fragment,e),le=n(e),p(F.$$.fragment,e),se=n(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1a0isl"&&(Z.innerHTML=Ue),ne=n(e),p($.$$.fragment,e),ie=n(e),R=r(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1jtaf10"&&(R.textContent=Ce),re=n(e),p(G.$$.fragment,e),oe=n(e),Q=r(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-14nrepa"&&(Q.innerHTML=je),ce=n(e),Y=r(e,"TABLE",{"data-svelte-h":!0}),o(Y)!=="svelte-g475cj"&&(Y.innerHTML=ke),de=n(e),B=r(e,"P",{}),_e(B).forEach(a),this.h()},h(){Ie(c,"name","hf:doc:metadata"),Ie(c,"content",Ye)},m(e,t){Ge(document.head,c),l(e,X,t),l(e,x,t),l(e,H,t),m(h,e,t),l(e,A,t),l(e,y,t),l(e,E,t),l(e,u,t),l(e,N,t),m(T,e,t),l(e,q,t),l(e,g,t),l(e,z,t),l(e,w,t),l(e,L,t),l(e,J,t),l(e,V,t),m(U,e,t),l(e,P,t),l(e,C,t),l(e,D,t),l(e,j,t),l(e,K,t),m(k,e,t),l(e,O,t),l(e,_,t),l(e,ee,t),m(I,e,t),l(e,te,t),l(e,W,t),l(e,ae,t),m(v,e,t),l(e,le,t),m(F,e,t),l(e,se,t),l(e,Z,t),l(e,ne,t),m($,e,t),l(e,ie,t),l(e,R,t),l(e,re,t),m(G,e,t),l(e,oe,t),l(e,Q,t),l(e,ce,t),l(e,Y,t),l(e,de,t),l(e,B,t),pe=!0},p:ve,i(e){pe||(M(h.$$.fragment,e),M(T.$$.fragment,e),M(U.$$.fragment,e),M(k.$$.fragment,e),M(I.$$.fragment,e),M(v.$$.fragment,e),M(F.$$.fragment,e),M($.$$.fragment,e),M(G.$$.fragment,e),pe=!0)},o(e){f(h.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(k.$$.fragment,e),f(I.$$.fragment,e),f(v.$$.fragment,e),f(F.$$.fragment,e),f($.$$.fragment,e),f(G.$$.fragment,e),pe=!1},d(e){e&&(a(X),a(x),a(H),a(A),a(y),a(E),a(u),a(N),a(q),a(g),a(z),a(w),a(L),a(J),a(V),a(P),a(C),a(D),a(j),a(K),a(O),a(_),a(ee),a(te),a(W),a(ae),a(le),a(se),a(Z),a(ne),a(ie),a(R),a(re),a(oe),a(Q),a(ce),a(Y),a(de),a(B)),a(c),b(h,e),b(T,e),b(U,e),b(k,e),b(I,e),b(v,e),b(F,e),b($,e),b(G,e)}}}const Ye='{"title":"Callbacks","local":"callbacks","sections":[{"title":"Callbacks in SetFit","local":"callbacks-in-setfit","sections":[],"depth":2},{"title":"Default Callbacks","local":"default-callbacks","sections":[],"depth":2},{"title":"Using Callbacks","local":"using-callbacks","sections":[],"depth":2},{"title":"Custom Callbacks","local":"custom-callbacks","sections":[],"depth":2}],"depth":1}';function xe(Me){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ae extends Ze{constructor(c){super(),$e(this,c,xe,Qe,We,{})}}export{Ae as component};
