import{s as Ut,n as It,o as $t}from"../chunks/scheduler.85c25b89.js";import{S as Zt,i as kt,g as p,s as l,r as i,A as Ct,h as m,f as e,c as n,j as ft,u as o,x as M,k as bt,y as Wt,a,v as r,d as c,t as h,w as g}from"../chunks/index.c9bcf812.js";import{C as V}from"../chunks/CodeBlock.94efc595.js";import{H as _}from"../chunks/Heading.3c6e5b17.js";function Nt(ct){let J,R,Q,Y,j,S,w,ht='<strong>SK ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs a <a href="https://paperswithcode.com/method/selective-kernel" rel="nofollow">Selective Kernel</a> unit. In general, all the large kernel convolutions in the original bottleneck blocks in ResNet are replaced by the proposed <a href="https://paperswithcode.com/method/selective-kernel-convolution" rel="nofollow">SK convolutions</a>, enabling the network to choose appropriate receptive field sizes in an adaptive manner.',A,d,z,T,gt="To load a pretrained model:",H,y,F,u,Mt="To load and preprocess the image:",L,f,q,b,Jt="To get the model predictions:",D,U,P,I,jt="To get the top-5 predictions class names:",K,$,O,Z,wt="Replace the model name with the variant you want to use, e.g. <code>skresnet18</code>. You can find the IDs in the model summaries at the top of this page.",tt,k,dt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,C,et,W,Tt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",at,N,lt,x,yt=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,B,pt,v,ut='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,G,it,E,ot,X,rt;return j=new _({props:{title:"SK-ResNet",local:"sk-resnet",headingTag:"h1"}}),d=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),y=new V({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3NrcmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new V({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new V({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),$=new V({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),C=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new V({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc2tyZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;skresnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),B=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),G=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),E=new V({props:{code:"JTQwbWlzYyU3QmxpMjAxOXNlbGVjdGl2ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHRpdGxlJTNEJTdCU2VsZWN0aXZlJTIwS2VybmVsJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JYaWFuZyUyMExpJTIwYW5kJTIwV2VuaGFpJTIwV2FuZyUyMGFuZCUyMFhpYW9saW4lMjBIdSUyMGFuZCUyMEppYW4lMjBZYW5nJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIweWVhciUzRCU3QjIwMTklN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjBlcHJpbnQlM0QlN0IxOTAzLjA2NTg2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwYXJjaGl2ZVByZWZpeCUzRCU3QmFyWGl2JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwcHJpbWFyeUNsYXNzJTNEJTdCY3MuQ1YlN0QlMEElN0Q=",highlighted:`<span class="language-xml">@misc</span><span class="hljs-template-variable">{li2019selective,
      title={Selective Kernel Networks}</span><span class="language-xml">, 
      author=</span><span class="hljs-template-variable">{Xiang Li and Wenhai Wang and Xiaolin Hu and Jian Yang}</span><span class="language-xml">,
      year=</span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
      eprint=</span><span class="hljs-template-variable">{1903.06586}</span><span class="language-xml">,
      archivePrefix=</span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
      primaryClass=</span><span class="hljs-template-variable">{cs.CV}</span><span class="language-xml">
}</span>`,wrap:!1}}),{c(){J=p("meta"),R=l(),Q=p("p"),Y=l(),i(j.$$.fragment),S=l(),w=p("p"),w.innerHTML=ht,A=l(),i(d.$$.fragment),z=l(),T=p("p"),T.textContent=gt,H=l(),i(y.$$.fragment),F=l(),u=p("p"),u.textContent=Mt,L=l(),i(f.$$.fragment),q=l(),b=p("p"),b.textContent=Jt,D=l(),i(U.$$.fragment),P=l(),I=p("p"),I.textContent=jt,K=l(),i($.$$.fragment),O=l(),Z=p("p"),Z.innerHTML=wt,tt=l(),k=p("p"),k.innerHTML=dt,st=l(),i(C.$$.fragment),et=l(),W=p("p"),W.textContent=Tt,at=l(),i(N.$$.fragment),lt=l(),x=p("p"),x.innerHTML=yt,nt=l(),i(B.$$.fragment),pt=l(),v=p("p"),v.innerHTML=ut,mt=l(),i(G.$$.fragment),it=l(),i(E.$$.fragment),ot=l(),X=p("p"),this.h()},l(t){const s=Ct("svelte-u9bgzb",document.head);J=m(s,"META",{name:!0,content:!0}),s.forEach(e),R=n(t),Q=m(t,"P",{}),ft(Q).forEach(e),Y=n(t),o(j.$$.fragment,t),S=n(t),w=m(t,"P",{"data-svelte-h":!0}),M(w)!=="svelte-bj35wp"&&(w.innerHTML=ht),A=n(t),o(d.$$.fragment,t),z=n(t),T=m(t,"P",{"data-svelte-h":!0}),M(T)!=="svelte-18ywhxh"&&(T.textContent=gt),H=n(t),o(y.$$.fragment,t),F=n(t),u=m(t,"P",{"data-svelte-h":!0}),M(u)!=="svelte-1c2ipa8"&&(u.textContent=Mt),L=n(t),o(f.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1n9qsq1"&&(b.textContent=Jt),D=n(t),o(U.$$.fragment,t),P=n(t),I=m(t,"P",{"data-svelte-h":!0}),M(I)!=="svelte-19cnvx1"&&(I.textContent=jt),K=n(t),o($.$$.fragment,t),O=n(t),Z=m(t,"P",{"data-svelte-h":!0}),M(Z)!=="svelte-17aafbm"&&(Z.innerHTML=wt),tt=n(t),k=m(t,"P",{"data-svelte-h":!0}),M(k)!=="svelte-1wmi3ea"&&(k.innerHTML=dt),st=n(t),o(C.$$.fragment,t),et=n(t),W=m(t,"P",{"data-svelte-h":!0}),M(W)!=="svelte-9sr7nh"&&(W.textContent=Tt),at=n(t),o(N.$$.fragment,t),lt=n(t),x=m(t,"P",{"data-svelte-h":!0}),M(x)!=="svelte-1kguc51"&&(x.innerHTML=yt),nt=n(t),o(B.$$.fragment,t),pt=n(t),v=m(t,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1n0coha"&&(v.innerHTML=ut),mt=n(t),o(G.$$.fragment,t),it=n(t),o(E.$$.fragment,t),ot=n(t),X=m(t,"P",{}),ft(X).forEach(e),this.h()},h(){bt(J,"name","hf:doc:metadata"),bt(J,"content",xt)},m(t,s){Wt(document.head,J),a(t,R,s),a(t,Q,s),a(t,Y,s),r(j,t,s),a(t,S,s),a(t,w,s),a(t,A,s),r(d,t,s),a(t,z,s),a(t,T,s),a(t,H,s),r(y,t,s),a(t,F,s),a(t,u,s),a(t,L,s),r(f,t,s),a(t,q,s),a(t,b,s),a(t,D,s),r(U,t,s),a(t,P,s),a(t,I,s),a(t,K,s),r($,t,s),a(t,O,s),a(t,Z,s),a(t,tt,s),a(t,k,s),a(t,st,s),r(C,t,s),a(t,et,s),a(t,W,s),a(t,at,s),r(N,t,s),a(t,lt,s),a(t,x,s),a(t,nt,s),r(B,t,s),a(t,pt,s),a(t,v,s),a(t,mt,s),r(G,t,s),a(t,it,s),r(E,t,s),a(t,ot,s),a(t,X,s),rt=!0},p:It,i(t){rt||(c(j.$$.fragment,t),c(d.$$.fragment,t),c(y.$$.fragment,t),c(f.$$.fragment,t),c(U.$$.fragment,t),c($.$$.fragment,t),c(C.$$.fragment,t),c(N.$$.fragment,t),c(B.$$.fragment,t),c(G.$$.fragment,t),c(E.$$.fragment,t),rt=!0)},o(t){h(j.$$.fragment,t),h(d.$$.fragment,t),h(y.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h($.$$.fragment,t),h(C.$$.fragment,t),h(N.$$.fragment,t),h(B.$$.fragment,t),h(G.$$.fragment,t),h(E.$$.fragment,t),rt=!1},d(t){t&&(e(R),e(Q),e(Y),e(S),e(w),e(A),e(z),e(T),e(H),e(F),e(u),e(L),e(q),e(b),e(D),e(P),e(I),e(K),e(O),e(Z),e(tt),e(k),e(st),e(et),e(W),e(at),e(lt),e(x),e(nt),e(pt),e(v),e(mt),e(it),e(ot),e(X)),e(J),g(j,t),g(d,t),g(y,t),g(f,t),g(U,t),g($,t),g(C,t),g(N,t),g(B,t),g(G,t),g(E,t)}}}const xt='{"title":"SK-ResNet","local":"sk-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function Bt(ct){return $t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qt extends Zt{constructor(J){super(),kt(this,J,Bt,Nt,Ut,{})}}export{Qt as component};
