import{s as pt,n as it,o as rt}from"../chunks/scheduler.bdbef820.js";import{S as ot,i as mt,g as p,s as n,r as o,A as ct,h as i,f as s,c as l,j as nt,u as m,x as r,k as lt,y as dt,a,v as c,d,t as h,w as g}from"../chunks/index.c0aea24a.js";import{C as f}from"../chunks/CodeBlock.6ccca92e.js";import{H as K}from"../chunks/Heading.2eb892cb.js";function ht(ze){let u,te,O,se,b,ae,j,qe='There are two types of dataset objects, a regular <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and then an ✨ <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> ✨. A <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> provides fast random access to the rows, and memory-mapping so that loading even large datasets only uses a relatively small amount of device memory. But for really, really big datasets that won’t even fit on disk or in memory, an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> allows you to access and use the dataset without waiting for it to download completely!',ne,x,He='This tutorial will show you how to load and access a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> and an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',le,w,pe,y,Ye='When you load a dataset split, you’ll get a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object. You can do many things with a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object, which is why it’s important to learn how to manipulate and interact with the data stored inside.',ie,$,Qe='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> dataset, but feel free to load any dataset you’d like and follow along!',re,M,oe,v,me,_,Le='A <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> contains columns of data, and each column can be a different type of data. The <em>index</em>, or axis label, is used to access examples from the dataset. For example, indexing by the row returns a dictionary of an example from the dataset:',ce,k,de,T,Pe="Use the <code>-</code> operator to start from the end of the dataset:",he,U,ge,I,We="Indexing by the column name returns a list of all the values in the column:",fe,J,ue,C,Ne="You can combine row and column name indexing to return a specific value at a position:",be,G,je,R,Se="But it is important to remember that indexing order matters, especially when working with large audio and image datasets. Indexing by the column name returns all the values in the column first, then loads the value at that position. For large datasets, it may be slower to index by the column name first.",xe,Z,we,D,ye,X,Ee="Slicing returns a slice - or subset - of the dataset, which is useful for viewing several rows at once. To slice a dataset, use the <code>:</code> operator to specify a range of positions.",$e,B,Me,F,ve,z,Ve='An <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> is loaded when you set the <code>streaming</code> parameter to <code>True</code> in <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',_e,q,ke,H,Ae='You can also create an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> from an <em>existing</em> <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>, but it is faster than streaming mode because the dataset is streamed from local files:',Te,Y,Ue,Q,Ke='An <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a> progressively iterates over a dataset one example at a time, so you don’t have to wait for the whole dataset to download before you can use it. As you can imagine, this is quite useful for large datasets you want to use immediately!',Ie,L,Oe='However, this means an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>’s behavior is different from a regular <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a>. You don’t get random access to examples in an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>. Instead, you should iterate over its elements, for example, by calling <code>next(iter())</code> or with a <code>for</code> loop to return the next item from the <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>:',Je,P,Ce,W,et='You can return a subset of the dataset with a specific number of examples in it with <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a>:',Ge,N,Re,S,tt='But unlike <a href="access/#slicing">slicing</a>, <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset.take">IterableDataset.take()</a> creates a new <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Ze,E,De,V,st='Interested in learning more about the differences between these two types of datasets? Learn more about them in the <a href="about_mapstyle_vs_iterable">Differences between <code>Dataset</code> and <code>IterableDataset</code></a> conceptual guide.',Xe,A,at='To get more hands-on with these datasets types, check out the <a href="process">Process</a> guide to learn how to preprocess a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> or the <a href="stream">Stream</a> guide to learn how to preprocess an <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.IterableDataset">IterableDataset</a>.',Be,ee,Fe;return b=new K({props:{title:"Know your dataset",local:"know-your-dataset",headingTag:"h1"}}),w=new K({props:{title:"Dataset",local:"dataset",headingTag:"h2"}}),M=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),v=new K({props:{title:"Indexing",local:"indexing",headingTag:"h3"}}),k=new f({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-comment"># Get the first row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">1</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>}`,wrap:!1}}),U=new f({props:{code:"ZGF0YXNldCU1Qi0xJTVE",highlighted:`<span class="hljs-comment"># Get the last row in the dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[-<span class="hljs-number">1</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>}`,wrap:!1}}),J=new f({props:{code:"ZGF0YXNldCU1QiUyMnRleHQlMjIlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-string">&quot;text&quot;</span>]
[<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
 <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
 <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>,
 ...,
 <span class="hljs-string">&#x27;things really get weird , though not particularly scary : the movie is all portent and no content .&#x27;</span>]`,wrap:!1}}),G=new f({props:{code:"ZGF0YXNldCU1QjAlNUQlNUIlMjJ0ZXh0JTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>`,wrap:!1}}),Z=new f({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXRleHQlMjAlM0QlMjBkYXRhc2V0JTVCMCU1RCU1QiUyMnRleHQlMjIlNUQlMEFlbmRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBcHJpbnQoZiUyMkVsYXBzZWQlMjB0aW1lJTNBJTIwJTdCZW5kX3RpbWUlMjAtJTIwc3RhcnRfdGltZSUzQS40ZiU3RCUyMHNlY29uZHMlMjIpJTBBJTBBc3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBdGV4dCUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXh0JTIyJTVEJTVCMCU1RCUwQWVuZF90aW1lJTIwJTNEJTIwdGltZS50aW1lKCklMEFwcmludChmJTIyRWxhcHNlZCUyMHRpbWUlM0ElMjAlN0JlbmRfdGltZSUyMC0lMjBzdGFydF90aW1lJTNBLjRmJTdEJTIwc2Vjb25kcyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;text&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0031</span> seconds

<span class="hljs-meta">&gt;&gt;&gt; </span>start_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = dataset[<span class="hljs-string">&quot;text&quot;</span>][<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>end_time = time.time()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Elapsed time: <span class="hljs-subst">{end_time - start_time:<span class="hljs-number">.4</span>f}</span> seconds&quot;</span>)
Elapsed time: <span class="hljs-number">0.0094</span> seconds`,wrap:!1}}),D=new K({props:{title:"Slicing",local:"slicing",headingTag:"h3"}}),B=new f({props:{code:"ZGF0YXNldCU1QiUzQTMlNUQlMEElMEFkYXRhc2V0JTVCMyUzQTYlNUQ=",highlighted:`<span class="hljs-comment"># Get the first three rows</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[:<span class="hljs-number">3</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;the rock is destined to be the 21st century\\&#x27;s new &quot; conan &quot; and that he\\&#x27;s going to make a splash even greater than arnold schwarzenegger , jean-claud van damme or steven segal .&#x27;</span>,
  <span class="hljs-string">&#x27;the gorgeously elaborate continuation of &quot; the lord of the rings &quot; trilogy is so huge that a column of words cannot adequately describe co-writer/director peter jackson\\&#x27;s expanded vision of j . r . r . tolkien\\&#x27;s middle-earth .&#x27;</span>,
  <span class="hljs-string">&#x27;effective but too-tepid biopic&#x27;</span>]}

<span class="hljs-comment"># Get rows between three and six</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">3</span>:<span class="hljs-number">6</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>],
 <span class="hljs-string">&#x27;text&#x27;</span>: [<span class="hljs-string">&#x27;if you sometimes like to go to the movies to have fun , wasabi is a good place to start .&#x27;</span>,
  <span class="hljs-string">&quot;emerges as something rare , an issue movie that&#x27;s so honest and keenly observed that it doesn&#x27;t feel like one .&quot;</span>,
  <span class="hljs-string">&#x27;the film provides some great insight into the neurotic mindset of all comics -- even those who have reached the absolute top of the game .&#x27;</span>]}`,wrap:!1}}),F=new K({props:{title:"IterableDataset",local:"iterabledataset",headingTag:"h2"}}),q=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBaXRlcmFibGVfZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJmb29kMTAxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHN0cmVhbWluZyUzRFRydWUpJTBBZm9yJTIwZXhhbXBsZSUyMGluJTIwaXRlcmFibGVfZGF0YXNldCUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGV4YW1wbGUpJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = load_dataset(<span class="hljs-string">&quot;food101&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F5C520</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWl0ZXJhYmxlX2RhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnRvX2l0ZXJhYmxlX2RhdGFzZXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>iterable_dataset = dataset.to_iterable_dataset()`,wrap:!1}}),P=new f({props:{code:"bmV4dChpdGVyKGl0ZXJhYmxlX2RhdGFzZXQpKSUwQSUwQWZvciUyMGV4YW1wbGUlMjBpbiUyMGl0ZXJhYmxlX2RhdGFzZXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChleGFtcGxlKSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(iterable_dataset))
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F0681F59B50</span>&gt;,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> iterable_dataset:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(example)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>
{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DE82B0</span>&gt;, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}`,wrap:!1}}),N=new f({props:{code:"bGlzdChpdGVyYWJsZV9kYXRhc2V0LnRha2UoMykp",highlighted:`<span class="hljs-comment"># Get first three examples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(iterable_dataset.take(<span class="hljs-number">3</span>))
[{<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=384x512 at <span class="hljs-number">0x7F7479DEE9D0</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x512 at <span class="hljs-number">0x7F7479DE8190</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>},
 {<span class="hljs-string">&#x27;image&#x27;</span>: &lt;PIL.JpegImagePlugin.JpegImageFile image mode=RGB size=512x383 at <span class="hljs-number">0x7F7479DE8310</span>&gt;,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">6</span>}]`,wrap:!1}}),E=new K({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){u=p("meta"),te=n(),O=p("p"),se=n(),o(b.$$.fragment),ae=n(),j=p("p"),j.innerHTML=qe,ne=n(),x=p("p"),x.innerHTML=He,le=n(),o(w.$$.fragment),pe=n(),y=p("p"),y.innerHTML=Ye,ie=n(),$=p("p"),$.innerHTML=Qe,re=n(),o(M.$$.fragment),oe=n(),o(v.$$.fragment),me=n(),_=p("p"),_.innerHTML=Le,ce=n(),o(k.$$.fragment),de=n(),T=p("p"),T.innerHTML=Pe,he=n(),o(U.$$.fragment),ge=n(),I=p("p"),I.textContent=We,fe=n(),o(J.$$.fragment),ue=n(),C=p("p"),C.textContent=Ne,be=n(),o(G.$$.fragment),je=n(),R=p("p"),R.textContent=Se,xe=n(),o(Z.$$.fragment),we=n(),o(D.$$.fragment),ye=n(),X=p("p"),X.innerHTML=Ee,$e=n(),o(B.$$.fragment),Me=n(),o(F.$$.fragment),ve=n(),z=p("p"),z.innerHTML=Ve,_e=n(),o(q.$$.fragment),ke=n(),H=p("p"),H.innerHTML=Ae,Te=n(),o(Y.$$.fragment),Ue=n(),Q=p("p"),Q.innerHTML=Ke,Ie=n(),L=p("p"),L.innerHTML=Oe,Je=n(),o(P.$$.fragment),Ce=n(),W=p("p"),W.innerHTML=et,Ge=n(),o(N.$$.fragment),Re=n(),S=p("p"),S.innerHTML=tt,Ze=n(),o(E.$$.fragment),De=n(),V=p("p"),V.innerHTML=st,Xe=n(),A=p("p"),A.innerHTML=at,Be=n(),ee=p("p"),this.h()},l(e){const t=ct("svelte-u9bgzb",document.head);u=i(t,"META",{name:!0,content:!0}),t.forEach(s),te=l(e),O=i(e,"P",{}),nt(O).forEach(s),se=l(e),m(b.$$.fragment,e),ae=l(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ct7tle"&&(j.innerHTML=qe),ne=l(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-did6k9"&&(x.innerHTML=He),le=l(e),m(w.$$.fragment,e),pe=l(e),y=i(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-ypg4fd"&&(y.innerHTML=Ye),ie=l(e),$=i(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-jz751l"&&($.innerHTML=Qe),re=l(e),m(M.$$.fragment,e),oe=l(e),m(v.$$.fragment,e),me=l(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1tnrj18"&&(_.innerHTML=Le),ce=l(e),m(k.$$.fragment,e),de=l(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18jqw8v"&&(T.innerHTML=Pe),he=l(e),m(U.$$.fragment,e),ge=l(e),I=i(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-18othzs"&&(I.textContent=We),fe=l(e),m(J.$$.fragment,e),ue=l(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1gzsqvo"&&(C.textContent=Ne),be=l(e),m(G.$$.fragment,e),je=l(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-158alym"&&(R.textContent=Se),xe=l(e),m(Z.$$.fragment,e),we=l(e),m(D.$$.fragment,e),ye=l(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gt5d64"&&(X.innerHTML=Ee),$e=l(e),m(B.$$.fragment,e),Me=l(e),m(F.$$.fragment,e),ve=l(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-jyxvm1"&&(z.innerHTML=Ve),_e=l(e),m(q.$$.fragment,e),ke=l(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1cbafg3"&&(H.innerHTML=Ae),Te=l(e),m(Y.$$.fragment,e),Ue=l(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1qj9el7"&&(Q.innerHTML=Ke),Ie=l(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-kw5zvb"&&(L.innerHTML=Oe),Je=l(e),m(P.$$.fragment,e),Ce=l(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-17eiudz"&&(W.innerHTML=et),Ge=l(e),m(N.$$.fragment,e),Re=l(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-14deofz"&&(S.innerHTML=tt),Ze=l(e),m(E.$$.fragment,e),De=l(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-51y7bk"&&(V.innerHTML=st),Xe=l(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1yl9fmu"&&(A.innerHTML=at),Be=l(e),ee=i(e,"P",{}),nt(ee).forEach(s),this.h()},h(){lt(u,"name","hf:doc:metadata"),lt(u,"content",gt)},m(e,t){dt(document.head,u),a(e,te,t),a(e,O,t),a(e,se,t),c(b,e,t),a(e,ae,t),a(e,j,t),a(e,ne,t),a(e,x,t),a(e,le,t),c(w,e,t),a(e,pe,t),a(e,y,t),a(e,ie,t),a(e,$,t),a(e,re,t),c(M,e,t),a(e,oe,t),c(v,e,t),a(e,me,t),a(e,_,t),a(e,ce,t),c(k,e,t),a(e,de,t),a(e,T,t),a(e,he,t),c(U,e,t),a(e,ge,t),a(e,I,t),a(e,fe,t),c(J,e,t),a(e,ue,t),a(e,C,t),a(e,be,t),c(G,e,t),a(e,je,t),a(e,R,t),a(e,xe,t),c(Z,e,t),a(e,we,t),c(D,e,t),a(e,ye,t),a(e,X,t),a(e,$e,t),c(B,e,t),a(e,Me,t),c(F,e,t),a(e,ve,t),a(e,z,t),a(e,_e,t),c(q,e,t),a(e,ke,t),a(e,H,t),a(e,Te,t),c(Y,e,t),a(e,Ue,t),a(e,Q,t),a(e,Ie,t),a(e,L,t),a(e,Je,t),c(P,e,t),a(e,Ce,t),a(e,W,t),a(e,Ge,t),c(N,e,t),a(e,Re,t),a(e,S,t),a(e,Ze,t),c(E,e,t),a(e,De,t),a(e,V,t),a(e,Xe,t),a(e,A,t),a(e,Be,t),a(e,ee,t),Fe=!0},p:it,i(e){Fe||(d(b.$$.fragment,e),d(w.$$.fragment,e),d(M.$$.fragment,e),d(v.$$.fragment,e),d(k.$$.fragment,e),d(U.$$.fragment,e),d(J.$$.fragment,e),d(G.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(B.$$.fragment,e),d(F.$$.fragment,e),d(q.$$.fragment,e),d(Y.$$.fragment,e),d(P.$$.fragment,e),d(N.$$.fragment,e),d(E.$$.fragment,e),Fe=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(M.$$.fragment,e),h(v.$$.fragment,e),h(k.$$.fragment,e),h(U.$$.fragment,e),h(J.$$.fragment,e),h(G.$$.fragment,e),h(Z.$$.fragment,e),h(D.$$.fragment,e),h(B.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(N.$$.fragment,e),h(E.$$.fragment,e),Fe=!1},d(e){e&&(s(te),s(O),s(se),s(ae),s(j),s(ne),s(x),s(le),s(pe),s(y),s(ie),s($),s(re),s(oe),s(me),s(_),s(ce),s(de),s(T),s(he),s(ge),s(I),s(fe),s(ue),s(C),s(be),s(je),s(R),s(xe),s(we),s(ye),s(X),s($e),s(Me),s(ve),s(z),s(_e),s(ke),s(H),s(Te),s(Ue),s(Q),s(Ie),s(L),s(Je),s(Ce),s(W),s(Ge),s(Re),s(S),s(Ze),s(De),s(V),s(Xe),s(A),s(Be),s(ee)),s(u),g(b,e),g(w,e),g(M,e),g(v,e),g(k,e),g(U,e),g(J,e),g(G,e),g(Z,e),g(D,e),g(B,e),g(F,e),g(q,e),g(Y,e),g(P,e),g(N,e),g(E,e)}}}const gt='{"title":"Know your dataset","local":"know-your-dataset","sections":[{"title":"Dataset","local":"dataset","sections":[{"title":"Indexing","local":"indexing","sections":[],"depth":3},{"title":"Slicing","local":"slicing","sections":[],"depth":3}],"depth":2},{"title":"IterableDataset","local":"iterabledataset","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ft(ze){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class wt extends ot{constructor(u){super(),mt(this,u,ft,ht,pt,{})}}export{wt as component};
