import{s as Hs,o as Ls,n as Ys}from"../chunks/scheduler.bdbef820.js";import{S as Bs,i as Ps,g as p,s as n,r,A as Ds,h as o,f as a,c as l,j as Ws,u as d,x as f,k as qs,y as Ss,a as e,v as c,d as h,t as g,w as m}from"../chunks/index.c0aea24a.js";import{T as Ns}from"../chunks/Tip.31005f7d.js";import{C as y}from"../chunks/CodeBlock.6ccca92e.js";import{H as V}from"../chunks/Heading.2eb892cb.js";function Vs(E){let i,w="In the next major release, the new safety features of 🤗 Datasets will disable running dataset loading scripts by default, and you will have to pass <code>trust_remote_code=True</code> to load datasets that require running a dataset script.";return{c(){i=p("p"),i.innerHTML=w},l(u){i=o(u,"P",{"data-svelte-h":!0}),f(i)!=="svelte-mdy5pl"&&(i.innerHTML=w)},m(u,S){e(u,i,S)},p:Ys,d(u){u&&a(i)}}}function Es(E){let i,w,u,S,_,Q,x,Ms='Finding high-quality datasets that are reproducible and accessible can be difficult. One of 🤗 Datasets main goals is to provide a simple way to load a dataset of any format or type. The easiest way to get started is to discover an existing dataset on the <a href="https://huggingface.co/datasets" rel="nofollow">Hugging Face Hub</a> - a community-driven collection of datasets for tasks in NLP, computer vision, and audio - and use 🤗 Datasets to download and generate the dataset.',A,$,Ts='This tutorial uses the <a href="https://huggingface.co/datasets/rotten_tomatoes" rel="nofollow">rotten_tomatoes</a> and <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> datasets, but feel free to load any dataset you want and follow along. Head over to the Hub now and find a dataset for your task!',K,b,O,M,vs='Before you take the time to download a dataset, it’s often helpful to quickly get some general information about a dataset. A dataset’s information is stored inside <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.DatasetInfo">DatasetInfo</a> and can include information such as the dataset description, features, and dataset size.',ss,T,Js='Use the <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.load_dataset_builder">load_dataset_builder()</a> function to load a dataset builder and inspect a dataset’s attributes without committing to downloading it:',ts,v,as,J,Rs='If you’re happy with the dataset, then load it with <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.load_dataset">load_dataset()</a>:',es,R,ns,Z,ls,k,Zs='A split is a specific subset of a dataset like <code>train</code> and <code>test</code>. List a dataset’s split names with the <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.get_dataset_split_names">get_dataset_split_names()</a> function:',is,X,ps,G,ks='Then you can load a specific split with the <code>split</code> parameter. Loading a dataset <code>split</code> returns a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.Dataset">Dataset</a> object:',os,I,rs,U,Xs='If you don’t specify a <code>split</code>, 🤗 Datasets returns a <a href="/docs/datasets/v2.17.0/en/package_reference/main_classes#datasets.DatasetDict">DatasetDict</a> object instead:',ds,C,cs,F,hs,z,Gs='Some datasets contain several sub-datasets. For example, the <a href="https://huggingface.co/datasets/PolyAI/minds14" rel="nofollow">MInDS-14</a> dataset has several sub-datasets, each one containing audio data in a different language. These sub-datasets are known as <em>configurations</em>, and you must explicitly select one when loading the dataset. If you don’t provide a configuration name, 🤗 Datasets will raise a <code>ValueError</code> and remind you to choose a configuration.',gs,W,Is='Use the <a href="/docs/datasets/v2.17.0/en/package_reference/loading_methods#datasets.get_dataset_config_names">get_dataset_config_names()</a> function to retrieve a list of all the possible configurations available to your dataset:',ms,q,fs,H,Us="Then load the configuration you want:",us,L,js,Y,ys,B,Cs=`Certain datasets repositories contain a loading script with the Python code used to generate the dataset.
Those datasets are generally exported to Parquet by Hugging Face, so that 🤗 Datasets can load the dataset fast and without running a loading script.`,ws,P,Fs=`Even if a Parquet export is not available, you can still use any dataset with Python code in its repository with <code>load_dataset</code>.
All files and code uploaded to the Hub are scanned for malware (refer to the Hub security documentation for more information), but you should still review the dataset loading scripts and authors to avoid executing malicious code on your machine. You should set <code>trust_remote_code=True</code> to use a dataset with a loading script, or you will get a warning:`,_s,D,xs,j,$s,N,bs;return _=new V({props:{title:"Load a dataset from the Hub",local:"load-a-dataset-from-the-hub",headingTag:"h1"}}),b=new V({props:{title:"Load a dataset",local:"load-a-dataset",headingTag:"h2"}}),v=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIlMEFkc19idWlsZGVyJTIwJTNEJTIwbG9hZF9kYXRhc2V0X2J1aWxkZXIoJTIycm90dGVuX3RvbWF0b2VzJTIyKSUwQSUwQWRzX2J1aWxkZXIuaW5mby5kZXNjcmlwdGlvbiUwQSUwQWRzX2J1aWxkZXIuaW5mby5mZWF0dXJlcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset_builder
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder = load_dataset_builder(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)

<span class="hljs-comment"># Inspect dataset description</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.info.description
Movie Review Dataset. This <span class="hljs-keyword">is</span> a dataset of containing <span class="hljs-number">5</span>,<span class="hljs-number">331</span> positive <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>,<span class="hljs-number">331</span> negative processed sentences <span class="hljs-keyword">from</span> Rotten Tomatoes movie reviews. This data was first used <span class="hljs-keyword">in</span> Bo Pang <span class="hljs-keyword">and</span> Lillian Lee, \`\`Seeing stars: Exploiting <span class="hljs-keyword">class</span> <span class="hljs-title class_">relationships</span> <span class="hljs-keyword">for</span> sentiment categorization <span class="hljs-keyword">with</span> respect to rating scales.<span class="hljs-string">&#x27;&#x27;</span>, Proceedings of the ACL, <span class="hljs-number">2005.</span>

<span class="hljs-comment"># Inspect dataset features</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>ds_builder.info.features
{<span class="hljs-string">&#x27;label&#x27;</span>: ClassLabel(num_classes=<span class="hljs-number">2</span>, names=[<span class="hljs-string">&#x27;neg&#x27;</span>, <span class="hljs-string">&#x27;pos&#x27;</span>], <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;text&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),R=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Z=new V({props:{title:"Splits",local:"splits",headingTag:"h2"}}),X=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfc3BsaXRfbmFtZXMlMEElMEFnZXRfZGF0YXNldF9zcGxpdF9uYW1lcyglMjJyb3R0ZW5fdG9tYXRvZXMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_split_names

<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_split_names(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
[<span class="hljs-string">&#x27;train&#x27;</span>, <span class="hljs-string">&#x27;validation&#x27;</span>, <span class="hljs-string">&#x27;test&#x27;</span>]`,wrap:!1}}),I=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKSUwQWRhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">8530</span>
})`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJyb3R0ZW5fdG9tYXRvZXMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;rotten_tomatoes&quot;</span>)
DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">8530</span>
    })
    validation: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">1066</span>
    })
    test: Dataset({
        features: [<span class="hljs-string">&#x27;text&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
        num_rows: <span class="hljs-number">1066</span>
    })
})`,wrap:!1}}),F=new V({props:{title:"Configurations",local:"configurations",headingTag:"h2"}}),q=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfY29uZmlnX25hbWVzJTBBJTBBY29uZmlncyUyMCUzRCUyMGdldF9kYXRhc2V0X2NvbmZpZ19uYW1lcyglMjJQb2x5QUklMkZtaW5kczE0JTIyKSUwQXByaW50KGNvbmZpZ3Mp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_config_names

<span class="hljs-meta">&gt;&gt;&gt; </span>configs = get_dataset_config_names(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(configs)
[<span class="hljs-string">&#x27;cs-CZ&#x27;</span>, <span class="hljs-string">&#x27;de-DE&#x27;</span>, <span class="hljs-string">&#x27;en-AU&#x27;</span>, <span class="hljs-string">&#x27;en-GB&#x27;</span>, <span class="hljs-string">&#x27;en-US&#x27;</span>, <span class="hljs-string">&#x27;es-ES&#x27;</span>, <span class="hljs-string">&#x27;fr-FR&#x27;</span>, <span class="hljs-string">&#x27;it-IT&#x27;</span>, <span class="hljs-string">&#x27;ko-KR&#x27;</span>, <span class="hljs-string">&#x27;nl-NL&#x27;</span>, <span class="hljs-string">&#x27;pl-PL&#x27;</span>, <span class="hljs-string">&#x27;pt-PT&#x27;</span>, <span class="hljs-string">&#x27;ru-RU&#x27;</span>, <span class="hljs-string">&#x27;zh-CN&#x27;</span>, <span class="hljs-string">&#x27;all&#x27;</span>]`,wrap:!1}}),L=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBbWluZHNGUiUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJQb2x5QUklMkZtaW5kczE0JTIyJTJDJTIwJTIyZnItRlIlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>mindsFR = load_dataset(<span class="hljs-string">&quot;PolyAI/minds14&quot;</span>, <span class="hljs-string">&quot;fr-FR&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Y=new V({props:{title:"Remote code",local:"remote-code",headingTag:"h2"}}),D=new y({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwZ2V0X2RhdGFzZXRfY29uZmlnX25hbWVzJTJDJTIwZ2V0X2RhdGFzZXRfc3BsaXRfbmFtZXMlMkMlMjBsb2FkX2RhdGFzZXQlMEElMEFjNCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJjNCUyMiUyQyUyMCUyMmVuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFnZXRfZGF0YXNldF9jb25maWdfbmFtZXMoJTIyYzQlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBZ2V0X2RhdGFzZXRfc3BsaXRfbmFtZXMoJTIyYzQlMjIlMkMlMjAlMjJlbiUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> get_dataset_config_names, get_dataset_split_names, load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>c4 = load_dataset(<span class="hljs-string">&quot;c4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_config_names(<span class="hljs-string">&quot;c4&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;en&#x27;</span>, <span class="hljs-string">&#x27;realnewslike&#x27;</span>, <span class="hljs-string">&#x27;en.noblocklist&#x27;</span>, <span class="hljs-string">&#x27;en.noclean&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>get_dataset_split_names(<span class="hljs-string">&quot;c4&quot;</span>, <span class="hljs-string">&quot;en&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;train&#x27;</span>, <span class="hljs-string">&#x27;validation&#x27;</span>]`,wrap:!1}}),j=new Ns({props:{warning:"true",$$slots:{default:[Vs]},$$scope:{ctx:E}}}),{c(){i=p("meta"),w=n(),u=p("p"),S=n(),r(_.$$.fragment),Q=n(),x=p("p"),x.innerHTML=Ms,A=n(),$=p("p"),$.innerHTML=Ts,K=n(),r(b.$$.fragment),O=n(),M=p("p"),M.innerHTML=vs,ss=n(),T=p("p"),T.innerHTML=Js,ts=n(),r(v.$$.fragment),as=n(),J=p("p"),J.innerHTML=Rs,es=n(),r(R.$$.fragment),ns=n(),r(Z.$$.fragment),ls=n(),k=p("p"),k.innerHTML=Zs,is=n(),r(X.$$.fragment),ps=n(),G=p("p"),G.innerHTML=ks,os=n(),r(I.$$.fragment),rs=n(),U=p("p"),U.innerHTML=Xs,ds=n(),r(C.$$.fragment),cs=n(),r(F.$$.fragment),hs=n(),z=p("p"),z.innerHTML=Gs,gs=n(),W=p("p"),W.innerHTML=Is,ms=n(),r(q.$$.fragment),fs=n(),H=p("p"),H.textContent=Us,us=n(),r(L.$$.fragment),js=n(),r(Y.$$.fragment),ys=n(),B=p("p"),B.textContent=Cs,ws=n(),P=p("p"),P.innerHTML=Fs,_s=n(),r(D.$$.fragment),xs=n(),r(j.$$.fragment),$s=n(),N=p("p"),this.h()},l(s){const t=Ds("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(a),w=l(s),u=o(s,"P",{}),Ws(u).forEach(a),S=l(s),d(_.$$.fragment,s),Q=l(s),x=o(s,"P",{"data-svelte-h":!0}),f(x)!=="svelte-9qr6ee"&&(x.innerHTML=Ms),A=l(s),$=o(s,"P",{"data-svelte-h":!0}),f($)!=="svelte-1nd3fhb"&&($.innerHTML=Ts),K=l(s),d(b.$$.fragment,s),O=l(s),M=o(s,"P",{"data-svelte-h":!0}),f(M)!=="svelte-18tftdp"&&(M.innerHTML=vs),ss=l(s),T=o(s,"P",{"data-svelte-h":!0}),f(T)!=="svelte-ikdv3p"&&(T.innerHTML=Js),ts=l(s),d(v.$$.fragment,s),as=l(s),J=o(s,"P",{"data-svelte-h":!0}),f(J)!=="svelte-s11w9l"&&(J.innerHTML=Rs),es=l(s),d(R.$$.fragment,s),ns=l(s),d(Z.$$.fragment,s),ls=l(s),k=o(s,"P",{"data-svelte-h":!0}),f(k)!=="svelte-1q46r22"&&(k.innerHTML=Zs),is=l(s),d(X.$$.fragment,s),ps=l(s),G=o(s,"P",{"data-svelte-h":!0}),f(G)!=="svelte-7blxsd"&&(G.innerHTML=ks),os=l(s),d(I.$$.fragment,s),rs=l(s),U=o(s,"P",{"data-svelte-h":!0}),f(U)!=="svelte-ywm782"&&(U.innerHTML=Xs),ds=l(s),d(C.$$.fragment,s),cs=l(s),d(F.$$.fragment,s),hs=l(s),z=o(s,"P",{"data-svelte-h":!0}),f(z)!=="svelte-r92fav"&&(z.innerHTML=Gs),gs=l(s),W=o(s,"P",{"data-svelte-h":!0}),f(W)!=="svelte-cdcwka"&&(W.innerHTML=Is),ms=l(s),d(q.$$.fragment,s),fs=l(s),H=o(s,"P",{"data-svelte-h":!0}),f(H)!=="svelte-avfjb"&&(H.textContent=Us),us=l(s),d(L.$$.fragment,s),js=l(s),d(Y.$$.fragment,s),ys=l(s),B=o(s,"P",{"data-svelte-h":!0}),f(B)!=="svelte-1s86kjd"&&(B.textContent=Cs),ws=l(s),P=o(s,"P",{"data-svelte-h":!0}),f(P)!=="svelte-yr5mb7"&&(P.innerHTML=Fs),_s=l(s),d(D.$$.fragment,s),xs=l(s),d(j.$$.fragment,s),$s=l(s),N=o(s,"P",{}),Ws(N).forEach(a),this.h()},h(){qs(i,"name","hf:doc:metadata"),qs(i,"content",Qs)},m(s,t){Ss(document.head,i),e(s,w,t),e(s,u,t),e(s,S,t),c(_,s,t),e(s,Q,t),e(s,x,t),e(s,A,t),e(s,$,t),e(s,K,t),c(b,s,t),e(s,O,t),e(s,M,t),e(s,ss,t),e(s,T,t),e(s,ts,t),c(v,s,t),e(s,as,t),e(s,J,t),e(s,es,t),c(R,s,t),e(s,ns,t),c(Z,s,t),e(s,ls,t),e(s,k,t),e(s,is,t),c(X,s,t),e(s,ps,t),e(s,G,t),e(s,os,t),c(I,s,t),e(s,rs,t),e(s,U,t),e(s,ds,t),c(C,s,t),e(s,cs,t),c(F,s,t),e(s,hs,t),e(s,z,t),e(s,gs,t),e(s,W,t),e(s,ms,t),c(q,s,t),e(s,fs,t),e(s,H,t),e(s,us,t),c(L,s,t),e(s,js,t),c(Y,s,t),e(s,ys,t),e(s,B,t),e(s,ws,t),e(s,P,t),e(s,_s,t),c(D,s,t),e(s,xs,t),c(j,s,t),e(s,$s,t),e(s,N,t),bs=!0},p(s,[t]){const zs={};t&2&&(zs.$$scope={dirty:t,ctx:s}),j.$set(zs)},i(s){bs||(h(_.$$.fragment,s),h(b.$$.fragment,s),h(v.$$.fragment,s),h(R.$$.fragment,s),h(Z.$$.fragment,s),h(X.$$.fragment,s),h(I.$$.fragment,s),h(C.$$.fragment,s),h(F.$$.fragment,s),h(q.$$.fragment,s),h(L.$$.fragment,s),h(Y.$$.fragment,s),h(D.$$.fragment,s),h(j.$$.fragment,s),bs=!0)},o(s){g(_.$$.fragment,s),g(b.$$.fragment,s),g(v.$$.fragment,s),g(R.$$.fragment,s),g(Z.$$.fragment,s),g(X.$$.fragment,s),g(I.$$.fragment,s),g(C.$$.fragment,s),g(F.$$.fragment,s),g(q.$$.fragment,s),g(L.$$.fragment,s),g(Y.$$.fragment,s),g(D.$$.fragment,s),g(j.$$.fragment,s),bs=!1},d(s){s&&(a(w),a(u),a(S),a(Q),a(x),a(A),a($),a(K),a(O),a(M),a(ss),a(T),a(ts),a(as),a(J),a(es),a(ns),a(ls),a(k),a(is),a(ps),a(G),a(os),a(rs),a(U),a(ds),a(cs),a(hs),a(z),a(gs),a(W),a(ms),a(fs),a(H),a(us),a(js),a(ys),a(B),a(ws),a(P),a(_s),a(xs),a($s),a(N)),a(i),m(_,s),m(b,s),m(v,s),m(R,s),m(Z,s),m(X,s),m(I,s),m(C,s),m(F,s),m(q,s),m(L,s),m(Y,s),m(D,s),m(j,s)}}}const Qs='{"title":"Load a dataset from the Hub","local":"load-a-dataset-from-the-hub","sections":[{"title":"Load a dataset","local":"load-a-dataset","sections":[],"depth":2},{"title":"Splits","local":"splits","sections":[],"depth":2},{"title":"Configurations","local":"configurations","sections":[],"depth":2},{"title":"Remote code","local":"remote-code","sections":[],"depth":2}],"depth":1}';function As(E){return Ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class et extends Bs{constructor(i){super(),Ps(this,i,As,Es,Hs,{})}}export{et as component};
