import{s as as,n as es,o as ls}from"../chunks/scheduler.bdbef820.js";import{S as ns,i as is,g as p,s as l,r as b,A as ps,h as o,f as a,c as n,j as O,u as T,x as J,k as ss,y as os,a as e,v as U,d as $,t as k,w as I}from"../chunks/index.c0aea24a.js";import{C as ts}from"../chunks/CodeBlock.6ccca92e.js";import{H as E}from"../chunks/Heading.2eb892cb.js";function rs(P){let i,v,C,B,r,Z,m,x,c,H='<a href="https://arrow.apache.org/" rel="nofollow">Arrow</a> enables large amounts of data to be processed and moved quickly. It is a specific data format that stores data in a columnar memory layout. This provides several significant advantages:',A,u,V='<li>Arrow’s standard format allows <a href="https://en.wikipedia.org/wiki/Zero-copy" rel="nofollow">zero-copy reads</a> which removes virtually all serialization overhead.</li> <li>Arrow is language-agnostic so it supports different programming languages.</li> <li>Arrow is column-oriented so it is faster at querying and processing slices or columns of data.</li> <li>Arrow allows for copy-free hand-offs to standard machine learning tools such as NumPy, Pandas, PyTorch, and TensorFlow.</li> <li>Arrow supports many, possibly nested, column types.</li>',W,h,R,d,Y=`🤗 Datasets uses Arrow for its local caching system. It allows datasets to be backed by an on-disk cache, which is memory-mapped for fast lookup.
This architecture allows for large datasets to be used on machines with relatively small device memory.`,F,f,K="For example, loading the full English Wikipedia dataset only takes a few MB of RAM:",X,w,z,M,L=`This is possible because the Arrow data is actually memory-mapped from disk, and not loaded in memory.
Memory-mapping allows access to data on disk, and leverages virtual memory capabilities for fast lookups.`,Q,y,q,g,D="Iterating over a memory-mapped dataset using Arrow is fast. Iterating over Wikipedia on a laptop gives you speeds of 1-3 Gbit/s:",G,j,S,_,N;return r=new E({props:{title:"Datasets 🤝 Arrow",local:"datasets--arrow",headingTag:"h1"}}),m=new E({props:{title:"What is Arrow?",local:"what-is-arrow",headingTag:"h2"}}),h=new E({props:{title:"Memory-mapping",local:"memory-mapping",headingTag:"h2"}}),w=new ts({props:{code:"aW1wb3J0JTIwb3MlM0IlMjBpbXBvcnQlMjBwc3V0aWwlM0IlMjBpbXBvcnQlMjB0aW1laXQlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFtZW1fYmVmb3JlJTIwJTNEJTIwcHN1dGlsLlByb2Nlc3Mob3MuZ2V0cGlkKCkpLm1lbW9yeV9pbmZvKCkucnNzJTIwJTJGJTIwKDEwMjQlMjAqJTIwMTAyNCklMEF3aWtpJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMndpa2lwZWRpYSUyMiUyQyUyMCUyMjIwMjIwMzAxLmVuJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFtZW1fYWZ0ZXIlMjAlM0QlMjBwc3V0aWwuUHJvY2Vzcyhvcy5nZXRwaWQoKSkubWVtb3J5X2luZm8oKS5yc3MlMjAlMkYlMjAoMTAyNCUyMColMjAxMDI0KSUwQSUwQXByaW50KGYlMjJSQU0lMjBtZW1vcnklMjB1c2VkJTNBJTIwJTdCKG1lbV9hZnRlciUyMC0lMjBtZW1fYmVmb3JlKSU3RCUyME1CJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> os; <span class="hljs-keyword">import</span> psutil; <span class="hljs-keyword">import</span> timeit
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-comment"># Process.memory_info is expressed in bytes, so convert to megabytes </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>mem_before = psutil.Process(os.getpid()).memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>wiki = load_dataset(<span class="hljs-string">&quot;wikipedia&quot;</span>, <span class="hljs-string">&quot;20220301.en&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mem_after = psutil.Process(os.getpid()).memory_info().rss / (<span class="hljs-number">1024</span> * <span class="hljs-number">1024</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;RAM memory used: <span class="hljs-subst">{(mem_after - mem_before)}</span> MB&quot;</span>)
RAM memory used: <span class="hljs-number">50</span> MB`,wrap:!1}}),y=new E({props:{title:"Performance",local:"performance",headingTag:"h2"}}),j=new ts({props:{code:"cyUyMCUzRCUyMCUyMiUyMiUyMmJhdGNoX3NpemUlMjAlM0QlMjAxMDAwJTBBZm9yJTIwYmF0Y2glMjBpbiUyMHdpa2kuaXRlcihiYXRjaF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMC4uLiUwQSUyMiUyMiUyMiUwQSUwQWVsYXBzZWRfdGltZSUyMCUzRCUyMHRpbWVpdC50aW1laXQoc3RtdCUzRHMlMkMlMjBudW1iZXIlM0QxJTJDJTIwZ2xvYmFscyUzRGdsb2JhbHMoKSklMEFwcmludChmJTIyVGltZSUyMHRvJTIwaXRlcmF0ZSUyMG92ZXIlMjB0aGUlMjAlN0J3aWtpLmRhdGFzZXRfc2l6ZSUyMCUzRSUzRSUyMDMwJTdEJTIwR0IlMjBkYXRhc2V0JTNBJTIwJTdCZWxhcHNlZF90aW1lJTNBLjFmJTdEJTIwc2VjJTJDJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwZiUyMmllLiUyMCU3QmZsb2F0KHdpa2kuZGF0YXNldF9zaXplJTIwJTNFJTNFJTIwMjcpJTJGZWxhcHNlZF90aW1lJTNBLjFmJTdEJTIwR2IlMkZzJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>s = <span class="hljs-string">&quot;&quot;&quot;batch_size = 1000
<span class="hljs-meta">... </span>for batch in wiki.iter(batch_size):
<span class="hljs-meta">... </span>    ...
<span class="hljs-meta">... </span>&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = timeit.timeit(stmt=s, number=<span class="hljs-number">1</span>, <span class="hljs-built_in">globals</span>=<span class="hljs-built_in">globals</span>())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time to iterate over the <span class="hljs-subst">{wiki.dataset_size &gt;&gt; <span class="hljs-number">30</span>}</span> GB dataset: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.1</span>f}</span> sec, &quot;</span>
<span class="hljs-meta">... </span>      <span class="hljs-string">f&quot;ie. <span class="hljs-subst">{<span class="hljs-built_in">float</span>(wiki.dataset_size &gt;&gt; <span class="hljs-number">27</span>)/elapsed_time:<span class="hljs-number">.1</span>f}</span> Gb/s&quot;</span>)
Time to iterate over the <span class="hljs-number">18</span> GB dataset: <span class="hljs-number">31.8</span> sec, ie. <span class="hljs-number">4.8</span> Gb/s`,wrap:!1}}),{c(){i=p("meta"),v=l(),C=p("p"),B=l(),b(r.$$.fragment),Z=l(),b(m.$$.fragment),x=l(),c=p("p"),c.innerHTML=H,A=l(),u=p("ul"),u.innerHTML=V,W=l(),b(h.$$.fragment),R=l(),d=p("p"),d.textContent=Y,F=l(),f=p("p"),f.textContent=K,X=l(),b(w.$$.fragment),z=l(),M=p("p"),M.textContent=L,Q=l(),b(y.$$.fragment),q=l(),g=p("p"),g.textContent=D,G=l(),b(j.$$.fragment),S=l(),_=p("p"),this.h()},l(s){const t=ps("svelte-u9bgzb",document.head);i=o(t,"META",{name:!0,content:!0}),t.forEach(a),v=n(s),C=o(s,"P",{}),O(C).forEach(a),B=n(s),T(r.$$.fragment,s),Z=n(s),T(m.$$.fragment,s),x=n(s),c=o(s,"P",{"data-svelte-h":!0}),J(c)!=="svelte-52goft"&&(c.innerHTML=H),A=n(s),u=o(s,"UL",{"data-svelte-h":!0}),J(u)!=="svelte-6kbcii"&&(u.innerHTML=V),W=n(s),T(h.$$.fragment,s),R=n(s),d=o(s,"P",{"data-svelte-h":!0}),J(d)!=="svelte-xad2nu"&&(d.textContent=Y),F=n(s),f=o(s,"P",{"data-svelte-h":!0}),J(f)!=="svelte-k9gzax"&&(f.textContent=K),X=n(s),T(w.$$.fragment,s),z=n(s),M=o(s,"P",{"data-svelte-h":!0}),J(M)!=="svelte-kx9jy5"&&(M.textContent=L),Q=n(s),T(y.$$.fragment,s),q=n(s),g=o(s,"P",{"data-svelte-h":!0}),J(g)!=="svelte-1telpcz"&&(g.textContent=D),G=n(s),T(j.$$.fragment,s),S=n(s),_=o(s,"P",{}),O(_).forEach(a),this.h()},h(){ss(i,"name","hf:doc:metadata"),ss(i,"content",ms)},m(s,t){os(document.head,i),e(s,v,t),e(s,C,t),e(s,B,t),U(r,s,t),e(s,Z,t),U(m,s,t),e(s,x,t),e(s,c,t),e(s,A,t),e(s,u,t),e(s,W,t),U(h,s,t),e(s,R,t),e(s,d,t),e(s,F,t),e(s,f,t),e(s,X,t),U(w,s,t),e(s,z,t),e(s,M,t),e(s,Q,t),U(y,s,t),e(s,q,t),e(s,g,t),e(s,G,t),U(j,s,t),e(s,S,t),e(s,_,t),N=!0},p:es,i(s){N||($(r.$$.fragment,s),$(m.$$.fragment,s),$(h.$$.fragment,s),$(w.$$.fragment,s),$(y.$$.fragment,s),$(j.$$.fragment,s),N=!0)},o(s){k(r.$$.fragment,s),k(m.$$.fragment,s),k(h.$$.fragment,s),k(w.$$.fragment,s),k(y.$$.fragment,s),k(j.$$.fragment,s),N=!1},d(s){s&&(a(v),a(C),a(B),a(Z),a(x),a(c),a(A),a(u),a(W),a(R),a(d),a(F),a(f),a(X),a(z),a(M),a(Q),a(q),a(g),a(G),a(S),a(_)),a(i),I(r,s),I(m,s),I(h,s),I(w,s),I(y,s),I(j,s)}}}const ms='{"title":"Datasets 🤝 Arrow","local":"datasets--arrow","sections":[{"title":"What is Arrow?","local":"what-is-arrow","sections":[],"depth":2},{"title":"Memory-mapping","local":"memory-mapping","sections":[],"depth":2},{"title":"Performance","local":"performance","sections":[],"depth":2}],"depth":1}';function cs(P){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ws extends ns{constructor(i){super(),is(this,i,cs,rs,as,{})}}export{ws as component};
