import{s as at,o as ct,n as ut}from"../chunks/scheduler.182ea377.js";import{S as pt,i as mt,g as i,s as r,r as m,A as ft,h as d,f as s,c as o,j as M,u as f,x as p,k as D,y as t,a as u,v as h,d as g,t as _,w as v}from"../chunks/index.abf12888.js";import{T as ht}from"../chunks/Tip.230e2334.js";import{D as b}from"../chunks/Docstring.93f6f462.js";import{H as Je}from"../chunks/Heading.16916d63.js";function gt(ce){let c,O=`The algorithm and model type are decoupled. You can use either DPMSolver or DPMSolver++ for both noise
prediction and data prediction models.`;return{c(){c=i("p"),c.textContent=O},l(S){c=d(S,"P",{"data-svelte-h":!0}),p(c)!=="svelte-95n5s"&&(c.textContent=O)},m(S,Y){u(S,c,Y)},p:ut,d(S){S&&s(c)}}}function _t(ce){let c,O,S,Y,I,ue,H,Ye='<code>EDMDPMSolverMultistepScheduler</code> is a <a href="https://huggingface.co/papers/2206.00364" rel="nofollow">Karras formulation</a> of <code>DPMSolverMultistep</code>, a multistep scheduler from <a href="https://huggingface.co/papers/2206.00927" rel="nofollow">DPM-Solver: A Fast ODE Solver for Diffusion Probabilistic Model Sampling in Around 10 Steps</a> and <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPM-Solver++: Fast Solver for Guided Sampling of Diffusion Probabilistic Models</a> by Cheng Lu, Yuhao Zhou, Fan Bao, Jianfei Chen, Chongxuan Li, and Jun Zhu.',pe,V,Ze=`DPMSolver (and the improved version DPMSolver++) is a fast dedicated high-order solver for diffusion ODEs with convergence order guarantee. Empirically, DPMSolver sampling with only 20 steps can generate high-quality
samples, and it can generate quite good samples even in 10 steps.`,me,q,fe,n,A,ye,Z,Re=`Implements DPMSolverMultistepScheduler in EDM formulation as presented in Karras et al. 2022 [1].
<code>EDMDPMSolverMultistepScheduler</code> is a fast dedicated high-order solver for diffusion ODEs.`,Ee,R,Qe=`[1] Karras, Tero, et al. “Elucidating the Design Space of Diffusion-Based Generative Models.”
<a href="https://arxiv.org/abs/2206.00364" rel="nofollow">https://arxiv.org/abs/2206.00364</a>`,we,Q,Xe=`This model inherits from <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a> and <a href="/docs/diffusers/main/en/api/configuration#diffusers.ConfigMixin">ConfigMixin</a>. Check the superclass documentation for the generic
methods the library implements for all schedulers such as loading and saving.`,Ce,x,z,Fe,X,et=`Convert the model output to the corresponding type the DPMSolver/DPMSolver++ algorithm needs. DPM-Solver is
designed to discretize an integral of the noise prediction model, and DPM-Solver++ is designed to discretize an
integral of the data prediction model.`,Le,P,Oe,T,N,Ie,ee,tt="One step for the first-order DPMSolver (equivalent to DDIM).",He,y,k,Ve,te,rt="One step for the second-order multistep DPMSolver.",qe,E,j,Ae,re,ot="One step for the third-order multistep DPMSolver.",ze,w,W,Ne,oe,st=`Ensures interchangeability with schedulers that need to scale the denoising model input depending on the
current timestep. Scales the denoising model input by <code>(sigma**2 + 1) ** 0.5</code> to match the Euler algorithm.`,ke,C,B,je,se,nt="Sets the begin index for the scheduler. This function should be run from pipeline before the inference.",We,F,G,Be,ne,it="Sets the discrete timesteps used for the diffusion chain (to be run before inference).",Ge,L,K,Ke,ie,dt=`Predict the sample from the previous timestep by reversing the SDE. This function propagates the sample with
the multistep DPMSolver.`,he,U,ge,$,J,Ue,de,lt="Base class for the output of a scheduler’s <code>step</code> function.",_e,ae,ve;return I=new Je({props:{title:"EDMDPMSolverMultistepScheduler",local:"edmdpmsolvermultistepscheduler",headingTag:"h1"}}),q=new Je({props:{title:"EDMDPMSolverMultistepScheduler",local:"diffusers.EDMDPMSolverMultistepScheduler",headingTag:"h2"}}),A=new b({props:{name:"class diffusers.EDMDPMSolverMultistepScheduler",anchor:"diffusers.EDMDPMSolverMultistepScheduler",parameters:[{name:"sigma_min",val:": float = 0.002"},{name:"sigma_max",val:": float = 80.0"},{name:"sigma_data",val:": float = 0.5"},{name:"num_train_timesteps",val:": int = 1000"},{name:"prediction_type",val:": str = 'epsilon'"},{name:"rho",val:": float = 7.0"},{name:"solver_order",val:": int = 2"},{name:"thresholding",val:": bool = False"},{name:"dynamic_thresholding_ratio",val:": float = 0.995"},{name:"sample_max_value",val:": float = 1.0"},{name:"algorithm_type",val:": str = 'dpmsolver++'"},{name:"solver_type",val:": str = 'midpoint'"},{name:"lower_order_final",val:": bool = True"},{name:"euler_at_final",val:": bool = False"},{name:"final_sigmas_type",val:": Optional = 'zero'"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.sigma_min",description:`<strong>sigma_min</strong> (<code>float</code>, <em>optional</em>, defaults to 0.002) &#x2014;
Minimum noise magnitude in the sigma schedule. This was set to 0.002 in the EDM paper [1]; a reasonable
range is [0, 10].`,name:"sigma_min"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.sigma_max",description:`<strong>sigma_max</strong> (<code>float</code>, <em>optional</em>, defaults to 80.0) &#x2014;
Maximum noise magnitude in the sigma schedule. This was set to 80.0 in the EDM paper [1]; a reasonable
range is [0.2, 80.0].`,name:"sigma_max"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.sigma_data",description:`<strong>sigma_data</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The standard deviation of the data distribution. This is set to 0.5 in the EDM paper [1].`,name:"sigma_data"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.num_train_timesteps",description:`<strong>num_train_timesteps</strong> (<code>int</code>, defaults to 1000) &#x2014;
The number of diffusion steps to train the model.`,name:"num_train_timesteps"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.solver_order",description:`<strong>solver_order</strong> (<code>int</code>, defaults to 2) &#x2014;
The DPMSolver order which can be <code>1</code> or <code>2</code> or <code>3</code>. It is recommended to use <code>solver_order=2</code> for guided
sampling, and <code>solver_order=3</code> for unconditional sampling.`,name:"solver_order"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.prediction_type",description:`<strong>prediction_type</strong> (<code>str</code>, defaults to <code>epsilon</code>, <em>optional</em>) &#x2014;
Prediction type of the scheduler function; can be <code>epsilon</code> (predicts the noise of the diffusion process),
<code>sample</code> (directly predicts the noisy sample<code>) or </code>v_prediction\` (see section 2.4 of <a href="https://imagen.research.google/video/paper.pdf" rel="nofollow">Imagen
Video</a> paper).`,name:"prediction_type"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.thresholding",description:`<strong>thresholding</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use the &#x201C;dynamic thresholding&#x201D; method. This is unsuitable for latent-space diffusion models such
as Stable Diffusion.`,name:"thresholding"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.dynamic_thresholding_ratio",description:`<strong>dynamic_thresholding_ratio</strong> (<code>float</code>, defaults to 0.995) &#x2014;
The ratio for the dynamic thresholding method. Valid only when <code>thresholding=True</code>.`,name:"dynamic_thresholding_ratio"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.sample_max_value",description:`<strong>sample_max_value</strong> (<code>float</code>, defaults to 1.0) &#x2014;
The threshold value for dynamic thresholding. Valid only when <code>thresholding=True</code> and
<code>algorithm_type=&quot;dpmsolver++&quot;</code>.`,name:"sample_max_value"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.algorithm_type",description:`<strong>algorithm_type</strong> (<code>str</code>, defaults to <code>dpmsolver++</code>) &#x2014;
Algorithm type for the solver; can be <code>dpmsolver++</code> or <code>sde-dpmsolver++</code>. The <code>dpmsolver++</code> type implements
the algorithms in the <a href="https://huggingface.co/papers/2211.01095" rel="nofollow">DPMSolver++</a> paper. It is recommended to
use <code>dpmsolver++</code> or <code>sde-dpmsolver++</code> with <code>solver_order=2</code> for guided sampling like in Stable Diffusion.`,name:"algorithm_type"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.solver_type",description:`<strong>solver_type</strong> (<code>str</code>, defaults to <code>midpoint</code>) &#x2014;
Solver type for the second-order solver; can be <code>midpoint</code> or <code>heun</code>. The solver type slightly affects the
sample quality, especially for a small number of steps. It is recommended to use <code>midpoint</code> solvers.`,name:"solver_type"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.lower_order_final",description:`<strong>lower_order_final</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to use lower-order solvers in the final steps. Only valid for &lt; 15 inference steps. This can
stabilize the sampling of DPMSolver for steps &lt; 15, especially for steps &lt;= 10.`,name:"lower_order_final"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.euler_at_final",description:`<strong>euler_at_final</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to use Euler&#x2019;s method in the final step. It is a trade-off between numerical stability and detail
richness. This can stabilize the sampling of the SDE variant of DPMSolver for small number of inference
steps, but sometimes may result in blurring.`,name:"euler_at_final"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.final_sigmas_type",description:`<strong>final_sigmas_type</strong> (<code>str</code>, defaults to <code>&quot;zero&quot;</code>) &#x2014;
The final <code>sigma</code> value for the noise schedule during the sampling process. If <code>&quot;sigma_min&quot;</code>, the final
sigma is the same as the last sigma in the training schedule. If <code>zero</code>, the final sigma is set to 0.`,name:"final_sigmas_type"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L27"}}),z=new b({props:{name:"convert_model_output",anchor:"diffusers.EDMDPMSolverMultistepScheduler.convert_model_output",parameters:[{name:"model_output",val:": FloatTensor"},{name:"sample",val:": FloatTensor = None"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.convert_model_output.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.convert_model_output.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L342",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The converted model output.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),P=new ht({props:{$$slots:{default:[gt]},$$scope:{ctx:ce}}}),N=new b({props:{name:"dpm_solver_first_order_update",anchor:"diffusers.EDMDPMSolverMultistepScheduler.dpm_solver_first_order_update",parameters:[{name:"model_output",val:": FloatTensor"},{name:"sample",val:": FloatTensor = None"},{name:"noise",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.dpm_solver_first_order_update.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from the learned diffusion model.`,name:"model_output"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.dpm_solver_first_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L377",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),k=new b({props:{name:"multistep_dpm_solver_second_order_update",anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update",parameters:[{name:"model_output_list",val:": List"},{name:"sample",val:": FloatTensor = None"},{name:"noise",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_second_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L415",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),j=new b({props:{name:"multistep_dpm_solver_third_order_update",anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update",parameters:[{name:"model_output_list",val:": List"},{name:"sample",val:": FloatTensor = None"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.model_output_list",description:`<strong>model_output_list</strong> (<code>List[torch.FloatTensor]</code>) &#x2014;
The direct outputs from learned diffusion model at current and latter timesteps.`,name:"model_output_list"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.multistep_dpm_solver_third_order_update.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by diffusion process.`,name:"sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L486",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sample tensor at the previous timestep.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),W=new b({props:{name:"scale_model_input",anchor:"diffusers.EDMDPMSolverMultistepScheduler.scale_model_input",parameters:[{name:"sample",val:": FloatTensor"},{name:"timestep",val:": Union"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.scale_model_input.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
The input sample.`,name:"sample"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.scale_model_input.timestep",description:`<strong>timestep</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The current timestep in the diffusion chain.`,name:"timestep"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L199",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A scaled input sample.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code></p>
`}}),B=new b({props:{name:"set_begin_index",anchor:"diffusers.EDMDPMSolverMultistepScheduler.set_begin_index",parameters:[{name:"begin_index",val:": int = 0"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.set_begin_index.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
The begin index for the scheduler.`,name:"begin_index"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L157"}}),G=new b({props:{name:"set_timesteps",anchor:"diffusers.EDMDPMSolverMultistepScheduler.set_timesteps",parameters:[{name:"num_inference_steps",val:": int = None"},{name:"device",val:": Union = None"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.set_timesteps.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>) &#x2014;
The number of diffusion steps used when generating samples with a pre-trained model.`,name:"num_inference_steps"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.set_timesteps.device",description:`<strong>device</strong> (<code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device to which the timesteps should be moved to. If <code>None</code>, the timesteps are not moved.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L225"}}),K=new b({props:{name:"step",anchor:"diffusers.EDMDPMSolverMultistepScheduler.step",parameters:[{name:"model_output",val:": FloatTensor"},{name:"timestep",val:": int"},{name:"sample",val:": FloatTensor"},{name:"generator",val:" = None"},{name:"return_dict",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.EDMDPMSolverMultistepScheduler.step.model_output",description:`<strong>model_output</strong> (<code>torch.FloatTensor</code>) &#x2014;
The direct output from learned diffusion model.`,name:"model_output"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.step.timestep",description:`<strong>timestep</strong> (<code>int</code>) &#x2014;
The current discrete timestep in the diffusion chain.`,name:"timestep"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.step.sample",description:`<strong>sample</strong> (<code>torch.FloatTensor</code>) &#x2014;
A current instance of a sample created by the diffusion process.`,name:"sample"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.step.generator",description:`<strong>generator</strong> (<code>torch.Generator</code>, <em>optional</em>) &#x2014;
A random number generator.`,name:"generator"},{anchor:"diffusers.EDMDPMSolverMultistepScheduler.step.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput">SchedulerOutput</a> or <code>tuple</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_edm_dpmsolver_multistep.py#L573",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If return_dict is <code>True</code>, <a
  href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> is returned, otherwise a
tuple is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.schedulers.scheduling_utils.SchedulerOutput"
>SchedulerOutput</a> or <code>tuple</code></p>
`}}),U=new Je({props:{title:"SchedulerOutput",local:"diffusers.schedulers.scheduling_utils.SchedulerOutput",headingTag:"h2"}}),J=new b({props:{name:"class diffusers.schedulers.scheduling_utils.SchedulerOutput",anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput",parameters:[{name:"prev_sample",val:": FloatTensor"}],parametersDescription:[{anchor:"diffusers.schedulers.scheduling_utils.SchedulerOutput.prev_sample",description:`<strong>prev_sample</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code> for images) &#x2014;
Computed sample <code>(x_{t-1})</code> of previous timestep. <code>prev_sample</code> should be used as next model input in the
denoising loop.`,name:"prev_sample"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/schedulers/scheduling_utils.py#L51"}}),{c(){c=i("meta"),O=r(),S=i("p"),Y=r(),m(I.$$.fragment),ue=r(),H=i("p"),H.innerHTML=Ye,pe=r(),V=i("p"),V.textContent=Ze,me=r(),m(q.$$.fragment),fe=r(),n=i("div"),m(A.$$.fragment),ye=r(),Z=i("p"),Z.innerHTML=Re,Ee=r(),R=i("p"),R.innerHTML=Qe,we=r(),Q=i("p"),Q.innerHTML=Xe,Ce=r(),x=i("div"),m(z.$$.fragment),Fe=r(),X=i("p"),X.textContent=et,Le=r(),m(P.$$.fragment),Oe=r(),T=i("div"),m(N.$$.fragment),Ie=r(),ee=i("p"),ee.textContent=tt,He=r(),y=i("div"),m(k.$$.fragment),Ve=r(),te=i("p"),te.textContent=rt,qe=r(),E=i("div"),m(j.$$.fragment),Ae=r(),re=i("p"),re.textContent=ot,ze=r(),w=i("div"),m(W.$$.fragment),Ne=r(),oe=i("p"),oe.innerHTML=st,ke=r(),C=i("div"),m(B.$$.fragment),je=r(),se=i("p"),se.textContent=nt,We=r(),F=i("div"),m(G.$$.fragment),Be=r(),ne=i("p"),ne.textContent=it,Ge=r(),L=i("div"),m(K.$$.fragment),Ke=r(),ie=i("p"),ie.textContent=dt,he=r(),m(U.$$.fragment),ge=r(),$=i("div"),m(J.$$.fragment),Ue=r(),de=i("p"),de.innerHTML=lt,_e=r(),ae=i("p"),this.h()},l(e){const a=ft("svelte-u9bgzb",document.head);c=d(a,"META",{name:!0,content:!0}),a.forEach(s),O=o(e),S=d(e,"P",{}),M(S).forEach(s),Y=o(e),f(I.$$.fragment,e),ue=o(e),H=d(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-wn9m1y"&&(H.innerHTML=Ye),pe=o(e),V=d(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-l6rv24"&&(V.textContent=Ze),me=o(e),f(q.$$.fragment,e),fe=o(e),n=d(e,"DIV",{class:!0});var l=M(n);f(A.$$.fragment,l),ye=o(l),Z=d(l,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-5b1txv"&&(Z.innerHTML=Re),Ee=o(l),R=d(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-72xw7v"&&(R.innerHTML=Qe),we=o(l),Q=d(l,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-linuuh"&&(Q.innerHTML=Xe),Ce=o(l),x=d(l,"DIV",{class:!0});var le=M(x);f(z.$$.fragment,le),Fe=o(le),X=d(le,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1st02i8"&&(X.textContent=et),Le=o(le),f(P.$$.fragment,le),le.forEach(s),Oe=o(l),T=d(l,"DIV",{class:!0});var Me=M(T);f(N.$$.fragment,Me),Ie=o(Me),ee=d(Me,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-4nw43d"&&(ee.textContent=tt),Me.forEach(s),He=o(l),y=d(l,"DIV",{class:!0});var De=M(y);f(k.$$.fragment,De),Ve=o(De),te=d(De,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1d6o6zu"&&(te.textContent=rt),De.forEach(s),qe=o(l),E=d(l,"DIV",{class:!0});var Se=M(E);f(j.$$.fragment,Se),Ae=o(Se),re=d(Se,"P",{"data-svelte-h":!0}),p(re)!=="svelte-17nne8p"&&(re.textContent=ot),Se.forEach(s),ze=o(l),w=d(l,"DIV",{class:!0});var xe=M(w);f(W.$$.fragment,xe),Ne=o(xe),oe=d(xe,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1hew89w"&&(oe.innerHTML=st),xe.forEach(s),ke=o(l),C=d(l,"DIV",{class:!0});var be=M(C);f(B.$$.fragment,be),je=o(be),se=d(be,"P",{"data-svelte-h":!0}),p(se)!=="svelte-1k141rk"&&(se.textContent=nt),be.forEach(s),We=o(l),F=d(l,"DIV",{class:!0});var $e=M(F);f(G.$$.fragment,$e),Be=o($e),ne=d($e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1vzm9q"&&(ne.textContent=it),$e.forEach(s),Ge=o(l),L=d(l,"DIV",{class:!0});var Pe=M(L);f(K.$$.fragment,Pe),Ke=o(Pe),ie=d(Pe,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-7jbjgx"&&(ie.textContent=dt),Pe.forEach(s),l.forEach(s),he=o(e),f(U.$$.fragment,e),ge=o(e),$=d(e,"DIV",{class:!0});var Te=M($);f(J.$$.fragment,Te),Ue=o(Te),de=d(Te,"P",{"data-svelte-h":!0}),p(de)!=="svelte-6ojmkw"&&(de.innerHTML=lt),Te.forEach(s),_e=o(e),ae=d(e,"P",{}),M(ae).forEach(s),this.h()},h(){D(c,"name","hf:doc:metadata"),D(c,"content",vt),D(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(n,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){t(document.head,c),u(e,O,a),u(e,S,a),u(e,Y,a),h(I,e,a),u(e,ue,a),u(e,H,a),u(e,pe,a),u(e,V,a),u(e,me,a),h(q,e,a),u(e,fe,a),u(e,n,a),h(A,n,null),t(n,ye),t(n,Z),t(n,Ee),t(n,R),t(n,we),t(n,Q),t(n,Ce),t(n,x),h(z,x,null),t(x,Fe),t(x,X),t(x,Le),h(P,x,null),t(n,Oe),t(n,T),h(N,T,null),t(T,Ie),t(T,ee),t(n,He),t(n,y),h(k,y,null),t(y,Ve),t(y,te),t(n,qe),t(n,E),h(j,E,null),t(E,Ae),t(E,re),t(n,ze),t(n,w),h(W,w,null),t(w,Ne),t(w,oe),t(n,ke),t(n,C),h(B,C,null),t(C,je),t(C,se),t(n,We),t(n,F),h(G,F,null),t(F,Be),t(F,ne),t(n,Ge),t(n,L),h(K,L,null),t(L,Ke),t(L,ie),u(e,he,a),h(U,e,a),u(e,ge,a),u(e,$,a),h(J,$,null),t($,Ue),t($,de),u(e,_e,a),u(e,ae,a),ve=!0},p(e,[a]){const l={};a&2&&(l.$$scope={dirty:a,ctx:e}),P.$set(l)},i(e){ve||(g(I.$$.fragment,e),g(q.$$.fragment,e),g(A.$$.fragment,e),g(z.$$.fragment,e),g(P.$$.fragment,e),g(N.$$.fragment,e),g(k.$$.fragment,e),g(j.$$.fragment,e),g(W.$$.fragment,e),g(B.$$.fragment,e),g(G.$$.fragment,e),g(K.$$.fragment,e),g(U.$$.fragment,e),g(J.$$.fragment,e),ve=!0)},o(e){_(I.$$.fragment,e),_(q.$$.fragment,e),_(A.$$.fragment,e),_(z.$$.fragment,e),_(P.$$.fragment,e),_(N.$$.fragment,e),_(k.$$.fragment,e),_(j.$$.fragment,e),_(W.$$.fragment,e),_(B.$$.fragment,e),_(G.$$.fragment,e),_(K.$$.fragment,e),_(U.$$.fragment,e),_(J.$$.fragment,e),ve=!1},d(e){e&&(s(O),s(S),s(Y),s(ue),s(H),s(pe),s(V),s(me),s(fe),s(n),s(he),s(ge),s($),s(_e),s(ae)),s(c),v(I,e),v(q,e),v(A),v(z),v(P),v(N),v(k),v(j),v(W),v(B),v(G),v(K),v(U,e),v(J)}}}const vt='{"title":"EDMDPMSolverMultistepScheduler","local":"edmdpmsolvermultistepscheduler","sections":[{"title":"EDMDPMSolverMultistepScheduler","local":"diffusers.EDMDPMSolverMultistepScheduler","sections":[],"depth":2},{"title":"SchedulerOutput","local":"diffusers.schedulers.scheduling_utils.SchedulerOutput","sections":[],"depth":2}],"depth":1}';function Mt(ce){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends pt{constructor(c){super(),mt(this,c,Mt,_t,at,{})}}export{Pt as component};
